/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: PrefsDialog.cpp,v 1.25 2004/12/17 08:04:14 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "PrefsDialog.h"
#include "FWBSettings.h"
#include "listOfLibraries.h"
#include "FWWindow.h"
#include "ObjectManipulator.h"

#include <qlineedit.h>
#include <qfiledialog.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qdir.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qtooltip.h>
#include <qspinbox.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qcolordialog.h>
#include <qcolor.h>

/*

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#ifdef _WIN32
#  include <direct.h>
#  include <stdlib.h>
#  include <io.h>
#else
#  include <unistd.h>
#endif
*/

#include <iostream>

using namespace std;

void PrefsDialog::setButtonColor(QPushButton *btn,const QString &colorCode)
{
    QPixmap pm(40,14);
    pm.fill( QColor(colorCode) );
    QPainter p( &pm );
    p.drawRect( pm.rect() );
    btn->setPixmap(pm);
}

PrefsDialog::PrefsDialog(QWidget *parent) : prefsDialog_q(parent)
{
    wDir->setText( st->getWDir() );
    startupAction->setCurrentItem( st->getStartupAction() );
    expandTree->setChecked( st->getExpandTree() );
//    mergeLibs->setChecked( st->getMergeLibs() );

    objTooltips->setChecked( st->getObjTooltips() );
    tooltipDelay->setValue( st->getTooltipDelay() );

    deletedObj->setChecked( st->getBool("UI/ShowDeletedObjects") );

    emptyRCSLog->setChecked( st->getRCSLogState() );
    autosave->setChecked( st->getAutoSave() );

    autosaveFile->setChecked( st->getBool("Environment/autoSaveFile") );
    autosaveInterval->setValue( st->getInt("Environment/autoSaveFilePeriod"));

    dontSaveStdLib->setChecked( st->getDontSaveStdLib() );

    scpPath->setText( st->getSCPPath() );
    sshPath->setText( st->getSSHPath() );

    for (list<libData>::iterator i=addOnLibs->begin(); i!=addOnLibs->end(); ++i)
    {
        QListViewItem *itm = new QListViewItem( avLibs,
                                      QString::fromUtf8(i->name),
                                                "",
                                                i->path );
        if (i->load)
            itm->setPixmap(1, QPixmap::fromMimeSource( "apply.png" ) );
    }

// set label icons colors and text strings using user's settings

    QString t;
    colors[FWBSettings::RED]=st->getLabelColor(FWBSettings::RED);
    t=st->getLabelText (FWBSettings::RED);

    setButtonColor(redBtn,colors[FWBSettings::RED]);
    redText->setText(t);

    colors[FWBSettings::ORANGE]=st->getLabelColor(FWBSettings::ORANGE);
    t=st->getLabelText (FWBSettings::ORANGE);

    setButtonColor(orangeBtn,colors[FWBSettings::ORANGE]);
    orangeText->setText(t);

    colors[FWBSettings::YELLOW]=st->getLabelColor(FWBSettings::YELLOW);
    t=st->getLabelText (FWBSettings::YELLOW);

    setButtonColor(yellowBtn,colors[FWBSettings::YELLOW]);
    yellowText->setText(t);

    colors[FWBSettings::GREEN]=st->getLabelColor(FWBSettings::GREEN);
    t=st->getLabelText (FWBSettings::GREEN);

    setButtonColor(greenBtn,colors[FWBSettings::GREEN]);
    greenText->setText(t);

    colors[FWBSettings::BLUE]=st->getLabelColor(FWBSettings::BLUE);
    t=st->getLabelText (FWBSettings::BLUE);

    setButtonColor(blueBtn,colors[FWBSettings::BLUE]);
    blueText->setText(t);

    colors[FWBSettings::PURPLE]=st->getLabelColor(FWBSettings::PURPLE);
    t=st->getLabelText (FWBSettings::PURPLE);

    setButtonColor(purpleBtn,colors[FWBSettings::PURPLE]);
    purpleText->setText(t);

    colors[FWBSettings::GRAY]=st->getLabelColor(FWBSettings::GRAY);
    t=st->getLabelText (FWBSettings::GRAY);

    setButtonColor(grayBtn,colors[FWBSettings::GRAY]);
    grayText->setText(t);

}

void PrefsDialog::changeColor(QPushButton *btn,
                              FWBSettings::LabelColors colorCode)
{
    QColor clr = QColorDialog::getColor(
        QColor(colors[colorCode]), this, tr("Pick the color") );

    if (!clr.isValid()) return;
    colors[colorCode]= clr.name();
    setButtonColor(btn,colors[colorCode]);
}


void PrefsDialog::changeRedColor()
{
    changeColor(redBtn, FWBSettings::RED);
}

void PrefsDialog::changeOrangeColor()
{
    changeColor(orangeBtn, FWBSettings::ORANGE);
}

void PrefsDialog::changeYellowColor()
{
    changeColor(yellowBtn, FWBSettings::YELLOW);
}

void PrefsDialog::changeGreenColor()
{
    changeColor(greenBtn, FWBSettings::GREEN);
}

void PrefsDialog::changeBlueColor()
{
    changeColor(blueBtn, FWBSettings::BLUE);
}

void PrefsDialog::changePurpleColor()
{
    changeColor(purpleBtn, FWBSettings::PURPLE);
}

void PrefsDialog::changeGrayColor()
{
    changeColor(grayBtn, FWBSettings::GRAY);
}


void PrefsDialog::findWDir()
{
    QString wd = st->getWDir();
    QString dir = QFileDialog::getExistingDirectory(
        wd, this, 0, tr("Find working directory"), TRUE, TRUE );

    if (!dir.isEmpty()) wDir->setText(dir);
}

void PrefsDialog::findSCP()
{
    QString fp = QFileDialog::getOpenFileName(
        QString::null, QString::null, this,
        tr("Find Secure File Transfer utility") );

    if (!fp.isEmpty()) scpPath->setText(fp);
}

void PrefsDialog::findSSH()
{
    QString fp = QFileDialog::getOpenFileName(
        QString::null, QString::null, this,
        tr("Find Secure Shell utility") );

    if (!fp.isEmpty()) sshPath->setText(fp);
}

void PrefsDialog::libClick(QListViewItem* itm, const QPoint &p, int col)
{
    if (itm && col==1)
    {
        if (itm->text(0)=="Standard") return;

        for (list<libData>::iterator i=addOnLibs->begin();
             i!=addOnLibs->end(); ++i)
        {
            if (QString::fromUtf8(i->name) == itm->text(0))
            {
                if (i->load)  itm->setPixmap(1, NULL);
                else  itm->setPixmap(1, QPixmap::fromMimeSource( "apply.png" ) );

                i->load = !i->load;

                if (i->load)
                {
                    mw->loadLibrary( i->path.latin1() );
                    om->loadObjects();
                }
                break;
            }
        }
    }
}

void PrefsDialog::addLibrary()
{
    QString fp = QFileDialog::getOpenFileName(
        st->getWDir(),
        "Firewall Builder 2 files (*.fwl)",
        this, 0, tr("Find add-on library") );

    if (!fp.isEmpty())
    {
        list<libData>::iterator i = addOnLibs->add( fp.latin1(), true );
        if (i==addOnLibs->end())
        {
            if (fwbdebug)
                qDebug("PrefsDialog::addLibrary(): library addition failed");
            return;
        }
        QString libname = QString::fromUtf8(i->name);
        QListViewItem *itm = new QListViewItem( avLibs, libname, "", fp );
        itm->setPixmap(1, QPixmap::fromMimeSource( "apply.png" ) );

        mw->loadLibrary( i->path.latin1() );
        om->loadObjects();
    }
}

/* when user removes library from the list, the change gets in effect
 * next time they start the program. There is a warning in the dialog
 * that says so
 */
void PrefsDialog::remLibrary()
{
    QListViewItem *itm = avLibs->currentItem();
    if (itm==NULL) return;

    if (itm->text(0)=="Standard") return;

    for (list<libData>::iterator i=addOnLibs->begin(); i!=addOnLibs->end(); ++i)
    {
        if (QString::fromUtf8(i->name) == itm->text(0))
        {
            addOnLibs->erase(i);
            delete itm;
            break;
        }
    }
}

void PrefsDialog::accept()
{
    QString wd=wDir->text();

/* check if the default working directory does not exist yet */

    st->setWDir( wd );
    st->setStartupAction( startupAction->currentItem() );
    st->setExpandTree( expandTree->isChecked() );
//    st->setMergeLibs( mergeLibs->isChecked() );

    st->setObjTooltips( objTooltips->isChecked() );
    st->setTooltipDelay( tooltipDelay->value() );

    st->setBool("UI/ShowDeletedObjects", deletedObj->isChecked() );

    QToolTip::setWakeUpDelay( st->getTooltipDelay()*1000 );

    st->setRCSLogState( emptyRCSLog->isChecked() );
    st->setAutoSave( autosave->isChecked() );

    st->setBool("Environment/autoSaveFile", autosaveFile->isChecked() );
    st->setInt("Environment/autoSaveFilePeriod", autosaveInterval->value() );

    st->setDontSaveStdLib( dontSaveStdLib->isChecked() );

    st->setLabelColor(FWBSettings::RED,    colors[FWBSettings::RED]);
    st->setLabelColor(FWBSettings::ORANGE, colors[FWBSettings::ORANGE]);
    st->setLabelColor(FWBSettings::YELLOW, colors[FWBSettings::YELLOW]);
    st->setLabelColor(FWBSettings::GREEN,  colors[FWBSettings::GREEN]);
    st->setLabelColor(FWBSettings::BLUE,   colors[FWBSettings::BLUE]);
    st->setLabelColor(FWBSettings::PURPLE, colors[FWBSettings::PURPLE]);
    st->setLabelColor(FWBSettings::GRAY,   colors[FWBSettings::GRAY]);

    st->setLabelText (FWBSettings::RED,    redText->text() );
    st->setLabelText (FWBSettings::ORANGE, orangeText->text() );
    st->setLabelText (FWBSettings::YELLOW, yellowText->text() );
    st->setLabelText (FWBSettings::GREEN,  greenText->text() );
    st->setLabelText (FWBSettings::BLUE,   blueText->text() );
    st->setLabelText (FWBSettings::PURPLE, purpleText->text() );
    st->setLabelText (FWBSettings::GRAY,   grayText->text() );

    st->setSCPPath( scpPath->text() );
    st->setSSHPath( sshPath->text() );

    QDir d;
    d.mkdir( wd );

    mw->setupAutoSave();
    om->showDeletedObjects(st->getBool("UI/ShowDeletedObjects"));

    QDialog::accept();
}

