/* Copyright 1989-93 GROUPE BULL -- See license conditions in file COPYRIGHT**/
/*****************************************************************************\
*                                                                             *
* 			 support for lexical analysis                         *
*                                                                             *
\*****************************************************************************/
#include "klparser.h"
#include "kly.tab.h"

/*****************************************************************************\
* 			     KLONE's I/O package                              *
\*****************************************************************************/

/* 
 * Klyywrap
 */

Klyywrap(){		
    return 1;		/* tell flex there is nothing more to read */
}

/* to know input is complete to send to lex, we parse file by hand
 * give 0 for reset
 */

int
KlCountParentheses(s)
    char *s;
{
    int level = 0;
    int in_string = 0;

    if (!s)
	return 0;			/* for back-compat */

    for(;;){
	switch (*s) {
	case 0:
	    return (level > 0 ? level : 0); /* allow extra closing pars */
	case '\\':
	    s++;
	    break;
	case '"':			/* enter string */
	    if (in_string) {
		in_string = 0;
		level--;
	    } else {
		in_string = 1;
		level++;
	    }
	    break;
	case '(': case '{': case '[':
	    if (!in_string)
		level++;
	    break;
	case ')': case '}': case ']':
	    if (!in_string)
		level--;
	    break;
	case ';':			/* gobble comments */
	    if (!in_string) 
		while (*(++s) != '\n')
		    if (!(*s)) {		/* EOF */
			s--;
			break;
		    }
	    break;
	case 2:				/* binary string*/
	    {
		int length = 0;

		s++;
		while (*s != KlBT_STRING) {
		    length *= 10;
		    length += *s++ - '0';
		}
		s++;
		while (length--)
		    if (! *s++)
			KlError1s(KlE_SYNTAX_ERROR,
				"Syntax error in binary strings");
	    }
	    
	}
	s++;
    }
}

#ifndef KLONE
/*****************************************************************************\
* 				Binary parsing                                *
\*****************************************************************************/

/****************************************************************** OBSOLETE */
/* binary mode: 
 * first byte = type
 * can be 
 * (with KlBT_STRING = \x02)
 * KlBT_STRING length-as-ascii-number KlBT_STRING raw-string-chars
 */
#include "kl_string.h"

int
KlParseBinaryOld()
{
    int length, c;
    char *s, *end;

    switch (Klyy_input()) {
    case KlBT_STRING:
	{
	    KlString kls;

	    length = 0;
	    while ((c = Klyy_input()) != KlBT_STRING) {
		length *= 10;
		length += c - '0';
	    }
	    kls = KlStringNMake(length);
	    for (s = kls->string, end = s + length; s < end;) {
		*s++ = Klyy_input();
	    }
	    kls->string[length] = '\0';
	    KlReadExprBin = (KlO) kls;
	}
	break;
    default:				/* EOF or KlBT_BINSTREAMEND */
	return BADBINEXPR;
    }
    return BINEXPR;
}

#endif /* !KLONE */

#ifdef KLCRYPT
#include "kl_string.h"
#include "kl_stream.h"

/*****************************************************************************\
* 			   Parsing of crypted files                           *
\*****************************************************************************/
/* This is just a demo on how an actual crypting method could be implemented.
 * crypted input would begin by a Control-Underscore (0x1f) character,
 * and a function KlDecrypt(stream) would be called to read the rest of the
 * characters from the klone stream "stream", and return another klone stream
 * to read from the decoded output
 * 
 * The decoding function could decode into a string in memory and return 
 * a stream on it, or fork a process an return a pipe reading from the process
 * or open a connection to a decoding server and return a stream on the socket
 * 
 * to enable this feature, add on top of the flex file klparser.flex:
 * 
 * #define KLCRYPT
 * 
 * and, after the line:
 * [\001]          {Klyy_input();return(KlParseBinaryOld());}
 * 
 * insert the line:
 * [\037]          {KlParseCrypted();}
 */

extern KlStream KlDecrypt();

int
KlParseCrypted()
{
    KlStream decoded_stream = KlDecrypt(KlStdyy);
    KlStdyyRedirect(decoded_stream);
    return 0;
}

/* A sample ultra-simple decoding function: 
 * read all input into a string, decode by decrementing by one all the ascii
 * characters in  the stream
 */

KlStream
KlDecrypt(stream)
    KlStream stream;
{
    /* gobble up all stream in a string */
    KlString string = (KlString) KlCoerce(stream, KlStringType);
    
    /* then decode in place */
    char *p = string->string;

    while (*p) {
	if (*p > ' ')			/* do not decode control chars */
	    *(p++) -= 1;
	else
	    p++;
    }

    return (KlStream) KlCoerce(string, KlStreamType);
}

/* a sample input file:
)qsjou!#Ifmmp-!Xpsme"]o#*
*/
#endif /* KLCRYPT */
