/*
 * Copyright (c) 1983, 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * Modified to provide counterintelligence
 * by Doug Hughes - Auburn University
 * @(#)klaxon.c	1.5 01/29/00
 */

/* Mar 8 1999 - added LOG_DATA - untested */
/* Jul 16 1999 - added paranoia options for sprintf, added srcport logging */

/*
 * Modified Dec 5 - converted strcpy to strncpy as premptive measure against
 * possible future reverse DNS spoofing attacks leading to buffer overflows
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983, 1988 The Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)rshd.c	5.17.1.2 (Berkeley) 2/7/89";
#endif /* not lint */

/*
 * Remote shell server.  We're invoked by the rexecd(8C) function.
 */

#include	<sys/types.h>
#include	<sys/socket.h>
#include    <sys/param.h>
#include 	<sys/fcntl.h>
#include	<sys/termios.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<stdio.h>
#include	<varargs.h>
#include	<signal.h>
#include	<netdb.h>
#include	<syslog.h>
#include	<errno.h>
#include	<string.h>
extern int	errno;

/* globals */
int protoval, protovallen;

#ifdef LOG_DATA
#define USECS_PER_SEC 1000000
#define TIME_LIMIT 3
#define DATA_LIMIT 128

#include <ctype.h>
#include <strings.h>
#include <sys/time.h>

static void append_data();
static void timeval_normalize(struct timeval *tm);
static void timeval_sub(struct timeval *t1, struct timeval *t2, struct timeval *t3);
static int timeval_cmp(struct timeval *t1, struct timeval *t2);

char tbuf[1500], buf[BUFSIZ];
#endif LOG_DATA

int recvlen;


/*ARGSUSED*/
main(argc, argv)
int	argc;
char	**argv;		/* argv1 is the service name */
{
	int			addrlen;
	struct sockaddr_in	cli_addr, *cli_addrp;
#ifndef LOG_DATA
	char 		tbuf[1500];
#endif

	openlog("klaxon", LOG_PID | LOG_ODELAY, LOG_DAEMON);

	/*
	 * We assume we're invoked by inetd, so the socket that the connection
	 * is on, is open on descriptors 0, 1 and 2.
	 *
	 * First get the Internet address of the client process.
	 * This is required for all the authentication we perform.
	 */

	addrlen = sizeof(cli_addr);
	protovallen = sizeof(int);

	
	if (getsockopt(0, SOL_SOCKET, SO_TYPE, (char *)&protoval, &protovallen) <0){
		my_error("getting socket options: %d", errno);
		_exit(1);
	}

	switch(protoval) {
		case SOCK_STREAM:
			if (getpeername(0, (struct sockaddr *) &cli_addr, &addrlen) < 0) {
				my_error("getpeername: %d", errno);
				_exit(1);
			}
			break;
		case SOCK_DGRAM:
			if ((recvlen = recvfrom(0, (char *) &tbuf, sizeof(tbuf), 0, 
						(struct sockaddr *) &cli_addr, &addrlen)) < 0) {
				my_error("recvfrom UDP socket: %d", errno);
				_exit(1);
			}
			break;
		default:
			syslog(LOG_AUTH|LOG_NOTICE, "inetd connection using unknown protocol type, %d", protoval);
			_exit(1);
			break;
	}

#ifdef PREEMPTIVE_TIMEOUT
	signal(SIGALRM, _exit(0));
	alarm(3);
#endif

	doit(&cli_addr, argv[1]);

}

doit(cli_addrp, service)
struct sockaddr_in	*cli_addrp;	/* client's Internet address */
char *service;
{
	char			hostname[MAXHOSTNAMELEN];
	char			remotehost[2 * MAXHOSTNAMELEN + 1];
	char			machine[MAXHOSTNAMELEN];
	char			username[128];
	struct sockaddr_in myaddr;
	int				srcport;
	int				myaddrlen = sizeof(struct sockaddr_in);
	struct hostent		*hp;
#ifndef LOG_DATA
	char			buf[BUFSIZ];
#endif

	signal(SIGINT, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
	signal(SIGTERM, SIG_DFL);

	
#ifdef DEBUG
	{
		int t = open("/dev/tty", 2);
		if (t >= 0) {
			ioctl(t, TIOCNOTTY, (char *) 0);
			close(t);
		}
	}
#endif


	/*
	 * Verify that the client's address is an Internet address.
	 */

	if (cli_addrp->sin_family != AF_INET) {
		syslog(LOG_ERR, "malformed from address\n");
		_exit(1);
	}

	/*
	 * Get the "name" of the client from its Internet address.
	 * This is used for the authentication below.
	 */

	hp = gethostbyaddr((char *) &cli_addrp->sin_addr,
				sizeof(struct in_addr), cli_addrp->sin_family);

	if (hp) {
		/*
		 * If the name returned by gethostbyaddr() is in our domain,
		 * attempt to verify that we haven't been fooled by someone
		 * in a remote net.  Look up the name and check that this
		 * address corresponds to the name.
		 */

		if (local_domain(hp->h_name)) {
			strncpy(remotehost, hp->h_name, sizeof(remotehost) - 1);
			remotehost[sizeof(remotehost) - 1] = 0;
			if ( (hp = gethostbyname(remotehost)) == NULL) {
				syslog(LOG_INFO,
				    "Couldn't look up address for %s port %s",
				    		remotehost, service);
				my_error("Couldn't look up addr for your host");
				exit(1);
			}
	
			for ( ; ; hp->h_addr_list++) {
				if (memcmp(hp->h_addr_list[0],
			    		      (caddr_t) &cli_addrp->sin_addr,
			    		      sizeof(cli_addrp->sin_addr)) == 0)
					break;	/* equal, OK */

				if (hp->h_addr_list[0] == NULL) {
					syslog(LOG_NOTICE,
				  	  "Host addr %s not listed for host %s using port %s",
				    		inet_ntoa(cli_addrp->sin_addr),
				    		hp->h_name, service);
					my_error("Host address mismatch");
					exit(1);
				}
			}
		}
		strncpy(hostname, hp->h_name, sizeof(hostname));
	} else
		strncpy(hostname, inet_ntoa(cli_addrp->sin_addr), sizeof(hostname));


	srcport = cli_addrp->sin_port;
#	ifdef USE_IDENT
	getsockname(0, (struct sockaddr *) &myaddr, &myaddrlen);
	if (protoval == SOCK_STREAM) {
		rfc931(cli_addrp, &myaddr, &username);
		sprintf(buf, "ALERT: user %.24s@%.256s:%d accessing port %s", username, hostname, srcport, service);
	} else {
		sprintf(buf, "ALERT: host %.256s:%d accessing port %s", hostname, srcport, service);
	}
#else
	sprintf(buf, "ALERT: host %.256s:%d accessing port %s", hostname, srcport, service);
#endif
		
#ifdef LOG_DATA
	append_data();
#endif

	syslog(LOG_AUTH|LOG_NOTICE, buf);

	exit(0);
	return(0);	/* just to clean up lint */
}

/*
 * Send an error message back to the rcmd() client.
 * The first byte we send must be binary 1, followed by the ASCII
 * error message, followed by a newline.
 */

my_error(va_alist)
va_dcl
{
	va_list		args;
	char		*fmt, buff[BUFSIZ];

	va_start(args);
	fmt = va_arg(args, char *);
	vsprintf(buff, fmt, args);
	va_end(args);

	syslog(LOG_ERR, buff);	/* fd 2 = socket, from inetd */
}

/*
 * Check whether the specified host is in our local domain, as determined
 * by the part of the name following the first period, in its name and in ours.
 * If either name is unqualified (contains no period), assume that the host
 * is local, as it will be interpreted as such.
 */

int				/* return 1 if local domain, else return 0 */
local_domain(host)
char	*host;
{
	register char	*ptr1, *ptr2;
	char		localhost[MAXHOSTNAMELEN];

	if ( (ptr1 = strchr(host, '.')) == NULL)
		return(1);		/* no period in remote host name */

	gethostname(localhost, sizeof(localhost));
	if ( (ptr2 = strchr(localhost, '.')) == NULL)
		return(1);		/* no period in local host name */

	/*
	 * Both host names contain a period.  Now compare both names,
	 * starting with the first period in each name (i.e., the names
	 * of their respective domains).  If equal, then the remote domain
	 * equals the local domain, return 1.
	 */

	if (strcasecmp(ptr1, ptr2) == 0)	/* case insensitive compare */
		return(1);

	return(0);
}


#ifdef LOG_DATA
/*******************************************************************************
*
*   This code contributed by don@mars.dgrc.crc.ca
*   modified for paranoia by edelkind@phri.nyu.edu and doug@eng.auburn.edu
*
*   This code requires that your system has snprintf. If it doesn't, this
*   will not compile.
*
*	Reads upto DATA_LIMIT bytes from socket on stdin within TIME_LIMIT
*	seconds, format it into a string, and append it to the log message.
*
*******************************************************************************/

static void append_data()
{
	static char newbuf[1500], junk[16];
	static int i, j;
	static struct timeval current, end, timeleft;
	static fd_set rfdset;

/*
	Read upto DATA_LIMIT bytes from socket on stdin within TIME_LIMIT secs. 
*/

						/* init current and quit time */
	gettimeofday(&current, (struct timezone *)0);
	end = current;
	end.tv_sec += TIME_LIMIT;

	FD_ZERO(&rfdset);
	FD_SET(0, &rfdset);			/* select socket on stdin */

	while((recvlen < DATA_LIMIT) && (timeval_cmp(&current, &end) < 0))
	{
		register int nbytes, retval;

						/* calc select timeout */
		timeval_sub(&end, &current, &timeleft);
						/* wait for data */
		if((retval = select(1, &rfdset, 0, 0, &timeleft)) == 0)
			break;			/* timeout */
		else if(retval == -1)		/* error, interrupt, or OOB */
			;			/* try again */
		else if(FD_ISSET(0, &rfdset))	/* socket ready to read */
		{
			if((nbytes = recvfrom(0, newbuf, sizeof(newbuf),
			   0, 0, 0)) > 0)
			{
				if(recvlen + nbytes > DATA_LIMIT)
					nbytes = DATA_LIMIT - recvlen;

				bcopy(&newbuf[0], &tbuf[recvlen], nbytes);
				recvlen += nbytes;
			}
		}

		FD_SET(0, &rfdset);
		gettimeofday(&current, (struct timezone *)0);
	}

/*
	Format recieved data into a string.
*/

	if(recvlen > DATA_LIMIT)
		recvlen = DATA_LIMIT;

	/* make sure i is less than newbuf's declaration *
	 * normally it would be, but some people may set *
	 * DATA_LIMIT to some outrageous value.          */
	for(i = j = 0; i < recvlen && (i < sizeof(newbuf)); ++i)
	{
		if(isprint(tbuf[i]))
		{
			newbuf[j++] = tbuf[i];
			newbuf[j] = '\0';
		}
		else
		{
			snprintf(junk, sizeof(junk), "(%d)", tbuf[i]);
			strncat(newbuf, junk, sizeof(newbuf) - strlen(newbuf) - 1);
			j += strlen(junk);
		}
	}

/*
	Append the received data string to the connect string to be sysloged.
*/
	if(recvlen > 0)
	{
		strncat(buf, ". DATA=", sizeof(buf) - strlen(buf) - 1);
		strncat(buf, newbuf, sizeof(buf) - strlen(buf) - 1);
	}
}

/*******************************************************************************
*
*	Make sure a timeval struct has abs(tv_usec) < 1000000, and that the
*	tv_sec and tv_usec have the same sign.
*
*******************************************************************************/

static void timeval_normalize(struct timeval *tm)
{
    long add_secs;

	add_secs    = tm->tv_usec / USECS_PER_SEC;
	tm->tv_sec += add_secs;		/* should check for overflow here */
	tm->tv_usec = tm->tv_usec % USECS_PER_SEC;
	
	if((tm->tv_sec > 0) && (tm->tv_usec < 0))
	{
		tm->tv_sec -= 1;
		tm->tv_usec += USECS_PER_SEC;
	}
	else if((tm->tv_sec < 0) && (tm->tv_usec > 0))
	{
		tm->tv_sec += 1;
		tm->tv_usec -= USECS_PER_SEC;
	}
}

/************************************************************************
*
*	t3 = t1 - t2;
*	normalize(t3);
*
**********************************************************************/

static void timeval_sub(struct timeval *t1, struct timeval *t2, struct timeval *t3)
{
	t3->tv_sec = t1->tv_sec - t2->tv_sec;
	t3->tv_usec = t1->tv_usec - t2->tv_usec;
	timeval_normalize(t3);
}

/*********************************************************************
*
*	If t1 is greater-than/less-than/equal-to t2
*	Return value is positive/negative/zero
*
**********************************************************************/

static int timeval_cmp(struct timeval *t1, struct timeval *t2)
{
        timeval_normalize(t1);
        timeval_normalize(t2);

        if(t1->tv_sec != t2->tv_sec)
                return(t1->tv_sec - t2->tv_sec);
        else
                return(t1->tv_usec - t2->tv_usec);
}

#endif LOG_DATA


