/* $Id: dlg_prefs.cc,v 1.24 2002/04/27 14:43:42 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2002 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "eboard.h"
#include "dlg_prefs.h"
#include "global.h"

// 3700 widgets for the price of 3699. Only today at dlg_prefs.cc, the
// Widget Warehouse.

typedef void (*sigfunc)(int);

PreferencesDialog::PreferencesDialog() : ModalDialog("Preferences") {
  GtkWidget *v,*hs,*ok,*apply,*cancel,*bhb,*nb;

  // gui
  GtkWidget *uil,*uiv,*uih,*tfr,*tr[4],*tv,*uih3,*uih4,*uih5;
  GSList *tl;

  // -- fonts
  GtkWidget *fl, *fv, *ft, *fn[4], *fb[4], *frv;

  // -- ics
  GtkWidget *icv, *icl, *ict1, *icl1, *ifr1, *ifr2, *ifv1, *ifv2, *icl2, *icl3;

  // -- sound
  GtkWidget *sv,*sl,*zl,*zf,*zv,*zd,*zt,*ze,*zh;
  static char *zcaption[]={"Opponent Moved","Draw Offered","Private Tell",
			   "ICS Challenge","Time Running Out"};
  char **zp;

  // -- autosave
  GtkWidget *gv, *gl, *gll, *gh;

  // -- colors
  GtkWidget *tcl, *tcv, *tch, *tcv2, *tcdef;
  int i;
  char z[64];

  for(i=0;i< N_SOUND_EVENTS;i++)
    sndcopy[i]=global.sndevents[i];

  gtk_window_set_default_size(GTK_WINDOW(widget),450,300);

  v=gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(widget),v);

  nb=gtk_notebook_new();
  gtk_box_pack_start(GTK_BOX(v),nb,TRUE,TRUE,2);

  // user interface ===================================================================
  
  uil=gtk_label_new("Appearance");
  uiv=gtk_vbox_new(FALSE,2);  
  gtk_container_set_border_width(GTK_CONTAINER(uiv),6);
  tfr=gtk_frame_new("Tab Position");
  gtk_box_pack_start(GTK_BOX(uiv),tfr,FALSE,FALSE,4);
  gtk_frame_set_shadow_type(GTK_FRAME(tfr),GTK_SHADOW_ETCHED_IN);
  tv=gtk_vbox_new(FALSE,2);

  tr[0]=gtk_radio_button_new_with_label(0,"Right");
  tl=gtk_radio_button_group(GTK_RADIO_BUTTON(tr[0]));
  tr[1]=gtk_radio_button_new_with_label(tl,"Left");
  tl=gtk_radio_button_group(GTK_RADIO_BUTTON(tr[1]));
  tr[2]=gtk_radio_button_new_with_label(tl,"Top");
  tl=gtk_radio_button_group(GTK_RADIO_BUTTON(tr[2]));
  tr[3]=gtk_radio_button_new_with_label(tl,"Bottom");

  gtk_container_add(GTK_CONTAINER(tfr),tv);
  for(i=0;i<4;i++) {
    gtk_box_pack_start(GTK_BOX(tv),tr[i],FALSE,FALSE,2);
    gtk_widget_show(tr[i]);
    tabposb[i]=tr[i];
  }

  uih=gtk_hbox_new(FALSE,4);
  plainb=gtk_check_button_new_with_label("Use plain color squares");
  gtk_box_pack_start(GTK_BOX(uih),plainb,FALSE,FALSE,0); 

  lsq=new ColorButton("Light Squares...", global.LightSqColor);
  dsq=new ColorButton("Dark Squares...", global.DarkSqColor);

  gtk_box_pack_start(GTK_BOX(uih),lsq->widget,FALSE,FALSE,4); 
  gtk_box_pack_start(GTK_BOX(uih),dsq->widget,FALSE,FALSE,4); 

  gtk_box_pack_start(GTK_BOX(uiv),uih,FALSE,FALSE,4);
  gtk_widget_show(plainb);
  gtk_widget_show(uih);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(plainb), global.PlainSquares?1:0);

  uih3=gtk_hbox_new(FALSE,4);
  uih4=gtk_hbox_new(FALSE,4);
  uih5=gtk_hbox_new(FALSE,4);

  smoothb=gtk_check_button_new_with_label("Smoother animation (eats more CPU)");
  gtk_box_pack_start(GTK_BOX(uih5),smoothb,FALSE,FALSE,0);

  dhsb=gtk_check_button_new_with_label("Graphic representation of crazy/bughouse stock");
  gtk_box_pack_start(GTK_BOX(uih3),dhsb,FALSE,FALSE,0);

  aqbar=gtk_check_button_new_with_label("Show shortcut buttons below board");
  gtk_box_pack_start(GTK_BOX(uih4),aqbar,FALSE,FALSE,0);

  gtk_box_pack_start(GTK_BOX(uiv),uih5,FALSE,FALSE,4);
  gtk_box_pack_start(GTK_BOX(uiv),uih3,FALSE,FALSE,4);
  gtk_box_pack_start(GTK_BOX(uiv),uih4,FALSE,FALSE,4);

  gtk_widget_show(smoothb);
  gtk_widget_show(dhsb);
  gtk_widget_show(aqbar);
  gtk_widget_show(uih3);
  gtk_widget_show(uih4);
  gtk_widget_show(uih5);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(smoothb), global.SmootherAnimation?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dhsb), global.DrawHouseStock?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(aqbar), global.ShowQuickbar?1:0);

  gtk_widget_show(tv);
  gtk_widget_show(tfr);
  gtk_widget_show(uiv);
  gtk_widget_show(uil);
  gtk_notebook_append_page(GTK_NOTEBOOK(nb),uiv,uil);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tr[global.TabPos]), TRUE);

  // ics ===============================================================================
  icv=gtk_vbox_new(FALSE,4);
  icl=gtk_label_new("ICS");

  gtk_container_set_border_width(GTK_CONTAINER(icv),6);

  ifr1=gtk_frame_new("Seek Table");
  gtk_frame_set_shadow_type(GTK_FRAME(ifr1),GTK_SHADOW_ETCHED_IN);
  ifr2=gtk_frame_new("Channel Tells");
  gtk_frame_set_shadow_type(GTK_FRAME(ifr2),GTK_SHADOW_ETCHED_IN);

  ifv1=gtk_vbox_new(FALSE,2);
  ifv2=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(ifr1),ifv1);
  gtk_container_add(GTK_CONTAINER(ifr2),ifv2);

  showratb=gtk_check_button_new_with_label("Show rating next to player name");
  gtk_box_pack_start(GTK_BOX(icv),showratb,FALSE,FALSE,4);

  autologb=gtk_check_button_new_with_label("Run autofics.pl script after connecting to FICS");
  gtk_box_pack_start(GTK_BOX(icv),autologb,FALSE,FALSE,4);

  gtk_box_pack_start(GTK_BOX(icv),ifr1,FALSE,FALSE,4);

  sgb=gtk_check_button_new_with_label("Dynamic Seek Table");
  gtk_box_pack_start(GTK_BOX(ifv1),sgb,FALSE,FALSE,4);

  hsb=gtk_check_button_new_with_label("Inhibit seek lines on console when Seek Table is active");
  gtk_box_pack_start(GTK_BOX(ifv1),hsb,FALSE,FALSE,4);

  gtk_box_pack_start(GTK_BOX(icv),ifr2,FALSE,FALSE,4);

  chsb=gtk_check_button_new_with_label("Show channel tells in one pane per channel");
  gtk_box_pack_start(GTK_BOX(ifv2),chsb,FALSE,FALSE,4);

  coct=gtk_check_button_new_with_label("Show channel tells on console too (when above option is active)");
  gtk_box_pack_start(GTK_BOX(ifv2),coct,FALSE,FALSE,4);

  wget=gtk_check_button_new_with_label("Retrieve ICS Channel Lists from eboard.sf.net");
  gtk_box_pack_start(GTK_BOX(ifv2),wget,FALSE,FALSE,0);

  ict1=gtk_table_new(2,3,FALSE);

  icl1=gtk_label_new("Scrollback limit (0 = unlimited) :");
  sbacke=gtk_entry_new();
  sprintf(z,"%d",global.ScrollBack);
  gtk_entry_set_text(GTK_ENTRY(sbacke),z);

  gtk_table_attach_defaults(GTK_TABLE(ict1), icl1, 0,1, 0,1);
  gtk_table_attach_defaults(GTK_TABLE(ict1), sbacke, 1,2, 0,1);

  icl2=gtk_label_new("Warn when own clock is below: ");
  lowtime=gtk_entry_new();
  sprintf(z,"%d",global.LowTimeWarningLimit);
  gtk_entry_set_text(GTK_ENTRY(lowtime),z);
  icl3=gtk_label_new("seconds.");

  gtk_table_attach_defaults(GTK_TABLE(ict1), icl2, 0,1, 1,2);
  gtk_table_attach_defaults(GTK_TABLE(ict1), lowtime, 1,2, 1,2);
  gtk_table_attach_defaults(GTK_TABLE(ict1), icl3, 2,3, 1,2);

  gtk_box_pack_start(GTK_BOX(icv),ict1,FALSE,FALSE,4);

  gtk_widget_show(icl1);
  gtk_widget_show(sbacke);
  gtk_widget_show(icl2);
  gtk_widget_show(lowtime);
  gtk_widget_show(icl3);
  gtk_widget_show(ict1);

  gtk_widget_show(ifr1);
  gtk_widget_show(ifr2);
  gtk_widget_show(ifv1);
  gtk_widget_show(ifv2);

  gtk_widget_show(icl);
  gtk_widget_show(showratb);
  gtk_widget_show(autologb);
  gtk_widget_show(sgb);
  gtk_widget_show(chsb);
  gtk_widget_show(coct);
  gtk_widget_show(wget);
  gtk_widget_show(hsb);
  gtk_widget_show(icv);
  
  gtk_notebook_append_page(GTK_NOTEBOOK(nb),icv,icl);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(showratb), global.ShowRating?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(autologb), global.FicsAutoLogin?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sgb), global.IcsSeekGraph?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(hsb), global.HideSeeks?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chsb), global.SplitChannels?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(coct), global.ChannelsToConsoleToo?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wget), global.RetrieveChannelNames?1:0);

  // colors ========================================================================

  tcl=gtk_label_new("Colors");
  tcv=gtk_vbox_new(FALSE,0);
  tcv2=gtk_vbox_new(FALSE,4);
  tch=gtk_hbox_new(FALSE,4);
  gtk_container_set_border_width(GTK_CONTAINER(tch),6);
  
  textcb[0]=new ColorButton("Normal Text",global.Colors.TextDefault);
  textcb[1]=new ColorButton("Bright Text",global.Colors.TextBright);
  textcb[2]=new ColorButton("Private Tells",global.Colors.PrivateTell);
  textcb[3]=new ColorButton("News/Notifications",global.Colors.NewsNotify);
  textcb[4]=new ColorButton("Mamer and TDs",global.Colors.Mamer);
  textcb[5]=new ColorButton("Kibitzes/Whispers",global.Colors.KibitzWhisper);

  textcb[6]=new ColorButton("Shouts",global.Colors.Shouts);
  textcb[7]=new ColorButton("Seek Ads",global.Colors.Seeks);
  textcb[8]=new ColorButton("Channel Tells",global.Colors.ChannelTell);
  textcb[9]=new ColorButton("Chess Programs",global.Colors.Engine);
  textcb[10]=new ColorButton("Background",global.Colors.Background);

  for(i=0;i<11;i++)
    gtk_box_pack_start(GTK_BOX(tcv),textcb[i]->widget,TRUE,TRUE,0);

  preview=new TextPreview(widget->window,textcb[10]);
  preview->attach(textcb[0],"Statistics for GMFoo(GM)  On for: 1 hr, 16 mins");
  preview->attach(textcb[1],"You accept the challenge of Zoobie");
  preview->attach(textcb[2],"CleverBoy tells you: eboard is the best!");
  preview->attach(textcb[3],"Notification: SsehcEmong has departed.");
  preview->attach(textcb[4],":mamer TOURNEY INFO: blah blah blah");
  preview->attach(textcb[5],"Pulga(TM)(1492)[24] whispers: watch my pawns die");
  preview->attach(textcb[6],"blik(C) shouts: I am wasting my cpu here!");
  preview->attach(textcb[7],"GMFoo (2402) seeking 45 45 rated Standard");
  preview->attach(textcb[8],"mhill(85): yes, that's exactly what I mean.");
  preview->attach(textcb[9],"My move is: d7d5");

  gtk_box_pack_start(GTK_BOX(tch),tcv,FALSE,FALSE,4);
  gtk_box_pack_start(GTK_BOX(tch),tcv2,FALSE,FALSE,4);
  gtk_box_pack_start(GTK_BOX(tcv2),preview->widget,FALSE,FALSE,4);

  tcdef=gtk_button_new_with_label("Revert to Defaults");
  gtk_box_pack_start(GTK_BOX(tcv2),tcdef,FALSE,FALSE,4);

  gtk_widget_show(preview->widget);
  gtk_widget_show(tcdef);
  gtk_widget_show(tch);
  gtk_widget_show(tcv);
  gtk_widget_show(tcv2);
  gtk_widget_show(tcl);
  gtk_notebook_append_page(GTK_NOTEBOOK(nb),tch,tcl);

  gtk_signal_connect(GTK_OBJECT(tcdef),"clicked",
		     GTK_SIGNAL_FUNC(prefs_defcolor),(gpointer)this);

  // fonts ==============================================================================
  fl=gtk_label_new("Fonts");
  fv=gtk_vbox_new(FALSE,2);
  gtk_container_set_border_width(GTK_CONTAINER(fv),6);
  ft=gtk_table_new(12,2,FALSE);
  gtk_table_set_row_spacings(GTK_TABLE(ft),4);
  gtk_table_set_col_spacings(GTK_TABLE(ft),6);

  gtk_box_pack_start(GTK_BOX(fv),ft,FALSE,FALSE,2);
  
  fm[0]=new BoxedLabel("Clock Font");
  fn[0]=gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(fn[0]),global.ClockFont);
  fb[0]=gtk_button_new_with_label("Choose...");

  fm[1]=new BoxedLabel("Player/Color Name Font");
  fn[1]=gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(fn[1]),global.PlayerFont);
  fb[1]=gtk_button_new_with_label("Choose...");

  fm[2]=new BoxedLabel("Game Information Font");
  fn[2]=gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(fn[2]),global.InfoFont);
  fb[2]=gtk_button_new_with_label("Choose...");

  fm[3]=new BoxedLabel("Console Font");
  fn[3]=gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(fn[3]),global.ConsoleFont);
  fb[3]=gtk_button_new_with_label("Choose...");

  gtk_table_attach(GTK_TABLE(ft),fm[0]->widget,0,1,0,1,GTK_FILL,GTK_FILL,0,0);
  gtk_table_attach(GTK_TABLE(ft),fn[0],0,1,1,2,(GtkAttachOptions)(GTK_EXPAND|GTK_FILL),GTK_FILL,0,0);
  gtk_table_attach(GTK_TABLE(ft),fb[0],1,2,1,2,GTK_SHRINK,GTK_FILL,0,0);

  gtk_table_attach(GTK_TABLE(ft),fm[1]->widget,0,1,3,4,GTK_FILL,GTK_FILL,0,0);
  gtk_table_attach(GTK_TABLE(ft),fn[1],0,1,4,5,(GtkAttachOptions)(GTK_EXPAND|GTK_FILL),GTK_FILL,0,0);
  gtk_table_attach(GTK_TABLE(ft),fb[1],1,2,4,5,GTK_SHRINK,GTK_FILL,0,0);

  gtk_table_attach(GTK_TABLE(ft),fm[2]->widget,0,1,6,7,GTK_FILL,GTK_FILL,0,0);
  gtk_table_attach(GTK_TABLE(ft),fn[2],0,1,7,8,(GtkAttachOptions)(GTK_EXPAND|GTK_FILL),GTK_FILL,0,0);
  gtk_table_attach(GTK_TABLE(ft),fb[2],1,2,7,8,GTK_SHRINK,GTK_FILL,0,0);

  gtk_table_attach(GTK_TABLE(ft),fm[3]->widget,0,1,9,10,GTK_FILL,GTK_FILL,0,0);
  gtk_table_attach(GTK_TABLE(ft),fn[3],0,1,10,11,(GtkAttachOptions)(GTK_EXPAND|GTK_FILL),GTK_FILL,0,0);
  gtk_table_attach(GTK_TABLE(ft),fb[3],1,2,10,11,GTK_SHRINK,GTK_FILL,0,0);

  frv=gtk_button_new_with_label("Revert to defaults");
  gtk_table_attach(GTK_TABLE(ft),frv,0,2,11,12,GTK_SHRINK,GTK_FILL,0,16);
  gtk_widget_show(frv);

  for(i=0;i<4;i++) {
    fm[i]->show();
    gtk_widget_show(fn[i]);
    gtk_widget_show(fb[i]);
    efont[i]=fn[i];
  }
  gtk_widget_show(ft);
  gtk_widget_show(fv);
  gtk_widget_show(fl);
  gtk_notebook_append_page(GTK_NOTEBOOK(nb),fv,fl);

  gtk_signal_connect(GTK_OBJECT(frv),"clicked",
		     GTK_SIGNAL_FUNC(prefs_frevert),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(fb[0]),"clicked",
		     GTK_SIGNAL_FUNC(prefs_cfont1),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(fb[1]),"clicked",
		     GTK_SIGNAL_FUNC(prefs_cfont2),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(fb[2]),"clicked",
		     GTK_SIGNAL_FUNC(prefs_cfont3),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(fb[3]),"clicked",
		     GTK_SIGNAL_FUNC(prefs_cfont4),(gpointer)this);

  // sounds ==============================================================================

  sv=gtk_vbox_new(FALSE,4);
  gtk_container_set_border_width(GTK_CONTAINER(sv),6);
  sl=gtk_label_new("Sounds");

  zf=gtk_frame_new("Sound Events");
  gtk_frame_set_shadow_type(GTK_FRAME(zf),GTK_SHADOW_ETCHED_IN);

  zv=gtk_vbox_new(FALSE,4);
  gtk_container_set_border_width(GTK_CONTAINER(zv), 4);

  gtk_box_pack_start(GTK_BOX(sv),zf,TRUE,TRUE,2);
  gtk_container_add(GTK_CONTAINER(zf),zv);

  zl=gtk_clist_new(1);
  gtk_clist_column_titles_hide(GTK_CLIST(zl));
  gtk_box_pack_start(GTK_BOX(zv),zl,TRUE,TRUE,4);

  for(i=0;i<N_SOUND_EVENTS;i++) {
    zp=&(zcaption[i]);
    gtk_clist_append(GTK_CLIST(zl),(gchar **) zp);
  }

  zd=gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX(zv),zd,FALSE,TRUE,4);

  zh=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(zh), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(zh), 5);

  zt=gtk_button_new_with_label("Test");
  ze=gtk_button_new_with_label("Edit");

  gtk_box_pack_start(GTK_BOX(zh),zt,TRUE,TRUE,2);
  gtk_box_pack_start(GTK_BOX(zh),ze,TRUE,TRUE,2);
  gtk_box_pack_start(GTK_BOX(zv),zh,FALSE,TRUE,2);

  gtk_widget_set_sensitive(zt, FALSE);
  gtk_widget_set_sensitive(ze, FALSE);

  gtk_widget_show(ze);
  gtk_widget_show(zt);
  gtk_widget_show(zh);
  gtk_widget_show(zd);
  gtk_widget_show(zl);
  gtk_widget_show(zv);
  gtk_widget_show(zf);

  snddesc=zd;
  sndb[0]=zt;
  sndb[1]=ze;
  selected_sound_event=-1;
  
  gtk_signal_connect(GTK_OBJECT(zt),"clicked",
		     GTK_SIGNAL_FUNC(prefs_sndtest),(gpointer) this);
  gtk_signal_connect(GTK_OBJECT(ze),"clicked",
		     GTK_SIGNAL_FUNC(prefs_sndedit),(gpointer) this);

  gtk_signal_connect(GTK_OBJECT(zl),"select_row",
		     GTK_SIGNAL_FUNC(prefs_sndsel),(gpointer) this);
  gtk_signal_connect(GTK_OBJECT(zl),"unselect_row",
		     GTK_SIGNAL_FUNC(prefs_sndunsel),(gpointer) this);

  gtk_widget_show(sv);
  gtk_widget_show(sl);
  gtk_notebook_append_page(GTK_NOTEBOOK(nb),sv,sl);

  // autosave ========================================================================

  gl=gtk_label_new("Autosave");
  gv=gtk_vbox_new(FALSE,4);
  
  gll=gtk_label_new("PGN filename:");
  gh=gtk_hbox_new(FALSE,4);

  asp=gtk_check_button_new_with_label("Auto-save played games");
  aso=gtk_check_button_new_with_label("Auto-save observed games");
  afn=gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(afn),global.AppendFile);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(asp), global.AppendPlayed?1:0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(aso), global.AppendObserved?1:0);

  gtk_box_pack_start(GTK_BOX(gv),asp,FALSE,FALSE,4);
  gtk_box_pack_start(GTK_BOX(gv),aso,FALSE,FALSE,4);
  gtk_box_pack_start(GTK_BOX(gv),gh,FALSE,FALSE,4);
  gtk_box_pack_start(GTK_BOX(gh),gll,FALSE,FALSE,4);
  gtk_box_pack_start(GTK_BOX(gh),afn,TRUE,TRUE,4);

  gtk_widget_show(gv);
  gtk_widget_show(gh);
  gtk_widget_show(gl);
  gtk_widget_show(gll);
  gtk_widget_show(asp);
  gtk_widget_show(aso);
  gtk_widget_show(afn);
  gtk_notebook_append_page(GTK_NOTEBOOK(nb),gv,gl);

  // bottom
  hs=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v),hs,FALSE,FALSE,4);
  bhb=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(bhb), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(bhb), 5);
  gtk_box_pack_start(GTK_BOX(v),bhb,FALSE,FALSE,2);
  ok=gtk_button_new_with_label("Ok");
  GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
  apply=gtk_button_new_with_label("Apply");
  GTK_WIDGET_SET_FLAGS(apply,GTK_CAN_DEFAULT);
  cancel=gtk_button_new_with_label("Cancel");
  GTK_WIDGET_SET_FLAGS(cancel,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(bhb),ok,TRUE,TRUE,0);
  gtk_box_pack_start(GTK_BOX(bhb),apply,TRUE,TRUE,0);
  gtk_box_pack_start(GTK_BOX(bhb),cancel,TRUE,TRUE,0);
  gtk_widget_grab_default(ok);

  gtk_widget_show(ok);
  gtk_widget_show(apply);
  gtk_widget_show(cancel);
  gtk_widget_show(bhb);
  gtk_widget_show(hs);
  gtk_widget_show(nb);
  gtk_widget_show(v);

  setDismiss(GTK_OBJECT(cancel),"clicked");
  gtk_signal_connect(GTK_OBJECT(ok),"clicked",
		     GTK_SIGNAL_FUNC(prefs_ok),(gpointer)this);
  gtk_signal_connect(GTK_OBJECT(apply),"clicked",
		     GTK_SIGNAL_FUNC(prefs_apply),(gpointer)this);
}

PreferencesDialog::~PreferencesDialog() {
  int i;
  for(i=0;i<3;i++)
    delete(fm[i]);
  for(i=0;i<11;i++)
    delete(textcb[i]);
  delete lsq;
  delete dsq;
  delete preview;
}

void PreferencesDialog::ApplyCheckBox(GtkWidget *cb,int *curval,int *ch1, int *ch2) {
  int nval;
  nval=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cb))?1:0;
  if (nval != *curval) {
    if (ch1) *ch1=1;
    if (ch2) *ch2=1;
    *curval=nval;
  }  
}

void PreferencesDialog::ApplyEntry(GtkWidget *entry,char *curval, int sz,
				   int *ch1, int *ch2)
{
  char *nv;
  nv=gtk_entry_get_text(GTK_ENTRY(entry));
  if (strcmp(curval,nv)) {
    strncpy(curval,nv,sz);
    if (ch1) *ch1=1;
    if (ch2) *ch2=1;
  }
}

void PreferencesDialog::ApplyColorButton(ColorButton *cb,int *curval,
					 int *ch1, int *ch2)
{
  if (cb->getColor() != *curval) {
    if (ch1) *ch1=1;
    if (ch2) *ch2=1;
    *curval=cb->getColor();
  }  
}

void PreferencesDialog::Apply() {
  int i,nval=0,changed=0,fchg=0,psetchg=0, tbg=0;
  GtkPositionType ntp;
  char *p;

  for(i=0;i<4;i++)
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tabposb[i]))) nval=i;

  if (nval!=global.TabPos) {
    global.TabPos=nval%4;
    changed=1;
    switch(global.TabPos) {
    case 0: ntp=GTK_POS_RIGHT; break;
    case 1: ntp=GTK_POS_LEFT; break;
    case 2: ntp=GTK_POS_TOP; break;
    case 3: ntp=GTK_POS_BOTTOM; break;
    }
    global.ebook->setTabPosition(ntp);
  }

  ApplyEntry(efont[0],global.ClockFont,96,&changed,0);
  ApplyEntry(efont[1],global.PlayerFont,96,&changed,0);
  ApplyEntry(efont[2],global.InfoFont,96,&changed,0);
  ApplyEntry(efont[3],global.ConsoleFont,96,&changed,&fchg);

  ApplyCheckBox(plainb, &global.PlainSquares, &changed, &psetchg);
  ApplyCheckBox(smoothb, &global.SmootherAnimation, &changed, 0);
  ApplyCheckBox(dhsb, &global.DrawHouseStock, &changed, 0);
  ApplyCheckBox(aqbar, &global.ShowQuickbar, &changed, 0);
  ApplyCheckBox(showratb, &global.ShowRating, &changed, 0);
  ApplyCheckBox(autologb, &global.FicsAutoLogin, &changed, 0);
  ApplyCheckBox(sgb, &global.IcsSeekGraph, &changed, 0);
  ApplyCheckBox(hsb, &global.HideSeeks, &changed, 0);
  ApplyCheckBox(chsb, &global.SplitChannels, &changed, 0);
  ApplyCheckBox(coct, &global.ChannelsToConsoleToo, &changed, 0);
  ApplyCheckBox(wget, &global.RetrieveChannelNames, &changed, 0);
  ApplyCheckBox(asp, &global.AppendPlayed, &changed, 0);
  ApplyCheckBox(aso, &global.AppendObserved, &changed, 0);

  ApplyEntry(afn,global.AppendFile,128,&changed,0);

  if (lsq->getColor() != global.LightSqColor) {
    changed=1; psetchg=1;
    global.LightSqColor=lsq->getColor();
  }

  ApplyColorButton(textcb[0],&global.Colors.TextDefault,&changed,0);
  ApplyColorButton(textcb[1],&global.Colors.TextBright,&changed,0);
  ApplyColorButton(textcb[2],&global.Colors.PrivateTell,&changed,0);
  ApplyColorButton(textcb[3],&global.Colors.NewsNotify,&changed,0);
  ApplyColorButton(textcb[4],&global.Colors.Mamer,&changed,0);
  ApplyColorButton(textcb[5],&global.Colors.KibitzWhisper,&changed,0);
  ApplyColorButton(textcb[6],&global.Colors.Shouts,&changed,0);
  ApplyColorButton(textcb[7],&global.Colors.Seeks,&changed,0);
  ApplyColorButton(textcb[8],&global.Colors.ChannelTell,&changed,0);
  ApplyColorButton(textcb[9],&global.Colors.Engine,&changed,0);
  ApplyColorButton(textcb[10],&global.Colors.Background,&changed,&tbg);

  if (dsq->getColor() != global.DarkSqColor) {
    changed=1; psetchg=1;
    global.DarkSqColor=dsq->getColor();
  }

  p=gtk_entry_get_text(GTK_ENTRY(sbacke));
  nval=atoi(p);
  if (nval!=global.ScrollBack) {
    changed=1;
    global.ScrollBack=nval;
    global.updateScrollBacks();
  }

  p=gtk_entry_get_text(GTK_ENTRY(lowtime));
  nval=atoi(p);
  if (nval!=global.LowTimeWarningLimit) {
    changed=1;
    global.LowTimeWarningLimit=nval;
  }

  for(i=0;i<N_SOUND_EVENTS;i++)
    if (sndcopy[i] != global.sndevents[i]) {
      global.sndevents[i]=sndcopy[i];
      changed=1;
    }
  
  if (changed)
    for(global.BLi=global.BoardList.begin();
	global.BLi!=global.BoardList.end(); // isn't c++ cute ?
	global.BLi++) {
      (*global.BLi)->reloadFonts();
      if (psetchg)
	global.respawnPieceSet();
      else
	(*global.BLi)->invalidate();
      (*global.BLi)->queueRepaint();
    }
  if (fchg)
    global.output->updateFont();
  if (tbg)
    global.output->setBackground(global.Colors.Background);

  if (changed)
    global.qbcontainer->update();
   
  if (changed)
    global.writeRC();
}

void prefs_defcolor(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  TerminalColor tc;
  int i;
  me=(PreferencesDialog *)data;

  me->preview->freeze();
  me->textcb[0]->setColor(tc.TextDefault);
  me->textcb[1]->setColor(tc.TextBright);
  me->textcb[2]->setColor(tc.PrivateTell);
  me->textcb[3]->setColor(tc.NewsNotify);
  me->textcb[4]->setColor(tc.Mamer);
  me->textcb[5]->setColor(tc.KibitzWhisper);
  me->textcb[6]->setColor(tc.Shouts);
  me->textcb[7]->setColor(tc.Seeks);
  me->textcb[8]->setColor(tc.ChannelTell);
  me->textcb[9]->setColor(tc.Engine);
  me->textcb[10]->setColor(tc.Background);
  me->preview->thaw();
}

void prefs_apply(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  me=(PreferencesDialog *)data;
  me->Apply();
}

void prefs_ok(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  me=(PreferencesDialog *)data;
  prefs_apply(w,data);
  me->release();
}

void prefs_cfont1(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  GtkWidget *fd;
  char cmd[256];
  sigfunc pipeopt;

  me=(PreferencesDialog *)data;  

  // this GTK font dialog sucks so much...
  me->ResolveFont(gtk_entry_get_text(GTK_ENTRY(me->efont[0])),cmd);

  fd=gtk_font_selection_dialog_new("Choose Font");

  if (strlen(cmd))
    gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(fd),cmd);

  gtk_font_selection_dialog_set_preview_text(GTK_FONT_SELECTION_DIALOG(fd),"52:38");
  gtk_widget_show(fd);
  gtk_grab_add(fd);

  gtk_signal_connect (GTK_OBJECT (fd), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed),&fd);
  gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fd)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC(prefs_fok1),data);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fd)->cancel_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			     GTK_OBJECT (fd));
  me->fontdlg=fd;
}

void prefs_fok1(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  char *p;
  me=(PreferencesDialog *)data;
  p=gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(me->fontdlg)); 
  if (p)
    gtk_entry_set_text(GTK_ENTRY(me->efont[0]),p);
  gtk_grab_remove(me->fontdlg);
  gtk_widget_destroy(me->fontdlg);
}

void prefs_fok2(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  char *p;
  me=(PreferencesDialog *)data;
  p=gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(me->fontdlg)); 
  if (p)
    gtk_entry_set_text(GTK_ENTRY(me->efont[1]),p);
  gtk_grab_remove(me->fontdlg);
  gtk_widget_destroy(me->fontdlg);
}

void prefs_fok3(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  char *p;
  me=(PreferencesDialog *)data;
  p=gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(me->fontdlg)); 
  if (p)
    gtk_entry_set_text(GTK_ENTRY(me->efont[2]),p);
  gtk_grab_remove(me->fontdlg);
  gtk_widget_destroy(me->fontdlg);
}

void prefs_fok4(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  char *p;
  me=(PreferencesDialog *)data;
  p=gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(me->fontdlg)); 
  if (p)
    gtk_entry_set_text(GTK_ENTRY(me->efont[3]),p);
  gtk_grab_remove(me->fontdlg);
  gtk_widget_destroy(me->fontdlg);
}

void prefs_cfont2(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  GtkWidget *fd;
  char cmd[256];
  sigfunc pipeopt;

  me=(PreferencesDialog *)data;  

  // this GTK font dialog sucks so much...
  me->ResolveFont(gtk_entry_get_text(GTK_ENTRY(me->efont[1])),cmd);

  fd=gtk_font_selection_dialog_new("Choose Font");

  if (strlen(cmd))
    gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(fd),cmd);

  gtk_font_selection_dialog_set_preview_text(GTK_FONT_SELECTION_DIALOG(fd),"White Capablanca");
  gtk_widget_show(fd);
  gtk_grab_add(fd);

  gtk_signal_connect (GTK_OBJECT (fd), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed),&fd);
  gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fd)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC(prefs_fok2),data);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fd)->cancel_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			     GTK_OBJECT (fd));
  me->fontdlg=fd;
}

void prefs_cfont3(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  GtkWidget *fd;
  char cmd[256];
  sigfunc pipeopt;

  me=(PreferencesDialog *)data;  

  // this GTK font dialog sucks so much...
  me->ResolveFont(gtk_entry_get_text(GTK_ENTRY(me->efont[2])),cmd);

  fd=gtk_font_selection_dialog_new("Choose Font");

  if (strlen(cmd))
    gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(fd),cmd);

  gtk_font_selection_dialog_set_preview_text(GTK_FONT_SELECTION_DIALOG(fd),"38. N@c5+");
  gtk_widget_show(fd);
  gtk_grab_add(fd);

  gtk_signal_connect (GTK_OBJECT (fd), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed),&fd);
  gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fd)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC(prefs_fok3),data);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fd)->cancel_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			     GTK_OBJECT (fd));
  me->fontdlg=fd;
}

void prefs_cfont4(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  GtkWidget *fd;
  char cmd[256];

  me=(PreferencesDialog *)data;  

  // this GTK font dialog sucks so much...
  me->ResolveFont(gtk_entry_get_text(GTK_ENTRY(me->efont[3])),cmd);

  fd=gtk_font_selection_dialog_new("Choose Font");

  if (strlen(cmd))
    gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(fd),cmd);

  gtk_font_selection_dialog_set_preview_text(GTK_FONT_SELECTION_DIALOG(fd),"AOLer(1): I have a question...");
  gtk_widget_show(fd);
  gtk_grab_add(fd);

  gtk_signal_connect (GTK_OBJECT (fd), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed),&fd);
  gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fd)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC(prefs_fok4),data);
  gtk_signal_connect_object (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fd)->cancel_button),
			     "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			     GTK_OBJECT (fd));
  me->fontdlg=fd;
}

void prefs_frevert(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  me=(PreferencesDialog *)data;
  gtk_entry_set_text(GTK_ENTRY(me->efont[0]),DEFAULT_FONT_CLOK);
  gtk_entry_set_text(GTK_ENTRY(me->efont[1]),DEFAULT_FONT_PLYR);
  gtk_entry_set_text(GTK_ENTRY(me->efont[2]),DEFAULT_FONT_INFO);
  gtk_entry_set_text(GTK_ENTRY(me->efont[3]),DEFAULT_FONT_CONS);
}

#include <X11/Xlib.h>

void PreferencesDialog::ResolveFont(char *src,char *dest) {
  Display *dpy;
  char **ptr;
  int r;

  strcpy(dest,src);
  dpy=XOpenDisplay(gdk_get_display());
  if (dpy) {
    ptr=XListFonts(dpy,src,1,&r);
    if (ptr) {
      if (r)
	strcpy(dest,ptr[0]);
      XFreeFontNames(ptr);
    }
    XCloseDisplay(dpy);
  }
}

// sounds

void prefs_sndtest(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  me=(PreferencesDialog *)data;
  me->sndcopy[me->selected_sound_event].safePlay();
}

void prefs_sndedit(GtkWidget *w,gpointer data) {
  PreferencesDialog *me;
  me=(PreferencesDialog *)data;
  me->sndcopy[me->selected_sound_event].edit(me);
}

void PreferencesDialog::SoundEventChanged() {
  gboolean sens;
  int i;
 
  if (selected_sound_event < 0) {
    gtk_label_set_text(GTK_LABEL(snddesc)," ");
    sens=FALSE;
  } else {
    gtk_label_set_text(GTK_LABEL(snddesc),sndcopy[selected_sound_event].getDescription());
    sens=TRUE;
  }

  for(i=0;i<2;i++)
    gtk_widget_set_sensitive(sndb[i],sens);

  gtk_widget_queue_resize(snddesc);
}

void prefs_sndsel(GtkCList *c,gint row, gint col, GdkEventButton *eb, gpointer data) {
  PreferencesDialog *me;
  me=(PreferencesDialog *)data;
  me->selected_sound_event=row;
  me->SoundEventChanged();
}

void prefs_sndunsel(GtkCList *c,gint row, gint col, GdkEventButton *eb, gpointer data) {
  PreferencesDialog *me;
  me=(PreferencesDialog *)data;
  me->selected_sound_event=-1;
  me->SoundEventChanged();
}
