/*
 * SiSCtrl - SiS Display Control Panel
 * for the SiS X.org/XFree86 driver
 *
 * Private definitions for GUI part
 *
 * (C) 2003-2005 Thomas Winischhofer <thomas@winischhofer.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _SISCTRL_GUI_H_
#define _SISCTRL_GUI_H_

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "../gfx/mode.xpm"
#include "../gfx/crt1.xpm"
#include "../gfx/crt2.xpm"
#include "../gfx/gamma.xpm"
#include "../gfx/tvsettings.xpm"
#include "../gfx/video.xpm"
#include "../gfx/config.xpm"
#include "../gfx/about.xpm"

#include "../gfx/lcdnew.xpm"
#include "../gfx/lcdanew.xpm"
#include "../gfx/dvi.xpm"
#include "../gfx/dvi1.xpm"
#include "../gfx/lcd.xpm"
#include "../gfx/lcda.xpm"
#include "../gfx/tvpal.xpm"
#include "../gfx/tvpalm.xpm"
#include "../gfx/tvpaln.xpm"
#include "../gfx/tvntsc.xpm"
#include "../gfx/tvhivi2.xpm"
#include "../gfx/tv525.xpm"
#include "../gfx/tv525i2.xpm"
#include "../gfx/tv525p2.xpm"
#include "../gfx/tv625.xpm"
#include "../gfx/tv625i2.xpm"
#include "../gfx/tv625p2.xpm"
#include "../gfx/tv750p2.xpm"
#include "../gfx/tv1080i2.xpm"
#include "../gfx/vga1.xpm"
#include "../gfx/vga2.xpm"

#include "../gfx/crt1lcda.xpm"
#include "../gfx/crt1lcdal.xpm"

#include "../gfx/redetect.xpm"
#include "../gfx/crt2lcd.xpm"
#include "../gfx/crt2lcdl.xpm"
#include "../gfx/crt2tv.xpm"
#include "../gfx/crt2svideo.xpm"
#include "../gfx/crt2cvbs.xpm"
#include "../gfx/crt2ypbpr.xpm"
#include "../gfx/crt2vga.xpm"
#include "../gfx/nomode.xpm"

#ifdef HAVE_RANDR
#include "../gfx/crt2lcd90.xpm"
#include "../gfx/crt2lcd180.xpm"
#include "../gfx/crt2lcd270.xpm"
#include "../gfx/crt2lcdl90.xpm"
#include "../gfx/crt2lcdl180.xpm"
#include "../gfx/crt2lcdl270.xpm"
#include "../gfx/crt2vga90.xpm"
#include "../gfx/crt2vga180.xpm"
#include "../gfx/crt2vga270.xpm"
#include "../gfx/crt2tv90.xpm"
#include "../gfx/crt2tv180.xpm"
#include "../gfx/crt2tv270.xpm"
#endif

#include "../gfx/clone.xpm"

#include "../gfx/tvleft.xpm"
#include "../gfx/tvright.xpm"
#include "../gfx/tvup.xpm"
#include "../gfx/tvdown.xpm"
#include "../gfx/tvxp.xpm"
#include "../gfx/tvxm.xpm"
#include "../gfx/tvyp.xpm"
#include "../gfx/tvym.xpm"
#include "../gfx/tvdef.xpm"

#include "../gfx/gammastipple.xpm"

#include "../gfx/sisctrl_logo.xpm"
#include "../gfx/sisctrl2.xpm"

#include "../gfx/ok.xpm"
#include "../gfx/apply.xpm"
#include "../gfx/close.xpm"
#include "../gfx/undo.xpm"

#include "../gfx/sisctrl_icon16.h"
#include "../gfx/sisctrl_icon32.h"
#include "../gfx/sisctrl_icon48.h"
#include "../gfx/sisctrl_icon64.h"

#ifdef USEXV
#include "../gfx/xvicon.h"
#endif

/* Size of gamma curve gfx (64 + 2 for border) */
#define GACW 66
#define GACH 66

/* Size of Xv icon image for video page */
#define XVWIDTH  150
#define XVHEIGHT 125

/* This is used to switch from using OptionMenus to ComboBoxes.
 * While ComboBox is supposed to the be successor of OptionMenu,
 * Comboboxes have several disadvantages.
 * - Showing/hiding specific items is a PITA. This was so easy
 *   with OptionMenu (due to the items being widgets), but now
 *   I need to fiddle with TreeView/ListStore models with filters
 *   or rebuild the (text-)combobox on changes.
 * - Tooltips don't work. Now I need eventboxes around the combobox
 *   in order to show tooltips.
 * - They are uglier.
 * Thanks guys. A real improvement.
 */
#undef SISGTK24
#if 1
#if (GTK_MAJOR_VERSION > 2) || ((GTK_MAJOR_VERSION == 2) && (GTK_MINOR_VERSION >= 4))
#define SISGTK24
#endif
#endif

/* Our global data */

typedef struct {

	GtkWidget *window, *errordialog;
	GtkWidget *table, *tv_table;
	GtkWidget *notebook;
	Bool nbscroll;
	int notebook_page;

	GtkWidget *dm_frame, *c1_frame, *om_frame, *ga_frame;
	GtkWidget *tv_frame, *tp_frame, *vi_frame, *ab_frame;
	GtkWidget *dm_label, *c1_label, *om_label, *ga_label;
	GtkWidget *tv_label, *tp_label, *vi_label, *ab_label;
	GtkWidget *button1, *button2, *button3, *button4;
	GtkWidget *button1box, *button2box, *button3box, *button4box;

	GtkWidget *dm_table, *dm_rr_table, *dm_size_label;
	GtkWidget *dm_list, *dm_list_window, *dm_rot_label;
	GtkWidget *dm_mmdt_label, *dm_mmdl_label, *dm_mmdr_label;
	GtkListStore *dm_liststore;
	GtkTreeIter dm_iter[SISCTRL_MAXMODES];
	GtkCellRenderer *dm_renderer;
	GtkTreeViewColumn *dm_column;
	GtkTreeSelection *dm_select;
	GtkWidget *dm_comboboxrr, *dm_comboboxrot;
	Bool dm_haverandrsize[SISCTRL_MAXMODES + 2];
	int dm_rotindices[8], dm_rrotindices[8];
	GdkPixbuf *pixbuf_vga, *pixbuf_lcd, *pixbuf_lcda, *pixbuf_tvpal, *pixbuf_tvpalm;
	GdkPixbuf *pixbuf_tvpaln, *pixbuf_tvntsc, *pixbuf_tv525i, *pixbuf_tv525p;
	GdkPixbuf *pixbuf_tv625i, *pixbuf_tv625p, *pixbuf_tv750p, *pixbuf_tv1080i;
	GdkPixbuf *pixbuf_tv525, *pixbuf_tv625, *pixbuf_vga2;
	GtkWidget *dm_mfbtable, *dm_mfbdraw;
	GdkPixbuf *dm_icon[DM_GI_NUM], *dm_icon90[DM_GI_NUM], *dm_icon180[DM_GI_NUM], *dm_icon270[DM_GI_NUM];
	GdkPixbuf *dm_icon_clone;
	GdkGC     *dm_mfb_context;
	int leftcrtnum, rightcrtnum;
	char lefthz[8], righthz[8];
	char **dm_icon90source[DM_GI_NUM], **dm_icon180source[DM_GI_NUM], **dm_icon270source[DM_GI_NUM];
	int dm_mfbsizex, dm_mfbsizey;

	GtkWidget *c1_table;
	GtkWidget *c1_combobox, *c1_comboboxls, *c1_comboboxcc;
	GtkWidget *c1_eventboxls, *c1_eventboxcc;
	int c1_menuindices[C1_MI_NUM], c1_rmenuindices[C1_MI_NUM];
	GtkWidget *c1_label_nodh, *c1_label_onoff, *c1_label_lcds;
	GtkWidget *c1_imageon, *c1_imageoff, *c1_imagelcda, *c1_imagenomode;
	GtkWidget *c1_redetect, *c1_redetectbox;

	GtkWidget *om_table, *om_table2;
	GtkWidget *om_label_lcds, *om_label_tvst, *om_label_tvas;
	Bool om_mi_visible[C2_MI_NUM];
	int om_menuindices[C2_MI_NUM], om_rmenuindices[C2_MI_NUM];
	int om_menuindices_t[C2_MI_TV_NUM], om_rmenuindices_t[C2_MI_TV_NUM];
	int om_menuindices_st[C2_MI_ST_NUM], om_rmenuindices_st[C2_MI_ST_NUM];
	Bool soverscanshown;
	GtkWidget *om_combobox, *om_comboboxt, *om_comboboxst;
	GtkWidget *om_comboboxas, *om_comboboxo, *om_comboboxls, *om_comboboxcc;
	GtkWidget *om_eventboxt, *om_eventboxst;
	GtkWidget *om_eventboxas, *om_eventboxo, *om_eventboxls, *om_eventboxcc;

	GtkWidget *om_lcd, *om_tv, *om_tvs, *om_tvc, *om_vga, *om_ypbpr, *om_tvbox, *om_tvc2, *om_tvs2, *om_nomode;
	GtkWidget *om_check, *om_label_nodh, *om_label_type, *om_label_tvtype;
	GtkWidget *om_redetect, *om_redetectbox, *om_tvalign;

	GtkWidget *tp_table, *tv_table2, *tp_box;
	GtkWidget *tp_label_notv, *tv_label_notv;
	GtkWidget *tp_label_af, *tp_label_sa, *tp_label_ee, *tp_label_coc, *tp_label_cof;
	GtkWidget *tp_label_co, *tp_label_te, *tp_check_col, *tp_check_cfi, *tp_label_yfi;
	GtkWidget *tp_label_cf, *tp_label_lf;
	GtkWidget *tp_range_sa, *tp_range_ee, *tp_range_coc, *tp_range_cof;
	GtkWidget *tp_range_co, *tp_range_te;
	GtkWidget *tp_range_cf, *tp_range_lf;
	GtkWidget *tp_combobox, *tp_comboboxy;

	GtkWidget *tp_framearh;
	GtkWidget *tv_button_le, *tv_button_ri, *tv_button_dn, *tv_button_up;
	GtkWidget *tv_button_de;
	GtkWidget *tv_button_xm, *tv_button_xp, *tv_button_yp, *tv_button_ym;
	GtkWidget *tv_arrow_ri, *tv_arrow_le, *tv_arrow_dn, *tv_arrow_up;
	GtkWidget *tv_arrow_xp, *tv_arrow_xm, *tv_arrow_yp, *tv_arrow_ym, *tv_arrow_def;
	GtkWidget *tv_button_arh, *tv_layout, *tv_eventbox;
	GdkGC     *tv_context;

	GtkWidget *ga_table, *ga_check1, *ga_check2, *ga_spin1, *ga_spin2, *ga_spin3;
	GtkWidget *ga_spin4, *ga_spin5, *ga_spin6, *ga_sping;
	GtkWidget *ga_spin7, *ga_spin8, *ga_spin9;
	GtkAdjustment *ga_spin1_adj, *ga_spin2_adj, *ga_spin3_adj;
	GtkAdjustment *ga_spin4_adj, *ga_spin5_adj, *ga_spin6_adj, *ga_sping_adj;
	GtkAdjustment *ga_spin7_adj, *ga_spin8_adj, *ga_spin9_adj;
	GtkWidget *ga_drawable, *ga_subtable, *ga_subtable1, *ga_subtable2, *ga_subtable3;
	GtkWidget *ga_plabel1, *ga_plabel2, *ga_hbox, *ga_vbox;
	GtkWidget *ga_label_enable, *ga_label_red, *ga_label_green, *ga_label_blue;
	GtkWidget *ga_label_red1, *ga_label_green1, *ga_label_blue1;
	GtkWidget *ga_label_red2, *ga_label_green2, *ga_label_blue2;
	GtkWidget *ga_label_gamma, *ga_label_bri, *ga_label_con, *ga_layout, *ga_eventbox;
	GtkWidget *ga_comboboxsep, *ga_eventboxsep, *ga_combobox;
	int ga_menuindices[GAMMA_GFX_NUM + 2], ga_rmenuindices[GAMMA_GFX_NUM + 2];
	GtkWidget *ga_label_adjust, *ga_label_sat, *ga_radio_rgb, *ga_radio_all;
	GtkWidget *ga_subsubtable2, *ga_label_sat1, *ga_label_sat2, *ga_spin_sat1, *ga_spin_sat2;
	GtkAdjustment *ga_sat1_adj, *ga_sat2_adj;
	GSList    *ga_group, *ga_group_rgb;
	GdkGC     *ga_context;
	GdkColor  ga_colorrgb[16*3];
	GdkColor  ga_colorcmy[11*3];
	GdkColor  ga_colorgrey[10*2];
	GdkColor  ga_colordgrey[10];
	GdkColor  ga_colormgrey[11];
	GdkColor  ga_colorlgrey[10];
	GdkPixmap *ga_stipple, *ga_stipple2;
	int	  ga_current_gfx;
	int	  ga_current_adj;

	GtkWidget *vi_table, *vi_table2, *vi_ga_table, *vi_layout, *vi_sw_table, *vi_label_busy;
	GtkWidget *vi_label_co, *vi_label_br, *vi_label_sa, *vi_label_hu, *vi_label_sw;
	GtkWidget *vi_range_co, *vi_range_br, *vi_range_sa, *vi_range_hu;
	GtkWidget *vi_label_red, *vi_label_green, *vi_label_blue;
	GtkWidget *vi_check_gamma, *vi_spin1, *vi_spin2, *vi_spin3;
	GtkAdjustment *vi_spin1_adj, *vi_spin2_adj, *vi_spin3_adj;
	GtkWidget *vi_radio_crt1, *vi_radio_crt2, *vi_check_video_only;
	GSList    *vi_group;
	GtkWidget *vi_label_gl, *vi_radio_gl, *vi_radio_th;
	GdkGC     *vi_context;

	Bool haveglobal;
	Bool isglobal;

	GtkWidget *cf_text_window, *cf_tview, *cf_frame, *cf_label;
	GtkWidget *cf_table, *cf_check, *cf_radio1, *cf_radio2, *cf_radio3;
	GSList    *cf_group;
	GtkTextBuffer *cf_buffer;
	GtkTextTag *black, *grey, *red, *blackb, *redb, *blue, *blueb;

	int showhints;

	GtkWidget *ab_table, *ab_table2, *ab_label_ab1, *ab_label_ab2, *ab_layout;
	GtkWidget *ab_label_ab3, *ab_label_ab4, *ab_label_ab5, *ab_label_ab6, *ab_label_ab7;
	GdkPixmap *ab_icon, *ab_iconul;
	GtkWidget *ab_text_window, *ab_tview, *ab_image;
	GtkTextBuffer *ab_buffer;
	GdkColor  ab_bgcolor, ab_bgcolorw, ab_bgcolorb;
	GdkGC     *ab_context;
	GtkTextTag *abblack, *abblackb;

	GtkTooltips *mytooltips;

	GdkCursor *waitcursor;

#ifdef USEXV
	Window xvwin;
	GC xvcontext;
	XvImage *myxvimage;
	XShmSegmentInfo xvshminfo;
	Bool xvattached, xvshown, xvraised, xvinit, xvwasbusy;
	int xvx, xvy, xvwidth, xvheight;
	int xerror;
	int current_xv_result;
#endif

	guchar rgbbuf[GACW * GACH * 3];

	gboolean init_done;

	/* Confirmation dialog */
	GtkWidget *confdialog, *pbar;
	int pbar_prog;
	gint pbar_timeout;

#ifdef USE_STRAY
	gboolean visible;
	GtkWidget *st_menu, *st_menu1, *st_menu2, *st_menuv;
	GtkWidget *stm1_on, *stm1_lcda, *stm1_off;
	GtkWidget *stm2_lcd, *stm2_svhs, *stm2_cvbs, *stm2_cvsv, *stm2_tv;
	GtkWidget *stm2_hivi, *stm2_525i, *stm2_525p, *stm2_625i, *stm2_625p, *stm2_750p, *stm2_1080i;
	GtkWidget *stm2_vga, *stm2_scart, *stm2_off, *stm2_det;
	GtkWidget *stmv_crt1, *stmv_crt2;
#endif

} sisctrl_gui;

static GdkColor ga_bgcolors[] = {
   { 0,     0,     0,     0 },	/* CRT1 */
   { 0,     0,     0,     0 },	/* CRT2 */
   { 0,     0,     0,     0 },	/* RGB Boxes 2.2 */
   { 0,     0,     0,     0 },	/* RGB Boxes 1.8 */
   { 0,     0,     0,     0 },	/* RGB Boxes Custom */
   { 0,     0,     0,     0 },	/* RGB Bars 2.2 */
   { 0,     0,     0,     0 },	/* RGB Bars 1.8 */
   { 0,     0,     0,     0 },	/* RGB Bars Custom */
   { 0, 65535, 65535, 65535 },	/* Brightness */
   { 0,     0,     0,     0 },	/* RGB scale */
   { 0,     0,     0,     0 },	/* Grey */
   { 0, 65535, 65535, 65535 },	/* CMY */
   { 0,     0,     0,     0 },	/* Dark grey */
   { 0, 32768, 32768, 32768 },  /* Mid grey */
   { 0, 65535, 65535, 65535 },	/* Light grey */
};

static GdkColor  ga_colorblack   = { 0,     0,     0,     0};

static GdkColor  ga_colordgrey   = { 0,  8448,  8448,  8448};

static GdkColor  ga_colorwhite   = { 0, 65535, 65535, 65535};
static GdkColor  ga_colorwhiteh  = { 0, 44288, 44288, 44288};

static GdkColor  ga_colorred     = { 0, 65535,     0,     0};
static GdkColor  ga_colorredh    = { 0, 47616,     0,     0};

static GdkColor  ga_colorgreen   = { 0,     0, 65535,     0};
static GdkColor  ga_colorgreenh  = { 0,     0, 47616,     0};

static GdkColor  ga_colorblue    = { 0,     0,     0, 65535};
static GdkColor  ga_colorblueh   = { 0,     0,     0, 47616};

static const int cmyc[] = {
	255, 255, 255,
	218, 241, 254,
	185, 230, 252,
	157, 219, 250,
	128, 209, 248,
	 98, 199, 247,
	 65, 190, 243,
	  1, 181, 242,
	  0, 174, 242,
	  0, 167, 240,
	  0, 160, 239
};

static const int cmym[] = {
	255, 255, 255,
	250, 226, 239,
	247, 200, 223,
	242, 176, 208,
	237, 151, 196,
	235, 130, 182,
	233, 108, 168,
	229,  86, 157,
	227,  62, 146,
	226,  31, 133,
	222,   0, 122
};

static const int cmyy[] = {
	255, 255, 255,
	255, 254, 226,
	255, 250, 201,
	255, 249, 177,
	255, 249, 154,
	255, 248, 130,
	255, 245, 108,
	255, 244,  84,
	255, 242,  57,
	255, 241,  25,
	255, 240,   0
};

static const int dgrey[] = {
	3, 5, 8, 10, 13, 15, 18, 20, 23, 26
};

static const int mgrey[] = {
	115, 117, 120, 122, 125, 128, 130, 133, 135, 138, 140
};

static const int lgrey[] = {
	229, 232, 235, 237, 240, 242, 245, 247, 250, 252
};

/* Our routines */

Bool gui_xinerama_chooser(int maxscreens, int *newscreen);

void gui_init(int *argc, char ***argv);
void gui_main(void);
void gui_clean_ups(void);
void gui_main_quit(void);
#ifdef USEXV
void gui_destroy_xv_image(void);
#endif

void gui_showerror(char *message);
Bool gui_showerror_pregui(char *message, Bool yesno, Bool warning);

void gui_build_gui(void);
void gui_enable_revert_button(int enable);

int  gui_dm_get_current_selected_mode(void);
void gui_dm_create_gfx(void);
void gui_dm_set_mode_list_attributes(int listindex, unsigned short field);
void gui_dm_set_current_entry(int index);
#ifdef HAVE_RANDR
int  gui_dm_get_current_randr_index(void);
void gui_dm_set_current_randr_index(int index);
int  gui_dm_get_current_randr_rot_index(void);
void gui_dm_set_current_randr_rot_index(int index);
void gui_dm_update_leaveunchanged(char *newtext, char *newrottext);
#endif
void gui_dm_remove_mode_list_and_randr_sizes(void);
void gui_dm_rebuild_mode_list_and_randr_sizes(void);

void gui_crt1_show_variant(int variant);
void gui_crt1_set_type_menu_index(int index);
int  gui_crt1_get_type_menu_index(void);
void gui_crt1_set_scaling_menu_index(int index);
int  gui_crt1_get_scaling_menu_index(int retdefault);
void gui_crt1_show_scaling_menu_and_label(void);
void gui_crt1_hide_scaling_menu_and_label(void);
void gui_crt1_set_centering_menu_index(int index);
int  gui_crt1_get_centering_menu_index(int retdefault);
void gui_crt1_show_center_menu(void);
void gui_crt1_hide_center_menu(void);

void gui_crt2_set_type_menu_index(int index);
int  gui_crt2_get_type_menu_index(void);
void gui_crt2_hide_crt2_menu_items(void);
void gui_crt2_show_crt2_menu_item(int index);
void gui_crt2_finished_show_crt2_menu_items(void);
void gui_crt2_set_scaling_menu_index(int index);
int  gui_crt2_get_scaling_menu_index(int retdefault);
void gui_crt2_show_scaling_menu_and_label(void);
void gui_crt2_hide_scaling_menu_and_label(void);
void gui_crt2_set_centering_menu_index(int index);
int  gui_crt2_get_centering_menu_index(int retdefault);
void gui_crt2_show_center_menu(void);
void gui_crt2_hide_center_menu(void);
void gui_crt2_set_tvstd_menu_index(int index);
int  gui_crt2_get_tvstd_menu_index(void);
void gui_crt2_show_tvstd_menu_and_label(void);
void gui_crt2_hide_tvstd_menu_and_label(void);
void gui_crt2_set_signal_menu_index(int index);
int  gui_crt2_get_signal_menu_index(void);
void gui_crt2_show_signal_menu_and_label(void);
void gui_crt2_hide_signal_menu_and_label(void);
void gui_crt2_set_aspect_menu_index(int index);
int  gui_crt2_get_aspect_menu_index(void);
void gui_crt2_show_aspect_menu_and_label(void);
void gui_crt2_hide_aspect_menu_and_label(void);
void gui_crt2_set_overscan_menu_index(int index);
int  gui_crt2_get_overscan_menu_index(void);
void gui_crt2_show_overscan_menu(void);
void gui_crt2_hide_overscan_menu(void);
void gui_crt2_show_overscan_superover_menu_item(void);
void gui_crt2_hide_overscan_superover_menu_item(void);
int  gui_crt2_show_detected_devices_checked(void);

void gui_show_lcd_menus(int pagenum);

void gui_tv_antiflicker_enable_and_set_menu_index(int enable, int index);
void gui_tv_colorcalib_c_enable_and_set_value(int enable, double value);
void gui_tv_colorcalib_f_enable_and_set_value(int enable, double value);
void gui_tv_saturation_enable_and_set_value(int enable, double value);
void gui_tv_edgeenhance_enable_and_set_value(int enable, double value);
void gui_tv_filter_c_enable_and_set_value(int enable, int value);
void gui_tv_filter_y_enable_and_set_value(int enable, int index);
void gui_tv_chrontel_slider_set_value(int slider, int enable, double value);
void gui_tv_chrontel_cvbscolor_set_value(int enable, int val);

void gui_gamma_set_all_spin_values(double s1, double s2, double s3,
				   double s4, double s5, double s6,
				   double s7, double s8, double s9);
void gui_gamma_set_gamma_enabled_check_box_stati(int b1, int b2);
void gui_gamma_show_separate_gamma_menu(void);
void gui_gamma_hide_separate_gamma_menu(void);
int  gui_gamma_get_active_separate_menu_item(void);
void gui_gamma_set_active_separate_menu_item(int index);
void gui_gamma_drawggfx(void);
void gui_gamma_update_gamma_gfx(void);
void gui_gamma_update_gamma_pattern_menu(void);

void gui_vi_slider_set_value(int slider, double value);
int  gui_vi_get_xv_shown(void);
void gui_vi_enable_and_set_xv_gamma_check(int enable, int active);
void gui_vi_enable_xvgamma_spins(int enable);
void gui_vi_set_xvgamma_spins(double s1, double s2, double s3);
void gui_vi_enable_switchcrt(int enable);
void gui_vi_set_switchcrt_active_num(int num);
void gui_vi_set_video_only_value(int active);

void gui_cf_clear_text(void);
void gui_cf_append_text(char *mytext, int texttag);
void gui_cf_insert_option(char *oname, char *ovalue, int texttag);

void gui_ab_clear_text(void);
void gui_ab_append_text(char *mytext, int texttag);

/* Callbacks to main program */

extern Bool sisctrl_xinerama_query_screen(int screennum, char **chip, int *crtnum, Bool *IsSIS);

extern void sisctrl_delete_event(void);
extern void sisctrl_destroy_event(void);
extern void sisctrl_ok_clicked(int what);
extern int  sisctrl_do_apply(int what);
extern void sisctrl_revert_clicked(int what);
extern void sisctrl_close_clicked(void);

extern void sisctrl_set_disable_gfx(int s1, int s2);
extern void sisctrl_restore_disable_gfx_lr(void);
extern void sisctrl_restore_disable_gfx(void);

#ifdef HAVE_RANDR
extern void sisctrl_xrandreventhandler(void);
#endif

extern int  sisctrl_checkmodeforcrtx(int crt2, int devindex, int modeindex, int stdindex, int ypindex);

extern Bool sisctrl_get_mfb_devices(int index, int rotindex,
		int *leftdev, int *rightdev, int *topdev, int *bottomdev, int *rot, Bool *cloned);

extern void sisctrl_gl_display_mode_page_selected(void);
extern void sisctrl_gl_crt1_page_selected(void);
extern void sisctrl_gl_crt2_page_selected(void);
extern void sisctrl_gl_gamma_page_selected(void);
extern void sisctrl_gl_tv_page_selected(void);
extern void sisctrl_gl_video_page_selected(void);
extern void sisctrl_gl_current_page_selected(int hints);

/* Need only these two */
extern void sisctrl_gl_crt1_page_deselected(void);
extern void sisctrl_gl_crt2_page_deselected(void);

extern int  sisctrl_dm_get_current_mode_index(void);
extern void sisctrl_dm_update_leaveunchanged(void);
extern void sisctrl_dm_selection_changed(int index, int rotindex,
		char *leftdev, char *leftcrt, char *leftcrtnum, char *leftres, char *lefthz,
		char *rightdev, char *rightcrt, char *rightcrtnum, char *rightres, char *righthz,
		int *left_crt_num, int *right_crt_num, char *lefthz2, char *righthz2,
		Bool *cloned);
extern unsigned short sisctrl_dm_get_modefield(int index);

extern void sisctrl_crt1_redetect_devices(void);
extern void sisctrl_crt1_activate_redetection_result(void);

extern void sisctrl_crt2_show_detected_only_changed(void);
extern void sisctrl_crt2_redetect_devices(void);

extern int  sisctrl_get_current_crt1type_index(void);
extern int  sisctrl_get_lcd_scaling_history(void);
extern int  sisctrl_get_lcd_center_history(void);

extern void sisctrl_crt2_show_initial_crt2_type_menu(void);
extern void sisctrl_crt2_set_initial_crt2_type_history(void);
extern void sisctrl_crt2_set_initial_tv_std(void);
extern void sisctrl_crt2_set_initial_signal_type(void);
extern void sisctrl_crt2_set_initial_aspect_ratio(void);

extern void sisctrl_tv_antiflicker_set_history(void);
extern void sisctrl_tv_col_calib_set_c_value(void);
extern void sisctrl_tv_col_calib_set_f_value(void);
extern void sisctrl_tv_saturation_set_value(void);
extern void sisctrl_tv_edgeenhance_set_value(void);
extern void sisctrl_tv_c_filter_set_value(void);
extern void sisctrl_tv_y_filter_set_value(void);
extern void sisctrl_tv_ch_contrast_set_value(void);
extern void sisctrl_tv_ch_textenhance_set_value(void);
extern void sisctrl_tv_ch_chromaff_set_value(void);
extern void sisctrl_tv_ch_lumaff_set_value(void);
extern void sisctrl_tv_ch_cvbscol_set_value(void);
extern void sisctrl_tv_de_clicked(void);
extern void sisctrl_tv_up_clicked(void);
extern void sisctrl_tv_dn_clicked(void);
extern void sisctrl_tv_le_clicked(void);
extern void sisctrl_tv_ri_clicked(void);
extern void sisctrl_tv_xm_clicked(void);
extern void sisctrl_tv_xp_clicked(void);
extern void sisctrl_tv_ym_clicked(void);
extern void sisctrl_tv_yp_clicked(void);
extern void sisctrl_tp_af_changed(int index);
extern void sisctrl_tp_sa_changed(double value);
extern void sisctrl_tp_ee_changed(double value);
extern void sisctrl_tp_col_calib_changed(double valc, double valf);
extern void sisctrl_tp_check_cfi_toggled(int val);
extern void sisctrl_tp_yfi_changed(int index);
extern void sisctrl_tp_co_changed(double value);
extern void sisctrl_tp_te_changed(double value);
extern void sisctrl_tp_cf_changed(double value);
extern void sisctrl_tp_lf_changed(double value);
extern void sisctrl_tp_check_col_toggled(int val);

extern void sisctrl_gamma_set_status(void);
extern void sisctrl_gamma_set_all_spinvalues(void);
extern void sisctrl_gamma_enable_1(int checked);
extern void sisctrl_gamma_enable_2(int checked);
extern void sisctrl_gamma_separate_changed(int checked);
extern void sisctrl_gamma_separate_toggled(int checked);
extern void sisctrl_gamma_spin_red_changed(double value);
extern void sisctrl_gamma_spin_green_changed(double value);
extern void sisctrl_gamma_spin_blue_changed(double value);
extern void sisctrl_gamma_spin_all_changed(double value);
extern void sisctrl_gamma_spin_bri_red_changed(double value);
extern void sisctrl_gamma_spin_bri_green_changed(double value);
extern void sisctrl_gamma_spin_bri_blue_changed(double value);
extern void sisctrl_gamma_spin_bri_all_changed(double value);
extern void sisctrl_gamma_spin_con_red_changed(double value);
extern void sisctrl_gamma_spin_con_green_changed(double value);
extern void sisctrl_gamma_spin_con_blue_changed(double value);
extern void sisctrl_gamma_spin_con_all_changed(double value);
extern void sisctrl_gamma_get_monitor_gamma(int crtnum);
extern int  sisctrl_gamma_get_sat_crt1();
extern int  sisctrl_gamma_get_sat_crt2();
extern void sisctrl_gamma_set_sat_crt1(int val);
extern void sisctrl_gamma_set_sat_crt2(int val);

extern void sisctrl_vi_set_contrast_value(void);
extern void sisctrl_vi_set_brightness_value(void);
extern void sisctrl_vi_set_saturation_value(void);
extern void sisctrl_vi_set_hue_value(void);
extern void sisctrl_vi_set_xv_gamma_status(void);
extern void sisctrl_vi_set_xvgamma_spin_values(void);
extern void sisctrl_vi_set_switchcrt(void);
extern void sisctrl_vi_co_changed(double value);
extern void sisctrl_vi_br_changed(double value);
extern void sisctrl_vi_hu_changed(double value);
extern void sisctrl_vi_sa_changed(double value);
extern void sisctrl_vi_radio_changed(int value);
extern void sisctrl_vi_check_gamma_toggled(int val);
extern void sisctrl_vi_spin1_changed(double value);
extern void sisctrl_vi_spin2_changed(double value);
extern void sisctrl_vi_spin3_changed(double value);
extern void sisctrl_vi_check_video_only_toggled(int val);
extern void sisctrl_vi_global_changed(int val);
extern unsigned long sisctrl_vi_get_colorkey(void);

extern void sisctrl_ab_generate_current(void);

#endif




