/*
 * SiSCtrl - SiS Display Control Panel
 * for the SiS X.org/XFree86 driver
 *
 * Private definitions for MAIN part
 *
 * (C) 2003-2005 Thomas Winischhofer <thomas@winischhofer.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _SISCTRL_H_
#define _SISCTRL_H_

#include "sisctrl_def.h"

char xverrorstring[] = "Failed to set/get Xv property\n";

sc_globals	sc;

gui_look	gl;

/* forward declarations */

static void setxvgammastatus(void);
static void setxvgammasensitive(void);

/* Callbacks from sisctrl_conf.c */

int	getxvval(Atom atom);
int	newgetxvval(unsigned int cmd, Atom atom);
int	sd_gettvscale(unsigned int cmd, Atom atom);
int	sd_readcolorcalib(Atom myatom, Bool IsCoarse);

Bool	isusb(void);
Bool	supportvihuesat(void);
Bool 	vbhavevb(void);
Bool	vbissisbridge(void);
Bool	vbischrontel(void);
Bool	vbsupportsvga2(void);
Bool	vbsupportsscart(void);
Bool	vbsupportstv(void);
Bool	vbsupportsoverscan(void);
Bool	vbsupportstmds(void);
Bool	vbsupportsettvtype(void);
Bool	vbsupportgamma2(void);
Bool	vbsupporttvedgeenhance(void);
Bool	vbsupporttvsaturation(void);
Bool	vbsupporttvsize(void);

/* Callbacks from GUI part */

Bool sisctrl_xinerama_query_screen(int screennum, char **chip, int *crtnum, Bool *IsSIS);

void sisctrl_delete_event(void);
void sisctrl_destroy_event(void);
void sisctrl_ok_clicked(int what);
int  sisctrl_do_apply(int what);
void sisctrl_revert_clicked(int what);
void sisctrl_close_clicked(void);

void sisctrl_set_disable_gfx(int s1, int s2);
void sisctrl_restore_disable_gfx_lr(void);
void sisctrl_restore_disable_gfx(void);

int  sisctrl_checkmodeforcrtx(int crt2, int devindex, int modeindex, int stdindex, int ypindex);

Bool sisctrl_get_mfb_devices(int index, int rotindex,
		int *leftdev, int *rightdev, int *topdev, int *bottomdev, int *rot, Bool *cloned);

void sisctrl_xrandreventhandler(void);

void sisctrl_gl_display_mode_page_selected(void);
void sisctrl_gl_crt1_page_selected(void);
void sisctrl_gl_crt2_page_selected(void);
void sisctrl_gl_gamma_page_selected(void);
void sisctrl_gl_tv_page_selected(void);
void sisctrl_gl_video_page_selected(void);
void sisctrl_gl_current_page_selected(int hints);

void sisctrl_gl_crt1_page_deselected(void);
void sisctrl_gl_crt2_page_deselected(void);

int  sisctrl_dm_get_current_mode_index(void);
void sisctrl_dm_update_leaveunchanged(void);
void sisctrl_dm_selection_changed(int index, int rotindex,
		char *leftdev, char *leftcrt, char *leftcrtnum, char *leftres, char *lefthz,
		char *rightdev, char *rightcrt, char *rightcrtnum, char *rightres, char *righthz,
		int *left_crt_num, int *right_crt_num, char *lefthz2, char *righthz2,
		Bool *cloned);
unsigned short sisctrl_dm_get_modefield(int index);

void sisctrl_crt1_redetect_devices(void);
void sisctrl_crt1_activate_redetection_result(void);

void sisctrl_crt2_show_detected_only_changed(void);
void sisctrl_crt2_redetect_devices(void);

int  sisctrl_get_current_crt1type_index(void);
int  sisctrl_get_lcd_scaling_history(void);
int  sisctrl_get_lcd_center_history(void);

void sisctrl_crt2_show_initial_crt2_type_menu(void);
void sisctrl_crt2_set_initial_crt2_type_history(void);
void sisctrl_crt2_set_initial_tv_std(void);
void sisctrl_crt2_set_initial_signal_type(void);
void sisctrl_crt2_set_initial_aspect_ratio(void);

void sisctrl_gamma_set_status(void);
void sisctrl_gamma_set_all_spinvalues(void);
void sisctrl_gamma_enable_1(int checked);
void sisctrl_gamma_enable_2(int checked);
void sisctrl_gamma_separate_changed(int checked);
void sisctrl_gamma_separate_toggled(int checked);
void sisctrl_gamma_spin_red_changed(double value);
void sisctrl_gamma_spin_green_changed(double value);
void sisctrl_gamma_spin_blue_changed(double value);
void sisctrl_gamma_spin_all_changed(double value);
void sisctrl_gamma_spin_bri_red_changed(double value);
void sisctrl_gamma_spin_bri_green_changed(double value);
void sisctrl_gamma_spin_bri_blue_changed(double value);
void sisctrl_gamma_spin_bri_all_changed(double value);
void sisctrl_gamma_spin_con_red_changed(double value);
void sisctrl_gamma_spin_con_green_changed(double value);
void sisctrl_gamma_spin_con_blue_changed(double value);
void sisctrl_gamma_spin_con_all_changed(double value);
void sisctrl_gamma_get_monitor_gamma(int crtnum);
int  sisctrl_gamma_get_sat_crt1();
int  sisctrl_gamma_get_sat_crt2();
void sisctrl_gamma_set_sat_crt1(int val);
void sisctrl_gamma_set_sat_crt2(int val);

void sisctrl_tv_antiflicker_set_history(void);
void sisctrl_tv_col_calib_set_c_value(void);
void sisctrl_tv_col_calib_set_f_value(void);
void sisctrl_tv_saturation_set_value(void);
void sisctrl_tv_edgeenhance_set_value(void);
void sisctrl_tv_c_filter_set_value(void);
void sisctrl_tv_y_filter_set_value(void);
void sisctrl_tv_ch_contrast_set_value(void);
void sisctrl_tv_ch_textenhance_set_value(void);
void sisctrl_tv_ch_chromaff_set_value(void);
void sisctrl_tv_ch_lumaff_set_value(void);
void sisctrl_tv_ch_cvbscol_set_value(void);
void sisctrl_tv_de_clicked(void);
void sisctrl_tv_up_clicked(void);
void sisctrl_tv_dn_clicked(void);
void sisctrl_tv_le_clicked(void);
void sisctrl_tv_ri_clicked(void);
void sisctrl_tv_xm_clicked(void);
void sisctrl_tv_xp_clicked(void);
void sisctrl_tv_ym_clicked(void);
void sisctrl_tv_yp_clicked(void);
void sisctrl_tp_af_changed(int index);
void sisctrl_tp_sa_changed(double value);
void sisctrl_tp_ee_changed(double value);
void sisctrl_tp_col_calib_changed(double valc, double valf);
void sisctrl_tp_check_cfi_toggled(int val);
void sisctrl_tp_yfi_changed(int index);
void sisctrl_tp_co_changed(double value);
void sisctrl_tp_te_changed(double value);
void sisctrl_tp_cf_changed(double value);
void sisctrl_tp_lf_changed(double value);
void sisctrl_tp_check_col_toggled(int val);

void sisctrl_vi_set_contrast_value(void);
void sisctrl_vi_set_brightness_value(void);
void sisctrl_vi_set_saturation_value(void);
void sisctrl_vi_set_hue_value(void);
void sisctrl_vi_set_xv_gamma_status(void);
void sisctrl_vi_set_xvgamma_spin_values(void);
void sisctrl_vi_set_switchcrt(void);
void sisctrl_vi_co_changed(double value);
void sisctrl_vi_br_changed(double value);
void sisctrl_vi_hu_changed(double value);
void sisctrl_vi_sa_changed(double value);
void sisctrl_vi_radio_changed(int value);
void sisctrl_vi_check_gamma_toggled(int val);
void sisctrl_vi_spin1_changed(double value);
void sisctrl_vi_spin2_changed(double value);
void sisctrl_vi_spin3_changed(double value);
void sisctrl_vi_check_video_only_toggled(int val);
void sisctrl_vi_global_changed(int val);
unsigned long sisctrl_vi_get_colorkey(void);

void sisctrl_ab_generate_current(void);

extern Bool gui_xinerama_chooser(int maxscreens, int *newscreen);

extern Bool gui_confirmation_popup(void);

/* "Current page" routines (in sisctrl_conf.c) */

extern void cf_generate_current(int hints);

/* Our GUI routines */

extern void gui_init(int *argc, char ***argv);
extern void gui_main(void);
extern void gui_clean_ups(void);
extern void gui_main_quit(void);

extern void gui_showerror(char *message);
extern Bool gui_showerror_pregui(char *message, Bool yesno, Bool warning);

#ifdef USEXV
extern void gui_destroy_xv_image(void);
#endif

extern void gui_build_gui(void);
extern void gui_enable_revert_button(int enable);

extern int  gui_dm_get_current_selected_mode(void);
extern void gui_dm_create_gfx(void);
extern void gui_dm_set_mode_list_attributes(int listindex, unsigned short field);
extern void gui_dm_set_current_entry(int index);
#ifdef HAVE_RANDR
extern int  gui_dm_get_current_randr_index(void);
extern void gui_dm_set_current_randr_index(int index);
extern int  gui_dm_get_current_randr_rot_index(void);
extern void gui_dm_set_current_randr_rot_index(int index);
extern void gui_dm_update_leaveunchanged(char *newtext, char *newrottext);
#endif
extern void gui_dm_remove_mode_list_and_randr_sizes(void);
extern void gui_dm_rebuild_mode_list_and_randr_sizes(void);

extern void gui_crt1_show_variant(int variant);
extern void gui_crt1_set_type_menu_index(int index);
extern int  gui_crt1_get_type_menu_index(void);
extern void gui_crt1_select_gfx(int gfxnum);
extern void gui_crt1_set_scaling_menu_index(int index);
extern int  gui_crt1_get_scaling_menu_index(int retdefault);
extern void gui_crt1_show_scaling_menu_and_label(void);
extern void gui_crt1_hide_scaling_menu_and_label(void);
extern void gui_crt1_set_centering_menu_index(int index);
extern int  gui_crt1_get_centering_menu_index(int retdefault);
extern void gui_crt1_show_center_menu(void);
extern void gui_crt1_hide_center_menu(void);

extern void gui_crt2_set_type_menu_index(int index);
extern int  gui_crt2_get_type_menu_index(void);
extern void gui_crt2_hide_crt2_menu_items(void);
extern void gui_crt2_show_crt2_menu_item(int index);
extern void gui_crt2_finished_show_crt2_menu_items(void);
extern void gui_crt2_select_gfx(int gfxnum);
extern void gui_crt2_set_scaling_menu_index(int index);
extern int  gui_crt2_get_scaling_menu_index(int retdefault);
extern void gui_crt2_show_scaling_menu_and_label(void);
extern void gui_crt2_hide_scaling_menu_and_label(void);
extern void gui_crt2_set_centering_menu_index(int index);
extern int  gui_crt2_get_centering_menu_index(int retdefault);
extern void gui_crt2_show_center_menu(void);
extern void gui_crt2_hide_center_menu(void);
extern void gui_crt2_set_tvstd_menu_index(int index);
extern int  gui_crt2_get_tvstd_menu_index(void);
extern void gui_crt2_show_tvstd_menu_and_label(void);
extern void gui_crt2_hide_tvstd_menu_and_label(void);
extern void gui_crt2_set_signal_menu_index(int index);
extern int  gui_crt2_get_signal_menu_index(void);
extern void gui_crt2_show_signal_menu_and_label(void);
extern void gui_crt2_hide_signal_menu_and_label(void);
extern void gui_crt2_set_aspect_menu_index(int index);
extern int  gui_crt2_get_aspect_menu_index(void);
extern void gui_crt2_show_aspect_menu_and_label(void);
extern void gui_crt2_hide_aspect_menu_and_label(void);
extern void gui_crt2_set_overscan_menu_index(int index);
extern int  gui_crt2_get_overscan_menu_index(void);
extern void gui_crt2_show_overscan_menu(void);
extern void gui_crt2_hide_overscan_menu(void);
extern void gui_crt2_show_overscan_superover_menu_item(void);
extern void gui_crt2_hide_overscan_superover_menu_item(void);
extern int  gui_crt2_show_detected_devices_checked(void);

extern void gui_show_lcd_menus(int pagenum);

extern void gui_gamma_set_all_spin_values(double s1, double s2, double s3,
				   double s4, double s5, double s6,
				   double s7, double s8, double s9);
extern void gui_gamma_set_gamma_enabled_check_box_stati(int b1, int b2);
extern void gui_gamma_show_separate_gamma_menu(void);
extern void gui_gamma_hide_separate_gamma_menu(void);
extern int  gui_gamma_get_active_separate_menu_item(void);
extern void gui_gamma_set_active_separate_menu_item(int index);
#if 0
extern void gui_gamma_show_separate_gamma_radio_buttons(void);
extern void gui_gamma_hide_separate_gamma_radio_buttons(void);
extern void gui_gamma_enable_and_activate_separate_gamma_check_box(int active);
extern void gui_gamma_disable_separate_gamma_check_box(void);
extern int  gui_gamma_get_active_separate_gamma_radio(void);
#endif
extern void gui_gamma_drawggfx(void);
extern void gui_gamma_update_gamma_gfx(void);
extern void gui_gamma_update_gamma_pattern_menu(void);

extern void gui_tv_antiflicker_enable_and_set_menu_index(int enable, int index);
extern void gui_tv_colorcalib_c_enable_and_set_value(int enable, double value);
extern void gui_tv_colorcalib_f_enable_and_set_value(int enable, double value);
extern void gui_tv_saturation_enable_and_set_value(int enable, double value);
extern void gui_tv_edgeenhance_enable_and_set_value(int enable, double value);
extern void gui_tv_filter_c_enable_and_set_value(int enable, int value);
extern void gui_tv_filter_y_enable_and_set_value(int enable, int index);
extern void gui_tv_chrontel_slider_set_value(int slider, int enable, double value);
extern void gui_tv_chrontel_cvbscolor_set_value(int enable, int val);

extern void gui_vi_slider_set_value(int slider, double value);
extern int  gui_vi_get_xv_shown(void);
extern void gui_vi_enable_and_set_xv_gamma_check(int enable, int active);
extern void gui_vi_enable_xvgamma_spins(int enable);
extern void gui_vi_set_xvgamma_spins(double s1, double s2, double s3);
extern void gui_vi_enable_switchcrt(int enable);
extern void gui_vi_set_switchcrt_active_num(int num);
extern void gui_vi_set_video_only_value(int active);

extern void gui_ab_clear_text(void);
extern void gui_ab_append_text(char *mytext, int texttag);

#endif


