/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : TextEntrySysListener.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "../include/mhgui/TextEntrySysListener.h"
#include "../include/mhgui/CGUtilities.h"
#include "../include/mhgui/TextEntry.h"

#include <cstdio>
#include <cassert>

#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

#include <iostream>

using namespace Animorph;
using namespace std;

namespace mhgui {

TextEntrySysListener::TextEntrySysListener()
    : AbstractListener()
{
}

TextEntrySysListener::~TextEntrySysListener()
{
}

bool TextEntrySysListener::mouseOver (const Point& inMousePos, Component *source)
{
  cgutils::redisplay();

  return false;
}

bool TextEntrySysListener::mouseOut (const Point& inMousePos, Component *source)
{
  cgutils::redisplay();

  return false;
}

bool TextEntrySysListener::mouseDragged (const Point& inMousePos, Component *source)
{
  return false;
}

bool TextEntrySysListener::mousePressed(const Point& inMousePos, int button, Component *source)
{
  TextEntry *textSource = dynamic_cast<TextEntry *>(source); // req. RTTI!
  assert(textSource); // Check if this is really an TextEntry object?

  textSource->setActive(true);
  textSource->setClickConsumed(false);

  return false;
}

bool TextEntrySysListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  TextEntry *textSource = dynamic_cast<TextEntry *>(source); // req. RTTI!
  assert(textSource); // Check if this is really an TextEntry object?

  textSource->setActive(true);
  textSource->setClickConsumed(false);

  return false;
}

bool TextEntrySysListener::keyType (unsigned char key, Component *source)
{
  TextEntry *textSource = dynamic_cast<TextEntry *>(source); // req. RTTI!
  assert(textSource); // Check if this is really an TextEntry object?
  //cerr << (int)key << endl;

  switch(key)
  {
  case 127:
    cerr << "delete forward -> not yet implemented" << endl;
    return true;
    break;
  case '\b':
    textSource->removeChar ();
    return true;
    break;
  default:
    // don't react on return
    if (key != 13)
    {
      textSource->addChar (key);
    }
    return true;
    break;
  }

  return false;
}

} // namespace mhgui

