/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : ImageSliderSysListener.cpp
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#include "../include/mhgui/ImageSliderSysListener.h"
#include "../include/mhgui/CGUtilities.h"
#include "../include/mhgui/ImageSlider.h"

#include <cstdio>
#include <cassert>

#ifdef __APPLE__
  #include <GLUT/glut.h>
#else
  #ifdef USE_FREEGLUT     
    #include <GL/freeglut.h>
  #else
    #include <GL/glut.h>
  #endif
#endif

#include <iostream>

using namespace Animorph;
using namespace std;

namespace mhgui {

ImageSliderSysListener::ImageSliderSysListener()
    : AbstractListener()
{
}

ImageSliderSysListener::~ImageSliderSysListener()
{
}

bool ImageSliderSysListener::mouseOver (const Point& inMousePos, Component *source)
{
  cgutils::redisplay();
  return false;
}

bool ImageSliderSysListener::mouseOut (const Point& inMousePos, Component *source)
{
  cgutils::redisplay();
  return false;
}

bool ImageSliderSysListener::mouseDragged (const Point& inMousePos, Component *source)
{
  ImageSlider *imgSliderSource = dynamic_cast<ImageSlider *>(source); // req. RTTI!
  assert(imgSliderSource); // Check if this is really an ImageSlider object?

  if(inMousePos.getX() > imgSliderSource->getOldMouseX() && imgSliderSource->getSliderValue() < imgSliderSource->getMaxValue())
  {
    imgSliderSource->increaseValue(inMousePos.getX() - imgSliderSource->getOldMouseX());
    imgSliderSource->setOldMouseX(inMousePos.getX());
    cgutils::redisplay();
  }
  else if(inMousePos.getX() < imgSliderSource->getOldMouseX() && imgSliderSource->getSliderValue() > imgSliderSource->getMinValue())
  {
    imgSliderSource->decreaseValue(imgSliderSource->getOldMouseX() - inMousePos.getX());
    imgSliderSource->setOldMouseX(inMousePos.getX());
    cgutils::redisplay();
  }

  return true;
}

bool ImageSliderSysListener::mousePressed(const Point& inMousePos, int button, Component *source)
{
  if(button == GLUT_LEFT_BUTTON)
  {
    ImageSlider *imgSliderSource = dynamic_cast<ImageSlider *>(source); // req. RTTI!
    assert(imgSliderSource); // Check if this is really an ImageSlider object?

    imgSliderSource->setActive (true);
    imgSliderSource->setOldMouseX (inMousePos.getX());
    return true;
  }
  return false;
}

bool ImageSliderSysListener::mouseReleased (const Point& inMousePos, int button, Component *source)
{
  if(button == GLUT_LEFT_BUTTON)
  {
    ImageSlider *imgSliderSource = dynamic_cast<ImageSlider *>(source); // req. RTTI!
    assert(imgSliderSource); // Check if this is really an ImageSlider object?
    if(imgSliderSource->isActive ())
    {
      imgSliderSource->setActive( false);
      imgSliderSource->setOldMouseX (0);
      return true;
    }
  }
  return false;
}

bool ImageSliderSysListener::keyType (unsigned char key, Component *source)
{
  return false;
}

} // namespace mhgui

