<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: CurrencyList.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('currency','enabled')
		OR !( $permission->Check('currency','view') OR $permission->Check('currency','view_own') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

//Debug::setVerbosity(11);

$smarty->assign('title', TTi18n::gettext($title = 'Currency List') );

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'ids'
												) ) );

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'sort_column' => $sort_column,
													'sort_order' => $sort_order,
													'page' => $page
												) );

$sort_array = NULL;
if ( $sort_column != '' ) {
	$sort_array = array($sort_column => $sort_order);
}

Debug::Arr($ids,'Selected Objects', __FILE__, __LINE__, __METHOD__,10);

$action = Misc::findSubmitButton();
switch ($action) {
	case 'update_rates':
		CurrencyFactory::updateCurrencyRates( $current_company->getId() );

		Redirect::Page( URLBuilder::getURL(NULL, 'CurrencyList.php') );
		break;
	case 'add':
		Redirect::Page( URLBuilder::getURL(NULL, 'EditCurrency.php') );
		break;
	case 'delete' OR 'undelete':
		if ( strtolower($action) == 'delete' ) {
			$delete = TRUE;
		} else {
			$delete = FALSE;
		}

		$clf = new CurrencyListFactory();

		if ( isset($ids) AND is_array($ids) ) {
			foreach ($ids as $id) {
				$clf->getByIdAndCompanyId($id, $current_company->getId() );
				foreach ($clf as $c_obj) {
					$c_obj->setDeleted($delete);
					$c_obj->Save();
				}
			}
		}

		Redirect::Page( URLBuilder::getURL(NULL, 'CurrencyList.php') );

		break;

	default:
		BreadCrumb::setCrumb($title);
		$clf = new CurrencyListFactory();

		$clf->getByCompanyId($current_company->getId(), $current_user_prefs->getItemsPerPage(),$page, NULL, $sort_array );

		$pager = new Pager($clf);

		$iso_code_options = $clf->getISOCodesArray();

		$base_currency = FALSE;
		foreach ($clf as $c_obj) {
			if ( $c_obj->getBase() === TRUE ) {
				$base_currency = TRUE;
			}
			$rows[] = array(
								'id' => $c_obj->GetId(),
								'status_id' => $c_obj->getStatus(),
								'name' => $c_obj->getName(),
								'iso_code' => $c_obj->getISOCode(),
								'currency_name' => Option::getByKey($c_obj->getISOCode(), $iso_code_options ),
								'conversion_rate' => $c_obj->getConversionRate(),
								'auto_update' => $c_obj->getAutoUpdate(),
								'is_base' => $c_obj->getBase(),
								'is_default' => $c_obj->getDefault(),
								'deleted' => $c_obj->getDeleted()
							);

		}
		$smarty->assign_by_ref('currencies', $rows);
		$smarty->assign_by_ref('base_currency', $base_currency);

		$smarty->assign_by_ref('sort_column', $sort_column );
		$smarty->assign_by_ref('sort_order', $sort_order );

		$smarty->assign_by_ref('paging_data', $pager->getPageVariables() );

		break;
}
$smarty->display('currency/CurrencyList.tpl');
?>