<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1457 $
 * $Id: AL.class.php 1457 2007-11-20 18:45:13Z ipso $
 * $Date: 2007-11-20 10:45:13 -0800 (Tue, 20 Nov 2007) $
 */
class PayrollDeduction_US_AL extends PayrollDeduction_US {
/*
	protected $state_al_filing_status_options = array(
														10 => 'Status "S" Claiming $1500',
														20 => 'Status "M" Claiming $3000',
														30 => 'Status "0"',
														40 => 'Head of Household'
														50 => 'Status "MS"'
									);
*/

	var $state_options = array(
								1167638400 => array(
													'standard_deduction_rate' => 0,
													'standard_deduction_maximum' => array(
																				'10' => array(
																							//1 = Deduction
																							//2 = Reduce By
																							//3 = Reduce by for every amount over the prev income level.
																							//4 = Previous Income
																							0 => array(20000, 2500, 0, 0, 0),
																							1 => array(30000, 2500, 25, 500, 20000),
																							2 => array(30000, 2000, 0, 0, 30000)
																							),
																				'20' => array(
																							0 => array(20000, 7500, 0, 0, 0),
																							1 => array(30000, 7500, 175, 500, 20000),
																							2 => array(30000, 4000, 0, 0, 30000)
																							),
																				'30' => array(
																							0 => array(20000, 2500, 0, 0, 0),
																							1 => array(30000, 2500, 25, 500, 20000),
																							2 => array(30000, 2000, 0, 0, 30000)
																							),
																				'40' => array(
																							0 => array(20000, 4700, 0, 0, 0),
																							1 => array(30000, 4700, 135, 500, 20000),
																							2 => array(30000, 2000, 0, 0, 30000)
																							),
																				'50' => array(
																							0 => array(10000, 3750, 0, 0, 0),
																							1 => array(15000, 3750, 88, 250, 10000),
																							2 => array(15000, 2000, 0, 0, 15000)
																							),
																				),
													'personal_deduction' => array(
																				'10' => 1500,
																				'20' => 3000,
																				'30' => 0,
																				'40' => 3000,
																				'50' => 1500,
																				),

													'dependant_allowance' => array(
																				0 => array(20000, 1000),
																				1 => array(100000, 500),
																				2 => array(100000, 300)
																				)
													),
								1136102400 => array(
													'standard_deduction_rate' => 20,
													'standard_deduction_maximum' => array(
																				'10' => 2000,
																				'20' => 4000,
																				'30' => 2000,
																				'40' => 2000,
																				'50' => 2000,
																				),
													'personal_deduction' => array(
																				'10' => 1500,
																				'20' => 3000,
																				'30' => 0,
																				'40' => 3000,
																				'50' => 1500
																				),

													'dependant_allowance' => 300
													)
								);

	function getStatePayPeriodDeductions() {
		return bcdiv($this->getStateTaxPayable(), $this->getAnnualPayPeriods() );
	}

	function getStateAnnualTaxableIncome() {
		$annual_income = $this->getAnnualTaxableIncome();
		$federal_tax = $this->getFederalTaxPayable();
		$standard_deduction = $this->getStateStandardDeduction();
		$personal_deduction = $this->getStatePersonalDeduction();
		$dependant_allowance = $this->getStateDependantAllowanceAmount();

		Debug::text('Federal Annual Tax: '. $federal_tax, __FILE__, __LINE__, __METHOD__,10);
		Debug::text('Standard Deduction: '. $standard_deduction, __FILE__, __LINE__, __METHOD__,10);
		Debug::text('Personal Deduction: '. $personal_deduction, __FILE__, __LINE__, __METHOD__,10);
		Debug::text('Dependant Allowance: '. $dependant_allowance, __FILE__, __LINE__, __METHOD__,10);

		$income = bcsub( bcsub( bcsub( bcsub( $annual_income, $standard_deduction), $personal_deduction), $dependant_allowance), $federal_tax);

		Debug::text('State Annual Taxable Income: '. $income, __FILE__, __LINE__, __METHOD__,10);

		return $income;
	}

	function getDataByIncome( $income, $arr ) {
		if ( !is_array($arr) ) {
			return FALSE;
		}

		$prev_value = 0;
		$total_rates = count($arr) - 1;
		$i=0;
		foreach( $arr as $key => $values ) {
			if ($this->getAnnualTaxableIncome() > $prev_value AND $this->getAnnualTaxableIncome() <= $values[0]) {
				return $values;
			} elseif ($i == $total_rates) {
				return $values;
			}
			$prev_value = $values[0];
			$i++;
		}

		return FALSE;
	}

	function getStateStandardDeduction() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		if ( $this->getDate() >= 1167638400 ) {
			Debug::text('Standard Deduction Formula (NEW)', __FILE__, __LINE__, __METHOD__,10);
			$deduction_arr = $this->getDataByIncome( $this->getAnnualTaxableIncome(), $retarr['standard_deduction_maximum'][$this->getStateFilingStatus()] );
			
			if ( $deduction_arr[3] > 0 ) {
				Debug::text('Complex Standard Deduction Formula (NEW)', __FILE__, __LINE__, __METHOD__,10);
				//Find out how far we're over the previous income level.
				$deduction = bcsub( $deduction_arr[1], bcmul( ceil( bcdiv( bcsub($this->getAnnualTaxableIncome(), $deduction_arr[4]), $deduction_arr[3] ) ), $deduction_arr[2] ) );
			} else {
				Debug::text('Basic Standard Deduction Formula (NEW)', __FILE__, __LINE__, __METHOD__,10);
				$deduction = $deduction_arr[1];
			}
		} else {
			Debug::text('Standard Deduction Forumla (OLD)', __FILE__, __LINE__, __METHOD__,10);
			$rate = bcdiv( $retarr['standard_deduction_rate'], 100 );

			$deduction = bcmul( $this->getAnnualTaxableIncome(), $rate);

			if ( $deduction >= $retarr['standard_deduction_maximum'][$this->getStateFilingStatus()] ) {
				$deduction = $retarr['standard_deduction_maximum'][$this->getStateFilingStatus()];
			}
		}

		Debug::text('Standard Deduction: '. $deduction .' Filing Status: '. $this->getStateFilingStatus() , __FILE__, __LINE__, __METHOD__,10);

		return $deduction;
	}

	function getStatePersonalDeduction() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;

		}

		$deduction = $retarr['personal_deduction'][$this->getStateFilingStatus()];

		Debug::text('Personal Deduction: '. $deduction .' Filing Status: '. $this->getStateFilingStatus() , __FILE__, __LINE__, __METHOD__,10);

		return $deduction;
	}

	function getStateDependantAllowanceAmount() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;

		}

		if ( $this->getDate() >= 1167638400 ) {
			$allowance_arr = $this->getDataByIncome( $this->getAnnualTaxableIncome(), $retarr['dependant_allowance'] );
			$allowance = $allowance_arr[1];
		} else {
			$allowance = $retarr['dependant_allowance'];
		}

		$retval = bcmul($allowance, $this->getUserValue2() );

		Debug::text('State Dependant Allowance Amount: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getStateTaxPayable() {
		$annual_income = $this->getStateAnnualTaxableIncome();

		$retval = 0;
		if ( $annual_income > 0 ) {
			$rate = $this->getData()->getStateRate($annual_income);
			$state_constant = $this->getData()->getStateConstant($annual_income);
			$state_rate_income = $this->getData()->getStateRateIncome($annual_income);

			Debug::text('Rate: '. $rate .' Constant: '. $state_constant .' Rate Income: '. $state_rate_income, __FILE__, __LINE__, __METHOD__,10);
			$retval = bcadd( bcmul( bcsub( $annual_income, $state_rate_income ), $rate ), $state_constant );
		}

		if ( $retval < 0 ) {
			$retval = 0;
		}

		Debug::text('State Annual Tax Payable: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}
}
?>
