<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1375 $
 * $Id: PolicyGroupListFactory.class.php 1375 2007-11-01 23:24:56Z ipso $
 * $Date: 2007-11-01 16:24:56 -0700 (Thu, 01 Nov 2007) $
 */
class PolicyGroupListFactory extends PolicyGroupFactory implements IteratorAggregate {

	function getAll($limit = NULL, $page = NULL, $where = NULL, $order = NULL) {
		$query = '
					select 	*
					from	'. $this->getTable() .'
					WHERE deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		if ($limit == NULL) {
			//Run query without limit
			$this->rs = $this->db->SelectLimit($query);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page);
		}

		return $this;
	}

	function getById($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	id = ?
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByIdAndCompanyId($id, $company_id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $company_id == '') {
			return FALSE;
		}

		$ph = array(
					'id' => $id,
					'company_id' => $company_id
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	id = ?
						AND company_id = ?
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByUserIds($ids, $where = NULL, $order = NULL) {
		if ( $ids == '') {
			return FALSE;
		}
/*
		if ( $order == NULL ) {
			$order = array( 'type_id' => 'asc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}
*/
		$pguf = new PolicyGroupUserFactory();

		$ph = array();

		$query = '
					select 	a.*,
							b.user_id as user_id
					from	'. $this->getTable() .' as a,
							'. $pguf->getTable() .' as b
					where 	a.id = b.policy_group_id
						AND b.user_id in  ('. $this->getListSQL($ids, $ph) .')
						AND a.deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);
	}

	function getByCompanyIdAndUserId($company_id, $user_ids, $where = NULL, $order = NULL) {
		if ( $company_id == '') {
			return FALSE;
		}

		if ( $user_ids == '') {
			return FALSE;
		}
/*
		if ( $order == NULL ) {
			$order = array( 'type_id' => 'asc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}
*/
		$pguf = new PolicyGroupUserFactory();

		$ph = array( 'company_id' => $company_id );

		$query = '
					select 	a.*,
							b.user_id as user_id
					from	'. $this->getTable() .' as a,
							'. $pguf->getTable() .' as b
					where 	a.id = b.policy_group_id
						AND a.company_id = ? ';

		if ( $user_ids AND is_array($user_ids) AND isset($user_ids[0]) ) {
			$query  .=	' AND b.user_id in ('. $this->getListSQL($user_ids, $ph) .') ';
		}

		$query .= '	AND a.deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);
	}

	function getByCompanyId($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}
/*
		if ( $order == NULL ) {
			$order = array( 'type_id' => 'asc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}
*/
		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .' as a
					where	company_id = ?
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);
	}

	function getSearchByCompanyIdAndArrayCriteria( $company_id, $filter_data, $limit = NULL, $page = NULL, $where = NULL, $order = NULL ) {
		if ( $company_id == '') {
			return FALSE;
		}

		if ( !is_array($order) ) {
			//Use Filter Data ordering if its set.
			if ( isset($filter_data['sort_column']) AND $filter_data['sort_order']) {
				$order = array(Misc::trimSortPrefix($filter_data['sort_column']) => $filter_data['sort_order']);
			}
		}

		$additional_order_fields = array();
		if ( $order == NULL ) {
			//$order = array( 'status_id' => 'asc', 'last_name' => 'asc', 'first_name' => 'asc', 'middle_name' => 'asc');
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}
		//Debug::Arr($order,'Order Data:', __FILE__, __LINE__, __METHOD__,10);
		//Debug::Arr($filter_data,'Filter Data:', __FILE__, __LINE__, __METHOD__,10);

		$pguf = new PolicyGroupUserFactory();
		$pgripf = new PolicyGroupRoundIntervalPolicyFactory();
		$pgotpf = new PolicyGroupOverTimePolicyFactory();
		$pgppf = new PolicyGroupPremiumPolicyFactory();
		$pgapf = new PolicyGroupAccrualPolicyFactory();

		$ph = array(
					'company_id' => $company_id,
					);

		$query = '
					select 	distinct a.*
					from 	'. $this->getTable() .' as a
						LEFT JOIN '. $pguf->getTable() .' as b ON a.id = b.policy_group_id
						LEFT JOIN '. $pgripf->getTable() .' as c ON a.id = c.policy_group_id
						LEFT JOIN '. $pgotpf->getTable() .' as d ON a.id = d.policy_group_id
						LEFT JOIN '. $pgppf->getTable() .' as e ON a.id = e.policy_group_id
						LEFT JOIN '. $pgapf->getTable() .' as f ON a.id = f.policy_group_id
					where	a.company_id = ?
					';

		if ( isset($filter_data['id']) AND isset($filter_data['id'][0]) AND !in_array(-1, (array)$filter_data['id']) ) {
			$query  .=	' AND a.id in ('. $this->getListSQL($filter_data['id'], $ph) .') ';
		}
		if ( isset($filter_data['exception_policy_control_id']) AND isset($filter_data['exception_policy_control_id'][0]) AND !in_array(-1, (array)$filter_data['exception_policy_control_id']) ) {
			$query  .=	' AND a.exception_policy_control_id in ('. $this->getListSQL($filter_data['exception_policy_control_id'], $ph) .') ';
		}
		if ( isset($filter_data['holiday_policy_id']) AND isset($filter_data['holiday_policy_id'][0]) AND !in_array(-1, (array)$filter_data['holiday_policy_id']) ) {
			$query  .=	' AND a.holiday_policy_id in ('. $this->getListSQL($filter_data['holiday_policy_id'], $ph) .') ';
		}
		if ( isset($filter_data['user_policy_id']) AND isset($filter_data['user_policy_id'][0]) AND !in_array(-1, (array)$filter_data['user_policy_id']) ) {
			$query  .=	' AND b.user_policy_id in ('. $this->getListSQL($filter_data['user_policy_id'], $ph) .') ';
		}
		if ( isset($filter_data['round_interval_policy_id']) AND isset($filter_data['round_interval_policy_id'][0]) AND !in_array(-1, (array)$filter_data['round_interval_policy_id']) ) {
			$query  .=	' AND c.round_interval_policy_id in ('. $this->getListSQL($filter_data['round_interval_policy_id'], $ph) .') ';
		}
		if ( isset($filter_data['over_time_policy_id']) AND isset($filter_data['over_time_policy_id'][0]) AND !in_array(-1, (array)$filter_data['over_time_policy_id']) ) {
			$query  .=	' AND d.over_time_policy_id in ('. $this->getListSQL($filter_data['over_time_policy_id'], $ph) .') ';
		}
		if ( isset($filter_data['premium_policy_id']) AND isset($filter_data['premium_policy_id'][0]) AND !in_array(-1, (array)$filter_data['premium_policy_id']) ) {
			$query  .=	' AND e.premium_policy_id in ('. $this->getListSQL($filter_data['premium_policy_id'], $ph) .') ';
		}
		if ( isset($filter_data['accrual_policy_id']) AND isset($filter_data['accrual_policy_id'][0]) AND !in_array(-1, (array)$filter_data['accrual_policy_id']) ) {
			$query  .=	' AND f.accrual_policy_id in ('. $this->getListSQL($filter_data['accrual_policy_id'], $ph) .') ';
		}

		$query .= 	'
						AND a.deleted = 0
					';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict, $additional_order_fields );

		if ($limit == NULL) {
			$this->rs = $this->db->Execute($query, $ph);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page, $ph);
		}

		return $this;
	}


	function getByCompanyIdArray($company_id, $include_blank = TRUE) {

		$pglf = new PolicyGroupListFactory();
		$pglf->getByCompanyId($company_id);

		if ( $include_blank == TRUE ) {
			$list[0] = '--';
		}

		foreach ($pglf as $pg_obj) {
			$list[$pg_obj->getID()] = $pg_obj->getName();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}

	function getUserToPolicyGroupMapArrayByListFactory( $lf ) {
		if ( !is_object($lf) ) {
			return FALSE;
		}

		foreach ($lf as $obj) {
			$retarr[$obj->getColumn('user_id')] = $obj->getId();
		}

		if ( isset($retarr) ) {
			return $retarr;
		}

		return FALSE;
	}
}
?>
