<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 417 $
 * $Id: InstallSchema_1007A.class.php 417 2006-12-06 22:58:53Z ipso $
 * $Date: 2006-12-06 14:58:53 -0800 (Wed, 06 Dec 2006) $
 */
class InstallSchema_1007A extends InstallSchema_Base {

	function preInstall() {
		Debug::text('preInstall: '. $this->getVersion() , __FILE__, __LINE__, __METHOD__,9);

		return TRUE;
	}


	function postInstall() {
		Debug::text('postInstall: '. $this->getVersion(), __FILE__, __LINE__, __METHOD__,9);

		//New Pay Period Schedule format, update any current schedules.
		$ppslf = new PayPeriodScheduleListFactory();
		$ppslf->getAll();
		Debug::text('Found Pay Period Schedules: '. $ppslf->getRecordCount(), __FILE__, __LINE__, __METHOD__,9);
		if ( $ppslf->getRecordCount() > 0 ) {
			foreach( $ppslf as $pps_obj ) {
				if ( $pps_obj->getType() == 10 OR $pps_obj->getType() == 20 ) {
					$pps_obj->setStartDayOfWeek( TTDate::getDayOfWeek( TTDate::strtotime( $pps_obj->getColumn('anchor_date') ) ) );
					$pps_obj->setTransactionDate(  floor( (TTDate::strtotime( $pps_obj->getColumn('primary_transaction_date') ) - TTDate::strtotime(  $pps_obj->getColumn('primary_date') ) ) / 86400 )+1 );
				} elseif (  $pps_obj->getType() == 30 ) {
					$pps_obj->setPrimaryDayOfMonth( TTDate::getDayOfMonth( TTDate::strtotime( $pps_obj->getColumn('anchor_date') ) )+1 );
					if ( $pps_obj->getColumn('primary_transaction_date_ldom') == 1 ) {
						$pps_obj->setPrimaryTransactionDayOfMonth( -1 );
					} else {
						$pps_obj->setPrimaryTransactionDayOfMonth( TTDate::getDayOfMonth( TTDate::strtotime( $pps_obj->getColumn('primary_transaction_date') ) ) );
					}

					$pps_obj->setSecondaryDayOfMonth( TTDate::getDayOfMonth( TTDate::strtotime( $pps_obj->getColumn('primary_date') ) ) );
					if ( $pps_obj->getColumn('secondary_transaction_date_ldom') == 1 ) {
						$pps_obj->setSecondaryTransactionDayOfMonth( -1 );
					} else {
						$pps_obj->setSecondaryTransactionDayOfMonth( TTDate::getDayOfMonth( TTDate::strtotime( $pps_obj->getColumn('secondary_transaction_date') ) ) );
					}
				} elseif ( $pps_obj->getType() == 50 ) {
					$pps_obj->setPrimaryDayOfMonth( TTDate::getDayOfMonth( TTDate::strtotime( $pps_obj->getColumn('anchor_date') ) ) );
					if ( $pps_obj->getColumn('primary_transaction_date_ldom') == 1 ) {
						$pps_obj->setPrimaryTransactionDayOfMonth( -1 );
					} else {
						$pps_obj->setPrimaryTransactionDayOfMonth( TTDate::getDayOfMonth( TTDate::strtotime( $pps_obj->getColumn('primary_transaction_date') ) ) );
					}
				}

				if ( $pps_obj->getColumn('transaction_date_bd') == 1 OR $pps_obj->getColumn('secondary_transaction_date_bd') == 1 ) {
					$pps_obj->setTransactionDateBusinessDay( TRUE );
				}

				if ( $pps_obj->isValid() ) {
					$pps_obj->Save();
				}
			}
		}
		
		return TRUE;

	}
}
?>
