<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1418 $
 * $Id: PermissionControlFactory.class.php 1418 2007-11-16 02:03:02Z ipso $
 * $Date: 2007-11-15 18:03:02 -0800 (Thu, 15 Nov 2007) $
 */
class PermissionControlFactory extends Factory {
	protected $table = 'permission_control';
	protected $pk_sequence_name = 'permission_control_id_seq'; //PK Sequence name

	protected $company_obj = NULL;
	protected $tmp_previous_user_ids = array();

	function getCompanyObject() {
		if ( is_object($this->company_obj) ) {
			return $this->company_obj;
		} else {
			$clf = new CompanyListFactory();
			$this->company_obj = $clf->getById( $this->getCompany() )->getCurrent();

			return $this->company_obj;
		}
	}

	function getCompany() {
		if ( isset($this->data['company_id']) ) {
			return $this->data['company_id'];
		}

		return FALSE;
	}
	function setCompany($id) {
		$id = trim($id);

		$clf = new CompanyListFactory();

		if ( $this->Validator->isResultSetWithRows(	'company',
													$clf->getByID($id),
													TTi18n::gettext('Company is invalid')
													) ) {

			$this->data['company_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function isUniqueName($name) {
		$ph = array(
					'company_id' => $this->getCompany(),
					'name' => $name,
					);

		$query = 'select id from '. $this->getTable() .' where company_id = ? AND name = ? AND deleted=0';
		$permission_control_id = $this->db->GetOne($query, $ph);
		Debug::Arr($permission_control_id,'Unique Permission Control ID: '. $permission_control_id, __FILE__, __LINE__, __METHOD__,10);

		if ( $permission_control_id === FALSE ) {
			return TRUE;
		} else {
			if ($permission_control_id == $this->getId() ) {
				return TRUE;
			}
		}

		return FALSE;
	}
	function getName() {
		return $this->data['name'];
	}
	function setName($name) {
		$name = trim($name);

		if (	$this->Validator->isLength(	'name',
											$name,
											TTi18n::gettext('Name is invalid'),
											2,50)
				AND	$this->Validator->isTrue(	'name',
												$this->isUniqueName($name),
												TTi18n::gettext('Name is already in use')
												)
						) {

			$this->data['name'] = $name;

			return TRUE;
		}

		return FALSE;
	}

	function getDescription() {
		return $this->data['description'];
	}
	function setDescription($description) {
		$description = trim($description);

		if (	$description == ''
				OR $this->Validator->isLength(	'description',
											$description,
											TTi18n::gettext('Description is invalid'),
											1,255) ) {

			$this->data['description'] = $description;

			return TRUE;
		}

		return FALSE;
	}

	function getUser() {
		$pulf = new PermissionUserListFactory();
		$pulf->getByPermissionControlId( $this->getId() );
		foreach ($pulf as $obj) {
			$list[] = $obj->getUser();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setUser($ids) {
		Debug::text('Setting User IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if (is_array($ids) and count($ids) > 0) {
			//Remove any of the selected employees from other permission control objects first.
			//So there we can switch employees from one group to another in a single action.
			$pulf = new PermissionUserListFactory();
			//$pculf->getByCompanyIdAndUserId( $this->getCompany(), $ids );
			$pulf->getByCompanyIdAndUserIdAndNotPermissionControlId( $this->getCompany(), $ids, (int)$this->getId() );
			if ( $pulf->getRecordCount() > 0 ) {
				Debug::text('Found User IDs assigned to another Permission Group, unassigning them!', __FILE__, __LINE__, __METHOD__, 10);
				foreach( $pulf as $pu_obj ) {
					$pu_obj->Delete();
				}
			}
			unset($pulf, $pu_obj);

			$tmp_ids = array();

			$pf = new PermissionFactory();
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$pulf = new PermissionUserListFactory();
				$pulf->getByPermissionControlId( $this->getId() );

				$tmp_ids = array();
				foreach ($pulf as $obj) {
					$id = $obj->getUser();
					Debug::text('Permission Control ID: '. $obj->getPermissionControl() .' ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$this->tmp_previous_user_ids[] = $id;
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			$ulf = new UserListFactory();

			foreach ($ids as $id) {
				if ( isset($ids) AND !in_array($id, $tmp_ids) ) {
					//Remove users from any other permission control object
					//first, otherwise there is a gab where an employee has
					//no permissions, this is especially bad for administrators
					//who are currently logged in.
					$puf = new PermissionUserFactory();
					$puf->setPermissionControl( $this->getId() );
					$puf->setUser( $id );

					$obj = $ulf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'user',
														$puf->Validator->isValid(),
														TTi18n::gettext('Selected employee is invalid, or already assigned to another permission group').' ('. $obj->getFullName() .')' )) {
						$puf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No User IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getPermission() {
		$plf = new PermissionListFactory();
		$plf->getByCompanyIdAndPermissionControlId( $this->getCompany(), $this->getId() );
		if ( $plf->getRecordCount() > 0 ) {
			Debug::Text('Found Permissions: '. $plf->getRecordCount(), __FILE__, __LINE__, __METHOD__,10);
			foreach($plf as $p_obj) {
				$current_permissions[$p_obj->getSection()][$p_obj->getName()] = $p_obj->getValue();
			}

			return $current_permissions;
		}

		return FALSE;
	}
	function setPermission( $permission_arr, $old_permission_arr = array() ) {
		if ( $this->getId() == FALSE ) {
			return FALSE;
		}

		$pf = new PermissionFactory();

		//Don't Delete all previous permissions, do that in the Permission class.
		if ( isset($permission_arr) AND is_array($permission_arr) AND count($permission_arr) > 0 ) {
			foreach ($permission_arr as $section => $permissions) {
				Debug::Text('  Section: '. $section, __FILE__, __LINE__, __METHOD__,10);

				foreach ($permissions as $name => $value) {
					Debug::Text('     Name: '. $name .' - Value: '. $value, __FILE__, __LINE__, __METHOD__,10);
					if ( 	(
							!isset($old_permission_arr[$section][$name])
								OR (isset($old_permission_arr[$section][$name]) AND $value != $old_permission_arr[$section][$name] )
							)
							AND $pf->isIgnore( $section, $name, $this->getCompanyObject()->getProductEdition() ) == FALSE
							) {

						if ( $value == 0 OR $value == 1 ) {
							Debug::Text('    Modifying/Adding Permission: '. $name .' - Value: '. $value, __FILE__, __LINE__, __METHOD__,10);
							$tmp_pf = new PermissionFactory();
							$tmp_pf->setPermissionControl( $this->getId() );
							$tmp_pf->setSection( $section );
							$tmp_pf->setName( $name );
							$tmp_pf->setValue( (int)$value );

							if ( $tmp_pf->isValid() ) {
								$tmp_pf->save();
							}
						}
					} else {
						Debug::Text('     Permission didnt change... Skipping', __FILE__, __LINE__, __METHOD__,10);
					}
				}
			}
		}

		return TRUE;
	}

	function postSave() {
		$pf = new PermissionFactory();

		$clear_cache_user_ids = array_merge( (array)$this->getUser(), (array)$this->tmp_previous_user_ids);
		foreach( $clear_cache_user_ids as $user_id ) {
			$pf->clearCache( $user_id, $this->getCompany() );
		}
	}

	function addLog( $log_action ) {
		return TTLog::addEntry( $this->getId(), $log_action,  TTi18n::getText('Permission Group'), NULL, $this->getTable() );
	}
}
?>
