<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: Exception.class.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
class DBError extends Exception {
   function __construct($e) {
      global $db;

      $db->FailTrans();

      //print_r($e);
      //adodb_pr($e);
      
      //Log database error
      if ( isset($e->message) ) {
         Debug::Text($e->message, __FILE__, __LINE__, __METHOD__,10);
      }      
      
      if ( isset($e->trace) ) {
         $e = strip_tags( adodb_backtrace($e->trace) );
         Debug::Arr( $e, 'Exception...', __FILE__, __LINE__, __METHOD__,10);
      }

      //Dump debug buffer.
      Debug::Display();
      Debug::writeToLog();
      Debug::emailLog();

      Redirect::Page( URLBuilder::getURL( array('exception' => 'DBError'), Environment::getBaseURL().'DownForMaintenance.php') );

      ob_flush();      
      ob_clean();

      exit;
   }
}

class GeneralError extends Exception {
   function __construct($message) {
      global $db;

      //debug_print_backtrace();
      $db->FailTrans();

      echo "======================================================================<br>\n";
      echo "EXCEPTION!<br>\n";
      echo "======================================================================<br>\n";
      echo "<b>Error message: </b>".$message ."<br>\n";
      echo "<b>Error code: </b>".$this->getCode()."<br>\n";
      echo "<b>Script Name: </b>".$this->getFile()."<br>\n";
      echo "<b>Line Number: </b>".$this->getLine()."<br>\n";
      echo "======================================================================<br>\n";
      echo "EXCEPTION!<br>\n";
      echo "======================================================================<br>\n";

      //Dump debug buffer.
      Debug::Display();
      Debug::writeToLog();
      Debug::emailLog();
      ob_flush();
      ob_clean();

      Redirect::Page( URLBuilder::getURL( array('exception' => 'GeneralError'), Environment::getBaseURL().'DownForMaintenance.php') );

      exit;
   }
}
?>
