/*
**  Copyright (c) 2004 Sendmail, Inc. and its suppliers.
**    All rights reserved.
*/

#ifndef _SMI_DK_PRIVATE_H_
#define _SMI_DK_PRIVATE_H_

#ifndef lint
static char dk_private_h_id[] = "@(#)$Id: dk-private.h,v 1.36 2004/12/01 21:26:15 msk Exp $";
#endif /* !lint */

/* system */
#include <sys/param.h>

/* libsm */
#include <sm/gen.h>

/* libdk */
#include <dk.h>

/* OpenSSL */
#include <openssl/pem.h>
#include <openssl/rsa.h>

/*
**  DK -- DomainKeys context
*/

struct dk
{
	unsigned char	dk_lastchar;		/* last body character */
	bool		dk_hdrmark[MAXHDRCNT];	/* header marks */
	bool		dk_processing;		/* processing (not skipping) */
	bool		dk_testing;		/* test mode */
	bool		dk_revoked;		/* revoked key? */
	bool		dk_signall;		/* domain signs all mail */
	bool		dk_skipbody;		/* skip body content */
	bool		dk_writesep;		/* write separator CRLF? */
	int		dk_mode;		/* operating mode */
	int		dk_crlf;		/* CRLF mode used by input */
	int		dk_state;		/* state */
	unsigned int	dk_hdrlidx;		/* header list index */
	unsigned int	dk_hdrsidx;		/* header set index */
	unsigned int	dk_blanks;		/* buffered blank lines */
	unsigned int	dk_flags;		/* flags */
	unsigned int	dk_signalg;		/* signing algorithm */
	unsigned int	dk_canonalg;		/* canonicalization algorithm */
	unsigned int	dk_querymethod;		/* query method */
	unsigned int	dk_timeout;		/* DNS timeout */
	size_t		dk_keylen;		/* length of the key */
	size_t		dk_signlen;		/* length of the signature */
	size_t		dk_b64len;		/* base64 data length */
	size_t		dk_hdrlen;		/* dk_hdrbuf bytes in use */
	const char *	dk_id;			/* ID string for logging */
	const char *	dk_tmpdir;		/* where to write temp files */
	char *		dk_sender;		/* sender user@domain */
	char *		dk_shdrlist;		/* signed header list */
	char *		dk_gran;		/* granularity */
	char *		dk_user;		/* signing user */
	char *		dk_domain;		/* signing domain */
	char *		dk_selector;		/* selector in signing domain */
	unsigned char *	dk_signature;		/* signature data */
	unsigned char *	dk_b64;			/* base64-encoded data */
	unsigned char *	dk_key;			/* signing key */
	void *		dk_signinfo;		/* signing info */
	void *		dk_closure;		/* opaque memory info */
	DK_LIB *	dk_libhandle;		/* library handle */
	char *		dk_hdrset[MAXHDRCNT];	/* pointers into dk_hdrbuf */
	char *		dk_hdrlist[MAXHDRCNT];	/* list of signed headers */
	char		dk_frombuf[MAXADDRESS];	/* copy of From: header */
	char		dk_uhdrn[MAXHEADER];	/* identity header name */
	char		dk_uhdrv[MAXADDRESS];	/* identity header value */
	char		dk_reportaddr[MAXADDRESS]; /* where to send reports */
	char		dk_hdrbuf[MAXHEADERS];	/* header buffer */
};

/*
**  DK_SHA1 -- SHA1 signing information
*/

struct dk_sha1
{
	unsigned char	sha1_pad;
	int		sha1_tmpfd;
	size_t		sha1_keysize;
	size_t		sha1_rsainlen;
	size_t		sha1_rsaoutlen;
	BIO *		sha1_tmpbio;
	EVP_PKEY *	sha1_pkey;
	RSA *		sha1_rsa;
	unsigned char *	sha1_rsain;
	unsigned char *	sha1_rsaout;
	SHA_CTX		sha1_sha1;
	char		sha1_tmppath[MAXPATHLEN + 1];
};

#endif /* ! _SMI_DK_PRIVATE_H_ */
