/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_icmp_h
#define __nd_icmp_h

#include <nd.h>
#include <nd_types.h>

#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>

#include <protocols/icmp/libnd_icmp.h>

extern ND_MenuData icmp_menu_type_data[];
extern ND_MenuData icmp_menu_unreach_code_data[];
extern ND_MenuData icmp_menu_redirect_code_data[];

/* These are the implementations of ND_Protocol's callbacks: */
GtkWidget *nd_icmp_create_gui(LND_Trace *trace, LND_ProtoInfo *pinf);
void       nd_icmp_set_gui(const LND_Packet *packet, LND_ProtoInfo *pinf);

/* Generic accessor function for the protocol implementation: */
LND_Protocol *nd_icmp_get(void);
ND_Protocol  *nd_icmp_get_gui(void);

/* Helper functions to set a trace's GUI table to a packet's content: */
void       nd_icmp_set_gui_type(LND_ProtoInfo *pinf, struct icmp *icmphdr);
void       nd_icmp_set_gui_code(LND_ProtoInfo *pinf, struct icmp *icmphdr);
void       nd_icmp_set_gui_cksum(LND_ProtoInfo *pinf, struct icmp *icmphdr,
				 const LND_Packet *packet);

void       nd_icmp_set_gui_echo(LND_ProtoInfo *pinf, struct icmp *icmphdr,
				const LND_Packet *packet);

void       nd_icmp_set_gui_data(LND_ProtoInfo *pinf, struct icmp *icmphdr,
				const LND_Packet *packet);

void       nd_icmp_set_gui_timestamp(LND_ProtoInfo *pinf, struct icmp *icmphdr,
				     const LND_Packet *packet);

void       nd_icmp_set_gui_info(LND_ProtoInfo *pinf, struct icmp *icmphdr,
				const LND_Packet *packet);

void       nd_icmp_set_gui_addr(LND_ProtoInfo *pinf, struct icmp *icmphdr,
				const LND_Packet *packet);

void       nd_icmp_set_gui_router_adv(LND_ProtoInfo *pinf, struct icmp *icmphdr,
				      const LND_Packet *packet);

#endif
