%  Copyright (C) 2002-2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\section{darcs whatsnew}
\label{whatsnew}
\begin{code}
module WhatsNew ( whatsnew ) where
import DarcsCommands
import DarcsArguments
import Directory
import IO
import System
import Repository
import Patch
import SlurpDirectory
import Diff
import PrintPatch ( printPatch )
\end{code}

\options{whatsnew}

\haskell{whatsnew_description}
\begin{code}
whatsnew_description = "Display unrecorded changes in the working directory.
"
\end{code}
\haskell{whatsnew_help} Darcs whatsnew will return a non-zero value if
there are no changes, which can be useful if you just want to see in a
script if anything has been modified.  FIXME: If I feel motivated, I may
create options for different (possibly more user-friendly) views, such as a
unidiff view.

\begin{code}
whatsnew_help = "What's-new gives you a view of what changes you've made in your working
directory that haven't yet been recorded.  The changes are displayed in
darcs patch format.
"
\end{code}

\begin{code}
whatsnew = DarcsCommand {command_name = "whatsnew",
                         command_help = whatsnew_help,
                         command_description = whatsnew_description,
                         command_extra_args = 0,
                         command_command = whatsnew_cmd,
                         command_prereq = am_in_repo,
                         command_get_arg_possibilities = return [],
                         command_argdefaults = nodefaults,
                         command_darcsoptions = [verbose, ignoretimes]}
\end{code}

\begin{code}
whatsnew_cmd opts args = do
    changes <- get_unrecorded opts
    case changes of
      Nothing -> do putStr "No changes!\n"
                    exitWith $ ExitFailure 1
      Just ch -> printPatch ch
\end{code}
