%  Copyright (C) 2003 Jan Scheffczyk and David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

NOTE: this documentation belongs in a ``libdarcs API'' chapter, which
currently doesn't exist.
\begin{code}
module PopulationData ( Population(..), PopTree(..), Info(..),
                        setPopState, notModified, setState,
                        DirMark(..),
                      ) where
import PatchInfo
import FastPackedString
\end{code}

the population of a darcs repository
(simpler Slurpy)
PatchInfo: state when last modified
PopTree: the directory listing

\begin{code}
data Population = Pop PatchInfo PopTree
 deriving (Show, Eq)

setPopState i (Pop _ tr) = Pop i tr
\end{code}

directory listing

\begin{code}
data PopTree = PopDir Info [PopTree]
             | PopFile Info
 deriving Eq
\end{code}

info of a directory member

\begin{code}
data DirMark = AddedFile | RemovedFile | MovedFile String
             | ModifiedFile | DullFile
             | AddedDir | RemovedDir | MovedDir String | DullDir
               deriving ( Ord, Eq )
data Info = Info {name :: PackedString, -- name of the element
                  modifiedBy :: PatchInfo, -- last patch modifying this element
                  modifiedHow :: DirMark, -- how was it modified
                  createdBy :: Maybe PatchInfo, -- this can be unknwon when restored backwards!
                  creationName :: Maybe PackedString} -- the original name of the element
 deriving Eq
\end{code}

was an Info record not modified?

\begin{code}
notModified :: Info -> Bool
notModified i = (modifiedHow i == DullFile) || (modifiedHow i == DullDir)
\end{code}

set the modifier for an Info record

\begin{code}
setState :: Info -> PatchInfo -> Info
setState i pi = Info {name = name i,
                      modifiedBy = pi,
                      modifiedHow = modifiedHow i,
                      createdBy = createdBy i,
                      creationName = creationName i}

instance Show PopTree where
 show s = showPop "" s

showPop indent (PopDir i fs)
 = indent ++ show i ++ "\n" ++
   unlines (map (showPop (' ':indent)) fs)
showPop indent (PopFile i)
 = indent ++ show i

instance Show Info where
 show i = show (name i) ++ " " ++ show (modifiedHow i) ++
          " at state " ++ show (modifiedBy i)

instance Show DirMark where
 show AddedFile = "File added"
 show RemovedFile = "File removed"
 show (MovedFile s) = "File moved to " ++ s
 show ModifiedFile = "File modified"
 show DullFile = "File old"
 show AddedDir = "Dir added"
 show RemovedDir = "Dir removed"
 show (MovedDir s) = "Dir moved from " ++ s
 show DullDir = "Dir old"
\end{code}
