/********************************************************************************
*                                                                               *
*                     H i g h l i g h t   E n g i n e                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002,2003 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: Hilite.cpp,v 1.27 2003/09/12 04:06:57 fox Exp $                          *
********************************************************************************/
#include "fx.h"
#include "FXRex.h"
#include "Hilite.h"


/*
  Notes:
  - Restart position: place in text which is default style, a few
    lines of context before the change.
  - Language mode: use wildcard on filename, or forced explicitly.
  - Either simple pattern, or begin/end pattern. Special stop pattern
    to prevent scanning indefinitely.  Patterns may have sub-patterns.
  - Simple pattern must be non-empty; begin/end patterns of a complex
    pattern may be zero-width assertions.
  - Capturing parenthesis are disabled, for speed reasons.
*/

/*******************************************************************************/


// Delete subnodes
HLNode::~HLNode(){
  register HLNode *n;
  while(sub){ 
    n=sub; sub=sub->alt; delete n; 
    }
  }
  
  
// Stylize simple expression
FXbool HLSimple::stylize(const FXchar* text,FXchar *textstyle,FXint fm,FXint to,FXint& start,FXint& stop) const {
  if(pat.match(text,to,&start,&stop,REX_NOT_EMPTY|REX_FORWARD,1,fm,fm)){
    memset(&textstyle[start],style,stop-start);
    return TRUE;
    }
  return FALSE;
  }


// Stylize complex recursive expression
FXbool HLComplex::stylize(const FXchar* text,FXchar *textstyle,FXint fm,FXint to,FXint& start,FXint& stop) const {
  register const HLNode *node; FXint head,tail,pos;
  if(beg.match(text,to,&start,&pos,REX_FORWARD,1,fm,fm)){
    memset(&textstyle[start],style,pos-start);
    while(pos<to){
      for(node=getSub(); node; node=node->getAlt()){
        if(node->stylize(text,textstyle,pos,to,head,tail)){
          pos=tail;
          goto nxt;
          }
        }
      if(end.match(text,to,&head,&stop,REX_FORWARD,1,pos,pos)){
        memset(&textstyle[head],style,stop-head);
        return TRUE;
        }
      textstyle[pos++]=style;
nxt:  continue;
      }
    stop=pos;
    }
  return FALSE;
  }


// Stylize complex recursive expression with termination pattern
FXbool HLSafeComplex::stylize(const FXchar* text,FXchar *textstyle,FXint fm,FXint to,FXint& start,FXint& stop) const {
  register const HLNode *node; FXint head,tail,pos;
  if(beg.match(text,to,&start,&pos,REX_FORWARD,1,fm,fm)){
    memset(&textstyle[start],style,pos-start);
    while(pos<to){
      for(node=getSub(); node; node=node->getAlt()){
        if(node->stylize(text,textstyle,pos,to,head,tail)){
          pos=tail;
          goto nxt;
          }
        }
      if(end.match(text,to,&head,&stop,REX_FORWARD,1,pos,pos)){
        memset(&textstyle[head],style,stop-head);
        return TRUE;
        }
      if(term.match(text,to,&head,&stop,REX_FORWARD,1,pos,pos)){
        memset(&textstyle[head],style,stop-head);
        return TRUE;
        }
      textstyle[pos++]=style;
nxt:  continue;
      }
    stop=pos;
    }
  return FALSE;
  }


// Stylize text
void Hilite::stylize(const FXchar* text,FXchar *textstyle,FXint fm,FXint to) const {
  register const HLNode *node;
  FXint head,tail,pos;
  pos=fm;
  while(pos<to){
    for(node=root; node; node=node->getAlt()){
      if(node->stylize(text,textstyle,pos,to,head,tail)){
        pos=tail;
        goto nxt;
        }
      }
    textstyle[pos++]=0;
nxt:continue;
    }
  }


// Append highlight pattern
HLNode *Hilite::append(HLNode *parent,FXint context,FXint style,const FXchar* rex){
  register HLNode *node=new HLSimple(parent,context,style,rex);
  register HLNode **nn=parent?&parent->sub:&root;
  register HLNode *n=*nn;
  while(n){
    nn=&n->alt;
    n=*nn;
    }
  node->alt=n;
  *nn=node;
  return node;
  }


// Append highlight pattern
HLNode *Hilite::append(HLNode *parent,FXint context,FXint style,const FXchar* brex,const FXchar* erex){
  register HLNode *node=new HLComplex(parent,context,style,brex,erex);
  register HLNode **nn=parent?&parent->sub:&root;
  register HLNode *n=*nn;
  while(n){
    nn=&n->alt;
    n=*nn;
    }
  node->alt=n;
  *nn=node;
  return node;
  }


// Append highlight pattern
HLNode *Hilite::append(HLNode *parent,FXint context,FXint style,const FXchar* brex,const FXchar* erex,const FXchar* srex){
  register HLNode *node=new HLSafeComplex(parent,context,style,brex,erex,srex);
  register HLNode **nn=parent?&parent->sub:&root;
  register HLNode *n=*nn;
  while(n){
    nn=&n->alt;
    n=*nn;
    }
  node->alt=n;
  *nn=node;
  return node;
  }


// Remove highlight pattern
void Hilite::remove(HLNode* node){
  register HLNode **nn=node->parent?&node->parent->sub:&root;
  register HLNode *n=*nn;
  while(n){
    if(n==node){
      *nn=node->alt;
      delete node;
      break;
      }
    nn=&n->alt;
    n=*nn;
    }
  }


// Find pattern node by style
HLNode *Hilite::find(FXint style) const {
  register HLNode *node=root;
  while(node){
    if(node->style==style){break;}
    if(node->sub){node=node->sub; continue; }
    while(!node->alt && node->parent){ node=node->parent; }
    node=node->alt;
    }
  return node;
  }


// Clear all syntax rules
void Hilite::clear(){
  register HLNode *n;
  while(root){
    n=root;
    root=root->alt;
    delete n;
    }
  }


// Clean up
Hilite::~Hilite(){
  clear();
  }
