/*
 * GQview
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef FILELIST_H
#define FILELIST_H


gint ishidden(const gchar *name);

gint filter_name_exists(const gchar *name);
void filter_rebuild(void);

GList *path_list_filter(GList *list, gint is_dir_list);

GList *path_list_sort(GList *list);
GList *path_list_recursive(const gchar *path);

gchar *text_from_size(gint size);
gchar *text_from_size_abrev(gint size);
const gchar *text_from_time(time_t t);

/* path is not const here, the allocated is text
 * is used, not copied - for speed
 */
FileData *file_data_new(gchar *path, struct stat *st);
void file_data_free(FileData *fd);

GList *filelist_sort(GList *list, SortType method, gint ascend);
GList *filelist_insert_sort(GList *list, FileData *fd, SortType method, gint ascend);

gint filelist_read(const gchar *path, GList **files, GList **dirs);
void filelist_free(GList *list);

#endif


