/*
 * GQview
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqview.h"
#include "dnd.h"

#include "collect.h"
#include "image.h"
#include "ui_fileops.h"


GtkTargetEntry dnd_file_drag_types[] = {
	{ "text/uri-list", 0, TARGET_URI_LIST },
	{ "text/plain", 0, TARGET_TEXT_PLAIN }
};
gint dnd_file_drag_types_count = 2;

GtkTargetEntry dnd_file_drop_types[] = {
	{ "application/x-gqview-collection-member", 0, TARGET_APP_COLLECTION_MEMBER },
	{ "text/uri-list", 0, TARGET_URI_LIST }
};
gint dnd_file_drop_types_count = 2;


GList *get_uri_file_list(gchar *data)
{
	GList *list = NULL;
	gint b, e;

	b = e = 0;

	while (data[b] != '\0')
		{
		while (data[e] != '\r' && data[e] != '\n' && data[e] != '\0') e++;
		if (!strncmp(data + b, "file:", 5))
			{
			b += 5;
			while (data[b] == '/' && data[b+1] == '/') b++;
			list = g_list_append(list, g_strndup(data + b, e - b));
			}
		while (data[e] == '\r' || data[e] == '\n') e++;
		b = e;
		}

	return list;
}

gchar *make_uri_file_list(GList *list, gint plain_text, gint *length)
{
	gchar *uri_text = NULL;
	gchar *leader = "file:";
	gchar *sep = "\r\n";
	gint total;
	gint leader_l;
	gint sep_l = strlen(sep);
	gchar *ptr;
	GList *work;

	if (!list)
		{
		*length = 0;
		return NULL;
		}

	if (plain_text)
		{
		leader_l = 0;
		}
	else
		{
		leader_l = strlen(leader);
		}
	

	work = list;
	total = 0;

	/* compute length */

	while (work)
		{
		gchar *name = work->data;
		total += leader_l + strlen(name) + sep_l;
		work = work->next;
		}

	/* create list */
	uri_text = g_malloc(total + 1);
	ptr = uri_text;

	work = list;
	while (work)
		{
		gchar *name = work->data;
		if (leader_l > 0)
			{
			strcpy(ptr, leader);
			ptr += leader_l;
			}
		strcpy(ptr, name);
		ptr += strlen(name);
		strcpy(ptr, sep);
		ptr += sep_l;
		work = work->next;
		}
	ptr[0] = '\0';

	*length = total;

	return uri_text;
}

/*
 *-----------------------------------------------------------------------------
 * image drag and drop routines
 *-----------------------------------------------------------------------------
 */ 

static void image_get_dnd_data(GtkWidget *widget, GdkDragContext *context,
			       gint x, gint y,
			       GtkSelectionData *selection_data, guint info,
			       guint time, gpointer data)
{
	ImageWindow *imd = data;

	if (info == TARGET_URI_LIST || info == TARGET_APP_COLLECTION_MEMBER)
		{
		CollectionData *source;
		GList *list;
		GList *info_list;

		if (info == TARGET_URI_LIST)
			{
			list = get_uri_file_list(selection_data->data);
			source = NULL;
			info_list = NULL;
			}
		else
			{
			source = collection_from_dnd_data((gchar *)selection_data->data, &list, &info_list);
			}

		if (list)
			{
			gchar *path;

			path = list->data;
			if (isfile(path))
				{
				if (source && info_list)
					{
					image_change_from_collection(imd, source, info_list->data, image_zoom_get_default(imd, zoom_mode));
					}
				else
					{
					image_change_path(imd, path, image_zoom_get_default(imd, zoom_mode));
					}
				}

			path_list_free(list);
			g_list_free(info_list);
			}
		}
}

static void image_set_dnd_data(GtkWidget *widget, GdkDragContext *context,
			       GtkSelectionData *selection_data, guint info,
			       guint time, gpointer data)
{
	ImageWindow *imd = data;
	const gchar *path = image_get_path(imd);

	if (path)
		{
		gchar *text = NULL;
		switch (info)
			{
			case TARGET_URI_LIST:
				text = g_strconcat("file:", path, "\r\n", NULL);
				break;
			case TARGET_TEXT_PLAIN:
				text = g_strdup(path);
				break;
			}
		if (text)
			{
			gtk_selection_data_set (selection_data, selection_data->target,
						8, text, strlen(text));
			g_free(text);
			}
		}
	else
		{
		gtk_selection_data_set (selection_data, selection_data->target,
					8, NULL, 0);
		}
}

void image_dnd_init(ImageWindow *imd)
{
	gtk_drag_source_set(imd->image, GDK_BUTTON2_MASK,
			    dnd_file_drag_types, dnd_file_drag_types_count,
			    GDK_ACTION_COPY | GDK_ACTION_MOVE | GDK_ACTION_LINK);
	gtk_signal_connect(GTK_OBJECT(imd->image), "drag_data_get",
			   GTK_SIGNAL_FUNC(image_set_dnd_data), imd);

	gtk_drag_dest_set(imd->image,
			  GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP,
			  dnd_file_drop_types, dnd_file_drop_types_count,
                          GDK_ACTION_COPY);
	gtk_signal_connect(GTK_OBJECT(imd->image), "drag_data_received",
			   GTK_SIGNAL_FUNC(image_get_dnd_data), imd);
}

