/*
 * $Id: nemesis-proto_arp.c,v 1.5 2000/02/14 03:45:48 obecian Exp $
 *
 * THE NEMESIS PROJECT (c) obecian 1999, 2000
 *
 * nemesis-proto_arp.c (ARP Packet Generator)
 *
 */

#include "nemesis-arp.h"

int
buildarp()
{
	int             n;
	static u_char  *pkt;
	static int		sockfd = -1;
	pcap_t *temp_pcap_d = NULL;
	char            errbuf[256];

	link_type=0, pcap_offset=0;

	/* sanity checks */	
	if (!device) {
		printf("Unspecified Device.\n");
		exit(-1);
	}
	if((temp_pcap_d = pcap_open_live(device,0,0,0,errbuf)) == NULL)
	{
		printf("Error opening interface: %s\n", errbuf);
		exit(-1);
	}
	link_type = pcap_datalink(temp_pcap_d);
	pcap_close(temp_pcap_d);

	/* verify supported link layer - from bane by dreck */

	switch(link_type)
    {
        /* Ethernet? Set offset and open l2w handle */
        case DLT_EN10MB:
        pcap_offset=14;
        if((l2=libnet_open_link_interface(device,errbuf)) == NULL)
        {
            printf("Error Opening layer2 dev for writing: %s\n",errbuf);
            exit(-1);
        }
        break;
        /* Other? Set offset and open l3w handle */
        case DLT_NULL:
        case DLT_PPP:
        pcap_offset=0;
        if((l3=libnet_open_raw_sock(IPPROTO_RAW)) == -1)
        {
            perror("Error Opening layer3 sock for writing:");
            exit(-1);
        }
        break;
        default:
        printf("Sorry, %s does not use a supported datalink type.\n",device);
        exit(0);
        break;
    }   
	
	if (libnet_init_packet(LIBNET_ARP_H + LIBNET_ETH_H + payload_s, &pkt) == -1) {
		printf("libnet_init_packet memory error");
		exit(-1);
	}

	libnet_build_ethernet(enet_dst,
			      enet_src,
			      ETHERTYPE_ARP,
			      NULL,
			      0,
			      pkt);

	if (arptype == 0) /* 0 = ask (request) */
	{
		libnet_build_arp(ARPHRD_ETHER,	/* hardware address type */
			 ETHERTYPE_IP,	/* protocol address type */
			 6,	/* hardware address length */
			 4,	/* protocol address length */
			 ARPOP_REQUEST,	/* opcode command */
			 enet_src,	/* sender hardware address */
			 (u_char *) & source,	/* sender protocol (IP)
						 * address */
			 enet_dst,	/* target hardware address */
			 (u_char *) & dest,	/* destination protocol (IP)
						 * address */
			 payload,	/* ARP payload pointer */
			 payload_s,	/* ARP payload size */
			 pkt + ETH_H);	/* packet header memory */
	} 
	else if (arptype == 1) /* 1 = tell (reply) */
	{
        libnet_build_arp(ARPHRD_ETHER,  /* hardware address type */
             ETHERTYPE_IP,  /* protocol address type */
             6, /* hardware address length */
             4, /* protocol address length */
             ARPOP_REPLY, /* opcode command */
             enet_src,  /* sender hardware address */
             (u_char *) & source,   /* sender protocol (IP)
                         * address */
             enet_dst,  /* target hardware address */
             (u_char *) & dest, /* destination protocol (IP)
                         * address */
             payload,   /* ARP payload pointer */
             payload_s, /* ARP payload size */
             pkt + ETH_H);  /* packet header memory */
	}

	n = libnet_write_link_layer(l2,
				    device,
				    pkt,
				    LIBNET_ARP_H + LIBNET_ETH_H + payload_s);

	if (verbose)
		printf("Wrote %d byte ARP packet through linktype %d\n", n, l2->linktype);
	libnet_destroy_packet(&pkt);
	libnet_close_raw_sock(sockfd);
	return (n);
}
