/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: Quaternion.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef QUATERNION_H
#define QUATERNION_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <cmath>
#include "Euler.h"
#include "Vector3.h"
#include "MathUtil.h"

namespace Animorph {

class Quaternion
{
public:
  float w, x, y, z;

  enum RotateAxis
  {
    X_AXIS,
    Y_AXIS,
    Z_AXIS
  };

  Quaternion () : w (1.0), x (0.0), y (0.0), z (0.0) {}
  Quaternion (float w, float x, float y, float z) : w (w), x (x), y (y), z (z) {};

  void identity () {w = 1.0; x = y = z = 0.0;}
  void conjugate ();

  /// as PI
  void setRotation (float theta, RotateAxis axis);
  void fromEuler (Euler &e);
};

/**************************************/
/* Non-Member operators and functions */
/**************************************/

/// Quaternion multiplication (cross product)
Quaternion operator * (const Quaternion &q1, const Quaternion &q2);

// << operator for output
std::ostream &operator << (std::ostream &s, const Quaternion &q);

}

#endif  // QUATERNION_H
