/* $Id: process.c,v 1.6 1998/03/08 22:44:13 fraserm Exp $
   $Log: process.c,v $
   Revision 1.6  1998/03/08 22:44:13  fraserm
   screen refresh by interval timer for xagm
   doesn't sort dictionary unless it has to

   Revision 1.5  1998/03/07 16:32:22  fraserm
   in so I can get it out again

   Revision 1.4  1996/11/01 22:24:21  fraser
   flush output every 1% regardless of whether it's a tty or not

 * Revision 1.3  1996/10/25  19:11:37  fraser
 * updates changing spinny line to 2 digit percentage
 *
 * Revision 1.2  1996/09/12  14:20:56  fraser
 * add module version printing
 *
 * Revision 1.1  1996/09/12  13:19:48  fraser
 * Initial revision
 *
*/
/* process.c: main anagram search function for agm
*/

char process_RCSid[] = "$Revision: 1.6 $";

#include "agm.h"

process (word, ls, le, minlen, maxw, depth)
    /* searches the list ls - le for words which can be extracted from
       word; if a word extracts exactly, the words in prevs are printed out,
       otherwise, a sublist is built, and process() called recursively */
    char *word;
    struct wnode *ls, *le;
    unsigned int minlen;
    unsigned int depth;
{
  char newword[WORDLEN];
  struct wnode *loop;
  struct wnode *newls = NULL, *newle = NULL;
  unsigned int subcount = 0, subwhere, length;

  if (maxw == 0) { /* end of the road; means we have exceeded the max
	              words restriction */
    ++perms;
    ++rejected;
    /* just return now */
  }
  else {
    for (loop = ls; loop != NULL; loop = loop->next) {
      if (contains (word, loop->word, &length)
	  && length >= MINMIN
	  && (!hardmin || (length >= minlen))) { /* then add it to the
						    list */
	addword (loop->word, &newls, &newle);
	++subcount;
      }
    }
    /* now go through each sub-word; add it to the prevlist;
       make newword from word by removing all the letters of sub-word from it;
       if no letters are left, print out the prev list, otherwise call
       process again with the new word and the sublist built above */
    subwhere = 0;
    for (loop = newls; loop != NULL; loop = loop->next) {
      if (depth == 1) {
	lastpct = pct;
	if ((pct = subwhere++ * 100 / subcount) > 99) pct = 99;
	/* this bit deleted because we now use a timer */
	/* if ((is_a_tty||force_percent) && lastpct != pct) {
	  printf ("%02d\b\b", pct);
	}
	fflush (stdout); */
      }
      prevs[prevcount++] = loop->word;
      totlen += strlen (loop->word);
      eliminate (word, loop->word, newword);
      if ((newword[0] == '\0'
	   && (totlen / prevcount >= minlen))
          || (partial && prevcount == maxwords)) { /* done; full anagram
                                                      or partial anagram
                                                      with correct # of
                                                      words */
	print_prevs (pct);
	++perms;
	++sucperms;
      }
      else { /* here we go again */
	if (newword[0] == '\0') { /* a full match, but rejected on length
				     grounds */
	  ++rejected;
	}
	process (newword, newls, newle, minlen, maxw - 1, depth + 1);
      }
      /* must back up the prevlist by one after doing each word */
      --prevcount;
      totlen -= strlen (loop->word);
    }
    /* destroy the sublist for this incarnation of process() before leaving,
       or memory use will increase exponentially */
    if (newls == NULL) { /* then the list was always empty, so this is a
			    dead-end permutation; therefore inc perms */
      ++perms;
    }
    destroy_list (newls, newle);
  }
}
