/* $Id: agm.h,v 1.6 1998/03/08 22:44:13 fraserm Exp $
   $Log: agm.h,v $
   Revision 1.6  1998/03/08 22:44:13  fraserm
   screen refresh by interval timer for xagm
   doesn't sort dictionary unless it has to

   Revision 1.5  1998/03/07 16:42:15  fraserm
   in to get out

   Revision 1.4  1996/10/09 15:27:45  fraser
   now undefines TIMER in HP-UX, because of change to using getrusage()

 * Revision 1.3  1996/09/13  20:36:39  fraser
 * removed include of sys/stat.h
 * added LOWER() macro for new gobble_file()
 *
 * Revision 1.2  1996/09/12  14:20:56  fraser
 * add module version printing
 *
*/
/* Definitions for agm
*/

#define HEADER_RCSID "$Revision: 1.6 $"

#ifdef hpux
#undef TIMER
#undef CPULIMIT
#endif
#ifdef _M_SYSV
#undef TIMER
#undef CPULIMIT
#endif

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <signal.h>

/* RELEASE now defined in Makefile */

#ifndef WORDFILE
#define WORDFILE "/usr/dict/words" /* NOW DEFINED IN MAKEFILE; always reads this file */
#endif
#define STANDARDIN "-" /* "file" denoting the standard input */
#define CHUNKSIZE 8192 /* when reading standard input, number of bytes to
                          allocate each time */
#define SEPCHARS " \t\n\r`~!@#$%^&*()-=\\_+|[]{};:'\",./<>?"
#define FILECHAR '+' /* character which specifies another file is to be read */
#define NOREADDEF "+" /* don't read the default wordfile if this "file" is
                         read */
#define LISTOPT "-w" /* don't generate anagrams, just output the final
                        dictionary */
#define FORCEOPT "-f" /* force output of percentage complete, regardless of
			 whether this is a tty or not */
#define QUIETOPT "-q" /* don't output anything but anagrams */
#define HARDOPT "-h" /* specifies a hard minimum wordlength, rather than
			a minimum average word length */
#define SPECOPT "-l" /* to specify the min word length, rather than have
			it calculated - overrides normal restrictions */
#define MAXWOPT "-c" /* to specify that ags are rejected by max number of
			words, rather than word length */
#define PARTOPT "-p" /* to specify that its okay to print partial anagrams */
#define SWOPT "-o" /* specified maximum output width, but pretty much
		      assumed to be at least 80 */
#ifdef CPULIMIT
#define CLOPT "-s" /* max runtime in seconds */
#else
#define CLOPT "<none>"
#endif
#ifdef TIMER
#define TIMEOPT "-t" /* display time statistics */
#else
#define TIMEOPT "<none>"
#endif
#define VERSOPT "-v" /* to display modules versions only */
#define MINUS '-' /* if found in search word, subtract letters after MINUS */
#define WORDLEN 256
#define DEFMAXSEC -1 /* no limit by default */
#define DEFMAXLIN -1 /* no limit by default */
#define MAXMIN 4 /* greatest minimum length a word must be to become
		    an anagram; for longish words, 3 gives far too
		    much output, 5 gives too little; 4 is "just right" */
#define MINMIN 2 /* to eliminate single letter words from the wordlist,
		    which not only generate loads of rubbish anagrams,
		    but are also boring */
#define WORDFACT 3 /* what to divide word length by to get minimum anagram
		      word length */
#define MAXPATHLEN 1024
#define MAXWORDS 64 /* max number of words prog will attempt to form
		       as anagram (64 is absurdly large - the universe would
		       end before it worked at all) */
#define UPDATETIME 1 /* interval between % complete updates in seconds */
#define TRUE 1
#define FALSE 0
#define HIDECHAR ' '
#define SCREENWID 80
/* #define LOWCHAR 'a'
#define HIGHCHAR 'z'
#define LOOKUPSIZE (HIGHCHAR - LOWCHAR + 1) */
#define LOWER(c) (((ch) >= 'A' && (ch) <= 'Z') ? (ch += ('a' - 'A')) : ch)

struct wnode { /* one node of a wordlist */
  char *word;
  struct wnode *next;
};

extern int listdict;
extern int hardmin;
extern int time_out;
extern int read_default;
extern char *prevs[MAXWORDS];
extern int prevcount;
extern int totlen;
extern int dups_removed;
extern int maxwords;
extern int partial;
extern long perms, sucperms, rejected;
extern int screenwid, spos;
extern int is_a_tty, force_percent;
extern int notquiet;
extern int pct, lastpct;
#ifdef TIMER
extern int timeok;
extern struct timeval start_at, sort_at, process_at, end_at;
#endif

extern unsigned int wordcount, filecount, must_sort;

extern struct wnode *lstart, *lend;

extern char main_RCSid[], gobble_RCSid[], listfuncs_RCSid[], output_RCSid[],
            process_RCSid[], sort_RCSid[], wordfuncs_RCSid[], progress_RCSid[];

extern void copysmall();
extern void arm_timer(), disarm_timer();
