/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class NOTATIONDatatypeValidator
extends AbstractDatatypeValidator {
    private DatatypeValidator fBaseValidator = null;
    private Vector fEnumeration = new Vector();
    private int fFacetsDefined = 0;
    private int fLength = 0;

    public NOTATIONDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public NOTATIONDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    this.fEnumeration = (Vector)hashtable.get(string);
                    continue;
                }
                if (!string.equals("length")) continue;
                ++this.fFacetsDefined;
                String string2 = (String)hashtable.get(string);
                try {
                    this.fLength = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidDatatypeFacetException("Length value '" + string2 + "' is invalid.");
                }
                if (this.fLength >= 0) continue;
                throw new InvalidDatatypeFacetException("Length value '" + string2 + "'  must be a nonNegativeInteger.");
            }
        }
        if (this.fBaseValidator != null && (this.fFacetsDefined & 0x10) == 0) {
            System.err.println("[Internal parser error] Enumeration facet is required for NOTATION decl!");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public void setLocale(Locale locale) {
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            if ((this.fFacetsDefined & 0x10) != 0 && !this.fEnumeration.contains(string)) {
                throw new InvalidDatatypeValueException("Value '" + string + "' must be one of " + this.fEnumeration);
            }
            if ((this.fFacetsDefined & 1) != 0 && string.length() != this.fLength) {
                throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + string.length() + "' is not equal to length facet '" + this.fLength + "'.");
            }
        }
        return null;
    }
}

