/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Vertex;

class Obstacle
extends Rectangle {
    boolean exclude;
    Vertex topLeft;
    Vertex topRight;
    Vertex bottomLeft;
    Vertex bottomRight;
    Vertex center;

    Obstacle(Rectangle rect) {
        this.init(rect);
    }

    public boolean containsProper(Point p) {
        return p.x > this.x && p.x < this.x + this.width - 1 && p.y > this.y && p.y < this.y + this.height - 1;
    }

    private void growVertex(Vertex vertex) {
        if (vertex.totalCount > 0) {
            vertex.grow();
        }
    }

    void growVertices() {
        this.growVertex(this.topLeft);
        this.growVertex(this.topRight);
        this.growVertex(this.bottomLeft);
        this.growVertex(this.bottomRight);
    }

    void init(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        this.exclude = false;
        this.topLeft = new Vertex(this.x, this.y, this);
        this.topLeft.positionOnObstacle = 9;
        this.topRight = new Vertex(this.x + this.width - 1, this.y, this);
        this.topRight.positionOnObstacle = 17;
        this.bottomLeft = new Vertex(this.x, this.y + this.height - 1, this);
        this.bottomLeft.positionOnObstacle = 12;
        this.bottomRight = new Vertex(this.x + this.width - 1, this.y + this.height - 1, this);
        this.bottomRight.positionOnObstacle = 20;
        this.center = new Vertex(this.getCenter(), this);
    }

    void reset() {
        this.topLeft.fullReset();
        this.bottomLeft.fullReset();
        this.bottomRight.fullReset();
        this.topRight.fullReset();
    }

    private void shrinkVertex(Vertex vertex) {
        if (vertex.totalCount > 0) {
            vertex.shrink();
        }
    }

    void shrinkVertices() {
        this.shrinkVertex(this.topLeft);
        this.shrinkVertex(this.topRight);
        this.shrinkVertex(this.bottomLeft);
        this.shrinkVertex(this.bottomRight);
    }

    public String toString() {
        return "Obstacle(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }
}

