/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.locks;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.graalvm.visualvm.lib.jfluid.results.locks.AbstractLockDataFrameProcessor;

public class LockDataFrameProcessor
extends AbstractLockDataFrameProcessor {
    @Override
    public void doProcessDataFrame(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Command start offset " + buffer.position());
            }
            byte eventType = buffer.get();
            switch (eventType) {
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    break;
                }
                case 29: {
                    char id = buffer.getChar();
                    long timeStamp = LockDataFrameProcessor.getTimeStamp(buffer);
                    char threadId = buffer.getChar();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profile Point Hit " + id + ", threadId=" + id + ", timeStamp=" + timeStamp);
                    }
                    this.fireProfilingPoint(threadId, id, timeStamp);
                    break;
                }
                case 13: {
                    this.currentThreadId = buffer.getChar();
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.log(Level.FINEST, "Change current thread , tId={0}", this.currentThreadId);
                    break;
                }
                case 11: {
                    char threadId = buffer.getChar();
                    String threadName = LockDataFrameProcessor.getString(buffer);
                    String threadClassName = LockDataFrameProcessor.getString(buffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new thread , tId={0}", threadId);
                    }
                    this.fireNewThread(threadId, threadName, threadClassName);
                    this.currentThreadId = threadId;
                    break;
                }
                case 28: {
                    int hash = buffer.getInt();
                    String className = LockDataFrameProcessor.getString(buffer);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Creating new monitor , monitorId={0} , className={1}", new Object[]{Integer.toHexString(hash), className});
                    }
                    this.fireNewMonitor(hash, className);
                    break;
                }
                case 22: 
                case 23: {
                    long timeStamp0 = LockDataFrameProcessor.getTimeStamp(buffer);
                    long timeStamp1 = -1L;
                    int hash = buffer.getInt();
                    if (eventType == 22) {
                        int ownerThreadId = buffer.getInt();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Monitor entry , tId={0} , monitorId={1} , ownerId={2}", new Object[]{this.currentThreadId, Integer.toHexString(hash), ownerThreadId});
                        }
                        this.fireMonitorEntry(this.currentThreadId, timeStamp0, timeStamp1, hash, ownerThreadId);
                    }
                    if (eventType != 23) break;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Monitor exit , tId={0} , monitorId={1}", new Object[]{this.currentThreadId, Integer.toHexString(hash)});
                    }
                    this.fireMonitorExit(this.currentThreadId, timeStamp0, timeStamp1, hash);
                    break;
                }
                case 5: {
                    long timeStamp1;
                    long timeStamp0 = LockDataFrameProcessor.getTimeStamp(buffer);
                    long l = timeStamp1 = this.collectingTwoTimeStamps ? LockDataFrameProcessor.getTimeStamp(buffer) : 0L;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Adjust time , tId={0}", this.currentThreadId);
                    }
                    this.fireAdjustTime(this.currentThreadId, timeStamp0, timeStamp1);
                    break;
                }
                default: {
                    LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in LockDataFrameProcessor: " + eventType + " at " + buffer.position());
                }
            }
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.finest("Command end offset " + buffer.position());
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Buffer end offset " + buffer.position());
        }
    }
}

