/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;

public class IO {
    public static void delete(File file) throws IOException {
        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void foreachFileIn(Path path, final Consumer<Path> consumer) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                consumer.accept(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String read(Path path) throws IOException {
        return new String(Files.readAllBytes(path), Charset.defaultCharset());
    }

    public static String read(String string) throws IOException {
        return IO.read(Paths.get(string, new String[0]));
    }
}

