/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.community.ide.impl.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pycharm.community.ide.impl.PyCharmCommunityCustomizationBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.VirtualEnvReader;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.sdk.poetry.PoetryCommandExecutorKt;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PyPoetrySdkAdditionalData;
import com.jetbrains.python.sdk.poetry.PyProjectTomlUtilsKt;
import com.jetbrains.python.sdk.poetry.ui.PyAddNewPoetryFromFilePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0017\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/pycharm/community/ide/impl/configuration/PyPoetrySdkConfiguration;", "Lcom/jetbrains/python/sdk/configuration/PyProjectSdkConfigurationExtension;", "<init>", "()V", "createAndAddSdkForConfigurator", "Lcom/intellij/openapi/projectRoots/Sdk;", "module", "Lcom/intellij/openapi/module/Module;", "getIntention", "", "Lcom/intellij/codeInspection/util/IntentionName;", "createAndAddSdkForInspection", "supportsHeadlessModel", "", "createAndAddSDk", "inspection", "askForEnvData", "Lcom/jetbrains/python/sdk/poetry/ui/PyAddNewPoetryFromFilePanel$Data;", "createPoetry", "Companion", "Dialog", "intellij.pycharm.community.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPyPoetrySdkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPoetrySdkConfiguration.kt\ncom/intellij/pycharm/community/ide/impl/configuration/PyPoetrySdkConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class PyPoetrySdkConfiguration
implements PyProjectSdkConfigurationExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;

    @Nullable
    public Sdk createAndAddSdkForConfigurator(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createAndAddSDk(module, false);
    }

    @Nullable
    public String getIntention(@NotNull Module module) {
        String string;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = PyProjectTomlUtilsKt.getPyProjectToml((Module)module);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getName()};
            string = PyCharmCommunityCustomizationBundle.message("sdk.set.up.poetry.environment", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Sdk createAndAddSdkForInspection(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createAndAddSDk(module, true);
    }

    public boolean supportsHeadlessModel() {
        return true;
    }

    private final Sdk createAndAddSDk(Module module, boolean inspection) {
        PyAddNewPoetryFromFilePanel.Data data = this.askForEnvData(module, inspection);
        if (data == null) {
            return null;
        }
        PyAddNewPoetryFromFilePanel.Data poetryEnvExecutable = data;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
        PoetryCommandExecutorKt.setPoetryPath((PropertiesComponent)propertiesComponent, (String)((Object)poetryEnvExecutable.getPoetryPath()).toString());
        return this.createPoetry(module);
    }

    private final PyAddNewPoetryFromFilePanel.Data askForEnvData(Module module, boolean inspection) {
        Path poetryExecutable = PoetryCommandExecutorKt.getPoetryExecutable();
        boolean isHeadlessEnv = ApplicationManager.getApplication().isHeadlessEnvironment();
        if ((inspection || isHeadlessEnv) && PoetryCommandExecutorKt.validatePoetryExecutable((Path)poetryExecutable) == null) {
            Path path = poetryExecutable;
            Intrinsics.checkNotNull((Object)path);
            return new PyAddNewPoetryFromFilePanel.Data(path);
        }
        if (isHeadlessEnv) {
            return null;
        }
        Ref.BooleanRef permitted = new Ref.BooleanRef();
        Ref.ObjectRef envData = new Ref.ObjectRef();
        ApplicationManager.getApplication().invokeAndWait(() -> PyPoetrySdkConfiguration.askForEnvData$lambda$1(module, permitted, envData));
        return permitted.element ? (PyAddNewPoetryFromFilePanel.Data)envData.element : null;
    }

    private final Sdk createPoetry(Module module) {
        VirtualFile virtualFile;
        String init22;
        Object it;
        Object object;
        block12: {
            block11: {
                ProgressManager.progress((String)PyCharmCommunityCustomizationBundle.message("sdk.progress.text.setting.up.poetry.environment", new Object[0]));
                LOGGER.debug("Creating poetry environment");
                object = BasePySdkExtKt.getBasePath((Module)module);
                if (object == null) break block11;
                it = object;
                boolean bl = false;
                Path path = Path.of((String)it, new String[0]);
                object = path;
                if (path != null) break block12;
            }
            return null;
        }
        Object basePath = object;
        try {
            Pair pair;
            VirtualFile virtualFile2 = StandardFileSystems.local().findFileByPath(basePath.toString());
            if (virtualFile2 != null && (virtualFile2 = virtualFile2.findChild("pyproject.toml")) != null) {
                VirtualFile it2 = virtualFile2;
                boolean bl = false;
                pair = PyProjectTomlUtilsKt.getPyProjectTomlForPoetry((VirtualFile)it2);
            } else {
                pair = null;
            }
            boolean init22 = pair == null;
            init22 = PoetryCommandExecutorKt.setupPoetry((Path)basePath, null, (boolean)true, (boolean)init22);
        }
        catch (ExecutionException e) {
            LOGGER.warn("Exception during creating poetry environment", (Throwable)e);
            String string = PyCharmCommunityCustomizationBundle.message("sdk.dialog.title.failed.to.set.up.poetry.environment", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            PySdkExtKt.showSdkExecutionException(null, (ExecutionException)e, (String)string);
            return null;
        }
        String poetry = init22;
        VirtualEnvReader virtualEnvReader = VirtualEnvReader.Companion.getInstance();
        Path path = Path.of(poetry, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Object it3 = it = virtualEnvReader.findPythonInPythonRoot(path);
        boolean bl = false;
        if (it3 == null) {
            LOGGER.warn("Python executable is not found: " + poetry);
        }
        Object object2 = it;
        if (object2 == null) {
            return null;
        }
        Object path2 = object2;
        VirtualFile it4 = virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2.toString());
        boolean bl2 = false;
        if (it4 == null) {
            LOGGER.warn("Python executable file is not found: " + (Path)path2);
        }
        VirtualFile virtualFile3 = virtualFile;
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile file = virtualFile3;
        LOGGER.debug("Setting up associated poetry environment: " + (Path)path2 + ", " + (Path)basePath);
        Sdk sdk2 = SdkConfigurationUtil.setupSdk((Sdk[])ProjectJdkTable.getInstance().getAllJdks(), (VirtualFile)file, (SdkType)((SdkType)PythonSdkType.getInstance()), (SdkAdditionalData)((SdkAdditionalData)new PyPoetrySdkAdditionalData()), (String)PoetryKt.suggestedSdkName((Path)basePath));
        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"setupSdk(...)");
        Sdk sdk3 = sdk2;
        ApplicationManager.getApplication().invokeAndWait(() -> PyPoetrySdkConfiguration.createPoetry$lambda$6((Path)path2, (Path)basePath, sdk3, module));
        return sdk3;
    }

    private static final void askForEnvData$lambda$1(Module $module, Ref.BooleanRef $permitted, Ref.ObjectRef $envData) {
        Dialog dialog = new Dialog($module);
        $permitted.element = dialog.showAndGet();
        $envData.element = dialog.getEnvData();
        LOGGER.debug("Dialog exit code: " + dialog.getExitCode() + ", " + $permitted.element);
    }

    private static final void createPoetry$lambda$6(Path $path, Path $basePath, Sdk $sdk, Module $module) {
        LOGGER.debug("Adding associated poetry environment: " + $path + ", " + $basePath);
        PySdkExtKt.setAssociationToModule((Sdk)$sdk, (Module)$module);
        SdkConfigurationUtil.addSdk((Sdk)$sdk);
    }

    static {
        Logger logger = Logger.getInstance(PyPoetrySdkConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/pycharm/community/ide/impl/configuration/PyPoetrySdkConfiguration$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.pycharm.community.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/pycharm/community/ide/impl/configuration/PyPoetrySdkConfiguration$Dialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "panel", "Lcom/jetbrains/python/sdk/poetry/ui/PyAddNewPoetryFromFilePanel;", "envData", "Lcom/jetbrains/python/sdk/poetry/ui/PyAddNewPoetryFromFilePanel$Data;", "getEnvData", "()Lcom/jetbrains/python/sdk/poetry/ui/PyAddNewPoetryFromFilePanel$Data;", "createCenterPanel", "Ljavax/swing/JComponent;", "postponeValidation", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.pycharm.community.ide.impl"})
    private static final class Dialog
    extends DialogWrapper {
        @NotNull
        private final PyAddNewPoetryFromFilePanel panel;

        public Dialog(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(module.getProject(), false, DialogWrapper.IdeModalityType.IDE);
            this.panel = new PyAddNewPoetryFromFilePanel(module);
            this.setTitle(PyCharmCommunityCustomizationBundle.message("sdk.dialog.title.setting.up.poetry.environment", new Object[0]));
            this.init();
        }

        @NotNull
        public final PyAddNewPoetryFromFilePanel.Data getEnvData() {
            return this.panel.getEnvData();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JPanel jPanel;
            JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
            boolean bl = false;
            Border border = IdeBorderFactory.createEmptyBorder((Insets)((Insets)JBUI.insets((int)4, (int)0, (int)6, (int)0)));
            String string = PyCharmCommunityCustomizationBundle.message("sdk.notification.label.set.up.poetry.environment.from.pyproject.toml.dependencies", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            $this$createCenterPanel_u24lambda_u240.add((Component)JBUI.Panels.simplePanel((Component)((Component)new JBLabel(message))).withBorder(border), "North");
            $this$createCenterPanel_u24lambda_u240.add((Component)this.panel, "Center");
            return jPanel;
        }

        protected boolean postponeValidation() {
            return false;
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            return this.panel.validateAll();
        }
    }
}

