/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.BusState;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusImplKt;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.RootBus;
import com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 a2\u00020\u0001:\u0002`aB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010 \u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J%\u0010'\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u000bH\u0016\u00a2\u0006\u0002\u0010*J%\u0010+\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u000bH\u0016\u00a2\u0006\u0002\u0010*J/\u0010,\u001a\b\u0012\u0004\u0012\u0002H(0-\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u000b2\u0006\u0010.\u001a\u00020/H\u0010\u00a2\u0006\u0002\b0J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000202J\b\u00104\u001a\u000202H\u0016J\r\u00105\u001a\u000202H\u0010\u00a2\u0006\u0002\b6J\u0014\u0010:\u001a\u0002082\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\r\u0010;\u001a\u000202H\u0000\u00a2\u0006\u0002\b<J\b\u0010=\u001a\u000202H\u0002J\b\u0010>\u001a\u000202H\u0002J1\u0010?\u001a\u0002022\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u000b2\u000e\u0010@\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0A2\u0006\u0010B\u001a\u000208H\u0010\u00a2\u0006\u0002\bCJ#\u0010D\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00112\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0010\u00a2\u0006\u0004\bE\u0010FJ\r\u0010G\u001a\u000208H\u0010\u00a2\u0006\u0002\bHJ\u0019\u0010I\u001a\u0002022\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0000\u00a2\u0006\u0002\bJJ\u0019\u0010K\u001a\u0002022\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0010\u00a2\u0006\u0002\bLJ\b\u0010M\u001a\u000202H\u0016J\u001d\u0010N\u001a\u0002082\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0010\u00a2\u0006\u0004\bP\u0010QJ\u001d\u0010R\u001a\u0002022\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0010\u00a2\u0006\u0004\bS\u0010TJ\u0015\u0010U\u001a\u0002022\u0006\u0010V\u001a\u00020WH\u0000\u00a2\u0006\u0002\bXJ\u000e\u0010Y\u001a\u0002022\u0006\u0010Z\u001a\u00020\u001aJ\u000e\u0010[\u001a\u0002022\u0006\u0010Z\u001a\u00020\u001aJ\u001a\u0010\\\u001a\u0002022\u0010\u0010]\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030_0^H\u0016R \u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00110\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00138\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u00107\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00109\u00a8\u0006b"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/MessageBus;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "Lcom/intellij/util/messages/impl/CompositeMessageBus;", "<init>", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "publisherCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/messages/Topic;", "", "subscribers", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "subscriberCache", "", "rootBus", "Lcom/intellij/util/messages/impl/RootBus;", "disposeState", "Lcom/intellij/util/messages/impl/BusState;", "connectionDisposable", "Lcom/intellij/openapi/Disposable;", "messageDeliveryListeners", "", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "parent", "getParent", "()Lcom/intellij/util/messages/MessageBus;", "toString", "", "connect", "Lcom/intellij/util/messages/MessageBusConnection;", "parentDisposable", "simpleConnect", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "syncPublisher", "L", "topic", "(Lcom/intellij/util/messages/Topic;)Ljava/lang/Object;", "syncAndPreloadPublisher", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "disposeConnectionChildren", "", "disposeConnection", "dispose", "disposeChildren", "disposeChildren$intellij_platform_core", "isDisposed", "", "()Z", "hasUndeliveredEvents", "checkDisposed", "checkDisposed$intellij_platform_core", "checkBusDisposed", "checkOwnerDisposed", "doComputeSubscribers", "result", "", "subscribeLazyListeners", "doComputeSubscribers$intellij_platform_core", "computeSubscribers", "computeSubscribers$intellij_platform_core", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "hasChildren", "hasChildren$intellij_platform_core", "notifyOnSubscription", "notifyOnSubscription$intellij_platform_core", "notifyOnSubscriptionToTopicToChildren", "notifyOnSubscriptionToTopicToChildren$intellij_platform_core", "removeEmptyConnectionsRecursively", "notifyConnectionTerminated", "topicAndHandlerPairs", "notifyConnectionTerminated$intellij_platform_core", "([Ljava/lang/Object;)Z", "clearSubscriberCache", "clearSubscriberCache$intellij_platform_core", "([Ljava/lang/Object;)V", "deliverImmediately", "connection", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "deliverImmediately$intellij_platform_core", "addMessageDeliveryListener", "listener", "removeMessageDeliveryListener", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "MessageHandlerHolder", "Companion", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMessageBusImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,790:1\n1755#2,3:791\n37#3,2:794\n1#4:796\n14#5:797\n*S KotlinDebug\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImpl\n*L\n200#1:791,3\n244#1:794,2\n47#1:797\n*E\n"})
public class MessageBusImpl
implements MessageBus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ConcurrentMap<Topic<?>, Object> publisherCache;
    @JvmField
    @NotNull
    public final ConcurrentLinkedQueue<MessageHandlerHolder> subscribers;
    @JvmField
    @NotNull
    public final ConcurrentMap<Topic<?>, Object[]> subscriberCache;
    @JvmField
    @Nullable
    public final CompositeMessageBus parentBus;
    @JvmField
    @NotNull
    public final RootBus rootBus;
    @JvmField
    @NotNull
    public final MessageBusOwner owner;
    @NotNull
    private BusState disposeState;
    @Nullable
    private Disposable connectionDisposable;
    @JvmField
    @NotNull
    public Set<MessageDeliveryListener> messageDeliveryListeners;
    @JvmField
    @NotNull
    public static final Logger LOG;

    public MessageBusImpl(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(parentBus, "parentBus");
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue();
        this.subscriberCache = new ConcurrentHashMap();
        this.disposeState = BusState.Alive.INSTANCE;
        this.connectionDisposable = Disposer.newDisposable();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, "newKeySet(...)");
        this.messageDeliveryListeners = keySetView;
        this.owner = owner;
        this.parentBus = parentBus;
        this.rootBus = parentBus.rootBus;
        parentBus.addChild(this);
    }

    public MessageBusImpl(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue();
        this.subscriberCache = new ConcurrentHashMap();
        this.disposeState = BusState.Alive.INSTANCE;
        this.connectionDisposable = Disposer.newDisposable();
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, "newKeySet(...)");
        this.messageDeliveryListeners = keySetView;
        this.owner = owner;
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type com.intellij.util.messages.impl.RootBus");
        this.rootBus = (RootBus)this;
        this.parentBus = null;
    }

    @Nullable
    public MessageBus getParent() {
        return this.parentBus;
    }

    @NotNull
    public String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ')';
    }

    @NotNull
    public MessageBusConnection connect() {
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull(disposable);
        return this.connect(disposable);
    }

    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(parentDisposable, "parentDisposable");
        this.checkDisposed$intellij_platform_core();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        Disposer.register(parentDisposable, (Disposable)((Object)connection));
        return connection;
    }

    @NotNull
    public SimpleMessageBusConnection simpleConnect() {
        this.checkDisposed$intellij_platform_core();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SimpleMessageBusConnection connect(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(coroutineScope, "coroutineScope");
        Job scopeJob = JobKt.getJob(coroutineScope.getCoroutineContext());
        JobKt.ensureActive(scopeJob);
        this.checkDisposed$intellij_platform_core();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        try {
            this.subscribers.add(connection);
        }
        finally {
            scopeJob.invokeOnCompletion(arg_0 -> MessageBusImpl.connect$lambda$0(connection, arg_0));
        }
        return connection;
    }

    @NotNull
    public <L> L syncPublisher(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        this.checkDisposed$intellij_platform_core();
        Object object = this.publisherCache.computeIfAbsent(topic, arg_0 -> MessageBusImpl.syncPublisher$lambda$2(arg_0 -> MessageBusImpl.syncPublisher$lambda$1(this, arg_0), arg_0));
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type L of com.intellij.util.messages.impl.MessageBusImpl.syncPublisher");
        return (L)object;
    }

    @NotNull
    public <L> L syncAndPreloadPublisher(@NotNull Topic<L> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        L publisher = this.syncPublisher(topic);
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(publisher);
        Intrinsics.checkNotNull(invocationHandler, "null cannot be cast to non-null type com.intellij.util.messages.impl.MessagePublisher<*>");
        ((MessagePublisher)invocationHandler).preload();
        return publisher;
    }

    @NotNull
    public <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(direction, "direction");
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
            }
            default: {
                LOG.error("Topic " + topic.getListenerClass().getName() + " broadcast direction TO_CHILDREN is not allowed for module level message bus. Please change to NONE or TO_PARENT");
                messagePublisher = new MessagePublisher<L>(topic, this);
            }
        }
        return messagePublisher;
    }

    public final void disposeConnectionChildren() {
        this.disposeState = BusState.Disposing.INSTANCE;
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull(disposable);
        Disposer.disposeChildren(disposable, arg_0 -> MessageBusImpl.disposeConnectionChildren$lambda$4(MessageBusImpl::disposeConnectionChildren$lambda$3, arg_0));
    }

    public final void disposeConnection() {
        Disposable disposable = this.connectionDisposable;
        Intrinsics.checkNotNull(disposable);
        Disposer.dispose(disposable);
        this.connectionDisposable = null;
    }

    public void dispose() {
        block1: {
            this.checkBusDisposed();
            this.disposeState = new BusState.Disposed(new Throwable());
            this.disposeChildren$intellij_platform_core();
            Disposable disposable = this.connectionDisposable;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose(it);
            }
            this.rootBus.getQueue$intellij_platform_core().queue.removeIf(arg_0 -> MessageBusImpl.dispose$lambda$7(arg_0 -> MessageBusImpl.dispose$lambda$6(this, arg_0), arg_0));
            CompositeMessageBus compositeMessageBus = this.parentBus;
            if (compositeMessageBus == null) break block1;
            compositeMessageBus.onChildBusDisposed$intellij_platform_core(this);
        }
    }

    public void disposeChildren$intellij_platform_core() {
    }

    public boolean isDisposed() {
        return this.disposeState instanceof BusState.Disposed || this.owner.isDisposed();
    }

    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(topic, "topic");
            if (this.isDisposed()) {
                return false;
            }
            MessageQueue queue = this.rootBus.getQueue$intellij_platform_core();
            Message current = queue.current;
            if (current != null && current.topic == topic && current.bus == this) {
                return true;
            }
            Iterable $this$any$iv = queue.queue;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Message it = (Message)element$iv;
                    boolean bl2 = false;
                    if (!(it.topic == topic && it.bus == this)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void checkDisposed$intellij_platform_core() {
        this.checkBusDisposed();
        this.checkOwnerDisposed();
    }

    private final void checkBusDisposed() {
        BusState state = this.disposeState;
        if (state instanceof BusState.Disposed) {
            if (RuntimeFlagsKt.isMessageBusThrowsWhenDisposed()) {
                throw new AlreadyDisposedException(this.toString()).initCause(((BusState.Disposed)state).where);
            }
            LOG.error("Already disposed: " + this, ((BusState.Disposed)state).where);
        }
    }

    private final void checkOwnerDisposed() {
        if (this.owner.isDisposed()) {
            if (RuntimeFlagsKt.isMessageBusThrowsWhenDisposed()) {
                throw new AlreadyDisposedException(this.toString());
            }
            LOG.error("Already disposed: " + this);
        }
    }

    public void doComputeSubscribers$intellij_platform_core(@NotNull Topic<?> topic, @NotNull List<? super Object> result2, boolean subscribeLazyListeners) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(result2, "result");
        Iterator<MessageHandlerHolder> iterator2 = this.subscribers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<MessageHandlerHolder> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            MessageHandlerHolder subscriber = iterator3.next();
            if (subscriber.isDisposed()) continue;
            subscriber.collectHandlers(topic, result2);
        }
    }

    @NotNull
    public Object[] computeSubscribers$intellij_platform_core(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, "topic");
        List result2 = new ArrayList();
        this.doComputeSubscribers$intellij_platform_core(topic, result2, true);
        if (result2.isEmpty()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue(ArrayUtilRt.EMPTY_OBJECT_ARRAY, "EMPTY_OBJECT_ARRAY");
        } else {
            Collection $this$toTypedArray$iv = result2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Object[0]);
        }
        return objectArray;
    }

    public boolean hasChildren$intellij_platform_core() {
        return false;
    }

    public final void notifyOnSubscription$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while (true) {
            CompositeMessageBus compositeMessageBus = parentBus.parentBus;
            if (compositeMessageBus == null) {
                break;
            }
            parentBus = compositeMessageBus;
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren$intellij_platform_core()) {
            this.notifyOnSubscriptionToTopicToChildren$intellij_platform_core(topic);
        }
    }

    public void notifyOnSubscriptionToTopicToChildren$intellij_platform_core(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, "topic");
    }

    public void removeEmptyConnectionsRecursively() {
        this.subscribers.removeIf(arg_0 -> MessageBusImpl.removeEmptyConnectionsRecursively$lambda$10(MessageBusImpl::removeEmptyConnectionsRecursively$lambda$9, arg_0));
    }

    public boolean notifyConnectionTerminated$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter(topicAndHandlerPairs, "topicAndHandlerPairs");
        if (!Intrinsics.areEqual(this.disposeState, BusState.Alive.INSTANCE)) {
            return false;
        }
        this.rootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImplKt.access$clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    public void clearSubscriberCache$intellij_platform_core(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter(topicAndHandlerPairs, "topicAndHandlerPairs");
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Map map2 = this.subscriberCache;
            Object object = topicAndHandlerPairs[i];
            TypeIntrinsics.asMutableMap(map2).remove(object);
        }
    }

    public final void deliverImmediately$intellij_platform_core(@NotNull MessageBusConnectionImpl connection) {
        block6: {
            Intrinsics.checkNotNullParameter(connection, "connection");
            this.checkBusDisposed();
            if (this.owner.isDisposed()) {
                return;
            }
            MessageQueue queue = this.rootBus.getQueue$intellij_platform_core();
            ArrayDeque<Message> jobs = queue.queue;
            if (jobs.isEmpty()) {
                return;
            }
            List list = MessageBusImplKt.access$deliverImmediately(connection, jobs);
            if (list == null) {
                return;
            }
            List newJobs = list;
            int n = ((Collection)newJobs).size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    jobs.addFirst((Message)newJobs.get(i));
                } while (0 <= n);
            }
            Throwable error = null;
            for (Message job2 : newJobs) {
                jobs.removeFirstOccurrence(job2);
                error = MessageBusImplKt.access$deliverMessage(job2, queue, error);
            }
            Throwable throwable = error;
            if (throwable == null) break block6;
            Throwable p0 = throwable;
            boolean $i$f$deliverImmediately$stub_for_inlining = false;
            boolean bl = false;
            MessageBusImplKt.throwError(p0);
        }
    }

    public final void addMessageDeliveryListener(@NotNull MessageDeliveryListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.messageDeliveryListeners.add(listener);
    }

    public final void removeMessageDeliveryListener(@NotNull MessageDeliveryListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.messageDeliveryListeners.remove(listener);
    }

    public void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Iterator<MessageHandlerHolder> iterator2 = this.subscribers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<MessageHandlerHolder> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            MessageHandlerHolder holder = iterator3.next();
            holder.disconnectIfNeeded(predicate);
        }
        this.subscriberCache.clear();
    }

    private static final Unit connect$lambda$0(SimpleMessageBusConnectionImpl $connection, Throwable it) {
        $connection.disconnect();
        return Unit.INSTANCE;
    }

    private static final Object syncPublisher$lambda$1(MessageBusImpl this$0, Topic topic1) {
        Class clazz = topic1.getListenerClass();
        Intrinsics.checkNotNullExpressionValue(clazz, "getListenerClass(...)");
        Class aClass = clazz;
        Intrinsics.checkNotNull(topic1);
        Topic.BroadcastDirection broadcastDirection = topic1.getBroadcastDirection();
        Intrinsics.checkNotNullExpressionValue(broadcastDirection, "getBroadcastDirection(...)");
        MessagePublisher publisher = this$0.createPublisher$intellij_platform_core(topic1, broadcastDirection);
        Class[] classArray = new Class[]{aClass};
        return Proxy.newProxyInstance(aClass.getClassLoader(), classArray, (InvocationHandler)publisher);
    }

    private static final Object syncPublisher$lambda$2(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    private static final boolean disposeConnectionChildren$lambda$3(Disposable it) {
        return true;
    }

    private static final boolean disposeConnectionChildren$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean dispose$lambda$6(MessageBusImpl this$0, Message it) {
        return it.bus == this$0;
    }

    private static final boolean dispose$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeEmptyConnectionsRecursively$lambda$9(MessageHandlerHolder it) {
        return it.isDisposed();
    }

    private static final boolean removeEmptyConnectionsRecursively$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MessageBusImpl.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00010\nH&J\u001a\u0010\u000b\u001a\u00020\u00062\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/messages/impl/MessageBusImpl$MessageHandlerHolder;", "", "isDisposed", "", "()Z", "collectHandlers", "", "topic", "Lcom/intellij/util/messages/Topic;", "result", "", "disconnectIfNeeded", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "intellij.platform.core"})
    public static interface MessageHandlerHolder {
        public boolean isDisposed();

        public void collectHandlers(@NotNull Topic<?> var1, @NotNull List<? super Object> var2);

        public void disconnectIfNeeded(@NotNull Predicate<Class<?>> var1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Topic.BroadcastDirection.values().length];
            try {
                nArray[Topic.BroadcastDirection.TO_PARENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Topic.BroadcastDirection.TO_DIRECT_CHILDREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

