/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.languagetool.JLanguageTool;

public class WordCoherencyDataLoader {
    public Map<String, Set<String>> loadWords(String path) {
        InputStream stream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(path);
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + path + ", line: " + line);
                }
                if (map.containsKey(parts[0])) {
                    ((Set)map.get(parts[0])).add(parts[1]);
                } else {
                    map.put(parts[0], Stream.of(parts[1]).collect(Collectors.toCollection(ObjectOpenHashSet::new)));
                }
                if (map.containsKey(parts[1])) {
                    ((Set)map.get(parts[1])).add(parts[0]);
                    continue;
                }
                map.put(parts[1], Stream.of(parts[0]).collect(Collectors.toCollection(ObjectOpenHashSet::new)));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load coherency data from " + path, e);
        }
        return Collections.unmodifiableMap(map);
    }
}

