/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.channels;

import com.intellij.station.comms.common.netty.channels.DomainServerSocketChannel;
import com.intellij.station.comms.common.netty.channels.DomainSocketChannel;
import com.intellij.station.comms.common.netty.channels.NioDomainSocketChannelConfig;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.SelectorProvider;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010\u0017\u001a\u00020\u0011H\u0014J\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010\u001a\u001a\u00020\u0011H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u0019H\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010&\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\u0010\u00100\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u00101\u001a\u00020\u0019H\u0016J\b\u00102\u001a\u00020\u0019H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/station/comms/common/netty/channels/NioDomainSocketChannel;", "Lio/netty/channel/nio/AbstractNioByteChannel;", "Lcom/intellij/station/comms/common/netty/channels/DomainSocketChannel;", "parent", "Lcom/intellij/station/comms/common/netty/channels/DomainServerSocketChannel;", "ch", "Ljava/nio/channels/SelectableChannel;", "<init>", "(Lcom/intellij/station/comms/common/netty/channels/DomainServerSocketChannel;Ljava/nio/channels/SelectableChannel;)V", "()V", "config", "Lcom/intellij/station/comms/common/netty/channels/NioDomainSocketChannelConfig;", "javaChannel", "Ljava/nio/channels/SocketChannel;", "localAddress", "Ljava/net/UnixDomainSocketAddress;", "doClose", "", "remoteAddress", "localAddress0", "Ljava/net/SocketAddress;", "remoteAddress0", "doBind", "doDisconnect", "doConnect", "", "doFinishConnect", "shutdownInput", "Lio/netty/channel/ChannelFuture;", "promise", "Lio/netty/channel/ChannelPromise;", "shutDownInput0", "isOutputShutdown", "shutdownOutput", "isShutdown", "shutdown", "shutdownOutputDone", "shutdownOutputFuture", "shutdownDone", "shutdownInputFuture", "doWriteFileRegion", "", "region", "Lio/netty/channel/FileRegion;", "doReadBytes", "", "buf", "Lio/netty/buffer/ByteBuf;", "doWriteBytes", "isActive", "isInputShutdown", "intellij.station.comms.common"})
@SourceDebugExtension(value={"SMAP\nNioDomainSocketChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioDomainSocketChannel.kt\ncom/intellij/station/comms/common/netty/channels/NioDomainSocketChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class NioDomainSocketChannel
extends AbstractNioByteChannel
implements DomainSocketChannel {
    @NotNull
    private final NioDomainSocketChannelConfig config;

    public NioDomainSocketChannel(@Nullable DomainServerSocketChannel parent, @NotNull SelectableChannel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        super((Channel)parent, ch);
        this.config = new NioDomainSocketChannelConfig(this, this.javaChannel());
    }

    public NioDomainSocketChannel() {
        SocketChannel socketChannel = SelectorProvider.provider().openSocketChannel(StandardProtocolFamily.UNIX);
        Intrinsics.checkNotNullExpressionValue((Object)socketChannel, (String)"openSocketChannel(...)");
        this(null, socketChannel);
    }

    @NotNull
    protected SocketChannel javaChannel() {
        SelectableChannel selectableChannel = super.javaChannel();
        Intrinsics.checkNotNull((Object)selectableChannel, (String)"null cannot be cast to non-null type java.nio.channels.SocketChannel");
        return (SocketChannel)selectableChannel;
    }

    @Override
    @Nullable
    public DomainServerSocketChannel parent() {
        return (DomainServerSocketChannel)super.parent();
    }

    @Override
    @Nullable
    public UnixDomainSocketAddress localAddress() {
        SocketAddress socketAddress = super.localAddress();
        return socketAddress instanceof UnixDomainSocketAddress ? (UnixDomainSocketAddress)socketAddress : null;
    }

    protected void doClose() {
        super.doClose();
        this.javaChannel().close();
    }

    @Override
    @Nullable
    public UnixDomainSocketAddress remoteAddress() {
        SocketAddress socketAddress = super.remoteAddress();
        return socketAddress instanceof UnixDomainSocketAddress ? (UnixDomainSocketAddress)socketAddress : null;
    }

    @NotNull
    protected SocketAddress localAddress0() {
        SocketAddress socketAddress = this.javaChannel().getLocalAddress();
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"getLocalAddress(...)");
        return socketAddress;
    }

    @NotNull
    protected SocketAddress remoteAddress0() {
        SocketAddress socketAddress = this.javaChannel().getRemoteAddress();
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"getRemoteAddress(...)");
        return socketAddress;
    }

    protected void doBind(@Nullable SocketAddress localAddress) {
        this.javaChannel().bind(localAddress);
    }

    protected void doDisconnect() {
        super.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doConnect(@Nullable SocketAddress remoteAddress, @Nullable SocketAddress localAddress) {
        boolean bl;
        SocketAddress socketAddress = localAddress;
        if (socketAddress != null) {
            SocketAddress it = socketAddress;
            boolean bl2 = false;
            this.bind(it);
        }
        boolean success = false;
        try {
            boolean connected = this.javaChannel().connect(remoteAddress);
            if (!connected) {
                this.selectionKey().interestOps(8);
            }
            success = true;
            bl = connected;
        }
        catch (Throwable throwable) {
            if (!success) {
                this.doClose();
            }
            throw throwable;
        }
        return bl;
    }

    protected void doFinishConnect() {
        boolean bl = this.javaChannel().finishConnect();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public ChannelFuture shutdownInput() {
        ChannelPromise channelPromise = this.newPromise();
        Intrinsics.checkNotNullExpressionValue((Object)channelPromise, (String)"newPromise(...)");
        return this.shutdownInput(channelPromise);
    }

    @NotNull
    public ChannelFuture shutdownInput(@NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            this.shutDownInput0(promise);
        } else {
            loop.execute(() -> NioDomainSocketChannel.shutdownInput$lambda$1(this, promise));
        }
        return (ChannelFuture)promise;
    }

    private final ChannelFuture shutDownInput0(ChannelPromise promise) {
        try {
            this.javaChannel().shutdownInput();
            promise.setSuccess();
        }
        catch (Throwable t) {
            promise.setFailure(t);
        }
        return (ChannelFuture)promise;
    }

    public boolean isOutputShutdown() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public ChannelFuture shutdownOutput() {
        ChannelPromise channelPromise = this.newPromise();
        Intrinsics.checkNotNullExpressionValue((Object)channelPromise, (String)"newPromise(...)");
        return this.shutdownOutput(channelPromise);
    }

    @NotNull
    public ChannelFuture shutdownOutput(@NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            AbstractNioChannel.NioUnsafe nioUnsafe = this.unsafe();
            Intrinsics.checkNotNull((Object)nioUnsafe, (String)"null cannot be cast to non-null type io.netty.channel.AbstractChannel.AbstractUnsafe");
            ((AbstractChannel.AbstractUnsafe)nioUnsafe).shutdownOutput(promise);
        } else {
            loop.execute(() -> NioDomainSocketChannel.shutdownOutput$lambda$2(this, promise));
        }
        return (ChannelFuture)promise;
    }

    public boolean isShutdown() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public ChannelFuture shutdown() {
        ChannelPromise channelPromise = this.newPromise();
        Intrinsics.checkNotNullExpressionValue((Object)channelPromise, (String)"newPromise(...)");
        return this.shutdown(channelPromise);
    }

    @NotNull
    public ChannelFuture shutdown(@NotNull ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            shutdownOutputFuture.addListener((GenericFutureListener)new ChannelFutureListener(this, promise){
                final /* synthetic */ NioDomainSocketChannel this$0;
                final /* synthetic */ ChannelPromise $promise;
                {
                    this.this$0 = $receiver;
                    this.$promise = $promise;
                }

                public void operationComplete(ChannelFuture shutdownOutputFuture) {
                    Intrinsics.checkNotNullParameter((Object)shutdownOutputFuture, (String)"shutdownOutputFuture");
                    NioDomainSocketChannel.access$shutdownOutputDone(this.this$0, shutdownOutputFuture, this.$promise);
                }
            });
        }
        return (ChannelFuture)promise;
    }

    private final void shutdownOutputDone(ChannelFuture shutdownOutputFuture, ChannelPromise promise) {
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            this.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
        } else {
            shutdownInputFuture.addListener((GenericFutureListener)new ChannelFutureListener(this, shutdownInputFuture, promise){
                final /* synthetic */ NioDomainSocketChannel this$0;
                final /* synthetic */ ChannelFuture $shutdownInputFuture;
                final /* synthetic */ ChannelPromise $promise;
                {
                    this.this$0 = $receiver;
                    this.$shutdownInputFuture = $shutdownInputFuture;
                    this.$promise = $promise;
                }

                public void operationComplete(ChannelFuture shutdownOutputFuture) {
                    Intrinsics.checkNotNullParameter((Object)shutdownOutputFuture, (String)"shutdownOutputFuture");
                    NioDomainSocketChannel.access$shutdownDone(this.this$0, shutdownOutputFuture, this.$shutdownInputFuture, this.$promise);
                }
            });
        }
    }

    private final void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        block5: {
            Throwable throwable;
            block4: {
                Throwable shutDownCause;
                Throwable throwable2 = shutdownOutputFuture.cause();
                if (throwable2 == null) {
                    throwable2 = shutdownInputFuture.cause();
                }
                if ((throwable = (shutDownCause = throwable2)) == null) break block4;
                Throwable it = throwable;
                boolean bl = false;
                ChannelPromise channelPromise = promise.setFailure(it);
                throwable = channelPromise;
                if (channelPromise != null) break block5;
            }
            throwable = promise.setSuccess();
        }
    }

    protected long doWriteFileRegion(@NotNull FileRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        long position = region.transferred();
        return region.transferTo((WritableByteChannel)this.javaChannel(), position);
    }

    protected int doReadBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        allocHandle.attemptedBytesRead(buf.writableBytes());
        return buf.writeBytes((ScatteringByteChannel)this.javaChannel(), allocHandle.attemptedBytesRead());
    }

    protected int doWriteBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int expectedWrittenBytes = buf.readableBytes();
        return buf.readBytes((GatheringByteChannel)this.javaChannel(), expectedWrittenBytes);
    }

    @NotNull
    public NioDomainSocketChannelConfig config() {
        return this.config;
    }

    public boolean isActive() {
        return this.javaChannel().isOpen() && this.javaChannel().isConnected();
    }

    public boolean isInputShutdown() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private static final void shutdownInput$lambda$1(NioDomainSocketChannel this$0, ChannelPromise $promise) {
        this$0.shutDownInput0($promise);
    }

    private static final void shutdownOutput$lambda$2(NioDomainSocketChannel this$0, ChannelPromise $promise) {
        AbstractNioChannel.NioUnsafe nioUnsafe = this$0.unsafe();
        Intrinsics.checkNotNull((Object)nioUnsafe, (String)"null cannot be cast to non-null type io.netty.channel.AbstractChannel.AbstractUnsafe");
        ((AbstractChannel.AbstractUnsafe)nioUnsafe).shutdownOutput($promise);
    }

    public static final /* synthetic */ void access$shutdownOutputDone(NioDomainSocketChannel $this, ChannelFuture shutdownOutputFuture, ChannelPromise promise) {
        $this.shutdownOutputDone(shutdownOutputFuture, promise);
    }

    public static final /* synthetic */ void access$shutdownDone(NioDomainSocketChannel $this, ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        $this.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
    }
}

