"use strict";

var _events = require("events");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/* eslint-disable */
// transpiled typescript->javascript from
// https://github.com/aurelia/pal-nodejs/blob/master/src/polyfills/mutation-observer.ts

/*
 * Based on Shim for MutationObserver interface
 * Author: Graeme Yeates (github.com/megawac)
 * Repository: https://github.com/megawac/MutationObserver.js
 */

var __extends = void 0 && (void 0).__extends || function () {
  var extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return function (d, b) {
    extendStatics(d, b);
    function __() {
      this.constructor = d;
    }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();
module.exports = {};
Object.defineProperty(module.exports, '__esModule', {
  value: true
});
var Util = /** @class */function () {
  function Util() {}
  Util.clone = function ($target, config) {
    var recurse = true; // set true so childList we'll always check the first level
    return function copy($target) {
      var elestruct = {
        /** @type {Node} */
        node: $target,
        charData: null,
        attr: null,
        kids: null
      };
      // Store current character data of target text or comment node if the config requests
      // those properties to be observed.
      if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
        elestruct.charData = $target.nodeValue;
      } else {
        // Add attr only if subtree is specified or top level and avoid if
        // attributes is a document object (#13).
        if (config.attr && recurse && $target.nodeType === 1) {
          /**
           * clone live attribute list to an object structure {name: val}
           * @type {Object.<string, string>}
           */
          elestruct.attr = Util.reduce($target.attributes, function (memo, attr) {
            if (!config.afilter || config.afilter[attr.name]) {
              memo[attr.name] = attr.value;
            }
            return memo;
          }, {});
        }
        // whether we should iterate the children of $target node
        if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
          /** @type {Array.<!Object>} : Array of custom clone */
          elestruct.kids = Util.map($target.childNodes, copy);
        }
        recurse = config.descendents;
      }
      return elestruct;
    }($target);
  };
  /**
   * indexOf an element in a collection of custom nodes
   *
   * @param {NodeList} set
   * @param {!Object} $node : A custom cloned nodeg333
   * @param {number} idx : index to start the loop
   * @return {number}
   */
  Util.indexOfCustomNode = function (set, $node, idx) {
    var JSCompiler_renameProperty = function (a) {
      return a;
    };
    return this.indexOf(set, $node, idx, JSCompiler_renameProperty('node'));
  };
  /**
   * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
   *
   * @param {Node} $ele
   * @return {(string|number)}
   */
  Util.getElementId = function ($ele) {
    try {
      return $ele.id || ($ele[this.expando] = $ele[this.expando] || this.counter++);
    } catch (e) {
      // ie <8 will throw if you set an unknown property on a text node
      try {
        return $ele.nodeValue; // naive
      } catch (shitie) {
        // when text node is removed: https://gist.github.com/megawac/8355978 :(
        return this.counter++;
      }
    }
  };
  /**
   * **map** Apply a mapping function to each item of a set
   * @param {Array|NodeList} set
   * @param {Function} iterator
   */
  Util.map = function (set, iterator) {
    var results = [];
    for (var index = 0; index < set.length; index++) {
      results[index] = iterator(set[index], index, set);
    }
    return results;
  };
  /**
   * **Reduce** builds up a single result from a list of values
   * @param {Array|NodeList|NamedNodeMap} set
   * @param {Function} iterator
   * @param {*} [memo] Initial value of the memo.
   */
  Util.reduce = function (set, iterator, memo) {
    for (var index = 0; index < set.length; index++) {
      memo = iterator(memo, set[index], index, set);
    }
    return memo;
  };
  /**
   * **indexOf** find index of item in collection.
   * @param {Array|NodeList} set
   * @param {Object} item
   * @param {number} idx
   * @param {string} [prop] Property on set item to compare to item
   */
  Util.indexOf = function (set, item, idx, prop) {
    for (; /*idx = ~~idx*/idx < set.length; idx++) {
      // start idx is always given as this is internal
      if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
    }
    return -1;
  };
  /**
   * @param {Object} obj
   * @param {(string|number)} prop
   * @return {boolean}
   */
  Util.has = function (obj, prop) {
    return obj[prop] !== undefined; // will be nicely inlined by gcc
  };

  Util.counter = 1;
  Util.expando = 'mo_id';
  return Util;
}();
module.exports.Util = Util;
var MutationObserver = /** @class */function () {
  function MutationObserver(listener) {
    var _this = this;
    this._watched = [];
    this._listener = null;
    this._period = 30;
    this._timeout = null;
    this._disposed = false;
    this._notifyListener = null;
    this._watched = [];
    this._listener = listener;
    this._period = 30;
    this._notifyListener = function () {
      _this.scheduleMutationCheck(_this);
    };
  }
  MutationObserver.prototype.observe = function ($target, config) {
    var settings = {
      attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
      // some browsers enforce that subtree must be set with childList, attributes or characterData.
      // We don't care as spec doesn't specify this rule.
      kids: !!config.childList,
      descendents: !!config.subtree,
      charData: !!(config.characterData || config.characterDataOldValue),
      afilter: null
    };
    MutationNotifier.getInstance().on('changed', this._notifyListener);
    var watched = this._watched;
    // remove already observed target element from pool
    for (var i = 0; i < watched.length; i++) {
      if (watched[i].tar === $target) watched.splice(i, 1);
    }
    if (config.attributeFilter) {
      /**
       * converts to a {key: true} dict for faster lookup
       * @type {Object.<String,Boolean>}
       */
      settings.afilter = Util.reduce(config.attributeFilter, function (a, b) {
        a[b] = true;
        return a;
      }, {});
    }
    watched.push({
      tar: $target,
      fn: this.createMutationSearcher($target, settings)
    });
  };
  MutationObserver.prototype.takeRecords = function () {
    var mutations = [];
    var watched = this._watched;
    for (var i = 0; i < watched.length; i++) {
      watched[i].fn(mutations);
    }
    return mutations;
  };
  MutationObserver.prototype.disconnect = function () {
    this._watched = []; // clear the stuff being observed
    MutationNotifier.getInstance().removeListener('changed', this._notifyListener);
    this._disposed = true;
    clearTimeout(this._timeout); // ready for garbage collection
    this._timeout = null;
  };
  MutationObserver.prototype.createMutationSearcher = function ($target, config) {
    var _this = this;
    /** type {Elestuct} */
    var $oldstate = Util.clone($target, config); // create the cloned datastructure
    /**
     * consumes array of mutations we can push to
     *
     * @param {Array.<MutationRecord>} mutations
     */
    return function (mutations) {
      var olen = mutations.length;
      var dirty;
      if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
        mutations.push(new MutationRecord({
          type: 'characterData',
          target: $target,
          oldValue: $oldstate.charData
        }));
      }
      // Alright we check base level changes in attributes... easy
      if (config.attr && $oldstate.attr) {
        _this.findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
      }
      // check childlist or subtree for mutations
      if (config.kids || config.descendents) {
        dirty = _this.searchSubtree(mutations, $target, $oldstate, config);
      }
      // reclone data structure if theres changes
      if (dirty || mutations.length !== olen) {
        /** type {Elestuct} */
        $oldstate = Util.clone($target, config);
      }
    };
  };
  MutationObserver.prototype.scheduleMutationCheck = function (observer) {
    var _this = this;
    // Only schedule if there isn't already a timer.
    if (!observer._timeout) {
      observer._timeout = setTimeout(function () {
        return _this.mutationChecker(observer);
      }, this._period);
    }
  };
  MutationObserver.prototype.mutationChecker = function (observer) {
    // allow scheduling a new timer.
    observer._timeout = null;
    var mutations = observer.takeRecords();
    if (mutations.length) {
      // fire away
      // calling the listener with context is not spec but currently consistent with FF and WebKit
      observer._listener(mutations, observer);
    }
  };
  MutationObserver.prototype.searchSubtree = function (mutations, $target, $oldstate, config) {
    var _this = this;
    // Track if the tree is dirty and has to be recomputed (#14).
    var dirty;
    /*
     * Helper to identify node rearrangment and stuff...
     * There is no gaurentee that the same node will be identified for both added and removed nodes
     * if the positions have been shuffled.
     * conflicts array will be emptied by end of operation
     */
    var _resolveConflicts = function (conflicts, node, $kids, $oldkids, numAddedNodes) {
      // the distance between the first conflicting node and the last
      var distance = conflicts.length - 1;
      // prevents same conflict being resolved twice consider when two nodes switch places.
      // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)
      var counter = -~((distance - numAddedNodes) / 2);
      var $cur;
      var oldstruct;
      var conflict;
      while (conflict = conflicts.pop()) {
        $cur = $kids[conflict.i];
        oldstruct = $oldkids[conflict.j];
        // attempt to determine if there was node rearrangement... won't gaurentee all matches
        // also handles case where added/removed nodes cause nodes to be identified as conflicts
        if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
          mutations.push(new MutationRecord({
            type: 'childList',
            target: node,
            addedNodes: [$cur],
            removedNodes: [$cur],
            // haha don't rely on this please
            nextSibling: $cur.nextSibling,
            previousSibling: $cur.previousSibling
          }));
          counter--; // found conflict
        }
        // Alright we found the resorted nodes now check for other types of mutations
        if (config.attr && oldstruct.attr) _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
        if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
          mutations.push(new MutationRecord({
            type: 'characterData',
            target: $cur,
            oldValue: oldstruct.charData
          }));
        }
        // now look @ subtree
        if (config.descendents) _findMutations($cur, oldstruct);
      }
    };
    /**
     * Main worker. Finds and adds mutations if there are any
     * @param {Node} node
     * @param {!Object} old : A cloned data structure using internal clone
     */
    var _findMutations = function (node, old) {
      var $kids = node.childNodes;
      var $oldkids = old.kids;
      var klen = $kids.length;
      // $oldkids will be undefined for text and comment nodes
      var olen = $oldkids ? $oldkids.length : 0;
      // if (!olen && !klen) return; // both empty; clearly no changes
      // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
      // map of checked element of ids to prevent registering the same conflict twice
      var map;
      // array of potential conflicts (ie nodes that may have been re arranged)
      var conflicts;
      var id; // element id from getElementId helper
      var idx; // index of a moved or inserted element
      var oldstruct;
      // current and old nodes
      var $cur;
      var $old;
      // track the number of added nodes so we can resolve conflicts more accurately
      var numAddedNodes = 0;
      // iterate over both old and current child nodes at the same time
      var i = 0;
      var j = 0;
      // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)
      while (i < klen || j < olen) {
        // current and old nodes at the indexs
        $cur = $kids[i];
        oldstruct = $oldkids[j];
        $old = oldstruct && oldstruct.node;
        if ($cur === $old) {
          // expected case - optimized for this case
          // check attributes as specified by config
          if (config.attr && oldstruct.attr) {
            /* oldstruct.attr instead of textnode check */
            _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
          }
          // check character data if node is a comment or textNode and it's being observed
          if (config.charData && oldstruct.charData !== undefined && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(new MutationRecord({
              type: 'characterData',
              target: $cur
            }));
          }
          // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array
          if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
          // recurse on next level of children. Avoids the recursive call when there are no children left to iterate
          if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) _findMutations($cur, oldstruct);
          i++;
          j++;
        } else {
          // (uncommon case) lookahead until they are the same again or the end of children
          dirty = true;
          if (!map) {
            // delayed initalization (big perf benefit)
            map = {};
            conflicts = [];
          }
          if ($cur) {
            // check id is in the location map otherwise do a indexOf search
            if (!map[id = Util.getElementId($cur)]) {
              // to prevent double checking
              // mark id as found
              map[id] = true;
              // custom indexOf using comparitor checking oldkids[i].node === $cur
              if ((idx = Util.indexOfCustomNode($oldkids, $cur, j)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: node,
                    addedNodes: [$cur],
                    nextSibling: $cur.nextSibling,
                    previousSibling: $cur.previousSibling
                  }));
                  numAddedNodes++;
                }
              } else {
                conflicts.push({
                  i: i,
                  j: idx
                });
              }
            }
            i++;
          }
          if ($old &&
          // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
          $old !== $kids[i]) {
            if (!map[id = Util.getElementId($old)]) {
              map[id] = true;
              if ((idx = Util.indexOf($kids, $old, i)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: old.node,
                    removedNodes: [$old],
                    nextSibling: $oldkids[j + 1],
                    previousSibling: $oldkids[j - 1]
                  }));
                  numAddedNodes--;
                }
              } else {
                conflicts.push({
                  i: idx,
                  j: j
                });
              }
            }
            j++;
          }
        } // end uncommon case
      } // end loop
      // resolve any remaining conflicts
      if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
    };
    _findMutations($target, $oldstate);
    return dirty;
  };
  MutationObserver.prototype.findAttributeMutations = function (mutations, $target, $oldstate, filter) {
    var checked = {};
    var attributes = $target.attributes;
    var attr;
    var name;
    var i = attributes.length;
    while (i--) {
      attr = attributes[i];
      name = attr.name;
      if (!filter || Util.has(filter, name)) {
        if (attr.value !== $oldstate[name]) {
          // The pushing is redundant but gzips very nicely
          mutations.push(new MutationRecord({
            type: 'attributes',
            target: $target,
            attributeName: name,
            oldValue: $oldstate[name],
            attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined
          }));
        }

        checked[name] = true;
      }
    }
    for (name in $oldstate) {
      if (!checked[name]) {
        mutations.push(new MutationRecord({
          target: $target,
          type: 'attributes',
          attributeName: name,
          oldValue: $oldstate[name]
        }));
      }
    }
  };
  return MutationObserver;
}();
module.exports.MutationObserver = MutationObserver;
var MutationRecord = /** @class */function () {
  function MutationRecord(data) {
    var settings = {
      type: null,
      target: null,
      addedNodes: [],
      removedNodes: [],
      previousSibling: null,
      nextSibling: null,
      attributeName: null,
      attributeNamespace: null,
      oldValue: null
    };
    for (var prop in data) {
      if (Util.has(settings, prop) && data[prop] !== undefined) settings[prop] = data[prop];
    }
    return settings;
  }
  return MutationRecord;
}();
module.exports.MutationRecord = MutationRecord;
var MutationNotifier = /** @class */function (_super) {
  __extends(MutationNotifier, _super);
  function MutationNotifier() {
    var _this = _super.call(this) || this;
    _this.setMaxListeners(100);
    return _this;
  }
  MutationNotifier.getInstance = function () {
    if (!MutationNotifier._instance) {
      MutationNotifier._instance = new MutationNotifier();
    }
    return MutationNotifier._instance;
  };
  MutationNotifier.prototype.destruct = function () {
    this.removeAllListeners('changed');
  };
  MutationNotifier.prototype.notifyChanged = function (node) {
    this.emit('changed', node);
  };
  MutationNotifier._instance = null;
  return MutationNotifier;
}(_events.EventEmitter);
module.exports.MutationNotifier = MutationNotifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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