"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderGrids = void 0;
var canvas_1 = require("../../../../renderers/canvas");
var line_1 = require("./primitives/line");
function renderGrids(ctx, props) {
    var perPanelGridLines = props.perPanelGridLines, _a = props.renderingArea, left = _a.left, top = _a.top;
    canvas_1.withContext(ctx, function (ctx) {
        ctx.translate(left, top);
        perPanelGridLines.forEach(function (_a) {
            var lineGroups = _a.lineGroups, _b = _a.panelAnchor, x = _b.x, y = _b.y;
            canvas_1.withContext(ctx, function (ctx) {
                ctx.translate(x, y);
                lineGroups.forEach(function (_a) {
                    var lines = _a.lines, stroke = _a.stroke;
                    line_1.renderMultiLine(ctx, lines, stroke);
                });
            });
        });
    });
}
exports.renderGrids = renderGrids;
//# sourceMappingURL=grids.js.map