/* $NetBSD: freebsd_sysent.c,v 1.93 2019/06/18 01:42:44 christos Exp $ */

/*
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.73 2019/06/18 01:42:36 christos Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: freebsd_sysent.c,v 1.93 2019/06/18 01:42:44 christos Exp $");

#if defined(_KERNEL_OPT)
#include "opt_ktrace.h"
#include "opt_ntp.h"
#include "opt_sysv.h"
#include "opt_compat_43.h"
#include "opt_quota.h"
#endif
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/syscallargs.h>
#include <compat/sys/signal.h>
#include <compat/sys/time.h>
#include <compat/freebsd/freebsd_syscallargs.h>
#include <compat/freebsd/freebsd_machdep.h>

#define	s(type)	sizeof(type)
#define	n(type)	(sizeof(type)/sizeof (register_t))
#define	ns(type)	.sy_narg = n(type), .sy_argsize = s(type)

struct sysent freebsd_sysent[] = {
	{
		.sy_call = (sy_call_t *)sys_nosys
	},		/* 0 = syscall */
	{
		ns(struct sys_exit_args),
		.sy_call = (sy_call_t *)sys_exit
	},		/* 1 = exit */
	{
		.sy_call = (sy_call_t *)sys_fork
	},		/* 2 = fork */
	{
		ns(struct sys_read_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_read
	},		/* 3 = read */
	{
		ns(struct sys_write_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_write
	},		/* 4 = write */
	{
		ns(struct sys_open_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_open
	},		/* 5 = open */
	{
		ns(struct sys_close_args),
		.sy_call = (sy_call_t *)sys_close
	},		/* 6 = close */
	{
		ns(struct compat_50_sys_wait4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_wait4
	},		/* 7 = wait4 */
	{
		ns(struct compat_43_sys_creat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_creat
	},		/* 8 = ocreat */
	{
		ns(struct sys_link_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_link
	},		/* 9 = link */
	{
		ns(struct sys_unlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_unlink
	},		/* 10 = unlink */
	{
		.sy_call = sys_nosys,
	},		/* 11 = filler */
	{
		ns(struct sys_chdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chdir
	},		/* 12 = chdir */
	{
		ns(struct sys_fchdir_args),
		.sy_call = (sy_call_t *)sys_fchdir
	},		/* 13 = fchdir */
	{
		ns(struct compat_50_sys_mknod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_mknod
	},		/* 14 = mknod */
	{
		ns(struct sys_chmod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chmod
	},		/* 15 = chmod */
	{
		ns(struct sys_chown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chown
	},		/* 16 = chown */
	{
		ns(struct sys_obreak_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_obreak
	},		/* 17 = break */
	{
		ns(struct compat_20_sys_getfsstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_20_sys_getfsstat
	},		/* 18 = getfsstat */
	{
		ns(struct compat_43_sys_lseek_args),
		.sy_call = (sy_call_t *)compat_43_sys_lseek
	},		/* 19 = olseek */
	{
		.sy_call = (sy_call_t *)sys_getpid_with_ppid
	},		/* 20 = getpid_with_ppid */
	{
		ns(struct freebsd_sys_mount_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_mount
	},		/* 21 = mount */
	{
		ns(struct sys_unmount_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_unmount
	},		/* 22 = unmount */
	{
		ns(struct sys_setuid_args),
		.sy_call = (sy_call_t *)sys_setuid
	},		/* 23 = setuid */
	{
		.sy_call = (sy_call_t *)sys_getuid_with_euid
	},		/* 24 = getuid_with_euid */
	{
		.sy_call = (sy_call_t *)sys_geteuid
	},		/* 25 = geteuid */
	{
		ns(struct freebsd_sys_ptrace_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_ptrace
	},		/* 26 = ptrace */
	{
		ns(struct sys_recvmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_recvmsg
	},		/* 27 = recvmsg */
	{
		ns(struct sys_sendmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_sendmsg
	},		/* 28 = sendmsg */
	{
		ns(struct sys_recvfrom_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_recvfrom
	},		/* 29 = recvfrom */
	{
		ns(struct sys_accept_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_accept
	},		/* 30 = accept */
	{
		ns(struct sys_getpeername_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getpeername
	},		/* 31 = getpeername */
	{
		ns(struct sys_getsockname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getsockname
	},		/* 32 = getsockname */
	{
		ns(struct sys_access_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_access
	},		/* 33 = access */
	{
		ns(struct sys_chflags_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chflags
	},		/* 34 = chflags */
	{
		ns(struct sys_fchflags_args),
		.sy_call = (sy_call_t *)sys_fchflags
	},		/* 35 = fchflags */
	{
		.sy_call = (sy_call_t *)sys_sync
	},		/* 36 = sync */
	{
		ns(struct sys_kill_args),
		.sy_call = (sy_call_t *)sys_kill
	},		/* 37 = kill */
	{
		ns(struct compat_43_sys_stat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_stat
	},		/* 38 = stat43 */
	{
		.sy_call = (sy_call_t *)sys_getppid
	},		/* 39 = getppid */
	{
		ns(struct compat_43_sys_lstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_lstat
	},		/* 40 = lstat43 */
	{
		ns(struct sys_dup_args),
		.sy_call = (sy_call_t *)sys_dup
	},		/* 41 = dup */
	{
		.sy_call = (sy_call_t *)sys_pipe
	},		/* 42 = pipe */
	{
		.sy_call = (sy_call_t *)sys_getegid
	},		/* 43 = getegid */
	{
		ns(struct sys_profil_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_profil
	},		/* 44 = profil */
#ifdef KTRACE
	{
		ns(struct sys_ktrace_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_ktrace
	},		/* 45 = ktrace */
#else
	{
		.sy_call = sys_nosys,
	},		/* 45 = filler */
#endif
	{
		ns(struct compat_13_sys_sigaction_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_13_sys_sigaction
	},		/* 46 = sigaction */
	{
		.sy_call = (sy_call_t *)sys_getgid_with_egid
	},		/* 47 = getgid_with_egid */
	{
		ns(struct compat_13_sys_sigprocmask_args),
		.sy_call = (sy_call_t *)compat_13_sys_sigprocmask
	},		/* 48 = sigprocmask */
	{
		ns(struct sys___getlogin_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___getlogin
	},		/* 49 = __getlogin */
	{
		ns(struct sys___setlogin_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___setlogin
	},		/* 50 = __setlogin */
	{
		ns(struct sys_acct_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_acct
	},		/* 51 = acct */
	{
		.sy_call = (sy_call_t *)compat_13_sys_sigpending
	},		/* 52 = sigpending */
	{
		ns(struct compat_13_sys_sigaltstack_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_13_sys_sigaltstack
	},		/* 53 = sigaltstack */
	{
		ns(struct freebsd_sys_ioctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_ioctl
	},		/* 54 = ioctl */
	{
		ns(struct sys_reboot_args),
		.sy_call = (sy_call_t *)sys_reboot
	},		/* 55 = oreboot */
	{
		ns(struct sys_revoke_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_revoke
	},		/* 56 = revoke */
	{
		ns(struct sys_symlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_symlink
	},		/* 57 = symlink */
	{
		ns(struct sys_readlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readlink
	},		/* 58 = readlink */
	{
		ns(struct sys_execve_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_execve
	},		/* 59 = execve */
	{
		ns(struct sys_umask_args),
		.sy_call = (sy_call_t *)sys_umask
	},		/* 60 = umask */
	{
		ns(struct sys_chroot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_chroot
	},		/* 61 = chroot */
	{
		ns(struct compat_43_sys_fstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_fstat
	},		/* 62 = fstat43 */
	{
		ns(struct compat_43_sys_getkerninfo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_getkerninfo
	},		/* 63 = ogetkerninfo */
	{
		.sy_call = (sy_call_t *)compat_43_sys_getpagesize
	},		/* 64 = ogetpagesize */
	{
		ns(struct freebsd_sys_msync_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_msync
	},		/* 65 = msync */
	{
		.sy_call = (sy_call_t *)sys_vfork
	},		/* 66 = vfork */
	{
		.sy_call = sys_nosys,
	},		/* 67 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 68 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 69 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 70 = filler */
	{
		ns(struct compat_43_sys_mmap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_mmap
	},		/* 71 = ommap */
	{
		ns(struct sys_ovadvise_args),
		.sy_call = (sy_call_t *)sys_ovadvise
	},		/* 72 = vadvise */
	{
		ns(struct sys_munmap_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munmap
	},		/* 73 = munmap */
	{
		ns(struct sys_mprotect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mprotect
	},		/* 74 = mprotect */
	{
		ns(struct sys_madvise_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_madvise
	},		/* 75 = madvise */
	{
		.sy_call = sys_nosys,
	},		/* 76 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 77 = filler */
	{
		ns(struct sys_mincore_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mincore
	},		/* 78 = mincore */
	{
		ns(struct sys_getgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getgroups
	},		/* 79 = getgroups */
	{
		ns(struct sys_setgroups_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_setgroups
	},		/* 80 = setgroups */
	{
		.sy_call = (sy_call_t *)sys_getpgrp
	},		/* 81 = getpgrp */
	{
		ns(struct sys_setpgid_args),
		.sy_call = (sy_call_t *)sys_setpgid
	},		/* 82 = setpgid */
	{
		ns(struct compat_50_sys_setitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_setitimer
	},		/* 83 = setitimer */
	{
		.sy_call = (sy_call_t *)compat_43_sys_wait
	},		/* 84 = owait */
	{
		ns(struct compat_12_sys_swapon_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_12_sys_swapon
	},		/* 85 = swapon */
	{
		ns(struct compat_50_sys_getitimer_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getitimer
	},		/* 86 = getitimer */
	{
		ns(struct compat_43_sys_gethostname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_gethostname
	},		/* 87 = ogethostname */
	{
		ns(struct compat_43_sys_sethostname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sethostname
	},		/* 88 = osethostname */
	{
		.sy_call = (sy_call_t *)compat_43_sys_getdtablesize
	},		/* 89 = ogetdtablesize */
	{
		ns(struct sys_dup2_args),
		.sy_call = (sy_call_t *)sys_dup2
	},		/* 90 = dup2 */
	{
		.sy_call = sys_nosys,
	},		/* 91 = filler */
	{
		ns(struct sys_fcntl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_fcntl
	},		/* 92 = fcntl */
	{
		ns(struct compat_50_sys_select_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_select
	},		/* 93 = select */
	{
		.sy_call = sys_nosys,
	},		/* 94 = filler */
	{
		ns(struct sys_fsync_args),
		.sy_call = (sy_call_t *)sys_fsync
	},		/* 95 = fsync */
	{
		ns(struct sys_setpriority_args),
		.sy_call = (sy_call_t *)sys_setpriority
	},		/* 96 = setpriority */
	{
		ns(struct compat_30_sys_socket_args),
		.sy_call = (sy_call_t *)compat_30_sys_socket
	},		/* 97 = socket */
	{
		ns(struct sys_connect_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_connect
	},		/* 98 = connect */
	{
		ns(struct compat_43_sys_accept_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_accept
	},		/* 99 = oaccept */
	{
		ns(struct sys_getpriority_args),
		.sy_call = (sy_call_t *)sys_getpriority
	},		/* 100 = getpriority */
	{
		ns(struct compat_43_sys_send_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_send
	},		/* 101 = osend */
	{
		ns(struct compat_43_sys_recv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_recv
	},		/* 102 = orecv */
	{
		ns(struct freebsd_sys_sigreturn_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_sigreturn
	},		/* 103 = sigreturn */
	{
		ns(struct sys_bind_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_bind
	},		/* 104 = bind */
	{
		ns(struct sys_setsockopt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_setsockopt
	},		/* 105 = setsockopt */
	{
		ns(struct sys_listen_args),
		.sy_call = (sy_call_t *)sys_listen
	},		/* 106 = listen */
	{
		.sy_call = sys_nosys,
	},		/* 107 = filler */
	{
		ns(struct compat_43_sys_sigvec_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sigvec
	},		/* 108 = osigvec */
	{
		ns(struct compat_43_sys_sigblock_args),
		.sy_call = (sy_call_t *)compat_43_sys_sigblock
	},		/* 109 = osigblock */
	{
		ns(struct compat_43_sys_sigsetmask_args),
		.sy_call = (sy_call_t *)compat_43_sys_sigsetmask
	},		/* 110 = osigsetmask */
	{
		ns(struct compat_13_sys_sigsuspend_args),
		.sy_call = (sy_call_t *)compat_13_sys_sigsuspend
	},		/* 111 = sigsuspend */
	{
		ns(struct compat_43_sys_sigstack_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sigstack
	},		/* 112 = osigstack */
	{
		ns(struct compat_43_sys_recvmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_recvmsg
	},		/* 113 = orecvmsg */
	{
		ns(struct compat_43_sys_sendmsg_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_sendmsg
	},		/* 114 = osendmsg */
#ifdef TRACE
	{
		ns(struct sys_vtrace_args),
		.sy_call = (sy_call_t *)sys_vtrace
	},		/* 115 = vtrace */
#else
	{
		.sy_call = sys_nosys,
	},		/* 115 = filler */
#endif
	{
		ns(struct compat_50_sys_gettimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_gettimeofday
	},		/* 116 = gettimeofday */
	{
		ns(struct compat_50_sys_getrusage_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_getrusage
	},		/* 117 = getrusage */
	{
		ns(struct sys_getsockopt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getsockopt
	},		/* 118 = getsockopt */
	{
		.sy_call = sys_nosys,
	},		/* 119 = filler */
	{
		ns(struct sys_readv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_readv
	},		/* 120 = readv */
	{
		ns(struct sys_writev_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_writev
	},		/* 121 = writev */
	{
		ns(struct compat_50_sys_settimeofday_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_settimeofday
	},		/* 122 = settimeofday */
	{
		ns(struct sys_fchown_args),
		.sy_call = (sy_call_t *)sys_fchown
	},		/* 123 = fchown */
	{
		ns(struct sys_fchmod_args),
		.sy_call = (sy_call_t *)sys_fchmod
	},		/* 124 = fchmod */
	{
		ns(struct compat_43_sys_recvfrom_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_recvfrom
	},		/* 125 = orecvfrom */
	{
		ns(struct sys_setreuid_args),
		.sy_call = (sy_call_t *)sys_setreuid
	},		/* 126 = setreuid */
	{
		ns(struct sys_setregid_args),
		.sy_call = (sy_call_t *)sys_setregid
	},		/* 127 = setregid */
	{
		ns(struct sys_rename_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_rename
	},		/* 128 = rename */
	{
		ns(struct compat_43_sys_truncate_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_truncate
	},		/* 129 = otruncate */
	{
		ns(struct compat_43_sys_ftruncate_args),
		.sy_call = (sy_call_t *)compat_43_sys_ftruncate
	},		/* 130 = oftruncate */
	{
		ns(struct sys_flock_args),
		.sy_call = (sy_call_t *)sys_flock
	},		/* 131 = flock */
	{
		ns(struct sys_mkfifo_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkfifo
	},		/* 132 = mkfifo */
	{
		ns(struct sys_sendto_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_sendto
	},		/* 133 = sendto */
	{
		ns(struct sys_shutdown_args),
		.sy_call = (sy_call_t *)sys_shutdown
	},		/* 134 = shutdown */
	{
		ns(struct sys_socketpair_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_socketpair
	},		/* 135 = socketpair */
	{
		ns(struct sys_mkdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mkdir
	},		/* 136 = mkdir */
	{
		ns(struct sys_rmdir_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_rmdir
	},		/* 137 = rmdir */
	{
		ns(struct compat_50_sys_utimes_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_utimes
	},		/* 138 = utimes */
	{
		.sy_call = sys_nosys,
	},		/* 139 = filler */
	{
		ns(struct compat_50_sys_adjtime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_adjtime
	},		/* 140 = adjtime */
	{
		ns(struct compat_43_sys_getpeername_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_getpeername
	},		/* 141 = ogetpeername */
	{
		.sy_call = (sy_call_t *)compat_43_sys_gethostid
	},		/* 142 = ogethostid */
	{
		ns(struct compat_43_sys_sethostid_args),
		.sy_call = (sy_call_t *)compat_43_sys_sethostid
	},		/* 143 = osethostid */
	{
		ns(struct compat_43_sys_getrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_getrlimit
	},		/* 144 = ogetrlimit */
	{
		ns(struct compat_43_sys_setrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_setrlimit
	},		/* 145 = osetrlimit */
	{
		ns(struct compat_43_sys_killpg_args),
		.sy_call = (sy_call_t *)compat_43_sys_killpg
	},		/* 146 = okillpg */
	{
		.sy_call = (sy_call_t *)sys_setsid
	},		/* 147 = setsid */
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	{
		ns(struct compat_50_sys_quotactl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_quotactl
	},		/* 148 = quotactl */
	{
		.sy_call = (sy_call_t *)compat_43_sys_quota
	},		/* 149 = oquota */
#else
	{
		.sy_call = sys_nosys,
	},		/* 148 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 149 = filler */
#endif
	{
		ns(struct compat_43_sys_getsockname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_getsockname
	},		/* 150 = ogetsockname */
	{
		.sy_call = sys_nosys,
	},		/* 151 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 152 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 153 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 154 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 155 = filler */
	{
		ns(struct compat_43_sys_getdirentries_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_43_sys_getdirentries
	},		/* 156 = ogetdirentries */
	{
		ns(struct compat_20_sys_statfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_20_sys_statfs
	},		/* 157 = statfs */
	{
		ns(struct compat_20_sys_fstatfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_20_sys_fstatfs
	},		/* 158 = fstatfs */
	{
		.sy_call = sys_nosys,
	},		/* 159 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 160 = filler */
	{
		ns(struct compat_30_sys_getfh_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_30_sys_getfh
	},		/* 161 = getfh */
	{
		ns(struct compat_09_sys_getdomainname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_09_sys_getdomainname
	},		/* 162 = getdomainname */
	{
		ns(struct compat_09_sys_setdomainname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_09_sys_setdomainname
	},		/* 163 = setdomainname */
	{
		ns(struct compat_09_sys_uname_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_09_sys_uname
	},		/* 164 = uname */
	{
		ns(struct sys_sysarch_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_sysarch
	},		/* 165 = sysarch */
	{
		ns(struct freebsd_sys_rtprio_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_rtprio
	},		/* 166 = rtprio */
	{
		.sy_call = sys_nosys,
	},		/* 167 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 168 = filler */
#if defined(SYSVSEM) && !defined(_LP64)
	{
		ns(struct freebsd_sys_semsys_args),
		.sy_call = (sy_call_t *)freebsd_sys_semsys
	},		/* 169 = semsys */
#else
	{
		.sy_call = sys_nosys,
	},		/* 169 = filler */
#endif
#if defined(SYSVMSG) && !defined(_LP64)
	{
		ns(struct freebsd_sys_msgsys_args),
		.sy_call = (sy_call_t *)freebsd_sys_msgsys
	},		/* 170 = msgsys */
#else
	{
		.sy_call = sys_nosys,
	},		/* 170 = filler */
#endif
#if defined(SYSVSHM) && !defined(_LP64)
	{
		ns(struct freebsd_sys_shmsys_args),
		.sy_call = (sy_call_t *)freebsd_sys_shmsys
	},		/* 171 = shmsys */
#else
	{
		.sy_call = sys_nosys,
	},		/* 171 = filler */
#endif
	{
		.sy_call = sys_nosys,
	},		/* 172 = filler */
	{
		ns(struct sys_pread_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG4_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_pread
	},		/* 173 = pread */
	{
		ns(struct sys_pwrite_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG4_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_pwrite
	},		/* 174 = pwrite */
	{
		.sy_call = sys_nosys,
	},		/* 175 = filler */
#ifdef NTP
	{
		ns(struct freebsd_ntp_adjtime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_ntp_adjtime
	},		/* 176 = freebsd_ntp_adjtime */
#else
	{
		.sy_call = sys_nosys,
	},		/* 176 = filler */
#endif
	{
		.sy_call = sys_nosys,
	},		/* 177 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 178 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 179 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 180 = filler */
	{
		ns(struct sys_setgid_args),
		.sy_call = (sy_call_t *)sys_setgid
	},		/* 181 = setgid */
	{
		ns(struct sys_setegid_args),
		.sy_call = (sy_call_t *)sys_setegid
	},		/* 182 = setegid */
	{
		ns(struct sys_seteuid_args),
		.sy_call = (sy_call_t *)sys_seteuid
	},		/* 183 = seteuid */
	{
		.sy_call = sys_nosys,
	},		/* 184 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 185 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 186 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 187 = filler */
	{
		ns(struct compat_12_sys_stat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_12_sys_stat
	},		/* 188 = stat */
	{
		ns(struct compat_12_sys_fstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_12_sys_fstat
	},		/* 189 = fstat */
	{
		ns(struct compat_12_sys_lstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_12_sys_lstat
	},		/* 190 = lstat */
	{
		ns(struct sys_pathconf_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_pathconf
	},		/* 191 = pathconf */
	{
		ns(struct sys_fpathconf_args),
		.sy_call = (sy_call_t *)sys_fpathconf
	},		/* 192 = fpathconf */
	{
		.sy_call = sys_nosys,
	},		/* 193 = filler */
	{
		ns(struct sys_getrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_getrlimit
	},		/* 194 = getrlimit */
	{
		ns(struct sys_setrlimit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_setrlimit
	},		/* 195 = setrlimit */
	{
		ns(struct compat_12_sys_getdirentries_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_12_sys_getdirentries
	},		/* 196 = getdirentries */
	{
		ns(struct freebsd_sys_mmap_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG6_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_mmap
	},		/* 197 = mmap */
	{
		.sy_call = (sy_call_t *)sys_nosys
	},		/* 198 = __syscall */
	{
		ns(struct sys_lseek_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG2_64 | SYCALL_RET_64,
		.sy_call = (sy_call_t *)sys_lseek
	},		/* 199 = lseek */
	{
		ns(struct sys_truncate_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG2_64 | SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_truncate
	},		/* 200 = truncate */
	{
		ns(struct sys_ftruncate_args),
		.sy_flags = SYCALL_NARGS64_VAL(1) | SYCALL_ARG2_64,
		.sy_call = (sy_call_t *)sys_ftruncate
	},		/* 201 = ftruncate */
	{
		ns(struct freebsd_sys_sysctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_sysctl
	},		/* 202 = sysctl */
	{
		ns(struct sys_mlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_mlock
	},		/* 203 = mlock */
	{
		ns(struct sys_munlock_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_munlock
	},		/* 204 = munlock */
#ifdef FREEBSD_BASED_ON_44LITE_R2
	{
		ns(struct freebsd_sys_undelete_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_undelete
	},		/* 205 = undelete */
#else
	{
		.sy_call = sys_nosys,
	},		/* 205 = filler */
#endif
	{
		ns(struct compat_50_sys_futimes_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_futimes
	},		/* 206 = futimes */
	{
		ns(struct sys_getpgid_args),
		.sy_call = (sy_call_t *)sys_getpgid
	},		/* 207 = getpgid */
#if 0
	{
		ns(struct sys_reboot_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_reboot
	},		/* 208 = reboot */
#else
	{
		.sy_call = sys_nosys,
	},		/* 208 = filler */
#endif
	{
		ns(struct sys_poll_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_poll
	},		/* 209 = poll */
	{
		.sy_call = sys_nosys,
	},		/* 210 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 211 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 212 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 213 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 214 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 215 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 216 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 217 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 218 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 219 = filler */
#ifdef SYSVSEM
	{
		ns(struct compat_14_sys___semctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_14_sys___semctl
	},		/* 220 = __semctl */
	{
		ns(struct sys_semget_args),
		.sy_call = (sy_call_t *)sys_semget
	},		/* 221 = semget */
	{
		ns(struct sys_semop_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_semop
	},		/* 222 = semop */
	{
		ns(struct sys_semconfig_args),
		.sy_call = (sy_call_t *)sys_semconfig
	},		/* 223 = semconfig */
#else
	{
		.sy_call = sys_nosys,
	},		/* 220 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 221 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 222 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 223 = filler */
#endif
#ifdef SYSVMSG
	{
		ns(struct compat_14_sys_msgctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_14_sys_msgctl
	},		/* 224 = msgctl */
	{
		ns(struct sys_msgget_args),
		.sy_call = (sy_call_t *)sys_msgget
	},		/* 225 = msgget */
	{
		ns(struct sys_msgsnd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_msgsnd
	},		/* 226 = msgsnd */
	{
		ns(struct sys_msgrcv_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_msgrcv
	},		/* 227 = msgrcv */
#else
	{
		.sy_call = sys_nosys,
	},		/* 224 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 225 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 226 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 227 = filler */
#endif
#ifdef SYSVSHM
	{
		ns(struct sys_shmat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_shmat
	},		/* 228 = shmat */
	{
		ns(struct compat_14_sys_shmctl_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_14_sys_shmctl
	},		/* 229 = shmctl */
	{
		ns(struct sys_shmdt_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_shmdt
	},		/* 230 = shmdt */
	{
		ns(struct sys_shmget_args),
		.sy_call = (sy_call_t *)sys_shmget
	},		/* 231 = shmget */
#else
	{
		.sy_call = sys_nosys,
	},		/* 228 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 229 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 230 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 231 = filler */
#endif
	{
		ns(struct compat_50_sys_clock_gettime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_clock_gettime
	},		/* 232 = clock_gettime */
	{
		ns(struct compat_50_sys_clock_settime_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_clock_settime
	},		/* 233 = clock_settime */
	{
		ns(struct compat_50_sys_clock_getres_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_clock_getres
	},		/* 234 = clock_getres */
	{
		.sy_call = sys_nosys,
	},		/* 235 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 236 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 237 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 238 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 239 = filler */
	{
		ns(struct compat_50_sys_nanosleep_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_nanosleep
	},		/* 240 = nanosleep */
	{
		.sy_call = sys_nosys,
	},		/* 241 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 242 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 243 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 244 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 245 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 246 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 247 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 248 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 249 = filler */
	{
		ns(struct sys_minherit_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_minherit
	},		/* 250 = minherit */
	{
		ns(struct freebsd_sys_rfork_args),
		.sy_call = (sy_call_t *)freebsd_sys_rfork
	},		/* 251 = rfork */
	{
		.sy_call = sys_nosys,
	},		/* 252 = filler */
	{
		.sy_call = (sy_call_t *)sys_issetugid
	},		/* 253 = issetugid */
	{
		ns(struct sys_lchown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_lchown
	},		/* 254 = lchown */
	{
		.sy_call = sys_nosys,
	},		/* 255 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 256 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 257 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 258 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 259 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 260 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 261 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 262 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 263 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 264 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 265 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 266 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 267 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 268 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 269 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 270 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 271 = filler */
	{
		ns(struct compat_30_sys_getdents_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_30_sys_getdents
	},		/* 272 = getdents */
	{
		.sy_call = sys_nosys,
	},		/* 273 = filler */
	{
		ns(struct sys_lchmod_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_lchmod
	},		/* 274 = lchmod */
	{
		ns(struct sys_lchown_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_lchown
	},		/* 275 = netbsd_lchown */
	{
		ns(struct compat_50_sys_lutimes_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_50_sys_lutimes
	},		/* 276 = lutimes */
	{
		ns(struct sys___msync13_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___msync13
	},		/* 277 = __msync13 */
	{
		ns(struct compat_30_sys___stat13_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_30_sys___stat13
	},		/* 278 = __stat13 */
	{
		ns(struct compat_30_sys___fstat13_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_30_sys___fstat13
	},		/* 279 = __fstat13 */
	{
		ns(struct compat_30_sys___lstat13_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_30_sys___lstat13
	},		/* 280 = __lstat13 */
	{
		.sy_call = sys_nosys,
	},		/* 281 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 282 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 283 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 284 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 285 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 286 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 287 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 288 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 289 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 290 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 291 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 292 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 293 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 294 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 295 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 296 = filler */
	{
		ns(struct compat_20_sys_fhstatfs_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_20_sys_fhstatfs
	},		/* 297 = fhstatfs */
	{
		ns(struct compat_30_sys_fhopen_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_30_sys_fhopen
	},		/* 298 = fhopen */
	{
		ns(struct compat_30_sys_fhstat_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)compat_30_sys_fhstat
	},		/* 299 = fhstat */
	{
		.sy_call = sys_nosys,
	},		/* 300 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 301 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 302 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 303 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 304 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 305 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 306 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 307 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 308 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 309 = filler */
	{
		ns(struct sys_getsid_args),
		.sy_call = (sy_call_t *)sys_getsid
	},		/* 310 = getsid */
	{
		.sy_call = sys_nosys,
	},		/* 311 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 312 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 313 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 314 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 315 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 316 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 317 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 318 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 319 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 320 = filler */
	{
		.sy_call = (sy_call_t *)freebsd_sys_yield
	},		/* 321 = yield */
	{
		.sy_call = sys_nosys,
	},		/* 322 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 323 = filler */
	{
		ns(struct sys_mlockall_args),
		.sy_call = (sy_call_t *)sys_mlockall
	},		/* 324 = mlockall */
	{
		.sy_call = (sy_call_t *)sys_munlockall
	},		/* 325 = munlockall */
	{
		ns(struct sys___getcwd_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___getcwd
	},		/* 326 = __getcwd */
	{
		ns(struct freebsd_sys_sched_setparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_sched_setparam
	},		/* 327 = sched_setparam */
	{
		ns(struct freebsd_sys_sched_getparam_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_sched_getparam
	},		/* 328 = sched_getparam */
	{
		ns(struct freebsd_sys_sched_setscheduler_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_sched_setscheduler
	},		/* 329 = sched_setscheduler */
	{
		ns(struct freebsd_sys_sched_getscheduler_args),
		.sy_call = (sy_call_t *)freebsd_sys_sched_getscheduler
	},		/* 330 = sched_getscheduler */
	{
		.sy_call = (sy_call_t *)freebsd_sys_sched_yield
	},		/* 331 = sched_yield */
	{
		ns(struct freebsd_sys_sched_get_priority_max_args),
		.sy_call = (sy_call_t *)freebsd_sys_sched_get_priority_max
	},		/* 332 = sched_get_priority_max */
	{
		ns(struct freebsd_sys_sched_get_priority_min_args),
		.sy_call = (sy_call_t *)freebsd_sys_sched_get_priority_min
	},		/* 333 = sched_get_priority_min */
	{
		.sy_call = sys_nosys,
	},		/* 334 = filler */
	{
		ns(struct freebsd_sys_utrace_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_utrace
	},		/* 335 = utrace */
	{
		.sy_call = sys_nosys,
	},		/* 336 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 337 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 338 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 339 = filler */
	{
		ns(struct sys___sigprocmask14_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___sigprocmask14
	},		/* 340 = __sigprocmask14 */
	{
		ns(struct sys___sigsuspend14_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___sigsuspend14
	},		/* 341 = __sigsuspend14 */
	{
		ns(struct freebsd_sys_sigaction4_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)freebsd_sys_sigaction4
	},		/* 342 = sigaction4 */
	{
		ns(struct sys___sigpending14_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys___sigpending14
	},		/* 343 = __sigpending14 */
	{
		.sy_call = sys_nosys,
	},		/* 344 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 345 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 346 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 347 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 348 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 349 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 350 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 351 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 352 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 353 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 354 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 355 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 356 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 357 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 358 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 359 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 360 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 361 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 362 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 363 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 364 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 365 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 366 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 367 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 368 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 369 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 370 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 371 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 372 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 373 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 374 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 375 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 376 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 377 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 378 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 379 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 380 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 381 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 382 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 383 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 384 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 385 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 386 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 387 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 388 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 389 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 390 = filler */
	{
		ns(struct sys_lchflags_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_lchflags
	},		/* 391 = lchflags */
	{
		ns(struct sys_uuidgen_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys_uuidgen
	},		/* 392 = uuidgen */
	{
		.sy_call = sys_nosys,
	},		/* 393 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 394 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 395 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 396 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 397 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 398 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 399 = filler */
	{
		ns(struct sys__ksem_close_args),
		.sy_call = (sy_call_t *)sys__ksem_close
	},		/* 400 = _ksem_close */
	{
		ns(struct sys__ksem_post_args),
		.sy_call = (sy_call_t *)sys__ksem_post
	},		/* 401 = _ksem_post */
	{
		ns(struct sys__ksem_wait_args),
		.sy_call = (sy_call_t *)sys__ksem_wait
	},		/* 402 = _ksem_wait */
	{
		ns(struct sys__ksem_trywait_args),
		.sy_call = (sy_call_t *)sys__ksem_trywait
	},		/* 403 = _ksem_trywait */
	{
		.sy_call = sys_nosys,
	},		/* 404 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 405 = filler */
	{
		ns(struct sys__ksem_unlink_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys__ksem_unlink
	},		/* 406 = _ksem_unlink */
	{
		ns(struct sys__ksem_getvalue_args),
		.sy_flags = SYCALL_ARG_PTR,
		.sy_call = (sy_call_t *)sys__ksem_getvalue
	},		/* 407 = _ksem_getvalue */
	{
		ns(struct sys__ksem_destroy_args),
		.sy_call = (sy_call_t *)sys__ksem_destroy
	},		/* 408 = _ksem_destroy */
	{
		.sy_call = sys_nosys,
	},		/* 409 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 410 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 411 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 412 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 413 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 414 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 415 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 416 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 417 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 418 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 419 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 420 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 421 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 422 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 423 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 424 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 425 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 426 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 427 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 428 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 429 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 430 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 431 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 432 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 433 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 434 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 435 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 436 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 437 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 438 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 439 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 440 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 441 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 442 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 443 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 444 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 445 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 446 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 447 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 448 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 449 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 450 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 451 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 452 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 453 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 454 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 455 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 456 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 457 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 458 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 459 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 460 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 461 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 462 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 463 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 464 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 465 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 466 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 467 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 468 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 469 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 470 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 471 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 472 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 473 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 474 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 475 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 476 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 477 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 478 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 479 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 480 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 481 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 482 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 483 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 484 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 485 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 486 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 487 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 488 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 489 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 490 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 491 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 492 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 493 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 494 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 495 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 496 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 497 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 498 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 499 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 500 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 501 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 502 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 503 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 504 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 505 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 506 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 507 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 508 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 509 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 510 = filler */
	{
		.sy_call = sys_nosys,
	},		/* 511 = filler */
};

const uint32_t freebsd_sysent_nomodbits[] = {
	0x00000000,	/* syscalls   0- 31 */
	0x00000000,	/* syscalls  32- 63 */
	0x00000000,	/* syscalls  64- 95 */
	0x00000000,	/* syscalls  96-127 */
	0x00000000,	/* syscalls 128-159 */
	0x00000000,	/* syscalls 160-191 */
	0x00000000,	/* syscalls 192-223 */
	0x00000000,	/* syscalls 224-255 */
	0x00000000,	/* syscalls 256-287 */
	0x00000000,	/* syscalls 288-319 */
	0x00000000,	/* syscalls 320-351 */
	0x00000000,	/* syscalls 352-383 */
	0x00000000,	/* syscalls 384-415 */
	0x00000000,	/* syscalls 416-447 */
	0x00000000,	/* syscalls 448-479 */
	0x00000000,	/* syscalls 480-511 */
};
