/*	$NetBSD: psgpam_table.c,v 1.1 2022/06/10 21:42:23 tsutsui Exp $	*/

/*
 * Copyright (c) 2018 Yosuke Sugahara. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(_KERNEL)
#include <sys/types.h>
#endif

/*
 * All PT_count=16
 * Limited (0,134217728) PT_count=14
 * Unique PT_count=14
 * min=0 step=434334
 * Used 13
 */
const uint8_t PCM1_TABLE[] = {
	      /* u  v : out v */
	0x00, /* [0]0 : [0]0 */
	0x00, /* [1]434334 : [0]0 */
	0x00, /* [2]868668 : [0]0 */
	0x01, /* [3]1303002 : [1]2097152 */
	0x01, /* [4]1737336 : [1]2097152 */
	0x01, /* [5]2171670 : [1]2097152 */
	0x02, /* [6]2606004 : [2]2965821 */
	0x02, /* [7]3040338 : [2]2965821 */
	0x02, /* [8]3474672 : [2]2965821 */
	0x03, /* [9]3909006 : [3]4194304 */
	0x03, /* [10]4343340 : [3]4194304 */
	0x03, /* [11]4777674 : [3]4194304 */
	0x04, /* [12]5212008 : [4]5931642 */
	0x04, /* [13]5646342 : [4]5931642 */
	0x04, /* [14]6080676 : [4]5931642 */
	0x04, /* [15]6515010 : [4]5931642 */
	0x04, /* [16]6949344 : [4]5931642 */
	0x05, /* [17]7383678 : [5]8388608 */
	0x05, /* [18]7818012 : [5]8388608 */
	0x05, /* [19]8252346 : [5]8388608 */
	0x05, /* [20]8686680 : [5]8388608 */
	0x05, /* [21]9121014 : [5]8388608 */
	0x05, /* [22]9555348 : [5]8388608 */
	0x05, /* [23]9989682 : [5]8388608 */
	0x06, /* [24]10424016 : [6]11863283 */
	0x06, /* [25]10858350 : [6]11863283 */
	0x06, /* [26]11292684 : [6]11863283 */
	0x06, /* [27]11727018 : [6]11863283 */
	0x06, /* [28]12161352 : [6]11863283 */
	0x06, /* [29]12595686 : [6]11863283 */
	0x06, /* [30]13030020 : [6]11863283 */
	0x06, /* [31]13464354 : [6]11863283 */
	0x06, /* [32]13898688 : [6]11863283 */
	0x07, /* [33]14333022 : [7]16777216 */
	0x07, /* [34]14767356 : [7]16777216 */
	0x07, /* [35]15201690 : [7]16777216 */
	0x07, /* [36]15636024 : [7]16777216 */
	0x07, /* [37]16070358 : [7]16777216 */
	0x07, /* [38]16504692 : [7]16777216 */
	0x07, /* [39]16939026 : [7]16777216 */
	0x07, /* [40]17373360 : [7]16777216 */
	0x07, /* [41]17807694 : [7]16777216 */
	0x07, /* [42]18242028 : [7]16777216 */
	0x07, /* [43]18676362 : [7]16777216 */
	0x07, /* [44]19110696 : [7]16777216 */
	0x07, /* [45]19545030 : [7]16777216 */
	0x07, /* [46]19979364 : [7]16777216 */
	0x08, /* [47]20413698 : [8]23726566 */
	0x08, /* [48]20848032 : [8]23726566 */
	0x08, /* [49]21282366 : [8]23726566 */
	0x08, /* [50]21716700 : [8]23726566 */
	0x08, /* [51]22151034 : [8]23726566 */
	0x08, /* [52]22585368 : [8]23726566 */
	0x08, /* [53]23019702 : [8]23726566 */
	0x08, /* [54]23454036 : [8]23726566 */
	0x08, /* [55]23888370 : [8]23726566 */
	0x08, /* [56]24322704 : [8]23726566 */
	0x08, /* [57]24757038 : [8]23726566 */
	0x08, /* [58]25191372 : [8]23726566 */
	0x08, /* [59]25625706 : [8]23726566 */
	0x08, /* [60]26060040 : [8]23726566 */
	0x08, /* [61]26494374 : [8]23726566 */
	0x08, /* [62]26928708 : [8]23726566 */
	0x08, /* [63]27363042 : [8]23726566 */
	0x08, /* [64]27797376 : [8]23726566 */
	0x08, /* [65]28231710 : [8]23726566 */
	0x09, /* [66]28666044 : [9]33554432 */
	0x09, /* [67]29100378 : [9]33554432 */
	0x09, /* [68]29534712 : [9]33554432 */
	0x09, /* [69]29969046 : [9]33554432 */
	0x09, /* [70]30403380 : [9]33554432 */
	0x09, /* [71]30837714 : [9]33554432 */
	0x09, /* [72]31272048 : [9]33554432 */
	0x09, /* [73]31706382 : [9]33554432 */
	0x09, /* [74]32140716 : [9]33554432 */
	0x09, /* [75]32575050 : [9]33554432 */
	0x09, /* [76]33009384 : [9]33554432 */
	0x09, /* [77]33443718 : [9]33554432 */
	0x09, /* [78]33878052 : [9]33554432 */
	0x09, /* [79]34312386 : [9]33554432 */
	0x09, /* [80]34746720 : [9]33554432 */
	0x09, /* [81]35181054 : [9]33554432 */
	0x09, /* [82]35615388 : [9]33554432 */
	0x09, /* [83]36049722 : [9]33554432 */
	0x09, /* [84]36484056 : [9]33554432 */
	0x09, /* [85]36918390 : [9]33554432 */
	0x09, /* [86]37352724 : [9]33554432 */
	0x09, /* [87]37787058 : [9]33554432 */
	0x09, /* [88]38221392 : [9]33554432 */
	0x09, /* [89]38655726 : [9]33554432 */
	0x09, /* [90]39090060 : [9]33554432 */
	0x09, /* [91]39524394 : [9]33554432 */
	0x09, /* [92]39958728 : [9]33554432 */
	0x09, /* [93]40393062 : [9]33554432 */
	0x0a, /* [94]40827396 : [10]47453133 */
	0x0a, /* [95]41261730 : [10]47453133 */
	0x0a, /* [96]41696064 : [10]47453133 */
	0x0a, /* [97]42130398 : [10]47453133 */
	0x0a, /* [98]42564732 : [10]47453133 */
	0x0a, /* [99]42999066 : [10]47453133 */
	0x0a, /* [100]43433400 : [10]47453133 */
	0x0a, /* [101]43867734 : [10]47453133 */
	0x0a, /* [102]44302068 : [10]47453133 */
	0x0a, /* [103]44736402 : [10]47453133 */
	0x0a, /* [104]45170736 : [10]47453133 */
	0x0a, /* [105]45605070 : [10]47453133 */
	0x0a, /* [106]46039404 : [10]47453133 */
	0x0a, /* [107]46473738 : [10]47453133 */
	0x0a, /* [108]46908072 : [10]47453133 */
	0x0a, /* [109]47342406 : [10]47453133 */
	0x0a, /* [110]47776740 : [10]47453133 */
	0x0a, /* [111]48211074 : [10]47453133 */
	0x0a, /* [112]48645408 : [10]47453133 */
	0x0a, /* [113]49079742 : [10]47453133 */
	0x0a, /* [114]49514076 : [10]47453133 */
	0x0a, /* [115]49948410 : [10]47453133 */
	0x0a, /* [116]50382744 : [10]47453133 */
	0x0a, /* [117]50817078 : [10]47453133 */
	0x0a, /* [118]51251412 : [10]47453133 */
	0x0a, /* [119]51685746 : [10]47453133 */
	0x0a, /* [120]52120080 : [10]47453133 */
	0x0a, /* [121]52554414 : [10]47453133 */
	0x0a, /* [122]52988748 : [10]47453133 */
	0x0a, /* [123]53423082 : [10]47453133 */
	0x0a, /* [124]53857416 : [10]47453133 */
	0x0a, /* [125]54291750 : [10]47453133 */
	0x0a, /* [126]54726084 : [10]47453133 */
	0x0a, /* [127]55160418 : [10]47453133 */
	0x0a, /* [128]55594752 : [10]47453133 */
	0x0a, /* [129]56029086 : [10]47453133 */
	0x0a, /* [130]56463420 : [10]47453133 */
	0x0a, /* [131]56897754 : [10]47453133 */
	0x0b, /* [132]57332088 : [11]67108864 */
	0x0b, /* [133]57766422 : [11]67108864 */
	0x0b, /* [134]58200756 : [11]67108864 */
	0x0b, /* [135]58635090 : [11]67108864 */
	0x0b, /* [136]59069424 : [11]67108864 */
	0x0b, /* [137]59503758 : [11]67108864 */
	0x0b, /* [138]59938092 : [11]67108864 */
	0x0b, /* [139]60372426 : [11]67108864 */
	0x0b, /* [140]60806760 : [11]67108864 */
	0x0b, /* [141]61241094 : [11]67108864 */
	0x0b, /* [142]61675428 : [11]67108864 */
	0x0b, /* [143]62109762 : [11]67108864 */
	0x0b, /* [144]62544096 : [11]67108864 */
	0x0b, /* [145]62978430 : [11]67108864 */
	0x0b, /* [146]63412764 : [11]67108864 */
	0x0b, /* [147]63847098 : [11]67108864 */
	0x0b, /* [148]64281432 : [11]67108864 */
	0x0b, /* [149]64715766 : [11]67108864 */
	0x0b, /* [150]65150100 : [11]67108864 */
	0x0b, /* [151]65584434 : [11]67108864 */
	0x0b, /* [152]66018768 : [11]67108864 */
	0x0b, /* [153]66453102 : [11]67108864 */
	0x0b, /* [154]66887436 : [11]67108864 */
	0x0b, /* [155]67321770 : [11]67108864 */
	0x0b, /* [156]67756104 : [11]67108864 */
	0x0b, /* [157]68190438 : [11]67108864 */
	0x0b, /* [158]68624772 : [11]67108864 */
	0x0b, /* [159]69059106 : [11]67108864 */
	0x0b, /* [160]69493440 : [11]67108864 */
	0x0b, /* [161]69927774 : [11]67108864 */
	0x0b, /* [162]70362108 : [11]67108864 */
	0x0b, /* [163]70796442 : [11]67108864 */
	0x0b, /* [164]71230776 : [11]67108864 */
	0x0b, /* [165]71665110 : [11]67108864 */
	0x0b, /* [166]72099444 : [11]67108864 */
	0x0b, /* [167]72533778 : [11]67108864 */
	0x0b, /* [168]72968112 : [11]67108864 */
	0x0b, /* [169]73402446 : [11]67108864 */
	0x0b, /* [170]73836780 : [11]67108864 */
	0x0b, /* [171]74271114 : [11]67108864 */
	0x0b, /* [172]74705448 : [11]67108864 */
	0x0b, /* [173]75139782 : [11]67108864 */
	0x0b, /* [174]75574116 : [11]67108864 */
	0x0b, /* [175]76008450 : [11]67108864 */
	0x0b, /* [176]76442784 : [11]67108864 */
	0x0b, /* [177]76877118 : [11]67108864 */
	0x0b, /* [178]77311452 : [11]67108864 */
	0x0b, /* [179]77745786 : [11]67108864 */
	0x0b, /* [180]78180120 : [11]67108864 */
	0x0b, /* [181]78614454 : [11]67108864 */
	0x0b, /* [182]79048788 : [11]67108864 */
	0x0b, /* [183]79483122 : [11]67108864 */
	0x0b, /* [184]79917456 : [11]67108864 */
	0x0b, /* [185]80351790 : [11]67108864 */
	0x0b, /* [186]80786124 : [11]67108864 */
	0x0c, /* [187]81220458 : [12]94906266 */
	0x0c, /* [188]81654792 : [12]94906266 */
	0x0c, /* [189]82089126 : [12]94906266 */
	0x0c, /* [190]82523460 : [12]94906266 */
	0x0c, /* [191]82957794 : [12]94906266 */
	0x0c, /* [192]83392128 : [12]94906266 */
	0x0c, /* [193]83826462 : [12]94906266 */
	0x0c, /* [194]84260796 : [12]94906266 */
	0x0c, /* [195]84695130 : [12]94906266 */
	0x0c, /* [196]85129464 : [12]94906266 */
	0x0c, /* [197]85563798 : [12]94906266 */
	0x0c, /* [198]85998132 : [12]94906266 */
	0x0c, /* [199]86432466 : [12]94906266 */
	0x0c, /* [200]86866800 : [12]94906266 */
	0x0c, /* [201]87301134 : [12]94906266 */
	0x0c, /* [202]87735468 : [12]94906266 */
	0x0c, /* [203]88169802 : [12]94906266 */
	0x0c, /* [204]88604136 : [12]94906266 */
	0x0c, /* [205]89038470 : [12]94906266 */
	0x0c, /* [206]89472804 : [12]94906266 */
	0x0c, /* [207]89907138 : [12]94906266 */
	0x0c, /* [208]90341472 : [12]94906266 */
	0x0c, /* [209]90775806 : [12]94906266 */
	0x0c, /* [210]91210140 : [12]94906266 */
	0x0c, /* [211]91644474 : [12]94906266 */
	0x0c, /* [212]92078808 : [12]94906266 */
	0x0c, /* [213]92513142 : [12]94906266 */
	0x0c, /* [214]92947476 : [12]94906266 */
	0x0c, /* [215]93381810 : [12]94906266 */
	0x0c, /* [216]93816144 : [12]94906266 */
	0x0c, /* [217]94250478 : [12]94906266 */
	0x0c, /* [218]94684812 : [12]94906266 */
	0x0c, /* [219]95119146 : [12]94906266 */
	0x0c, /* [220]95553480 : [12]94906266 */
	0x0c, /* [221]95987814 : [12]94906266 */
	0x0c, /* [222]96422148 : [12]94906266 */
	0x0c, /* [223]96856482 : [12]94906266 */
	0x0c, /* [224]97290816 : [12]94906266 */
	0x0c, /* [225]97725150 : [12]94906266 */
	0x0c, /* [226]98159484 : [12]94906266 */
	0x0c, /* [227]98593818 : [12]94906266 */
	0x0c, /* [228]99028152 : [12]94906266 */
	0x0c, /* [229]99462486 : [12]94906266 */
	0x0c, /* [230]99896820 : [12]94906266 */
	0x0c, /* [231]100331154 : [12]94906266 */
	0x0c, /* [232]100765488 : [12]94906266 */
	0x0c, /* [233]101199822 : [12]94906266 */
	0x0c, /* [234]101634156 : [12]94906266 */
	0x0c, /* [235]102068490 : [12]94906266 */
	0x0c, /* [236]102502824 : [12]94906266 */
	0x0c, /* [237]102937158 : [12]94906266 */
	0x0c, /* [238]103371492 : [12]94906266 */
	0x0c, /* [239]103805826 : [12]94906266 */
	0x0c, /* [240]104240160 : [12]94906266 */
	0x0c, /* [241]104674494 : [12]94906266 */
	0x0c, /* [242]105108828 : [12]94906266 */
	0x0c, /* [243]105543162 : [12]94906266 */
	0x0c, /* [244]105977496 : [12]94906266 */
	0x0c, /* [245]106411830 : [12]94906266 */
	0x0c, /* [246]106846164 : [12]94906266 */
	0x0c, /* [247]107280498 : [12]94906266 */
	0x0c, /* [248]107714832 : [12]94906266 */
	0x0c, /* [249]108149166 : [12]94906266 */
	0x0c, /* [250]108583500 : [12]94906266 */
	0x0c, /* [251]109017834 : [12]94906266 */
	0x0c, /* [252]109452168 : [12]94906266 */
	0x0c, /* [253]109886502 : [12]94906266 */
	0x0c, /* [254]110320836 : [12]94906266 */
	0x0c, /* [255]110755170 : [12]94906266 */
};
/*
 * All PT_count=256
 * Limited (2097152,134217728) PT_count=139
 * Unique PT_count=75
 * min=0 step=434334
 * Used 71
 */
const uint8_t PCM2_TABLE[] = {
	        /* u  v : out v */
	0x11, /* [0]0 : [0]4194304 */
	0x11, /* [1]434334 : [0]4194304 */
	0x11, /* [2]868668 : [0]4194304 */
	0x11, /* [3]1303002 : [0]4194304 */
	0x11, /* [4]1737336 : [0]4194304 */
	0x11, /* [5]2171670 : [0]4194304 */
	0x11, /* [6]2606004 : [0]4194304 */
	0x11, /* [7]3040338 : [0]4194304 */
	0x11, /* [8]3474672 : [0]4194304 */
	0x11, /* [9]3909006 : [0]4194304 */
	0x11, /* [10]4343340 : [0]4194304 */
	0x21, /* [11]4777674 : [1]5062973 */
	0x21, /* [12]5212008 : [1]5062973 */
	0x22, /* [13]5646342 : [2]5931642 */
	0x22, /* [14]6080676 : [2]5931642 */
	0x13, /* [15]6515010 : [3]6291456 */
	0x32, /* [16]6949344 : [4]7160125 */
	0x32, /* [17]7383678 : [4]7160125 */
	0x41, /* [18]7818012 : [5]8028794 */
	0x33, /* [19]8252346 : [6]8388608 */
	0x24, /* [20]8686680 : [7]8897463 */
	0x24, /* [21]9121014 : [7]8897463 */
	0x34, /* [22]9555348 : [8]10125946 */
	0x34, /* [23]9989682 : [8]10125946 */
	0x51, /* [24]10424016 : [9]10485760 */
	0x51, /* [25]10858350 : [9]10485760 */
	0x25, /* [26]11292684 : [10]11354429 */
	0x44, /* [27]11727018 : [11]11863284 */
	0x44, /* [28]12161352 : [11]11863284 */
	0x53, /* [29]12595686 : [12]12582912 */
	0x53, /* [30]13030020 : [12]12582912 */
	0x16, /* [31]13464354 : [13]13960435 */
	0x16, /* [32]13898688 : [13]13960435 */
	0x45, /* [33]14333022 : [14]14320250 */
	0x26, /* [34]14767356 : [15]14829104 */
	0x26, /* [35]15201690 : [15]14829104 */
	0x63, /* [36]15636024 : [16]16057587 */
	0x63, /* [37]16070358 : [16]16057587 */
	0x55, /* [38]16504692 : [17]16777216 */
	0x55, /* [39]16939026 : [17]16777216 */
	0x46, /* [40]17373360 : [18]17794925 */
	0x46, /* [41]17807694 : [18]17794925 */
	0x46, /* [42]18242028 : [18]17794925 */
	0x71, /* [43]18676362 : [19]18874368 */
	0x71, /* [44]19110696 : [19]18874368 */
	0x72, /* [45]19545030 : [20]19743037 */
	0x72, /* [46]19979364 : [20]19743037 */
	0x65, /* [47]20413698 : [21]20251891 */
	0x73, /* [48]20848032 : [22]20971520 */
	0x73, /* [49]21282366 : [22]20971520 */
	0x73, /* [50]21716700 : [22]20971520 */
	0x47, /* [51]22151034 : [23]22708858 */
	0x47, /* [52]22585368 : [23]22708858 */
	0x47, /* [53]23019702 : [23]22708858 */
	0x66, /* [54]23454036 : [24]23726566 */
	0x66, /* [55]23888370 : [24]23726566 */
	0x66, /* [56]24322704 : [24]23726566 */
	0x75, /* [57]24757038 : [25]25165824 */
	0x75, /* [58]25191372 : [25]25165824 */
	0x81, /* [59]25625706 : [26]25823718 */
	0x81, /* [60]26060040 : [26]25823718 */
	0x82, /* [61]26494374 : [27]26692387 */
	0x82, /* [62]26928708 : [27]26692387 */
	0x38, /* [63]27363042 : [28]27920870 */
	0x38, /* [64]27797376 : [28]27920870 */
	0x38, /* [65]28231710 : [28]27920870 */
	0x76, /* [66]28666044 : [29]28640499 */
	0x76, /* [67]29100378 : [29]28640499 */
	0x48, /* [68]29534712 : [30]29658208 */
	0x48, /* [69]29969046 : [30]29658208 */
	0x48, /* [70]30403380 : [30]29658208 */
	0x48, /* [71]30837714 : [30]29658208 */
	0x85, /* [72]31272048 : [31]32115174 */
	0x85, /* [73]31706382 : [31]32115174 */
	0x85, /* [74]32140716 : [31]32115174 */
	0x85, /* [75]32575050 : [31]32115174 */
	0x77, /* [76]33009384 : [32]33554432 */
	0x77, /* [77]33443718 : [32]33554432 */
	0x77, /* [78]33878052 : [32]33554432 */
	0x77, /* [79]34312386 : [32]33554432 */
	0x68, /* [80]34746720 : [33]35589849 */
	0x68, /* [81]35181054 : [33]35589849 */
	0x68, /* [82]35615388 : [33]35589849 */
	0x19, /* [83]36049722 : [34]35651584 */
	0x92, /* [84]36484056 : [35]36520253 */
	0x92, /* [85]36918390 : [35]36520253 */
	0x93, /* [86]37352724 : [36]37748736 */
	0x93, /* [87]37787058 : [36]37748736 */
	0x93, /* [88]38221392 : [36]37748736 */
	0x94, /* [89]38655726 : [37]39486074 */
	0x94, /* [90]39090060 : [37]39486074 */
	0x94, /* [91]39524394 : [37]39486074 */
	0x94, /* [92]39958728 : [37]39486074 */
	0x78, /* [93]40393062 : [38]40503782 */
	0x78, /* [94]40827396 : [38]40503782 */
	0x95, /* [95]41261730 : [39]41943040 */
	0x95, /* [96]41696064 : [39]41943040 */
	0x95, /* [97]42130398 : [39]41943040 */
	0x95, /* [98]42564732 : [39]41943040 */
	0x95, /* [99]42999066 : [39]41943040 */
	0x95, /* [100]43433400 : [39]41943040 */
	0x96, /* [101]43867734 : [40]45417715 */
	0x96, /* [102]44302068 : [40]45417715 */
	0x96, /* [103]44736402 : [40]45417715 */
	0x96, /* [104]45170736 : [40]45417715 */
	0x96, /* [105]45605070 : [40]45417715 */
	0x96, /* [106]46039404 : [40]45417715 */
	0x88, /* [107]46473738 : [41]47453132 */
	0x88, /* [108]46908072 : [41]47453132 */
	0x88, /* [109]47342406 : [41]47453132 */
	0x88, /* [110]47776740 : [41]47453132 */
	0x88, /* [111]48211074 : [41]47453132 */
	0xa1, /* [112]48645408 : [42]49550285 */
	0xa1, /* [113]49079742 : [42]49550285 */
	0xa1, /* [114]49514076 : [42]49550285 */
	0x97, /* [115]49948410 : [43]50331648 */
	0xa2, /* [116]50382744 : [44]50418954 */
	0xa2, /* [117]50817078 : [44]50418954 */
	0x3a, /* [118]51251412 : [45]51647437 */
	0x3a, /* [119]51685746 : [45]51647437 */
	0x3a, /* [120]52120080 : [45]51647437 */
	0x4a, /* [121]52554414 : [46]53384775 */
	0x4a, /* [122]52988748 : [46]53384775 */
	0x4a, /* [123]53423082 : [46]53384775 */
	0x4a, /* [124]53857416 : [46]53384775 */
	0x4a, /* [125]54291750 : [46]53384775 */
	0xa5, /* [126]54726084 : [47]55841741 */
	0xa5, /* [127]55160418 : [47]55841741 */
	0xa5, /* [128]55594752 : [47]55841741 */
	0xa5, /* [129]56029086 : [47]55841741 */
	0xa5, /* [130]56463420 : [47]55841741 */
	0x89, /* [131]56897754 : [48]57280998 */
	0x89, /* [132]57332088 : [48]57280998 */
	0x89, /* [133]57766422 : [48]57280998 */
	0x89, /* [134]58200756 : [48]57280998 */
	0x6a, /* [135]58635090 : [49]59316416 */
	0x6a, /* [136]59069424 : [49]59316416 */
	0x6a, /* [137]59503758 : [49]59316416 */
	0x6a, /* [138]59938092 : [49]59316416 */
	0x6a, /* [139]60372426 : [49]59316416 */
	0x6a, /* [140]60806760 : [49]59316416 */
	0x6a, /* [141]61241094 : [49]59316416 */
	0x6a, /* [142]61675428 : [49]59316416 */
	0x7a, /* [143]62109762 : [50]64230349 */
	0x7a, /* [144]62544096 : [50]64230349 */
	0x7a, /* [145]62978430 : [50]64230349 */
	0x7a, /* [146]63412764 : [50]64230349 */
	0x7a, /* [147]63847098 : [50]64230349 */
	0x7a, /* [148]64281432 : [50]64230349 */
	0x7a, /* [149]64715766 : [50]64230349 */
	0x7a, /* [150]65150100 : [50]64230349 */
	0x7a, /* [151]65584434 : [50]64230349 */
	0x99, /* [152]66018768 : [51]67108864 */
	0x99, /* [153]66453102 : [51]67108864 */
	0x99, /* [154]66887436 : [51]67108864 */
	0x99, /* [155]67321770 : [51]67108864 */
	0x99, /* [156]67756104 : [51]67108864 */
	0xb1, /* [157]68190438 : [52]69206016 */
	0xb1, /* [158]68624772 : [52]69206016 */
	0xb1, /* [159]69059106 : [52]69206016 */
	0xb1, /* [160]69493440 : [52]69206016 */
	0xb2, /* [161]69927774 : [53]70074685 */
	0xb2, /* [162]70362108 : [53]70074685 */
	0x8a, /* [163]70796442 : [54]71179699 */
	0x8a, /* [164]71230776 : [54]71179699 */
	0xb3, /* [165]71665110 : [55]71303168 */
	0xb3, /* [166]72099444 : [55]71303168 */
	0xb4, /* [167]72533778 : [56]73040506 */
	0xb4, /* [168]72968112 : [56]73040506 */
	0xb4, /* [169]73402446 : [56]73040506 */
	0xb4, /* [170]73836780 : [56]73040506 */
	0xb5, /* [171]74271114 : [57]75497472 */
	0xb5, /* [172]74705448 : [57]75497472 */
	0xb5, /* [173]75139782 : [57]75497472 */
	0xb5, /* [174]75574116 : [57]75497472 */
	0xb5, /* [175]76008450 : [57]75497472 */
	0xb5, /* [176]76442784 : [57]75497472 */
	0xb5, /* [177]76877118 : [57]75497472 */
	0xb6, /* [178]77311452 : [58]78972147 */
	0xb6, /* [179]77745786 : [58]78972147 */
	0xb6, /* [180]78180120 : [58]78972147 */
	0xb6, /* [181]78614454 : [58]78972147 */
	0xb6, /* [182]79048788 : [58]78972147 */
	0xb6, /* [183]79483122 : [58]78972147 */
	0xb6, /* [184]79917456 : [58]78972147 */
	0xa9, /* [185]80351790 : [59]81007565 */
	0xa9, /* [186]80786124 : [59]81007565 */
	0xa9, /* [187]81220458 : [59]81007565 */
	0xa9, /* [188]81654792 : [59]81007565 */
	0xa9, /* [189]82089126 : [59]81007565 */
	0x7b, /* [190]82523460 : [60]83886080 */
	0x7b, /* [191]82957794 : [60]83886080 */
	0x7b, /* [192]83392128 : [60]83886080 */
	0x7b, /* [193]83826462 : [60]83886080 */
	0x7b, /* [194]84260796 : [60]83886080 */
	0x7b, /* [195]84695130 : [60]83886080 */
	0x7b, /* [196]85129464 : [60]83886080 */
	0x7b, /* [197]85563798 : [60]83886080 */
	0x7b, /* [198]85998132 : [60]83886080 */
	0x7b, /* [199]86432466 : [60]83886080 */
	0x7b, /* [200]86866800 : [60]83886080 */
	0x7b, /* [201]87301134 : [60]83886080 */
	0xb8, /* [202]87735468 : [61]90835430 */
	0xb8, /* [203]88169802 : [61]90835430 */
	0xb8, /* [204]88604136 : [61]90835430 */
	0xb8, /* [205]89038470 : [61]90835430 */
	0xb8, /* [206]89472804 : [61]90835430 */
	0xb8, /* [207]89907138 : [61]90835430 */
	0xb8, /* [208]90341472 : [61]90835430 */
	0xb8, /* [209]90775806 : [61]90835430 */
	0xb8, /* [210]91210140 : [61]90835430 */
	0xb8, /* [211]91644474 : [61]90835430 */
	0xb8, /* [212]92078808 : [61]90835430 */
	0xb8, /* [213]92513142 : [61]90835430 */
	0xaa, /* [214]92947476 : [62]94906266 */
	0xaa, /* [215]93381810 : [62]94906266 */
	0xaa, /* [216]93816144 : [62]94906266 */
	0xaa, /* [217]94250478 : [62]94906266 */
	0xaa, /* [218]94684812 : [62]94906266 */
	0xaa, /* [219]95119146 : [62]94906266 */
	0xaa, /* [220]95553480 : [62]94906266 */
	0x1c, /* [221]95987814 : [63]97003418 */
	0x1c, /* [222]96422148 : [63]97003418 */
	0x1c, /* [223]96856482 : [63]97003418 */
	0x1c, /* [224]97290816 : [63]97003418 */
	0x2c, /* [225]97725150 : [64]97872087 */
	0x2c, /* [226]98159484 : [64]97872087 */
	0x3c, /* [227]98593818 : [65]99100570 */
	0x3c, /* [228]99028152 : [65]99100570 */
	0x3c, /* [229]99462486 : [65]99100570 */
	0x9b, /* [230]99896820 : [66]100663296 */
	0x9b, /* [231]100331154 : [66]100663296 */
	0xc4, /* [232]100765488 : [67]100837908 */
	0xc4, /* [233]101199822 : [67]100837908 */
	0xc4, /* [234]101634156 : [67]100837908 */
	0x5c, /* [235]102068490 : [68]103294874 */
	0x5c, /* [236]102502824 : [68]103294874 */
	0x5c, /* [237]102937158 : [68]103294874 */
	0x5c, /* [238]103371492 : [68]103294874 */
	0x5c, /* [239]103805826 : [68]103294874 */
	0x5c, /* [240]104240160 : [68]103294874 */
	0x5c, /* [241]104674494 : [68]103294874 */
	0x6c, /* [242]105108828 : [69]106769549 */
	0x6c, /* [243]105543162 : [69]106769549 */
	0x6c, /* [244]105977496 : [69]106769549 */
	0x6c, /* [245]106411830 : [69]106769549 */
	0x6c, /* [246]106846164 : [69]106769549 */
	0x6c, /* [247]107280498 : [69]106769549 */
	0x6c, /* [248]107714832 : [69]106769549 */
	0x6c, /* [249]108149166 : [69]106769549 */
	0x6c, /* [250]108583500 : [69]106769549 */
	0x6c, /* [251]109017834 : [69]106769549 */
	0xc7, /* [252]109452168 : [70]111683482 */
	0xc7, /* [253]109886502 : [70]111683482 */
	0xc7, /* [254]110320836 : [70]111683482 */
	0xc7, /* [255]110755170 : [70]111683482 */
};
/*
 * All PT_count=4096
 * Limited (2097152,134217728) PT_count=1485
 * Unique PT_count=265
 * min=0 step=217167
 * Used 229
 */
const uint16_t PCM3_TABLE[] = {
	            /* u  v : out v */
	0x1111, /* [0]0 : [0]6291456 */
	0x1111, /* [1]217167 : [0]6291456 */
	0x1111, /* [2]434334 : [0]6291456 */
	0x1111, /* [3]651501 : [0]6291456 */
	0x1111, /* [4]868668 : [0]6291456 */
	0x1111, /* [5]1085835 : [0]6291456 */
	0x1111, /* [6]1303002 : [0]6291456 */
	0x1111, /* [7]1520169 : [0]6291456 */
	0x1111, /* [8]1737336 : [0]6291456 */
	0x1111, /* [9]1954503 : [0]6291456 */
	0x1111, /* [10]2171670 : [0]6291456 */
	0x1111, /* [11]2388837 : [0]6291456 */
	0x1111, /* [12]2606004 : [0]6291456 */
	0x1111, /* [13]2823171 : [0]6291456 */
	0x1111, /* [14]3040338 : [0]6291456 */
	0x1111, /* [15]3257505 : [0]6291456 */
	0x1111, /* [16]3474672 : [0]6291456 */
	0x1111, /* [17]3691839 : [0]6291456 */
	0x1111, /* [18]3909006 : [0]6291456 */
	0x1111, /* [19]4126173 : [0]6291456 */
	0x1111, /* [20]4343340 : [0]6291456 */
	0x1111, /* [21]4560507 : [0]6291456 */
	0x1111, /* [22]4777674 : [0]6291456 */
	0x1111, /* [23]4994841 : [0]6291456 */
	0x1111, /* [24]5212008 : [0]6291456 */
	0x1111, /* [25]5429175 : [0]6291456 */
	0x1111, /* [26]5646342 : [0]6291456 */
	0x1111, /* [27]5863509 : [0]6291456 */
	0x1111, /* [28]6080676 : [0]6291456 */
	0x1111, /* [29]6297843 : [0]6291456 */
	0x1111, /* [30]6515010 : [0]6291456 */
	0x1211, /* [31]6732177 : [1]7160125 */
	0x1211, /* [32]6949344 : [1]7160125 */
	0x1211, /* [33]7166511 : [1]7160125 */
	0x1211, /* [34]7383678 : [1]7160125 */
	0x2211, /* [35]7600845 : [2]8028794 */
	0x2211, /* [36]7818012 : [2]8028794 */
	0x2211, /* [37]8035179 : [2]8028794 */
	0x1311, /* [38]8252346 : [3]8388608 */
	0x1311, /* [39]8469513 : [3]8388608 */
	0x2222, /* [40]8686680 : [4]8897463 */
	0x2222, /* [41]8903847 : [4]8897463 */
	0x2133, /* [42]9121014 : [5]9257277 */
	0x2133, /* [43]9338181 : [5]9257277 */
	0x2133, /* [44]9555348 : [5]9257277 */
	0x3222, /* [45]9772515 : [6]10125946 */
	0x3222, /* [46]9989682 : [6]10125946 */
	0x3222, /* [47]10206849 : [6]10125946 */
	0x3133, /* [48]10424016 : [7]10485760 */
	0x3133, /* [49]10641183 : [7]10485760 */
	0x1244, /* [50]10858350 : [8]10994615 */
	0x1244, /* [51]11075517 : [8]10994615 */
	0x3233, /* [52]11292684 : [9]11354429 */
	0x3233, /* [53]11509851 : [9]11354429 */
	0x2422, /* [54]11727018 : [10]11863284 */
	0x2422, /* [55]11944185 : [10]11863284 */
	0x3411, /* [56]12161352 : [11]12223098 */
	0x3411, /* [57]12378519 : [11]12223098 */
	0x3333, /* [58]12595686 : [12]12582912 */
	0x3333, /* [59]12812853 : [12]12582912 */
	0x3244, /* [60]13030020 : [13]13091767 */
	0x3244, /* [61]13247187 : [13]13091767 */
	0x5122, /* [62]13464354 : [14]13451581 */
	0x5122, /* [63]13681521 : [14]13451581 */
	0x4411, /* [64]13898688 : [15]13960436 */
	0x4411, /* [65]14115855 : [15]13960436 */
	0x3433, /* [66]14333022 : [16]14320250 */
	0x1533, /* [67]14550189 : [17]14680064 */
	0x2444, /* [68]14767356 : [18]14829105 */
	0x2444, /* [69]14984523 : [18]14829105 */
	0x3522, /* [70]15201690 : [19]15548733 */
	0x3522, /* [71]15418857 : [19]15548733 */
	0x3522, /* [72]15636024 : [19]15548733 */
	0x4344, /* [73]15853191 : [20]16057588 */
	0x4344, /* [74]16070358 : [20]16057588 */
	0x1544, /* [75]16287525 : [21]16417402 */
	0x1544, /* [76]16504692 : [21]16417402 */
	0x3355, /* [77]16721859 : [22]16777216 */
	0x2166, /* [78]16939026 : [23]16926256 */
	0x5244, /* [79]17156193 : [24]17286071 */
	0x5244, /* [80]17373360 : [24]17286071 */
	0x4444, /* [81]17590527 : [25]17794926 */
	0x4444, /* [82]17807694 : [25]17794926 */
	0x3166, /* [83]18024861 : [26]18154739 */
	0x3166, /* [84]18242028 : [26]18154739 */
	0x4355, /* [85]18459195 : [27]18514554 */
	0x4355, /* [86]18676362 : [27]18514554 */
	0x5155, /* [87]18893529 : [28]18874368 */
	0x3622, /* [88]19110696 : [29]19023408 */
	0x3622, /* [89]19327863 : [29]19023408 */
	0x2555, /* [90]19545030 : [30]19743037 */
	0x2555, /* [91]19762197 : [30]19743037 */
	0x1644, /* [92]19979364 : [31]19892077 */
	0x5444, /* [93]20196531 : [32]20251892 */
	0x5444, /* [94]20413698 : [32]20251892 */
	0x2644, /* [95]20630865 : [33]20760746 */
	0x2644, /* [96]20848032 : [33]20760746 */
	0x5533, /* [97]21065199 : [34]20971520 */
	0x5533, /* [98]21282366 : [34]20971520 */
	0x2711, /* [99]21499533 : [35]21840189 */
	0x2711, /* [100]21716700 : [35]21840189 */
	0x4633, /* [101]21933867 : [36]21989229 */
	0x4633, /* [102]22151034 : [36]21989229 */
	0x6511, /* [103]22368201 : [37]22349043 */
	0x5455, /* [104]22585368 : [38]22708858 */
	0x5455, /* [105]22802535 : [38]22708858 */
	0x7133, /* [106]23019702 : [39]23068672 */
	0x5266, /* [107]23236869 : [40]23217712 */
	0x5266, /* [108]23454036 : [40]23217712 */
	0x6444, /* [109]23671203 : [41]23726567 */
	0x3722, /* [110]23888370 : [42]23937341 */
	0x3722, /* [111]24105537 : [42]23937341 */
	0x3655, /* [112]24322704 : [43]24446195 */
	0x3655, /* [113]24539871 : [43]24446195 */
	0x1477, /* [114]24757038 : [44]24806010 */
	0x1477, /* [115]24974205 : [44]24806010 */
	0x5555, /* [116]25191372 : [45]25165824 */
	0x5555, /* [117]25408539 : [45]25165824 */
	0x2477, /* [118]25625706 : [46]25674679 */
	0x6166, /* [119]25842873 : [47]25823718 */
	0x6544, /* [120]26060040 : [48]26183533 */
	0x6544, /* [121]26277207 : [48]26183533 */
	0x6266, /* [122]26494374 : [49]26692387 */
	0x6266, /* [123]26711541 : [49]26692387 */
	0x7344, /* [124]26928708 : [50]26903162 */
	0x1577, /* [125]27145875 : [51]27262976 */
	0x1577, /* [126]27363042 : [51]27262976 */
	0x1577, /* [127]27580209 : [51]27262976 */
	0x6366, /* [128]27797376 : [52]27920870 */
	0x6366, /* [129]28014543 : [52]27920870 */
	0x7255, /* [130]28231710 : [53]28131645 */
	0x6555, /* [131]28448877 : [54]28640499 */
	0x6555, /* [132]28666044 : [54]28640499 */
	0x2188, /* [133]28883211 : [55]28789539 */
	0x7355, /* [134]29100378 : [56]29360128 */
	0x7355, /* [135]29317545 : [56]29360128 */
	0x6644, /* [136]29534712 : [57]29658208 */
	0x6644, /* [137]29751879 : [57]29658208 */
	0x3188, /* [138]29969046 : [58]30018022 */
	0x3188, /* [139]30186213 : [58]30018022 */
	0x1677, /* [140]30403380 : [59]30737651 */
	0x1677, /* [141]30620547 : [59]30737651 */
	0x3822, /* [142]30837714 : [60]30886691 */
	0x4755, /* [143]31054881 : [61]31097466 */
	0x4755, /* [144]31272048 : [61]31097466 */
	0x6722, /* [145]31489215 : [62]31606320 */
	0x4811, /* [146]31706382 : [63]31755360 */
	0x4811, /* [147]31923549 : [63]31755360 */
	0x5666, /* [148]32140716 : [64]32115174 */
	0x5666, /* [149]32357883 : [64]32115174 */
	0x8244, /* [150]32575050 : [65]32624029 */
	0x7366, /* [151]32792217 : [66]32834803 */
	0x7366, /* [152]33009384 : [66]32834803 */
	0x5577, /* [153]33226551 : [67]33554432 */
	0x5577, /* [154]33443718 : [67]33554432 */
	0x5577, /* [155]33660885 : [67]33554432 */
	0x4833, /* [156]33878052 : [68]33852512 */
	0x5188, /* [157]34095219 : [69]34212326 */
	0x5188, /* [158]34312386 : [69]34212326 */
	0x7466, /* [159]34529553 : [70]34572141 */
	0x7466, /* [160]34746720 : [70]34572141 */
	0x5288, /* [161]34963887 : [71]35080995 */
	0x5288, /* [162]35181054 : [71]35080995 */
	0x6666, /* [163]35398221 : [72]35589849 */
	0x6666, /* [164]35615388 : [72]35589849 */
	0x7177, /* [165]35832555 : [73]35651584 */
	0x3588, /* [166]36049722 : [74]36309478 */
	0x3588, /* [167]36266889 : [74]36309478 */
	0x7722, /* [168]36484056 : [75]36520253 */
	0x7722, /* [169]36701223 : [75]36520253 */
	0x5766, /* [170]36918390 : [76]37029107 */
	0x5766, /* [171]37135557 : [76]37029107 */
	0x5766, /* [172]37352724 : [76]37029107 */
	0x8166, /* [173]37569891 : [77]37687001 */
	0x7377, /* [174]37787058 : [78]37748736 */
	0x8544, /* [175]38004225 : [79]38046816 */
	0x8544, /* [176]38221392 : [79]38046816 */
	0x8622, /* [177]38438559 : [80]38555670 */
	0x1922, /* [178]38655726 : [81]38617405 */
	0x1922, /* [179]38872893 : [81]38617405 */
	0x7744, /* [180]39090060 : [82]39486074 */
	0x7744, /* [181]39307227 : [82]39486074 */
	0x7744, /* [182]39524394 : [82]39486074 */
	0x6833, /* [183]39741561 : [83]39784153 */
	0x1933, /* [184]39958728 : [84]39845888 */
	0x6766, /* [185]40175895 : [85]40503782 */
	0x6766, /* [186]40393062 : [85]40503782 */
	0x3922, /* [187]40610229 : [86]40714557 */
	0x3922, /* [188]40827396 : [86]40714557 */
	0x3922, /* [189]41044563 : [86]40714557 */
	0x4688, /* [190]41261730 : [87]41521491 */
	0x4688, /* [191]41478897 : [87]41521491 */
	0x9144, /* [192]41696064 : [88]41583226 */
	0x5777, /* [193]41913231 : [89]41943040 */
	0x5777, /* [194]42130398 : [89]41943040 */
	0x2499, /* [195]42347565 : [90]42451895 */
	0x1877, /* [196]42564732 : [91]42600934 */
	0x1877, /* [197]42781899 : [91]42600934 */
	0x1877, /* [198]42999066 : [91]42600934 */
	0x7288, /* [199]43216233 : [92]43469603 */
	0x7288, /* [200]43433400 : [92]43469603 */
	0x9344, /* [201]43650567 : [93]43680378 */
	0x6588, /* [202]43867734 : [94]43978457 */
	0x1599, /* [203]44084901 : [95]44040192 */
	0x1599, /* [204]44302068 : [95]44040192 */
	0x3877, /* [205]44519235 : [96]44698086 */
	0x3877, /* [206]44736402 : [96]44698086 */
	0x5922, /* [207]44953569 : [97]44908861 */
	0x7677, /* [208]45170736 : [98]45417715 */
	0x7677, /* [209]45387903 : [98]45417715 */
	0x7677, /* [210]45605070 : [98]45417715 */
	0x3599, /* [211]45822237 : [99]46137344 */
	0x3599, /* [212]46039404 : [99]46137344 */
	0x3599, /* [213]46256571 : [99]46137344 */
	0x4877, /* [214]46473738 : [100]46435424 */
	0x4877, /* [215]46690905 : [100]46435424 */
	0x4877, /* [216]46908072 : [100]46435424 */
	0x8666, /* [217]47125239 : [101]47453132 */
	0x8666, /* [218]47342406 : [101]47453132 */
	0x9166, /* [219]47559573 : [102]47514867 */
	0x5944, /* [220]47776740 : [103]47874682 */
	0x5944, /* [221]47993907 : [103]47874682 */
	0x2966, /* [222]48211074 : [104]48383536 */
	0x2966, /* [223]48428241 : [104]48383536 */
	0x8755, /* [224]48645408 : [105]48892390 */
	0x8755, /* [225]48862575 : [105]48892390 */
	0x8755, /* [226]49079742 : [105]48892390 */
	0x8188, /* [227]49296909 : [106]49550284 */
	0x8188, /* [228]49514076 : [106]49550284 */
	0x6933, /* [229]49731243 : [107]49612019 */
	0x6933, /* [230]49948410 : [107]49612019 */
	0x7777, /* [231]50165577 : [108]50331648 */
	0x8288, /* [232]50382744 : [109]50418953 */
	0x8288, /* [233]50599911 : [109]50418953 */
	0x8288, /* [234]50817078 : [109]50418953 */
	0x4966, /* [235]51034245 : [110]51349357 */
	0x4966, /* [236]51251412 : [110]51349357 */
	0x4966, /* [237]51468579 : [110]51349357 */
	0x8833, /* [238]51685746 : [111]51647436 */
	0x8833, /* [239]51902913 : [111]51647436 */
	0x7688, /* [240]52120080 : [112]52367065 */
	0x7688, /* [241]52337247 : [112]52367065 */
	0x1a22, /* [242]52554414 : [114]52516106 */
	0x1a22, /* [243]52771581 : [114]52516106 */
	0x2977, /* [244]52988748 : [115]53297469 */
	0x2977, /* [245]53205915 : [115]53297469 */
	0x8488, /* [246]53423082 : [116]53384774 */
	0xa311, /* [247]53640249 : [117]53744589 */
	0x9566, /* [248]53857416 : [118]53806323 */
	0x9566, /* [249]54074583 : [118]53806323 */
	0x3977, /* [250]54291750 : [119]54525952 */
	0x3977, /* [251]54508917 : [119]54525952 */
	0x2a33, /* [252]54726084 : [120]54613258 */
	0x2a33, /* [253]54943251 : [120]54613258 */
	0x14aa, /* [254]55160418 : [121]55481927 */
	0x14aa, /* [255]55377585 : [121]55481927 */
	0x14aa, /* [256]55594752 : [121]55481927 */
	0x8855, /* [257]55811919 : [122]55841740 */
	0x8855, /* [258]56029086 : [122]55841740 */
	0x9477, /* [259]56246253 : [123]56263290 */
	0x24aa, /* [260]56463420 : [124]56350596 */
	0x24aa, /* [261]56680587 : [124]56350596 */
	0x7877, /* [262]56897754 : [125]57280998 */
	0x7877, /* [263]57114921 : [125]57280998 */
	0x7877, /* [264]57332088 : [125]57280998 */
	0x3a44, /* [265]57549255 : [126]57579079 */
	0x15aa, /* [266]57766422 : [127]57938893 */
	0x15aa, /* [267]57983589 : [127]57938893 */
	0x15aa, /* [268]58200756 : [127]57938893 */
	0x7599, /* [269]58417923 : [128]58720256 */
	0x7599, /* [270]58635090 : [128]58720256 */
	0x2a55, /* [271]58852257 : [129]58807562 */
	0x6888, /* [272]59069424 : [130]59316415 */
	0x6888, /* [273]59286591 : [130]59316415 */
	0x1899, /* [274]59503758 : [131]59378150 */
	0x35aa, /* [275]59720925 : [132]60036045 */
	0x35aa, /* [276]59938092 : [132]60036045 */
	0x2988, /* [277]60155259 : [133]60246819 */
	0x2988, /* [278]60372426 : [133]60246819 */
	0x2988, /* [279]60589593 : [133]60246819 */
	0x2988, /* [280]60806760 : [133]60246819 */
	0x61aa, /* [281]61023927 : [134]61413568 */
	0x61aa, /* [282]61241094 : [134]61413568 */
	0x9833, /* [283]61458261 : [135]61475302 */
	0xa455, /* [284]61675428 : [136]61773383 */
	0xa455, /* [285]61892595 : [136]61773383 */
	0x7966, /* [286]62109762 : [137]62194931 */
	0x2a66, /* [287]62326929 : [138]62282237 */
	0x2a66, /* [288]62544096 : [138]62282237 */
	0x4988, /* [289]62761263 : [139]63212640 */
	0x4988, /* [290]62978430 : [139]63212640 */
	0x4988, /* [291]63195597 : [139]63212640 */
	0x63aa, /* [292]63412764 : [140]63510720 */
	0x63aa, /* [293]63629931 : [140]63510720 */
	0x63aa, /* [294]63847098 : [140]63510720 */
	0x8877, /* [295]64064265 : [141]64230348 */
	0x8877, /* [296]64281432 : [141]64230348 */
	0x8877, /* [297]64498599 : [141]64230348 */
	0x8877, /* [298]64715766 : [141]64230348 */
	0x64aa, /* [299]64932933 : [142]65248058 */
	0x64aa, /* [300]65150100 : [142]65248058 */
	0x64aa, /* [301]65367267 : [142]65248058 */
	0x9855, /* [302]65584434 : [143]65669606 */
	0x9855, /* [303]65801601 : [143]65669606 */
	0x17aa, /* [304]66018768 : [144]66327501 */
	0x17aa, /* [305]66235935 : [144]66327501 */
	0x17aa, /* [306]66453102 : [144]66327501 */
	0x17aa, /* [307]66670269 : [144]66327501 */
	0x9777, /* [308]66887436 : [145]67108864 */
	0x9777, /* [309]67104603 : [145]67108864 */
	0xa722, /* [310]67321770 : [146]67196170 */
	0x65aa, /* [311]67538937 : [147]67705024 */
	0x65aa, /* [312]67756104 : [147]67705024 */
	0x65aa, /* [313]67973271 : [147]67705024 */
	0xa733, /* [314]68190438 : [148]68424653 */
	0xa733, /* [315]68407605 : [148]68424653 */
	0xa733, /* [316]68624772 : [148]68424653 */
	0x8699, /* [317]68841939 : [149]69144281 */
	0x8699, /* [318]69059106 : [149]69144281 */
	0x1999, /* [319]69276273 : [150]69206016 */
	0x1999, /* [320]69493440 : [150]69206016 */
	0x9922, /* [321]69710607 : [151]70074685 */
	0x9922, /* [322]69927774 : [151]70074685 */
	0x47aa, /* [323]70144941 : [152]70161991 */
	0x47aa, /* [324]70362108 : [152]70161991 */
	0x47aa, /* [325]70579275 : [152]70161991 */
	0x8888, /* [326]70796442 : [153]71179698 */
	0x8888, /* [327]71013609 : [153]71179698 */
	0x8888, /* [328]71230776 : [153]71179698 */
	0x3999, /* [329]71447943 : [154]71303168 */
	0x3999, /* [330]71665110 : [154]71303168 */
	0x21bb, /* [331]71882277 : [155]72171837 */
	0x21bb, /* [332]72099444 : [155]72171837 */
	0x21bb, /* [333]72316611 : [155]72171837 */
	0x57aa, /* [334]72533778 : [156]72618957 */
	0x57aa, /* [335]72750945 : [156]72618957 */
	0x4999, /* [336]72968112 : [157]73040506 */
	0x81aa, /* [337]73185279 : [158]73276851 */
	0x31bb, /* [338]73402446 : [159]73400320 */
	0x31bb, /* [339]73619613 : [159]73400320 */
	0x9877, /* [340]73836780 : [160]74058214 */
	0x9877, /* [341]74053947 : [160]74058214 */
	0x32bb, /* [342]74271114 : [162]74268989 */
	0x32bb, /* [343]74488281 : [162]74268989 */
	0x4b11, /* [344]74705448 : [163]75137658 */
	0x4b11, /* [345]74922615 : [163]75137658 */
	0x4b11, /* [346]75139782 : [163]75137658 */
	0x83aa, /* [347]75356949 : [164]75374003 */
	0x5999, /* [348]75574116 : [165]75497472 */
	0x4b22, /* [349]75791283 : [166]76006327 */
	0x4b22, /* [350]76008450 : [166]76006327 */
	0xa766, /* [351]76225617 : [167]76093632 */
	0xa766, /* [352]76442784 : [167]76093632 */
	0xa844, /* [353]76659951 : [168]77111341 */
	0xa844, /* [354]76877118 : [168]77111341 */
	0xa844, /* [355]77094285 : [168]77111341 */
	0x4b33, /* [356]77311452 : [169]77234810 */
	0x1b55, /* [357]77528619 : [170]77594624 */
	0x1b55, /* [358]77745786 : [170]77594624 */
	0x1b55, /* [359]77962953 : [170]77594624 */
	0x25bb, /* [360]78180120 : [171]78463293 */
	0x25bb, /* [361]78397287 : [171]78463293 */
	0x25bb, /* [362]78614454 : [171]78463293 */
	0x9966, /* [363]78831621 : [172]78972147 */
	0x9966, /* [364]79048788 : [172]78972147 */
	0x9966, /* [365]79265955 : [172]78972147 */
	0x5a88, /* [366]79483122 : [173]79568307 */
	0x5b33, /* [367]79700289 : [174]79691776 */
	0x5b33, /* [368]79917456 : [174]79691776 */
	0x5b33, /* [369]80134623 : [174]79691776 */
	0x8899, /* [370]80351790 : [175]81007564 */
	0x8899, /* [371]80568957 : [175]81007564 */
	0x8899, /* [372]80786124 : [175]81007564 */
	0x8899, /* [373]81003291 : [175]81007564 */
	0x6b11, /* [374]81220458 : [176]81069299 */
	0xb544, /* [375]81437625 : [177]81429114 */
	0xb544, /* [376]81654792 : [177]81429114 */
	0x6b22, /* [377]81871959 : [178]81937968 */
	0x6b22, /* [378]82089126 : [178]81937968 */
	0x6b22, /* [379]82306293 : [178]81937968 */
	0x8a66, /* [380]82523460 : [179]83042982 */
	0x8a66, /* [381]82740627 : [179]83042982 */
	0x8a66, /* [382]82957794 : [179]83042982 */
	0xb366, /* [383]83174961 : [181]83166451 */
	0xb366, /* [384]83392128 : [181]83166451 */
	0x9799, /* [385]83609295 : [182]83886080 */
	0x9799, /* [386]83826462 : [182]83886080 */
	0xa299, /* [387]84043629 : [183]83973386 */
	0xa299, /* [388]84260796 : [183]83973386 */
	0xb644, /* [389]84477963 : [184]84903789 */
	0xb644, /* [390]84695130 : [184]84903789 */
	0xb644, /* [391]84912297 : [184]84903789 */
	0xa933, /* [392]85129464 : [185]85201869 */
	0xa933, /* [393]85346631 : [185]85201869 */
	0xa933, /* [394]85563798 : [185]85201869 */
	0x71bb, /* [395]85780965 : [186]85983232 */
	0x71bb, /* [396]85998132 : [186]85983232 */
	0x71bb, /* [397]86215299 : [186]85983232 */
	0x2b77, /* [398]86432466 : [187]86851901 */
	0x2b77, /* [399]86649633 : [187]86851901 */
	0x2b77, /* [400]86866800 : [187]86851901 */
	0x9a44, /* [401]87083967 : [188]86939207 */
	0x65bb, /* [402]87301134 : [189]87360755 */
	0x65bb, /* [403]87518301 : [189]87360755 */
	0x7a88, /* [404]87735468 : [190]87956915 */
	0x7a88, /* [405]87952635 : [190]87956915 */
	0x37bb, /* [406]88169802 : [191]88080384 */
	0x37bb, /* [407]88386969 : [191]88080384 */
	0x37bb, /* [408]88604136 : [191]88080384 */
	0xa599, /* [409]88821303 : [192]89396173 */
	0xa599, /* [410]89038470 : [192]89396173 */
	0xa599, /* [411]89255637 : [192]89396173 */
	0xa599, /* [412]89472804 : [192]89396173 */
	0xb477, /* [413]89689971 : [193]89817722 */
	0xb477, /* [414]89907138 : [193]89817722 */
	0xb477, /* [415]90124305 : [193]89817722 */
	0x9988, /* [416]90341472 : [194]90835430 */
	0x9988, /* [417]90558639 : [194]90835430 */
	0x9988, /* [418]90775806 : [194]90835430 */
	0x9988, /* [419]90992973 : [194]90835430 */
	0x9988, /* [420]91210140 : [194]90835430 */
	0x9988, /* [421]91427307 : [194]90835430 */
	0xb577, /* [422]91644474 : [195]92274688 */
	0xb577, /* [423]91861641 : [195]92274688 */
	0xb577, /* [424]92078808 : [195]92274688 */
	0xb577, /* [425]92295975 : [195]92274688 */
	0xb577, /* [426]92513142 : [195]92274688 */
	0x96aa, /* [427]92730309 : [196]92870848 */
	0x1b88, /* [428]92947476 : [197]92932582 */
	0x1b88, /* [429]93164643 : [197]92932582 */
	0x8b22, /* [430]93381810 : [198]93801251 */
	0x8b22, /* [431]93598977 : [198]93801251 */
	0x8b22, /* [432]93816144 : [198]93801251 */
	0x8b22, /* [433]94033311 : [198]93801251 */
	0x8b22, /* [434]94250478 : [198]93801251 */
	0x88aa, /* [435]94467645 : [199]94906265 */
	0x88aa, /* [436]94684812 : [199]94906265 */
	0x88aa, /* [437]94901979 : [199]94906265 */
	0x83bb, /* [438]95119146 : [200]95029734 */
	0x83bb, /* [439]95336313 : [200]95029734 */
	0x76bb, /* [440]95553480 : [201]95749363 */
	0x76bb, /* [441]95770647 : [201]95749363 */
	0x76bb, /* [442]95987814 : [201]95749363 */
	0x76bb, /* [443]96204981 : [201]95749363 */
	0x8b44, /* [444]96422148 : [202]96767072 */
	0x8b44, /* [445]96639315 : [202]96767072 */
	0x8b44, /* [446]96856482 : [202]96767072 */
	0xa1aa, /* [447]97073649 : [203]97003418 */
	0xa1aa, /* [448]97290816 : [203]97003418 */
	0x9a77, /* [449]97507983 : [204]97784781 */
	0x9a77, /* [450]97725150 : [204]97784781 */
	0x2aaa, /* [451]97942317 : [205]97872087 */
	0x2aaa, /* [452]98159484 : [205]97872087 */
	0x2aaa, /* [453]98376651 : [205]97872087 */
	0xaa33, /* [454]98593818 : [206]99100570 */
	0xaa33, /* [455]98810985 : [206]99100570 */
	0xaa33, /* [456]99028152 : [206]99100570 */
	0x58bb, /* [457]99245319 : [207]99224038 */
	0x58bb, /* [458]99462486 : [207]99224038 */
	0x2c11, /* [459]99679653 : [208]99969239 */
	0x2c11, /* [460]99896820 : [208]99969239 */
	0x2c11, /* [461]100113987 : [208]99969239 */
	0x9999, /* [462]100331154 : [209]100663296 */
	0x9999, /* [463]100548321 : [209]100663296 */
	0x4aaa, /* [464]100765488 : [210]100837908 */
	0x4aaa, /* [465]100982655 : [210]100837908 */
	0xc133, /* [466]101199822 : [211]101197722 */
	0xc133, /* [467]101416989 : [211]101197722 */
	0xc233, /* [468]101634156 : [212]102066391 */
	0xc233, /* [469]101851323 : [212]102066391 */
	0xc233, /* [470]102068490 : [212]102066391 */
	0xc233, /* [471]102285657 : [212]102066391 */
	0x68bb, /* [472]102502824 : [213]102698713 */
	0x68bb, /* [473]102719991 : [213]102698713 */
	0xc411, /* [474]102937158 : [215]102935060 */
	0x5aaa, /* [475]103154325 : [216]103294874 */
	0x5aaa, /* [476]103371492 : [216]103294874 */
	0x9b22, /* [477]103588659 : [217]103629117 */
	0x4c22, /* [478]103805826 : [218]103803729 */
	0x4c22, /* [479]104022993 : [218]103803729 */
	0x4c22, /* [480]104240160 : [218]103803729 */
	0x89aa, /* [481]104457327 : [219]104734131 */
	0x89aa, /* [482]104674494 : [219]104734131 */
	0x3b99, /* [483]104891661 : [220]104857600 */
	0x4c33, /* [484]105108828 : [221]105032212 */
	0x51cc, /* [485]105325995 : [222]105392026 */
	0x51cc, /* [486]105543162 : [222]105392026 */
	0x51cc, /* [487]105760329 : [222]105392026 */
	0x5c22, /* [488]105977496 : [223]106260695 */
	0x5c22, /* [489]106194663 : [223]106260695 */
	0x5c22, /* [490]106411830 : [223]106260695 */
	0xb499, /* [491]106628997 : [224]106594938 */
	0xa6aa, /* [492]106846164 : [225]106769549 */
	0xa6aa, /* [493]107063331 : [225]106769549 */
	0x5c33, /* [494]107280498 : [226]107489178 */
	0x5c33, /* [495]107497665 : [226]107489178 */
	0x87bb, /* [496]107714832 : [227]107612646 */
	0x87bb, /* [497]107931999 : [227]107612646 */
	0x87bb, /* [498]108149166 : [227]107612646 */
	0x61cc, /* [499]108366333 : [228]108866701 */
	0x61cc, /* [500]108583500 : [228]108866701 */
	0x61cc, /* [501]108800667 : [228]108866701 */
	0x9b55, /* [502]109017834 : [229]109051904 */
	0xc455, /* [503]109235001 : [230]109226516 */
	0xc455, /* [504]109452168 : [230]109226516 */
	0xc622, /* [505]109669335 : [231]109735370 */
	0xc622, /* [506]109886502 : [231]109735370 */
	0xc622, /* [507]110103669 : [231]109735370 */
	0xc622, /* [508]110320836 : [231]109735370 */
	0x6c33, /* [509]110538003 : [232]110963853 */
	0x6c33, /* [510]110755170 : [232]110963853 */
	0x6c33, /* [511]110972337 : [232]110963853 */
};
/*
 * All PT_count=256
 * Limited (2097152,134217728) PT_count=169
 * Unique PT_count=114
 * min=0 step=434334
 * Used 100
 */
const uint8_t PAM2A_TABLE[] = {
	        /* u  v : out v */
	0x11, /* [0]0 : [0]2097152 */
	0x11, /* [1]434334 : [0]2097152 */
	0x11, /* [2]868668 : [0]2097152 */
	0x11, /* [3]1303002 : [0]2097152 */
	0x11, /* [4]1737336 : [0]2097152 */
	0x11, /* [5]2171670 : [0]2097152 */
	0x12, /* [6]2606004 : [2]2676264 */
	0x22, /* [7]3040338 : [4]2965821 */
	0x13, /* [8]3474672 : [6]3495253 */
	0x42, /* [9]3909006 : [8]3954428 */
	0x33, /* [10]4343340 : [9]4194304 */
	0x52, /* [11]4777674 : [11]4773416 */
	0x34, /* [12]5212008 : [13]5352529 */
	0x53, /* [13]5646342 : [14]5592405 */
	0x44, /* [14]6080676 : [15]5931642 */
	0x25, /* [15]6515010 : [17]6581012 */
	0x35, /* [16]6949344 : [19]6990506 */
	0x45, /* [17]7383678 : [20]7569619 */
	0x64, /* [18]7818012 : [21]7908855 */
	0x55, /* [19]8252346 : [22]8388608 */
	0x16, /* [20]8686680 : [23]8607906 */
	0x36, /* [21]9121014 : [25]9306956 */
	0x65, /* [22]9555348 : [26]9546833 */
	0x46, /* [23]9989682 : [27]9886069 */
	0x56, /* [24]10424016 : [28]10705058 */
	0x56, /* [25]10858350 : [28]10705058 */
	0x75, /* [26]11292684 : [29]11184810 */
	0x66, /* [27]11727018 : [30]11863283 */
	0x27, /* [28]12161352 : [32]12173417 */
	0x37, /* [29]12595686 : [33]12582912 */
	0x47, /* [30]13030020 : [34]13162024 */
	0x76, /* [31]13464354 : [35]13501260 */
	0x57, /* [32]13898688 : [36]13981013 */
	0x57, /* [33]14333022 : [36]13981013 */
	0x67, /* [34]14767356 : [37]15139238 */
	0x67, /* [35]15201690 : [37]15139238 */
	0x86, /* [36]15636024 : [38]15817710 */
	0x86, /* [37]16070358 : [38]15817710 */
	0x18, /* [38]16504692 : [39]16516761 */
	0x28, /* [39]16939026 : [41]16806317 */
	0x38, /* [40]17373360 : [42]17215812 */
	0x48, /* [41]17807694 : [43]17794924 */
	0x58, /* [42]18242028 : [44]18613913 */
	0x58, /* [43]18676362 : [44]18613913 */
	0x96, /* [44]19110696 : [45]19093666 */
	0x68, /* [45]19545030 : [46]19772138 */
	0x68, /* [46]19979364 : [46]19772138 */
	0x68, /* [47]20413698 : [46]19772138 */
	0x78, /* [48]20848032 : [47]21410116 */
	0x78, /* [49]21282366 : [47]21410116 */
	0x78, /* [50]21716700 : [47]21410116 */
	0x97, /* [51]22151034 : [48]22369621 */
	0x97, /* [52]22585368 : [48]22369621 */
	0x19, /* [53]23019702 : [49]23068672 */
	0x29, /* [54]23454036 : [50]23358228 */
	0x39, /* [55]23888370 : [52]23767722 */
	0x49, /* [56]24322704 : [53]24346835 */
	0x59, /* [57]24757038 : [54]25165824 */
	0x59, /* [58]25191372 : [54]25165824 */
	0x59, /* [59]25625706 : [54]25165824 */
	0x69, /* [60]26060040 : [55]26324049 */
	0x69, /* [61]26494374 : [55]26324049 */
	0x98, /* [62]26928708 : [56]27002521 */
	0x98, /* [63]27363042 : [56]27002521 */
	0x79, /* [64]27797376 : [57]27962026 */
	0x79, /* [65]28231710 : [57]27962026 */
	0x79, /* [66]28666044 : [57]27962026 */
	0x79, /* [67]29100378 : [57]27962026 */
	0x89, /* [68]29534712 : [58]30278476 */
	0x89, /* [69]29969046 : [58]30278476 */
	0x89, /* [70]30403380 : [58]30278476 */
	0x89, /* [71]30837714 : [58]30278476 */
	0xa8, /* [72]31272048 : [59]31635421 */
	0xa8, /* [73]31706382 : [59]31635421 */
	0x1a, /* [74]32140716 : [60]32334472 */
	0x2a, /* [75]32575050 : [61]32624029 */
	0x3a, /* [76]33009384 : [62]33033523 */
	0x99, /* [77]33443718 : [63]33554432 */
	0x4a, /* [78]33878052 : [64]33612636 */
	0x5a, /* [79]34312386 : [65]34431624 */
	0x5a, /* [80]34746720 : [65]34431624 */
	0x6a, /* [81]35181054 : [66]35589849 */
	0x6a, /* [82]35615388 : [66]35589849 */
	0x6a, /* [83]36049722 : [66]35589849 */
	0x7a, /* [84]36484056 : [67]37227827 */
	0x7a, /* [85]36918390 : [67]37227827 */
	0x7a, /* [86]37352724 : [67]37227827 */
	0xa9, /* [87]37787058 : [68]38187332 */
	0xa9, /* [88]38221392 : [68]38187332 */
	0xa9, /* [89]38655726 : [68]38187332 */
	0x8a, /* [90]39090060 : [69]39544277 */
	0x8a, /* [91]39524394 : [69]39544277 */
	0x8a, /* [92]39958728 : [69]39544277 */
	0x8a, /* [93]40393062 : [69]39544277 */
	0x8a, /* [94]40827396 : [69]39544277 */
	0x9a, /* [95]41261730 : [70]42820232 */
	0x9a, /* [96]41696064 : [70]42820232 */
	0x9a, /* [97]42130398 : [70]42820232 */
	0x9a, /* [98]42564732 : [70]42820232 */
	0x9a, /* [99]42999066 : [70]42820232 */
	0x9a, /* [100]43433400 : [70]42820232 */
	0xb9, /* [101]43867734 : [71]44739242 */
	0xb9, /* [102]44302068 : [71]44739242 */
	0xb9, /* [103]44736402 : [71]44739242 */
	0x1b, /* [104]45170736 : [72]45438293 */
	0x2b, /* [105]45605070 : [73]45727849 */
	0x3b, /* [106]46039404 : [74]46137344 */
	0x4b, /* [107]46473738 : [75]46716456 */
	0x4b, /* [108]46908072 : [75]46716456 */
	0xc8, /* [109]47342406 : [76]47453132 */
	0x5b, /* [110]47776740 : [77]47535445 */
	0x6b, /* [111]48211074 : [78]48693670 */
	0x6b, /* [112]48645408 : [78]48693670 */
	0x6b, /* [113]49079742 : [78]48693670 */
	0x7b, /* [114]49514076 : [79]50331648 */
	0x7b, /* [115]49948410 : [79]50331648 */
	0x7b, /* [116]50382744 : [79]50331648 */
	0x7b, /* [117]50817078 : [79]50331648 */
	0x7b, /* [118]51251412 : [79]50331648 */
	0x8b, /* [119]51685746 : [80]52648098 */
	0x8b, /* [120]52120080 : [80]52648098 */
	0x8b, /* [121]52554414 : [80]52648098 */
	0x8b, /* [122]52988748 : [80]52648098 */
	0xba, /* [123]53423082 : [81]54005043 */
	0xba, /* [124]53857416 : [81]54005043 */
	0xba, /* [125]54291750 : [81]54005043 */
	0xba, /* [126]54726084 : [81]54005043 */
	0x9b, /* [127]55160418 : [82]55924053 */
	0x9b, /* [128]55594752 : [82]55924053 */
	0x9b, /* [129]56029086 : [82]55924053 */
	0x9b, /* [130]56463420 : [82]55924053 */
	0x9b, /* [131]56897754 : [82]55924053 */
	0x9b, /* [132]57332088 : [82]55924053 */
	0x9b, /* [133]57766422 : [82]55924053 */
	0x9b, /* [134]58200756 : [82]55924053 */
	0xab, /* [135]58635090 : [83]60556953 */
	0xab, /* [136]59069424 : [83]60556953 */
	0xab, /* [137]59503758 : [83]60556953 */
	0xab, /* [138]59938092 : [83]60556953 */
	0xab, /* [139]60372426 : [83]60556953 */
	0xab, /* [140]60806760 : [83]60556953 */
	0xab, /* [141]61241094 : [83]60556953 */
	0xab, /* [142]61675428 : [83]60556953 */
	0xca, /* [143]62109762 : [84]63270844 */
	0xca, /* [144]62544096 : [84]63270844 */
	0xca, /* [145]62978430 : [84]63270844 */
	0xca, /* [146]63412764 : [84]63270844 */
	0x1c, /* [147]63847098 : [85]63969894 */
	0x2c, /* [148]64281432 : [86]64259451 */
	0x3c, /* [149]64715766 : [87]64668945 */
	0x4c, /* [150]65150100 : [88]65248058 */
	0x4c, /* [151]65584434 : [88]65248058 */
	0x5c, /* [152]66018768 : [89]66067046 */
	0x5c, /* [153]66453102 : [89]66067046 */
	0xbb, /* [154]66887436 : [90]67108864 */
	0x6c, /* [155]67321770 : [91]67225271 */
	0x6c, /* [156]67756104 : [91]67225271 */
	0x7c, /* [157]68190438 : [92]68863249 */
	0x7c, /* [158]68624772 : [92]68863249 */
	0x7c, /* [159]69059106 : [92]68863249 */
	0x7c, /* [160]69493440 : [92]68863249 */
	0x7c, /* [161]69927774 : [92]68863249 */
	0x8c, /* [162]70362108 : [93]71179699 */
	0x8c, /* [163]70796442 : [93]71179699 */
	0x8c, /* [164]71230776 : [93]71179699 */
	0x8c, /* [165]71665110 : [93]71179699 */
	0x8c, /* [166]72099444 : [93]71179699 */
	0x8c, /* [167]72533778 : [93]71179699 */
	0x9c, /* [168]72968112 : [94]74455654 */
	0x9c, /* [169]73402446 : [94]74455654 */
	0x9c, /* [170]73836780 : [94]74455654 */
	0x9c, /* [171]74271114 : [94]74455654 */
	0x9c, /* [172]74705448 : [94]74455654 */
	0x9c, /* [173]75139782 : [94]74455654 */
	0xcb, /* [174]75574116 : [95]76374664 */
	0xcb, /* [175]76008450 : [95]76374664 */
	0xcb, /* [176]76442784 : [95]76374664 */
	0xcb, /* [177]76877118 : [95]76374664 */
	0xcb, /* [178]77311452 : [95]76374664 */
	0xac, /* [179]77745786 : [96]79088555 */
	0xac, /* [180]78180120 : [96]79088555 */
	0xac, /* [181]78614454 : [96]79088555 */
	0xac, /* [182]79048788 : [96]79088555 */
	0xac, /* [183]79483122 : [96]79088555 */
	0xac, /* [184]79917456 : [96]79088555 */
	0xac, /* [185]80351790 : [96]79088555 */
	0xac, /* [186]80786124 : [96]79088555 */
	0xac, /* [187]81220458 : [96]79088555 */
	0xac, /* [188]81654792 : [96]79088555 */
	0xac, /* [189]82089126 : [96]79088555 */
	0xbc, /* [190]82523460 : [97]85640465 */
	0xbc, /* [191]82957794 : [97]85640465 */
	0xbc, /* [192]83392128 : [97]85640465 */
	0xbc, /* [193]83826462 : [97]85640465 */
	0xbc, /* [194]84260796 : [97]85640465 */
	0xbc, /* [195]84695130 : [97]85640465 */
	0xbc, /* [196]85129464 : [97]85640465 */
	0xbc, /* [197]85563798 : [97]85640465 */
	0xbc, /* [198]85998132 : [97]85640465 */
	0xbc, /* [199]86432466 : [97]85640465 */
	0xbc, /* [200]86866800 : [97]85640465 */
	0xbc, /* [201]87301134 : [97]85640465 */
	0xdb, /* [202]87735468 : [98]89478485 */
	0xdb, /* [203]88169802 : [98]89478485 */
	0xdb, /* [204]88604136 : [98]89478485 */
	0xdb, /* [205]89038470 : [98]89478485 */
	0xdb, /* [206]89472804 : [98]89478485 */
	0x1d, /* [207]89907138 : [99]90177536 */
	0x2d, /* [208]90341472 : [100]90467092 */
	0x3d, /* [209]90775806 : [101]90876586 */
	0x4d, /* [210]91210140 : [102]91455699 */
	0x4d, /* [211]91644474 : [102]91455699 */
	0x5d, /* [212]92078808 : [103]92274688 */
	0x5d, /* [213]92513142 : [103]92274688 */
	0x6d, /* [214]92947476 : [104]93432913 */
	0x6d, /* [215]93381810 : [104]93432913 */
	0x6d, /* [216]93816144 : [104]93432913 */
	0xcc, /* [217]94250478 : [105]94906266 */
	0xcc, /* [218]94684812 : [105]94906266 */
	0x7d, /* [219]95119146 : [106]95070890 */
	0x7d, /* [220]95553480 : [106]95070890 */
	0x7d, /* [221]95987814 : [106]95070890 */
	0x8d, /* [222]96422148 : [107]97387340 */
	0x8d, /* [223]96856482 : [107]97387340 */
	0x8d, /* [224]97290816 : [107]97387340 */
	0x8d, /* [225]97725150 : [107]97387340 */
	0x8d, /* [226]98159484 : [107]97387340 */
	0x8d, /* [227]98593818 : [107]97387340 */
	0x9d, /* [228]99028152 : [108]100663296 */
	0x9d, /* [229]99462486 : [108]100663296 */
	0x9d, /* [230]99896820 : [108]100663296 */
	0x9d, /* [231]100331154 : [108]100663296 */
	0x9d, /* [232]100765488 : [108]100663296 */
	0x9d, /* [233]101199822 : [108]100663296 */
	0x9d, /* [234]101634156 : [108]100663296 */
	0x9d, /* [235]102068490 : [108]100663296 */
	0x9d, /* [236]102502824 : [108]100663296 */
	0x9d, /* [237]102937158 : [108]100663296 */
	0xad, /* [238]103371492 : [109]105296196 */
	0xad, /* [239]103805826 : [109]105296196 */
	0xad, /* [240]104240160 : [109]105296196 */
	0xad, /* [241]104674494 : [109]105296196 */
	0xad, /* [242]105108828 : [109]105296196 */
	0xad, /* [243]105543162 : [109]105296196 */
	0xad, /* [244]105977496 : [109]105296196 */
	0xad, /* [245]106411830 : [109]105296196 */
	0xdc, /* [246]106846164 : [110]108010086 */
	0xdc, /* [247]107280498 : [110]108010086 */
	0xdc, /* [248]107714832 : [110]108010086 */
	0xdc, /* [249]108149166 : [110]108010086 */
	0xdc, /* [250]108583500 : [110]108010086 */
	0xdc, /* [251]109017834 : [110]108010086 */
	0xdc, /* [252]109452168 : [110]108010086 */
	0xdc, /* [253]109886502 : [110]108010086 */
	0xbd, /* [254]110320836 : [111]111848106 */
	0xbd, /* [255]110755170 : [111]111848106 */
};
/*
 * All PT_count=256
 * Limited (2097152,134217728) PT_count=169
 * Unique PT_count=91
 * min=0 step=434334
 * Used 84
 */
const uint8_t PAM2B_TABLE[] = {
	        /* u  v : out v */
	0x11, /* [0]0 : [0]2097152 */
	0x11, /* [1]434334 : [0]2097152 */
	0x11, /* [2]868668 : [0]2097152 */
	0x11, /* [3]1303002 : [0]2097152 */
	0x11, /* [4]1737336 : [0]2097152 */
	0x11, /* [5]2171670 : [0]2097152 */
	0x12, /* [6]2606004 : [1]2531486 */
	0x22, /* [7]3040338 : [2]2965821 */
	0x32, /* [8]3474672 : [4]3580062 */
	0x14, /* [9]3909006 : [5]4014397 */
	0x42, /* [10]4343340 : [7]4448731 */
	0x34, /* [11]4777674 : [8]5062973 */
	0x15, /* [12]5212008 : [9]5242880 */
	0x25, /* [13]5646342 : [10]5677214 */
	0x44, /* [14]6080676 : [11]5931642 */
	0x35, /* [15]6515010 : [12]6291456 */
	0x61, /* [16]6949344 : [13]6980217 */
	0x26, /* [17]7383678 : [15]7414552 */
	0x63, /* [18]7818012 : [16]8028793 */
	0x55, /* [19]8252346 : [17]8388608 */
	0x64, /* [20]8686680 : [18]8897462 */
	0x64, /* [21]9121014 : [18]8897462 */
	0x17, /* [22]9555348 : [19]9437184 */
	0x27, /* [23]9989682 : [20]9871518 */
	0x37, /* [24]10424016 : [22]10485760 */
	0x37, /* [25]10858350 : [22]10485760 */
	0x47, /* [26]11292684 : [23]11354429 */
	0x66, /* [27]11727018 : [24]11863283 */
	0x66, /* [28]12161352 : [24]11863283 */
	0x75, /* [29]12595686 : [25]12582912 */
	0x18, /* [30]13030020 : [26]12911859 */
	0x82, /* [31]13464354 : [27]13346193 */
	0x83, /* [32]13898688 : [28]13960435 */
	0x67, /* [33]14333022 : [29]14320249 */
	0x48, /* [34]14767356 : [30]14829104 */
	0x48, /* [35]15201690 : [30]14829104 */
	0x58, /* [36]15636024 : [31]16057587 */
	0x58, /* [37]16070358 : [31]16057587 */
	0x77, /* [38]16504692 : [32]16777216 */
	0x77, /* [39]16939026 : [32]16777216 */
	0x68, /* [40]17373360 : [33]17794924 */
	0x68, /* [41]17807694 : [33]17794924 */
	0x29, /* [42]18242028 : [35]18260126 */
	0x93, /* [43]18676362 : [36]18874368 */
	0x93, /* [44]19110696 : [36]18874368 */
	0x49, /* [45]19545030 : [37]19743037 */
	0x49, /* [46]19979364 : [37]19743037 */
	0x87, /* [47]20413698 : [38]20251891 */
	0x59, /* [48]20848032 : [39]20971520 */
	0x59, /* [49]21282366 : [39]20971520 */
	0x59, /* [50]21716700 : [39]20971520 */
	0x69, /* [51]22151034 : [40]22708857 */
	0x69, /* [52]22585368 : [40]22708857 */
	0x69, /* [53]23019702 : [40]22708857 */
	0x88, /* [54]23454036 : [41]23726566 */
	0x88, /* [55]23888370 : [41]23726566 */
	0x1a, /* [56]24322704 : [42]24775142 */
	0x1a, /* [57]24757038 : [42]24775142 */
	0x2a, /* [58]25191372 : [44]25209477 */
	0xa3, /* [59]25625706 : [45]25823718 */
	0xa3, /* [60]26060040 : [45]25823718 */
	0x4a, /* [61]26494374 : [46]26692387 */
	0x4a, /* [62]26928708 : [46]26692387 */
	0x5a, /* [63]27363042 : [47]27920870 */
	0x5a, /* [64]27797376 : [47]27920870 */
	0x5a, /* [65]28231710 : [47]27920870 */
	0x98, /* [66]28666044 : [48]28640499 */
	0x98, /* [67]29100378 : [48]28640499 */
	0x6a, /* [68]29534712 : [49]29658208 */
	0x6a, /* [69]29969046 : [49]29658208 */
	0x6a, /* [70]30403380 : [49]29658208 */
	0x6a, /* [71]30837714 : [49]29658208 */
	0x7a, /* [72]31272048 : [50]32115174 */
	0x7a, /* [73]31706382 : [50]32115174 */
	0x7a, /* [74]32140716 : [50]32115174 */
	0x7a, /* [75]32575050 : [50]32115174 */
	0x99, /* [76]33009384 : [51]33554432 */
	0x99, /* [77]33443718 : [51]33554432 */
	0x99, /* [78]33878052 : [51]33554432 */
	0x1b, /* [79]34312386 : [52]34603008 */
	0x1b, /* [80]34746720 : [52]34603008 */
	0xb2, /* [81]35181054 : [53]35037342 */
	0x8a, /* [82]35615388 : [54]35589849 */
	0xb3, /* [83]36049722 : [55]35651584 */
	0xb4, /* [84]36484056 : [56]36520253 */
	0xb4, /* [85]36918390 : [56]36520253 */
	0x5b, /* [86]37352724 : [57]37748736 */
	0x5b, /* [87]37787058 : [57]37748736 */
	0x5b, /* [88]38221392 : [57]37748736 */
	0xb6, /* [89]38655726 : [58]39486073 */
	0xb6, /* [90]39090060 : [58]39486073 */
	0xb6, /* [91]39524394 : [58]39486073 */
	0xb6, /* [92]39958728 : [58]39486073 */
	0xa9, /* [93]40393062 : [59]40503782 */
	0xa9, /* [94]40827396 : [59]40503782 */
	0xb7, /* [95]41261730 : [60]41943040 */
	0xb7, /* [96]41696064 : [60]41943040 */
	0xb7, /* [97]42130398 : [60]41943040 */
	0xb7, /* [98]42564732 : [60]41943040 */
	0xb7, /* [99]42999066 : [60]41943040 */
	0xb7, /* [100]43433400 : [60]41943040 */
	0xb8, /* [101]43867734 : [61]45417715 */
	0xb8, /* [102]44302068 : [61]45417715 */
	0xb8, /* [103]44736402 : [61]45417715 */
	0xb8, /* [104]45170736 : [61]45417715 */
	0xb8, /* [105]45605070 : [61]45417715 */
	0xb8, /* [106]46039404 : [61]45417715 */
	0xaa, /* [107]46473738 : [62]47453133 */
	0xaa, /* [108]46908072 : [62]47453133 */
	0xaa, /* [109]47342406 : [62]47453133 */
	0xaa, /* [110]47776740 : [62]47453133 */
	0x1c, /* [111]48211074 : [63]48501709 */
	0x1c, /* [112]48645408 : [63]48501709 */
	0x2c, /* [113]49079742 : [64]48936043 */
	0x3c, /* [114]49514076 : [65]49550285 */
	0xb9, /* [115]49948410 : [66]50331648 */
	0xc4, /* [116]50382744 : [67]50418954 */
	0xc4, /* [117]50817078 : [67]50418954 */
	0xc5, /* [118]51251412 : [68]51647437 */
	0xc5, /* [119]51685746 : [68]51647437 */
	0xc5, /* [120]52120080 : [68]51647437 */
	0x6c, /* [121]52554414 : [69]53384774 */
	0x6c, /* [122]52988748 : [69]53384774 */
	0x6c, /* [123]53423082 : [69]53384774 */
	0x6c, /* [124]53857416 : [69]53384774 */
	0x6c, /* [125]54291750 : [69]53384774 */
	0xc7, /* [126]54726084 : [70]55841741 */
	0xc7, /* [127]55160418 : [70]55841741 */
	0xc7, /* [128]55594752 : [70]55841741 */
	0xc7, /* [129]56029086 : [70]55841741 */
	0xc7, /* [130]56463420 : [70]55841741 */
	0xab, /* [131]56897754 : [71]57280998 */
	0xab, /* [132]57332088 : [71]57280998 */
	0xab, /* [133]57766422 : [71]57280998 */
	0xab, /* [134]58200756 : [71]57280998 */
	0xc8, /* [135]58635090 : [72]59316416 */
	0xc8, /* [136]59069424 : [72]59316416 */
	0xc8, /* [137]59503758 : [72]59316416 */
	0xc8, /* [138]59938092 : [72]59316416 */
	0xc8, /* [139]60372426 : [72]59316416 */
	0xc8, /* [140]60806760 : [72]59316416 */
	0xc8, /* [141]61241094 : [72]59316416 */
	0xc8, /* [142]61675428 : [72]59316416 */
	0xc9, /* [143]62109762 : [73]64230349 */
	0xc9, /* [144]62544096 : [73]64230349 */
	0xc9, /* [145]62978430 : [73]64230349 */
	0xc9, /* [146]63412764 : [73]64230349 */
	0xc9, /* [147]63847098 : [73]64230349 */
	0xc9, /* [148]64281432 : [73]64230349 */
	0xc9, /* [149]64715766 : [73]64230349 */
	0xc9, /* [150]65150100 : [73]64230349 */
	0xc9, /* [151]65584434 : [73]64230349 */
	0xbb, /* [152]66018768 : [74]67108864 */
	0xbb, /* [153]66453102 : [74]67108864 */
	0xbb, /* [154]66887436 : [74]67108864 */
	0xbb, /* [155]67321770 : [74]67108864 */
	0x1d, /* [156]67756104 : [75]68157440 */
	0x1d, /* [157]68190438 : [75]68157440 */
	0x2d, /* [158]68624772 : [76]68591774 */
	0xd3, /* [159]69059106 : [77]69206016 */
	0xd3, /* [160]69493440 : [77]69206016 */
	0x4d, /* [161]69927774 : [78]70074685 */
	0x4d, /* [162]70362108 : [78]70074685 */
	0xac, /* [163]70796442 : [79]71179699 */
	0xac, /* [164]71230776 : [79]71179699 */
	0xd5, /* [165]71665110 : [80]71303168 */
	0xd5, /* [166]72099444 : [80]71303168 */
	0x6d, /* [167]72533778 : [81]73040505 */
	0x6d, /* [168]72968112 : [81]73040505 */
	0x6d, /* [169]73402446 : [81]73040505 */
	0x6d, /* [170]73836780 : [81]73040505 */
	0x7d, /* [171]74271114 : [82]75497472 */
	0x7d, /* [172]74705448 : [82]75497472 */
	0x7d, /* [173]75139782 : [82]75497472 */
	0x7d, /* [174]75574116 : [82]75497472 */
	0x7d, /* [175]76008450 : [82]75497472 */
	0x7d, /* [176]76442784 : [82]75497472 */
	0x7d, /* [177]76877118 : [82]75497472 */
	0xd8, /* [178]77311452 : [83]78972147 */
	0xd8, /* [179]77745786 : [83]78972147 */
	0xd8, /* [180]78180120 : [83]78972147 */
	0xd8, /* [181]78614454 : [83]78972147 */
	0xd8, /* [182]79048788 : [83]78972147 */
	0xd8, /* [183]79483122 : [83]78972147 */
	0xd8, /* [184]79917456 : [83]78972147 */
	0xcb, /* [185]80351790 : [84]81007565 */
	0xcb, /* [186]80786124 : [84]81007565 */
	0xcb, /* [187]81220458 : [84]81007565 */
	0xcb, /* [188]81654792 : [84]81007565 */
	0xcb, /* [189]82089126 : [84]81007565 */
	0x9d, /* [190]82523460 : [85]83886080 */
	0x9d, /* [191]82957794 : [85]83886080 */
	0x9d, /* [192]83392128 : [85]83886080 */
	0x9d, /* [193]83826462 : [85]83886080 */
	0x9d, /* [194]84260796 : [85]83886080 */
	0x9d, /* [195]84695130 : [85]83886080 */
	0x9d, /* [196]85129464 : [85]83886080 */
	0x9d, /* [197]85563798 : [85]83886080 */
	0x9d, /* [198]85998132 : [85]83886080 */
	0x9d, /* [199]86432466 : [85]83886080 */
	0x9d, /* [200]86866800 : [85]83886080 */
	0x9d, /* [201]87301134 : [85]83886080 */
	0xad, /* [202]87735468 : [86]90835430 */
	0xad, /* [203]88169802 : [86]90835430 */
	0xad, /* [204]88604136 : [86]90835430 */
	0xad, /* [205]89038470 : [86]90835430 */
	0xad, /* [206]89472804 : [86]90835430 */
	0xad, /* [207]89907138 : [86]90835430 */
	0xad, /* [208]90341472 : [86]90835430 */
	0xad, /* [209]90775806 : [86]90835430 */
	0xad, /* [210]91210140 : [86]90835430 */
	0xad, /* [211]91644474 : [86]90835430 */
	0xad, /* [212]92078808 : [86]90835430 */
	0xad, /* [213]92513142 : [86]90835430 */
	0xcc, /* [214]92947476 : [87]94906266 */
	0xcc, /* [215]93381810 : [87]94906266 */
	0xcc, /* [216]93816144 : [87]94906266 */
	0xcc, /* [217]94250478 : [87]94906266 */
	0xcc, /* [218]94684812 : [87]94906266 */
	0xcc, /* [219]95119146 : [87]94906266 */
	0xcc, /* [220]95553480 : [87]94906266 */
	0xcc, /* [221]95987814 : [87]94906266 */
	0xcc, /* [222]96422148 : [87]94906266 */
	0xcc, /* [223]96856482 : [87]94906266 */
	0xcc, /* [224]97290816 : [87]94906266 */
	0xcc, /* [225]97725150 : [87]94906266 */
	0xbd, /* [226]98159484 : [88]100663296 */
	0xbd, /* [227]98593818 : [88]100663296 */
	0xbd, /* [228]99028152 : [88]100663296 */
	0xbd, /* [229]99462486 : [88]100663296 */
	0xbd, /* [230]99896820 : [88]100663296 */
	0xbd, /* [231]100331154 : [88]100663296 */
	0xbd, /* [232]100765488 : [88]100663296 */
	0xbd, /* [233]101199822 : [88]100663296 */
	0xbd, /* [234]101634156 : [88]100663296 */
	0xbd, /* [235]102068490 : [88]100663296 */
	0xbd, /* [236]102502824 : [88]100663296 */
	0xbd, /* [237]102937158 : [88]100663296 */
	0xbd, /* [238]103371492 : [88]100663296 */
	0xbd, /* [239]103805826 : [88]100663296 */
	0xbd, /* [240]104240160 : [88]100663296 */
	0xbd, /* [241]104674494 : [88]100663296 */
	0xbd, /* [242]105108828 : [88]100663296 */
	0xbd, /* [243]105543162 : [88]100663296 */
	0xbd, /* [244]105977496 : [88]100663296 */
	0xbd, /* [245]106411830 : [88]100663296 */
	0xbd, /* [246]106846164 : [88]100663296 */
	0xbd, /* [247]107280498 : [88]100663296 */
	0xcd, /* [248]107714832 : [89]114561997 */
	0xcd, /* [249]108149166 : [89]114561997 */
	0xcd, /* [250]108583500 : [89]114561997 */
	0xcd, /* [251]109017834 : [89]114561997 */
	0xcd, /* [252]109452168 : [89]114561997 */
	0xcd, /* [253]109886502 : [89]114561997 */
	0xcd, /* [254]110320836 : [89]114561997 */
	0xcd, /* [255]110755170 : [89]114561997 */
};
/*
 * All PT_count=4096
 * Limited (2097152,134217728) PT_count=2197
 * Unique PT_count=1351
 * min=0 step=54291
 * Used 1091
 */
const uint16_t PAM3A_TABLE[] = {
	            /* u  v : out v */
	0x1111, /* [0]0 : [0]2097152 */
	0x1111, /* [1]54291 : [0]2097152 */
	0x1111, /* [2]108582 : [0]2097152 */
	0x1111, /* [3]162873 : [0]2097152 */
	0x1111, /* [4]217164 : [0]2097152 */
	0x1111, /* [5]271455 : [0]2097152 */
	0x1111, /* [6]325746 : [0]2097152 */
	0x1111, /* [7]380037 : [0]2097152 */
	0x1111, /* [8]434328 : [0]2097152 */
	0x1111, /* [9]488619 : [0]2097152 */
	0x1111, /* [10]542910 : [0]2097152 */
	0x1111, /* [11]597201 : [0]2097152 */
	0x1111, /* [12]651492 : [0]2097152 */
	0x1111, /* [13]705783 : [0]2097152 */
	0x1111, /* [14]760074 : [0]2097152 */
	0x1111, /* [15]814365 : [0]2097152 */
	0x1111, /* [16]868656 : [0]2097152 */
	0x1111, /* [17]922947 : [0]2097152 */
	0x1111, /* [18]977238 : [0]2097152 */
	0x1111, /* [19]1031529 : [0]2097152 */
	0x1111, /* [20]1085820 : [0]2097152 */
	0x1111, /* [21]1140111 : [0]2097152 */
	0x1111, /* [22]1194402 : [0]2097152 */
	0x1111, /* [23]1248693 : [0]2097152 */
	0x1111, /* [24]1302984 : [0]2097152 */
	0x1111, /* [25]1357275 : [0]2097152 */
	0x1111, /* [26]1411566 : [0]2097152 */
	0x1111, /* [27]1465857 : [0]2097152 */
	0x1111, /* [28]1520148 : [0]2097152 */
	0x1111, /* [29]1574439 : [0]2097152 */
	0x1111, /* [30]1628730 : [0]2097152 */
	0x1111, /* [31]1683021 : [0]2097152 */
	0x1111, /* [32]1737312 : [0]2097152 */
	0x1111, /* [33]1791603 : [0]2097152 */
	0x1111, /* [34]1845894 : [0]2097152 */
	0x1111, /* [35]1900185 : [0]2097152 */
	0x1111, /* [36]1954476 : [0]2097152 */
	0x1111, /* [37]2008767 : [0]2097152 */
	0x1111, /* [38]2063058 : [0]2097152 */
	0x1111, /* [39]2117349 : [0]2097152 */
	0x1111, /* [40]2171640 : [0]2097152 */
	0x2111, /* [41]2225931 : [1]2301544 */
	0x2111, /* [42]2280222 : [1]2301544 */
	0x1211, /* [43]2334513 : [2]2352642 */
	0x1211, /* [44]2388804 : [2]2352642 */
	0x1122, /* [45]2443095 : [3]2505937 */
	0x1122, /* [46]2497386 : [3]2505937 */
	0x2211, /* [47]2551677 : [4]2557035 */
	0x3111, /* [48]2605968 : [5]2590599 */
	0x2122, /* [49]2660259 : [6]2710330 */
	0x1311, /* [50]2714550 : [7]2713961 */
	0x1222, /* [51]2768841 : [8]2761428 */
	0x3211, /* [52]2823132 : [9]2846090 */
	0x3211, /* [53]2877423 : [9]2846090 */
	0x2311, /* [54]2931714 : [10]2918354 */
	0x3122, /* [55]2986005 : [12]2999384 */
	0x3122, /* [56]3040296 : [12]2999384 */
	0x1133, /* [57]3094587 : [13]3084047 */
	0x1322, /* [58]3148878 : [14]3122746 */
	0x3311, /* [59]3203169 : [15]3207408 */
	0x3222, /* [60]3257460 : [17]3254875 */
	0x2322, /* [61]3311751 : [19]3327139 */
	0x1233, /* [62]3366042 : [20]3339537 */
	0x2411, /* [63]3420333 : [22]3429335 */
	0x2411, /* [64]3474624 : [22]3429335 */
	0x2233, /* [65]3528915 : [23]3543930 */
	0x3133, /* [66]3583206 : [24]3577494 */
	0x1422, /* [67]3637497 : [26]3633728 */
	0x1333, /* [68]3691788 : [28]3700856 */
	0x3411, /* [69]3746079 : [29]3718390 */
	0x3233, /* [70]3800370 : [30]3832985 */
	0x2422, /* [71]3854661 : [31]3838121 */
	0x2333, /* [72]3908952 : [33]3905249 */
	0x1511, /* [73]3963243 : [34]3947580 */
	0x4322, /* [74]4017534 : [36]4024979 */
	0x2144, /* [75]4071825 : [37]4106010 */
	0x3422, /* [76]4126116 : [38]4127176 */
	0x3333, /* [77]4180407 : [41]4194304 */
	0x4233, /* [78]4234698 : [43]4241770 */
	0x4233, /* [79]4288989 : [43]4241770 */
	0x1522, /* [80]4343280 : [44]4356365 */
	0x3144, /* [81]4397571 : [46]4395065 */
	0x3511, /* [82]4451862 : [48]4441027 */
	0x1344, /* [83]4506153 : [49]4518427 */
	0x2522, /* [84]4560444 : [51]4560758 */
	0x4333, /* [85]4614735 : [53]4603089 */
	0x3244, /* [86]4669026 : [54]4650556 */
	0x2344, /* [87]4723317 : [56]4722820 */
	0x4144, /* [88]4777608 : [57]4803850 */
	0x5233, /* [89]4831899 : [58]4819880 */
	0x3522, /* [90]4886190 : [59]4849813 */
	0x1533, /* [91]4940481 : [60]4934475 */
	0x3344, /* [92]4994772 : [62]5011874 */
	0x1155, /* [93]5049063 : [64]5057837 */
	0x4433, /* [94]5103354 : [66]5114071 */
	0x2611, /* [95]5157645 : [68]5173936 */
	0x2444, /* [96]5211936 : [70]5233801 */
	0x2155, /* [97]5266227 : [72]5262229 */
	0x1255, /* [98]5320518 : [73]5313328 */
	0x1622, /* [99]5374809 : [74]5378328 */
	0x3533, /* [100]5429100 : [77]5427922 */
	0x3611, /* [101]5483391 : [78]5462991 */
	0x3155, /* [102]5537682 : [81]5551284 */
	0x2622, /* [103]5591973 : [82]5582721 */
	0x5244, /* [104]5646264 : [83]5637451 */
	0x5433, /* [105]5700555 : [85]5692180 */
	0x1544, /* [106]5754846 : [86]5752046 */
	0x3255, /* [107]5809137 : [87]5806775 */
	0x3622, /* [108]5863428 : [89]5871776 */
	0x4444, /* [109]5917719 : [91]5931642 */
	0x4155, /* [110]5972010 : [93]5960070 */
	0x5344, /* [111]6026301 : [94]5998769 */
	0x2633, /* [112]6080592 : [95]6160831 */
	0x2633, /* [113]6134883 : [95]6160831 */
	0x1455, /* [114]6189174 : [97]6185628 */
	0x3544, /* [115]6243465 : [100]6245493 */
	0x4622, /* [116]6297756 : [101]6280561 */
	0x2455, /* [117]6352047 : [102]6390021 */
	0x5533, /* [118]6406338 : [103]6414817 */
	0x6244, /* [119]6460629 : [105]6455021 */
	0x5444, /* [120]6514920 : [106]6509751 */
	0x4355, /* [121]6569211 : [108]6576879 */
	0x2711, /* [122]6623502 : [109]6619210 */
	0x3455, /* [123]6677793 : [111]6679075 */
	0x1166, /* [124]6732084 : [112]6692978 */
	0x5255, /* [125]6786375 : [114]6793670 */
	0x1722, /* [126]6840666 : [116]6823603 */
	0x2166, /* [127]6894957 : [118]6897371 */
	0x1266, /* [128]6949248 : [120]6948469 */
	0x2722, /* [129]7003539 : [122]7027996 */
	0x2722, /* [130]7057830 : [122]7027996 */
	0x2555, /* [131]7112121 : [124]7112658 */
	0x5355, /* [132]7166412 : [126]7154989 */
	0x5544, /* [133]7220703 : [128]7232388 */
	0x3644, /* [134]7274994 : [129]7267456 */
	0x6444, /* [135]7329285 : [132]7327322 */
	0x3555, /* [136]7383576 : [134]7401712 */
	0x5633, /* [137]7437867 : [135]7436781 */
	0x2366, /* [138]7492158 : [137]7514180 */
	0x2366, /* [139]7546449 : [137]7514180 */
	0x2733, /* [140]7600740 : [139]7606105 */
	0x5455, /* [141]7655031 : [141]7665970 */
	0x4722, /* [142]7709322 : [143]7725836 */
	0x4722, /* [143]7763613 : [143]7725836 */
	0x1466, /* [144]7817904 : [146]7820769 */
	0x4266, /* [145]7872195 : [147]7850702 */
	0x1655, /* [146]7926486 : [149]7930228 */
	0x6355, /* [147]7980777 : [150]7972559 */
	0x2466, /* [148]8035068 : [151]8025162 */
	0x6544, /* [149]8089359 : [152]8049959 */
	0x2655, /* [150]8143650 : [153]8134621 */
	0x4366, /* [151]8197941 : [155]8212020 */
	0x5644, /* [152]8252232 : [157]8254351 */
	0x4733, /* [153]8306523 : [158]8303945 */
	0x5555, /* [154]8360814 : [160]8388608 */
	0x3655, /* [155]8415105 : [161]8423676 */
	0x1811, /* [156]8469396 : [163]8458744 */
	0x7155, /* [157]8523687 : [165]8511969 */
	0x1566, /* [158]8577978 : [166]8543406 */
	0x2811, /* [159]8632269 : [167]8663137 */
	0x2811, /* [160]8686560 : [167]8663137 */
	0x2566, /* [161]8740851 : [170]8747799 */
	0x5366, /* [162]8795142 : [172]8790130 */
	0x4655, /* [163]8849433 : [173]8832461 */
	0x5733, /* [164]8903724 : [175]8882055 */
	0x3811, /* [165]8958015 : [176]8952191 */
	0x1177, /* [166]9012306 : [178]9005417 */
	0x6644, /* [167]9066597 : [180]9071922 */
	0x4744, /* [168]9120888 : [181]9121516 */
	0x6555, /* [169]9175179 : [183]9206178 */
	0x6266, /* [170]9229470 : [185]9246382 */
	0x5466, /* [171]9283761 : [187]9301112 */
	0x3822, /* [172]9338052 : [188]9360977 */
	0x1755, /* [173]9392343 : [189]9375503 */
	0x4566, /* [174]9446634 : [191]9445639 */
	0x3177, /* [175]9500925 : [193]9498864 */
	0x1666, /* [176]9555216 : [194]9565369 */
	0x6366, /* [177]9609507 : [196]9607700 */
	0x2833, /* [178]9663798 : [199]9650032 */
	0x5744, /* [179]9718089 : [200]9699626 */
	0x2666, /* [180]9772380 : [202]9769762 */
	0x2377, /* [181]9826671 : [203]9826619 */
	0x3755, /* [182]9880962 : [204]9868950 */
	0x3833, /* [183]9935253 : [206]9939086 */
	0x5566, /* [184]9989544 : [207]10023749 */
	0x3666, /* [185]10043835 : [208]10058817 */
	0x3377, /* [186]10098126 : [209]10115674 */
	0x7166, /* [187]10152417 : [212]10147111 */
	0x6655, /* [188]10206708 : [214]10228141 */
	0x1844, /* [189]10260999 : [215]10263210 */
	0x2477, /* [190]10315290 : [217]10337601 */
	0x7555, /* [191]10369581 : [219]10362398 */
	0x7266, /* [192]10423872 : [220]10402601 */
	0x5177, /* [193]10478163 : [222]10485760 */
	0x4377, /* [194]10532454 : [224]10524459 */
	0x3477, /* [195]10586745 : [225]10626656 */
	0x3477, /* [196]10641036 : [225]10626656 */
	0x5277, /* [197]10695327 : [226]10741250 */
	0x3844, /* [198]10749618 : [227]10756657 */
	0x6566, /* [199]10803909 : [229]10841319 */
	0x5755, /* [200]10858200 : [230]10855845 */
	0x5833, /* [201]10912491 : [231]10925982 */
	0x5833, /* [202]10966782 : [231]10925982 */
	0x1766, /* [203]11021073 : [232]11010644 */
	0x2577, /* [204]11075364 : [235]11060238 */
	0x5377, /* [205]11129655 : [236]11102569 */
	0x4844, /* [206]11183946 : [237]11165443 */
	0x2766, /* [207]11238237 : [238]11215036 */
	0x6177, /* [208]11292528 : [240]11303330 */
	0x3577, /* [209]11346819 : [241]11349293 */
	0x7655, /* [210]11401110 : [242]11384361 */
	0x1855, /* [211]11455401 : [243]11419429 */
	0x3766, /* [212]11509692 : [244]11504091 */
	0x6277, /* [213]11563983 : [246]11558821 */
	0x5477, /* [214]11618274 : [247]11613551 */
	0x6755, /* [215]11672565 : [249]11673416 */
	0x5844, /* [216]11726856 : [250]11743552 */
	0x8166, /* [217]11781147 : [252]11782252 */
	0x3911, /* [218]11835438 : [253]11842740 */
	0x1677, /* [219]11889729 : [255]11877808 */
	0x2922, /* [220]11944020 : [258]11962471 */
	0x7566, /* [221]11998311 : [259]11997539 */
	0x8266, /* [222]12052602 : [260]12037743 */
	0x2677, /* [223]12106893 : [261]12082201 */
	0x2677, /* [224]12161184 : [261]12082201 */
	0x3922, /* [225]12215475 : [262]12251526 */
	0x1188, /* [226]12269766 : [263]12275699 */
	0x4855, /* [227]12324057 : [264]12321662 */
	0x3677, /* [228]12378348 : [266]12371256 */
	0x6477, /* [229]12432639 : [268]12431121 */
	0x5766, /* [230]12486930 : [271]12490986 */
	0x2933, /* [231]12541221 : [273]12540580 */
	0x6844, /* [232]12595512 : [274]12561123 */
	0x4922, /* [233]12649803 : [275]12660311 */
	0x7277, /* [234]12704094 : [276]12715041 */
	0x3188, /* [235]12758385 : [278]12769147 */
	0x7755, /* [236]12812676 : [280]12829635 */
	0x1388, /* [237]12866967 : [281]12892509 */
	0x8466, /* [238]12921258 : [283]12910043 */
	0x7666, /* [239]12975549 : [284]13019502 */
	0x3288, /* [240]13029840 : [285]13024638 */
	0x7377, /* [241]13084131 : [287]13076359 */
	0x6577, /* [242]13138422 : [289]13153758 */
	0x4188, /* [243]13192713 : [290]13177932 */
	0x4933, /* [244]13247004 : [291]13238421 */
	0x6766, /* [245]13301295 : [293]13308557 */
	0x5677, /* [246]13355586 : [295]13358151 */
	0x1488, /* [247]13409877 : [297]13403490 */
	0x4288, /* [248]13464168 : [298]13433423 */
	0x2777, /* [249]13518459 : [299]13527476 */
	0x7477, /* [250]13572750 : [301]13587341 */
	0x8566, /* [251]13627041 : [303]13632680 */
	0x3944, /* [252]13681332 : [304]13647206 */
	0x6855, /* [253]13735623 : [305]13717342 */
	0x4388, /* [254]13789914 : [307]13794742 */
	0x3777, /* [255]13844205 : [308]13816530 */
	0x3488, /* [256]13898496 : [309]13896938 */
	0x4866, /* [257]13952787 : [310]13956803 */
	0x5288, /* [258]14007078 : [311]14011533 */
	0x4944, /* [259]14061369 : [312]14055992 */
	0x1588, /* [260]14115660 : [314]14126128 */
	0x6677, /* [261]14169951 : [315]14175722 */
	0x4777, /* [262]14224242 : [316]14225316 */
	0x4488, /* [263]14278533 : [317]14305723 */
	0x2588, /* [264]14332824 : [319]14330520 */
	0x5388, /* [265]14387115 : [321]14372851 */
	0x7766, /* [266]14441406 : [322]14464776 */
	0x2955, /* [267]14495697 : [323]14514371 */
	0x5866, /* [268]14549988 : [324]14534913 */
	0x3588, /* [269]14604279 : [326]14619575 */
	0x8666, /* [270]14658570 : [328]14654643 */
	0x8377, /* [271]14712861 : [329]14711500 */
	0x5777, /* [272]14767152 : [330]14803425 */
	0x6288, /* [273]14821443 : [331]14829103 */
	0x7855, /* [274]14875734 : [332]14873562 */
	0x5488, /* [275]14930025 : [333]14883833 */
	0x4588, /* [276]14984316 : [334]15028360 */
	0x4588, /* [277]15038607 : [334]15028360 */
	0x1688, /* [278]15092898 : [335]15148091 */
	0x1688, /* [279]15147189 : [335]15148091 */
	0x4955, /* [280]15201480 : [337]15212211 */
	0x8477, /* [281]15255771 : [338]15222482 */
	0x7677, /* [282]15310062 : [339]15331941 */
	0x1877, /* [283]15364353 : [341]15367009 */
	0x1a11, /* [284]15418644 : [342]15437146 */
	0x6944, /* [285]15472935 : [343]15451672 */
	0x2877, /* [286]15527226 : [344]15571402 */
	0x2877, /* [287]15581517 : [344]15571402 */
	0x3688, /* [288]15635808 : [347]15641538 */
	0x6488, /* [289]15690099 : [348]15701404 */
	0x7188, /* [290]15744390 : [349]15729832 */
	0x5955, /* [291]15798681 : [350]15790320 */
	0x1a22, /* [292]15852972 : [351]15845931 */
	0x3a11, /* [293]15907263 : [353]15930593 */
	0x8577, /* [294]15961554 : [354]15945119 */
	0x7288, /* [295]16015845 : [355]15985323 */
	0x4688, /* [296]16070136 : [356]16050324 */
	0x8766, /* [297]16124427 : [357]16099918 */
	0x2966, /* [298]16178718 : [358]16149512 */
	0x4877, /* [299]16233009 : [359]16269242 */
	0x4877, /* [300]16287300 : [359]16269242 */
	0x3a22, /* [301]16341591 : [360]16339379 */
	0x9177, /* [302]16395882 : [362]16407130 */
	0x3966, /* [303]16450173 : [364]16438567 */
	0x7866, /* [304]16504464 : [365]16508703 */
	0x1788, /* [305]16558755 : [366]16593365 */
	0x6955, /* [306]16613046 : [367]16607891 */
	0x9277, /* [307]16667337 : [369]16662621 */
	0x4a22, /* [308]16721628 : [370]16748164 */
	0x7777, /* [309]16775919 : [371]16777216 */
	0x5877, /* [310]16830210 : [373]16847352 */
	0x1199, /* [311]16884501 : [375]16900577 */
	0x3a33, /* [312]16938792 : [376]16917489 */
	0x8677, /* [313]16993083 : [377]16967082 */
	0x9377, /* [314]17047374 : [378]17023939 */
	0x2199, /* [315]17101665 : [380]17104970 */
	0x1299, /* [316]17155956 : [381]17156068 */
	0x1a44, /* [317]17210247 : [382]17241612 */
	0x1a44, /* [318]17264538 : [382]17241612 */
	0x4a33, /* [319]17318829 : [383]17326274 */
	0x8188, /* [320]17373120 : [385]17364973 */
	0x5966, /* [321]17427411 : [387]17425462 */
	0x4788, /* [322]17481702 : [389]17495598 */
	0x9477, /* [323]17535993 : [391]17534921 */
	0x7588, /* [324]17590284 : [392]17580260 */
	0x3299, /* [325]17644575 : [394]17649516 */
	0x2399, /* [326]17698866 : [396]17721780 */
	0x7955, /* [327]17753157 : [398]17764111 */
	0x4199, /* [328]17807448 : [399]17802810 */
	0x5a33, /* [329]17861739 : [400]17904384 */
	0x5a33, /* [330]17916030 : [400]17904384 */
	0x8388, /* [331]17970321 : [401]17981783 */
	0x1499, /* [332]18024612 : [403]18028369 */
	0x5788, /* [333]18078903 : [405]18073708 */
	0x8866, /* [334]18133194 : [406]18143844 */
	0x8866, /* [335]18187485 : [406]18143844 */
	0x6966, /* [336]18241776 : [408]18243032 */
	0x9577, /* [337]18296067 : [409]18257558 */
	0x5199, /* [338]18350358 : [410]18380920 */
	0x1a55, /* [339]18404649 : [411]18397831 */
	0x2977, /* [340]18458940 : [414]18461951 */
	0x3499, /* [341]18513231 : [416]18521816 */
	0x7688, /* [342]18567522 : [417]18602223 */
	0x5299, /* [343]18621813 : [418]18636411 */
	0x1888, /* [344]18676104 : [419]18637292 */
	0x5a44, /* [345]18730395 : [420]18721954 */
	0x3977, /* [346]18784686 : [421]18751006 */
	0x2888, /* [347]18838977 : [423]18841684 */
	0x6788, /* [348]18893268 : [424]18891278 */
	0x2599, /* [349]18947559 : [426]18955398 */
	0x5399, /* [350]19001850 : [427]18997729 */
	0x5399, /* [351]19056141 : [427]18997729 */
	0x3888, /* [352]19110432 : [428]19130739 */
	0x4977, /* [353]19164723 : [429]19159791 */
	0x8588, /* [354]19219014 : [431]19215401 */
	0x9677, /* [355]19273305 : [433]19279521 */
	0x4a55, /* [356]19327596 : [434]19300064 */
	0x7966, /* [357]19381887 : [435]19399252 */
	0x6299, /* [358]19436178 : [436]19453981 */
	0x5499, /* [359]19490469 : [437]19508711 */
	0x4888, /* [360]19544760 : [438]19539525 */
	0x4599, /* [361]19599051 : [439]19653239 */
	0x4599, /* [362]19653342 : [439]19653239 */
	0x9188, /* [363]19707633 : [440]19677412 */
	0x1699, /* [364]19761924 : [442]19772969 */
	0x6399, /* [365]19816215 : [443]19815300 */
	0x5a55, /* [366]19870506 : [444]19878174 */
	0x9288, /* [367]19924797 : [445]19932903 */
	0x2699, /* [368]19979088 : [446]19977362 */
	0x1a66, /* [369]20033379 : [447]20032972 */
	0x5888, /* [370]20087670 : [449]20117634 */
	0x5888, /* [371]20141961 : [449]20117634 */
	0x5599, /* [372]20196252 : [450]20231348 */
	0x8688, /* [373]20250543 : [451]20237365 */
	0x9388, /* [374]20304834 : [453]20294222 */
	0x7199, /* [375]20359125 : [455]20354710 */
	0x8877, /* [376]20413416 : [456]20456283 */
	0x8877, /* [377]20467707 : [456]20456283 */
	0x3a66, /* [378]20521998 : [457]20526420 */
	0x6977, /* [379]20576289 : [458]20555471 */
	0x7299, /* [380]20630580 : [459]20610201 */
	0x4699, /* [381]20684871 : [460]20675202 */
	0x9777, /* [382]20739162 : [462]20724796 */
	0x9488, /* [383]20793453 : [463]20805203 */
	0x9488, /* [384]20847744 : [463]20805203 */
	0x6888, /* [385]20902035 : [464]20935205 */
	0x7399, /* [386]20956326 : [465]20971520 */
	0x8966, /* [387]21010617 : [466]21034393 */
	0x6599, /* [388]21064908 : [467]21048919 */
	0x6599, /* [389]21119199 : [467]21048919 */
	0x1799, /* [390]21173490 : [468]21218243 */
	0x1799, /* [391]21227781 : [468]21218243 */
	0x5699, /* [392]21282072 : [469]21253311 */
	0x5699, /* [393]21336363 : [469]21253311 */
	0x2799, /* [394]21390654 : [470]21422636 */
	0x2799, /* [395]21444945 : [470]21422636 */
	0x5a66, /* [396]21499236 : [472]21513315 */
	0x9588, /* [397]21553527 : [473]21527840 */
	0x1b22, /* [398]21607818 : [474]21627029 */
	0x8788, /* [399]21662109 : [475]21682639 */
	0x7977, /* [400]21716400 : [476]21711691 */
	0x2988, /* [401]21770691 : [477]21732233 */
	0x2b22, /* [402]21824982 : [478]21831421 */
	0x7a55, /* [403]21879273 : [479]21851964 */
	0x8199, /* [404]21933564 : [480]21989851 */
	0x8199, /* [405]21987855 : [480]21989851 */
	0x3988, /* [406]22042146 : [481]22021288 */
	0x7888, /* [407]22096437 : [483]22091424 */
	0x4799, /* [408]22150728 : [484]22120476 */
	0x7599, /* [409]22205019 : [485]22205138 */
	0x8299, /* [410]22259310 : [486]22245342 */
	0x6a66, /* [411]22313601 : [487]22330885 */
	0x1a77, /* [412]22367892 : [488]22345411 */
	0x4988, /* [413]22422183 : [490]22430073 */
	0x4988, /* [414]22476474 : [490]22430073 */
	0x4b22, /* [415]22530765 : [491]22529262 */
	0x8399, /* [416]22585056 : [493]22606661 */
	0x8399, /* [417]22639347 : [493]22606661 */
	0x5799, /* [418]22693638 : [494]22698586 */
	0x9877, /* [419]22747929 : [495]22768722 */
	0x9877, /* [420]22802220 : [495]22768722 */
	0x3a77, /* [421]22856511 : [496]22838859 */
	0xa188, /* [422]22910802 : [497]22947695 */
	0xa188, /* [423]22965093 : [497]22947695 */
	0x1b44, /* [424]23019384 : [499]23022709 */
	0x4b33, /* [425]23073675 : [500]23107371 */
	0x8499, /* [426]23127966 : [501]23117642 */
	0xa288, /* [427]23182257 : [502]23203186 */
	0x7699, /* [428]23236548 : [503]23227102 */
	0x1899, /* [429]23290839 : [505]23262170 */
	0x8977, /* [430]23345130 : [506]23346832 */
	0x11aa, /* [431]23399421 : [507]23441143 */
	0x11aa, /* [432]23453712 : [507]23441143 */
	0x6799, /* [433]23508003 : [510]23516156 */
	0xa388, /* [434]23562294 : [511]23564504 */
	0x21aa, /* [435]23616585 : [512]23645535 */
	0x5b33, /* [436]23670876 : [513]23685481 */
	0x8888, /* [437]23725167 : [515]23726566 */
	0x3899, /* [438]23779458 : [516]23755617 */
	0x8599, /* [439]23833749 : [518]23840280 */
	0x22aa, /* [440]23888040 : [519]23901026 */
	0x31aa, /* [441]23942331 : [521]23934590 */
	0x9788, /* [442]23996622 : [522]23995078 */
	0x13aa, /* [443]24050913 : [523]24057952 */
	0xa488, /* [444]24105204 : [524]24075486 */
	0x4899, /* [445]24159495 : [525]24164403 */
	0x32aa, /* [446]24213786 : [527]24190081 */
	0x23aa, /* [447]24268077 : [528]24262345 */
	0x9199, /* [448]24322368 : [529]24302290 */
	0x2b55, /* [449]24376659 : [531]24383321 */
	0x2b55, /* [450]24430950 : [531]24383321 */
	0x5b44, /* [451]24485241 : [532]24503052 */
	0x33aa, /* [452]24539532 : [533]24551400 */
	0x42aa, /* [453]24593823 : [536]24598866 */
	0x6a77, /* [454]24648114 : [537]24643325 */
	0x7799, /* [455]24702405 : [538]24672376 */
	0x5899, /* [456]24756696 : [539]24742512 */
	0xa588, /* [457]24810987 : [541]24798123 */
	0x8699, /* [458]24865278 : [542]24862243 */
	0x9399, /* [459]24919569 : [543]24919100 */
	0x7988, /* [460]24973860 : [546]24981973 */
	0x34aa, /* [461]25028151 : [547]25062381 */
	0x4b55, /* [462]25082442 : [548]25081161 */
	0x8a66, /* [463]25136733 : [549]25122246 */
	0x52aa, /* [464]25191024 : [550]25176976 */
	0x15aa, /* [465]25245315 : [551]25291571 */
	0x15aa, /* [466]25299606 : [551]25291571 */
	0x6b44, /* [467]25353897 : [552]25320622 */
	0x9499, /* [468]25408188 : [553]25430082 */
	0x44aa, /* [469]25462479 : [554]25471167 */
	0x25aa, /* [470]25516770 : [555]25495964 */
	0x6899, /* [471]25571061 : [557]25560083 */
	0x1a88, /* [472]25625352 : [558]25615694 */
	0x9977, /* [473]25679643 : [559]25659271 */
	0x61aa, /* [474]25733934 : [560]25739056 */
	0x35aa, /* [475]25788225 : [561]25785018 */
	0xa688, /* [476]25842516 : [564]25820086 */
	0xa688, /* [477]25896807 : [564]25820086 */
	0x62aa, /* [478]25951098 : [565]25994547 */
	0x62aa, /* [479]26005389 : [565]25994547 */
	0x54aa, /* [480]26059680 : [568]26049276 */
	0x3a88, /* [481]26113971 : [569]26109141 */
	0x9599, /* [482]26168262 : [570]26152719 */
	0x45aa, /* [483]26222553 : [571]26193804 */
	0x8799, /* [484]26276844 : [572]26307517 */
	0x16aa, /* [485]26331135 : [573]26313534 */
	0x2999, /* [486]26385426 : [575]26357111 */
	0x6b55, /* [487]26439717 : [576]26476842 */
	0x6b55, /* [488]26494008 : [576]26476842 */
	0x4a88, /* [489]26548299 : [577]26517927 */
	0x8988, /* [490]26602590 : [578]26617114 */
	0x3999, /* [491]26656881 : [579]26646166 */
	0x7899, /* [492]26711172 : [580]26716302 */
	0x55aa, /* [493]26765463 : [581]26771913 */
	0x36aa, /* [494]26819754 : [582]26806982 */
	0x64aa, /* [495]26874045 : [583]26866847 */
	0x71aa, /* [496]26928336 : [584]26895275 */
	0x4999, /* [497]26982627 : [585]27054952 */
	0x4999, /* [498]27036918 : [585]27054952 */
	0x5a88, /* [499]27091209 : [586]27096036 */
	0x72aa, /* [500]27145500 : [587]27150766 */
	0x46aa, /* [501]27199791 : [589]27215767 */
	0xa788, /* [502]27254082 : [590]27265361 */
	0x5b66, /* [503]27308373 : [591]27294412 */
	0x5b66, /* [504]27362664 : [591]27294412 */
	0x8a77, /* [505]27416955 : [592]27434685 */
	0x8a77, /* [506]27471246 : [592]27434685 */
	0x73aa, /* [507]27525537 : [593]27512085 */
	0xa199, /* [508]27579828 : [594]27572573 */
	0x5999, /* [509]27634119 : [596]27633061 */
	0x5999, /* [510]27688410 : [596]27633061 */
	0x17aa, /* [511]27742701 : [597]27758808 */
	0x56aa, /* [512]27796992 : [598]27793877 */
	0xa299, /* [513]27851283 : [599]27828064 */
	0x6a88, /* [514]27905574 : [600]27913607 */
	0x27aa, /* [515]27959865 : [601]27963201 */
	0x74aa, /* [516]28014156 : [602]28023066 */
	0x6b66, /* [517]28068447 : [603]28111983 */
	0x1b77, /* [518]28122738 : [604]28126509 */
	0xa399, /* [519]28177029 : [605]28189382 */
	0x37aa, /* [520]28231320 : [606]28252256 */
	0x37aa, /* [521]28285611 : [606]28252256 */
	0x2b77, /* [522]28339902 : [607]28330901 */
	0x8899, /* [523]28394193 : [608]28351444 */
	0x6999, /* [524]28448484 : [609]28450632 */
	0x81aa, /* [525]28502775 : [610]28530416 */
	0x81aa, /* [526]28557066 : [610]28530416 */
	0x66aa, /* [527]28611357 : [611]28611447 */
	0x47aa, /* [528]28665648 : [613]28661041 */
	0xa499, /* [529]28719939 : [614]28700364 */
	0x82aa, /* [530]28774230 : [616]28785907 */
	0x82aa, /* [531]28828521 : [616]28785907 */
	0x9988, /* [532]28882812 : [617]28929553 */
	0x9988, /* [533]28937103 : [617]28929553 */
	0x4b77, /* [534]28991394 : [618]29028742 */
	0x4b77, /* [535]29045685 : [618]29028742 */
	0x7a88, /* [536]29099976 : [619]29069826 */
	0x83aa, /* [537]29154267 : [620]29147226 */
	0x57aa, /* [538]29208558 : [621]29239151 */
	0x7b66, /* [539]29262849 : [622]29268202 */
	0xa888, /* [540]29317140 : [623]29309287 */
	0x1c11, /* [541]29371431 : [624]29393950 */
	0xa599, /* [542]29425722 : [625]29423001 */
	0xa599, /* [543]29480013 : [625]29423001 */
	0x2c11, /* [544]29534304 : [626]29598342 */
	0x2c11, /* [545]29588595 : [626]29598342 */
	0x84aa, /* [546]29642886 : [628]29658208 */
	0x84aa, /* [547]29697177 : [628]29658208 */
	0x9a77, /* [548]29751468 : [629]29747124 */
	0x18aa, /* [549]29805759 : [631]29802735 */
	0x3c11, /* [550]29860050 : [632]29887397 */
	0x3c11, /* [551]29914341 : [632]29887397 */
	0x28aa, /* [552]29968632 : [633]30007128 */
	0x28aa, /* [553]30022923 : [633]30007128 */
	0x67aa, /* [554]30077214 : [634]30056722 */
	0x67aa, /* [555]30131505 : [634]30056722 */
	0x1a99, /* [556]30185796 : [635]30240572 */
	0x1a99, /* [557]30240087 : [635]30240572 */
	0x38aa, /* [558]30294378 : [636]30296182 */
	0x85aa, /* [559]30348669 : [637]30380845 */
	0x6b77, /* [560]30402960 : [638]30424422 */
	0xa699, /* [561]30457251 : [639]30444964 */
	0xa699, /* [562]30511542 : [639]30444964 */
	0x2c33, /* [563]30565833 : [640]30585238 */
	0x2c33, /* [564]30620124 : [640]30585238 */
	0x9899, /* [565]30674415 : [641]30663883 */
	0x3a99, /* [566]30728706 : [643]30734019 */
	0x3a99, /* [567]30782997 : [643]30734019 */
	0x91aa, /* [568]30837288 : [644]30842856 */
	0x8b66, /* [569]30891579 : [646]30903344 */
	0x8b66, /* [570]30945870 : [646]30903344 */
	0x8b66, /* [571]31000161 : [646]30903344 */
	0x92aa, /* [572]31054452 : [647]31098346 */
	0x92aa, /* [573]31108743 : [647]31098346 */
	0x4a99, /* [574]31163034 : [648]31142805 */
	0x77aa, /* [575]31217325 : [650]31212941 */
	0x58aa, /* [576]31271616 : [652]31283078 */
	0x58aa, /* [577]31325907 : [652]31283078 */
	0x1b88, /* [578]31380198 : [653]31396791 */
	0x93aa, /* [579]31434489 : [655]31459665 */
	0x93aa, /* [580]31488780 : [655]31459665 */
	0x7b77, /* [581]31543071 : [656]31580641 */
	0x2b88, /* [582]31597362 : [657]31601184 */
	0x3c44, /* [583]31651653 : [658]31691863 */
	0x3c44, /* [584]31705944 : [658]31691863 */
	0x5a99, /* [585]31760235 : [659]31720914 */
	0x5c33, /* [586]31814526 : [660]31861187 */
	0x5c33, /* [587]31868817 : [660]31861187 */
	0xa799, /* [588]31923108 : [661]31890239 */
	0x94aa, /* [589]31977399 : [662]31970647 */
	0x94aa, /* [590]32031690 : [662]31970647 */
	0x68aa, /* [591]32085981 : [663]32100648 */
	0x68aa, /* [592]32140272 : [663]32100648 */
	0xb199, /* [593]32194563 : [664]32197451 */
	0xa988, /* [594]32248854 : [665]32199836 */
	0x4b88, /* [595]32303145 : [666]32299024 */
	0x1c55, /* [596]32357436 : [667]32354635 */
	0xb299, /* [597]32411727 : [668]32452942 */
	0xb299, /* [598]32466018 : [668]32452942 */
	0x6a99, /* [599]32520309 : [669]32538485 */
	0x2c55, /* [600]32574600 : [670]32559028 */
	0x5c44, /* [601]32628891 : [671]32678758 */
	0x5c44, /* [602]32683182 : [671]32678758 */
	0x95aa, /* [603]32737473 : [673]32693284 */
	0xb399, /* [604]32791764 : [674]32814260 */
	0x87aa, /* [605]32846055 : [675]32848082 */
	0x29aa, /* [606]32900346 : [678]32897676 */
	0x12bb, /* [607]32954637 : [679]32946389 */
	0x9a88, /* [608]33008928 : [680]33017407 */
	0x9a88, /* [609]33063219 : [680]33017407 */
	0x22bb, /* [610]33117510 : [681]33150782 */
	0x31bb, /* [611]33171801 : [682]33184346 */
	0x8b77, /* [612]33226092 : [684]33215783 */
	0x78aa, /* [613]33280383 : [685]33256868 */
	0xb499, /* [614]33334674 : [687]33325242 */
	0x32bb, /* [615]33388965 : [688]33439837 */
	0x32bb, /* [616]33443256 : [688]33439837 */
	0x6c44, /* [617]33497547 : [689]33496329 */
	0x9999, /* [618]33551838 : [691]33554432 */
	0x49aa, /* [619]33606129 : [693]33595517 */
	0x7a99, /* [620]33660420 : [694]33694705 */
	0x96aa, /* [621]33714711 : [695]33715247 */
	0x33bb, /* [622]33769002 : [696]33801155 */
	0x14bb, /* [623]33823293 : [697]33818690 */
	0x42bb, /* [624]33877584 : [699]33848622 */
	0xa899, /* [625]33931875 : [700]33934165 */
	0x1c66, /* [626]33986166 : [701]33989776 */
	0xb599, /* [627]34040457 : [703]34047879 */
	0xa1aa, /* [628]34094748 : [704]34113138 */
	0x51bb, /* [629]34149039 : [705]34171241 */
	0x43bb, /* [630]34203330 : [708]34209941 */
	0x43bb, /* [631]34257621 : [708]34209941 */
	0x34bb, /* [632]34311912 : [709]34312137 */
	0xa2aa, /* [633]34366203 : [710]34368629 */
	0x52bb, /* [634]34420494 : [711]34426732 */
	0x3c66, /* [635]34474785 : [712]34483224 */
	0x15bb, /* [636]34529076 : [713]34541327 */
	0x15bb, /* [637]34583367 : [713]34541327 */
	0x6c55, /* [638]34637658 : [714]34652548 */
	0x44bb, /* [639]34691949 : [715]34720922 */
	0x25bb, /* [640]34746240 : [717]34745719 */
	0x53bb, /* [641]34800531 : [718]34788050 */
	0x7b88, /* [642]34854822 : [719]34850924 */
	0x88aa, /* [643]34909113 : [720]34892009 */
	0x61bb, /* [644]34963404 : [721]34988812 */
	0x35bb, /* [645]35017695 : [723]35034774 */
	0xb699, /* [646]35071986 : [724]35069842 */
	0x97aa, /* [647]35126277 : [725]35160521 */
	0x97aa, /* [648]35180568 : [725]35160521 */
	0xa4aa, /* [649]35234859 : [726]35240929 */
	0x54bb, /* [650]35289150 : [728]35299032 */
	0x8a99, /* [651]35343441 : [729]35329846 */
	0x45bb, /* [652]35397732 : [730]35443560 */
	0x45bb, /* [653]35452023 : [730]35443560 */
	0x9b77, /* [654]35506314 : [732]35528222 */
	0x16bb, /* [655]35560605 : [733]35563290 */
	0x63bb, /* [656]35614896 : [734]35605621 */
	0x63bb, /* [657]35669187 : [734]35605621 */
	0x26bb, /* [658]35723478 : [735]35767683 */
	0x26bb, /* [659]35777769 : [735]35767683 */
	0x7c55, /* [660]35832060 : [736]35808768 */
	0xa5aa, /* [661]35886351 : [737]35963566 */
	0xa5aa, /* [662]35940642 : [737]35963566 */
	0x55bb, /* [663]35994933 : [738]36021669 */
	0x36bb, /* [664]36049224 : [739]36056737 */
	0x64bb, /* [665]36103515 : [740]36116603 */
	0x79aa, /* [666]36157806 : [742]36147416 */
	0x2b99, /* [667]36212097 : [743]36226062 */
	0xaa88, /* [668]36266388 : [744]36287689 */
	0x1c77, /* [669]36320679 : [745]36302215 */
	0x72bb, /* [670]36374970 : [746]36400522 */
	0x72bb, /* [671]36429261 : [746]36400522 */
	0x8b88, /* [672]36483552 : [748]36486065 */
	0xb799, /* [673]36537843 : [750]36515117 */
	0xb799, /* [674]36592134 : [750]36515117 */
	0x73bb, /* [675]36646425 : [751]36761840 */
	0x73bb, /* [676]36700716 : [751]36761840 */
	0x73bb, /* [677]36755007 : [751]36761840 */
	0x3c77, /* [678]36809298 : [753]36795663 */
	0x65bb, /* [679]36863589 : [755]36839240 */
	0x4b99, /* [680]36917880 : [756]36923902 */
	0xa6aa, /* [681]36972171 : [757]36985530 */
	0x56bb, /* [682]37026462 : [759]37043632 */
	0x56bb, /* [683]37080753 : [759]37043632 */
	0x98aa, /* [684]37135044 : [760]37204448 */
	0x98aa, /* [685]37189335 : [760]37204448 */
	0x74bb, /* [686]37243626 : [762]37272822 */
	0x3aaa, /* [687]37297917 : [763]37274585 */
	0x3aaa, /* [688]37352208 : [763]37274585 */
	0x7c66, /* [689]37406499 : [764]37443909 */
	0x7c66, /* [690]37460790 : [764]37443909 */
	0x5b99, /* [691]37515081 : [765]37502012 */
	0x5b99, /* [692]37569372 : [765]37502012 */
	0x9a99, /* [693]37623663 : [766]37642285 */
	0x4aaa, /* [694]37677954 : [767]37683370 */
	0x81bb, /* [695]37732245 : [768]37780172 */
	0x89aa, /* [696]37786536 : [769]37782558 */
	0x66bb, /* [697]37840827 : [770]37861203 */
	0x47bb, /* [698]37895118 : [771]37910797 */
	0x47bb, /* [699]37949409 : [771]37910797 */
	0x75bb, /* [700]38003700 : [772]37995459 */
	0x82bb, /* [701]38057991 : [773]38035663 */
	0x82bb, /* [702]38112282 : [773]38035663 */
	0x5aaa, /* [703]38166573 : [774]38261480 */
	0x5aaa, /* [704]38220864 : [774]38261480 */
	0x5aaa, /* [705]38275155 : [774]38261480 */
	0x6b99, /* [706]38329446 : [775]38319582 */
	0x83bb, /* [707]38383737 : [776]38396982 */
	0xa7aa, /* [708]38438028 : [777]38430804 */
	0x57bb, /* [709]38492319 : [778]38488907 */
	0xb899, /* [710]38546610 : [779]38559043 */
	0x6c77, /* [711]38600901 : [780]38600128 */
	0x6c77, /* [712]38655192 : [780]38600128 */
	0xb1aa, /* [713]38709483 : [781]38738016 */
	0xb1aa, /* [714]38763774 : [781]38738016 */
	0x9b88, /* [715]38818065 : [782]38798504 */
	0x84bb, /* [716]38872356 : [783]38907963 */
	0x84bb, /* [717]38926647 : [783]38907963 */
	0xb2aa, /* [718]38980938 : [784]38993507 */
	0x18bb, /* [719]39035229 : [786]39052491 */
	0x6aaa, /* [720]39089520 : [787]39079050 */
	0x6aaa, /* [721]39143811 : [787]39079050 */
	0x28bb, /* [722]39198102 : [788]39256883 */
	0x28bb, /* [723]39252393 : [788]39256883 */
	0x67bb, /* [724]39306684 : [789]39306477 */
	0xb3aa, /* [725]39360975 : [790]39354825 */
	0xb3aa, /* [726]39415266 : [790]39354825 */
	0x7b99, /* [727]39469557 : [791]39475802 */
	0x38bb, /* [728]39523848 : [792]39545938 */
	0x1c88, /* [729]39578139 : [793]39572498 */
	0x85bb, /* [730]39632430 : [794]39630600 */
	0x85bb, /* [731]39686721 : [794]39630600 */
	0x7c77, /* [732]39741012 : [795]39756348 */
	0x2c88, /* [733]39795303 : [796]39776890 */
	0xb4aa, /* [734]39849594 : [797]39865807 */
	0xb4aa, /* [735]39903885 : [797]39865807 */
	0x48bb, /* [736]39958176 : [798]39954724 */
	0x3c88, /* [737]40012467 : [799]40065945 */
	0x3c88, /* [738]40066758 : [799]40065945 */
	0x99aa, /* [739]40121049 : [801]40094997 */
	0x7aaa, /* [740]40175340 : [802]40235270 */
	0x7aaa, /* [741]40229631 : [802]40235270 */
	0x7aaa, /* [742]40283922 : [802]40235270 */
	0x92bb, /* [743]40338213 : [803]40348102 */
	0x92bb, /* [744]40392504 : [803]40348102 */
	0x77bb, /* [745]40446795 : [804]40462697 */
	0xa8aa, /* [746]40501086 : [805]40474730 */
	0x58bb, /* [747]40555377 : [806]40532833 */
	0xb5aa, /* [748]40609668 : [807]40588444 */
	0x86bb, /* [749]40663959 : [808]40652564 */
	0x93bb, /* [750]40718250 : [809]40709421 */
	0x93bb, /* [751]40772541 : [809]40709421 */
	0xaa99, /* [752]40826832 : [810]40912567 */
	0xaa99, /* [753]40881123 : [810]40912567 */
	0x1d11, /* [754]40935414 : [811]40956144 */
	0x1d11, /* [755]40989705 : [811]40956144 */
	0x5c88, /* [756]41043996 : [812]41052840 */
	0x8b99, /* [757]41098287 : [813]41110943 */
	0x2d11, /* [758]41152578 : [814]41160537 */
	0x94bb, /* [759]41206869 : [815]41220402 */
	0x94bb, /* [760]41261160 : [815]41220402 */
	0x68bb, /* [761]41315451 : [816]41350404 */
	0x1d22, /* [762]41369742 : [817]41364930 */
	0xb999, /* [763]41424033 : [819]41449592 */
	0xb999, /* [764]41478324 : [819]41449592 */
	0x2d22, /* [765]41532615 : [820]41569323 */
	0x2d22, /* [766]41586906 : [820]41569323 */
	0xb6aa, /* [767]41641197 : [821]41610407 */
	0xb6aa, /* [768]41695488 : [821]41610407 */
	0x3d22, /* [769]41749779 : [822]41858377 */
	0x3d22, /* [770]41804070 : [822]41858377 */
	0x3d22, /* [771]41858361 : [822]41858377 */
	0x95bb, /* [772]41912652 : [824]41943040 */
	0x95bb, /* [773]41966943 : [824]41943040 */
	0xab88, /* [774]42021234 : [825]42068787 */
	0xab88, /* [775]42075525 : [825]42068787 */
	0x29bb, /* [776]42129816 : [827]42147432 */
	0x29bb, /* [777]42184107 : [827]42147432 */
	0x4d22, /* [778]42238398 : [828]42267163 */
	0x4d22, /* [779]42292689 : [828]42267163 */
	0x4d22, /* [780]42346980 : [828]42267163 */
	0x39bb, /* [781]42401271 : [829]42436487 */
	0x39bb, /* [782]42455562 : [829]42436487 */
	0x78bb, /* [783]42509853 : [830]42506623 */
	0x1baa, /* [784]42564144 : [831]42562234 */
	0x1baa, /* [785]42618435 : [831]42562234 */
	0x1d44, /* [786]42672726 : [832]42760610 */
	0x1d44, /* [787]42727017 : [832]42760610 */
	0x2baa, /* [788]42781308 : [833]42766627 */
	0x49bb, /* [789]42835599 : [834]42845272 */
	0x49bb, /* [790]42889890 : [834]42845272 */
	0x96bb, /* [791]42944181 : [835]42965003 */
	0x7c88, /* [792]42998472 : [836]43026630 */
	0xb7aa, /* [793]43052763 : [837]43055682 */
	0xb7aa, /* [794]43107054 : [837]43055682 */
	0x3d44, /* [795]43161345 : [838]43254058 */
	0x3d44, /* [796]43215636 : [838]43254058 */
	0x3d44, /* [797]43269927 : [838]43254058 */
	0xa1bb, /* [798]43324218 : [839]43362894 */
	0xa9aa, /* [799]43378509 : [840]43365279 */
	0x9b99, /* [800]43432800 : [841]43423382 */
	0x4baa, /* [801]43487091 : [842]43464467 */
	0x4baa, /* [802]43541382 : [842]43464467 */
	0xa2bb, /* [803]43595673 : [843]43618385 */
	0x4d44, /* [804]43649964 : [844]43662843 */
	0x9c77, /* [805]43704255 : [845]43703928 */
	0x9c77, /* [806]43758546 : [845]43703928 */
	0x1d55, /* [807]43812837 : [846]43916830 */
	0x1d55, /* [808]43867128 : [846]43916830 */
	0x1d55, /* [809]43921419 : [846]43916830 */
	0xa3bb, /* [810]43975710 : [847]43979703 */
	0x5baa, /* [811]44030001 : [848]44042577 */
	0x2d55, /* [812]44084292 : [849]44121222 */
	0x88bb, /* [813]44138583 : [850]44141765 */
	0x1c99, /* [814]44192874 : [852]44197376 */
	0x69bb, /* [815]44247165 : [853]44240953 */
	0x69bb, /* [816]44301456 : [853]44240953 */
	0x2c99, /* [817]44355747 : [854]44401768 */
	0x97bb, /* [818]44410038 : [855]44410277 */
	0xa4bb, /* [819]44464329 : [856]44490685 */
	0xa4bb, /* [820]44518620 : [856]44490685 */
	0xa4bb, /* [821]44572911 : [856]44490685 */
	0x8c88, /* [822]44627202 : [857]44661771 */
	0x3c99, /* [823]44681493 : [858]44690823 */
	0x3c99, /* [824]44735784 : [858]44690823 */
	0x4d55, /* [825]44790075 : [859]44819063 */
	0x6baa, /* [826]44844366 : [860]44860148 */
	0x6baa, /* [827]44898657 : [860]44860148 */
	0x6baa, /* [828]44952948 : [860]44860148 */
	0x6d44, /* [829]45007239 : [861]45058524 */
	0x6d44, /* [830]45061530 : [861]45058524 */
	0xb8aa, /* [831]45115821 : [862]45099608 */
	0xa5bb, /* [832]45170112 : [863]45213322 */
	0xa5bb, /* [833]45224403 : [863]45213322 */
	0xc1aa, /* [834]45278694 : [864]45278581 */
	0xc1aa, /* [835]45332985 : [864]45278581 */
	0x79bb, /* [836]45387276 : [865]45397172 */
	0x79bb, /* [837]45441567 : [865]45397172 */
	0xc2aa, /* [838]45495858 : [866]45534072 */
	0x1d66, /* [839]45550149 : [868]45551971 */
	0x1d66, /* [840]45604440 : [868]45551971 */
	0x5c99, /* [841]45658731 : [869]45677718 */
	0x5c99, /* [842]45713022 : [869]45677718 */
	0x11cc, /* [843]45767313 : [871]45772029 */
	0x11cc, /* [844]45821604 : [871]45772029 */
	0xc3aa, /* [845]45875895 : [872]45895391 */
	0xc3aa, /* [846]45930186 : [872]45895391 */
	0x21cc, /* [847]45984477 : [873]45976421 */
	0x3d66, /* [848]46038768 : [877]46045418 */
	0x3d66, /* [849]46093059 : [877]46045418 */
	0x6d55, /* [850]46147350 : [878]46214743 */
	0x6d55, /* [851]46201641 : [878]46214743 */
	0x31cc, /* [852]46255932 : [881]46265476 */
	0x31cc, /* [853]46310223 : [881]46265476 */
	0x13cc, /* [854]46364514 : [882]46388838 */
	0xc4aa, /* [855]46418805 : [883]46406372 */
	0x98bb, /* [856]46473096 : [884]46454204 */
	0x3abb, /* [857]46527387 : [887]46524340 */
	0x23cc, /* [858]46581678 : [888]46593231 */
	0x41cc, /* [859]46635969 : [889]46674262 */
	0xab99, /* [860]46690260 : [890]46693665 */
	0xab99, /* [861]46744551 : [890]46693665 */
	0x33cc, /* [862]46798842 : [891]46882286 */
	0x33cc, /* [863]46853133 : [891]46882286 */
	0x14cc, /* [864]46907424 : [892]46899820 */
	0x9c88, /* [865]46961715 : [895]46974210 */
	0x89bb, /* [866]47016006 : [896]47032313 */
	0x24cc, /* [867]47070297 : [897]47104213 */
	0xc5aa, /* [868]47124588 : [898]47129009 */
	0xc5aa, /* [869]47178879 : [898]47129009 */
	0x51cc, /* [870]47233170 : [899]47252371 */
	0x43cc, /* [871]47287461 : [900]47291071 */
	0x7d55, /* [872]47341752 : [901]47370962 */
	0x34cc, /* [873]47396043 : [902]47393267 */
	0xaaaa, /* [874]47450334 : [903]47453133 */
	0x52cc, /* [875]47504625 : [904]47507862 */
	0x5abb, /* [876]47558916 : [905]47511235 */
	0x15cc, /* [877]47613207 : [906]47622457 */
	0xa7bb, /* [878]47667498 : [908]47680560 */
	0xa7bb, /* [879]47721789 : [908]47680560 */
	0x44cc, /* [880]47776080 : [909]47802053 */
	0x25cc, /* [881]47830371 : [910]47826850 */
	0x53cc, /* [882]47884662 : [913]47869181 */
	0xb1bb, /* [883]47938953 : [914]47987772 */
	0xb9aa, /* [884]47993244 : [915]47990157 */
	0x2d77, /* [885]48047535 : [916]48068803 */
	0x35cc, /* [886]48101826 : [918]48115904 */
	0xc6aa, /* [887]48156117 : [919]48150973 */
	0xb2bb, /* [888]48210408 : [920]48243263 */
	0xb2bb, /* [889]48264699 : [920]48243263 */
	0x62cc, /* [890]48318990 : [921]48325433 */
	0x54cc, /* [891]48373281 : [924]48380162 */
	0x54cc, /* [892]48427572 : [924]48380162 */
	0x45cc, /* [893]48481863 : [925]48524690 */
	0x45cc, /* [894]48536154 : [925]48524690 */
	0xb3bb, /* [895]48590445 : [926]48604581 */
	0x16cc, /* [896]48644736 : [927]48644420 */
	0x63cc, /* [897]48699027 : [928]48686751 */
	0x4d77, /* [898]48753318 : [929]48766643 */
	0x4d77, /* [899]48807609 : [929]48766643 */
	0x26cc, /* [900]48861900 : [930]48848813 */
	0x26cc, /* [901]48916191 : [930]48848813 */
	0x7d66, /* [902]48970482 : [931]49006104 */
	0x7d66, /* [903]49024773 : [931]49006104 */
	0x55cc, /* [904]49079064 : [932]49102800 */
	0x36cc, /* [905]49133355 : [934]49137868 */
	0x64cc, /* [906]49187646 : [935]49197733 */
	0x71cc, /* [907]49241937 : [936]49226161 */
	0x8c99, /* [908]49296228 : [937]49286650 */
	0x99bb, /* [909]49350519 : [938]49344752 */
	0x99bb, /* [910]49404810 : [938]49344752 */
	0x72cc, /* [911]49459101 : [939]49481652 */
	0x7abb, /* [912]49513392 : [940]49485025 */
	0x46cc, /* [913]49567683 : [941]49546653 */
	0xc7aa, /* [914]49621974 : [942]49596247 */
	0xa8bb, /* [915]49676265 : [943]49724486 */
	0xa8bb, /* [916]49730556 : [943]49724486 */
	0xb5bb, /* [917]49784847 : [944]49838200 */
	0xb5bb, /* [918]49839138 : [944]49838200 */
	0x65cc, /* [919]49893429 : [946]49920370 */
	0x9baa, /* [920]49947720 : [947]49963947 */
	0x9baa, /* [921]50002011 : [947]49963947 */
	0x17cc, /* [922]50056302 : [948]50089695 */
	0x56cc, /* [923]50110593 : [949]50124763 */
	0x6d77, /* [924]50164884 : [950]50162323 */
	0xac88, /* [925]50219175 : [951]50244493 */
	0x27cc, /* [926]50273466 : [952]50294087 */
	0x74cc, /* [927]50327757 : [953]50353953 */
	0x74cc, /* [928]50382048 : [953]50353953 */
	0x74cc, /* [929]50436339 : [953]50353953 */
	0x37cc, /* [930]50490630 : [954]50583142 */
	0x37cc, /* [931]50544921 : [954]50583142 */
	0x37cc, /* [932]50599212 : [954]50583142 */
	0x8d66, /* [933]50653503 : [955]50641245 */
	0x1caa, /* [934]50707794 : [956]50737941 */
	0x1caa, /* [935]50762085 : [956]50737941 */
	0xb6bb, /* [936]50816376 : [957]50860163 */
	0x81cc, /* [937]50870667 : [958]50861303 */
	0x66cc, /* [938]50924958 : [959]50942333 */
	0x47cc, /* [939]50979249 : [960]50991928 */
	0x47cc, /* [940]51033540 : [960]50991928 */
	0x75cc, /* [941]51087831 : [961]51076590 */
	0x1d88, /* [942]51142122 : [964]51134692 */
	0x3caa, /* [943]51196413 : [965]51231388 */
	0x3caa, /* [944]51250704 : [965]51231388 */
	0xbb99, /* [945]51304995 : [966]51318543 */
	0x2d88, /* [946]51359286 : [967]51339085 */
	0x83cc, /* [947]51413577 : [968]51478112 */
	0x83cc, /* [948]51467868 : [968]51478112 */
	0x83cc, /* [949]51522159 : [968]51478112 */
	0x57cc, /* [950]51576450 : [969]51570037 */
	0x3d88, /* [951]51630741 : [971]51628140 */
	0xc8aa, /* [952]51685032 : [972]51640174 */
	0x1bbb, /* [953]51739323 : [973]51811990 */
	0x1bbb, /* [954]51793614 : [973]51811990 */
	0x1bbb, /* [955]51847905 : [973]51811990 */
	0x84cc, /* [956]51902196 : [974]51989094 */
	0x84cc, /* [957]51956487 : [974]51989094 */
	0x2bbb, /* [958]52010778 : [975]52016383 */
	0xbaaa, /* [959]52065069 : [977]52078010 */
	0x18cc, /* [960]52119360 : [979]52133621 */
	0x18cc, /* [961]52173651 : [979]52133621 */
	0x5caa, /* [962]52227942 : [980]52218283 */
	0xb7bb, /* [963]52282233 : [981]52305438 */
	0x28cc, /* [964]52336524 : [982]52338014 */
	0x67cc, /* [965]52390815 : [983]52387608 */
	0x67cc, /* [966]52445106 : [983]52387608 */
	0x67cc, /* [967]52499397 : [983]52387608 */
	0xa9bb, /* [968]52553688 : [984]52615035 */
	0xa9bb, /* [969]52607979 : [984]52615035 */
	0x38cc, /* [970]52662270 : [985]52627069 */
	0x4bbb, /* [971]52716561 : [987]52714223 */
	0x4bbb, /* [972]52770852 : [987]52714223 */
	0x4bbb, /* [973]52825143 : [987]52714223 */
	0x8d77, /* [974]52879434 : [988]52953684 */
	0x8d77, /* [975]52933725 : [988]52953684 */
	0x8d77, /* [976]52988016 : [988]52953684 */
	0x6caa, /* [977]53042307 : [989]53035854 */
	0x6caa, /* [978]53096598 : [989]53035854 */
	0x91cc, /* [979]53150889 : [990]53173742 */
	0xabaa, /* [980]53205180 : [991]53234230 */
	0xabaa, /* [981]53259471 : [991]53234230 */
	0x5bbb, /* [982]53313762 : [992]53292333 */
	0x92cc, /* [983]53368053 : [993]53429233 */
	0x92cc, /* [984]53422344 : [993]53429233 */
	0x9abb, /* [985]53476635 : [994]53432606 */
	0x77cc, /* [986]53530926 : [995]53543827 */
	0x58cc, /* [987]53585217 : [996]53613964 */
	0x58cc, /* [988]53639508 : [996]53613964 */
	0x86cc, /* [989]53693799 : [997]53733694 */
	0x86cc, /* [990]53748090 : [997]53733694 */
	0x93cc, /* [991]53802381 : [998]53790551 */
	0x93cc, /* [992]53856672 : [998]53790551 */
	0x93cc, /* [993]53910963 : [998]53790551 */
	0x6bbb, /* [994]53965254 : [999]54109903 */
	0x6bbb, /* [995]54019545 : [999]54109903 */
	0x6bbb, /* [996]54073836 : [999]54109903 */
	0x6bbb, /* [997]54128127 : [999]54109903 */
	0x7caa, /* [998]54182418 : [1000]54192074 */
	0x7caa, /* [999]54236709 : [1000]54192074 */
	0x94cc, /* [1000]54291000 : [1001]54301533 */
	0xb8bb, /* [1001]54345291 : [1002]54349364 */
	0x68cc, /* [1002]54399582 : [1003]54431534 */
	0x68cc, /* [1003]54453873 : [1003]54431534 */
	0xc1bb, /* [1004]54508164 : [1004]54528337 */
	0x7d88, /* [1005]54562455 : [1006]54588825 */
	0x7d88, /* [1006]54616746 : [1006]54588825 */
	0x7d88, /* [1007]54671037 : [1006]54588825 */
	0xc2bb, /* [1008]54725328 : [1007]54783828 */
	0xc2bb, /* [1009]54779619 : [1007]54783828 */
	0xac99, /* [1010]54833910 : [1008]54869371 */
	0xac99, /* [1011]54888201 : [1008]54869371 */
	0xac99, /* [1012]54942492 : [1008]54869371 */
	0x95cc, /* [1013]54996783 : [1009]55024170 */
	0x95cc, /* [1014]55051074 : [1009]55024170 */
	0xc3bb, /* [1015]55105365 : [1010]55145146 */
	0xc3bb, /* [1016]55159656 : [1010]55145146 */
	0x29cc, /* [1017]55213947 : [1012]55228563 */
	0x7bbb, /* [1018]55268238 : [1013]55266123 */
	0x7bbb, /* [1019]55322529 : [1013]55266123 */
	0x7bbb, /* [1020]55376820 : [1013]55266123 */
	0x39cc, /* [1021]55431111 : [1014]55517617 */
	0x39cc, /* [1022]55485402 : [1014]55517617 */
	0x39cc, /* [1023]55539693 : [1014]55517617 */
	0x78cc, /* [1024]55593984 : [1015]55587754 */
	0xc4bb, /* [1025]55648275 : [1016]55656128 */
	0xc4bb, /* [1026]55702566 : [1016]55656128 */
	0x1d99, /* [1027]55756857 : [1017]55759570 */
	0x8caa, /* [1028]55811148 : [1018]55827215 */
	0x8caa, /* [1029]55865439 : [1018]55827215 */
	0x49cc, /* [1030]55919730 : [1019]55926403 */
	0x2d99, /* [1031]55974021 : [1020]55963963 */
	0x96cc, /* [1032]56028312 : [1021]56046133 */
	0x96cc, /* [1033]56082603 : [1021]56046133 */
	0x8d88, /* [1034]56136894 : [1022]56223966 */
	0x8d88, /* [1035]56191185 : [1022]56223966 */
	0x3d99, /* [1036]56245476 : [1023]56253018 */
	0x3d99, /* [1037]56299767 : [1023]56253018 */
	0xc5bb, /* [1038]56354058 : [1024]56378765 */
	0xc5bb, /* [1039]56408349 : [1024]56378765 */
	0xa1cc, /* [1040]56462640 : [1025]56444024 */
	0x59cc, /* [1041]56516931 : [1026]56504512 */
	0x59cc, /* [1042]56571222 : [1026]56504512 */
	0x4d99, /* [1043]56625513 : [1027]56661803 */
	0x4d99, /* [1044]56679804 : [1027]56661803 */
	0xaabb, /* [1045]56734095 : [1029]56702888 */
	0xaabb, /* [1046]56788386 : [1029]56702888 */
	0x8bbb, /* [1047]56842677 : [1030]56901264 */
	0x8bbb, /* [1048]56896968 : [1030]56901264 */
	0x8bbb, /* [1049]56951259 : [1030]56901264 */
	0xa3cc, /* [1050]57005550 : [1031]57060834 */
	0xa3cc, /* [1051]57059841 : [1031]57060834 */
	0xa3cc, /* [1052]57114132 : [1031]57060834 */
	0x88cc, /* [1053]57168423 : [1032]57222895 */
	0x88cc, /* [1054]57222714 : [1032]57222895 */
	0xb9bb, /* [1055]57277005 : [1033]57239913 */
	0x69cc, /* [1056]57331296 : [1034]57322083 */
	0xc6bb, /* [1057]57385587 : [1035]57400728 */
	0xc6bb, /* [1058]57439878 : [1035]57400728 */
	0x97cc, /* [1059]57494169 : [1036]57491408 */
	0xa4cc, /* [1060]57548460 : [1037]57571815 */
	0xa4cc, /* [1061]57602751 : [1037]57571815 */
	0xa4cc, /* [1062]57657042 : [1037]57571815 */
	0xa4cc, /* [1063]57711333 : [1037]57571815 */
	0xbbaa, /* [1064]57765624 : [1038]57859108 */
	0xbbaa, /* [1065]57819915 : [1038]57859108 */
	0xbbaa, /* [1066]57874206 : [1038]57859108 */
	0xbbaa, /* [1067]57928497 : [1038]57859108 */
	0x6d99, /* [1068]57982788 : [1039]58057484 */
	0x6d99, /* [1069]58037079 : [1039]58057484 */
	0x6d99, /* [1070]58091370 : [1039]58057484 */
	0x9caa, /* [1071]58145661 : [1040]58139654 */
	0x9caa, /* [1072]58199952 : [1040]58139654 */
	0xa5cc, /* [1073]58254243 : [1041]58294452 */
	0xa5cc, /* [1074]58308534 : [1041]58294452 */
	0xa5cc, /* [1075]58362825 : [1041]58294452 */
	0x79cc, /* [1076]58417116 : [1042]58478303 */
	0x79cc, /* [1077]58471407 : [1042]58478303 */
	0x9d88, /* [1078]58525698 : [1043]58536405 */
	0xcaaa, /* [1079]58579989 : [1044]58618576 */
	0xcaaa, /* [1080]58634280 : [1044]58618576 */
	0xcaaa, /* [1081]58688571 : [1044]58618576 */
	0xc7bb, /* [1082]58742862 : [1045]58846003 */
	0xc7bb, /* [1083]58797153 : [1045]58846003 */
	0xc7bb, /* [1084]58851444 : [1045]58846003 */
	0xc7bb, /* [1085]58905735 : [1045]58846003 */
	0xc7bb, /* [1086]58960026 : [1045]58846003 */
	0x1acc, /* [1087]59014317 : [1046]59112023 */
	0x1acc, /* [1088]59068608 : [1046]59112023 */
	0x1acc, /* [1089]59122899 : [1046]59112023 */
	0x9bbb, /* [1090]59177190 : [1047]59213703 */
	0x9bbb, /* [1091]59231481 : [1047]59213703 */
	0xa6cc, /* [1092]59285772 : [1048]59316416 */
	0xa6cc, /* [1093]59340063 : [1048]59316416 */
	0xa6cc, /* [1094]59394354 : [1048]59316416 */
	0xbc99, /* [1095]59448645 : [1049]59494249 */
	0xbc99, /* [1096]59502936 : [1049]59494249 */
	0x98cc, /* [1097]59557227 : [1050]59535334 */
	0x3acc, /* [1098]59611518 : [1051]59605471 */
	0x3acc, /* [1099]59665809 : [1051]59605471 */
	0x3acc, /* [1100]59720100 : [1051]59605471 */
	0x3acc, /* [1101]59774391 : [1051]59605471 */
	0x1cbb, /* [1102]59828682 : [1052]59987697 */
	0x1cbb, /* [1103]59882973 : [1052]59987697 */
	0x1cbb, /* [1104]59937264 : [1052]59987697 */
	0x1cbb, /* [1105]59991555 : [1052]59987697 */
	0x4acc, /* [1106]60045846 : [1053]60014256 */
	0x89cc, /* [1107]60100137 : [1054]60113444 */
	0x2cbb, /* [1108]60154428 : [1055]60192089 */
	0x2cbb, /* [1109]60208719 : [1055]60192089 */
	0x2cbb, /* [1110]60263010 : [1055]60192089 */
	0x2cbb, /* [1111]60317301 : [1055]60192089 */
	0x3cbb, /* [1112]60371592 : [1056]60481144 */
	0x3cbb, /* [1113]60425883 : [1056]60481144 */
	0x3cbb, /* [1114]60480174 : [1056]60481144 */
	0x3cbb, /* [1115]60534465 : [1056]60481144 */
	0x5acc, /* [1116]60588756 : [1057]60592366 */
	0x5acc, /* [1117]60643047 : [1057]60592366 */
	0xa7cc, /* [1118]60697338 : [1058]60761690 */
	0xa7cc, /* [1119]60751629 : [1058]60761690 */
	0x8d99, /* [1120]60805920 : [1059]60848844 */
	0x8d99, /* [1121]60860211 : [1059]60848844 */
	0xc8bb, /* [1122]60914502 : [1060]60889929 */
	0xc8bb, /* [1123]60968793 : [1060]60889929 */
	0xb1cc, /* [1124]61023084 : [1061]61068902 */
	0xb1cc, /* [1125]61077375 : [1061]61068902 */
	0xb1cc, /* [1126]61131666 : [1061]61068902 */
	0xb1cc, /* [1127]61185957 : [1061]61068902 */
	0xb2cc, /* [1128]61240248 : [1062]61324393 */
	0xb2cc, /* [1129]61294539 : [1062]61324393 */
	0xbabb, /* [1130]61348830 : [1063]61327766 */
	0xacaa, /* [1131]61403121 : [1064]61409936 */
	0x5cbb, /* [1132]61457412 : [1065]61468039 */
	0x5cbb, /* [1133]61511703 : [1065]61468039 */
	0x5cbb, /* [1134]61565994 : [1065]61468039 */
	0xb3cc, /* [1135]61620285 : [1066]61685712 */
	0xb3cc, /* [1136]61674576 : [1066]61685712 */
	0xb3cc, /* [1137]61728867 : [1066]61685712 */
	0xad88, /* [1138]61783158 : [1067]61806688 */
	0xad88, /* [1139]61837449 : [1067]61806688 */
	0xad88, /* [1140]61891740 : [1067]61806688 */
	0xad88, /* [1141]61946031 : [1067]61806688 */
	0xad88, /* [1142]62000322 : [1067]61806688 */
	0xb4cc, /* [1143]62054613 : [1068]62196693 */
	0xb4cc, /* [1144]62108904 : [1068]62196693 */
	0xb4cc, /* [1145]62163195 : [1068]62196693 */
	0xb4cc, /* [1146]62217486 : [1068]62196693 */
	0x6cbb, /* [1147]62271777 : [1069]62285610 */
	0x1daa, /* [1148]62326068 : [1070]62300136 */
	0x99cc, /* [1149]62380359 : [1071]62425883 */
	0x99cc, /* [1150]62434650 : [1071]62425883 */
	0xabbb, /* [1151]62488941 : [1072]62483986 */
	0x7acc, /* [1152]62543232 : [1074]62566156 */
	0x7acc, /* [1153]62597523 : [1074]62566156 */
	0x7acc, /* [1154]62651814 : [1074]62566156 */
	0x3daa, /* [1155]62706105 : [1075]62793583 */
	0x3daa, /* [1156]62760396 : [1075]62793583 */
	0xa8cc, /* [1157]62814687 : [1076]62805617 */
	0xb5cc, /* [1158]62868978 : [1077]62919330 */
	0xb5cc, /* [1159]62923269 : [1077]62919330 */
	0xb5cc, /* [1160]62977560 : [1077]62919330 */
	0xb5cc, /* [1161]63031851 : [1077]62919330 */
	0x9d99, /* [1162]63086142 : [1078]63161283 */
	0x9d99, /* [1163]63140433 : [1078]63161283 */
	0x4daa, /* [1164]63194724 : [1079]63202368 */
	0x4daa, /* [1165]63249015 : [1079]63202368 */
	0x4daa, /* [1166]63303306 : [1079]63202368 */
	0x7cbb, /* [1167]63357597 : [1080]63441829 */
	0x7cbb, /* [1168]63411888 : [1080]63441829 */
	0x7cbb, /* [1169]63466179 : [1080]63441829 */
	0x7cbb, /* [1170]63520470 : [1080]63441829 */
	0x7cbb, /* [1171]63574761 : [1080]63441829 */
	0xd1bb, /* [1172]63629052 : [1081]63778093 */
	0xd1bb, /* [1173]63683343 : [1081]63778093 */
	0xd1bb, /* [1174]63737634 : [1081]63778093 */
	0xc9bb, /* [1175]63791925 : [1082]63780478 */
	0xc9bb, /* [1176]63846216 : [1082]63780478 */
	0xb6cc, /* [1177]63900507 : [1083]63941294 */
	0xb6cc, /* [1178]63954798 : [1083]63941294 */
	0xd2bb, /* [1179]64009089 : [1084]64033584 */
	0xd2bb, /* [1180]64063380 : [1084]64033584 */
	0x8acc, /* [1181]64117671 : [1085]64201297 */
	0x8acc, /* [1182]64171962 : [1085]64201297 */
	0x8acc, /* [1183]64226253 : [1085]64201297 */
	0x11dd, /* [1184]64280544 : [1086]64271540 */
	0xd3bb, /* [1185]64334835 : [1087]64394902 */
	0xd3bb, /* [1186]64389126 : [1087]64394902 */
	0x21dd, /* [1187]64443417 : [1089]64475933 */
	0x21dd, /* [1188]64497708 : [1089]64475933 */
	0x12dd, /* [1189]64551999 : [1090]64527031 */
	0x6daa, /* [1190]64606290 : [1091]64598049 */
	0x6daa, /* [1191]64660581 : [1091]64598049 */
	0x22dd, /* [1192]64714872 : [1092]64731424 */
	0x31dd, /* [1193]64769163 : [1093]64764988 */
	0x31dd, /* [1194]64823454 : [1093]64764988 */
	0x13dd, /* [1195]64877745 : [1094]64888350 */
	0xd4bb, /* [1196]64932036 : [1096]64905884 */
	0x32dd, /* [1197]64986327 : [1097]65020479 */
	0x32dd, /* [1198]65040618 : [1097]65020479 */
	0x23dd, /* [1199]65094909 : [1099]65092742 */
	0x41dd, /* [1200]65149200 : [1101]65173773 */
	0x41dd, /* [1201]65203491 : [1101]65173773 */
	0x41dd, /* [1202]65257782 : [1101]65173773 */
	0x33dd, /* [1203]65312073 : [1102]65381797 */
	0x33dd, /* [1204]65366364 : [1102]65381797 */
	0x42dd, /* [1205]65420655 : [1105]65429264 */
	0x42dd, /* [1206]65474946 : [1105]65429264 */
	0x24dd, /* [1207]65529237 : [1106]65603724 */
	0x24dd, /* [1208]65583528 : [1106]65603724 */
	0xd5bb, /* [1209]65637819 : [1107]65628521 */
	0xa9cc, /* [1210]65692110 : [1108]65696165 */
	0x51dd, /* [1211]65746401 : [1109]65751883 */
	0x4bcc, /* [1212]65800692 : [1112]65795353 */
	0x34dd, /* [1213]65854983 : [1113]65892779 */
	0x34dd, /* [1214]65909274 : [1113]65892779 */
	0x52dd, /* [1215]65963565 : [1114]66007374 */
	0x52dd, /* [1216]66017856 : [1114]66007374 */
	0xbcaa, /* [1217]66072147 : [1115]66034814 */
	0x15dd, /* [1218]66126438 : [1116]66121968 */
	0x15dd, /* [1219]66180729 : [1116]66121968 */
	0x44dd, /* [1220]66235020 : [1117]66301564 */
	0x44dd, /* [1221]66289311 : [1117]66301564 */
	0x25dd, /* [1222]66343602 : [1118]66326361 */
	0x5bcc, /* [1223]66397893 : [1120]66373463 */
	0xad99, /* [1224]66452184 : [1121]66431566 */
	0x9acc, /* [1225]66506475 : [1122]66513736 */
	0x61dd, /* [1226]66560766 : [1123]66569453 */
	0x35dd, /* [1227]66615057 : [1124]66615416 */
	0xd6bb, /* [1228]66669348 : [1125]66650484 */
	0xd6bb, /* [1229]66723639 : [1125]66650484 */
	0x62dd, /* [1230]66777930 : [1126]66824944 */
	0x62dd, /* [1231]66832221 : [1126]66824944 */
	0x54dd, /* [1232]66886512 : [1127]66879674 */
	0x54dd, /* [1233]66940803 : [1127]66879674 */
	0x45dd, /* [1234]66995094 : [1128]67024201 */
	0x45dd, /* [1235]67049385 : [1128]67024201 */
	0xbbbb, /* [1236]67103676 : [1129]67108864 */
	0x16dd, /* [1237]67157967 : [1130]67143932 */
	0x6bcc, /* [1238]67212258 : [1132]67191034 */
	0x6bcc, /* [1239]67266549 : [1132]67191034 */
	0x26dd, /* [1240]67320840 : [1133]67348324 */
	0x9cbb, /* [1241]67375131 : [1134]67389410 */
	0xb8cc, /* [1242]67429422 : [1135]67430494 */
	0xb8cc, /* [1243]67483713 : [1135]67430494 */
	0x55dd, /* [1244]67538004 : [1136]67602311 */
	0x55dd, /* [1245]67592295 : [1136]67602311 */
	0x36dd, /* [1246]67646586 : [1138]67637379 */
	0x64dd, /* [1247]67700877 : [1139]67697245 */
	0x71dd, /* [1248]67755168 : [1140]67725673 */
	0xc2cc, /* [1249]67809459 : [1141]67864958 */
	0xc2cc, /* [1250]67863750 : [1141]67864958 */
	0xcabb, /* [1251]67918041 : [1142]67868331 */
	0x72dd, /* [1252]67972332 : [1143]67981164 */
	0x46dd, /* [1253]68026623 : [1144]68046165 */
	0xd7bb, /* [1254]68080914 : [1145]68095759 */
	0xd7bb, /* [1255]68135205 : [1145]68095759 */
	0xc3cc, /* [1256]68189496 : [1146]68226277 */
	0xc3cc, /* [1257]68243787 : [1146]68226277 */
	0x73dd, /* [1258]68298078 : [1147]68342482 */
	0x7bcc, /* [1259]68352369 : [1148]68347253 */
	0x65dd, /* [1260]68406660 : [1149]68419882 */
	0x65dd, /* [1261]68460951 : [1149]68419882 */
	0x17dd, /* [1262]68515242 : [1150]68589206 */
	0x17dd, /* [1263]68569533 : [1150]68589206 */
	0x56dd, /* [1264]68623824 : [1151]68624274 */
	0x56dd, /* [1265]68678115 : [1151]68624274 */
	0xc4cc, /* [1266]68732406 : [1152]68737258 */
	0x27dd, /* [1267]68786697 : [1153]68793599 */
	0x74dd, /* [1268]68840988 : [1154]68853464 */
	0x74dd, /* [1269]68895279 : [1154]68853464 */
	0x74dd, /* [1270]68949570 : [1154]68853464 */
	0x37dd, /* [1271]69003861 : [1155]69082654 */
	0x37dd, /* [1272]69058152 : [1155]69082654 */
	0x37dd, /* [1273]69112443 : [1155]69082654 */
	0x37dd, /* [1274]69166734 : [1155]69082654 */
	0x37dd, /* [1275]69221025 : [1155]69082654 */
	0x81dd, /* [1276]69275316 : [1156]69360814 */
	0x81dd, /* [1277]69329607 : [1156]69360814 */
	0x81dd, /* [1278]69383898 : [1156]69360814 */
	0x66dd, /* [1279]69438189 : [1157]69441845 */
	0x47dd, /* [1280]69492480 : [1159]69491439 */
	0x75dd, /* [1281]69546771 : [1160]69576101 */
	0x82dd, /* [1282]69601062 : [1161]69616305 */
	0x82dd, /* [1283]69655353 : [1161]69616305 */
	0x9daa, /* [1284]69709644 : [1162]69701848 */
	0xaacc, /* [1285]69763935 : [1163]69784019 */
	0xaacc, /* [1286]69818226 : [1163]69784019 */
	0xaacc, /* [1287]69872517 : [1163]69784019 */
	0x83dd, /* [1288]69926808 : [1164]69977624 */
	0x8bcc, /* [1289]69981099 : [1165]69982394 */
	0x57dd, /* [1290]70035390 : [1166]70069549 */
	0x57dd, /* [1291]70089681 : [1166]70069549 */
	0xd8bb, /* [1292]70143972 : [1167]70139685 */
	0xd8bb, /* [1293]70198263 : [1167]70139685 */
	0xb9cc, /* [1294]70252554 : [1168]70321043 */
	0xb9cc, /* [1295]70306845 : [1168]70321043 */
	0xb9cc, /* [1296]70361136 : [1168]70321043 */
	0xc6cc, /* [1297]70415427 : [1169]70481859 */
	0xc6cc, /* [1298]70469718 : [1169]70481859 */
	0x84dd, /* [1299]70524009 : [1170]70488605 */
	0x76dd, /* [1300]70578300 : [1171]70598064 */
	0x18dd, /* [1301]70632591 : [1172]70633133 */
	0xacbb, /* [1302]70686882 : [1173]70659692 */
	0xacbb, /* [1303]70741173 : [1173]70659692 */
	0x28dd, /* [1304]70795464 : [1174]70837525 */
	0x28dd, /* [1305]70849755 : [1174]70837525 */
	0x67dd, /* [1306]70904046 : [1175]70887119 */
	0x67dd, /* [1307]70958337 : [1175]70887119 */
	0xbd99, /* [1308]71012628 : [1176]71056444 */
	0xbd99, /* [1309]71066919 : [1176]71056444 */
	0x38dd, /* [1310]71121210 : [1177]71126580 */
	0x85dd, /* [1311]71175501 : [1178]71211242 */
	0x85dd, /* [1312]71229792 : [1178]71211242 */
	0x85dd, /* [1313]71284083 : [1178]71211242 */
	0x85dd, /* [1314]71338374 : [1178]71211242 */
	0x48dd, /* [1315]71392665 : [1179]71535366 */
	0x48dd, /* [1316]71446956 : [1179]71535366 */
	0x48dd, /* [1317]71501247 : [1179]71535366 */
	0x1dbb, /* [1318]71555538 : [1180]71549891 */
	0x1dbb, /* [1319]71609829 : [1180]71549891 */
	0x91dd, /* [1320]71664120 : [1181]71673253 */
	0x2dbb, /* [1321]71718411 : [1182]71754284 */
	0x2dbb, /* [1322]71772702 : [1182]71754284 */
	0x2dbb, /* [1323]71826993 : [1182]71754284 */
	0xc7cc, /* [1324]71881284 : [1183]71927133 */
	0x92dd, /* [1325]71935575 : [1184]71928744 */
	0x77dd, /* [1326]71989866 : [1185]72043339 */
	0x77dd, /* [1327]72044157 : [1185]72043339 */
	0x58dd, /* [1328]72098448 : [1186]72113475 */
	0x58dd, /* [1329]72152739 : [1186]72113475 */
	0x86dd, /* [1330]72207030 : [1187]72233206 */
	0x86dd, /* [1331]72261321 : [1187]72233206 */
	0x9bcc, /* [1332]72315612 : [1189]72294833 */
	0x9bcc, /* [1333]72369903 : [1189]72294833 */
	0x4dbb, /* [1334]72424194 : [1190]72452124 */
	0x4dbb, /* [1335]72478485 : [1190]72452124 */
	0xccaa, /* [1336]72532776 : [1191]72575379 */
	0xccaa, /* [1337]72587067 : [1191]72575379 */
	0xccaa, /* [1338]72641358 : [1191]72575379 */
	0x94dd, /* [1339]72695649 : [1192]72801044 */
	0x94dd, /* [1340]72749940 : [1192]72801044 */
	0x94dd, /* [1341]72804231 : [1192]72801044 */
	0x94dd, /* [1342]72858522 : [1192]72801044 */
	0x68dd, /* [1343]72912813 : [1193]72931046 */
	0xadaa, /* [1344]72967104 : [1194]72972131 */
	0xd9bb, /* [1345]73021395 : [1195]73030234 */
	0x1ccc, /* [1346]73075686 : [1196]73068827 */
	0x1ccc, /* [1347]73129977 : [1196]73068827 */
	0x2ccc, /* [1348]73184268 : [1197]73273220 */
	0x2ccc, /* [1349]73238559 : [1197]73273220 */
	0x2ccc, /* [1350]73292850 : [1197]73273220 */
	0x2ccc, /* [1351]73347141 : [1197]73273220 */
	0x95dd, /* [1352]73401432 : [1198]73523681 */
	0x95dd, /* [1353]73455723 : [1198]73523681 */
	0x95dd, /* [1354]73510014 : [1198]73523681 */
	0x3ccc, /* [1355]73564305 : [1199]73562274 */
	0xcbbb, /* [1356]73618596 : [1200]73649429 */
	0x87dd, /* [1357]73672887 : [1201]73678480 */
	0x29dd, /* [1358]73727178 : [1202]73728074 */
	0x29dd, /* [1359]73781469 : [1202]73728074 */
	0x6dbb, /* [1360]73835760 : [1203]73847804 */
	0x6dbb, /* [1361]73890051 : [1203]73847804 */
	0xc8cc, /* [1362]73944342 : [1204]73971060 */
	0x39dd, /* [1363]73998633 : [1205]74017129 */
	0x78dd, /* [1364]74052924 : [1206]74087265 */
	0x78dd, /* [1365]74107215 : [1206]74087265 */
	0x78dd, /* [1366]74161506 : [1206]74087265 */
	0x78dd, /* [1367]74215797 : [1206]74087265 */
	0xbacc, /* [1368]74270088 : [1207]74408897 */
	0xbacc, /* [1369]74324379 : [1207]74408897 */
	0xbacc, /* [1370]74378670 : [1207]74408897 */
	0x49dd, /* [1371]74432961 : [1208]74425914 */
	0x96dd, /* [1372]74487252 : [1209]74545645 */
	0x96dd, /* [1373]74541543 : [1209]74545645 */
	0x5ccc, /* [1374]74595834 : [1210]74549170 */
	0x5ccc, /* [1375]74650125 : [1210]74549170 */
	0x5ccc, /* [1376]74704416 : [1210]74549170 */
	0xa1dd, /* [1377]74758707 : [1211]74943536 */
	0xa1dd, /* [1378]74812998 : [1211]74943536 */
	0xa1dd, /* [1379]74867289 : [1211]74943536 */
	0xa1dd, /* [1380]74921580 : [1211]74943536 */
	0x7dbb, /* [1381]74975871 : [1212]75004024 */
	0x7dbb, /* [1382]75030162 : [1212]75004024 */
	0x7dbb, /* [1383]75084453 : [1212]75004024 */
	0xa2dd, /* [1384]75138744 : [1213]75199027 */
	0xa2dd, /* [1385]75193035 : [1213]75199027 */
	0xbcbb, /* [1386]75247326 : [1214]75284570 */
	0xbcbb, /* [1387]75301617 : [1214]75284570 */
	0x6ccc, /* [1388]75355908 : [1215]75366740 */
	0x6ccc, /* [1389]75410199 : [1215]75366740 */
	0xa3dd, /* [1390]75464490 : [1216]75560345 */
	0xa3dd, /* [1391]75518781 : [1216]75560345 */
	0xabcc, /* [1392]75573072 : [1217]75565116 */
	0xabcc, /* [1393]75627363 : [1217]75565116 */
	0x88dd, /* [1394]75681654 : [1218]75722406 */
	0x88dd, /* [1395]75735945 : [1218]75722406 */
	0x69dd, /* [1396]75790236 : [1219]75821595 */
	0x69dd, /* [1397]75844527 : [1219]75821595 */
	0x69dd, /* [1398]75898818 : [1219]75821595 */
	0x97dd, /* [1399]75953109 : [1220]75990919 */
	0x97dd, /* [1400]76007400 : [1220]75990919 */
	0xa4dd, /* [1401]76061691 : [1221]76071327 */
	0xa4dd, /* [1402]76115982 : [1221]76071327 */
	0xa4dd, /* [1403]76170273 : [1221]76071327 */
	0xa4dd, /* [1404]76224564 : [1221]76071327 */
	0xa4dd, /* [1405]76278855 : [1221]76071327 */
	0x7ccc, /* [1406]76333146 : [1222]76522960 */
	0x7ccc, /* [1407]76387437 : [1222]76522960 */
	0x7ccc, /* [1408]76441728 : [1222]76522960 */
	0x7ccc, /* [1409]76496019 : [1222]76522960 */
	0x7ccc, /* [1410]76550310 : [1222]76522960 */
	0x8dbb, /* [1411]76604601 : [1223]76639165 */
	0x8dbb, /* [1412]76658892 : [1223]76639165 */
	0x8dbb, /* [1413]76713183 : [1223]76639165 */
	0xa5dd, /* [1414]76767474 : [1224]76793964 */
	0xa5dd, /* [1415]76821765 : [1224]76793964 */
	0xc9cc, /* [1416]76876056 : [1226]76861608 */
	0x79dd, /* [1417]76930347 : [1227]76977814 */
	0x79dd, /* [1418]76984638 : [1227]76977814 */
	0x79dd, /* [1419]77038929 : [1227]76977814 */
	0xd2cc, /* [1420]77093220 : [1228]77114714 */
	0xdabb, /* [1421]77147511 : [1229]77118087 */
	0xdabb, /* [1422]77201802 : [1229]77118087 */
	0xdabb, /* [1423]77256093 : [1229]77118087 */
	0xd3cc, /* [1424]77310384 : [1230]77476032 */
	0xd3cc, /* [1425]77364675 : [1230]77476032 */
	0xd3cc, /* [1426]77418966 : [1230]77476032 */
	0xd3cc, /* [1427]77473257 : [1230]77476032 */
	0xd3cc, /* [1428]77527548 : [1230]77476032 */
	0xbdaa, /* [1429]77581839 : [1231]77597009 */
	0x1add, /* [1430]77636130 : [1232]77611535 */
	0x1add, /* [1431]77690421 : [1232]77611535 */
	0xa6dd, /* [1432]77744712 : [1233]77815927 */
	0xa6dd, /* [1433]77799003 : [1233]77815927 */
	0xa6dd, /* [1434]77853294 : [1233]77815927 */
	0xd4cc, /* [1435]77907585 : [1234]77987014 */
	0xd4cc, /* [1436]77961876 : [1234]77987014 */
	0x98dd, /* [1437]78016167 : [1235]78034846 */
	0x3add, /* [1438]78070458 : [1236]78104982 */
	0x3add, /* [1439]78124749 : [1236]78104982 */
	0x8ccc, /* [1440]78179040 : [1237]78158101 */
	0x8ccc, /* [1441]78233331 : [1237]78158101 */
	0x8ccc, /* [1442]78287622 : [1237]78158101 */
	0x4add, /* [1443]78341913 : [1238]78513768 */
	0x4add, /* [1444]78396204 : [1238]78513768 */
	0x4add, /* [1445]78450495 : [1238]78513768 */
	0x4add, /* [1446]78504786 : [1238]78513768 */
	0x4add, /* [1447]78559077 : [1238]78513768 */
	0x89dd, /* [1448]78613368 : [1239]78612955 */
	0xd5cc, /* [1449]78667659 : [1240]78709651 */
	0xd5cc, /* [1450]78721950 : [1240]78709651 */
	0xd5cc, /* [1451]78776241 : [1240]78709651 */
	0xd5cc, /* [1452]78830532 : [1240]78709651 */
	0x9dbb, /* [1453]78884823 : [1241]78951604 */
	0x9dbb, /* [1454]78939114 : [1241]78951604 */
	0x9dbb, /* [1455]78993405 : [1241]78951604 */
	0x5add, /* [1456]79047696 : [1242]79091877 */
	0x5add, /* [1457]79101987 : [1242]79091877 */
	0x5add, /* [1458]79156278 : [1242]79091877 */
	0xa7dd, /* [1459]79210569 : [1243]79261202 */
	0xa7dd, /* [1460]79264860 : [1243]79261202 */
	0xa7dd, /* [1461]79319151 : [1243]79261202 */
	0xa7dd, /* [1462]79373442 : [1243]79261202 */
	0xb1dd, /* [1463]79427733 : [1244]79568414 */
	0xb1dd, /* [1464]79482024 : [1244]79568414 */
	0xb1dd, /* [1465]79536315 : [1244]79568414 */
	0xb1dd, /* [1466]79590606 : [1244]79568414 */
	0xb1dd, /* [1467]79644897 : [1244]79568414 */
	0xd6cc, /* [1468]79699188 : [1245]79731615 */
	0xd6cc, /* [1469]79753479 : [1245]79731615 */
	0xb2dd, /* [1470]79807770 : [1246]79823905 */
	0xb2dd, /* [1471]79862061 : [1246]79823905 */
	0x6add, /* [1472]79916352 : [1247]79909448 */
	0x6add, /* [1473]79970643 : [1247]79909448 */
	0x6add, /* [1474]80024934 : [1247]79909448 */
	0xb3dd, /* [1475]80079225 : [1248]80185223 */
	0xb3dd, /* [1476]80133516 : [1248]80185223 */
	0xbbcc, /* [1477]80187807 : [1249]80189994 */
	0xbbcc, /* [1478]80242098 : [1249]80189994 */
	0xbbcc, /* [1479]80296389 : [1249]80189994 */
	0x9ccc, /* [1480]80350680 : [1250]80470540 */
	0x9ccc, /* [1481]80404971 : [1250]80470540 */
	0x9ccc, /* [1482]80459262 : [1250]80470540 */
	0x9ccc, /* [1483]80513553 : [1250]80470540 */
	0x9ccc, /* [1484]80567844 : [1250]80470540 */
	0xb4dd, /* [1485]80622135 : [1251]80696205 */
	0xb4dd, /* [1486]80676426 : [1251]80696205 */
	0xb4dd, /* [1487]80730717 : [1251]80696205 */
	0xb4dd, /* [1488]80785008 : [1251]80696205 */
	0x99dd, /* [1489]80839299 : [1252]80925394 */
	0x99dd, /* [1490]80893590 : [1252]80925394 */
	0xcacc, /* [1491]80947881 : [1253]80949462 */
	0xcacc, /* [1492]81002172 : [1253]80949462 */
	0x7add, /* [1493]81056463 : [1254]81065667 */
	0x7add, /* [1494]81110754 : [1254]81065667 */
	0xd7cc, /* [1495]81165045 : [1255]81176889 */
	0xd7cc, /* [1496]81219336 : [1255]81176889 */
	0xa8dd, /* [1497]81273627 : [1256]81305128 */
	0xa8dd, /* [1498]81327918 : [1256]81305128 */
	0xb5dd, /* [1499]81382209 : [1257]81418842 */
	0xb5dd, /* [1500]81436500 : [1257]81418842 */
	0xb5dd, /* [1501]81490791 : [1257]81418842 */
	0xb5dd, /* [1502]81545082 : [1257]81418842 */
	0xb5dd, /* [1503]81599373 : [1257]81418842 */
	0xccbb, /* [1504]81653664 : [1258]81825135 */
	0xccbb, /* [1505]81707955 : [1258]81825135 */
	0xccbb, /* [1506]81762246 : [1258]81825135 */
	0xccbb, /* [1507]81816537 : [1258]81825135 */
	0xccbb, /* [1508]81870828 : [1258]81825135 */
	0xccbb, /* [1509]81925119 : [1258]81825135 */
	0xccbb, /* [1510]81979410 : [1258]81825135 */
	0xadbb, /* [1511]82033701 : [1259]82221887 */
	0xadbb, /* [1512]82087992 : [1259]82221887 */
	0xadbb, /* [1513]82142283 : [1259]82221887 */
	0xadbb, /* [1514]82196574 : [1259]82221887 */
	0xadbb, /* [1515]82250865 : [1259]82221887 */
	0xadbb, /* [1516]82305156 : [1259]82221887 */
	0xb6dd, /* [1517]82359447 : [1260]82440805 */
	0xb6dd, /* [1518]82413738 : [1260]82440805 */
	0xb6dd, /* [1519]82468029 : [1260]82440805 */
	0xb6dd, /* [1520]82522320 : [1260]82440805 */
	0x8add, /* [1521]82576611 : [1261]82700809 */
	0x8add, /* [1522]82630902 : [1261]82700809 */
	0x8add, /* [1523]82685193 : [1261]82700809 */
	0x8add, /* [1524]82739484 : [1261]82700809 */
	0x8add, /* [1525]82793775 : [1261]82700809 */
	0xdbbb, /* [1526]82848066 : [1262]82899184 */
	0xdbbb, /* [1527]82902357 : [1262]82899184 */
	0xdbbb, /* [1528]82956648 : [1262]82899184 */
	0xdbbb, /* [1529]83010939 : [1262]82899184 */
	0xd8cc, /* [1530]83065230 : [1263]83220815 */
	0xd8cc, /* [1531]83119521 : [1263]83220815 */
	0xd8cc, /* [1532]83173812 : [1263]83220815 */
	0xd8cc, /* [1533]83228103 : [1263]83220815 */
	0xd8cc, /* [1534]83282394 : [1263]83220815 */
	0x1bdd, /* [1535]83336685 : [1264]83392632 */
	0x1bdd, /* [1536]83390976 : [1264]83392632 */
	0x1bdd, /* [1537]83445267 : [1264]83392632 */
	0x2bdd, /* [1538]83499558 : [1265]83597025 */
	0x2bdd, /* [1539]83553849 : [1265]83597025 */
	0x2bdd, /* [1540]83608140 : [1265]83597025 */
	0x2bdd, /* [1541]83662431 : [1265]83597025 */
	0xaccc, /* [1542]83716722 : [1266]83740822 */
	0xaccc, /* [1543]83771013 : [1266]83740822 */
	0xb7dd, /* [1544]83825304 : [1267]83886080 */
	0xb7dd, /* [1545]83879595 : [1267]83886080 */
	0xb7dd, /* [1546]83933886 : [1267]83886080 */
	0xb7dd, /* [1547]83988177 : [1267]83886080 */
	0xcdaa, /* [1548]84042468 : [1268]84137574 */
	0xcdaa, /* [1549]84096759 : [1268]84137574 */
	0xcdaa, /* [1550]84151050 : [1268]84137574 */
	0xa9dd, /* [1551]84205341 : [1269]84195677 */
	0x4bdd, /* [1552]84259632 : [1270]84294865 */
	0x4bdd, /* [1553]84313923 : [1270]84294865 */
	0x4bdd, /* [1554]84368214 : [1270]84294865 */
	0x4bdd, /* [1555]84422505 : [1270]84294865 */
	0x1dcc, /* [1556]84476796 : [1271]84631022 */
	0x1dcc, /* [1557]84531087 : [1271]84631022 */
	0x1dcc, /* [1558]84585378 : [1271]84631022 */
	0x1dcc, /* [1559]84639669 : [1271]84631022 */
	0x1dcc, /* [1560]84693960 : [1271]84631022 */
	0x2dcc, /* [1561]84748251 : [1272]84835414 */
	0x2dcc, /* [1562]84802542 : [1272]84835414 */
	0x5bdd, /* [1563]84856833 : [1273]84872975 */
	0x5bdd, /* [1564]84911124 : [1273]84872975 */
	0x9add, /* [1565]84965415 : [1274]85013248 */
	0x9add, /* [1566]85019706 : [1274]85013248 */
	0x3dcc, /* [1567]85073997 : [1275]85124469 */
	0x3dcc, /* [1568]85128288 : [1275]85124469 */
	0x3dcc, /* [1569]85182579 : [1275]85124469 */
	0x3dcc, /* [1570]85236870 : [1275]85124469 */
	0x3dcc, /* [1571]85291161 : [1275]85124469 */
	0x4dcc, /* [1572]85345452 : [1276]85533255 */
	0x4dcc, /* [1573]85399743 : [1276]85533255 */
	0x4dcc, /* [1574]85454034 : [1276]85533255 */
	0x4dcc, /* [1575]85508325 : [1276]85533255 */
	0x4dcc, /* [1576]85562616 : [1276]85533255 */
	0x6bdd, /* [1577]85616907 : [1277]85690545 */
	0x6bdd, /* [1578]85671198 : [1277]85690545 */
	0x6bdd, /* [1579]85725489 : [1277]85690545 */
	0x6bdd, /* [1580]85779780 : [1277]85690545 */
	0xb8dd, /* [1581]85834071 : [1278]85930006 */
	0xb8dd, /* [1582]85888362 : [1278]85930006 */
	0xb8dd, /* [1583]85942653 : [1278]85930006 */
	0xb8dd, /* [1584]85996944 : [1278]85930006 */
	0xc1dd, /* [1585]86051235 : [1279]86108979 */
	0xc1dd, /* [1586]86105526 : [1279]86108979 */
	0xd9cc, /* [1587]86159817 : [1280]86111364 */
	0xd9cc, /* [1588]86214108 : [1280]86111364 */
	0xc2dd, /* [1589]86268399 : [1281]86364470 */
	0xc2dd, /* [1590]86322690 : [1281]86364470 */
	0xc2dd, /* [1591]86376981 : [1281]86364470 */
	0xc2dd, /* [1592]86431272 : [1281]86364470 */
	0xc2dd, /* [1593]86485563 : [1281]86364470 */
	0xc2dd, /* [1594]86539854 : [1281]86364470 */
	0xc3dd, /* [1595]86594145 : [1282]86725788 */
	0xc3dd, /* [1596]86648436 : [1282]86725788 */
	0xc3dd, /* [1597]86702727 : [1282]86725788 */
	0xcbcc, /* [1598]86757018 : [1283]86730559 */
	0xbdbb, /* [1599]86811309 : [1284]86846765 */
	0xbdbb, /* [1600]86865600 : [1284]86846765 */
	0x6dcc, /* [1601]86919891 : [1285]86928935 */
	0x6dcc, /* [1602]86974182 : [1285]86928935 */
	0x6dcc, /* [1603]87028473 : [1285]86928935 */
	0x6dcc, /* [1604]87082764 : [1285]86928935 */
	0xc4dd, /* [1605]87137055 : [1286]87236770 */
	0xc4dd, /* [1606]87191346 : [1286]87236770 */
	0xc4dd, /* [1607]87245637 : [1286]87236770 */
	0xc4dd, /* [1608]87299928 : [1286]87236770 */
	0xc4dd, /* [1609]87354219 : [1286]87236770 */
	0xc4dd, /* [1610]87408510 : [1286]87236770 */
	0xc4dd, /* [1611]87462801 : [1286]87236770 */
	0xc4dd, /* [1612]87517092 : [1286]87236770 */
	0xc4dd, /* [1613]87571383 : [1286]87236770 */
	0xc5dd, /* [1614]87625674 : [1287]87959407 */
	0xc5dd, /* [1615]87679965 : [1287]87959407 */
	0xc5dd, /* [1616]87734256 : [1287]87959407 */
	0xc5dd, /* [1617]87788547 : [1287]87959407 */
	0xc5dd, /* [1618]87842838 : [1287]87959407 */
	0xc5dd, /* [1619]87897129 : [1287]87959407 */
	0xc5dd, /* [1620]87951420 : [1287]87959407 */
	0xc5dd, /* [1621]88005711 : [1287]87959407 */
	0x7dcc, /* [1622]88060002 : [1288]88085154 */
	0x7dcc, /* [1623]88114293 : [1288]88085154 */
	0x7dcc, /* [1624]88168584 : [1288]88085154 */
	0xaadd, /* [1625]88222875 : [1289]88283530 */
	0xaadd, /* [1626]88277166 : [1289]88283530 */
	0xbccc, /* [1627]88331457 : [1290]88365700 */
	0xbccc, /* [1628]88385748 : [1290]88365700 */
	0x8bdd, /* [1629]88440039 : [1291]88481906 */
	0x8bdd, /* [1630]88494330 : [1291]88481906 */
	0x8bdd, /* [1631]88548621 : [1291]88481906 */
	0x8bdd, /* [1632]88602912 : [1291]88481906 */
	0xb9dd, /* [1633]88657203 : [1292]88820555 */
	0xb9dd, /* [1634]88711494 : [1292]88820555 */
	0xb9dd, /* [1635]88765785 : [1292]88820555 */
	0xb9dd, /* [1636]88820076 : [1292]88820555 */
	0xb9dd, /* [1637]88874367 : [1292]88820555 */
	0xc6dd, /* [1638]88928658 : [1293]88981370 */
	0xc6dd, /* [1639]88982949 : [1293]88981370 */
	0xc6dd, /* [1640]89037240 : [1293]88981370 */
	0xc6dd, /* [1641]89091531 : [1293]88981370 */
	0xc6dd, /* [1642]89145822 : [1293]88981370 */
	0xc6dd, /* [1643]89200113 : [1293]88981370 */
	0xc6dd, /* [1644]89254404 : [1293]88981370 */
	0xc6dd, /* [1645]89308695 : [1293]88981370 */
	0x8dcc, /* [1646]89362986 : [1294]89720296 */
	0x8dcc, /* [1647]89417277 : [1294]89720296 */
	0x8dcc, /* [1648]89471568 : [1294]89720296 */
	0x8dcc, /* [1649]89525859 : [1294]89720296 */
	0x8dcc, /* [1650]89580150 : [1294]89720296 */
	0x8dcc, /* [1651]89634441 : [1294]89720296 */
	0x8dcc, /* [1652]89688732 : [1294]89720296 */
	0x8dcc, /* [1653]89743023 : [1294]89720296 */
	0x8dcc, /* [1654]89797314 : [1294]89720296 */
	0x8dcc, /* [1655]89851605 : [1294]89720296 */
	0x8dcc, /* [1656]89905896 : [1294]89720296 */
	0xdacc, /* [1657]89960187 : [1295]90199217 */
	0xdacc, /* [1658]90014478 : [1295]90199217 */
	0xdacc, /* [1659]90068769 : [1295]90199217 */
	0xdacc, /* [1660]90123060 : [1295]90199217 */
	0xdacc, /* [1661]90177351 : [1295]90199217 */
	0xdacc, /* [1662]90231642 : [1295]90199217 */
	0xdacc, /* [1663]90285933 : [1295]90199217 */
	0xc7dd, /* [1664]90340224 : [1296]90426645 */
	0xc7dd, /* [1665]90394515 : [1296]90426645 */
	0xc7dd, /* [1666]90448806 : [1296]90426645 */
	0xc7dd, /* [1667]90503097 : [1296]90426645 */
	0xc7dd, /* [1668]90557388 : [1296]90426645 */
	0x9bdd, /* [1669]90611679 : [1297]90794345 */
	0x9bdd, /* [1670]90665970 : [1297]90794345 */
	0x9bdd, /* [1671]90720261 : [1297]90794345 */
	0x9bdd, /* [1672]90774552 : [1297]90794345 */
	0x9bdd, /* [1673]90828843 : [1297]90794345 */
	0x9bdd, /* [1674]90883134 : [1297]90794345 */
	0xdcbb, /* [1675]90937425 : [1298]91074891 */
	0xdcbb, /* [1676]90991716 : [1298]91074891 */
	0xdcbb, /* [1677]91046007 : [1298]91074891 */
	0xdcbb, /* [1678]91100298 : [1298]91074891 */
	0xdcbb, /* [1679]91154589 : [1298]91074891 */
	0xdcbb, /* [1680]91208880 : [1298]91074891 */
	0xdcbb, /* [1681]91263171 : [1298]91074891 */
	0xdcbb, /* [1682]91317462 : [1298]91074891 */
	0x1cdd, /* [1683]91371753 : [1299]91568338 */
	0x1cdd, /* [1684]91426044 : [1299]91568338 */
	0x1cdd, /* [1685]91480335 : [1299]91568338 */
	0x1cdd, /* [1686]91534626 : [1299]91568338 */
	0x1cdd, /* [1687]91588917 : [1299]91568338 */
	0x1cdd, /* [1688]91643208 : [1299]91568338 */
	0x2cdd, /* [1689]91697499 : [1300]91772731 */
	0x2cdd, /* [1690]91751790 : [1300]91772731 */
	0x2cdd, /* [1691]91806081 : [1300]91772731 */
	0x2cdd, /* [1692]91860372 : [1300]91772731 */
	0x9dcc, /* [1693]91914663 : [1301]92032735 */
	0x9dcc, /* [1694]91968954 : [1301]92032735 */
	0x9dcc, /* [1695]92023245 : [1301]92032735 */
	0x3cdd, /* [1696]92077536 : [1302]92061786 */
	0x3cdd, /* [1697]92131827 : [1302]92061786 */
	0x3cdd, /* [1698]92186118 : [1302]92061786 */
	0x3cdd, /* [1699]92240409 : [1302]92061786 */
	0xc8dd, /* [1700]92294700 : [1303]92470571 */
	0xc8dd, /* [1701]92348991 : [1303]92470571 */
	0xc8dd, /* [1702]92403282 : [1303]92470571 */
	0xc8dd, /* [1703]92457573 : [1303]92470571 */
	0xc8dd, /* [1704]92511864 : [1303]92470571 */
	0xc8dd, /* [1705]92566155 : [1303]92470571 */
	0xc8dd, /* [1706]92620446 : [1303]92470571 */
	0xc8dd, /* [1707]92674737 : [1303]92470571 */
	0xbadd, /* [1708]92729028 : [1304]92908408 */
	0xbadd, /* [1709]92783319 : [1304]92908408 */
	0xbadd, /* [1710]92837610 : [1304]92908408 */
	0xbadd, /* [1711]92891901 : [1304]92908408 */
	0xbadd, /* [1712]92946192 : [1304]92908408 */
	0x5cdd, /* [1713]93000483 : [1305]93048681 */
	0x5cdd, /* [1714]93054774 : [1305]93048681 */
	0x5cdd, /* [1715]93109065 : [1305]93048681 */
	0x5cdd, /* [1716]93163356 : [1305]93048681 */
	0x5cdd, /* [1717]93217647 : [1305]93048681 */
	0xcdbb, /* [1718]93271938 : [1306]93387330 */
	0xcdbb, /* [1719]93326229 : [1306]93387330 */
	0xcdbb, /* [1720]93380520 : [1306]93387330 */
	0xcdbb, /* [1721]93434811 : [1306]93387330 */
	0xcdbb, /* [1722]93489102 : [1306]93387330 */
	0xcdbb, /* [1723]93543393 : [1306]93387330 */
	0xcdbb, /* [1724]93597684 : [1306]93387330 */
	0x6cdd, /* [1725]93651975 : [1307]93866252 */
	0x6cdd, /* [1726]93706266 : [1307]93866252 */
	0x6cdd, /* [1727]93760557 : [1307]93866252 */
	0x6cdd, /* [1728]93814848 : [1307]93866252 */
	0x6cdd, /* [1729]93869139 : [1307]93866252 */
	0x6cdd, /* [1730]93923430 : [1307]93866252 */
	0xabdd, /* [1731]93977721 : [1308]94064628 */
	0xabdd, /* [1732]94032012 : [1308]94064628 */
	0xabdd, /* [1733]94086303 : [1308]94064628 */
	0xabdd, /* [1734]94140594 : [1308]94064628 */
	0xabdd, /* [1735]94194885 : [1308]94064628 */
	0xabdd, /* [1736]94249176 : [1308]94064628 */
	0xabdd, /* [1737]94303467 : [1308]94064628 */
	0xabdd, /* [1738]94357758 : [1308]94064628 */
	0xabdd, /* [1739]94412049 : [1308]94064628 */
	0xabdd, /* [1740]94466340 : [1308]94064628 */
	0xcccc, /* [1741]94520631 : [1309]94906266 */
	0xcccc, /* [1742]94574922 : [1309]94906266 */
	0xcccc, /* [1743]94629213 : [1309]94906266 */
	0xcccc, /* [1744]94683504 : [1309]94906266 */
	0xcccc, /* [1745]94737795 : [1309]94906266 */
	0xcccc, /* [1746]94792086 : [1309]94906266 */
	0xcccc, /* [1747]94846377 : [1309]94906266 */
	0xcccc, /* [1748]94900668 : [1309]94906266 */
	0xcccc, /* [1749]94954959 : [1309]94906266 */
	0x7cdd, /* [1750]95009250 : [1310]95022471 */
	0x7cdd, /* [1751]95063541 : [1310]95022471 */
	0x7cdd, /* [1752]95117832 : [1310]95022471 */
	0xadcc, /* [1753]95172123 : [1311]95303017 */
	0xadcc, /* [1754]95226414 : [1311]95303017 */
	0xadcc, /* [1755]95280705 : [1311]95303017 */
	0xd1dd, /* [1756]95334996 : [1312]95358735 */
	0xc9dd, /* [1757]95389287 : [1313]95361120 */
	0xc9dd, /* [1758]95443578 : [1313]95361120 */
	0xd2dd, /* [1759]95497869 : [1314]95614225 */
	0xd2dd, /* [1760]95552160 : [1314]95614225 */
	0xd2dd, /* [1761]95606451 : [1314]95614225 */
	0xd2dd, /* [1762]95660742 : [1314]95614225 */
	0xd2dd, /* [1763]95715033 : [1314]95614225 */
	0xd2dd, /* [1764]95769324 : [1314]95614225 */
	0xd3dd, /* [1765]95823615 : [1315]95975544 */
	0xd3dd, /* [1766]95877906 : [1315]95975544 */
	0xd3dd, /* [1767]95932197 : [1315]95975544 */
	0xdbcc, /* [1768]95986488 : [1316]95980315 */
	0xdbcc, /* [1769]96040779 : [1316]95980315 */
	0xdbcc, /* [1770]96095070 : [1316]95980315 */
	0xdbcc, /* [1771]96149361 : [1316]95980315 */
	0xdbcc, /* [1772]96203652 : [1316]95980315 */
	0xd4dd, /* [1773]96257943 : [1317]96486526 */
	0xd4dd, /* [1774]96312234 : [1317]96486526 */
	0xd4dd, /* [1775]96366525 : [1317]96486526 */
	0xd4dd, /* [1776]96420816 : [1317]96486526 */
	0xd4dd, /* [1777]96475107 : [1317]96486526 */
	0xd4dd, /* [1778]96529398 : [1317]96486526 */
	0x8cdd, /* [1779]96583689 : [1318]96657612 */
	0x8cdd, /* [1780]96637980 : [1318]96657612 */
	0x8cdd, /* [1781]96692271 : [1318]96657612 */
	0x8cdd, /* [1782]96746562 : [1318]96657612 */
	0x8cdd, /* [1783]96800853 : [1318]96657612 */
	0x8cdd, /* [1784]96855144 : [1318]96657612 */
	0x8cdd, /* [1785]96909435 : [1318]96657612 */
	0xd5dd, /* [1786]96963726 : [1319]97209163 */
	0xd5dd, /* [1787]97018017 : [1319]97209163 */
	0xd5dd, /* [1788]97072308 : [1319]97209163 */
	0xd5dd, /* [1789]97126599 : [1319]97209163 */
	0xd5dd, /* [1790]97180890 : [1319]97209163 */
	0xd5dd, /* [1791]97235181 : [1319]97209163 */
	0xd5dd, /* [1792]97289472 : [1319]97209163 */
	0xd5dd, /* [1793]97343763 : [1319]97209163 */
	0xd5dd, /* [1794]97398054 : [1319]97209163 */
	0xd5dd, /* [1795]97452345 : [1319]97209163 */
	0xd5dd, /* [1796]97506636 : [1319]97209163 */
	0xd5dd, /* [1797]97560927 : [1319]97209163 */
	0xd5dd, /* [1798]97615218 : [1319]97209163 */
	0xd5dd, /* [1799]97669509 : [1319]97209163 */
	0xd6dd, /* [1800]97723800 : [1320]98231126 */
	0xd6dd, /* [1801]97778091 : [1320]98231126 */
	0xd6dd, /* [1802]97832382 : [1320]98231126 */
	0xd6dd, /* [1803]97886673 : [1320]98231126 */
	0xd6dd, /* [1804]97940964 : [1320]98231126 */
	0xd6dd, /* [1805]97995255 : [1320]98231126 */
	0xd6dd, /* [1806]98049546 : [1320]98231126 */
	0xd6dd, /* [1807]98103837 : [1320]98231126 */
	0xd6dd, /* [1808]98158128 : [1320]98231126 */
	0xd6dd, /* [1809]98212419 : [1320]98231126 */
	0xd6dd, /* [1810]98266710 : [1320]98231126 */
	0xd6dd, /* [1811]98321001 : [1320]98231126 */
	0xd6dd, /* [1812]98375292 : [1320]98231126 */
	0xd6dd, /* [1813]98429583 : [1320]98231126 */
	0xbbdd, /* [1814]98483874 : [1321]98689505 */
	0xbbdd, /* [1815]98538165 : [1321]98689505 */
	0xbbdd, /* [1816]98592456 : [1321]98689505 */
	0xbbdd, /* [1817]98646747 : [1321]98689505 */
	0xbbdd, /* [1818]98701038 : [1321]98689505 */
	0xbbdd, /* [1819]98755329 : [1321]98689505 */
	0xbbdd, /* [1820]98809620 : [1321]98689505 */
	0x9cdd, /* [1821]98863911 : [1322]98970051 */
	0x9cdd, /* [1822]98918202 : [1322]98970051 */
	0x9cdd, /* [1823]98972493 : [1322]98970051 */
	0x9cdd, /* [1824]99026784 : [1322]98970051 */
	0x9cdd, /* [1825]99081075 : [1322]98970051 */
	0x9cdd, /* [1826]99135366 : [1322]98970051 */
	0x9cdd, /* [1827]99189657 : [1322]98970051 */
	0xcadd, /* [1828]99243948 : [1323]99448973 */
	0xcadd, /* [1829]99298239 : [1323]99448973 */
	0xcadd, /* [1830]99352530 : [1323]99448973 */
	0xcadd, /* [1831]99406821 : [1323]99448973 */
	0xcadd, /* [1832]99461112 : [1323]99448973 */
	0xcadd, /* [1833]99515403 : [1323]99448973 */
	0xd7dd, /* [1834]99569694 : [1324]99676400 */
	0xd7dd, /* [1835]99623985 : [1324]99676400 */
	0xd7dd, /* [1836]99678276 : [1324]99676400 */
	0xd7dd, /* [1837]99732567 : [1324]99676400 */
	0xd7dd, /* [1838]99786858 : [1324]99676400 */
	0xbdcc, /* [1839]99841149 : [1325]99927895 */
	0xbdcc, /* [1840]99895440 : [1325]99927895 */
	0xbdcc, /* [1841]99949731 : [1325]99927895 */
	0xbdcc, /* [1842]100004022 : [1325]99927895 */
	0xbdcc, /* [1843]100058313 : [1325]99927895 */
	0xbdcc, /* [1844]100112604 : [1325]99927895 */
	0xbdcc, /* [1845]100166895 : [1325]99927895 */
	0xbdcc, /* [1846]100221186 : [1325]99927895 */
	0xbdcc, /* [1847]100275477 : [1325]99927895 */
	0xbdcc, /* [1848]100329768 : [1325]99927895 */
	0xbdcc, /* [1849]100384059 : [1325]99927895 */
	0xbdcc, /* [1850]100438350 : [1325]99927895 */
	0xbdcc, /* [1851]100492641 : [1325]99927895 */
	0xbdcc, /* [1852]100546932 : [1325]99927895 */
	0xbdcc, /* [1853]100601223 : [1325]99927895 */
	0xbdcc, /* [1854]100655514 : [1325]99927895 */
	0xbdcc, /* [1855]100709805 : [1325]99927895 */
	0xbdcc, /* [1856]100764096 : [1325]99927895 */
	0xbdcc, /* [1857]100818387 : [1325]99927895 */
	0xd8dd, /* [1858]100872678 : [1326]101720327 */
	0xd8dd, /* [1859]100926969 : [1326]101720327 */
	0xd8dd, /* [1860]100981260 : [1326]101720327 */
	0xd8dd, /* [1861]101035551 : [1326]101720327 */
	0xd8dd, /* [1862]101089842 : [1326]101720327 */
	0xd8dd, /* [1863]101144133 : [1326]101720327 */
	0xd8dd, /* [1864]101198424 : [1326]101720327 */
	0xd8dd, /* [1865]101252715 : [1326]101720327 */
	0xd8dd, /* [1866]101307006 : [1326]101720327 */
	0xd8dd, /* [1867]101361297 : [1326]101720327 */
	0xd8dd, /* [1868]101415588 : [1326]101720327 */
	0xd8dd, /* [1869]101469879 : [1326]101720327 */
	0xd8dd, /* [1870]101524170 : [1326]101720327 */
	0xd8dd, /* [1871]101578461 : [1326]101720327 */
	0xd8dd, /* [1872]101632752 : [1326]101720327 */
	0xd8dd, /* [1873]101687043 : [1326]101720327 */
	0xd8dd, /* [1874]101741334 : [1326]101720327 */
	0xd8dd, /* [1875]101795625 : [1326]101720327 */
	0xd8dd, /* [1876]101849916 : [1326]101720327 */
	0xd8dd, /* [1877]101904207 : [1326]101720327 */
	0xd8dd, /* [1878]101958498 : [1326]101720327 */
	0xacdd, /* [1879]102012789 : [1327]102240334 */
	0xacdd, /* [1880]102067080 : [1327]102240334 */
	0xacdd, /* [1881]102121371 : [1327]102240334 */
	0xacdd, /* [1882]102175662 : [1327]102240334 */
	0xacdd, /* [1883]102229953 : [1327]102240334 */
	0xacdd, /* [1884]102284244 : [1327]102240334 */
	0xacdd, /* [1885]102338535 : [1327]102240334 */
	0xacdd, /* [1886]102392826 : [1327]102240334 */
	0xddbb, /* [1887]102447117 : [1328]102637086 */
	0xddbb, /* [1888]102501408 : [1328]102637086 */
	0xddbb, /* [1889]102555699 : [1328]102637086 */
	0xddbb, /* [1890]102609990 : [1328]102637086 */
	0xddbb, /* [1891]102664281 : [1328]102637086 */
	0xddbb, /* [1892]102718572 : [1328]102637086 */
	0xddbb, /* [1893]102772863 : [1328]102637086 */
	0xddbb, /* [1894]102827154 : [1328]102637086 */
	0xddbb, /* [1895]102881445 : [1328]102637086 */
	0x1ddd, /* [1896]102935736 : [1329]103130533 */
	0x1ddd, /* [1897]102990027 : [1329]103130533 */
	0x1ddd, /* [1898]103044318 : [1329]103130533 */
	0x1ddd, /* [1899]103098609 : [1329]103130533 */
	0x1ddd, /* [1900]103152900 : [1329]103130533 */
	0x1ddd, /* [1901]103207191 : [1329]103130533 */
	0x2ddd, /* [1902]103261482 : [1330]103334926 */
	0x2ddd, /* [1903]103315773 : [1330]103334926 */
	0x2ddd, /* [1904]103370064 : [1330]103334926 */
	0x2ddd, /* [1905]103424355 : [1330]103334926 */
	0x2ddd, /* [1906]103478646 : [1330]103334926 */
	0x3ddd, /* [1907]103532937 : [1331]103623981 */
	0x3ddd, /* [1908]103587228 : [1331]103623981 */
	0x3ddd, /* [1909]103641519 : [1331]103623981 */
	0x3ddd, /* [1910]103695810 : [1331]103623981 */
	0x3ddd, /* [1911]103750101 : [1331]103623981 */
	0x3ddd, /* [1912]103804392 : [1331]103623981 */
	0x4ddd, /* [1913]103858683 : [1332]104032766 */
	0x4ddd, /* [1914]103912974 : [1332]104032766 */
	0x4ddd, /* [1915]103967265 : [1332]104032766 */
	0x4ddd, /* [1916]104021556 : [1332]104032766 */
	0x4ddd, /* [1917]104075847 : [1332]104032766 */
	0xdccc, /* [1918]104130138 : [1333]104156021 */
	0xdccc, /* [1919]104184429 : [1333]104156021 */
	0xdccc, /* [1920]104238720 : [1333]104156021 */
	0xdccc, /* [1921]104293011 : [1333]104156021 */
	0xdccc, /* [1922]104347302 : [1333]104156021 */
	0xd9dd, /* [1923]104401593 : [1334]104610876 */
	0xd9dd, /* [1924]104455884 : [1334]104610876 */
	0xd9dd, /* [1925]104510175 : [1334]104610876 */
	0xd9dd, /* [1926]104564466 : [1334]104610876 */
	0xd9dd, /* [1927]104618757 : [1334]104610876 */
	0xd9dd, /* [1928]104673048 : [1334]104610876 */
	0xd9dd, /* [1929]104727339 : [1334]104610876 */
	0xd9dd, /* [1930]104781630 : [1334]104610876 */
	0xd9dd, /* [1931]104835921 : [1334]104610876 */
	0xd9dd, /* [1932]104890212 : [1334]104610876 */
	0xcbdd, /* [1933]104944503 : [1335]105230071 */
	0xcbdd, /* [1934]104998794 : [1335]105230071 */
	0xcbdd, /* [1935]105053085 : [1335]105230071 */
	0xcbdd, /* [1936]105107376 : [1335]105230071 */
	0xcbdd, /* [1937]105161667 : [1335]105230071 */
	0xcbdd, /* [1938]105215958 : [1335]105230071 */
	0xcbdd, /* [1939]105270249 : [1335]105230071 */
	0xcbdd, /* [1940]105324540 : [1335]105230071 */
	0x6ddd, /* [1941]105378831 : [1336]105428446 */
	0x6ddd, /* [1942]105433122 : [1336]105428446 */
	0x6ddd, /* [1943]105487413 : [1336]105428446 */
	0x6ddd, /* [1944]105541704 : [1336]105428446 */
	0x6ddd, /* [1945]105595995 : [1336]105428446 */
	0x6ddd, /* [1946]105650286 : [1336]105428446 */
	0x6ddd, /* [1947]105704577 : [1336]105428446 */
	0x6ddd, /* [1948]105758868 : [1336]105428446 */
	0x6ddd, /* [1949]105813159 : [1336]105428446 */
	0x6ddd, /* [1950]105867450 : [1336]105428446 */
	0x6ddd, /* [1951]105921741 : [1336]105428446 */
	0xcdcc, /* [1952]105976032 : [1337]106468460 */
	0xcdcc, /* [1953]106030323 : [1337]106468460 */
	0xcdcc, /* [1954]106084614 : [1337]106468460 */
	0xcdcc, /* [1955]106138905 : [1337]106468460 */
	0xcdcc, /* [1956]106193196 : [1337]106468460 */
	0xcdcc, /* [1957]106247487 : [1337]106468460 */
	0xcdcc, /* [1958]106301778 : [1337]106468460 */
	0xcdcc, /* [1959]106356069 : [1337]106468460 */
	0xcdcc, /* [1960]106410360 : [1337]106468460 */
	0xcdcc, /* [1961]106464651 : [1337]106468460 */
	0xcdcc, /* [1962]106518942 : [1337]106468460 */
	0x7ddd, /* [1963]106573233 : [1338]106584666 */
	0x7ddd, /* [1964]106627524 : [1338]106584666 */
	0x7ddd, /* [1965]106681815 : [1338]106584666 */
	0xbcdd, /* [1966]106736106 : [1339]106865212 */
	0xbcdd, /* [1967]106790397 : [1339]106865212 */
	0xbcdd, /* [1968]106844688 : [1339]106865212 */
	0xbcdd, /* [1969]106898979 : [1339]106865212 */
	0xbcdd, /* [1970]106953270 : [1339]106865212 */
	0xbcdd, /* [1971]107007561 : [1339]106865212 */
	0xbcdd, /* [1972]107061852 : [1339]106865212 */
	0xbcdd, /* [1973]107116143 : [1339]106865212 */
	0xbcdd, /* [1974]107170434 : [1339]106865212 */
	0xbcdd, /* [1975]107224725 : [1339]106865212 */
	0xbcdd, /* [1976]107279016 : [1339]106865212 */
	0xbcdd, /* [1977]107333307 : [1339]106865212 */
	0xbcdd, /* [1978]107387598 : [1339]106865212 */
	0xbcdd, /* [1979]107441889 : [1339]106865212 */
	0xbcdd, /* [1980]107496180 : [1339]106865212 */
	0x8ddd, /* [1981]107550471 : [1340]108219807 */
	0x8ddd, /* [1982]107604762 : [1340]108219807 */
	0x8ddd, /* [1983]107659053 : [1340]108219807 */
	0x8ddd, /* [1984]107713344 : [1340]108219807 */
	0x8ddd, /* [1985]107767635 : [1340]108219807 */
	0x8ddd, /* [1986]107821926 : [1340]108219807 */
	0x8ddd, /* [1987]107876217 : [1340]108219807 */
	0x8ddd, /* [1988]107930508 : [1340]108219807 */
	0x8ddd, /* [1989]107984799 : [1340]108219807 */
	0x8ddd, /* [1990]108039090 : [1340]108219807 */
	0x8ddd, /* [1991]108093381 : [1340]108219807 */
	0x8ddd, /* [1992]108147672 : [1340]108219807 */
	0x8ddd, /* [1993]108201963 : [1340]108219807 */
	0x8ddd, /* [1994]108256254 : [1340]108219807 */
	0x8ddd, /* [1995]108310545 : [1340]108219807 */
	0x8ddd, /* [1996]108364836 : [1340]108219807 */
	0x8ddd, /* [1997]108419127 : [1340]108219807 */
	0xdadd, /* [1998]108473418 : [1341]108698729 */
	0xdadd, /* [1999]108527709 : [1341]108698729 */
	0xdadd, /* [2000]108582000 : [1341]108698729 */
	0xdadd, /* [2001]108636291 : [1341]108698729 */
	0xdadd, /* [2002]108690582 : [1341]108698729 */
	0xdadd, /* [2003]108744873 : [1341]108698729 */
	0xdadd, /* [2004]108799164 : [1341]108698729 */
	0xdadd, /* [2005]108853455 : [1341]108698729 */
	0xdadd, /* [2006]108907746 : [1341]108698729 */
	0xdadd, /* [2007]108962037 : [1341]108698729 */
	0xdadd, /* [2008]109016328 : [1341]108698729 */
	0xdadd, /* [2009]109070619 : [1341]108698729 */
	0xdadd, /* [2010]109124910 : [1341]108698729 */
	0xdadd, /* [2011]109179201 : [1341]108698729 */
	0xdadd, /* [2012]109233492 : [1341]108698729 */
	0xdadd, /* [2013]109287783 : [1341]108698729 */
	0xdadd, /* [2014]109342074 : [1341]108698729 */
	0xdadd, /* [2015]109396365 : [1341]108698729 */
	0xdadd, /* [2016]109450656 : [1341]108698729 */
	0xdadd, /* [2017]109504947 : [1341]108698729 */
	0xdadd, /* [2018]109559238 : [1341]108698729 */
	0xdadd, /* [2019]109613529 : [1341]108698729 */
	0x9ddd, /* [2020]109667820 : [1342]110532246 */
	0x9ddd, /* [2021]109722111 : [1342]110532246 */
	0x9ddd, /* [2022]109776402 : [1342]110532246 */
	0x9ddd, /* [2023]109830693 : [1342]110532246 */
	0x9ddd, /* [2024]109884984 : [1342]110532246 */
	0x9ddd, /* [2025]109939275 : [1342]110532246 */
	0x9ddd, /* [2026]109993566 : [1342]110532246 */
	0x9ddd, /* [2027]110047857 : [1342]110532246 */
	0x9ddd, /* [2028]110102148 : [1342]110532246 */
	0x9ddd, /* [2029]110156439 : [1342]110532246 */
	0x9ddd, /* [2030]110210730 : [1342]110532246 */
	0x9ddd, /* [2031]110265021 : [1342]110532246 */
	0x9ddd, /* [2032]110319312 : [1342]110532246 */
	0x9ddd, /* [2033]110373603 : [1342]110532246 */
	0x9ddd, /* [2034]110427894 : [1342]110532246 */
	0x9ddd, /* [2035]110482185 : [1342]110532246 */
	0x9ddd, /* [2036]110536476 : [1342]110532246 */
	0x9ddd, /* [2037]110590767 : [1342]110532246 */
	0x9ddd, /* [2038]110645058 : [1342]110532246 */
	0x9ddd, /* [2039]110699349 : [1342]110532246 */
	0x9ddd, /* [2040]110753640 : [1342]110532246 */
	0x9ddd, /* [2041]110807931 : [1342]110532246 */
	0x9ddd, /* [2042]110862222 : [1342]110532246 */
	0x9ddd, /* [2043]110916513 : [1342]110532246 */
	0x9ddd, /* [2044]110970804 : [1342]110532246 */
	0x9ddd, /* [2045]111025095 : [1342]110532246 */
	0x9ddd, /* [2046]111079386 : [1342]110532246 */
	0x9ddd, /* [2047]111133677 : [1342]110532246 */
};
/*
 * All PT_count=4096
 * Limited (2097152,134217728) PT_count=2197
 * Unique PT_count=400
 * min=0 step=217167
 * Used 307
 */
const uint16_t PAM3B_TABLE[] = {
	            /* u  v : out v */
	0x1111, /* [0]0 : [0]2097152 */
	0x1111, /* [1]217167 : [0]2097152 */
	0x1111, /* [2]434334 : [0]2097152 */
	0x1111, /* [3]651501 : [0]2097152 */
	0x1111, /* [4]868668 : [0]2097152 */
	0x1111, /* [5]1085835 : [0]2097152 */
	0x1111, /* [6]1303002 : [0]2097152 */
	0x1111, /* [7]1520169 : [0]2097152 */
	0x1111, /* [8]1737336 : [0]2097152 */
	0x1111, /* [9]1954503 : [0]2097152 */
	0x1111, /* [10]2171670 : [0]2097152 */
	0x2111, /* [11]2388837 : [1]2386708 */
	0x2122, /* [12]2606004 : [2]2676264 */
	0x3111, /* [13]2823171 : [3]2796202 */
	0x2133, /* [14]3040338 : [5]3085759 */
	0x2322, /* [15]3257505 : [6]3375315 */
	0x3311, /* [16]3474672 : [7]3495253 */
	0x2144, /* [17]3691839 : [8]3664871 */
	0x4222, /* [18]3909006 : [10]3954428 */
	0x1433, /* [19]4126173 : [11]4074366 */
	0x3244, /* [20]4343340 : [13]4363922 */
	0x2511, /* [21]4560507 : [14]4483860 */
	0x4333, /* [22]4777674 : [16]4773416 */
	0x4422, /* [23]4994841 : [18]4943035 */
	0x5322, /* [24]5212008 : [19]5182911 */
	0x1544, /* [25]5429175 : [21]5472467 */
	0x6122, /* [26]5646342 : [23]5642085 */
	0x4444, /* [27]5863509 : [25]5931642 */
	0x6311, /* [28]6080676 : [26]6051579 */
	0x1555, /* [29]6297843 : [28]6291456 */
	0x2555, /* [30]6515010 : [30]6581012 */
	0x5444, /* [31]6732177 : [32]6750630 */
	0x2644, /* [32]6949344 : [33]6920248 */
	0x1722, /* [33]7166511 : [35]7280063 */
	0x4633, /* [34]7383678 : [36]7329743 */
	0x4555, /* [35]7600845 : [38]7569619 */
	0x6522, /* [36]7818012 : [40]7739237 */
	0x2733, /* [37]8035179 : [42]7979113 */
	0x4177, /* [38]8252346 : [44]8268670 */
	0x5555, /* [39]8469513 : [45]8388608 */
	0x4566, /* [40]8686680 : [48]8727844 */
	0x2666, /* [41]8903847 : [49]8897462 */
	0x1577, /* [42]9121014 : [51]9087658 */
	0x6366, /* [43]9338181 : [52]9306956 */
	0x5566, /* [44]9555348 : [54]9546833 */
	0x7355, /* [45]9772515 : [56]9786709 */
	0x1833, /* [46]9989682 : [58]10006007 */
	0x6711, /* [47]10206849 : [59]10245883 */
	0x7544, /* [48]10424016 : [61]10365822 */
	0x1844, /* [49]10641183 : [63]10585120 */
	0x8244, /* [50]10858350 : [65]10874676 */
	0x5755, /* [51]11075517 : [67]11184810 */
	0x3844, /* [52]11292684 : [68]11284170 */
	0x7644, /* [53]11509851 : [70]11524047 */
	0x2588, /* [54]11727018 : [71]11693665 */
	0x1777, /* [55]11944185 : [73]11883861 */
	0x2777, /* [56]12161352 : [75]12173417 */
	0x6755, /* [57]12378519 : [76]12343035 */
	0x7733, /* [58]12595686 : [78]12582912 */
	0x2688, /* [59]12812853 : [80]12851890 */
	0x4777, /* [60]13030020 : [82]13162024 */
	0x3688, /* [61]13247187 : [83]13261384 */
	0x7666, /* [62]13464354 : [85]13501260 */
	0x3922, /* [63]13681521 : [86]13571519 */
	0x1499, /* [64]13898688 : [88]13861075 */
	0x4299, /* [65]14115855 : [90]14150631 */
	0x8177, /* [66]14333022 : [91]14200311 */
	0x3499, /* [67]14550189 : [93]14560126 */
	0x5911, /* [68]14767356 : [95]14680064 */
	0x2599, /* [69]14984523 : [97]14969620 */
	0x7677, /* [70]15201690 : [98]15139238 */
	0x9533, /* [71]15418857 : [99]15379114 */
	0x7844, /* [72]15636024 : [100]15478474 */
	0x9611, /* [73]15853191 : [102]15838289 */
	0x6299, /* [74]16070358 : [104]16127845 */
	0x7588, /* [75]16287525 : [105]16297463 */
	0x8188, /* [76]16504692 : [106]16516761 */
	0x7777, /* [77]16721859 : [108]16777216 */
	0x8822, /* [78]16939026 : [109]16806317 */
	0x4966, /* [79]17156193 : [110]17116452 */
	0x7866, /* [80]17373360 : [112]17455688 */
	0xa122, /* [81]17590527 : [114]17505368 */
	0x4888, /* [82]17807694 : [116]17794924 */
	0x6599, /* [83]18024861 : [118]17935441 */
	0x23aa, /* [84]18242028 : [120]18204419 */
	0x14aa, /* [85]18459195 : [121]18493975 */
	0x8588, /* [86]18676362 : [122]18613913 */
	0x4a22, /* [87]18893529 : [124]18783532 */
	0x7877, /* [88]19110696 : [125]19093666 */
	0x5a11, /* [89]19327863 : [127]19312964 */
	0x5977, /* [90]19545030 : [128]19573418 */
	0x6888, /* [91]19762197 : [130]19772138 */
	0xa533, /* [92]19979364 : [132]20012015 */
	0x9822, /* [93]20196531 : [133]20082273 */
	0xa166, /* [94]20413698 : [134]20471189 */
	0xa544, /* [95]20630865 : [136]20591127 */
	0x26aa, /* [96]20848032 : [138]20760745 */
	0x8944, /* [97]21065199 : [139]21070880 */
	0x36aa, /* [98]21282366 : [140]21170240 */
	0x7888, /* [99]21499533 : [141]21410116 */
	0xa644, /* [100]21716700 : [142]21749352 */
	0x5988, /* [101]21933867 : [143]21889868 */
	0xa177, /* [102]22151034 : [144]22109167 */
	0x9777, /* [103]22368201 : [145]22369621 */
	0x6a55, /* [104]22585368 : [147]22568341 */
	0x37aa, /* [105]22802535 : [148]22808217 */
	0x6988, /* [106]23019702 : [149]23048093 */
	0x2999, /* [107]23236869 : [151]23358228 */
	0x4a77, /* [108]23454036 : [152]23387330 */
	0x8888, /* [109]23671203 : [153]23726566 */
	0x9399, /* [110]23888370 : [154]23767722 */
	0xb211, /* [111]24105537 : [155]24057279 */
	0x9944, /* [112]24322704 : [157]24346835 */
	0x13bb, /* [113]24539871 : [159]24466773 */
	0x23bb, /* [114]24757038 : [162]24756329 */
	0x4b11, /* [115]24974205 : [163]25045886 */
	0x9955, /* [116]25191372 : [165]25165824 */
	0xa766, /* [117]25408539 : [167]25364544 */
	0x4a88, /* [118]25625706 : [168]25703780 */
	0x5b11, /* [119]25842873 : [170]25864874 */
	0xb522, /* [120]26060040 : [171]26154431 */
	0x9966, /* [121]26277207 : [172]26324049 */
	0x8a55, /* [122]26494374 : [173]26522769 */
	0xb355, /* [123]26711541 : [174]26563925 */
	0x8988, /* [124]26928708 : [175]27002521 */
	0x45bb, /* [125]27145875 : [177]27143038 */
	0xb266, /* [126]27363042 : [178]27312656 */
	0x86aa, /* [127]27580209 : [179]27680994 */
	0xb633, /* [128]27797376 : [181]27722150 */
	0x92aa, /* [129]28014543 : [183]27991128 */
	0xb466, /* [130]28231710 : [184]28301263 */
	0x9a33, /* [131]28448877 : [185]28400623 */
	0x7b11, /* [132]28666044 : [186]28661077 */
	0xb277, /* [133]28883211 : [187]28950633 */
	0x5b66, /* [134]29100378 : [189]29120251 */
	0x87aa, /* [135]29317545 : [190]29318971 */
	0xb733, /* [136]29534712 : [191]29360128 */
	0xa955, /* [137]29751879 : [192]29798724 */
	0xb744, /* [138]29969046 : [193]29939240 */
	0x9988, /* [139]30186213 : [194]30278476 */
	0x9988, /* [140]30403380 : [194]30278476 */
	0xb577, /* [141]30620547 : [195]30758229 */
	0xb577, /* [142]30837714 : [195]30758229 */
	0xb188, /* [143]31054881 : [197]30977527 */
	0x8b22, /* [144]31272048 : [198]31267083 */
	0x8a88, /* [145]31489215 : [199]31635421 */
	0x38bb, /* [146]31706382 : [200]31676578 */
	0x7b66, /* [147]31923549 : [201]31916454 */
	0xb488, /* [148]32140716 : [202]32255690 */
	0xaa11, /* [149]32357883 : [203]32334472 */
	0x79aa, /* [150]32575050 : [204]32594927 */
	0x2aaa, /* [151]32792217 : [205]32624029 */
	0xaa33, /* [152]33009384 : [206]33033523 */
	0x12cc, /* [153]33226551 : [208]33323079 */
	0x9999, /* [154]33443718 : [209]33554432 */
	0x4aaa, /* [155]33660885 : [210]33612636 */
	0x3c22, /* [156]33878052 : [212]34022130 */
	0x3c22, /* [157]34095219 : [212]34022130 */
	0x41cc, /* [158]34312386 : [215]34311686 */
	0xb299, /* [159]34529553 : [217]34543039 */
	0xc244, /* [160]34746720 : [218]34601243 */
	0x93bb, /* [161]34963887 : [220]34952533 */
	0x1c55, /* [162]35181054 : [222]35130675 */
	0x25cc, /* [163]35398221 : [223]35420231 */
	0xa6aa, /* [164]35615388 : [225]35589849 */
	0xc355, /* [165]35832555 : [226]35829726 */
	0xb877, /* [166]36049722 : [227]35870882 */
	0xc166, /* [167]36266889 : [228]36288900 */
	0xc544, /* [168]36484056 : [230]36408838 */
	0x26cc, /* [169]36701223 : [231]36578456 */
	0x63cc, /* [170]36918390 : [232]36987951 */
	0xa7aa, /* [171]37135557 : [233]37227827 */
	0xa7aa, /* [172]37352724 : [233]37227827 */
	0xc466, /* [173]37569891 : [235]37567063 */
	0xc177, /* [174]37787058 : [236]37926878 */
	0xc177, /* [175]38004225 : [236]37926878 */
	0xc722, /* [176]38221392 : [238]38216434 */
	0xc566, /* [177]38438559 : [239]38386052 */
	0x7c33, /* [178]38655726 : [240]38625928 */
	0xb1aa, /* [179]38872893 : [241]38886383 */
	0x7b99, /* [180]39090060 : [242]39146837 */
	0x74cc, /* [181]39307227 : [244]39205041 */
	0x8aaa, /* [182]39524394 : [245]39544277 */
	0xb3aa, /* [183]39741561 : [246]39585433 */
	0xc755, /* [184]39958728 : [247]40024030 */
	0x4baa, /* [185]40175895 : [248]40164546 */
	0xc288, /* [186]40393062 : [250]40532884 */
	0xc288, /* [187]40610229 : [250]40532884 */
	0x3c88, /* [188]40827396 : [251]40942378 */
	0x5baa, /* [189]41044563 : [252]40983535 */
	0x6c77, /* [190]41261730 : [253]41182255 */
	0x89bb, /* [191]41478897 : [254]41463287 */
	0xc488, /* [192]41696064 : [255]41521491 */
	0xa6bb, /* [193]41913231 : [256]42141760 */
	0xa6bb, /* [194]42130398 : [256]42141760 */
	0xc855, /* [195]42347565 : [257]42340480 */
	0xc855, /* [196]42564732 : [257]42340480 */
	0xa9aa, /* [197]42781899 : [258]42820232 */
	0xa9aa, /* [198]42999066 : [258]42820232 */
	0x86cc, /* [199]43216233 : [259]43498705 */
	0x86cc, /* [200]43433400 : [259]43498705 */
	0x7baa, /* [201]43650567 : [261]43779737 */
	0x9c22, /* [202]43867734 : [262]43808839 */
	0xc399, /* [203]44084901 : [263]44218334 */
	0xc399, /* [204]44302068 : [263]44218334 */
	0x99bb, /* [205]44519235 : [264]44739242 */
	0x99bb, /* [206]44736402 : [264]44739242 */
	0xc944, /* [207]44953569 : [265]44797446 */
	0xc877, /* [208]45170736 : [266]45136682 */
	0x1bbb, /* [209]45387903 : [267]45438293 */
	0x5c99, /* [210]45605070 : [268]45616435 */
	0xb2bb, /* [211]45822237 : [269]45727849 */
	0xb8aa, /* [212]46039404 : [270]46096187 */
	0xb3bb, /* [213]46256571 : [271]46137344 */
	0x12dd, /* [214]46473738 : [272]46426900 */
	0xbb44, /* [215]46690905 : [273]46716456 */
	0x13dd, /* [216]46908072 : [275]46836394 */
	0x2d33, /* [217]47125239 : [276]47125951 */
	0x14dd, /* [218]47342406 : [277]47415507 */
	0x5bbb, /* [219]47559573 : [279]47535445 */
	0xd422, /* [220]47776740 : [280]47705063 */
	0xd433, /* [221]47993907 : [281]48114558 */
	0xd155, /* [222]48211074 : [283]48234496 */
	0x2acc, /* [223]48428241 : [285]48441740 */
	0x6bbb, /* [224]48645408 : [287]48693670 */
	0xa3cc, /* [225]48862575 : [288]48851234 */
	0x3d55, /* [226]49079742 : [289]48933546 */
	0x9abb, /* [227]49296909 : [290]49372143 */
	0x5d44, /* [228]49514076 : [293]49512659 */
	0x26dd, /* [229]49731243 : [294]49682277 */
	0x6d33, /* [230]49948410 : [295]50091771 */
	0x6d33, /* [231]50165577 : [295]50091771 */
	0xbb77, /* [232]50382744 : [297]50331648 */
	0x64dd, /* [233]50599911 : [298]50670884 */
	0x9c88, /* [234]50817078 : [299]50729088 */
	0x7d11, /* [235]51034245 : [300]51030698 */
	0x72dd, /* [236]51251412 : [301]51320255 */
	0x65dd, /* [237]51468579 : [303]51489873 */
	0x37dd, /* [238]51685746 : [304]51729749 */
	0x37dd, /* [239]51902913 : [304]51729749 */
	0x47dd, /* [240]52120080 : [305]52308862 */
	0x47dd, /* [241]52337247 : [305]52308862 */
	0xb8bb, /* [242]52554414 : [306]52648098 */
	0xb8bb, /* [243]52771581 : [306]52648098 */
	0xa7cc, /* [244]52988748 : [307]53045538 */
	0x57dd, /* [245]53205915 : [308]53127850 */
	0xd811, /* [246]53423082 : [309]53347148 */
	0xd288, /* [247]53640249 : [310]53636705 */
	0xabaa, /* [248]53857416 : [311]54005043 */
	0x8d33, /* [249]54074583 : [312]54046199 */
	0x76dd, /* [250]54291750 : [313]54286075 */
	0x8d44, /* [251]54508917 : [314]54625312 */
	0x1bcc, /* [252]54726084 : [315]54704094 */
	0x2cbb, /* [253]54943251 : [316]54993650 */
	0x2cbb, /* [254]55160418 : [316]54993650 */
	0xc8aa, /* [255]55377585 : [317]55361988 */
	0x5d88, /* [256]55594752 : [319]55444300 */
	0xb9bb, /* [257]55811919 : [320]55924053 */
	0xb4cc, /* [258]56029086 : [321]55982257 */
	0xb4cc, /* [259]56246253 : [321]55982257 */
	0x86dd, /* [260]56463420 : [322]56602525 */
	0xd911, /* [261]56680587 : [323]56623104 */
	0xd922, /* [262]56897754 : [325]56912660 */
	0xd922, /* [263]57114921 : [325]56912660 */
	0x9d33, /* [264]57332088 : [326]57322154 */
	0x9d33, /* [265]57549255 : [326]57322154 */
	0xd499, /* [266]57766422 : [327]57901267 */
	0x6bcc, /* [267]57983589 : [328]57959471 */
	0x7d88, /* [268]58200756 : [329]58240503 */
	0x7d88, /* [269]58417923 : [329]58240503 */
	0xca99, /* [270]58635090 : [330]58637943 */
	0xd955, /* [271]58852257 : [331]58720256 */
	0xd955, /* [272]59069424 : [331]58720256 */
	0x7bcc, /* [273]59286591 : [332]59597448 */
	0x7bcc, /* [274]59503758 : [332]59597448 */
	0x7bcc, /* [275]59720925 : [332]59597448 */
	0x96dd, /* [276]59938092 : [333]59878481 */
	0x96dd, /* [277]60155259 : [333]59878481 */
	0xbbaa, /* [278]60372426 : [334]60556953 */
	0xbbaa, /* [279]60589593 : [334]60556953 */
	0xbbaa, /* [280]60806760 : [334]60556953 */
	0xda11, /* [281]61023927 : [335]61256004 */
	0xda11, /* [282]61241094 : [335]61256004 */
	0xd977, /* [283]61458261 : [336]61516458 */
	0xa2dd, /* [284]61675428 : [337]61545560 */
	0x8bcc, /* [285]61892595 : [338]61913898 */
	0x3add, /* [286]62109762 : [339]61955055 */
	0xad44, /* [287]62326929 : [340]62534167 */
	0xad44, /* [288]62544096 : [340]62534167 */
	0xad44, /* [289]62761263 : [340]62534167 */
	0xcaaa, /* [290]62978430 : [341]63270844 */
	0xcaaa, /* [291]63195597 : [341]63270844 */
	0x5daa, /* [292]63412764 : [342]63353156 */
	0x89dd, /* [293]63629931 : [343]63832908 */
	0x89dd, /* [294]63847098 : [343]63832908 */
	0x1ccc, /* [295]64064265 : [344]63969894 */
	0x2ccc, /* [296]64281432 : [345]64259451 */
	0xa6dd, /* [297]64498599 : [346]64511381 */
	0x3ccc, /* [298]64715766 : [347]64668945 */
	0x9bcc, /* [299]64932933 : [348]65189854 */
	0x9bcc, /* [300]65150100 : [348]65189854 */
	0xc4cc, /* [301]65367267 : [349]65248058 */
	0xc4cc, /* [302]65584434 : [349]65248058 */
	0xcc55, /* [303]65801601 : [350]66067046 */
	0xcc55, /* [304]66018768 : [350]66067046 */
	0x7add, /* [305]66235935 : [351]66149359 */
	0x7add, /* [306]66453102 : [351]66149359 */
	0xbbbb, /* [307]66670269 : [352]67108864 */
	0xbbbb, /* [308]66887436 : [352]67108864 */
	0xbbbb, /* [309]67104603 : [352]67108864 */
	0xc6cc, /* [310]67321770 : [353]67225271 */
	0x1bdd, /* [311]67538937 : [354]67807914 */
	0x1bdd, /* [312]67756104 : [354]67807914 */
	0xd2bb, /* [313]67973271 : [355]68097471 */
	0xd2bb, /* [314]68190438 : [355]68097471 */
	0x8add, /* [315]68407605 : [356]68465809 */
	0xdb33, /* [316]68624772 : [357]68506965 */
	0x7ccc, /* [317]68841939 : [358]68863249 */
	0xdb44, /* [318]69059106 : [359]69086078 */
	0xdb44, /* [319]69276273 : [359]69086078 */
	0xcabb, /* [320]69493440 : [360]69822754 */
	0xcabb, /* [321]69710607 : [360]69822754 */
	0xd5bb, /* [322]69927774 : [361]69905066 */
	0xd5bb, /* [323]70144941 : [361]69905066 */
	0xd5bb, /* [324]70362108 : [361]69905066 */
	0xb6dd, /* [325]70579275 : [362]71063291 */
	0xb6dd, /* [326]70796442 : [362]71063291 */
	0xb6dd, /* [327]71013609 : [362]71063291 */
	0xcc88, /* [328]71230776 : [363]71179699 */
	0xcc88, /* [329]71447943 : [363]71179699 */
	0xa9dd, /* [330]71665110 : [364]71741764 */
	0xa9dd, /* [331]71882277 : [364]71741764 */
	0xa9dd, /* [332]72099444 : [364]71741764 */
	0xdb77, /* [333]72316611 : [365]72701269 */
	0xdb77, /* [334]72533778 : [365]72701269 */
	0xdb77, /* [335]72750945 : [365]72701269 */
	0xdb77, /* [336]72968112 : [365]72701269 */
	0xdb77, /* [337]73185279 : [365]72701269 */
	0xdb77, /* [338]73402446 : [365]72701269 */
	0xcc99, /* [339]73619613 : [366]74455654 */
	0xcc99, /* [340]73836780 : [366]74455654 */
	0xcc99, /* [341]74053947 : [366]74455654 */
	0xcc99, /* [342]74271114 : [366]74455654 */
	0xcc99, /* [343]74488281 : [366]74455654 */
	0xcc99, /* [344]74705448 : [366]74455654 */
	0x8bdd, /* [345]74922615 : [367]75017719 */
	0x8bdd, /* [346]75139782 : [367]75017719 */
	0x8bdd, /* [347]75356949 : [367]75017719 */
	0x8bdd, /* [348]75574116 : [367]75017719 */
	0xcbbb, /* [349]75791283 : [368]76374664 */
	0xcbbb, /* [350]76008450 : [368]76374664 */
	0xcbbb, /* [351]76225617 : [368]76374664 */
	0xcbbb, /* [352]76442784 : [368]76374664 */
	0xcbbb, /* [353]76659951 : [368]76374664 */
	0xdc11, /* [354]76877118 : [369]77073715 */
	0xdc11, /* [355]77094285 : [369]77073715 */
	0x2dcc, /* [356]77311452 : [370]77363271 */
	0x2dcc, /* [357]77528619 : [370]77363271 */
	0x3cdd, /* [358]77745786 : [371]77772766 */
	0x3cdd, /* [359]77962953 : [371]77772766 */
	0xd9bb, /* [360]78180120 : [372]78293674 */
	0xdc44, /* [361]78397287 : [373]78351878 */
	0xdc44, /* [362]78614454 : [373]78351878 */
	0xcacc, /* [363]78831621 : [374]79088555 */
	0xcacc, /* [364]79048788 : [374]79088555 */
	0x5dcc, /* [365]79265955 : [375]79170867 */
	0x5dcc, /* [366]79483122 : [375]79170867 */
	0x5dcc, /* [367]79700289 : [375]79170867 */
	0xd6cc, /* [368]79917456 : [376]80329092 */
	0xd6cc, /* [369]80134623 : [376]80329092 */
	0xd6cc, /* [370]80351790 : [376]80329092 */
	0xd6cc, /* [371]80568957 : [376]80329092 */
	0xd6cc, /* [372]80786124 : [376]80329092 */
	0xd6cc, /* [373]81003291 : [376]80329092 */
	0xcd77, /* [374]81220458 : [377]81967070 */
	0xcd77, /* [375]81437625 : [377]81967070 */
	0xcd77, /* [376]81654792 : [377]81967070 */
	0xcd77, /* [377]81871959 : [377]81967070 */
	0xcd77, /* [378]82089126 : [377]81967070 */
	0xcd77, /* [379]82306293 : [377]81967070 */
	0xbdaa, /* [380]82523460 : [378]82926575 */
	0xbdaa, /* [381]82740627 : [378]82926575 */
	0xbdaa, /* [382]82957794 : [378]82926575 */
	0xbdaa, /* [383]83174961 : [378]82926575 */
	0xbdaa, /* [384]83392128 : [378]82926575 */
	0xcd88, /* [385]83609295 : [379]84283520 */
	0xcd88, /* [386]83826462 : [379]84283520 */
	0xcd88, /* [387]84043629 : [379]84283520 */
	0xcd88, /* [388]84260796 : [379]84283520 */
	0xcd88, /* [389]84477963 : [379]84283520 */
	0xcd88, /* [390]84695130 : [379]84283520 */
	0xcd88, /* [391]84912297 : [379]84283520 */
	0xccbb, /* [392]85129464 : [380]85640465 */
	0xccbb, /* [393]85346631 : [380]85640465 */
	0xccbb, /* [394]85563798 : [380]85640465 */
	0xccbb, /* [395]85780965 : [380]85640465 */
	0xccbb, /* [396]85998132 : [380]85640465 */
	0xccbb, /* [397]86215299 : [380]85640465 */
	0xccbb, /* [398]86432466 : [380]85640465 */
	0x9dcc, /* [399]86649633 : [381]87559475 */
	0x9dcc, /* [400]86866800 : [381]87559475 */
	0x9dcc, /* [401]87083967 : [381]87559475 */
	0x9dcc, /* [402]87301134 : [381]87559475 */
	0x9dcc, /* [403]87518301 : [381]87559475 */
	0x9dcc, /* [404]87735468 : [381]87559475 */
	0x9dcc, /* [405]87952635 : [381]87559475 */
	0x9dcc, /* [406]88169802 : [381]87559475 */
	0x9dcc, /* [407]88386969 : [381]87559475 */
	0xbdbb, /* [408]88604136 : [382]89478485 */
	0xbdbb, /* [409]88821303 : [382]89478485 */
	0xbdbb, /* [410]89038470 : [382]89478485 */
	0xbdbb, /* [411]89255637 : [382]89478485 */
	0xbdbb, /* [412]89472804 : [382]89478485 */
	0xbdbb, /* [413]89689971 : [382]89478485 */
	0x1ddd, /* [414]89907138 : [383]90177536 */
	0x1ddd, /* [415]90124305 : [383]90177536 */
	0xd2dd, /* [416]90341472 : [384]90467092 */
	0xd2dd, /* [417]90558639 : [384]90467092 */
	0x3ddd, /* [418]90775806 : [385]90876586 */
	0x3ddd, /* [419]90992973 : [385]90876586 */
	0x4ddd, /* [420]91210140 : [386]91455699 */
	0x4ddd, /* [421]91427307 : [386]91455699 */
	0x4ddd, /* [422]91644474 : [386]91455699 */
	0xcdaa, /* [423]91861641 : [387]92192375 */
	0xcdaa, /* [424]92078808 : [387]92192375 */
	0xdd55, /* [425]92295975 : [388]92274688 */
	0xdd55, /* [426]92513142 : [388]92274688 */
	0xdd55, /* [427]92730309 : [388]92274688 */
	0xdd66, /* [428]92947476 : [389]93432913 */
	0xdd66, /* [429]93164643 : [389]93432913 */
	0xdd66, /* [430]93381810 : [389]93432913 */
	0xdd66, /* [431]93598977 : [389]93432913 */
	0xdd66, /* [432]93816144 : [389]93432913 */
	0xdd66, /* [433]94033311 : [389]93432913 */
	0xcccc, /* [434]94250478 : [390]94906266 */
	0xcccc, /* [435]94467645 : [390]94906266 */
	0xcccc, /* [436]94684812 : [390]94906266 */
	0xcccc, /* [437]94901979 : [390]94906266 */
	0xdd77, /* [438]95119146 : [391]95070890 */
	0xdd77, /* [439]95336313 : [391]95070890 */
	0xdd77, /* [440]95553480 : [391]95070890 */
	0xdd77, /* [441]95770647 : [391]95070890 */
	0xdd77, /* [442]95987814 : [391]95070890 */
	0xdd77, /* [443]96204981 : [391]95070890 */
	0x8ddd, /* [444]96422148 : [392]97387340 */
	0x8ddd, /* [445]96639315 : [392]97387340 */
	0x8ddd, /* [446]96856482 : [392]97387340 */
	0x8ddd, /* [447]97073649 : [392]97387340 */
	0x8ddd, /* [448]97290816 : [392]97387340 */
	0x8ddd, /* [449]97507983 : [392]97387340 */
	0x8ddd, /* [450]97725150 : [392]97387340 */
	0x8ddd, /* [451]97942317 : [392]97387340 */
	0xbcdd, /* [452]98159484 : [393]98744286 */
	0xbcdd, /* [453]98376651 : [393]98744286 */
	0xbcdd, /* [454]98593818 : [393]98744286 */
	0xbcdd, /* [455]98810985 : [393]98744286 */
	0xbcdd, /* [456]99028152 : [393]98744286 */
	0xbcdd, /* [457]99245319 : [393]98744286 */
	0xbcdd, /* [458]99462486 : [393]98744286 */
	0xbcdd, /* [459]99679653 : [393]98744286 */
	0xd9dd, /* [460]99896820 : [394]100663296 */
	0xd9dd, /* [461]100113987 : [394]100663296 */
	0xd9dd, /* [462]100331154 : [394]100663296 */
	0xd9dd, /* [463]100548321 : [394]100663296 */
	0xd9dd, /* [464]100765488 : [394]100663296 */
	0xd9dd, /* [465]100982655 : [394]100663296 */
	0xd9dd, /* [466]101199822 : [394]100663296 */
	0xd9dd, /* [467]101416989 : [394]100663296 */
	0xd9dd, /* [468]101634156 : [394]100663296 */
	0xd9dd, /* [469]101851323 : [394]100663296 */
	0xd9dd, /* [470]102068490 : [394]100663296 */
	0xd9dd, /* [471]102285657 : [394]100663296 */
	0xd9dd, /* [472]102502824 : [394]100663296 */
	0xd9dd, /* [473]102719991 : [394]100663296 */
	0xd9dd, /* [474]102937158 : [394]100663296 */
	0xdadd, /* [475]103154325 : [395]105296196 */
	0xdadd, /* [476]103371492 : [395]105296196 */
	0xdadd, /* [477]103588659 : [395]105296196 */
	0xdadd, /* [478]103805826 : [395]105296196 */
	0xdadd, /* [479]104022993 : [395]105296196 */
	0xdadd, /* [480]104240160 : [395]105296196 */
	0xdadd, /* [481]104457327 : [395]105296196 */
	0xdadd, /* [482]104674494 : [395]105296196 */
	0xdadd, /* [483]104891661 : [395]105296196 */
	0xdadd, /* [484]105108828 : [395]105296196 */
	0xdadd, /* [485]105325995 : [395]105296196 */
	0xdadd, /* [486]105543162 : [395]105296196 */
	0xdadd, /* [487]105760329 : [395]105296196 */
	0xdadd, /* [488]105977496 : [395]105296196 */
	0xdadd, /* [489]106194663 : [395]105296196 */
	0xdadd, /* [490]106411830 : [395]105296196 */
	0xdadd, /* [491]106628997 : [395]105296196 */
	0xdccc, /* [492]106846164 : [396]108010086 */
	0xdccc, /* [493]107063331 : [396]108010086 */
	0xdccc, /* [494]107280498 : [396]108010086 */
	0xdccc, /* [495]107497665 : [396]108010086 */
	0xdccc, /* [496]107714832 : [396]108010086 */
	0xdccc, /* [497]107931999 : [396]108010086 */
	0xdccc, /* [498]108149166 : [396]108010086 */
	0xdccc, /* [499]108366333 : [396]108010086 */
	0xdccc, /* [500]108583500 : [396]108010086 */
	0xdccc, /* [501]108800667 : [396]108010086 */
	0xdccc, /* [502]109017834 : [396]108010086 */
	0xdccc, /* [503]109235001 : [396]108010086 */
	0xdccc, /* [504]109452168 : [396]108010086 */
	0xdccc, /* [505]109669335 : [396]108010086 */
	0xdccc, /* [506]109886502 : [396]108010086 */
	0xdbdd, /* [507]110103669 : [397]111848106 */
	0xdbdd, /* [508]110320836 : [397]111848106 */
	0xdbdd, /* [509]110538003 : [397]111848106 */
	0xdbdd, /* [510]110755170 : [397]111848106 */
	0xdbdd, /* [511]110972337 : [397]111848106 */
};
