/*	$NetBSD: smu_7_1_3_sh_mask.h,v 1.2 2018/08/27 04:58:23 riastradh Exp $	*/

/*
 * SMU_7_1_3 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef SMU_7_1_3_SH_MASK_H
#define SMU_7_1_3_SH_MASK_H

#define GCK_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define GCK_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define GCK_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define GCK_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define GCK_MCLK_FUSES__StartupMClkDid_MASK 0x7f
#define GCK_MCLK_FUSES__StartupMClkDid__SHIFT 0x0
#define GCK_MCLK_FUSES__MClkADCA_MASK 0x780
#define GCK_MCLK_FUSES__MClkADCA__SHIFT 0x7
#define GCK_MCLK_FUSES__MClkDDCA_MASK 0x1800
#define GCK_MCLK_FUSES__MClkDDCA__SHIFT 0xb
#define GCK_MCLK_FUSES__MClkDiDtWait_MASK 0xe000
#define GCK_MCLK_FUSES__MClkDiDtWait__SHIFT 0xd
#define GCK_MCLK_FUSES__MClkDiDtFloor_MASK 0x30000
#define GCK_MCLK_FUSES__MClkDiDtFloor__SHIFT 0x10
#define CG_DCLK_CNTL__DCLK_DIVIDER_MASK 0x7f
#define CG_DCLK_CNTL__DCLK_DIVIDER__SHIFT 0x0
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_EN_MASK 0x100
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_TOG_MASK 0x200
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_DCLK_STATUS__DCLK_STATUS_MASK 0x1
#define CG_DCLK_STATUS__DCLK_STATUS__SHIFT 0x0
#define CG_DCLK_STATUS__DCLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_DCLK_STATUS__DCLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_VCLK_CNTL__VCLK_DIVIDER_MASK 0x7f
#define CG_VCLK_CNTL__VCLK_DIVIDER__SHIFT 0x0
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_EN_MASK 0x100
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_TOG_MASK 0x200
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_VCLK_STATUS__VCLK_STATUS_MASK 0x1
#define CG_VCLK_STATUS__VCLK_STATUS__SHIFT 0x0
#define CG_VCLK_STATUS__VCLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_VCLK_STATUS__VCLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_ECLK_CNTL__ECLK_DIVIDER_MASK 0x7f
#define CG_ECLK_CNTL__ECLK_DIVIDER__SHIFT 0x0
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_EN_MASK 0x100
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_TOG_MASK 0x200
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_ECLK_STATUS__ECLK_STATUS_MASK 0x1
#define CG_ECLK_STATUS__ECLK_STATUS__SHIFT 0x0
#define CG_ECLK_STATUS__ECLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_ECLK_STATUS__ECLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_ACLK_CNTL__ACLK_DIVIDER_MASK 0x7f
#define CG_ACLK_CNTL__ACLK_DIVIDER__SHIFT 0x0
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_EN_MASK 0x100
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_TOG_MASK 0x200
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_MCLK_CNTL__MCLK_DIVIDER_MASK 0x7f
#define CG_MCLK_CNTL__MCLK_DIVIDER__SHIFT 0x0
#define CG_MCLK_CNTL__MCLK_DIR_CNTL_EN_MASK 0x100
#define CG_MCLK_CNTL__MCLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_MCLK_CNTL__MCLK_DIR_CNTL_TOG_MASK 0x200
#define CG_MCLK_CNTL__MCLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_MCLK_CNTL__MCLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_MCLK_CNTL__MCLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_MCLK_STATUS__MCLK_STATUS_MASK 0x1
#define CG_MCLK_STATUS__MCLK_STATUS__SHIFT 0x0
#define CG_MCLK_STATUS__MCLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_MCLK_STATUS__MCLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define GCK_DFS_BYPASS_CNTL__BYPASSECLK_MASK 0x1
#define GCK_DFS_BYPASS_CNTL__BYPASSECLK__SHIFT 0x0
#define GCK_DFS_BYPASS_CNTL__BYPASSLCLK_MASK 0x2
#define GCK_DFS_BYPASS_CNTL__BYPASSLCLK__SHIFT 0x1
#define GCK_DFS_BYPASS_CNTL__BYPASSEVCLK_MASK 0x4
#define GCK_DFS_BYPASS_CNTL__BYPASSEVCLK__SHIFT 0x2
#define GCK_DFS_BYPASS_CNTL__BYPASSDCLK_MASK 0x8
#define GCK_DFS_BYPASS_CNTL__BYPASSDCLK__SHIFT 0x3
#define GCK_DFS_BYPASS_CNTL__BYPASSVCLK_MASK 0x10
#define GCK_DFS_BYPASS_CNTL__BYPASSVCLK__SHIFT 0x4
#define GCK_DFS_BYPASS_CNTL__BYPASSDISPCLK_MASK 0x20
#define GCK_DFS_BYPASS_CNTL__BYPASSDISPCLK__SHIFT 0x5
#define GCK_DFS_BYPASS_CNTL__BYPASSDPREFCLK_MASK 0x40
#define GCK_DFS_BYPASS_CNTL__BYPASSDPREFCLK__SHIFT 0x6
#define GCK_DFS_BYPASS_CNTL__BYPASSACLK_MASK 0x80
#define GCK_DFS_BYPASS_CNTL__BYPASSACLK__SHIFT 0x7
#define GCK_DFS_BYPASS_CNTL__BYPASSADIVCLK_MASK 0x100
#define GCK_DFS_BYPASS_CNTL__BYPASSADIVCLK__SHIFT 0x8
#define GCK_DFS_BYPASS_CNTL__BYPASSPSPCLK_MASK 0x200
#define GCK_DFS_BYPASS_CNTL__BYPASSPSPCLK__SHIFT 0x9
#define GCK_DFS_BYPASS_CNTL__BYPASSSAMCLK_MASK 0x400
#define GCK_DFS_BYPASS_CNTL__BYPASSSAMCLK__SHIFT 0xa
#define GCK_DFS_BYPASS_CNTL__BYPASSSCLK_MASK 0x800
#define GCK_DFS_BYPASS_CNTL__BYPASSSCLK__SHIFT 0xb
#define GCK_DFS_BYPASS_CNTL__USE_SPLL_BYPASS_EN_MASK 0x1000
#define GCK_DFS_BYPASS_CNTL__USE_SPLL_BYPASS_EN__SHIFT 0xc
#define GCK_DFS_BYPASS_CNTL__BYPASSMCLK_MASK 0x2000
#define GCK_DFS_BYPASS_CNTL__BYPASSMCLK__SHIFT 0xd
#define CG_SPLL_FUNC_CNTL__SPLL_RESET_MASK 0x1
#define CG_SPLL_FUNC_CNTL__SPLL_RESET__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL__SPLL_PWRON_MASK 0x2
#define CG_SPLL_FUNC_CNTL__SPLL_PWRON__SHIFT 0x1
#define CG_SPLL_FUNC_CNTL__SPLL_DIVEN_MASK 0x4
#define CG_SPLL_FUNC_CNTL__SPLL_DIVEN__SHIFT 0x2
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_EN_MASK 0x8
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_EN__SHIFT 0x3
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_THRU_DFS_MASK 0x10
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_THRU_DFS__SHIFT 0x4
#define CG_SPLL_FUNC_CNTL__SPLL_REF_DIV_MASK 0x7e0
#define CG_SPLL_FUNC_CNTL__SPLL_REF_DIV__SHIFT 0x5
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_UPDATE_MASK 0x800
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_UPDATE__SHIFT 0xb
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_EN_MASK 0x1000
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_EN__SHIFT 0xc
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_MASK 0x7f00000
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A__SHIFT 0x14
#define CG_SPLL_FUNC_CNTL__SPLL_DIVA_ACK_MASK 0x8000000
#define CG_SPLL_FUNC_CNTL__SPLL_DIVA_ACK__SHIFT 0x1b
#define CG_SPLL_FUNC_CNTL__SPLL_OTEST_LOCK_EN_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL__SPLL_OTEST_LOCK_EN__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_SEL_MASK 0x1ff
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_SEL__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_MASK 0x800
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ__SHIFT 0xb
#define CG_SPLL_FUNC_CNTL_2__SPLL_BYPASS_CHG_MASK 0x400000
#define CG_SPLL_FUNC_CNTL_2__SPLL_BYPASS_CHG__SHIFT 0x16
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_CHG_MASK 0x800000
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_CHG__SHIFT 0x17
#define CG_SPLL_FUNC_CNTL_2__SPLL_RESET_CHG_MASK 0x1000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_RESET_CHG__SHIFT 0x18
#define CG_SPLL_FUNC_CNTL_2__SPLL_BABY_STEP_CHG_MASK 0x2000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_BABY_STEP_CHG__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_UPDATE_MASK 0x4000000
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_UPDATE__SHIFT 0x1a
#define CG_SPLL_FUNC_CNTL_2__SPLL_UNLOCK_CLEAR_MASK 0x8000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_UNLOCK_CLEAR__SHIFT 0x1b
#define CG_SPLL_FUNC_CNTL_2__SPLL_CLKF_UPDATE_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_CLKF_UPDATE__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_2__SPLL_TEST_UNLOCK_CLR_MASK 0x40000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_TEST_UNLOCK_CLR__SHIFT 0x1e
#define CG_SPLL_FUNC_CNTL_3__SPLL_FB_DIV_MASK 0x3ffffff
#define CG_SPLL_FUNC_CNTL_3__SPLL_FB_DIV__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_3__SPLL_DITHEN_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL_3__SPLL_DITHEN__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_TEST_SEL_MASK 0xf
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_TEST_SEL__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_SEL_MASK 0x60
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_SEL__SHIFT 0x5
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EN_MASK 0x180
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EN__SHIFT 0x7
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_MASK 0xe00
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE__SHIFT 0x9
#define CG_SPLL_FUNC_CNTL_4__PCC_INC_DIV_MASK 0x7f000
#define CG_SPLL_FUNC_CNTL_4__PCC_INC_DIV__SHIFT 0xc
#define CG_SPLL_FUNC_CNTL_4__TEST_FRAC_BYPASS_MASK 0x200000
#define CG_SPLL_FUNC_CNTL_4__TEST_FRAC_BYPASS__SHIFT 0x15
#define CG_SPLL_FUNC_CNTL_4__SPLL_ILOCK_MASK 0x800000
#define CG_SPLL_FUNC_CNTL_4__SPLL_ILOCK__SHIFT 0x17
#define CG_SPLL_FUNC_CNTL_4__SPLL_FBCLK_SEL_MASK 0x1000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_FBCLK_SEL__SHIFT 0x18
#define CG_SPLL_FUNC_CNTL_4__SPLL_VCTRLADC_EN_MASK 0x2000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_VCTRLADC_EN__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_MASK 0xc000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT__SHIFT 0x1a
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_EXT_MASK 0x70000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_EXT__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_4__SPLL_VTOI_BIAS_CNTL_MASK 0x80000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_VTOI_BIAS_CNTL__SHIFT 0x1f
#define CG_SPLL_FUNC_CNTL_5__FBDIV_SSC_BYPASS_MASK 0x1
#define CG_SPLL_FUNC_CNTL_5__FBDIV_SSC_BYPASS__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_5__RISEFBVCO_EN_MASK 0x2
#define CG_SPLL_FUNC_CNTL_5__RISEFBVCO_EN__SHIFT 0x1
#define CG_SPLL_FUNC_CNTL_5__PFD_RESET_CNTRL_MASK 0xc
#define CG_SPLL_FUNC_CNTL_5__PFD_RESET_CNTRL__SHIFT 0x2
#define CG_SPLL_FUNC_CNTL_5__RESET_TIMER_MASK 0x30
#define CG_SPLL_FUNC_CNTL_5__RESET_TIMER__SHIFT 0x4
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_CNTRL_MASK 0xc0
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_CNTRL__SHIFT 0x6
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_EN_MASK 0x100
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_EN__SHIFT 0x8
#define CG_SPLL_FUNC_CNTL_5__RESET_ANTI_MUX_MASK 0x200
#define CG_SPLL_FUNC_CNTL_5__RESET_ANTI_MUX__SHIFT 0x9
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX0_CLKOFF_CNT_MASK 0xff
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX0_CLKOFF_CNT__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX1_CLKOFF_CNT_MASK 0xff00
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX1_CLKOFF_CNT__SHIFT 0x8
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_EN_MASK 0x10000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_EN__SHIFT 0x10
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_IN_MASK 0x1e0000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_IN__SHIFT 0x11
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_OUT_MASK 0x1e00000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_OUT__SHIFT 0x15
#define CG_SPLL_FUNC_CNTL_6__SPLL_LF_CNTR_MASK 0xfe000000
#define CG_SPLL_FUNC_CNTL_6__SPLL_LF_CNTR__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_7__SPLL_BW_CNTRL_MASK 0xfff
#define CG_SPLL_FUNC_CNTL_7__SPLL_BW_CNTRL__SHIFT 0x0
#define SPLL_CNTL_MODE__SPLL_SW_DIR_CONTROL_MASK 0x1
#define SPLL_CNTL_MODE__SPLL_SW_DIR_CONTROL__SHIFT 0x0
#define SPLL_CNTL_MODE__SPLL_LEGACY_PDIV_MASK 0x2
#define SPLL_CNTL_MODE__SPLL_LEGACY_PDIV__SHIFT 0x1
#define SPLL_CNTL_MODE__SPLL_TEST_MASK 0x4
#define SPLL_CNTL_MODE__SPLL_TEST__SHIFT 0x2
#define SPLL_CNTL_MODE__SPLL_FASTEN_MASK 0x8
#define SPLL_CNTL_MODE__SPLL_FASTEN__SHIFT 0x3
#define SPLL_CNTL_MODE__SPLL_ENSAT_MASK 0x10
#define SPLL_CNTL_MODE__SPLL_ENSAT__SHIFT 0x4
#define SPLL_CNTL_MODE__SPLL_TEST_CLK_EXT_DIV_MASK 0xc00
#define SPLL_CNTL_MODE__SPLL_TEST_CLK_EXT_DIV__SHIFT 0xa
#define SPLL_CNTL_MODE__SPLL_CTLREQ_DLY_CNT_MASK 0xff000
#define SPLL_CNTL_MODE__SPLL_CTLREQ_DLY_CNT__SHIFT 0xc
#define SPLL_CNTL_MODE__SPLL_RESET_EN_MASK 0x10000000
#define SPLL_CNTL_MODE__SPLL_RESET_EN__SHIFT 0x1c
#define SPLL_CNTL_MODE__SPLL_VCO_MODE_MASK 0x60000000
#define SPLL_CNTL_MODE__SPLL_VCO_MODE__SHIFT 0x1d
#define CG_SPLL_SPREAD_SPECTRUM__SSEN_MASK 0x1
#define CG_SPLL_SPREAD_SPECTRUM__SSEN__SHIFT 0x0
#define CG_SPLL_SPREAD_SPECTRUM__CLKS_MASK 0xfff0
#define CG_SPLL_SPREAD_SPECTRUM__CLKS__SHIFT 0x4
#define CG_SPLL_SPREAD_SPECTRUM_2__CLKV_MASK 0x3ffffff
#define CG_SPLL_SPREAD_SPECTRUM_2__CLKV__SHIFT 0x0
#define MPLL_BYPASSCLK_SEL__MPLL_CLKOUT_SEL_MASK 0xff00
#define MPLL_BYPASSCLK_SEL__MPLL_CLKOUT_SEL__SHIFT 0x8
#define CG_CLKPIN_CNTL__XTALIN_DIVIDE_MASK 0x2
#define CG_CLKPIN_CNTL__XTALIN_DIVIDE__SHIFT 0x1
#define CG_CLKPIN_CNTL__BCLK_AS_XCLK_MASK 0x4
#define CG_CLKPIN_CNTL__BCLK_AS_XCLK__SHIFT 0x2
#define CG_CLKPIN_CNTL_2__ENABLE_XCLK_MASK 0x1
#define CG_CLKPIN_CNTL_2__ENABLE_XCLK__SHIFT 0x0
#define CG_CLKPIN_CNTL_2__FORCE_BIF_REFCLK_EN_MASK 0x8
#define CG_CLKPIN_CNTL_2__FORCE_BIF_REFCLK_EN__SHIFT 0x3
#define CG_CLKPIN_CNTL_2__MUX_TCLK_TO_XCLK_MASK 0x100
#define CG_CLKPIN_CNTL_2__MUX_TCLK_TO_XCLK__SHIFT 0x8
#define CG_CLKPIN_CNTL_2__XO_IN_OSCIN_EN_MASK 0x4000
#define CG_CLKPIN_CNTL_2__XO_IN_OSCIN_EN__SHIFT 0xe
#define CG_CLKPIN_CNTL_2__XO_IN_ICORE_CLK_OE_MASK 0x8000
#define CG_CLKPIN_CNTL_2__XO_IN_ICORE_CLK_OE__SHIFT 0xf
#define CG_CLKPIN_CNTL_2__XO_IN_CML_RXEN_MASK 0x10000
#define CG_CLKPIN_CNTL_2__XO_IN_CML_RXEN__SHIFT 0x10
#define CG_CLKPIN_CNTL_2__XO_IN_BIDIR_CML_OE_MASK 0x20000
#define CG_CLKPIN_CNTL_2__XO_IN_BIDIR_CML_OE__SHIFT 0x11
#define CG_CLKPIN_CNTL_2__XO_IN2_OSCIN_EN_MASK 0x40000
#define CG_CLKPIN_CNTL_2__XO_IN2_OSCIN_EN__SHIFT 0x12
#define CG_CLKPIN_CNTL_2__XO_IN2_ICORE_CLK_OE_MASK 0x80000
#define CG_CLKPIN_CNTL_2__XO_IN2_ICORE_CLK_OE__SHIFT 0x13
#define CG_CLKPIN_CNTL_2__XO_IN2_CML_RXEN_MASK 0x100000
#define CG_CLKPIN_CNTL_2__XO_IN2_CML_RXEN__SHIFT 0x14
#define CG_CLKPIN_CNTL_2__XO_IN2_BIDIR_CML_OE_MASK 0x200000
#define CG_CLKPIN_CNTL_2__XO_IN2_BIDIR_CML_OE__SHIFT 0x15
#define CG_CLKPIN_CNTL_2__CML_CTRL_MASK 0xc00000
#define CG_CLKPIN_CNTL_2__CML_CTRL__SHIFT 0x16
#define CG_CLKPIN_CNTL_2__CLK_SPARE_MASK 0xff000000
#define CG_CLKPIN_CNTL_2__CLK_SPARE__SHIFT 0x18
#define CG_CLKPIN_CNTL_DC__OSC_EN_MASK 0x1
#define CG_CLKPIN_CNTL_DC__OSC_EN__SHIFT 0x0
#define CG_CLKPIN_CNTL_DC__XTL_LOW_GAIN_MASK 0x6
#define CG_CLKPIN_CNTL_DC__XTL_LOW_GAIN__SHIFT 0x1
#define CG_CLKPIN_CNTL_DC__XTL_XOCLK_DRV_R_EN_MASK 0x200
#define CG_CLKPIN_CNTL_DC__XTL_XOCLK_DRV_R_EN__SHIFT 0x9
#define CG_CLKPIN_CNTL_DC__XTALIN_SEL_MASK 0x1c00
#define CG_CLKPIN_CNTL_DC__XTALIN_SEL__SHIFT 0xa
#define THM_CLK_CNTL__CMON_CLK_SEL_MASK 0xff
#define THM_CLK_CNTL__CMON_CLK_SEL__SHIFT 0x0
#define THM_CLK_CNTL__TMON_CLK_SEL_MASK 0xff00
#define THM_CLK_CNTL__TMON_CLK_SEL__SHIFT 0x8
#define THM_CLK_CNTL__CTF_CLK_SHUTOFF_EN_MASK 0x10000
#define THM_CLK_CNTL__CTF_CLK_SHUTOFF_EN__SHIFT 0x10
#define MISC_CLK_CTRL__DEEP_SLEEP_CLK_SEL_MASK 0xff
#define MISC_CLK_CTRL__DEEP_SLEEP_CLK_SEL__SHIFT 0x0
#define MISC_CLK_CTRL__ZCLK_SEL_MASK 0xff00
#define MISC_CLK_CTRL__ZCLK_SEL__SHIFT 0x8
#define MISC_CLK_CTRL__DFT_SMS_PG_CLK_SEL_MASK 0xff0000
#define MISC_CLK_CTRL__DFT_SMS_PG_CLK_SEL__SHIFT 0x10
#define GCK_PLL_TEST_CNTL__TST_SRC_SEL_MASK 0x1f
#define GCK_PLL_TEST_CNTL__TST_SRC_SEL__SHIFT 0x0
#define GCK_PLL_TEST_CNTL__TST_REF_SEL_MASK 0x3e0
#define GCK_PLL_TEST_CNTL__TST_REF_SEL__SHIFT 0x5
#define GCK_PLL_TEST_CNTL__REF_TEST_COUNT_MASK 0x1fc00
#define GCK_PLL_TEST_CNTL__REF_TEST_COUNT__SHIFT 0xa
#define GCK_PLL_TEST_CNTL__TST_RESET_MASK 0x20000
#define GCK_PLL_TEST_CNTL__TST_RESET__SHIFT 0x11
#define GCK_PLL_TEST_CNTL__TST_CLK_SEL_MODE_MASK 0x40000
#define GCK_PLL_TEST_CNTL__TST_CLK_SEL_MODE__SHIFT 0x12
#define GCK_PLL_TEST_CNTL_2__TEST_COUNT_MASK 0xfffe0000
#define GCK_PLL_TEST_CNTL_2__TEST_COUNT__SHIFT 0x11
#define GCK_ADFS_CLK_BYPASS_CNTL1__ECLK_BYPASS_CNTL_MASK 0x7
#define GCK_ADFS_CLK_BYPASS_CNTL1__ECLK_BYPASS_CNTL__SHIFT 0x0
#define GCK_ADFS_CLK_BYPASS_CNTL1__SCLK_BYPASS_CNTL_MASK 0x38
#define GCK_ADFS_CLK_BYPASS_CNTL1__SCLK_BYPASS_CNTL__SHIFT 0x3
#define GCK_ADFS_CLK_BYPASS_CNTL1__LCLK_BYPASS_CNTL_MASK 0x1c0
#define GCK_ADFS_CLK_BYPASS_CNTL1__LCLK_BYPASS_CNTL__SHIFT 0x6
#define GCK_ADFS_CLK_BYPASS_CNTL1__DCLK_BYPASS_CNTL_MASK 0xe00
#define GCK_ADFS_CLK_BYPASS_CNTL1__DCLK_BYPASS_CNTL__SHIFT 0x9
#define GCK_ADFS_CLK_BYPASS_CNTL1__VCLK_BYPASS_CNTL_MASK 0x7000
#define GCK_ADFS_CLK_BYPASS_CNTL1__VCLK_BYPASS_CNTL__SHIFT 0xc
#define GCK_ADFS_CLK_BYPASS_CNTL1__DISPCLK_BYPASS_CNTL_MASK 0x38000
#define GCK_ADFS_CLK_BYPASS_CNTL1__DISPCLK_BYPASS_CNTL__SHIFT 0xf
#define GCK_ADFS_CLK_BYPASS_CNTL1__DRREFCLK_BYPASS_CNTL_MASK 0x1c0000
#define GCK_ADFS_CLK_BYPASS_CNTL1__DRREFCLK_BYPASS_CNTL__SHIFT 0x12
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_BYPASS_CNTL_MASK 0xe00000
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_BYPASS_CNTL__SHIFT 0x15
#define GCK_ADFS_CLK_BYPASS_CNTL1__SAMCLK_BYPASS_CNTL_MASK 0x7000000
#define GCK_ADFS_CLK_BYPASS_CNTL1__SAMCLK_BYPASS_CNTL__SHIFT 0x18
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_DIV_BYPASS_CNTL_MASK 0x38000000
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_DIV_BYPASS_CNTL__SHIFT 0x1b
#define SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_0__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_0__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_0__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_0__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_1__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_1__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_1__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_1__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_2__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_2__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_2__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_2__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_3__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_3__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_3__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_3__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_4__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_4__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_4__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_4__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_5__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_5__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_5__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_5__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_6__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_6__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_6__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_6__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_7__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_7__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_7__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_7__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_0_MASK 0x1
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_0__SHIFT 0x0
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_1_MASK 0x2
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_1__SHIFT 0x1
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_2_MASK 0x4
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_2__SHIFT 0x2
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_3_MASK 0x8
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_3__SHIFT 0x3
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_4_MASK 0x10
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_4__SHIFT 0x4
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_5_MASK 0x20
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_5__SHIFT 0x5
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_6_MASK 0x40
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_6__SHIFT 0x6
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_7_MASK 0x80
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_7__SHIFT 0x7
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_8_MASK 0x100
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_8__SHIFT 0x8
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_9_MASK 0x200
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_9__SHIFT 0x9
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_10_MASK 0x400
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_10__SHIFT 0xa
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_11_MASK 0x800
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_11__SHIFT 0xb
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_12_MASK 0x1000
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_12__SHIFT 0xc
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_13_MASK 0x2000
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_13__SHIFT 0xd
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_14_MASK 0x4000
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_14__SHIFT 0xe
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_15_MASK 0x8000
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_15__SHIFT 0xf
#define SMC_MESSAGE_0__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_0__SMC_MSG__SHIFT 0x0
#define SMC_RESP_0__SMC_RESP_MASK 0xffff
#define SMC_RESP_0__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_1__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_1__SMC_MSG__SHIFT 0x0
#define SMC_RESP_1__SMC_RESP_MASK 0xffff
#define SMC_RESP_1__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_2__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_2__SMC_MSG__SHIFT 0x0
#define SMC_RESP_2__SMC_RESP_MASK 0xffff
#define SMC_RESP_2__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_3__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_3__SMC_MSG__SHIFT 0x0
#define SMC_RESP_3__SMC_RESP_MASK 0xffff
#define SMC_RESP_3__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_4__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_4__SMC_MSG__SHIFT 0x0
#define SMC_RESP_4__SMC_RESP_MASK 0xffff
#define SMC_RESP_4__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_5__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_5__SMC_MSG__SHIFT 0x0
#define SMC_RESP_5__SMC_RESP_MASK 0xffff
#define SMC_RESP_5__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_6__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_6__SMC_MSG__SHIFT 0x0
#define SMC_RESP_6__SMC_RESP_MASK 0xffff
#define SMC_RESP_6__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_7__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_7__SMC_MSG__SHIFT 0x0
#define SMC_RESP_7__SMC_RESP_MASK 0xffff
#define SMC_RESP_7__SMC_RESP__SHIFT 0x0
#define SMC_MSG_ARG_0__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_0__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_1__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_1__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_2__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_2__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_3__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_3__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_4__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_4__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_5__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_5__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_6__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_6__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_7__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_7__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MESSAGE_8__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_8__SMC_MSG__SHIFT 0x0
#define SMC_RESP_8__SMC_RESP_MASK 0xffff
#define SMC_RESP_8__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_9__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_9__SMC_MSG__SHIFT 0x0
#define SMC_RESP_9__SMC_RESP_MASK 0xffff
#define SMC_RESP_9__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_10__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_10__SMC_MSG__SHIFT 0x0
#define SMC_RESP_10__SMC_RESP_MASK 0xffff
#define SMC_RESP_10__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_11__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_11__SMC_MSG__SHIFT 0x0
#define SMC_RESP_11__SMC_RESP_MASK 0xffff
#define SMC_RESP_11__SMC_RESP__SHIFT 0x0
#define SMC_MSG_ARG_8__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_8__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_9__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_9__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_10__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_10__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_11__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_11__SMC_MSG_ARG__SHIFT 0x0
#define SMC_SYSCON_RESET_CNTL__rst_reg_MASK 0x1
#define SMC_SYSCON_RESET_CNTL__rst_reg__SHIFT 0x0
#define SMC_SYSCON_RESET_CNTL__srbm_soft_rst_override_MASK 0x2
#define SMC_SYSCON_RESET_CNTL__srbm_soft_rst_override__SHIFT 0x1
#define SMC_SYSCON_RESET_CNTL__RegReset_MASK 0x40000000
#define SMC_SYSCON_RESET_CNTL__RegReset__SHIFT 0x1e
#define SMC_SYSCON_CLOCK_CNTL_0__ck_disable_MASK 0x1
#define SMC_SYSCON_CLOCK_CNTL_0__ck_disable__SHIFT 0x0
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_en_MASK 0x2
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_en__SHIFT 0x1
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_timeout_MASK 0xffff00
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_timeout__SHIFT 0x8
#define SMC_SYSCON_CLOCK_CNTL_0__cken_MASK 0x1000000
#define SMC_SYSCON_CLOCK_CNTL_0__cken__SHIFT 0x18
#define SMC_SYSCON_CLOCK_CNTL_1__auto_ck_disable_MASK 0x1
#define SMC_SYSCON_CLOCK_CNTL_1__auto_ck_disable__SHIFT 0x0
#define SMC_SYSCON_CLOCK_CNTL_2__wake_on_irq_MASK 0xffffffff
#define SMC_SYSCON_CLOCK_CNTL_2__wake_on_irq__SHIFT 0x0
#define SMC_SYSCON_MISC_CNTL__dma_no_outstanding_MASK 0x2
#define SMC_SYSCON_MISC_CNTL__dma_no_outstanding__SHIFT 0x1
#define SMC_SYSCON_MSG_ARG_0__smc_msg_arg_MASK 0xffffffff
#define SMC_SYSCON_MSG_ARG_0__smc_msg_arg__SHIFT 0x0
#define SMC_PC_C__smc_pc_c_MASK 0xffffffff
#define SMC_PC_C__smc_pc_c__SHIFT 0x0
#define SMC_SCRATCH9__SCRATCH_VALUE_MASK 0xffffffff
#define SMC_SCRATCH9__SCRATCH_VALUE__SHIFT 0x0
#define GPIOPAD_SW_INT_STAT__SW_INT_STAT_MASK 0x1
#define GPIOPAD_SW_INT_STAT__SW_INT_STAT__SHIFT 0x0
#define GPIOPAD_STRENGTH__GPIO_STRENGTH_SN_MASK 0xf
#define GPIOPAD_STRENGTH__GPIO_STRENGTH_SN__SHIFT 0x0
#define GPIOPAD_STRENGTH__GPIO_STRENGTH_SP_MASK 0xf0
#define GPIOPAD_STRENGTH__GPIO_STRENGTH_SP__SHIFT 0x4
#define GPIOPAD_MASK__GPIO_MASK_MASK 0x7fffffff
#define GPIOPAD_MASK__GPIO_MASK__SHIFT 0x0
#define GPIOPAD_A__GPIO_A_MASK 0x7fffffff
#define GPIOPAD_A__GPIO_A__SHIFT 0x0
#define GPIOPAD_EN__GPIO_EN_MASK 0x7fffffff
#define GPIOPAD_EN__GPIO_EN__SHIFT 0x0
#define GPIOPAD_Y__GPIO_Y_MASK 0x7fffffff
#define GPIOPAD_Y__GPIO_Y__SHIFT 0x0
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_0_MASK 0x1
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_0__SHIFT 0x0
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_1_MASK 0x2
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_1__SHIFT 0x1
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_2_MASK 0x4
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_2__SHIFT 0x2
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_3_MASK 0x8
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_3__SHIFT 0x3
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_4_MASK 0x10
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_4__SHIFT 0x4
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_5_MASK 0x20
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_5__SHIFT 0x5
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_6_MASK 0x40
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_6__SHIFT 0x6
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_7_MASK 0x80
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_7__SHIFT 0x7
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_8_MASK 0x100
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_8__SHIFT 0x8
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_9_MASK 0x200
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_9__SHIFT 0x9
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_10_MASK 0x400
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_10__SHIFT 0xa
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_11_MASK 0x800
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_11__SHIFT 0xb
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_12_MASK 0x1000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_12__SHIFT 0xc
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_13_MASK 0x2000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_13__SHIFT 0xd
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_14_MASK 0x4000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_14__SHIFT 0xe
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_15_MASK 0x8000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_15__SHIFT 0xf
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_16_MASK 0x10000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_16__SHIFT 0x10
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_17_MASK 0x20000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_17__SHIFT 0x11
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_18_MASK 0x40000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_18__SHIFT 0x12
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_19_MASK 0x80000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_19__SHIFT 0x13
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_20_MASK 0x100000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_20__SHIFT 0x14
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_21_MASK 0x200000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_21__SHIFT 0x15
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_22_MASK 0x400000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_22__SHIFT 0x16
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_23_MASK 0x800000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_23__SHIFT 0x17
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_24_MASK 0x1000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_24__SHIFT 0x18
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_25_MASK 0x2000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_25__SHIFT 0x19
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_26_MASK 0x4000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_26__SHIFT 0x1a
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_27_MASK 0x8000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_27__SHIFT 0x1b
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_28_MASK 0x10000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_28__SHIFT 0x1c
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_29_MASK 0x20000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_29__SHIFT 0x1d
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_30_MASK 0x40000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_30__SHIFT 0x1e
#define GPIOPAD_INT_STAT_EN__GPIO_INT_STAT_EN_MASK 0x1fffffff
#define GPIOPAD_INT_STAT_EN__GPIO_INT_STAT_EN__SHIFT 0x0
#define GPIOPAD_INT_STAT_EN__SW_INITIATED_INT_STAT_EN_MASK 0x80000000
#define GPIOPAD_INT_STAT_EN__SW_INITIATED_INT_STAT_EN__SHIFT 0x1f
#define GPIOPAD_INT_STAT__GPIO_INT_STAT_MASK 0x1fffffff
#define GPIOPAD_INT_STAT__GPIO_INT_STAT__SHIFT 0x0
#define GPIOPAD_INT_STAT__SW_INITIATED_INT_STAT_MASK 0x80000000
#define GPIOPAD_INT_STAT__SW_INITIATED_INT_STAT__SHIFT 0x1f
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_0_MASK 0x1
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_0__SHIFT 0x0
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_1_MASK 0x2
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_1__SHIFT 0x1
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_2_MASK 0x4
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_2__SHIFT 0x2
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_3_MASK 0x8
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_3__SHIFT 0x3
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_4_MASK 0x10
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_4__SHIFT 0x4
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_5_MASK 0x20
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_5__SHIFT 0x5
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_6_MASK 0x40
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_6__SHIFT 0x6
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_7_MASK 0x80
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_7__SHIFT 0x7
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_8_MASK 0x100
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_8__SHIFT 0x8
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_9_MASK 0x200
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_9__SHIFT 0x9
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_10_MASK 0x400
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_10__SHIFT 0xa
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_11_MASK 0x800
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_11__SHIFT 0xb
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_12_MASK 0x1000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_12__SHIFT 0xc
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_13_MASK 0x2000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_13__SHIFT 0xd
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_14_MASK 0x4000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_14__SHIFT 0xe
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_15_MASK 0x8000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_15__SHIFT 0xf
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_16_MASK 0x10000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_16__SHIFT 0x10
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_17_MASK 0x20000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_17__SHIFT 0x11
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_18_MASK 0x40000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_18__SHIFT 0x12
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_19_MASK 0x80000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_19__SHIFT 0x13
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_20_MASK 0x100000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_20__SHIFT 0x14
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_21_MASK 0x200000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_21__SHIFT 0x15
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_22_MASK 0x400000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_22__SHIFT 0x16
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_23_MASK 0x800000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_23__SHIFT 0x17
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_24_MASK 0x1000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_24__SHIFT 0x18
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_25_MASK 0x2000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_25__SHIFT 0x19
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_26_MASK 0x4000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_26__SHIFT 0x1a
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_27_MASK 0x8000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_27__SHIFT 0x1b
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_28_MASK 0x10000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_28__SHIFT 0x1c
#define GPIOPAD_INT_STAT_AK__SW_INITIATED_INT_STAT_AK_MASK 0x80000000
#define GPIOPAD_INT_STAT_AK__SW_INITIATED_INT_STAT_AK__SHIFT 0x1f
#define GPIOPAD_INT_EN__GPIO_INT_EN_MASK 0x1fffffff
#define GPIOPAD_INT_EN__GPIO_INT_EN__SHIFT 0x0
#define GPIOPAD_INT_EN__SW_INITIATED_INT_EN_MASK 0x80000000
#define GPIOPAD_INT_EN__SW_INITIATED_INT_EN__SHIFT 0x1f
#define GPIOPAD_INT_TYPE__GPIO_INT_TYPE_MASK 0x1fffffff
#define GPIOPAD_INT_TYPE__GPIO_INT_TYPE__SHIFT 0x0
#define GPIOPAD_INT_TYPE__SW_INITIATED_INT_TYPE_MASK 0x80000000
#define GPIOPAD_INT_TYPE__SW_INITIATED_INT_TYPE__SHIFT 0x1f
#define GPIOPAD_INT_POLARITY__GPIO_INT_POLARITY_MASK 0x1fffffff
#define GPIOPAD_INT_POLARITY__GPIO_INT_POLARITY__SHIFT 0x0
#define GPIOPAD_INT_POLARITY__SW_INITIATED_INT_POLARITY_MASK 0x80000000
#define GPIOPAD_INT_POLARITY__SW_INITIATED_INT_POLARITY__SHIFT 0x1f
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_SEL_MASK 0x1f
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_SEL__SHIFT 0x0
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_CLR_MASK 0x20
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_CLR__SHIFT 0x5
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_READ_MASK 0x40
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_READ__SHIFT 0x6
#define GPIOPAD_RCVR_SEL__GPIO_RCVR_SEL_MASK 0x7fffffff
#define GPIOPAD_RCVR_SEL__GPIO_RCVR_SEL__SHIFT 0x0
#define GPIOPAD_PU_EN__GPIO_PU_EN_MASK 0x7fffffff
#define GPIOPAD_PU_EN__GPIO_PU_EN__SHIFT 0x0
#define GPIOPAD_PD_EN__GPIO_PD_EN_MASK 0x7fffffff
#define GPIOPAD_PD_EN__GPIO_PD_EN__SHIFT 0x0
#define CG_FPS_CNT__FPS_CNT_MASK 0xffffffff
#define CG_FPS_CNT__FPS_CNT__SHIFT 0x0
#define SMU_IND_INDEX_0__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_IND_INDEX_0__SMC_IND_ADDR__SHIFT 0x0
#define SMU_IND_DATA_0__SMC_IND_DATA_MASK 0xffffffff
#define SMU_IND_DATA_0__SMC_IND_DATA__SHIFT 0x0
#define SMU_IND_INDEX_1__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_IND_INDEX_1__SMC_IND_ADDR__SHIFT 0x0
#define SMU_IND_DATA_1__SMC_IND_DATA_MASK 0xffffffff
#define SMU_IND_DATA_1__SMC_IND_DATA__SHIFT 0x0
#define SMU_IND_INDEX_2__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_IND_INDEX_2__SMC_IND_ADDR__SHIFT 0x0
#define SMU_IND_DATA_2__SMC_IND_DATA_MASK 0xffffffff
#define SMU_IND_DATA_2__SMC_IND_DATA__SHIFT 0x0
#define SMU_IND_INDEX_3__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_IND_INDEX_3__SMC_IND_ADDR__SHIFT 0x0
#define SMU_IND_DATA_3__SMC_IND_DATA_MASK 0xffffffff
#define SMU_IND_DATA_3__SMC_IND_DATA__SHIFT 0x0
#define SMU_IND_INDEX_4__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_IND_INDEX_4__SMC_IND_ADDR__SHIFT 0x0
#define SMU_IND_DATA_4__SMC_IND_DATA_MASK 0xffffffff
#define SMU_IND_DATA_4__SMC_IND_DATA__SHIFT 0x0
#define SMU_IND_INDEX_5__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_IND_INDEX_5__SMC_IND_ADDR__SHIFT 0x0
#define SMU_IND_DATA_5__SMC_IND_DATA_MASK 0xffffffff
#define SMU_IND_DATA_5__SMC_IND_DATA__SHIFT 0x0
#define SMU_IND_INDEX_6__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_IND_INDEX_6__SMC_IND_ADDR__SHIFT 0x0
#define SMU_IND_DATA_6__SMC_IND_DATA_MASK 0xffffffff
#define SMU_IND_DATA_6__SMC_IND_DATA__SHIFT 0x0
#define SMU_IND_INDEX_7__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_IND_INDEX_7__SMC_IND_ADDR__SHIFT 0x0
#define SMU_IND_DATA_7__SMC_IND_DATA_MASK 0xffffffff
#define SMU_IND_DATA_7__SMC_IND_DATA__SHIFT 0x0
#define SMU_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define SMU_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define SMU_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define RCU_UC_EVENTS__RCU_TST_jpc_rep_req_MASK 0x1
#define RCU_UC_EVENTS__RCU_TST_jpc_rep_req__SHIFT 0x0
#define RCU_UC_EVENTS__TST_RCU_jpc_rep_done_MASK 0x2
#define RCU_UC_EVENTS__TST_RCU_jpc_rep_done__SHIFT 0x1
#define RCU_UC_EVENTS__drv_rst_mode_MASK 0x4
#define RCU_UC_EVENTS__drv_rst_mode__SHIFT 0x2
#define RCU_UC_EVENTS__SMU_DC_efuse_status_invalid_MASK 0x8
#define RCU_UC_EVENTS__SMU_DC_efuse_status_invalid__SHIFT 0x3
#define RCU_UC_EVENTS__TP_Tester_MASK 0x40
#define RCU_UC_EVENTS__TP_Tester__SHIFT 0x6
#define RCU_UC_EVENTS__boot_seq_done_MASK 0x80
#define RCU_UC_EVENTS__boot_seq_done__SHIFT 0x7
#define RCU_UC_EVENTS__sclk_deep_sleep_exit_MASK 0x100
#define RCU_UC_EVENTS__sclk_deep_sleep_exit__SHIFT 0x8
#define RCU_UC_EVENTS__BREAK_PT1_ACTIVE_MASK 0x200
#define RCU_UC_EVENTS__BREAK_PT1_ACTIVE__SHIFT 0x9
#define RCU_UC_EVENTS__BREAK_PT2_ACTIVE_MASK 0x400
#define RCU_UC_EVENTS__BREAK_PT2_ACTIVE__SHIFT 0xa
#define RCU_UC_EVENTS__FCH_HALT_MASK 0x800
#define RCU_UC_EVENTS__FCH_HALT__SHIFT 0xb
#define RCU_UC_EVENTS__RCU_GIO_fch_lockdown_MASK 0x2000
#define RCU_UC_EVENTS__RCU_GIO_fch_lockdown__SHIFT 0xd
#define RCU_UC_EVENTS__INTERRUPTS_ENABLED_MASK 0x10000
#define RCU_UC_EVENTS__INTERRUPTS_ENABLED__SHIFT 0x10
#define RCU_UC_EVENTS__RCU_DtmCnt0_Done_MASK 0x20000
#define RCU_UC_EVENTS__RCU_DtmCnt0_Done__SHIFT 0x11
#define RCU_UC_EVENTS__RCU_DtmCnt1_Done_MASK 0x40000
#define RCU_UC_EVENTS__RCU_DtmCnt1_Done__SHIFT 0x12
#define RCU_UC_EVENTS__RCU_DtmCnt2_Done_MASK 0x80000
#define RCU_UC_EVENTS__RCU_DtmCnt2_Done__SHIFT 0x13
#define RCU_UC_EVENTS__irq31_sel_MASK 0x3000000
#define RCU_UC_EVENTS__irq31_sel__SHIFT 0x18
#define RCU_MISC_CTRL__REG_DRV_RST_MODE_MASK 0x2
#define RCU_MISC_CTRL__REG_DRV_RST_MODE__SHIFT 0x1
#define RCU_MISC_CTRL__REG_RCU_MEMREP_DIS_MASK 0x8
#define RCU_MISC_CTRL__REG_RCU_MEMREP_DIS__SHIFT 0x3
#define RCU_MISC_CTRL__REG_CC_FUSE_DISABLE_MASK 0x10
#define RCU_MISC_CTRL__REG_CC_FUSE_DISABLE__SHIFT 0x4
#define RCU_MISC_CTRL__REG_SAMU_FUSE_DISABLE_MASK 0x20
#define RCU_MISC_CTRL__REG_SAMU_FUSE_DISABLE__SHIFT 0x5
#define RCU_MISC_CTRL__REG_CC_SRBM_RD_DISABLE_MASK 0x100
#define RCU_MISC_CTRL__REG_CC_SRBM_RD_DISABLE__SHIFT 0x8
#define RCU_MISC_CTRL__BREAK_PT1_DONE_MASK 0x10000
#define RCU_MISC_CTRL__BREAK_PT1_DONE__SHIFT 0x10
#define RCU_MISC_CTRL__BREAK_PT2_DONE_MASK 0x20000
#define RCU_MISC_CTRL__BREAK_PT2_DONE__SHIFT 0x11
#define RCU_MISC_CTRL__SAMU_START_MASK 0x400000
#define RCU_MISC_CTRL__SAMU_START__SHIFT 0x16
#define RCU_MISC_CTRL__RST_PULSE_WIDTH_MASK 0xff800000
#define RCU_MISC_CTRL__RST_PULSE_WIDTH__SHIFT 0x17
#define RCU_VIRT_RESET_REQ__VF_MASK 0xffff
#define RCU_VIRT_RESET_REQ__VF__SHIFT 0x0
#define RCU_VIRT_RESET_REQ__PF_MASK 0x80000000
#define RCU_VIRT_RESET_REQ__PF__SHIFT 0x1f
#define CC_RCU_FUSES__GPU_DIS_MASK 0x2
#define CC_RCU_FUSES__GPU_DIS__SHIFT 0x1
#define CC_RCU_FUSES__DEBUG_DISABLE_MASK 0x4
#define CC_RCU_FUSES__DEBUG_DISABLE__SHIFT 0x2
#define CC_RCU_FUSES__EFUSE_RD_DISABLE_MASK 0x10
#define CC_RCU_FUSES__EFUSE_RD_DISABLE__SHIFT 0x4
#define CC_RCU_FUSES__CG_RST_GLB_REQ_DIS_MASK 0x20
#define CC_RCU_FUSES__CG_RST_GLB_REQ_DIS__SHIFT 0x5
#define CC_RCU_FUSES__DRV_RST_MODE_MASK 0x40
#define CC_RCU_FUSES__DRV_RST_MODE__SHIFT 0x6
#define CC_RCU_FUSES__ROM_DIS_MASK 0x80
#define CC_RCU_FUSES__ROM_DIS__SHIFT 0x7
#define CC_RCU_FUSES__JPC_REP_DISABLE_MASK 0x100
#define CC_RCU_FUSES__JPC_REP_DISABLE__SHIFT 0x8
#define CC_RCU_FUSES__RCU_BREAK_POINT1_MASK 0x200
#define CC_RCU_FUSES__RCU_BREAK_POINT1__SHIFT 0x9
#define CC_RCU_FUSES__RCU_BREAK_POINT2_MASK 0x400
#define CC_RCU_FUSES__RCU_BREAK_POINT2__SHIFT 0xa
#define CC_RCU_FUSES__SMU_IOC_MST_DISABLE_MASK 0x4000
#define CC_RCU_FUSES__SMU_IOC_MST_DISABLE__SHIFT 0xe
#define CC_RCU_FUSES__FCH_LOCKOUT_ENABLE_MASK 0x8000
#define CC_RCU_FUSES__FCH_LOCKOUT_ENABLE__SHIFT 0xf
#define CC_RCU_FUSES__FCH_XFIRE_FILTER_ENABLE_MASK 0x10000
#define CC_RCU_FUSES__FCH_XFIRE_FILTER_ENABLE__SHIFT 0x10
#define CC_RCU_FUSES__XFIRE_DISABLE_MASK 0x20000
#define CC_RCU_FUSES__XFIRE_DISABLE__SHIFT 0x11
#define CC_RCU_FUSES__SAMU_FUSE_DISABLE_MASK 0x40000
#define CC_RCU_FUSES__SAMU_FUSE_DISABLE__SHIFT 0x12
#define CC_RCU_FUSES__BIF_RST_POLLING_DISABLE_MASK 0x80000
#define CC_RCU_FUSES__BIF_RST_POLLING_DISABLE__SHIFT 0x13
#define CC_RCU_FUSES__MEM_HARDREP_EN_MASK 0x200000
#define CC_RCU_FUSES__MEM_HARDREP_EN__SHIFT 0x15
#define CC_RCU_FUSES__PCIE_INIT_DISABLE_MASK 0x400000
#define CC_RCU_FUSES__PCIE_INIT_DISABLE__SHIFT 0x16
#define CC_RCU_FUSES__DSMU_DISABLE_MASK 0x800000
#define CC_RCU_FUSES__DSMU_DISABLE__SHIFT 0x17
#define CC_RCU_FUSES__WRP_FUSE_VALID_MASK 0x1000000
#define CC_RCU_FUSES__WRP_FUSE_VALID__SHIFT 0x18
#define CC_RCU_FUSES__PHY_FUSE_VALID_MASK 0x2000000
#define CC_RCU_FUSES__PHY_FUSE_VALID__SHIFT 0x19
#define CC_RCU_FUSES__RCU_SPARE_MASK 0xfc000000
#define CC_RCU_FUSES__RCU_SPARE__SHIFT 0x1a
#define CC_SMU_MISC_FUSES__IOMMU_V2_DISABLE_MASK 0x2
#define CC_SMU_MISC_FUSES__IOMMU_V2_DISABLE__SHIFT 0x1
#define CC_SMU_MISC_FUSES__MinSClkDid_MASK 0x1fc
#define CC_SMU_MISC_FUSES__MinSClkDid__SHIFT 0x2
#define CC_SMU_MISC_FUSES__MISC_SPARE_MASK 0x600
#define CC_SMU_MISC_FUSES__MISC_SPARE__SHIFT 0x9
#define CC_SMU_MISC_FUSES__PostResetGnbClkDid_MASK 0x3f800
#define CC_SMU_MISC_FUSES__PostResetGnbClkDid__SHIFT 0xb
#define CC_SMU_MISC_FUSES__L2IMU_tn2_dtc_half_MASK 0x40000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_dtc_half__SHIFT 0x12
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_half_MASK 0x80000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_half__SHIFT 0x13
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_half_MASK 0x100000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_half__SHIFT 0x14
#define CC_SMU_MISC_FUSES__L2IMU_tn2_pdc_half_MASK 0x200000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_pdc_half__SHIFT 0x15
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_dis_MASK 0x400000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_dis__SHIFT 0x16
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_dis_MASK 0x800000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_dis__SHIFT 0x17
#define CC_SMU_MISC_FUSES__VCE_DISABLE_MASK 0x8000000
#define CC_SMU_MISC_FUSES__VCE_DISABLE__SHIFT 0x1b
#define CC_SMU_MISC_FUSES__IOC_IOMMU_DISABLE_MASK 0x10000000
#define CC_SMU_MISC_FUSES__IOC_IOMMU_DISABLE__SHIFT 0x1c
#define CC_SMU_MISC_FUSES__GNB_SPARE_MASK 0x60000000
#define CC_SMU_MISC_FUSES__GNB_SPARE__SHIFT 0x1d
#define CC_SCLK_VID_FUSES__SClkVid0_MASK 0xff
#define CC_SCLK_VID_FUSES__SClkVid0__SHIFT 0x0
#define CC_SCLK_VID_FUSES__SClkVid1_MASK 0xff00
#define CC_SCLK_VID_FUSES__SClkVid1__SHIFT 0x8
#define CC_SCLK_VID_FUSES__SClkVid2_MASK 0xff0000
#define CC_SCLK_VID_FUSES__SClkVid2__SHIFT 0x10
#define CC_SCLK_VID_FUSES__SClkVid3_MASK 0xff000000
#define CC_SCLK_VID_FUSES__SClkVid3__SHIFT 0x18
#define CC_GIO_IOCCFG_FUSES__NB_REV_ID_MASK 0x7fe
#define CC_GIO_IOCCFG_FUSES__NB_REV_ID__SHIFT 0x1
#define CC_GIO_IOC_FUSES__IOC_FUSES_MASK 0x3e
#define CC_GIO_IOC_FUSES__IOC_FUSES__SHIFT 0x1
#define CC_SMU_TST_EFUSE1_MISC__RF_RM_6_2_MASK 0x3e
#define CC_SMU_TST_EFUSE1_MISC__RF_RM_6_2__SHIFT 0x1
#define CC_SMU_TST_EFUSE1_MISC__RME_MASK 0x40
#define CC_SMU_TST_EFUSE1_MISC__RME__SHIFT 0x6
#define CC_SMU_TST_EFUSE1_MISC__MBIST_DISABLE_MASK 0x80
#define CC_SMU_TST_EFUSE1_MISC__MBIST_DISABLE__SHIFT 0x7
#define CC_SMU_TST_EFUSE1_MISC__HARD_REPAIR_DISABLE_MASK 0x100
#define CC_SMU_TST_EFUSE1_MISC__HARD_REPAIR_DISABLE__SHIFT 0x8
#define CC_SMU_TST_EFUSE1_MISC__SOFT_REPAIR_DISABLE_MASK 0x200
#define CC_SMU_TST_EFUSE1_MISC__SOFT_REPAIR_DISABLE__SHIFT 0x9
#define CC_SMU_TST_EFUSE1_MISC__GPU_DIS_MASK 0x400
#define CC_SMU_TST_EFUSE1_MISC__GPU_DIS__SHIFT 0xa
#define CC_SMU_TST_EFUSE1_MISC__SMS_PWRDWN_DISABLE_MASK 0x800
#define CC_SMU_TST_EFUSE1_MISC__SMS_PWRDWN_DISABLE__SHIFT 0xb
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISA_MASK 0x1000
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISA__SHIFT 0xc
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISB_MASK 0x2000
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISB__SHIFT 0xd
#define CC_SMU_TST_EFUSE1_MISC__RM_RF8_MASK 0x4000
#define CC_SMU_TST_EFUSE1_MISC__RM_RF8__SHIFT 0xe
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE1_MASK 0x400000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE1__SHIFT 0x16
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE2_MASK 0x800000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE2__SHIFT 0x17
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE3_MASK 0x1000000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE3__SHIFT 0x18
#define CC_SMU_TST_EFUSE1_MISC__VCE_DISABLE_MASK 0x2000000
#define CC_SMU_TST_EFUSE1_MISC__VCE_DISABLE__SHIFT 0x19
#define CC_SMU_TST_EFUSE1_MISC__DCE_SCAN_DISABLE_MASK 0x4000000
#define CC_SMU_TST_EFUSE1_MISC__DCE_SCAN_DISABLE__SHIFT 0x1a
#define CC_TST_ID_STRAPS__DEVICE_ID_MASK 0xffff0
#define CC_TST_ID_STRAPS__DEVICE_ID__SHIFT 0x4
#define CC_TST_ID_STRAPS__MAJOR_REV_ID_MASK 0xf00000
#define CC_TST_ID_STRAPS__MAJOR_REV_ID__SHIFT 0x14
#define CC_TST_ID_STRAPS__MINOR_REV_ID_MASK 0xf000000
#define CC_TST_ID_STRAPS__MINOR_REV_ID__SHIFT 0x18
#define CC_TST_ID_STRAPS__ATI_REV_ID_MASK 0xf0000000
#define CC_TST_ID_STRAPS__ATI_REV_ID__SHIFT 0x1c
#define CC_FCTRL_FUSES__EXT_EFUSE_MACRO_PRESENT_MASK 0x2
#define CC_FCTRL_FUSES__EXT_EFUSE_MACRO_PRESENT__SHIFT 0x1
#define CC_HARVEST_FUSES__VCE_DISABLE_MASK 0x6
#define CC_HARVEST_FUSES__VCE_DISABLE__SHIFT 0x1
#define CC_HARVEST_FUSES__UVD_DISABLE_MASK 0x10
#define CC_HARVEST_FUSES__UVD_DISABLE__SHIFT 0x4
#define CC_HARVEST_FUSES__ACP_DISABLE_MASK 0x40
#define CC_HARVEST_FUSES__ACP_DISABLE__SHIFT 0x6
#define CC_HARVEST_FUSES__DC_DISABLE_MASK 0x3f00
#define CC_HARVEST_FUSES__DC_DISABLE__SHIFT 0x8
#define SMU_MAIN_PLL_OP_FREQ__PLL_OP_FREQ_MASK 0xffffffff
#define SMU_MAIN_PLL_OP_FREQ__PLL_OP_FREQ__SHIFT 0x0
#define SMU_STATUS__SMU_DONE_MASK 0x1
#define SMU_STATUS__SMU_DONE__SHIFT 0x0
#define SMU_STATUS__SMU_PASS_MASK 0x2
#define SMU_STATUS__SMU_PASS__SHIFT 0x1
#define SMU_FIRMWARE__SMU_IN_PROG_MASK 0x1
#define SMU_FIRMWARE__SMU_IN_PROG__SHIFT 0x0
#define SMU_FIRMWARE__SMU_RD_DONE_MASK 0x6
#define SMU_FIRMWARE__SMU_RD_DONE__SHIFT 0x1
#define SMU_FIRMWARE__SMU_SRAM_RD_BLOCK_EN_MASK 0x8
#define SMU_FIRMWARE__SMU_SRAM_RD_BLOCK_EN__SHIFT 0x3
#define SMU_FIRMWARE__SMU_SRAM_WR_BLOCK_EN_MASK 0x10
#define SMU_FIRMWARE__SMU_SRAM_WR_BLOCK_EN__SHIFT 0x4
#define SMU_FIRMWARE__SMU_counter_MASK 0xf00
#define SMU_FIRMWARE__SMU_counter__SHIFT 0x8
#define SMU_FIRMWARE__SMU_MODE_MASK 0x10000
#define SMU_FIRMWARE__SMU_MODE__SHIFT 0x10
#define SMU_FIRMWARE__SMU_SEL_MASK 0x20000
#define SMU_FIRMWARE__SMU_SEL__SHIFT 0x11
#define SMU_INPUT_DATA__START_ADDR_MASK 0x7fffffff
#define SMU_INPUT_DATA__START_ADDR__SHIFT 0x0
#define SMU_INPUT_DATA__AUTO_START_MASK 0x80000000
#define SMU_INPUT_DATA__AUTO_START__SHIFT 0x1f
#define SMU_EFUSE_0__EFUSE_DATA_MASK 0xffffffff
#define SMU_EFUSE_0__EFUSE_DATA__SHIFT 0x0
#define FIRMWARE_FLAGS__INTERRUPTS_ENABLED_MASK 0x1
#define FIRMWARE_FLAGS__INTERRUPTS_ENABLED__SHIFT 0x0
#define FIRMWARE_FLAGS__RESERVED_MASK 0xfffffe
#define FIRMWARE_FLAGS__RESERVED__SHIFT 0x1
#define FIRMWARE_FLAGS__TEST_COUNT_MASK 0xff000000
#define FIRMWARE_FLAGS__TEST_COUNT__SHIFT 0x18
#define TDC_STATUS__VDD_Boost_MASK 0xff
#define TDC_STATUS__VDD_Boost__SHIFT 0x0
#define TDC_STATUS__VDD_Throttle_MASK 0xff00
#define TDC_STATUS__VDD_Throttle__SHIFT 0x8
#define TDC_STATUS__VDDC_Boost_MASK 0xff0000
#define TDC_STATUS__VDDC_Boost__SHIFT 0x10
#define TDC_STATUS__VDDC_Throttle_MASK 0xff000000
#define TDC_STATUS__VDDC_Throttle__SHIFT 0x18
#define TDC_MV_AVERAGE__IDD_MASK 0xffff
#define TDC_MV_AVERAGE__IDD__SHIFT 0x0
#define TDC_MV_AVERAGE__IDDC_MASK 0xffff0000
#define TDC_MV_AVERAGE__IDDC__SHIFT 0x10
#define TDC_VRM_LIMIT__IDD_MASK 0xffff
#define TDC_VRM_LIMIT__IDD__SHIFT 0x0
#define TDC_VRM_LIMIT__IDDC_MASK 0xffff0000
#define TDC_VRM_LIMIT__IDDC__SHIFT 0x10
#define FEATURE_STATUS__SCLK_DPM_ON_MASK 0x1
#define FEATURE_STATUS__SCLK_DPM_ON__SHIFT 0x0
#define FEATURE_STATUS__MCLK_DPM_ON_MASK 0x2
#define FEATURE_STATUS__MCLK_DPM_ON__SHIFT 0x1
#define FEATURE_STATUS__LCLK_DPM_ON_MASK 0x4
#define FEATURE_STATUS__LCLK_DPM_ON__SHIFT 0x2
#define FEATURE_STATUS__UVD_DPM_ON_MASK 0x8
#define FEATURE_STATUS__UVD_DPM_ON__SHIFT 0x3
#define FEATURE_STATUS__VCE_DPM_ON_MASK 0x10
#define FEATURE_STATUS__VCE_DPM_ON__SHIFT 0x4
#define FEATURE_STATUS__SAMU_DPM_ON_MASK 0x20
#define FEATURE_STATUS__SAMU_DPM_ON__SHIFT 0x5
#define FEATURE_STATUS__ACP_DPM_ON_MASK 0x40
#define FEATURE_STATUS__ACP_DPM_ON__SHIFT 0x6
#define FEATURE_STATUS__PCIE_DPM_ON_MASK 0x80
#define FEATURE_STATUS__PCIE_DPM_ON__SHIFT 0x7
#define FEATURE_STATUS__BAPM_ON_MASK 0x100
#define FEATURE_STATUS__BAPM_ON__SHIFT 0x8
#define FEATURE_STATUS__LPMX_ON_MASK 0x200
#define FEATURE_STATUS__LPMX_ON__SHIFT 0x9
#define FEATURE_STATUS__NBDPM_ON_MASK 0x400
#define FEATURE_STATUS__NBDPM_ON__SHIFT 0xa
#define FEATURE_STATUS__LHTC_ON_MASK 0x800
#define FEATURE_STATUS__LHTC_ON__SHIFT 0xb
#define FEATURE_STATUS__VPC_ON_MASK 0x1000
#define FEATURE_STATUS__VPC_ON__SHIFT 0xc
#define FEATURE_STATUS__VOLTAGE_CONTROLLER_ON_MASK 0x2000
#define FEATURE_STATUS__VOLTAGE_CONTROLLER_ON__SHIFT 0xd
#define FEATURE_STATUS__TDC_LIMIT_ON_MASK 0x4000
#define FEATURE_STATUS__TDC_LIMIT_ON__SHIFT 0xe
#define FEATURE_STATUS__GPU_CAC_ON_MASK 0x8000
#define FEATURE_STATUS__GPU_CAC_ON__SHIFT 0xf
#define FEATURE_STATUS__AVS_ON_MASK 0x10000
#define FEATURE_STATUS__AVS_ON__SHIFT 0x10
#define FEATURE_STATUS__SPMI_ON_MASK 0x20000
#define FEATURE_STATUS__SPMI_ON__SHIFT 0x11
#define FEATURE_STATUS__SCLK_DPM_FORCED_MASK 0x40000
#define FEATURE_STATUS__SCLK_DPM_FORCED__SHIFT 0x12
#define FEATURE_STATUS__MCLK_DPM_FORCED_MASK 0x80000
#define FEATURE_STATUS__MCLK_DPM_FORCED__SHIFT 0x13
#define FEATURE_STATUS__LCLK_DPM_FORCED_MASK 0x100000
#define FEATURE_STATUS__LCLK_DPM_FORCED__SHIFT 0x14
#define FEATURE_STATUS__PCIE_DPM_FORCED_MASK 0x200000
#define FEATURE_STATUS__PCIE_DPM_FORCED__SHIFT 0x15
#define FEATURE_STATUS__RESERVED_MASK 0xffc00000
#define FEATURE_STATUS__RESERVED__SHIFT 0x16
#define ENTITY_TEMPERATURES_1__GPU_MASK 0xffffffff
#define ENTITY_TEMPERATURES_1__GPU__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_1__entries_0_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_1__entries_0_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_2__entries_0_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_2__entries_0_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_4__entries_0_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_4__entries_0_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_5__entries_0_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_5__entries_0_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_7__entries_0_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_7__entries_0_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_8__entries_0_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_8__entries_0_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_10__entries_0_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_10__entries_0_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_11__entries_0_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_11__entries_0_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_13__entries_1_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_13__entries_1_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_14__entries_1_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_14__entries_1_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_15__entries_1_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_15__entries_1_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_15__entries_1_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_15__entries_1_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_15__entries_1_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_15__entries_1_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_15__entries_1_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_15__entries_1_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_16__entries_1_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_16__entries_1_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_17__entries_1_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_17__entries_1_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_18__entries_1_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_18__entries_1_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_18__entries_1_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_18__entries_1_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_18__entries_1_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_18__entries_1_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_18__entries_1_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_18__entries_1_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_19__entries_1_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_19__entries_1_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_20__entries_1_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_20__entries_1_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_22__entries_1_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_22__entries_1_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_23__entries_1_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_23__entries_1_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_25__entries_2_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_25__entries_2_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_26__entries_2_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_26__entries_2_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_27__entries_2_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_27__entries_2_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_27__entries_2_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_27__entries_2_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_27__entries_2_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_27__entries_2_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_27__entries_2_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_27__entries_2_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_28__entries_2_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_28__entries_2_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_29__entries_2_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_29__entries_2_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_30__entries_2_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_30__entries_2_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_30__entries_2_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_30__entries_2_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_30__entries_2_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_30__entries_2_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_30__entries_2_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_30__entries_2_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_31__entries_2_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_31__entries_2_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_32__entries_2_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_32__entries_2_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_33__entries_2_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_33__entries_2_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_33__entries_2_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_33__entries_2_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_33__entries_2_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_33__entries_2_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_33__entries_2_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_33__entries_2_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_34__entries_2_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_34__entries_2_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_35__entries_2_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_35__entries_2_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_36__entries_2_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_36__entries_2_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_36__entries_2_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_36__entries_2_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_36__entries_2_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_36__entries_2_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_36__entries_2_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_36__entries_2_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_37__entries_3_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_37__entries_3_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_38__entries_3_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_38__entries_3_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_39__entries_3_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_39__entries_3_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_39__entries_3_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_39__entries_3_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_39__entries_3_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_39__entries_3_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_39__entries_3_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_39__entries_3_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_40__entries_3_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_40__entries_3_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_41__entries_3_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_41__entries_3_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_42__entries_3_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_42__entries_3_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_42__entries_3_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_42__entries_3_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_42__entries_3_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_42__entries_3_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_42__entries_3_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_42__entries_3_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_43__entries_3_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_43__entries_3_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_44__entries_3_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_44__entries_3_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_45__entries_3_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_45__entries_3_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_45__entries_3_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_45__entries_3_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_45__entries_3_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_45__entries_3_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_45__entries_3_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_45__entries_3_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_46__entries_3_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_46__entries_3_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_47__entries_3_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_47__entries_3_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_48__entries_3_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_48__entries_3_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_48__entries_3_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_48__entries_3_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_48__entries_3_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_48__entries_3_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_48__entries_3_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_48__entries_3_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_49__entries_4_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_49__entries_4_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_50__entries_4_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_50__entries_4_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_51__entries_4_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_51__entries_4_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_51__entries_4_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_51__entries_4_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_51__entries_4_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_51__entries_4_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_51__entries_4_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_51__entries_4_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_52__entries_4_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_52__entries_4_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_53__entries_4_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_53__entries_4_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_54__entries_4_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_54__entries_4_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_54__entries_4_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_54__entries_4_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_54__entries_4_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_54__entries_4_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_54__entries_4_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_54__entries_4_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_55__entries_4_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_55__entries_4_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_56__entries_4_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_56__entries_4_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_57__entries_4_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_57__entries_4_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_57__entries_4_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_57__entries_4_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_57__entries_4_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_57__entries_4_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_57__entries_4_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_57__entries_4_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_58__entries_4_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_58__entries_4_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_59__entries_4_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_59__entries_4_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_60__entries_4_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_60__entries_4_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_60__entries_4_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_60__entries_4_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_60__entries_4_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_60__entries_4_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_60__entries_4_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_60__entries_4_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_61__entries_5_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_61__entries_5_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_62__entries_5_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_62__entries_5_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_63__entries_5_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_63__entries_5_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_63__entries_5_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_63__entries_5_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_63__entries_5_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_63__entries_5_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_63__entries_5_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_63__entries_5_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_64__entries_5_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_64__entries_5_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_65__entries_5_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_65__entries_5_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_66__entries_5_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_66__entries_5_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_66__entries_5_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_66__entries_5_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_66__entries_5_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_66__entries_5_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_66__entries_5_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_66__entries_5_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_67__entries_5_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_67__entries_5_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_68__entries_5_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_68__entries_5_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_69__entries_5_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_69__entries_5_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_69__entries_5_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_69__entries_5_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_69__entries_5_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_69__entries_5_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_69__entries_5_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_69__entries_5_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_70__entries_5_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_70__entries_5_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_71__entries_5_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_71__entries_5_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_72__entries_5_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_72__entries_5_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_72__entries_5_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_72__entries_5_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_72__entries_5_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_72__entries_5_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_72__entries_5_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_72__entries_5_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_73__entries_6_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_73__entries_6_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_74__entries_6_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_74__entries_6_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_75__entries_6_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_75__entries_6_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_75__entries_6_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_75__entries_6_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_75__entries_6_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_75__entries_6_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_75__entries_6_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_75__entries_6_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_76__entries_6_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_76__entries_6_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_77__entries_6_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_77__entries_6_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_78__entries_6_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_78__entries_6_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_78__entries_6_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_78__entries_6_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_78__entries_6_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_78__entries_6_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_78__entries_6_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_78__entries_6_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_79__entries_6_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_79__entries_6_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_80__entries_6_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_80__entries_6_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_81__entries_6_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_81__entries_6_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_81__entries_6_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_81__entries_6_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_81__entries_6_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_81__entries_6_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_81__entries_6_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_81__entries_6_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_82__entries_6_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_82__entries_6_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_83__entries_6_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_83__entries_6_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_84__entries_6_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_84__entries_6_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_84__entries_6_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_84__entries_6_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_84__entries_6_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_84__entries_6_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_84__entries_6_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_84__entries_6_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_85__entries_7_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_85__entries_7_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_86__entries_7_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_86__entries_7_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_87__entries_7_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_87__entries_7_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_87__entries_7_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_87__entries_7_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_87__entries_7_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_87__entries_7_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_87__entries_7_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_87__entries_7_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_88__entries_7_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_88__entries_7_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_89__entries_7_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_89__entries_7_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_90__entries_7_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_90__entries_7_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_90__entries_7_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_90__entries_7_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_90__entries_7_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_90__entries_7_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_90__entries_7_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_90__entries_7_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_91__entries_7_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_91__entries_7_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_92__entries_7_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_92__entries_7_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_93__entries_7_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_93__entries_7_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_93__entries_7_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_93__entries_7_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_93__entries_7_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_93__entries_7_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_93__entries_7_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_93__entries_7_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_94__entries_7_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_94__entries_7_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_95__entries_7_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_95__entries_7_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_96__entries_7_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_96__entries_7_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_96__entries_7_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_96__entries_7_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_96__entries_7_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_96__entries_7_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_96__entries_7_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_96__entries_7_3_McArbBurstTime__SHIFT 0x18
#define DPM_TABLE_1__GraphicsPIDController_Ki_MASK 0xffffffff
#define DPM_TABLE_1__GraphicsPIDController_Ki__SHIFT 0x0
#define DPM_TABLE_2__GraphicsPIDController_LFWindupUpperLim_MASK 0xffffffff
#define DPM_TABLE_2__GraphicsPIDController_LFWindupUpperLim__SHIFT 0x0
#define DPM_TABLE_3__GraphicsPIDController_LFWindupLowerLim_MASK 0xffffffff
#define DPM_TABLE_3__GraphicsPIDController_LFWindupLowerLim__SHIFT 0x0
#define DPM_TABLE_4__GraphicsPIDController_StatePrecision_MASK 0xffffffff
#define DPM_TABLE_4__GraphicsPIDController_StatePrecision__SHIFT 0x0
#define DPM_TABLE_5__GraphicsPIDController_LfPrecision_MASK 0xffffffff
#define DPM_TABLE_5__GraphicsPIDController_LfPrecision__SHIFT 0x0
#define DPM_TABLE_6__GraphicsPIDController_LfOffset_MASK 0xffffffff
#define DPM_TABLE_6__GraphicsPIDController_LfOffset__SHIFT 0x0
#define DPM_TABLE_7__GraphicsPIDController_MaxState_MASK 0xffffffff
#define DPM_TABLE_7__GraphicsPIDController_MaxState__SHIFT 0x0
#define DPM_TABLE_8__GraphicsPIDController_MaxLfFraction_MASK 0xffffffff
#define DPM_TABLE_8__GraphicsPIDController_MaxLfFraction__SHIFT 0x0
#define DPM_TABLE_9__GraphicsPIDController_StateShift_MASK 0xffffffff
#define DPM_TABLE_9__GraphicsPIDController_StateShift__SHIFT 0x0
#define DPM_TABLE_10__MemoryPIDController_Ki_MASK 0xffffffff
#define DPM_TABLE_10__MemoryPIDController_Ki__SHIFT 0x0
#define DPM_TABLE_11__MemoryPIDController_LFWindupUpperLim_MASK 0xffffffff
#define DPM_TABLE_11__MemoryPIDController_LFWindupUpperLim__SHIFT 0x0
#define DPM_TABLE_12__MemoryPIDController_LFWindupLowerLim_MASK 0xffffffff
#define DPM_TABLE_12__MemoryPIDController_LFWindupLowerLim__SHIFT 0x0
#define DPM_TABLE_13__MemoryPIDController_StatePrecision_MASK 0xffffffff
#define DPM_TABLE_13__MemoryPIDController_StatePrecision__SHIFT 0x0
#define DPM_TABLE_14__MemoryPIDController_LfPrecision_MASK 0xffffffff
#define DPM_TABLE_14__MemoryPIDController_LfPrecision__SHIFT 0x0
#define DPM_TABLE_15__MemoryPIDController_LfOffset_MASK 0xffffffff
#define DPM_TABLE_15__MemoryPIDController_LfOffset__SHIFT 0x0
#define DPM_TABLE_16__MemoryPIDController_MaxState_MASK 0xffffffff
#define DPM_TABLE_16__MemoryPIDController_MaxState__SHIFT 0x0
#define DPM_TABLE_17__MemoryPIDController_MaxLfFraction_MASK 0xffffffff
#define DPM_TABLE_17__MemoryPIDController_MaxLfFraction__SHIFT 0x0
#define DPM_TABLE_18__MemoryPIDController_StateShift_MASK 0xffffffff
#define DPM_TABLE_18__MemoryPIDController_StateShift__SHIFT 0x0
#define DPM_TABLE_19__LinkPIDController_Ki_MASK 0xffffffff
#define DPM_TABLE_19__LinkPIDController_Ki__SHIFT 0x0
#define DPM_TABLE_20__LinkPIDController_LFWindupUpperLim_MASK 0xffffffff
#define DPM_TABLE_20__LinkPIDController_LFWindupUpperLim__SHIFT 0x0
#define DPM_TABLE_21__LinkPIDController_LFWindupLowerLim_MASK 0xffffffff
#define DPM_TABLE_21__LinkPIDController_LFWindupLowerLim__SHIFT 0x0
#define DPM_TABLE_22__LinkPIDController_StatePrecision_MASK 0xffffffff
#define DPM_TABLE_22__LinkPIDController_StatePrecision__SHIFT 0x0
#define DPM_TABLE_23__LinkPIDController_LfPrecision_MASK 0xffffffff
#define DPM_TABLE_23__LinkPIDController_LfPrecision__SHIFT 0x0
#define DPM_TABLE_24__LinkPIDController_LfOffset_MASK 0xffffffff
#define DPM_TABLE_24__LinkPIDController_LfOffset__SHIFT 0x0
#define DPM_TABLE_25__LinkPIDController_MaxState_MASK 0xffffffff
#define DPM_TABLE_25__LinkPIDController_MaxState__SHIFT 0x0
#define DPM_TABLE_26__LinkPIDController_MaxLfFraction_MASK 0xffffffff
#define DPM_TABLE_26__LinkPIDController_MaxLfFraction__SHIFT 0x0
#define DPM_TABLE_27__LinkPIDController_StateShift_MASK 0xffffffff
#define DPM_TABLE_27__LinkPIDController_StateShift__SHIFT 0x0
#define DPM_TABLE_28__SystemFlags_MASK 0xffffffff
#define DPM_TABLE_28__SystemFlags__SHIFT 0x0
#define DPM_TABLE_29__VRConfig_MASK 0xffffffff
#define DPM_TABLE_29__VRConfig__SHIFT 0x0
#define DPM_TABLE_30__SmioMask1_MASK 0xffffffff
#define DPM_TABLE_30__SmioMask1__SHIFT 0x0
#define DPM_TABLE_31__SmioMask2_MASK 0xffffffff
#define DPM_TABLE_31__SmioMask2__SHIFT 0x0
#define DPM_TABLE_32__SmioTable1_Pattern_0_padding_MASK 0xff
#define DPM_TABLE_32__SmioTable1_Pattern_0_padding__SHIFT 0x0
#define DPM_TABLE_32__SmioTable1_Pattern_0_Smio_MASK 0xff00
#define DPM_TABLE_32__SmioTable1_Pattern_0_Smio__SHIFT 0x8
#define DPM_TABLE_32__SmioTable1_Pattern_0_Voltage_MASK 0xffff0000
#define DPM_TABLE_32__SmioTable1_Pattern_0_Voltage__SHIFT 0x10
#define DPM_TABLE_33__SmioTable1_Pattern_1_padding_MASK 0xff
#define DPM_TABLE_33__SmioTable1_Pattern_1_padding__SHIFT 0x0
#define DPM_TABLE_33__SmioTable1_Pattern_1_Smio_MASK 0xff00
#define DPM_TABLE_33__SmioTable1_Pattern_1_Smio__SHIFT 0x8
#define DPM_TABLE_33__SmioTable1_Pattern_1_Voltage_MASK 0xffff0000
#define DPM_TABLE_33__SmioTable1_Pattern_1_Voltage__SHIFT 0x10
#define DPM_TABLE_34__SmioTable1_Pattern_2_padding_MASK 0xff
#define DPM_TABLE_34__SmioTable1_Pattern_2_padding__SHIFT 0x0
#define DPM_TABLE_34__SmioTable1_Pattern_2_Smio_MASK 0xff00
#define DPM_TABLE_34__SmioTable1_Pattern_2_Smio__SHIFT 0x8
#define DPM_TABLE_34__SmioTable1_Pattern_2_Voltage_MASK 0xffff0000
#define DPM_TABLE_34__SmioTable1_Pattern_2_Voltage__SHIFT 0x10
#define DPM_TABLE_35__SmioTable1_Pattern_3_padding_MASK 0xff
#define DPM_TABLE_35__SmioTable1_Pattern_3_padding__SHIFT 0x0
#define DPM_TABLE_35__SmioTable1_Pattern_3_Smio_MASK 0xff00
#define DPM_TABLE_35__SmioTable1_Pattern_3_Smio__SHIFT 0x8
#define DPM_TABLE_35__SmioTable1_Pattern_3_Voltage_MASK 0xffff0000
#define DPM_TABLE_35__SmioTable1_Pattern_3_Voltage__SHIFT 0x10
#define DPM_TABLE_36__SmioTable2_Pattern_0_padding_MASK 0xff
#define DPM_TABLE_36__SmioTable2_Pattern_0_padding__SHIFT 0x0
#define DPM_TABLE_36__SmioTable2_Pattern_0_Smio_MASK 0xff00
#define DPM_TABLE_36__SmioTable2_Pattern_0_Smio__SHIFT 0x8
#define DPM_TABLE_36__SmioTable2_Pattern_0_Voltage_MASK 0xffff0000
#define DPM_TABLE_36__SmioTable2_Pattern_0_Voltage__SHIFT 0x10
#define DPM_TABLE_37__SmioTable2_Pattern_1_padding_MASK 0xff
#define DPM_TABLE_37__SmioTable2_Pattern_1_padding__SHIFT 0x0
#define DPM_TABLE_37__SmioTable2_Pattern_1_Smio_MASK 0xff00
#define DPM_TABLE_37__SmioTable2_Pattern_1_Smio__SHIFT 0x8
#define DPM_TABLE_37__SmioTable2_Pattern_1_Voltage_MASK 0xffff0000
#define DPM_TABLE_37__SmioTable2_Pattern_1_Voltage__SHIFT 0x10
#define DPM_TABLE_38__SmioTable2_Pattern_2_padding_MASK 0xff
#define DPM_TABLE_38__SmioTable2_Pattern_2_padding__SHIFT 0x0
#define DPM_TABLE_38__SmioTable2_Pattern_2_Smio_MASK 0xff00
#define DPM_TABLE_38__SmioTable2_Pattern_2_Smio__SHIFT 0x8
#define DPM_TABLE_38__SmioTable2_Pattern_2_Voltage_MASK 0xffff0000
#define DPM_TABLE_38__SmioTable2_Pattern_2_Voltage__SHIFT 0x10
#define DPM_TABLE_39__SmioTable2_Pattern_3_padding_MASK 0xff
#define DPM_TABLE_39__SmioTable2_Pattern_3_padding__SHIFT 0x0
#define DPM_TABLE_39__SmioTable2_Pattern_3_Smio_MASK 0xff00
#define DPM_TABLE_39__SmioTable2_Pattern_3_Smio__SHIFT 0x8
#define DPM_TABLE_39__SmioTable2_Pattern_3_Voltage_MASK 0xffff0000
#define DPM_TABLE_39__SmioTable2_Pattern_3_Voltage__SHIFT 0x10
#define DPM_TABLE_40__VddcLevelCount_MASK 0xffffffff
#define DPM_TABLE_40__VddcLevelCount__SHIFT 0x0
#define DPM_TABLE_41__VddciLevelCount_MASK 0xffffffff
#define DPM_TABLE_41__VddciLevelCount__SHIFT 0x0
#define DPM_TABLE_42__VddGfxLevelCount_MASK 0xffffffff
#define DPM_TABLE_42__VddGfxLevelCount__SHIFT 0x0
#define DPM_TABLE_43__MvddLevelCount_MASK 0xffffffff
#define DPM_TABLE_43__MvddLevelCount__SHIFT 0x0
#define DPM_TABLE_44__VddcTable_1_MASK 0xffff
#define DPM_TABLE_44__VddcTable_1__SHIFT 0x0
#define DPM_TABLE_44__VddcTable_0_MASK 0xffff0000
#define DPM_TABLE_44__VddcTable_0__SHIFT 0x10
#define DPM_TABLE_45__VddcTable_3_MASK 0xffff
#define DPM_TABLE_45__VddcTable_3__SHIFT 0x0
#define DPM_TABLE_45__VddcTable_2_MASK 0xffff0000
#define DPM_TABLE_45__VddcTable_2__SHIFT 0x10
#define DPM_TABLE_46__VddcTable_5_MASK 0xffff
#define DPM_TABLE_46__VddcTable_5__SHIFT 0x0
#define DPM_TABLE_46__VddcTable_4_MASK 0xffff0000
#define DPM_TABLE_46__VddcTable_4__SHIFT 0x10
#define DPM_TABLE_47__VddcTable_7_MASK 0xffff
#define DPM_TABLE_47__VddcTable_7__SHIFT 0x0
#define DPM_TABLE_47__VddcTable_6_MASK 0xffff0000
#define DPM_TABLE_47__VddcTable_6__SHIFT 0x10
#define DPM_TABLE_48__VddcTable_9_MASK 0xffff
#define DPM_TABLE_48__VddcTable_9__SHIFT 0x0
#define DPM_TABLE_48__VddcTable_8_MASK 0xffff0000
#define DPM_TABLE_48__VddcTable_8__SHIFT 0x10
#define DPM_TABLE_49__VddcTable_11_MASK 0xffff
#define DPM_TABLE_49__VddcTable_11__SHIFT 0x0
#define DPM_TABLE_49__VddcTable_10_MASK 0xffff0000
#define DPM_TABLE_49__VddcTable_10__SHIFT 0x10
#define DPM_TABLE_50__VddcTable_13_MASK 0xffff
#define DPM_TABLE_50__VddcTable_13__SHIFT 0x0
#define DPM_TABLE_50__VddcTable_12_MASK 0xffff0000
#define DPM_TABLE_50__VddcTable_12__SHIFT 0x10
#define DPM_TABLE_51__VddcTable_15_MASK 0xffff
#define DPM_TABLE_51__VddcTable_15__SHIFT 0x0
#define DPM_TABLE_51__VddcTable_14_MASK 0xffff0000
#define DPM_TABLE_51__VddcTable_14__SHIFT 0x10
#define DPM_TABLE_52__VddGfxTable_1_MASK 0xffff
#define DPM_TABLE_52__VddGfxTable_1__SHIFT 0x0
#define DPM_TABLE_52__VddGfxTable_0_MASK 0xffff0000
#define DPM_TABLE_52__VddGfxTable_0__SHIFT 0x10
#define DPM_TABLE_53__VddGfxTable_3_MASK 0xffff
#define DPM_TABLE_53__VddGfxTable_3__SHIFT 0x0
#define DPM_TABLE_53__VddGfxTable_2_MASK 0xffff0000
#define DPM_TABLE_53__VddGfxTable_2__SHIFT 0x10
#define DPM_TABLE_54__VddGfxTable_5_MASK 0xffff
#define DPM_TABLE_54__VddGfxTable_5__SHIFT 0x0
#define DPM_TABLE_54__VddGfxTable_4_MASK 0xffff0000
#define DPM_TABLE_54__VddGfxTable_4__SHIFT 0x10
#define DPM_TABLE_55__VddGfxTable_7_MASK 0xffff
#define DPM_TABLE_55__VddGfxTable_7__SHIFT 0x0
#define DPM_TABLE_55__VddGfxTable_6_MASK 0xffff0000
#define DPM_TABLE_55__VddGfxTable_6__SHIFT 0x10
#define DPM_TABLE_56__VddGfxTable_9_MASK 0xffff
#define DPM_TABLE_56__VddGfxTable_9__SHIFT 0x0
#define DPM_TABLE_56__VddGfxTable_8_MASK 0xffff0000
#define DPM_TABLE_56__VddGfxTable_8__SHIFT 0x10
#define DPM_TABLE_57__VddGfxTable_11_MASK 0xffff
#define DPM_TABLE_57__VddGfxTable_11__SHIFT 0x0
#define DPM_TABLE_57__VddGfxTable_10_MASK 0xffff0000
#define DPM_TABLE_57__VddGfxTable_10__SHIFT 0x10
#define DPM_TABLE_58__VddGfxTable_13_MASK 0xffff
#define DPM_TABLE_58__VddGfxTable_13__SHIFT 0x0
#define DPM_TABLE_58__VddGfxTable_12_MASK 0xffff0000
#define DPM_TABLE_58__VddGfxTable_12__SHIFT 0x10
#define DPM_TABLE_59__VddGfxTable_15_MASK 0xffff
#define DPM_TABLE_59__VddGfxTable_15__SHIFT 0x0
#define DPM_TABLE_59__VddGfxTable_14_MASK 0xffff0000
#define DPM_TABLE_59__VddGfxTable_14__SHIFT 0x10
#define DPM_TABLE_60__VddciTable_1_MASK 0xffff
#define DPM_TABLE_60__VddciTable_1__SHIFT 0x0
#define DPM_TABLE_60__VddciTable_0_MASK 0xffff0000
#define DPM_TABLE_60__VddciTable_0__SHIFT 0x10
#define DPM_TABLE_61__VddciTable_3_MASK 0xffff
#define DPM_TABLE_61__VddciTable_3__SHIFT 0x0
#define DPM_TABLE_61__VddciTable_2_MASK 0xffff0000
#define DPM_TABLE_61__VddciTable_2__SHIFT 0x10
#define DPM_TABLE_62__VddciTable_5_MASK 0xffff
#define DPM_TABLE_62__VddciTable_5__SHIFT 0x0
#define DPM_TABLE_62__VddciTable_4_MASK 0xffff0000
#define DPM_TABLE_62__VddciTable_4__SHIFT 0x10
#define DPM_TABLE_63__VddciTable_7_MASK 0xffff
#define DPM_TABLE_63__VddciTable_7__SHIFT 0x0
#define DPM_TABLE_63__VddciTable_6_MASK 0xffff0000
#define DPM_TABLE_63__VddciTable_6__SHIFT 0x10
#define DPM_TABLE_64__BapmVddGfxVidHiSidd_3_MASK 0xff
#define DPM_TABLE_64__BapmVddGfxVidHiSidd_3__SHIFT 0x0
#define DPM_TABLE_64__BapmVddGfxVidHiSidd_2_MASK 0xff00
#define DPM_TABLE_64__BapmVddGfxVidHiSidd_2__SHIFT 0x8
#define DPM_TABLE_64__BapmVddGfxVidHiSidd_1_MASK 0xff0000
#define DPM_TABLE_64__BapmVddGfxVidHiSidd_1__SHIFT 0x10
#define DPM_TABLE_64__BapmVddGfxVidHiSidd_0_MASK 0xff000000
#define DPM_TABLE_64__BapmVddGfxVidHiSidd_0__SHIFT 0x18
#define DPM_TABLE_65__BapmVddGfxVidHiSidd_7_MASK 0xff
#define DPM_TABLE_65__BapmVddGfxVidHiSidd_7__SHIFT 0x0
#define DPM_TABLE_65__BapmVddGfxVidHiSidd_6_MASK 0xff00
#define DPM_TABLE_65__BapmVddGfxVidHiSidd_6__SHIFT 0x8
#define DPM_TABLE_65__BapmVddGfxVidHiSidd_5_MASK 0xff0000
#define DPM_TABLE_65__BapmVddGfxVidHiSidd_5__SHIFT 0x10
#define DPM_TABLE_65__BapmVddGfxVidHiSidd_4_MASK 0xff000000
#define DPM_TABLE_65__BapmVddGfxVidHiSidd_4__SHIFT 0x18
#define DPM_TABLE_66__BapmVddGfxVidHiSidd_11_MASK 0xff
#define DPM_TABLE_66__BapmVddGfxVidHiSidd_11__SHIFT 0x0
#define DPM_TABLE_66__BapmVddGfxVidHiSidd_10_MASK 0xff00
#define DPM_TABLE_66__BapmVddGfxVidHiSidd_10__SHIFT 0x8
#define DPM_TABLE_66__BapmVddGfxVidHiSidd_9_MASK 0xff0000
#define DPM_TABLE_66__BapmVddGfxVidHiSidd_9__SHIFT 0x10
#define DPM_TABLE_66__BapmVddGfxVidHiSidd_8_MASK 0xff000000
#define DPM_TABLE_66__BapmVddGfxVidHiSidd_8__SHIFT 0x18
#define DPM_TABLE_67__BapmVddGfxVidHiSidd_15_MASK 0xff
#define DPM_TABLE_67__BapmVddGfxVidHiSidd_15__SHIFT 0x0
#define DPM_TABLE_67__BapmVddGfxVidHiSidd_14_MASK 0xff00
#define DPM_TABLE_67__BapmVddGfxVidHiSidd_14__SHIFT 0x8
#define DPM_TABLE_67__BapmVddGfxVidHiSidd_13_MASK 0xff0000
#define DPM_TABLE_67__BapmVddGfxVidHiSidd_13__SHIFT 0x10
#define DPM_TABLE_67__BapmVddGfxVidHiSidd_12_MASK 0xff000000
#define DPM_TABLE_67__BapmVddGfxVidHiSidd_12__SHIFT 0x18
#define DPM_TABLE_68__BapmVddGfxVidLoSidd_3_MASK 0xff
#define DPM_TABLE_68__BapmVddGfxVidLoSidd_3__SHIFT 0x0
#define DPM_TABLE_68__BapmVddGfxVidLoSidd_2_MASK 0xff00
#define DPM_TABLE_68__BapmVddGfxVidLoSidd_2__SHIFT 0x8
#define DPM_TABLE_68__BapmVddGfxVidLoSidd_1_MASK 0xff0000
#define DPM_TABLE_68__BapmVddGfxVidLoSidd_1__SHIFT 0x10
#define DPM_TABLE_68__BapmVddGfxVidLoSidd_0_MASK 0xff000000
#define DPM_TABLE_68__BapmVddGfxVidLoSidd_0__SHIFT 0x18
#define DPM_TABLE_69__BapmVddGfxVidLoSidd_7_MASK 0xff
#define DPM_TABLE_69__BapmVddGfxVidLoSidd_7__SHIFT 0x0
#define DPM_TABLE_69__BapmVddGfxVidLoSidd_6_MASK 0xff00
#define DPM_TABLE_69__BapmVddGfxVidLoSidd_6__SHIFT 0x8
#define DPM_TABLE_69__BapmVddGfxVidLoSidd_5_MASK 0xff0000
#define DPM_TABLE_69__BapmVddGfxVidLoSidd_5__SHIFT 0x10
#define DPM_TABLE_69__BapmVddGfxVidLoSidd_4_MASK 0xff000000
#define DPM_TABLE_69__BapmVddGfxVidLoSidd_4__SHIFT 0x18
#define DPM_TABLE_70__BapmVddGfxVidLoSidd_11_MASK 0xff
#define DPM_TABLE_70__BapmVddGfxVidLoSidd_11__SHIFT 0x0
#define DPM_TABLE_70__BapmVddGfxVidLoSidd_10_MASK 0xff00
#define DPM_TABLE_70__BapmVddGfxVidLoSidd_10__SHIFT 0x8
#define DPM_TABLE_70__BapmVddGfxVidLoSidd_9_MASK 0xff0000
#define DPM_TABLE_70__BapmVddGfxVidLoSidd_9__SHIFT 0x10
#define DPM_TABLE_70__BapmVddGfxVidLoSidd_8_MASK 0xff000000
#define DPM_TABLE_70__BapmVddGfxVidLoSidd_8__SHIFT 0x18
#define DPM_TABLE_71__BapmVddGfxVidLoSidd_15_MASK 0xff
#define DPM_TABLE_71__BapmVddGfxVidLoSidd_15__SHIFT 0x0
#define DPM_TABLE_71__BapmVddGfxVidLoSidd_14_MASK 0xff00
#define DPM_TABLE_71__BapmVddGfxVidLoSidd_14__SHIFT 0x8
#define DPM_TABLE_71__BapmVddGfxVidLoSidd_13_MASK 0xff0000
#define DPM_TABLE_71__BapmVddGfxVidLoSidd_13__SHIFT 0x10
#define DPM_TABLE_71__BapmVddGfxVidLoSidd_12_MASK 0xff000000
#define DPM_TABLE_71__BapmVddGfxVidLoSidd_12__SHIFT 0x18
#define DPM_TABLE_72__BapmVddGfxVidHiSidd2_3_MASK 0xff
#define DPM_TABLE_72__BapmVddGfxVidHiSidd2_3__SHIFT 0x0
#define DPM_TABLE_72__BapmVddGfxVidHiSidd2_2_MASK 0xff00
#define DPM_TABLE_72__BapmVddGfxVidHiSidd2_2__SHIFT 0x8
#define DPM_TABLE_72__BapmVddGfxVidHiSidd2_1_MASK 0xff0000
#define DPM_TABLE_72__BapmVddGfxVidHiSidd2_1__SHIFT 0x10
#define DPM_TABLE_72__BapmVddGfxVidHiSidd2_0_MASK 0xff000000
#define DPM_TABLE_72__BapmVddGfxVidHiSidd2_0__SHIFT 0x18
#define DPM_TABLE_73__BapmVddGfxVidHiSidd2_7_MASK 0xff
#define DPM_TABLE_73__BapmVddGfxVidHiSidd2_7__SHIFT 0x0
#define DPM_TABLE_73__BapmVddGfxVidHiSidd2_6_MASK 0xff00
#define DPM_TABLE_73__BapmVddGfxVidHiSidd2_6__SHIFT 0x8
#define DPM_TABLE_73__BapmVddGfxVidHiSidd2_5_MASK 0xff0000
#define DPM_TABLE_73__BapmVddGfxVidHiSidd2_5__SHIFT 0x10
#define DPM_TABLE_73__BapmVddGfxVidHiSidd2_4_MASK 0xff000000
#define DPM_TABLE_73__BapmVddGfxVidHiSidd2_4__SHIFT 0x18
#define DPM_TABLE_74__BapmVddGfxVidHiSidd2_11_MASK 0xff
#define DPM_TABLE_74__BapmVddGfxVidHiSidd2_11__SHIFT 0x0
#define DPM_TABLE_74__BapmVddGfxVidHiSidd2_10_MASK 0xff00
#define DPM_TABLE_74__BapmVddGfxVidHiSidd2_10__SHIFT 0x8
#define DPM_TABLE_74__BapmVddGfxVidHiSidd2_9_MASK 0xff0000
#define DPM_TABLE_74__BapmVddGfxVidHiSidd2_9__SHIFT 0x10
#define DPM_TABLE_74__BapmVddGfxVidHiSidd2_8_MASK 0xff000000
#define DPM_TABLE_74__BapmVddGfxVidHiSidd2_8__SHIFT 0x18
#define DPM_TABLE_75__BapmVddGfxVidHiSidd2_15_MASK 0xff
#define DPM_TABLE_75__BapmVddGfxVidHiSidd2_15__SHIFT 0x0
#define DPM_TABLE_75__BapmVddGfxVidHiSidd2_14_MASK 0xff00
#define DPM_TABLE_75__BapmVddGfxVidHiSidd2_14__SHIFT 0x8
#define DPM_TABLE_75__BapmVddGfxVidHiSidd2_13_MASK 0xff0000
#define DPM_TABLE_75__BapmVddGfxVidHiSidd2_13__SHIFT 0x10
#define DPM_TABLE_75__BapmVddGfxVidHiSidd2_12_MASK 0xff000000
#define DPM_TABLE_75__BapmVddGfxVidHiSidd2_12__SHIFT 0x18
#define DPM_TABLE_76__BapmVddcVidHiSidd_3_MASK 0xff
#define DPM_TABLE_76__BapmVddcVidHiSidd_3__SHIFT 0x0
#define DPM_TABLE_76__BapmVddcVidHiSidd_2_MASK 0xff00
#define DPM_TABLE_76__BapmVddcVidHiSidd_2__SHIFT 0x8
#define DPM_TABLE_76__BapmVddcVidHiSidd_1_MASK 0xff0000
#define DPM_TABLE_76__BapmVddcVidHiSidd_1__SHIFT 0x10
#define DPM_TABLE_76__BapmVddcVidHiSidd_0_MASK 0xff000000
#define DPM_TABLE_76__BapmVddcVidHiSidd_0__SHIFT 0x18
#define DPM_TABLE_77__BapmVddcVidHiSidd_7_MASK 0xff
#define DPM_TABLE_77__BapmVddcVidHiSidd_7__SHIFT 0x0
#define DPM_TABLE_77__BapmVddcVidHiSidd_6_MASK 0xff00
#define DPM_TABLE_77__BapmVddcVidHiSidd_6__SHIFT 0x8
#define DPM_TABLE_77__BapmVddcVidHiSidd_5_MASK 0xff0000
#define DPM_TABLE_77__BapmVddcVidHiSidd_5__SHIFT 0x10
#define DPM_TABLE_77__BapmVddcVidHiSidd_4_MASK 0xff000000
#define DPM_TABLE_77__BapmVddcVidHiSidd_4__SHIFT 0x18
#define DPM_TABLE_78__BapmVddcVidHiSidd_11_MASK 0xff
#define DPM_TABLE_78__BapmVddcVidHiSidd_11__SHIFT 0x0
#define DPM_TABLE_78__BapmVddcVidHiSidd_10_MASK 0xff00
#define DPM_TABLE_78__BapmVddcVidHiSidd_10__SHIFT 0x8
#define DPM_TABLE_78__BapmVddcVidHiSidd_9_MASK 0xff0000
#define DPM_TABLE_78__BapmVddcVidHiSidd_9__SHIFT 0x10
#define DPM_TABLE_78__BapmVddcVidHiSidd_8_MASK 0xff000000
#define DPM_TABLE_78__BapmVddcVidHiSidd_8__SHIFT 0x18
#define DPM_TABLE_79__BapmVddcVidHiSidd_15_MASK 0xff
#define DPM_TABLE_79__BapmVddcVidHiSidd_15__SHIFT 0x0
#define DPM_TABLE_79__BapmVddcVidHiSidd_14_MASK 0xff00
#define DPM_TABLE_79__BapmVddcVidHiSidd_14__SHIFT 0x8
#define DPM_TABLE_79__BapmVddcVidHiSidd_13_MASK 0xff0000
#define DPM_TABLE_79__BapmVddcVidHiSidd_13__SHIFT 0x10
#define DPM_TABLE_79__BapmVddcVidHiSidd_12_MASK 0xff000000
#define DPM_TABLE_79__BapmVddcVidHiSidd_12__SHIFT 0x18
#define DPM_TABLE_80__BapmVddcVidLoSidd_3_MASK 0xff
#define DPM_TABLE_80__BapmVddcVidLoSidd_3__SHIFT 0x0
#define DPM_TABLE_80__BapmVddcVidLoSidd_2_MASK 0xff00
#define DPM_TABLE_80__BapmVddcVidLoSidd_2__SHIFT 0x8
#define DPM_TABLE_80__BapmVddcVidLoSidd_1_MASK 0xff0000
#define DPM_TABLE_80__BapmVddcVidLoSidd_1__SHIFT 0x10
#define DPM_TABLE_80__BapmVddcVidLoSidd_0_MASK 0xff000000
#define DPM_TABLE_80__BapmVddcVidLoSidd_0__SHIFT 0x18
#define DPM_TABLE_81__BapmVddcVidLoSidd_7_MASK 0xff
#define DPM_TABLE_81__BapmVddcVidLoSidd_7__SHIFT 0x0
#define DPM_TABLE_81__BapmVddcVidLoSidd_6_MASK 0xff00
#define DPM_TABLE_81__BapmVddcVidLoSidd_6__SHIFT 0x8
#define DPM_TABLE_81__BapmVddcVidLoSidd_5_MASK 0xff0000
#define DPM_TABLE_81__BapmVddcVidLoSidd_5__SHIFT 0x10
#define DPM_TABLE_81__BapmVddcVidLoSidd_4_MASK 0xff000000
#define DPM_TABLE_81__BapmVddcVidLoSidd_4__SHIFT 0x18
#define DPM_TABLE_82__BapmVddcVidLoSidd_11_MASK 0xff
#define DPM_TABLE_82__BapmVddcVidLoSidd_11__SHIFT 0x0
#define DPM_TABLE_82__BapmVddcVidLoSidd_10_MASK 0xff00
#define DPM_TABLE_82__BapmVddcVidLoSidd_10__SHIFT 0x8
#define DPM_TABLE_82__BapmVddcVidLoSidd_9_MASK 0xff0000
#define DPM_TABLE_82__BapmVddcVidLoSidd_9__SHIFT 0x10
#define DPM_TABLE_82__BapmVddcVidLoSidd_8_MASK 0xff000000
#define DPM_TABLE_82__BapmVddcVidLoSidd_8__SHIFT 0x18
#define DPM_TABLE_83__BapmVddcVidLoSidd_15_MASK 0xff
#define DPM_TABLE_83__BapmVddcVidLoSidd_15__SHIFT 0x0
#define DPM_TABLE_83__BapmVddcVidLoSidd_14_MASK 0xff00
#define DPM_TABLE_83__BapmVddcVidLoSidd_14__SHIFT 0x8
#define DPM_TABLE_83__BapmVddcVidLoSidd_13_MASK 0xff0000
#define DPM_TABLE_83__BapmVddcVidLoSidd_13__SHIFT 0x10
#define DPM_TABLE_83__BapmVddcVidLoSidd_12_MASK 0xff000000
#define DPM_TABLE_83__BapmVddcVidLoSidd_12__SHIFT 0x18
#define DPM_TABLE_84__BapmVddcVidHiSidd2_3_MASK 0xff
#define DPM_TABLE_84__BapmVddcVidHiSidd2_3__SHIFT 0x0
#define DPM_TABLE_84__BapmVddcVidHiSidd2_2_MASK 0xff00
#define DPM_TABLE_84__BapmVddcVidHiSidd2_2__SHIFT 0x8
#define DPM_TABLE_84__BapmVddcVidHiSidd2_1_MASK 0xff0000
#define DPM_TABLE_84__BapmVddcVidHiSidd2_1__SHIFT 0x10
#define DPM_TABLE_84__BapmVddcVidHiSidd2_0_MASK 0xff000000
#define DPM_TABLE_84__BapmVddcVidHiSidd2_0__SHIFT 0x18
#define DPM_TABLE_85__BapmVddcVidHiSidd2_7_MASK 0xff
#define DPM_TABLE_85__BapmVddcVidHiSidd2_7__SHIFT 0x0
#define DPM_TABLE_85__BapmVddcVidHiSidd2_6_MASK 0xff00
#define DPM_TABLE_85__BapmVddcVidHiSidd2_6__SHIFT 0x8
#define DPM_TABLE_85__BapmVddcVidHiSidd2_5_MASK 0xff0000
#define DPM_TABLE_85__BapmVddcVidHiSidd2_5__SHIFT 0x10
#define DPM_TABLE_85__BapmVddcVidHiSidd2_4_MASK 0xff000000
#define DPM_TABLE_85__BapmVddcVidHiSidd2_4__SHIFT 0x18
#define DPM_TABLE_86__BapmVddcVidHiSidd2_11_MASK 0xff
#define DPM_TABLE_86__BapmVddcVidHiSidd2_11__SHIFT 0x0
#define DPM_TABLE_86__BapmVddcVidHiSidd2_10_MASK 0xff00
#define DPM_TABLE_86__BapmVddcVidHiSidd2_10__SHIFT 0x8
#define DPM_TABLE_86__BapmVddcVidHiSidd2_9_MASK 0xff0000
#define DPM_TABLE_86__BapmVddcVidHiSidd2_9__SHIFT 0x10
#define DPM_TABLE_86__BapmVddcVidHiSidd2_8_MASK 0xff000000
#define DPM_TABLE_86__BapmVddcVidHiSidd2_8__SHIFT 0x18
#define DPM_TABLE_87__BapmVddcVidHiSidd2_15_MASK 0xff
#define DPM_TABLE_87__BapmVddcVidHiSidd2_15__SHIFT 0x0
#define DPM_TABLE_87__BapmVddcVidHiSidd2_14_MASK 0xff00
#define DPM_TABLE_87__BapmVddcVidHiSidd2_14__SHIFT 0x8
#define DPM_TABLE_87__BapmVddcVidHiSidd2_13_MASK 0xff0000
#define DPM_TABLE_87__BapmVddcVidHiSidd2_13__SHIFT 0x10
#define DPM_TABLE_87__BapmVddcVidHiSidd2_12_MASK 0xff000000
#define DPM_TABLE_87__BapmVddcVidHiSidd2_12__SHIFT 0x18
#define DPM_TABLE_88__MasterDeepSleepControl_MASK 0xff
#define DPM_TABLE_88__MasterDeepSleepControl__SHIFT 0x0
#define DPM_TABLE_88__LinkLevelCount_MASK 0xff00
#define DPM_TABLE_88__LinkLevelCount__SHIFT 0x8
#define DPM_TABLE_88__MemoryDpmLevelCount_MASK 0xff0000
#define DPM_TABLE_88__MemoryDpmLevelCount__SHIFT 0x10
#define DPM_TABLE_88__GraphicsDpmLevelCount_MASK 0xff000000
#define DPM_TABLE_88__GraphicsDpmLevelCount__SHIFT 0x18
#define DPM_TABLE_89__SamuLevelCount_MASK 0xff
#define DPM_TABLE_89__SamuLevelCount__SHIFT 0x0
#define DPM_TABLE_89__AcpLevelCount_MASK 0xff00
#define DPM_TABLE_89__AcpLevelCount__SHIFT 0x8
#define DPM_TABLE_89__VceLevelCount_MASK 0xff0000
#define DPM_TABLE_89__VceLevelCount__SHIFT 0x10
#define DPM_TABLE_89__UvdLevelCount_MASK 0xff000000
#define DPM_TABLE_89__UvdLevelCount__SHIFT 0x18
#define DPM_TABLE_90__Reserved_0_MASK 0xff
#define DPM_TABLE_90__Reserved_0__SHIFT 0x0
#define DPM_TABLE_90__ThermOutMode_MASK 0xff00
#define DPM_TABLE_90__ThermOutMode__SHIFT 0x8
#define DPM_TABLE_90__ThermOutPolarity_MASK 0xff0000
#define DPM_TABLE_90__ThermOutPolarity__SHIFT 0x10
#define DPM_TABLE_90__ThermOutGpio_MASK 0xff000000
#define DPM_TABLE_90__ThermOutGpio__SHIFT 0x18
#define DPM_TABLE_91__Reserved_0_MASK 0xffffffff
#define DPM_TABLE_91__Reserved_0__SHIFT 0x0
#define DPM_TABLE_92__Reserved_1_MASK 0xffffffff
#define DPM_TABLE_92__Reserved_1__SHIFT 0x0
#define DPM_TABLE_93__Reserved_2_MASK 0xffffffff
#define DPM_TABLE_93__Reserved_2__SHIFT 0x0
#define DPM_TABLE_94__Reserved_3_MASK 0xffffffff
#define DPM_TABLE_94__Reserved_3__SHIFT 0x0
#define DPM_TABLE_95__GraphicsLevel_0_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_95__GraphicsLevel_0_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_95__GraphicsLevel_0_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_95__GraphicsLevel_0_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_95__GraphicsLevel_0_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_95__GraphicsLevel_0_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_95__GraphicsLevel_0_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_95__GraphicsLevel_0_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_96__GraphicsLevel_0_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_96__GraphicsLevel_0_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_97__GraphicsLevel_0_ActivityLevel_MASK 0xffff
#define DPM_TABLE_97__GraphicsLevel_0_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_97__GraphicsLevel_0_DeepSleepDivId_MASK 0xff0000
#define DPM_TABLE_97__GraphicsLevel_0_DeepSleepDivId__SHIFT 0x10
#define DPM_TABLE_97__GraphicsLevel_0_pcieDpmLevel_MASK 0xff000000
#define DPM_TABLE_97__GraphicsLevel_0_pcieDpmLevel__SHIFT 0x18
#define DPM_TABLE_98__GraphicsLevel_0_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_98__GraphicsLevel_0_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_99__GraphicsLevel_0_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_99__GraphicsLevel_0_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_100__GraphicsLevel_0_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_100__GraphicsLevel_0_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_101__GraphicsLevel_0_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_101__GraphicsLevel_0_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_102__GraphicsLevel_0_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_102__GraphicsLevel_0_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_103__GraphicsLevel_0_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_103__GraphicsLevel_0_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_104__GraphicsLevel_0_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_104__GraphicsLevel_0_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_104__GraphicsLevel_0_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_104__GraphicsLevel_0_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_104__GraphicsLevel_0_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_104__GraphicsLevel_0_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_104__GraphicsLevel_0_SclkDid_MASK 0xff000000
#define DPM_TABLE_104__GraphicsLevel_0_SclkDid__SHIFT 0x18
#define DPM_TABLE_105__GraphicsLevel_0_PowerThrottle_MASK 0xff
#define DPM_TABLE_105__GraphicsLevel_0_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_105__GraphicsLevel_0_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_105__GraphicsLevel_0_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_105__GraphicsLevel_0_DownHyst_MASK 0xff0000
#define DPM_TABLE_105__GraphicsLevel_0_DownHyst__SHIFT 0x10
#define DPM_TABLE_105__GraphicsLevel_0_UpHyst_MASK 0xff000000
#define DPM_TABLE_105__GraphicsLevel_0_UpHyst__SHIFT 0x18
#define DPM_TABLE_106__GraphicsLevel_1_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_106__GraphicsLevel_1_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_106__GraphicsLevel_1_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_106__GraphicsLevel_1_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_106__GraphicsLevel_1_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_106__GraphicsLevel_1_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_106__GraphicsLevel_1_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_106__GraphicsLevel_1_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_107__GraphicsLevel_1_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_107__GraphicsLevel_1_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_108__GraphicsLevel_1_ActivityLevel_MASK 0xffff
#define DPM_TABLE_108__GraphicsLevel_1_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_108__GraphicsLevel_1_DeepSleepDivId_MASK 0xff0000
#define DPM_TABLE_108__GraphicsLevel_1_DeepSleepDivId__SHIFT 0x10
#define DPM_TABLE_108__GraphicsLevel_1_pcieDpmLevel_MASK 0xff000000
#define DPM_TABLE_108__GraphicsLevel_1_pcieDpmLevel__SHIFT 0x18
#define DPM_TABLE_109__GraphicsLevel_1_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_109__GraphicsLevel_1_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_110__GraphicsLevel_1_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_110__GraphicsLevel_1_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_111__GraphicsLevel_1_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_111__GraphicsLevel_1_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_112__GraphicsLevel_1_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_112__GraphicsLevel_1_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_113__GraphicsLevel_1_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_113__GraphicsLevel_1_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_114__GraphicsLevel_1_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_114__GraphicsLevel_1_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_115__GraphicsLevel_1_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_115__GraphicsLevel_1_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_115__GraphicsLevel_1_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_115__GraphicsLevel_1_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_115__GraphicsLevel_1_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_115__GraphicsLevel_1_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_115__GraphicsLevel_1_SclkDid_MASK 0xff000000
#define DPM_TABLE_115__GraphicsLevel_1_SclkDid__SHIFT 0x18
#define DPM_TABLE_116__GraphicsLevel_1_PowerThrottle_MASK 0xff
#define DPM_TABLE_116__GraphicsLevel_1_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_116__GraphicsLevel_1_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_116__GraphicsLevel_1_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_116__GraphicsLevel_1_DownHyst_MASK 0xff0000
#define DPM_TABLE_116__GraphicsLevel_1_DownHyst__SHIFT 0x10
#define DPM_TABLE_116__GraphicsLevel_1_UpHyst_MASK 0xff000000
#define DPM_TABLE_116__GraphicsLevel_1_UpHyst__SHIFT 0x18
#define DPM_TABLE_117__GraphicsLevel_2_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_117__GraphicsLevel_2_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_117__GraphicsLevel_2_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_117__GraphicsLevel_2_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_117__GraphicsLevel_2_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_117__GraphicsLevel_2_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_117__GraphicsLevel_2_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_117__GraphicsLevel_2_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_118__GraphicsLevel_2_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_118__GraphicsLevel_2_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_119__GraphicsLevel_2_ActivityLevel_MASK 0xffff
#define DPM_TABLE_119__GraphicsLevel_2_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_119__GraphicsLevel_2_DeepSleepDivId_MASK 0xff0000
#define DPM_TABLE_119__GraphicsLevel_2_DeepSleepDivId__SHIFT 0x10
#define DPM_TABLE_119__GraphicsLevel_2_pcieDpmLevel_MASK 0xff000000
#define DPM_TABLE_119__GraphicsLevel_2_pcieDpmLevel__SHIFT 0x18
#define DPM_TABLE_120__GraphicsLevel_2_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_120__GraphicsLevel_2_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_121__GraphicsLevel_2_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_121__GraphicsLevel_2_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_122__GraphicsLevel_2_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_122__GraphicsLevel_2_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_123__GraphicsLevel_2_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_123__GraphicsLevel_2_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_124__GraphicsLevel_2_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_124__GraphicsLevel_2_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_125__GraphicsLevel_2_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_125__GraphicsLevel_2_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_126__GraphicsLevel_2_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_126__GraphicsLevel_2_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_126__GraphicsLevel_2_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_126__GraphicsLevel_2_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_126__GraphicsLevel_2_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_126__GraphicsLevel_2_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_126__GraphicsLevel_2_SclkDid_MASK 0xff000000
#define DPM_TABLE_126__GraphicsLevel_2_SclkDid__SHIFT 0x18
#define DPM_TABLE_127__GraphicsLevel_2_PowerThrottle_MASK 0xff
#define DPM_TABLE_127__GraphicsLevel_2_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_127__GraphicsLevel_2_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_127__GraphicsLevel_2_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_127__GraphicsLevel_2_DownHyst_MASK 0xff0000
#define DPM_TABLE_127__GraphicsLevel_2_DownHyst__SHIFT 0x10
#define DPM_TABLE_127__GraphicsLevel_2_UpHyst_MASK 0xff000000
#define DPM_TABLE_127__GraphicsLevel_2_UpHyst__SHIFT 0x18
#define DPM_TABLE_128__GraphicsLevel_3_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_128__GraphicsLevel_3_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_128__GraphicsLevel_3_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_128__GraphicsLevel_3_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_128__GraphicsLevel_3_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_128__GraphicsLevel_3_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_128__GraphicsLevel_3_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_128__GraphicsLevel_3_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_129__GraphicsLevel_3_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_129__GraphicsLevel_3_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_130__GraphicsLevel_3_ActivityLevel_MASK 0xffff
#define DPM_TABLE_130__GraphicsLevel_3_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_130__GraphicsLevel_3_DeepSleepDivId_MASK 0xff0000
#define DPM_TABLE_130__GraphicsLevel_3_DeepSleepDivId__SHIFT 0x10
#define DPM_TABLE_130__GraphicsLevel_3_pcieDpmLevel_MASK 0xff000000
#define DPM_TABLE_130__GraphicsLevel_3_pcieDpmLevel__SHIFT 0x18
#define DPM_TABLE_131__GraphicsLevel_3_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_131__GraphicsLevel_3_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_132__GraphicsLevel_3_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_132__GraphicsLevel_3_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_133__GraphicsLevel_3_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_133__GraphicsLevel_3_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_134__GraphicsLevel_3_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_134__GraphicsLevel_3_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_135__GraphicsLevel_3_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_135__GraphicsLevel_3_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_136__GraphicsLevel_3_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_136__GraphicsLevel_3_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_137__GraphicsLevel_3_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_137__GraphicsLevel_3_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_137__GraphicsLevel_3_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_137__GraphicsLevel_3_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_137__GraphicsLevel_3_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_137__GraphicsLevel_3_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_137__GraphicsLevel_3_SclkDid_MASK 0xff000000
#define DPM_TABLE_137__GraphicsLevel_3_SclkDid__SHIFT 0x18
#define DPM_TABLE_138__GraphicsLevel_3_PowerThrottle_MASK 0xff
#define DPM_TABLE_138__GraphicsLevel_3_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_138__GraphicsLevel_3_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_138__GraphicsLevel_3_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_138__GraphicsLevel_3_DownHyst_MASK 0xff0000
#define DPM_TABLE_138__GraphicsLevel_3_DownHyst__SHIFT 0x10
#define DPM_TABLE_138__GraphicsLevel_3_UpHyst_MASK 0xff000000
#define DPM_TABLE_138__GraphicsLevel_3_UpHyst__SHIFT 0x18
#define DPM_TABLE_139__GraphicsLevel_4_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_139__GraphicsLevel_4_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_139__GraphicsLevel_4_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_139__GraphicsLevel_4_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_139__GraphicsLevel_4_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_139__GraphicsLevel_4_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_139__GraphicsLevel_4_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_139__GraphicsLevel_4_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_140__GraphicsLevel_4_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_140__GraphicsLevel_4_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_141__GraphicsLevel_4_ActivityLevel_MASK 0xffff
#define DPM_TABLE_141__GraphicsLevel_4_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_141__GraphicsLevel_4_DeepSleepDivId_MASK 0xff0000
#define DPM_TABLE_141__GraphicsLevel_4_DeepSleepDivId__SHIFT 0x10
#define DPM_TABLE_141__GraphicsLevel_4_pcieDpmLevel_MASK 0xff000000
#define DPM_TABLE_141__GraphicsLevel_4_pcieDpmLevel__SHIFT 0x18
#define DPM_TABLE_142__GraphicsLevel_4_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_142__GraphicsLevel_4_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_143__GraphicsLevel_4_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_143__GraphicsLevel_4_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_144__GraphicsLevel_4_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_144__GraphicsLevel_4_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_145__GraphicsLevel_4_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_145__GraphicsLevel_4_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_146__GraphicsLevel_4_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_146__GraphicsLevel_4_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_147__GraphicsLevel_4_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_147__GraphicsLevel_4_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_148__GraphicsLevel_4_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_148__GraphicsLevel_4_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_148__GraphicsLevel_4_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_148__GraphicsLevel_4_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_148__GraphicsLevel_4_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_148__GraphicsLevel_4_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_148__GraphicsLevel_4_SclkDid_MASK 0xff000000
#define DPM_TABLE_148__GraphicsLevel_4_SclkDid__SHIFT 0x18
#define DPM_TABLE_149__GraphicsLevel_4_PowerThrottle_MASK 0xff
#define DPM_TABLE_149__GraphicsLevel_4_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_149__GraphicsLevel_4_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_149__GraphicsLevel_4_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_149__GraphicsLevel_4_DownHyst_MASK 0xff0000
#define DPM_TABLE_149__GraphicsLevel_4_DownHyst__SHIFT 0x10
#define DPM_TABLE_149__GraphicsLevel_4_UpHyst_MASK 0xff000000
#define DPM_TABLE_149__GraphicsLevel_4_UpHyst__SHIFT 0x18
#define DPM_TABLE_150__GraphicsLevel_5_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_150__GraphicsLevel_5_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_150__GraphicsLevel_5_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_150__GraphicsLevel_5_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_150__GraphicsLevel_5_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_150__GraphicsLevel_5_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_150__GraphicsLevel_5_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_150__GraphicsLevel_5_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_151__GraphicsLevel_5_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_151__GraphicsLevel_5_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_152__GraphicsLevel_5_ActivityLevel_MASK 0xffff
#define DPM_TABLE_152__GraphicsLevel_5_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_152__GraphicsLevel_5_DeepSleepDivId_MASK 0xff0000
#define DPM_TABLE_152__GraphicsLevel_5_DeepSleepDivId__SHIFT 0x10
#define DPM_TABLE_152__GraphicsLevel_5_pcieDpmLevel_MASK 0xff000000
#define DPM_TABLE_152__GraphicsLevel_5_pcieDpmLevel__SHIFT 0x18
#define DPM_TABLE_153__GraphicsLevel_5_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_153__GraphicsLevel_5_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_154__GraphicsLevel_5_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_154__GraphicsLevel_5_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_155__GraphicsLevel_5_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_155__GraphicsLevel_5_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_156__GraphicsLevel_5_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_156__GraphicsLevel_5_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_157__GraphicsLevel_5_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_157__GraphicsLevel_5_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_158__GraphicsLevel_5_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_158__GraphicsLevel_5_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_159__GraphicsLevel_5_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_159__GraphicsLevel_5_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_159__GraphicsLevel_5_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_159__GraphicsLevel_5_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_159__GraphicsLevel_5_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_159__GraphicsLevel_5_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_159__GraphicsLevel_5_SclkDid_MASK 0xff000000
#define DPM_TABLE_159__GraphicsLevel_5_SclkDid__SHIFT 0x18
#define DPM_TABLE_160__GraphicsLevel_5_PowerThrottle_MASK 0xff
#define DPM_TABLE_160__GraphicsLevel_5_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_160__GraphicsLevel_5_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_160__GraphicsLevel_5_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_160__GraphicsLevel_5_DownHyst_MASK 0xff0000
#define DPM_TABLE_160__GraphicsLevel_5_DownHyst__SHIFT 0x10
#define DPM_TABLE_160__GraphicsLevel_5_UpHyst_MASK 0xff000000
#define DPM_TABLE_160__GraphicsLevel_5_UpHyst__SHIFT 0x18
#define DPM_TABLE_161__GraphicsLevel_6_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_161__GraphicsLevel_6_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_161__GraphicsLevel_6_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_161__GraphicsLevel_6_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_161__GraphicsLevel_6_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_161__GraphicsLevel_6_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_161__GraphicsLevel_6_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_161__GraphicsLevel_6_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_162__GraphicsLevel_6_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_162__GraphicsLevel_6_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_163__GraphicsLevel_6_ActivityLevel_MASK 0xffff
#define DPM_TABLE_163__GraphicsLevel_6_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_163__GraphicsLevel_6_DeepSleepDivId_MASK 0xff0000
#define DPM_TABLE_163__GraphicsLevel_6_DeepSleepDivId__SHIFT 0x10
#define DPM_TABLE_163__GraphicsLevel_6_pcieDpmLevel_MASK 0xff000000
#define DPM_TABLE_163__GraphicsLevel_6_pcieDpmLevel__SHIFT 0x18
#define DPM_TABLE_164__GraphicsLevel_6_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_164__GraphicsLevel_6_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_165__GraphicsLevel_6_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_165__GraphicsLevel_6_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_166__GraphicsLevel_6_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_166__GraphicsLevel_6_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_167__GraphicsLevel_6_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_167__GraphicsLevel_6_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_168__GraphicsLevel_6_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_168__GraphicsLevel_6_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_169__GraphicsLevel_6_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_169__GraphicsLevel_6_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_170__GraphicsLevel_6_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_170__GraphicsLevel_6_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_170__GraphicsLevel_6_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_170__GraphicsLevel_6_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_170__GraphicsLevel_6_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_170__GraphicsLevel_6_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_170__GraphicsLevel_6_SclkDid_MASK 0xff000000
#define DPM_TABLE_170__GraphicsLevel_6_SclkDid__SHIFT 0x18
#define DPM_TABLE_171__GraphicsLevel_6_PowerThrottle_MASK 0xff
#define DPM_TABLE_171__GraphicsLevel_6_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_171__GraphicsLevel_6_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_171__GraphicsLevel_6_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_171__GraphicsLevel_6_DownHyst_MASK 0xff0000
#define DPM_TABLE_171__GraphicsLevel_6_DownHyst__SHIFT 0x10
#define DPM_TABLE_171__GraphicsLevel_6_UpHyst_MASK 0xff000000
#define DPM_TABLE_171__GraphicsLevel_6_UpHyst__SHIFT 0x18
#define DPM_TABLE_172__GraphicsLevel_7_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_172__GraphicsLevel_7_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_172__GraphicsLevel_7_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_172__GraphicsLevel_7_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_172__GraphicsLevel_7_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_172__GraphicsLevel_7_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_172__GraphicsLevel_7_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_172__GraphicsLevel_7_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_173__GraphicsLevel_7_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_173__GraphicsLevel_7_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_174__GraphicsLevel_7_ActivityLevel_MASK 0xffff
#define DPM_TABLE_174__GraphicsLevel_7_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_174__GraphicsLevel_7_DeepSleepDivId_MASK 0xff0000
#define DPM_TABLE_174__GraphicsLevel_7_DeepSleepDivId__SHIFT 0x10
#define DPM_TABLE_174__GraphicsLevel_7_pcieDpmLevel_MASK 0xff000000
#define DPM_TABLE_174__GraphicsLevel_7_pcieDpmLevel__SHIFT 0x18
#define DPM_TABLE_175__GraphicsLevel_7_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_175__GraphicsLevel_7_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_176__GraphicsLevel_7_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_176__GraphicsLevel_7_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_177__GraphicsLevel_7_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_177__GraphicsLevel_7_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_178__GraphicsLevel_7_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_178__GraphicsLevel_7_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_179__GraphicsLevel_7_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_179__GraphicsLevel_7_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_180__GraphicsLevel_7_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_180__GraphicsLevel_7_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_181__GraphicsLevel_7_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_181__GraphicsLevel_7_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_181__GraphicsLevel_7_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_181__GraphicsLevel_7_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_181__GraphicsLevel_7_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_181__GraphicsLevel_7_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_181__GraphicsLevel_7_SclkDid_MASK 0xff000000
#define DPM_TABLE_181__GraphicsLevel_7_SclkDid__SHIFT 0x18
#define DPM_TABLE_182__GraphicsLevel_7_PowerThrottle_MASK 0xff
#define DPM_TABLE_182__GraphicsLevel_7_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_182__GraphicsLevel_7_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_182__GraphicsLevel_7_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_182__GraphicsLevel_7_DownHyst_MASK 0xff0000
#define DPM_TABLE_182__GraphicsLevel_7_DownHyst__SHIFT 0x10
#define DPM_TABLE_182__GraphicsLevel_7_UpHyst_MASK 0xff000000
#define DPM_TABLE_182__GraphicsLevel_7_UpHyst__SHIFT 0x18
#define DPM_TABLE_183__MemoryACPILevel_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_183__MemoryACPILevel_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_183__MemoryACPILevel_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_183__MemoryACPILevel_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_183__MemoryACPILevel_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_183__MemoryACPILevel_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_183__MemoryACPILevel_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_183__MemoryACPILevel_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_184__MemoryACPILevel_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_184__MemoryACPILevel_MinMvdd__SHIFT 0x0
#define DPM_TABLE_185__MemoryACPILevel_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_185__MemoryACPILevel_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_186__MemoryACPILevel_EnabledForActivity_MASK 0xff
#define DPM_TABLE_186__MemoryACPILevel_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_186__MemoryACPILevel_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_186__MemoryACPILevel_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_186__MemoryACPILevel_FreqRange_MASK 0xff0000
#define DPM_TABLE_186__MemoryACPILevel_FreqRange__SHIFT 0x10
#define DPM_TABLE_186__MemoryACPILevel_StutterEnable_MASK 0xff000000
#define DPM_TABLE_186__MemoryACPILevel_StutterEnable__SHIFT 0x18
#define DPM_TABLE_187__MemoryACPILevel_padding_MASK 0xff
#define DPM_TABLE_187__MemoryACPILevel_padding__SHIFT 0x0
#define DPM_TABLE_187__MemoryACPILevel_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_187__MemoryACPILevel_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_187__MemoryACPILevel_DownHyst_MASK 0xff0000
#define DPM_TABLE_187__MemoryACPILevel_DownHyst__SHIFT 0x10
#define DPM_TABLE_187__MemoryACPILevel_UpHyst_MASK 0xff000000
#define DPM_TABLE_187__MemoryACPILevel_UpHyst__SHIFT 0x18
#define DPM_TABLE_188__MemoryACPILevel_MclkDivider_MASK 0xff
#define DPM_TABLE_188__MemoryACPILevel_MclkDivider__SHIFT 0x0
#define DPM_TABLE_188__MemoryACPILevel_DisplayWatermark_MASK 0xff00
#define DPM_TABLE_188__MemoryACPILevel_DisplayWatermark__SHIFT 0x8
#define DPM_TABLE_188__MemoryACPILevel_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_188__MemoryACPILevel_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_189__MemoryLevel_0_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_189__MemoryLevel_0_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_189__MemoryLevel_0_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_189__MemoryLevel_0_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_189__MemoryLevel_0_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_189__MemoryLevel_0_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_189__MemoryLevel_0_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_189__MemoryLevel_0_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_190__MemoryLevel_0_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_190__MemoryLevel_0_MinMvdd__SHIFT 0x0
#define DPM_TABLE_191__MemoryLevel_0_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_191__MemoryLevel_0_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_192__MemoryLevel_0_EnabledForActivity_MASK 0xff
#define DPM_TABLE_192__MemoryLevel_0_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_192__MemoryLevel_0_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_192__MemoryLevel_0_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_192__MemoryLevel_0_FreqRange_MASK 0xff0000
#define DPM_TABLE_192__MemoryLevel_0_FreqRange__SHIFT 0x10
#define DPM_TABLE_192__MemoryLevel_0_StutterEnable_MASK 0xff000000
#define DPM_TABLE_192__MemoryLevel_0_StutterEnable__SHIFT 0x18
#define DPM_TABLE_193__MemoryLevel_0_padding_MASK 0xff
#define DPM_TABLE_193__MemoryLevel_0_padding__SHIFT 0x0
#define DPM_TABLE_193__MemoryLevel_0_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_193__MemoryLevel_0_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_193__MemoryLevel_0_DownHyst_MASK 0xff0000
#define DPM_TABLE_193__MemoryLevel_0_DownHyst__SHIFT 0x10
#define DPM_TABLE_193__MemoryLevel_0_UpHyst_MASK 0xff000000
#define DPM_TABLE_193__MemoryLevel_0_UpHyst__SHIFT 0x18
#define DPM_TABLE_194__MemoryLevel_0_MclkDivider_MASK 0xff
#define DPM_TABLE_194__MemoryLevel_0_MclkDivider__SHIFT 0x0
#define DPM_TABLE_194__MemoryLevel_0_DisplayWatermark_MASK 0xff00
#define DPM_TABLE_194__MemoryLevel_0_DisplayWatermark__SHIFT 0x8
#define DPM_TABLE_194__MemoryLevel_0_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_194__MemoryLevel_0_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_195__MemoryLevel_1_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_195__MemoryLevel_1_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_195__MemoryLevel_1_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_195__MemoryLevel_1_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_195__MemoryLevel_1_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_195__MemoryLevel_1_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_195__MemoryLevel_1_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_195__MemoryLevel_1_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_196__MemoryLevel_1_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_196__MemoryLevel_1_MinMvdd__SHIFT 0x0
#define DPM_TABLE_197__MemoryLevel_1_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_197__MemoryLevel_1_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_198__MemoryLevel_1_EnabledForActivity_MASK 0xff
#define DPM_TABLE_198__MemoryLevel_1_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_198__MemoryLevel_1_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_198__MemoryLevel_1_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_198__MemoryLevel_1_FreqRange_MASK 0xff0000
#define DPM_TABLE_198__MemoryLevel_1_FreqRange__SHIFT 0x10
#define DPM_TABLE_198__MemoryLevel_1_StutterEnable_MASK 0xff000000
#define DPM_TABLE_198__MemoryLevel_1_StutterEnable__SHIFT 0x18
#define DPM_TABLE_199__MemoryLevel_1_padding_MASK 0xff
#define DPM_TABLE_199__MemoryLevel_1_padding__SHIFT 0x0
#define DPM_TABLE_199__MemoryLevel_1_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_199__MemoryLevel_1_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_199__MemoryLevel_1_DownHyst_MASK 0xff0000
#define DPM_TABLE_199__MemoryLevel_1_DownHyst__SHIFT 0x10
#define DPM_TABLE_199__MemoryLevel_1_UpHyst_MASK 0xff000000
#define DPM_TABLE_199__MemoryLevel_1_UpHyst__SHIFT 0x18
#define DPM_TABLE_200__MemoryLevel_1_MclkDivider_MASK 0xff
#define DPM_TABLE_200__MemoryLevel_1_MclkDivider__SHIFT 0x0
#define DPM_TABLE_200__MemoryLevel_1_DisplayWatermark_MASK 0xff00
#define DPM_TABLE_200__MemoryLevel_1_DisplayWatermark__SHIFT 0x8
#define DPM_TABLE_200__MemoryLevel_1_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_200__MemoryLevel_1_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_201__MemoryLevel_2_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_201__MemoryLevel_2_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_201__MemoryLevel_2_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_201__MemoryLevel_2_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_201__MemoryLevel_2_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_201__MemoryLevel_2_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_201__MemoryLevel_2_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_201__MemoryLevel_2_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_202__MemoryLevel_2_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_202__MemoryLevel_2_MinMvdd__SHIFT 0x0
#define DPM_TABLE_203__MemoryLevel_2_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_203__MemoryLevel_2_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_204__MemoryLevel_2_EnabledForActivity_MASK 0xff
#define DPM_TABLE_204__MemoryLevel_2_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_204__MemoryLevel_2_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_204__MemoryLevel_2_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_204__MemoryLevel_2_FreqRange_MASK 0xff0000
#define DPM_TABLE_204__MemoryLevel_2_FreqRange__SHIFT 0x10
#define DPM_TABLE_204__MemoryLevel_2_StutterEnable_MASK 0xff000000
#define DPM_TABLE_204__MemoryLevel_2_StutterEnable__SHIFT 0x18
#define DPM_TABLE_205__MemoryLevel_2_padding_MASK 0xff
#define DPM_TABLE_205__MemoryLevel_2_padding__SHIFT 0x0
#define DPM_TABLE_205__MemoryLevel_2_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_205__MemoryLevel_2_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_205__MemoryLevel_2_DownHyst_MASK 0xff0000
#define DPM_TABLE_205__MemoryLevel_2_DownHyst__SHIFT 0x10
#define DPM_TABLE_205__MemoryLevel_2_UpHyst_MASK 0xff000000
#define DPM_TABLE_205__MemoryLevel_2_UpHyst__SHIFT 0x18
#define DPM_TABLE_206__MemoryLevel_2_MclkDivider_MASK 0xff
#define DPM_TABLE_206__MemoryLevel_2_MclkDivider__SHIFT 0x0
#define DPM_TABLE_206__MemoryLevel_2_DisplayWatermark_MASK 0xff00
#define DPM_TABLE_206__MemoryLevel_2_DisplayWatermark__SHIFT 0x8
#define DPM_TABLE_206__MemoryLevel_2_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_206__MemoryLevel_2_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_207__MemoryLevel_3_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_207__MemoryLevel_3_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_207__MemoryLevel_3_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_207__MemoryLevel_3_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_207__MemoryLevel_3_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_207__MemoryLevel_3_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_207__MemoryLevel_3_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_207__MemoryLevel_3_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_208__MemoryLevel_3_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_208__MemoryLevel_3_MinMvdd__SHIFT 0x0
#define DPM_TABLE_209__MemoryLevel_3_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_209__MemoryLevel_3_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_210__MemoryLevel_3_EnabledForActivity_MASK 0xff
#define DPM_TABLE_210__MemoryLevel_3_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_210__MemoryLevel_3_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_210__MemoryLevel_3_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_210__MemoryLevel_3_FreqRange_MASK 0xff0000
#define DPM_TABLE_210__MemoryLevel_3_FreqRange__SHIFT 0x10
#define DPM_TABLE_210__MemoryLevel_3_StutterEnable_MASK 0xff000000
#define DPM_TABLE_210__MemoryLevel_3_StutterEnable__SHIFT 0x18
#define DPM_TABLE_211__MemoryLevel_3_padding_MASK 0xff
#define DPM_TABLE_211__MemoryLevel_3_padding__SHIFT 0x0
#define DPM_TABLE_211__MemoryLevel_3_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_211__MemoryLevel_3_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_211__MemoryLevel_3_DownHyst_MASK 0xff0000
#define DPM_TABLE_211__MemoryLevel_3_DownHyst__SHIFT 0x10
#define DPM_TABLE_211__MemoryLevel_3_UpHyst_MASK 0xff000000
#define DPM_TABLE_211__MemoryLevel_3_UpHyst__SHIFT 0x18
#define DPM_TABLE_212__MemoryLevel_3_MclkDivider_MASK 0xff
#define DPM_TABLE_212__MemoryLevel_3_MclkDivider__SHIFT 0x0
#define DPM_TABLE_212__MemoryLevel_3_DisplayWatermark_MASK 0xff00
#define DPM_TABLE_212__MemoryLevel_3_DisplayWatermark__SHIFT 0x8
#define DPM_TABLE_212__MemoryLevel_3_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_212__MemoryLevel_3_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_213__LinkLevel_0_SPC_MASK 0xff
#define DPM_TABLE_213__LinkLevel_0_SPC__SHIFT 0x0
#define DPM_TABLE_213__LinkLevel_0_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_213__LinkLevel_0_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_213__LinkLevel_0_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_213__LinkLevel_0_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_213__LinkLevel_0_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_213__LinkLevel_0_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_214__LinkLevel_0_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_214__LinkLevel_0_DownThreshold__SHIFT 0x0
#define DPM_TABLE_215__LinkLevel_0_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_215__LinkLevel_0_UpThreshold__SHIFT 0x0
#define DPM_TABLE_216__LinkLevel_0_Reserved_MASK 0xffffffff
#define DPM_TABLE_216__LinkLevel_0_Reserved__SHIFT 0x0
#define DPM_TABLE_217__LinkLevel_1_SPC_MASK 0xff
#define DPM_TABLE_217__LinkLevel_1_SPC__SHIFT 0x0
#define DPM_TABLE_217__LinkLevel_1_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_217__LinkLevel_1_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_217__LinkLevel_1_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_217__LinkLevel_1_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_217__LinkLevel_1_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_217__LinkLevel_1_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_218__LinkLevel_1_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_218__LinkLevel_1_DownThreshold__SHIFT 0x0
#define DPM_TABLE_219__LinkLevel_1_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_219__LinkLevel_1_UpThreshold__SHIFT 0x0
#define DPM_TABLE_220__LinkLevel_1_Reserved_MASK 0xffffffff
#define DPM_TABLE_220__LinkLevel_1_Reserved__SHIFT 0x0
#define DPM_TABLE_221__LinkLevel_2_SPC_MASK 0xff
#define DPM_TABLE_221__LinkLevel_2_SPC__SHIFT 0x0
#define DPM_TABLE_221__LinkLevel_2_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_221__LinkLevel_2_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_221__LinkLevel_2_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_221__LinkLevel_2_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_221__LinkLevel_2_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_221__LinkLevel_2_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_222__LinkLevel_2_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_222__LinkLevel_2_DownThreshold__SHIFT 0x0
#define DPM_TABLE_223__LinkLevel_2_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_223__LinkLevel_2_UpThreshold__SHIFT 0x0
#define DPM_TABLE_224__LinkLevel_2_Reserved_MASK 0xffffffff
#define DPM_TABLE_224__LinkLevel_2_Reserved__SHIFT 0x0
#define DPM_TABLE_225__LinkLevel_3_SPC_MASK 0xff
#define DPM_TABLE_225__LinkLevel_3_SPC__SHIFT 0x0
#define DPM_TABLE_225__LinkLevel_3_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_225__LinkLevel_3_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_225__LinkLevel_3_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_225__LinkLevel_3_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_225__LinkLevel_3_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_225__LinkLevel_3_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_226__LinkLevel_3_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_226__LinkLevel_3_DownThreshold__SHIFT 0x0
#define DPM_TABLE_227__LinkLevel_3_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_227__LinkLevel_3_UpThreshold__SHIFT 0x0
#define DPM_TABLE_228__LinkLevel_3_Reserved_MASK 0xffffffff
#define DPM_TABLE_228__LinkLevel_3_Reserved__SHIFT 0x0
#define DPM_TABLE_229__LinkLevel_4_SPC_MASK 0xff
#define DPM_TABLE_229__LinkLevel_4_SPC__SHIFT 0x0
#define DPM_TABLE_229__LinkLevel_4_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_229__LinkLevel_4_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_229__LinkLevel_4_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_229__LinkLevel_4_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_229__LinkLevel_4_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_229__LinkLevel_4_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_230__LinkLevel_4_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_230__LinkLevel_4_DownThreshold__SHIFT 0x0
#define DPM_TABLE_231__LinkLevel_4_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_231__LinkLevel_4_UpThreshold__SHIFT 0x0
#define DPM_TABLE_232__LinkLevel_4_Reserved_MASK 0xffffffff
#define DPM_TABLE_232__LinkLevel_4_Reserved__SHIFT 0x0
#define DPM_TABLE_233__LinkLevel_5_SPC_MASK 0xff
#define DPM_TABLE_233__LinkLevel_5_SPC__SHIFT 0x0
#define DPM_TABLE_233__LinkLevel_5_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_233__LinkLevel_5_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_233__LinkLevel_5_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_233__LinkLevel_5_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_233__LinkLevel_5_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_233__LinkLevel_5_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_234__LinkLevel_5_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_234__LinkLevel_5_DownThreshold__SHIFT 0x0
#define DPM_TABLE_235__LinkLevel_5_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_235__LinkLevel_5_UpThreshold__SHIFT 0x0
#define DPM_TABLE_236__LinkLevel_5_Reserved_MASK 0xffffffff
#define DPM_TABLE_236__LinkLevel_5_Reserved__SHIFT 0x0
#define DPM_TABLE_237__LinkLevel_6_SPC_MASK 0xff
#define DPM_TABLE_237__LinkLevel_6_SPC__SHIFT 0x0
#define DPM_TABLE_237__LinkLevel_6_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_237__LinkLevel_6_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_237__LinkLevel_6_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_237__LinkLevel_6_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_237__LinkLevel_6_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_237__LinkLevel_6_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_238__LinkLevel_6_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_238__LinkLevel_6_DownThreshold__SHIFT 0x0
#define DPM_TABLE_239__LinkLevel_6_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_239__LinkLevel_6_UpThreshold__SHIFT 0x0
#define DPM_TABLE_240__LinkLevel_6_Reserved_MASK 0xffffffff
#define DPM_TABLE_240__LinkLevel_6_Reserved__SHIFT 0x0
#define DPM_TABLE_241__LinkLevel_7_SPC_MASK 0xff
#define DPM_TABLE_241__LinkLevel_7_SPC__SHIFT 0x0
#define DPM_TABLE_241__LinkLevel_7_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_241__LinkLevel_7_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_241__LinkLevel_7_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_241__LinkLevel_7_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_241__LinkLevel_7_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_241__LinkLevel_7_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_242__LinkLevel_7_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_242__LinkLevel_7_DownThreshold__SHIFT 0x0
#define DPM_TABLE_243__LinkLevel_7_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_243__LinkLevel_7_UpThreshold__SHIFT 0x0
#define DPM_TABLE_244__LinkLevel_7_Reserved_MASK 0xffffffff
#define DPM_TABLE_244__LinkLevel_7_Reserved__SHIFT 0x0
#define DPM_TABLE_245__ACPILevel_Flags_MASK 0xffffffff
#define DPM_TABLE_245__ACPILevel_Flags__SHIFT 0x0
#define DPM_TABLE_246__ACPILevel_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_246__ACPILevel_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_246__ACPILevel_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_246__ACPILevel_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_246__ACPILevel_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_246__ACPILevel_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_246__ACPILevel_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_246__ACPILevel_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_247__ACPILevel_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_247__ACPILevel_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_248__ACPILevel_padding_MASK 0xff
#define DPM_TABLE_248__ACPILevel_padding__SHIFT 0x0
#define DPM_TABLE_248__ACPILevel_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_248__ACPILevel_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_248__ACPILevel_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_248__ACPILevel_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_248__ACPILevel_SclkDid_MASK 0xff000000
#define DPM_TABLE_248__ACPILevel_SclkDid__SHIFT 0x18
#define DPM_TABLE_249__ACPILevel_CgSpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_249__ACPILevel_CgSpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_250__ACPILevel_CgSpllFuncCntl2_MASK 0xffffffff
#define DPM_TABLE_250__ACPILevel_CgSpllFuncCntl2__SHIFT 0x0
#define DPM_TABLE_251__ACPILevel_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_251__ACPILevel_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_252__ACPILevel_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_252__ACPILevel_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_253__ACPILevel_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_253__ACPILevel_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_254__ACPILevel_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_254__ACPILevel_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_255__ACPILevel_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_255__ACPILevel_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_256__ACPILevel_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_256__ACPILevel_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_257__UvdLevel_0_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_257__UvdLevel_0_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_258__UvdLevel_0_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_258__UvdLevel_0_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_259__UvdLevel_0_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_259__UvdLevel_0_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_259__UvdLevel_0_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_259__UvdLevel_0_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_259__UvdLevel_0_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_259__UvdLevel_0_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_259__UvdLevel_0_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_259__UvdLevel_0_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_260__UvdLevel_0_padding_1_MASK 0xff
#define DPM_TABLE_260__UvdLevel_0_padding_1__SHIFT 0x0
#define DPM_TABLE_260__UvdLevel_0_padding_0_MASK 0xff00
#define DPM_TABLE_260__UvdLevel_0_padding_0__SHIFT 0x8
#define DPM_TABLE_260__UvdLevel_0_DclkDivider_MASK 0xff0000
#define DPM_TABLE_260__UvdLevel_0_DclkDivider__SHIFT 0x10
#define DPM_TABLE_260__UvdLevel_0_VclkDivider_MASK 0xff000000
#define DPM_TABLE_260__UvdLevel_0_VclkDivider__SHIFT 0x18
#define DPM_TABLE_261__UvdLevel_1_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_261__UvdLevel_1_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_262__UvdLevel_1_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_262__UvdLevel_1_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_263__UvdLevel_1_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_263__UvdLevel_1_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_263__UvdLevel_1_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_263__UvdLevel_1_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_263__UvdLevel_1_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_263__UvdLevel_1_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_263__UvdLevel_1_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_263__UvdLevel_1_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_264__UvdLevel_1_padding_1_MASK 0xff
#define DPM_TABLE_264__UvdLevel_1_padding_1__SHIFT 0x0
#define DPM_TABLE_264__UvdLevel_1_padding_0_MASK 0xff00
#define DPM_TABLE_264__UvdLevel_1_padding_0__SHIFT 0x8
#define DPM_TABLE_264__UvdLevel_1_DclkDivider_MASK 0xff0000
#define DPM_TABLE_264__UvdLevel_1_DclkDivider__SHIFT 0x10
#define DPM_TABLE_264__UvdLevel_1_VclkDivider_MASK 0xff000000
#define DPM_TABLE_264__UvdLevel_1_VclkDivider__SHIFT 0x18
#define DPM_TABLE_265__UvdLevel_2_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_265__UvdLevel_2_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_266__UvdLevel_2_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_266__UvdLevel_2_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_267__UvdLevel_2_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_267__UvdLevel_2_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_267__UvdLevel_2_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_267__UvdLevel_2_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_267__UvdLevel_2_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_267__UvdLevel_2_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_267__UvdLevel_2_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_267__UvdLevel_2_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_268__UvdLevel_2_padding_1_MASK 0xff
#define DPM_TABLE_268__UvdLevel_2_padding_1__SHIFT 0x0
#define DPM_TABLE_268__UvdLevel_2_padding_0_MASK 0xff00
#define DPM_TABLE_268__UvdLevel_2_padding_0__SHIFT 0x8
#define DPM_TABLE_268__UvdLevel_2_DclkDivider_MASK 0xff0000
#define DPM_TABLE_268__UvdLevel_2_DclkDivider__SHIFT 0x10
#define DPM_TABLE_268__UvdLevel_2_VclkDivider_MASK 0xff000000
#define DPM_TABLE_268__UvdLevel_2_VclkDivider__SHIFT 0x18
#define DPM_TABLE_269__UvdLevel_3_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_269__UvdLevel_3_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_270__UvdLevel_3_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_270__UvdLevel_3_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_271__UvdLevel_3_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_271__UvdLevel_3_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_271__UvdLevel_3_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_271__UvdLevel_3_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_271__UvdLevel_3_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_271__UvdLevel_3_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_271__UvdLevel_3_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_271__UvdLevel_3_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_272__UvdLevel_3_padding_1_MASK 0xff
#define DPM_TABLE_272__UvdLevel_3_padding_1__SHIFT 0x0
#define DPM_TABLE_272__UvdLevel_3_padding_0_MASK 0xff00
#define DPM_TABLE_272__UvdLevel_3_padding_0__SHIFT 0x8
#define DPM_TABLE_272__UvdLevel_3_DclkDivider_MASK 0xff0000
#define DPM_TABLE_272__UvdLevel_3_DclkDivider__SHIFT 0x10
#define DPM_TABLE_272__UvdLevel_3_VclkDivider_MASK 0xff000000
#define DPM_TABLE_272__UvdLevel_3_VclkDivider__SHIFT 0x18
#define DPM_TABLE_273__UvdLevel_4_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_273__UvdLevel_4_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_274__UvdLevel_4_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_274__UvdLevel_4_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_275__UvdLevel_4_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_275__UvdLevel_4_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_275__UvdLevel_4_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_275__UvdLevel_4_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_275__UvdLevel_4_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_275__UvdLevel_4_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_275__UvdLevel_4_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_275__UvdLevel_4_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_276__UvdLevel_4_padding_1_MASK 0xff
#define DPM_TABLE_276__UvdLevel_4_padding_1__SHIFT 0x0
#define DPM_TABLE_276__UvdLevel_4_padding_0_MASK 0xff00
#define DPM_TABLE_276__UvdLevel_4_padding_0__SHIFT 0x8
#define DPM_TABLE_276__UvdLevel_4_DclkDivider_MASK 0xff0000
#define DPM_TABLE_276__UvdLevel_4_DclkDivider__SHIFT 0x10
#define DPM_TABLE_276__UvdLevel_4_VclkDivider_MASK 0xff000000
#define DPM_TABLE_276__UvdLevel_4_VclkDivider__SHIFT 0x18
#define DPM_TABLE_277__UvdLevel_5_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_277__UvdLevel_5_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_278__UvdLevel_5_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_278__UvdLevel_5_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_279__UvdLevel_5_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_279__UvdLevel_5_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_279__UvdLevel_5_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_279__UvdLevel_5_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_279__UvdLevel_5_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_279__UvdLevel_5_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_279__UvdLevel_5_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_279__UvdLevel_5_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_280__UvdLevel_5_padding_1_MASK 0xff
#define DPM_TABLE_280__UvdLevel_5_padding_1__SHIFT 0x0
#define DPM_TABLE_280__UvdLevel_5_padding_0_MASK 0xff00
#define DPM_TABLE_280__UvdLevel_5_padding_0__SHIFT 0x8
#define DPM_TABLE_280__UvdLevel_5_DclkDivider_MASK 0xff0000
#define DPM_TABLE_280__UvdLevel_5_DclkDivider__SHIFT 0x10
#define DPM_TABLE_280__UvdLevel_5_VclkDivider_MASK 0xff000000
#define DPM_TABLE_280__UvdLevel_5_VclkDivider__SHIFT 0x18
#define DPM_TABLE_281__UvdLevel_6_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_281__UvdLevel_6_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_282__UvdLevel_6_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_282__UvdLevel_6_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_283__UvdLevel_6_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_283__UvdLevel_6_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_283__UvdLevel_6_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_283__UvdLevel_6_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_283__UvdLevel_6_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_283__UvdLevel_6_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_283__UvdLevel_6_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_283__UvdLevel_6_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_284__UvdLevel_6_padding_1_MASK 0xff
#define DPM_TABLE_284__UvdLevel_6_padding_1__SHIFT 0x0
#define DPM_TABLE_284__UvdLevel_6_padding_0_MASK 0xff00
#define DPM_TABLE_284__UvdLevel_6_padding_0__SHIFT 0x8
#define DPM_TABLE_284__UvdLevel_6_DclkDivider_MASK 0xff0000
#define DPM_TABLE_284__UvdLevel_6_DclkDivider__SHIFT 0x10
#define DPM_TABLE_284__UvdLevel_6_VclkDivider_MASK 0xff000000
#define DPM_TABLE_284__UvdLevel_6_VclkDivider__SHIFT 0x18
#define DPM_TABLE_285__UvdLevel_7_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_285__UvdLevel_7_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_286__UvdLevel_7_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_286__UvdLevel_7_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_287__UvdLevel_7_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_287__UvdLevel_7_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_287__UvdLevel_7_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_287__UvdLevel_7_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_287__UvdLevel_7_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_287__UvdLevel_7_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_287__UvdLevel_7_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_287__UvdLevel_7_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_288__UvdLevel_7_padding_1_MASK 0xff
#define DPM_TABLE_288__UvdLevel_7_padding_1__SHIFT 0x0
#define DPM_TABLE_288__UvdLevel_7_padding_0_MASK 0xff00
#define DPM_TABLE_288__UvdLevel_7_padding_0__SHIFT 0x8
#define DPM_TABLE_288__UvdLevel_7_DclkDivider_MASK 0xff0000
#define DPM_TABLE_288__UvdLevel_7_DclkDivider__SHIFT 0x10
#define DPM_TABLE_288__UvdLevel_7_VclkDivider_MASK 0xff000000
#define DPM_TABLE_288__UvdLevel_7_VclkDivider__SHIFT 0x18
#define DPM_TABLE_289__VceLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_289__VceLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_290__VceLevel_0_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_290__VceLevel_0_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_290__VceLevel_0_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_290__VceLevel_0_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_290__VceLevel_0_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_290__VceLevel_0_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_290__VceLevel_0_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_290__VceLevel_0_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_291__VceLevel_0_padding_2_MASK 0xff
#define DPM_TABLE_291__VceLevel_0_padding_2__SHIFT 0x0
#define DPM_TABLE_291__VceLevel_0_padding_1_MASK 0xff00
#define DPM_TABLE_291__VceLevel_0_padding_1__SHIFT 0x8
#define DPM_TABLE_291__VceLevel_0_padding_0_MASK 0xff0000
#define DPM_TABLE_291__VceLevel_0_padding_0__SHIFT 0x10
#define DPM_TABLE_291__VceLevel_0_Divider_MASK 0xff000000
#define DPM_TABLE_291__VceLevel_0_Divider__SHIFT 0x18
#define DPM_TABLE_292__VceLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_292__VceLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_293__VceLevel_1_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_293__VceLevel_1_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_293__VceLevel_1_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_293__VceLevel_1_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_293__VceLevel_1_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_293__VceLevel_1_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_293__VceLevel_1_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_293__VceLevel_1_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_294__VceLevel_1_padding_2_MASK 0xff
#define DPM_TABLE_294__VceLevel_1_padding_2__SHIFT 0x0
#define DPM_TABLE_294__VceLevel_1_padding_1_MASK 0xff00
#define DPM_TABLE_294__VceLevel_1_padding_1__SHIFT 0x8
#define DPM_TABLE_294__VceLevel_1_padding_0_MASK 0xff0000
#define DPM_TABLE_294__VceLevel_1_padding_0__SHIFT 0x10
#define DPM_TABLE_294__VceLevel_1_Divider_MASK 0xff000000
#define DPM_TABLE_294__VceLevel_1_Divider__SHIFT 0x18
#define DPM_TABLE_295__VceLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_295__VceLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_296__VceLevel_2_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_296__VceLevel_2_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_296__VceLevel_2_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_296__VceLevel_2_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_296__VceLevel_2_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_296__VceLevel_2_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_296__VceLevel_2_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_296__VceLevel_2_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_297__VceLevel_2_padding_2_MASK 0xff
#define DPM_TABLE_297__VceLevel_2_padding_2__SHIFT 0x0
#define DPM_TABLE_297__VceLevel_2_padding_1_MASK 0xff00
#define DPM_TABLE_297__VceLevel_2_padding_1__SHIFT 0x8
#define DPM_TABLE_297__VceLevel_2_padding_0_MASK 0xff0000
#define DPM_TABLE_297__VceLevel_2_padding_0__SHIFT 0x10
#define DPM_TABLE_297__VceLevel_2_Divider_MASK 0xff000000
#define DPM_TABLE_297__VceLevel_2_Divider__SHIFT 0x18
#define DPM_TABLE_298__VceLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_298__VceLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_299__VceLevel_3_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_299__VceLevel_3_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_299__VceLevel_3_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_299__VceLevel_3_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_299__VceLevel_3_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_299__VceLevel_3_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_299__VceLevel_3_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_299__VceLevel_3_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_300__VceLevel_3_padding_2_MASK 0xff
#define DPM_TABLE_300__VceLevel_3_padding_2__SHIFT 0x0
#define DPM_TABLE_300__VceLevel_3_padding_1_MASK 0xff00
#define DPM_TABLE_300__VceLevel_3_padding_1__SHIFT 0x8
#define DPM_TABLE_300__VceLevel_3_padding_0_MASK 0xff0000
#define DPM_TABLE_300__VceLevel_3_padding_0__SHIFT 0x10
#define DPM_TABLE_300__VceLevel_3_Divider_MASK 0xff000000
#define DPM_TABLE_300__VceLevel_3_Divider__SHIFT 0x18
#define DPM_TABLE_301__VceLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_301__VceLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_302__VceLevel_4_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_302__VceLevel_4_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_302__VceLevel_4_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_302__VceLevel_4_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_302__VceLevel_4_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_302__VceLevel_4_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_302__VceLevel_4_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_302__VceLevel_4_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_303__VceLevel_4_padding_2_MASK 0xff
#define DPM_TABLE_303__VceLevel_4_padding_2__SHIFT 0x0
#define DPM_TABLE_303__VceLevel_4_padding_1_MASK 0xff00
#define DPM_TABLE_303__VceLevel_4_padding_1__SHIFT 0x8
#define DPM_TABLE_303__VceLevel_4_padding_0_MASK 0xff0000
#define DPM_TABLE_303__VceLevel_4_padding_0__SHIFT 0x10
#define DPM_TABLE_303__VceLevel_4_Divider_MASK 0xff000000
#define DPM_TABLE_303__VceLevel_4_Divider__SHIFT 0x18
#define DPM_TABLE_304__VceLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_304__VceLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_305__VceLevel_5_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_305__VceLevel_5_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_305__VceLevel_5_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_305__VceLevel_5_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_305__VceLevel_5_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_305__VceLevel_5_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_305__VceLevel_5_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_305__VceLevel_5_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_306__VceLevel_5_padding_2_MASK 0xff
#define DPM_TABLE_306__VceLevel_5_padding_2__SHIFT 0x0
#define DPM_TABLE_306__VceLevel_5_padding_1_MASK 0xff00
#define DPM_TABLE_306__VceLevel_5_padding_1__SHIFT 0x8
#define DPM_TABLE_306__VceLevel_5_padding_0_MASK 0xff0000
#define DPM_TABLE_306__VceLevel_5_padding_0__SHIFT 0x10
#define DPM_TABLE_306__VceLevel_5_Divider_MASK 0xff000000
#define DPM_TABLE_306__VceLevel_5_Divider__SHIFT 0x18
#define DPM_TABLE_307__VceLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_307__VceLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_308__VceLevel_6_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_308__VceLevel_6_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_308__VceLevel_6_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_308__VceLevel_6_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_308__VceLevel_6_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_308__VceLevel_6_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_308__VceLevel_6_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_308__VceLevel_6_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_309__VceLevel_6_padding_2_MASK 0xff
#define DPM_TABLE_309__VceLevel_6_padding_2__SHIFT 0x0
#define DPM_TABLE_309__VceLevel_6_padding_1_MASK 0xff00
#define DPM_TABLE_309__VceLevel_6_padding_1__SHIFT 0x8
#define DPM_TABLE_309__VceLevel_6_padding_0_MASK 0xff0000
#define DPM_TABLE_309__VceLevel_6_padding_0__SHIFT 0x10
#define DPM_TABLE_309__VceLevel_6_Divider_MASK 0xff000000
#define DPM_TABLE_309__VceLevel_6_Divider__SHIFT 0x18
#define DPM_TABLE_310__VceLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_310__VceLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_311__VceLevel_7_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_311__VceLevel_7_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_311__VceLevel_7_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_311__VceLevel_7_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_311__VceLevel_7_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_311__VceLevel_7_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_311__VceLevel_7_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_311__VceLevel_7_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_312__VceLevel_7_padding_2_MASK 0xff
#define DPM_TABLE_312__VceLevel_7_padding_2__SHIFT 0x0
#define DPM_TABLE_312__VceLevel_7_padding_1_MASK 0xff00
#define DPM_TABLE_312__VceLevel_7_padding_1__SHIFT 0x8
#define DPM_TABLE_312__VceLevel_7_padding_0_MASK 0xff0000
#define DPM_TABLE_312__VceLevel_7_padding_0__SHIFT 0x10
#define DPM_TABLE_312__VceLevel_7_Divider_MASK 0xff000000
#define DPM_TABLE_312__VceLevel_7_Divider__SHIFT 0x18
#define DPM_TABLE_313__AcpLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_313__AcpLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_314__AcpLevel_0_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_314__AcpLevel_0_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_314__AcpLevel_0_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_314__AcpLevel_0_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_314__AcpLevel_0_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_314__AcpLevel_0_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_314__AcpLevel_0_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_314__AcpLevel_0_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_315__AcpLevel_0_padding_2_MASK 0xff
#define DPM_TABLE_315__AcpLevel_0_padding_2__SHIFT 0x0
#define DPM_TABLE_315__AcpLevel_0_padding_1_MASK 0xff00
#define DPM_TABLE_315__AcpLevel_0_padding_1__SHIFT 0x8
#define DPM_TABLE_315__AcpLevel_0_padding_0_MASK 0xff0000
#define DPM_TABLE_315__AcpLevel_0_padding_0__SHIFT 0x10
#define DPM_TABLE_315__AcpLevel_0_Divider_MASK 0xff000000
#define DPM_TABLE_315__AcpLevel_0_Divider__SHIFT 0x18
#define DPM_TABLE_316__AcpLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_316__AcpLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_317__AcpLevel_1_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_317__AcpLevel_1_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_317__AcpLevel_1_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_317__AcpLevel_1_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_317__AcpLevel_1_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_317__AcpLevel_1_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_317__AcpLevel_1_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_317__AcpLevel_1_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_318__AcpLevel_1_padding_2_MASK 0xff
#define DPM_TABLE_318__AcpLevel_1_padding_2__SHIFT 0x0
#define DPM_TABLE_318__AcpLevel_1_padding_1_MASK 0xff00
#define DPM_TABLE_318__AcpLevel_1_padding_1__SHIFT 0x8
#define DPM_TABLE_318__AcpLevel_1_padding_0_MASK 0xff0000
#define DPM_TABLE_318__AcpLevel_1_padding_0__SHIFT 0x10
#define DPM_TABLE_318__AcpLevel_1_Divider_MASK 0xff000000
#define DPM_TABLE_318__AcpLevel_1_Divider__SHIFT 0x18
#define DPM_TABLE_319__AcpLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_319__AcpLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_320__AcpLevel_2_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_320__AcpLevel_2_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_320__AcpLevel_2_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_320__AcpLevel_2_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_320__AcpLevel_2_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_320__AcpLevel_2_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_320__AcpLevel_2_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_320__AcpLevel_2_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_321__AcpLevel_2_padding_2_MASK 0xff
#define DPM_TABLE_321__AcpLevel_2_padding_2__SHIFT 0x0
#define DPM_TABLE_321__AcpLevel_2_padding_1_MASK 0xff00
#define DPM_TABLE_321__AcpLevel_2_padding_1__SHIFT 0x8
#define DPM_TABLE_321__AcpLevel_2_padding_0_MASK 0xff0000
#define DPM_TABLE_321__AcpLevel_2_padding_0__SHIFT 0x10
#define DPM_TABLE_321__AcpLevel_2_Divider_MASK 0xff000000
#define DPM_TABLE_321__AcpLevel_2_Divider__SHIFT 0x18
#define DPM_TABLE_322__AcpLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_322__AcpLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_323__AcpLevel_3_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_323__AcpLevel_3_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_323__AcpLevel_3_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_323__AcpLevel_3_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_323__AcpLevel_3_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_323__AcpLevel_3_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_323__AcpLevel_3_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_323__AcpLevel_3_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_324__AcpLevel_3_padding_2_MASK 0xff
#define DPM_TABLE_324__AcpLevel_3_padding_2__SHIFT 0x0
#define DPM_TABLE_324__AcpLevel_3_padding_1_MASK 0xff00
#define DPM_TABLE_324__AcpLevel_3_padding_1__SHIFT 0x8
#define DPM_TABLE_324__AcpLevel_3_padding_0_MASK 0xff0000
#define DPM_TABLE_324__AcpLevel_3_padding_0__SHIFT 0x10
#define DPM_TABLE_324__AcpLevel_3_Divider_MASK 0xff000000
#define DPM_TABLE_324__AcpLevel_3_Divider__SHIFT 0x18
#define DPM_TABLE_325__AcpLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_325__AcpLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_326__AcpLevel_4_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_326__AcpLevel_4_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_326__AcpLevel_4_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_326__AcpLevel_4_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_326__AcpLevel_4_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_326__AcpLevel_4_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_326__AcpLevel_4_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_326__AcpLevel_4_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_327__AcpLevel_4_padding_2_MASK 0xff
#define DPM_TABLE_327__AcpLevel_4_padding_2__SHIFT 0x0
#define DPM_TABLE_327__AcpLevel_4_padding_1_MASK 0xff00
#define DPM_TABLE_327__AcpLevel_4_padding_1__SHIFT 0x8
#define DPM_TABLE_327__AcpLevel_4_padding_0_MASK 0xff0000
#define DPM_TABLE_327__AcpLevel_4_padding_0__SHIFT 0x10
#define DPM_TABLE_327__AcpLevel_4_Divider_MASK 0xff000000
#define DPM_TABLE_327__AcpLevel_4_Divider__SHIFT 0x18
#define DPM_TABLE_328__AcpLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_328__AcpLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_329__AcpLevel_5_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_329__AcpLevel_5_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_329__AcpLevel_5_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_329__AcpLevel_5_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_329__AcpLevel_5_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_329__AcpLevel_5_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_329__AcpLevel_5_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_329__AcpLevel_5_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_330__AcpLevel_5_padding_2_MASK 0xff
#define DPM_TABLE_330__AcpLevel_5_padding_2__SHIFT 0x0
#define DPM_TABLE_330__AcpLevel_5_padding_1_MASK 0xff00
#define DPM_TABLE_330__AcpLevel_5_padding_1__SHIFT 0x8
#define DPM_TABLE_330__AcpLevel_5_padding_0_MASK 0xff0000
#define DPM_TABLE_330__AcpLevel_5_padding_0__SHIFT 0x10
#define DPM_TABLE_330__AcpLevel_5_Divider_MASK 0xff000000
#define DPM_TABLE_330__AcpLevel_5_Divider__SHIFT 0x18
#define DPM_TABLE_331__AcpLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_331__AcpLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_332__AcpLevel_6_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_332__AcpLevel_6_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_332__AcpLevel_6_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_332__AcpLevel_6_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_332__AcpLevel_6_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_332__AcpLevel_6_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_332__AcpLevel_6_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_332__AcpLevel_6_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_333__AcpLevel_6_padding_2_MASK 0xff
#define DPM_TABLE_333__AcpLevel_6_padding_2__SHIFT 0x0
#define DPM_TABLE_333__AcpLevel_6_padding_1_MASK 0xff00
#define DPM_TABLE_333__AcpLevel_6_padding_1__SHIFT 0x8
#define DPM_TABLE_333__AcpLevel_6_padding_0_MASK 0xff0000
#define DPM_TABLE_333__AcpLevel_6_padding_0__SHIFT 0x10
#define DPM_TABLE_333__AcpLevel_6_Divider_MASK 0xff000000
#define DPM_TABLE_333__AcpLevel_6_Divider__SHIFT 0x18
#define DPM_TABLE_334__AcpLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_334__AcpLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_335__AcpLevel_7_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_335__AcpLevel_7_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_335__AcpLevel_7_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_335__AcpLevel_7_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_335__AcpLevel_7_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_335__AcpLevel_7_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_335__AcpLevel_7_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_335__AcpLevel_7_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_336__AcpLevel_7_padding_2_MASK 0xff
#define DPM_TABLE_336__AcpLevel_7_padding_2__SHIFT 0x0
#define DPM_TABLE_336__AcpLevel_7_padding_1_MASK 0xff00
#define DPM_TABLE_336__AcpLevel_7_padding_1__SHIFT 0x8
#define DPM_TABLE_336__AcpLevel_7_padding_0_MASK 0xff0000
#define DPM_TABLE_336__AcpLevel_7_padding_0__SHIFT 0x10
#define DPM_TABLE_336__AcpLevel_7_Divider_MASK 0xff000000
#define DPM_TABLE_336__AcpLevel_7_Divider__SHIFT 0x18
#define DPM_TABLE_337__SamuLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_337__SamuLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_338__SamuLevel_0_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_338__SamuLevel_0_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_338__SamuLevel_0_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_338__SamuLevel_0_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_338__SamuLevel_0_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_338__SamuLevel_0_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_338__SamuLevel_0_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_338__SamuLevel_0_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_339__SamuLevel_0_padding_2_MASK 0xff
#define DPM_TABLE_339__SamuLevel_0_padding_2__SHIFT 0x0
#define DPM_TABLE_339__SamuLevel_0_padding_1_MASK 0xff00
#define DPM_TABLE_339__SamuLevel_0_padding_1__SHIFT 0x8
#define DPM_TABLE_339__SamuLevel_0_padding_0_MASK 0xff0000
#define DPM_TABLE_339__SamuLevel_0_padding_0__SHIFT 0x10
#define DPM_TABLE_339__SamuLevel_0_Divider_MASK 0xff000000
#define DPM_TABLE_339__SamuLevel_0_Divider__SHIFT 0x18
#define DPM_TABLE_340__SamuLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_340__SamuLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_341__SamuLevel_1_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_341__SamuLevel_1_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_341__SamuLevel_1_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_341__SamuLevel_1_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_341__SamuLevel_1_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_341__SamuLevel_1_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_341__SamuLevel_1_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_341__SamuLevel_1_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_342__SamuLevel_1_padding_2_MASK 0xff
#define DPM_TABLE_342__SamuLevel_1_padding_2__SHIFT 0x0
#define DPM_TABLE_342__SamuLevel_1_padding_1_MASK 0xff00
#define DPM_TABLE_342__SamuLevel_1_padding_1__SHIFT 0x8
#define DPM_TABLE_342__SamuLevel_1_padding_0_MASK 0xff0000
#define DPM_TABLE_342__SamuLevel_1_padding_0__SHIFT 0x10
#define DPM_TABLE_342__SamuLevel_1_Divider_MASK 0xff000000
#define DPM_TABLE_342__SamuLevel_1_Divider__SHIFT 0x18
#define DPM_TABLE_343__SamuLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_343__SamuLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_344__SamuLevel_2_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_344__SamuLevel_2_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_344__SamuLevel_2_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_344__SamuLevel_2_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_344__SamuLevel_2_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_344__SamuLevel_2_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_344__SamuLevel_2_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_344__SamuLevel_2_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_345__SamuLevel_2_padding_2_MASK 0xff
#define DPM_TABLE_345__SamuLevel_2_padding_2__SHIFT 0x0
#define DPM_TABLE_345__SamuLevel_2_padding_1_MASK 0xff00
#define DPM_TABLE_345__SamuLevel_2_padding_1__SHIFT 0x8
#define DPM_TABLE_345__SamuLevel_2_padding_0_MASK 0xff0000
#define DPM_TABLE_345__SamuLevel_2_padding_0__SHIFT 0x10
#define DPM_TABLE_345__SamuLevel_2_Divider_MASK 0xff000000
#define DPM_TABLE_345__SamuLevel_2_Divider__SHIFT 0x18
#define DPM_TABLE_346__SamuLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_346__SamuLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_347__SamuLevel_3_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_347__SamuLevel_3_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_347__SamuLevel_3_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_347__SamuLevel_3_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_347__SamuLevel_3_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_347__SamuLevel_3_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_347__SamuLevel_3_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_347__SamuLevel_3_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_348__SamuLevel_3_padding_2_MASK 0xff
#define DPM_TABLE_348__SamuLevel_3_padding_2__SHIFT 0x0
#define DPM_TABLE_348__SamuLevel_3_padding_1_MASK 0xff00
#define DPM_TABLE_348__SamuLevel_3_padding_1__SHIFT 0x8
#define DPM_TABLE_348__SamuLevel_3_padding_0_MASK 0xff0000
#define DPM_TABLE_348__SamuLevel_3_padding_0__SHIFT 0x10
#define DPM_TABLE_348__SamuLevel_3_Divider_MASK 0xff000000
#define DPM_TABLE_348__SamuLevel_3_Divider__SHIFT 0x18
#define DPM_TABLE_349__SamuLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_349__SamuLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_350__SamuLevel_4_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_350__SamuLevel_4_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_350__SamuLevel_4_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_350__SamuLevel_4_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_350__SamuLevel_4_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_350__SamuLevel_4_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_350__SamuLevel_4_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_350__SamuLevel_4_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_351__SamuLevel_4_padding_2_MASK 0xff
#define DPM_TABLE_351__SamuLevel_4_padding_2__SHIFT 0x0
#define DPM_TABLE_351__SamuLevel_4_padding_1_MASK 0xff00
#define DPM_TABLE_351__SamuLevel_4_padding_1__SHIFT 0x8
#define DPM_TABLE_351__SamuLevel_4_padding_0_MASK 0xff0000
#define DPM_TABLE_351__SamuLevel_4_padding_0__SHIFT 0x10
#define DPM_TABLE_351__SamuLevel_4_Divider_MASK 0xff000000
#define DPM_TABLE_351__SamuLevel_4_Divider__SHIFT 0x18
#define DPM_TABLE_352__SamuLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_352__SamuLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_353__SamuLevel_5_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_353__SamuLevel_5_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_353__SamuLevel_5_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_353__SamuLevel_5_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_353__SamuLevel_5_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_353__SamuLevel_5_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_353__SamuLevel_5_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_353__SamuLevel_5_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_354__SamuLevel_5_padding_2_MASK 0xff
#define DPM_TABLE_354__SamuLevel_5_padding_2__SHIFT 0x0
#define DPM_TABLE_354__SamuLevel_5_padding_1_MASK 0xff00
#define DPM_TABLE_354__SamuLevel_5_padding_1__SHIFT 0x8
#define DPM_TABLE_354__SamuLevel_5_padding_0_MASK 0xff0000
#define DPM_TABLE_354__SamuLevel_5_padding_0__SHIFT 0x10
#define DPM_TABLE_354__SamuLevel_5_Divider_MASK 0xff000000
#define DPM_TABLE_354__SamuLevel_5_Divider__SHIFT 0x18
#define DPM_TABLE_355__SamuLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_355__SamuLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_356__SamuLevel_6_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_356__SamuLevel_6_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_356__SamuLevel_6_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_356__SamuLevel_6_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_356__SamuLevel_6_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_356__SamuLevel_6_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_356__SamuLevel_6_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_356__SamuLevel_6_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_357__SamuLevel_6_padding_2_MASK 0xff
#define DPM_TABLE_357__SamuLevel_6_padding_2__SHIFT 0x0
#define DPM_TABLE_357__SamuLevel_6_padding_1_MASK 0xff00
#define DPM_TABLE_357__SamuLevel_6_padding_1__SHIFT 0x8
#define DPM_TABLE_357__SamuLevel_6_padding_0_MASK 0xff0000
#define DPM_TABLE_357__SamuLevel_6_padding_0__SHIFT 0x10
#define DPM_TABLE_357__SamuLevel_6_Divider_MASK 0xff000000
#define DPM_TABLE_357__SamuLevel_6_Divider__SHIFT 0x18
#define DPM_TABLE_358__SamuLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_358__SamuLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_359__SamuLevel_7_MinVoltage_Phases_MASK 0xff
#define DPM_TABLE_359__SamuLevel_7_MinVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_359__SamuLevel_7_MinVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_359__SamuLevel_7_MinVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_359__SamuLevel_7_MinVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_359__SamuLevel_7_MinVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_359__SamuLevel_7_MinVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_359__SamuLevel_7_MinVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_360__SamuLevel_7_padding_2_MASK 0xff
#define DPM_TABLE_360__SamuLevel_7_padding_2__SHIFT 0x0
#define DPM_TABLE_360__SamuLevel_7_padding_1_MASK 0xff00
#define DPM_TABLE_360__SamuLevel_7_padding_1__SHIFT 0x8
#define DPM_TABLE_360__SamuLevel_7_padding_0_MASK 0xff0000
#define DPM_TABLE_360__SamuLevel_7_padding_0__SHIFT 0x10
#define DPM_TABLE_360__SamuLevel_7_Divider_MASK 0xff000000
#define DPM_TABLE_360__SamuLevel_7_Divider__SHIFT 0x18
#define DPM_TABLE_361__Ulv_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_361__Ulv_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_362__Ulv_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_362__Ulv_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_363__Ulv_VddcPhase_MASK 0xff
#define DPM_TABLE_363__Ulv_VddcPhase__SHIFT 0x0
#define DPM_TABLE_363__Ulv_VddcOffsetVid_MASK 0xff00
#define DPM_TABLE_363__Ulv_VddcOffsetVid__SHIFT 0x8
#define DPM_TABLE_363__Ulv_VddcOffset_MASK 0xffff0000
#define DPM_TABLE_363__Ulv_VddcOffset__SHIFT 0x10
#define DPM_TABLE_364__Ulv_Reserved_MASK 0xffffffff
#define DPM_TABLE_364__Ulv_Reserved__SHIFT 0x0
#define DPM_TABLE_365__SclkStepSize_MASK 0xffffffff
#define DPM_TABLE_365__SclkStepSize__SHIFT 0x0
#define DPM_TABLE_366__Smio_0_MASK 0xffffffff
#define DPM_TABLE_366__Smio_0__SHIFT 0x0
#define DPM_TABLE_367__Smio_1_MASK 0xffffffff
#define DPM_TABLE_367__Smio_1__SHIFT 0x0
#define DPM_TABLE_368__Smio_2_MASK 0xffffffff
#define DPM_TABLE_368__Smio_2__SHIFT 0x0
#define DPM_TABLE_369__Smio_3_MASK 0xffffffff
#define DPM_TABLE_369__Smio_3__SHIFT 0x0
#define DPM_TABLE_370__Smio_4_MASK 0xffffffff
#define DPM_TABLE_370__Smio_4__SHIFT 0x0
#define DPM_TABLE_371__Smio_5_MASK 0xffffffff
#define DPM_TABLE_371__Smio_5__SHIFT 0x0
#define DPM_TABLE_372__Smio_6_MASK 0xffffffff
#define DPM_TABLE_372__Smio_6__SHIFT 0x0
#define DPM_TABLE_373__Smio_7_MASK 0xffffffff
#define DPM_TABLE_373__Smio_7__SHIFT 0x0
#define DPM_TABLE_374__Smio_8_MASK 0xffffffff
#define DPM_TABLE_374__Smio_8__SHIFT 0x0
#define DPM_TABLE_375__Smio_9_MASK 0xffffffff
#define DPM_TABLE_375__Smio_9__SHIFT 0x0
#define DPM_TABLE_376__Smio_10_MASK 0xffffffff
#define DPM_TABLE_376__Smio_10__SHIFT 0x0
#define DPM_TABLE_377__Smio_11_MASK 0xffffffff
#define DPM_TABLE_377__Smio_11__SHIFT 0x0
#define DPM_TABLE_378__Smio_12_MASK 0xffffffff
#define DPM_TABLE_378__Smio_12__SHIFT 0x0
#define DPM_TABLE_379__Smio_13_MASK 0xffffffff
#define DPM_TABLE_379__Smio_13__SHIFT 0x0
#define DPM_TABLE_380__Smio_14_MASK 0xffffffff
#define DPM_TABLE_380__Smio_14__SHIFT 0x0
#define DPM_TABLE_381__Smio_15_MASK 0xffffffff
#define DPM_TABLE_381__Smio_15__SHIFT 0x0
#define DPM_TABLE_382__Smio_16_MASK 0xffffffff
#define DPM_TABLE_382__Smio_16__SHIFT 0x0
#define DPM_TABLE_383__Smio_17_MASK 0xffffffff
#define DPM_TABLE_383__Smio_17__SHIFT 0x0
#define DPM_TABLE_384__Smio_18_MASK 0xffffffff
#define DPM_TABLE_384__Smio_18__SHIFT 0x0
#define DPM_TABLE_385__Smio_19_MASK 0xffffffff
#define DPM_TABLE_385__Smio_19__SHIFT 0x0
#define DPM_TABLE_386__Smio_20_MASK 0xffffffff
#define DPM_TABLE_386__Smio_20__SHIFT 0x0
#define DPM_TABLE_387__Smio_21_MASK 0xffffffff
#define DPM_TABLE_387__Smio_21__SHIFT 0x0
#define DPM_TABLE_388__Smio_22_MASK 0xffffffff
#define DPM_TABLE_388__Smio_22__SHIFT 0x0
#define DPM_TABLE_389__Smio_23_MASK 0xffffffff
#define DPM_TABLE_389__Smio_23__SHIFT 0x0
#define DPM_TABLE_390__Smio_24_MASK 0xffffffff
#define DPM_TABLE_390__Smio_24__SHIFT 0x0
#define DPM_TABLE_391__Smio_25_MASK 0xffffffff
#define DPM_TABLE_391__Smio_25__SHIFT 0x0
#define DPM_TABLE_392__Smio_26_MASK 0xffffffff
#define DPM_TABLE_392__Smio_26__SHIFT 0x0
#define DPM_TABLE_393__Smio_27_MASK 0xffffffff
#define DPM_TABLE_393__Smio_27__SHIFT 0x0
#define DPM_TABLE_394__Smio_28_MASK 0xffffffff
#define DPM_TABLE_394__Smio_28__SHIFT 0x0
#define DPM_TABLE_395__Smio_29_MASK 0xffffffff
#define DPM_TABLE_395__Smio_29__SHIFT 0x0
#define DPM_TABLE_396__Smio_30_MASK 0xffffffff
#define DPM_TABLE_396__Smio_30__SHIFT 0x0
#define DPM_TABLE_397__Smio_31_MASK 0xffffffff
#define DPM_TABLE_397__Smio_31__SHIFT 0x0
#define DPM_TABLE_398__SamuBootLevel_MASK 0xff
#define DPM_TABLE_398__SamuBootLevel__SHIFT 0x0
#define DPM_TABLE_398__AcpBootLevel_MASK 0xff00
#define DPM_TABLE_398__AcpBootLevel__SHIFT 0x8
#define DPM_TABLE_398__VceBootLevel_MASK 0xff0000
#define DPM_TABLE_398__VceBootLevel__SHIFT 0x10
#define DPM_TABLE_398__UvdBootLevel_MASK 0xff000000
#define DPM_TABLE_398__UvdBootLevel__SHIFT 0x18
#define DPM_TABLE_399__GraphicsInterval_MASK 0xff
#define DPM_TABLE_399__GraphicsInterval__SHIFT 0x0
#define DPM_TABLE_399__GraphicsThermThrottleEnable_MASK 0xff00
#define DPM_TABLE_399__GraphicsThermThrottleEnable__SHIFT 0x8
#define DPM_TABLE_399__GraphicsVoltageChangeEnable_MASK 0xff0000
#define DPM_TABLE_399__GraphicsVoltageChangeEnable__SHIFT 0x10
#define DPM_TABLE_399__GraphicsBootLevel_MASK 0xff000000
#define DPM_TABLE_399__GraphicsBootLevel__SHIFT 0x18
#define DPM_TABLE_400__TemperatureLimitHigh_MASK 0xffff
#define DPM_TABLE_400__TemperatureLimitHigh__SHIFT 0x0
#define DPM_TABLE_400__ThermalInterval_MASK 0xff0000
#define DPM_TABLE_400__ThermalInterval__SHIFT 0x10
#define DPM_TABLE_400__VoltageInterval_MASK 0xff000000
#define DPM_TABLE_400__VoltageInterval__SHIFT 0x18
#define DPM_TABLE_401__MemoryVoltageChangeEnable_MASK 0xff
#define DPM_TABLE_401__MemoryVoltageChangeEnable__SHIFT 0x0
#define DPM_TABLE_401__MemoryBootLevel_MASK 0xff00
#define DPM_TABLE_401__MemoryBootLevel__SHIFT 0x8
#define DPM_TABLE_401__TemperatureLimitLow_MASK 0xffff0000
#define DPM_TABLE_401__TemperatureLimitLow__SHIFT 0x10
#define DPM_TABLE_402__MemoryThermThrottleEnable_MASK 0xff
#define DPM_TABLE_402__MemoryThermThrottleEnable__SHIFT 0x0
#define DPM_TABLE_402__MemoryInterval_MASK 0xff00
#define DPM_TABLE_402__MemoryInterval__SHIFT 0x8
#define DPM_TABLE_402__BootMVdd_MASK 0xffff0000
#define DPM_TABLE_402__BootMVdd__SHIFT 0x10
#define DPM_TABLE_403__PhaseResponseTime_MASK 0xffff
#define DPM_TABLE_403__PhaseResponseTime__SHIFT 0x0
#define DPM_TABLE_403__VoltageResponseTime_MASK 0xffff0000
#define DPM_TABLE_403__VoltageResponseTime__SHIFT 0x10
#define DPM_TABLE_404__DTEMode_MASK 0xff
#define DPM_TABLE_404__DTEMode__SHIFT 0x0
#define DPM_TABLE_404__DTEInterval_MASK 0xff00
#define DPM_TABLE_404__DTEInterval__SHIFT 0x8
#define DPM_TABLE_404__PCIeGenInterval_MASK 0xff0000
#define DPM_TABLE_404__PCIeGenInterval__SHIFT 0x10
#define DPM_TABLE_404__PCIeBootLinkLevel_MASK 0xff000000
#define DPM_TABLE_404__PCIeBootLinkLevel__SHIFT 0x18
#define DPM_TABLE_405__ThermGpio_MASK 0xff
#define DPM_TABLE_405__ThermGpio__SHIFT 0x0
#define DPM_TABLE_405__AcDcGpio_MASK 0xff00
#define DPM_TABLE_405__AcDcGpio__SHIFT 0x8
#define DPM_TABLE_405__VRHotGpio_MASK 0xff0000
#define DPM_TABLE_405__VRHotGpio__SHIFT 0x10
#define DPM_TABLE_405__SVI2Enable_MASK 0xff000000
#define DPM_TABLE_405__SVI2Enable__SHIFT 0x18
#define DPM_TABLE_406__PPM_TemperatureLimit_MASK 0xffff
#define DPM_TABLE_406__PPM_TemperatureLimit__SHIFT 0x0
#define DPM_TABLE_406__PPM_PkgPwrLimit_MASK 0xffff0000
#define DPM_TABLE_406__PPM_PkgPwrLimit__SHIFT 0x10
#define DPM_TABLE_407__TargetTdp_MASK 0xffff
#define DPM_TABLE_407__TargetTdp__SHIFT 0x0
#define DPM_TABLE_407__DefaultTdp_MASK 0xffff0000
#define DPM_TABLE_407__DefaultTdp__SHIFT 0x10
#define DPM_TABLE_408__FpsLowThreshold_MASK 0xffff
#define DPM_TABLE_408__FpsLowThreshold__SHIFT 0x0
#define DPM_TABLE_408__FpsHighThreshold_MASK 0xffff0000
#define DPM_TABLE_408__FpsHighThreshold__SHIFT 0x10
#define DPM_TABLE_409__BAPMTI_R_0_1_0_MASK 0xffff
#define DPM_TABLE_409__BAPMTI_R_0_1_0__SHIFT 0x0
#define DPM_TABLE_409__BAPMTI_R_0_0_0_MASK 0xffff0000
#define DPM_TABLE_409__BAPMTI_R_0_0_0__SHIFT 0x10
#define DPM_TABLE_410__BAPMTI_R_1_0_0_MASK 0xffff
#define DPM_TABLE_410__BAPMTI_R_1_0_0__SHIFT 0x0
#define DPM_TABLE_410__BAPMTI_R_0_2_0_MASK 0xffff0000
#define DPM_TABLE_410__BAPMTI_R_0_2_0__SHIFT 0x10
#define DPM_TABLE_411__BAPMTI_R_1_2_0_MASK 0xffff
#define DPM_TABLE_411__BAPMTI_R_1_2_0__SHIFT 0x0
#define DPM_TABLE_411__BAPMTI_R_1_1_0_MASK 0xffff0000
#define DPM_TABLE_411__BAPMTI_R_1_1_0__SHIFT 0x10
#define DPM_TABLE_412__BAPMTI_R_2_1_0_MASK 0xffff
#define DPM_TABLE_412__BAPMTI_R_2_1_0__SHIFT 0x0
#define DPM_TABLE_412__BAPMTI_R_2_0_0_MASK 0xffff0000
#define DPM_TABLE_412__BAPMTI_R_2_0_0__SHIFT 0x10
#define DPM_TABLE_413__BAPMTI_R_3_0_0_MASK 0xffff
#define DPM_TABLE_413__BAPMTI_R_3_0_0__SHIFT 0x0
#define DPM_TABLE_413__BAPMTI_R_2_2_0_MASK 0xffff0000
#define DPM_TABLE_413__BAPMTI_R_2_2_0__SHIFT 0x10
#define DPM_TABLE_414__BAPMTI_R_3_2_0_MASK 0xffff
#define DPM_TABLE_414__BAPMTI_R_3_2_0__SHIFT 0x0
#define DPM_TABLE_414__BAPMTI_R_3_1_0_MASK 0xffff0000
#define DPM_TABLE_414__BAPMTI_R_3_1_0__SHIFT 0x10
#define DPM_TABLE_415__BAPMTI_R_4_1_0_MASK 0xffff
#define DPM_TABLE_415__BAPMTI_R_4_1_0__SHIFT 0x0
#define DPM_TABLE_415__BAPMTI_R_4_0_0_MASK 0xffff0000
#define DPM_TABLE_415__BAPMTI_R_4_0_0__SHIFT 0x10
#define DPM_TABLE_416__BAPMTI_RC_0_0_0_MASK 0xffff
#define DPM_TABLE_416__BAPMTI_RC_0_0_0__SHIFT 0x0
#define DPM_TABLE_416__BAPMTI_R_4_2_0_MASK 0xffff0000
#define DPM_TABLE_416__BAPMTI_R_4_2_0__SHIFT 0x10
#define DPM_TABLE_417__BAPMTI_RC_0_2_0_MASK 0xffff
#define DPM_TABLE_417__BAPMTI_RC_0_2_0__SHIFT 0x0
#define DPM_TABLE_417__BAPMTI_RC_0_1_0_MASK 0xffff0000
#define DPM_TABLE_417__BAPMTI_RC_0_1_0__SHIFT 0x10
#define DPM_TABLE_418__BAPMTI_RC_1_1_0_MASK 0xffff
#define DPM_TABLE_418__BAPMTI_RC_1_1_0__SHIFT 0x0
#define DPM_TABLE_418__BAPMTI_RC_1_0_0_MASK 0xffff0000
#define DPM_TABLE_418__BAPMTI_RC_1_0_0__SHIFT 0x10
#define DPM_TABLE_419__BAPMTI_RC_2_0_0_MASK 0xffff
#define DPM_TABLE_419__BAPMTI_RC_2_0_0__SHIFT 0x0
#define DPM_TABLE_419__BAPMTI_RC_1_2_0_MASK 0xffff0000
#define DPM_TABLE_419__BAPMTI_RC_1_2_0__SHIFT 0x10
#define DPM_TABLE_420__BAPMTI_RC_2_2_0_MASK 0xffff
#define DPM_TABLE_420__BAPMTI_RC_2_2_0__SHIFT 0x0
#define DPM_TABLE_420__BAPMTI_RC_2_1_0_MASK 0xffff0000
#define DPM_TABLE_420__BAPMTI_RC_2_1_0__SHIFT 0x10
#define DPM_TABLE_421__BAPMTI_RC_3_1_0_MASK 0xffff
#define DPM_TABLE_421__BAPMTI_RC_3_1_0__SHIFT 0x0
#define DPM_TABLE_421__BAPMTI_RC_3_0_0_MASK 0xffff0000
#define DPM_TABLE_421__BAPMTI_RC_3_0_0__SHIFT 0x10
#define DPM_TABLE_422__BAPMTI_RC_4_0_0_MASK 0xffff
#define DPM_TABLE_422__BAPMTI_RC_4_0_0__SHIFT 0x0
#define DPM_TABLE_422__BAPMTI_RC_3_2_0_MASK 0xffff0000
#define DPM_TABLE_422__BAPMTI_RC_3_2_0__SHIFT 0x10
#define DPM_TABLE_423__BAPMTI_RC_4_2_0_MASK 0xffff
#define DPM_TABLE_423__BAPMTI_RC_4_2_0__SHIFT 0x0
#define DPM_TABLE_423__BAPMTI_RC_4_1_0_MASK 0xffff0000
#define DPM_TABLE_423__BAPMTI_RC_4_1_0__SHIFT 0x10
#define DPM_TABLE_424__GpuTjHyst_MASK 0xff
#define DPM_TABLE_424__GpuTjHyst__SHIFT 0x0
#define DPM_TABLE_424__GpuTjMax_MASK 0xff00
#define DPM_TABLE_424__GpuTjMax__SHIFT 0x8
#define DPM_TABLE_424__DTETjOffset_MASK 0xff0000
#define DPM_TABLE_424__DTETjOffset__SHIFT 0x10
#define DPM_TABLE_424__DTEAmbientTempBase_MASK 0xff000000
#define DPM_TABLE_424__DTEAmbientTempBase__SHIFT 0x18
#define DPM_TABLE_425__BootVoltage_Phases_MASK 0xff
#define DPM_TABLE_425__BootVoltage_Phases__SHIFT 0x0
#define DPM_TABLE_425__BootVoltage_VddGfx_MASK 0xff00
#define DPM_TABLE_425__BootVoltage_VddGfx__SHIFT 0x8
#define DPM_TABLE_425__BootVoltage_Vddci_MASK 0xff0000
#define DPM_TABLE_425__BootVoltage_Vddci__SHIFT 0x10
#define DPM_TABLE_425__BootVoltage_Vddc_MASK 0xff000000
#define DPM_TABLE_425__BootVoltage_Vddc__SHIFT 0x18
#define DPM_TABLE_426__BAPM_TEMP_GRADIENT_MASK 0xffffffff
#define DPM_TABLE_426__BAPM_TEMP_GRADIENT__SHIFT 0x0
#define DPM_TABLE_427__LowSclkInterruptThreshold_MASK 0xffffffff
#define DPM_TABLE_427__LowSclkInterruptThreshold__SHIFT 0x0
#define DPM_TABLE_428__VddGfxReChkWait_MASK 0xffffffff
#define DPM_TABLE_428__VddGfxReChkWait__SHIFT 0x0
#define DPM_TABLE_429__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_padding_1_MASK 0xff
#define DPM_TABLE_429__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_padding_1__SHIFT 0x0
#define DPM_TABLE_429__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_padding_0_MASK 0xff00
#define DPM_TABLE_429__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_padding_0__SHIFT 0x8
#define DPM_TABLE_429__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_maxVID_MASK 0xff0000
#define DPM_TABLE_429__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_maxVID__SHIFT 0x10
#define DPM_TABLE_429__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_minVID_MASK 0xff000000
#define DPM_TABLE_429__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_minVID__SHIFT 0x18
#define DPM_TABLE_430__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_3_MASK 0xff
#define DPM_TABLE_430__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_3__SHIFT 0x0
#define DPM_TABLE_430__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_2_MASK 0xff00
#define DPM_TABLE_430__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_2__SHIFT 0x8
#define DPM_TABLE_430__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_1_MASK 0xff0000
#define DPM_TABLE_430__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_1__SHIFT 0x10
#define DPM_TABLE_430__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_0_MASK 0xff000000
#define DPM_TABLE_430__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_0__SHIFT 0x18
#define DPM_TABLE_431__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_7_MASK 0xff
#define DPM_TABLE_431__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_7__SHIFT 0x0
#define DPM_TABLE_431__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_6_MASK 0xff00
#define DPM_TABLE_431__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_6__SHIFT 0x8
#define DPM_TABLE_431__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_5_MASK 0xff0000
#define DPM_TABLE_431__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_5__SHIFT 0x10
#define DPM_TABLE_431__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_4_MASK 0xff000000
#define DPM_TABLE_431__ClockStretcherDataTable_ClockStretcherDataTableEntry_0_setting_4__SHIFT 0x18
#define DPM_TABLE_432__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_padding_1_MASK 0xff
#define DPM_TABLE_432__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_padding_1__SHIFT 0x0
#define DPM_TABLE_432__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_padding_0_MASK 0xff00
#define DPM_TABLE_432__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_padding_0__SHIFT 0x8
#define DPM_TABLE_432__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_maxVID_MASK 0xff0000
#define DPM_TABLE_432__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_maxVID__SHIFT 0x10
#define DPM_TABLE_432__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_minVID_MASK 0xff000000
#define DPM_TABLE_432__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_minVID__SHIFT 0x18
#define DPM_TABLE_433__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_3_MASK 0xff
#define DPM_TABLE_433__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_3__SHIFT 0x0
#define DPM_TABLE_433__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_2_MASK 0xff00
#define DPM_TABLE_433__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_2__SHIFT 0x8
#define DPM_TABLE_433__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_1_MASK 0xff0000
#define DPM_TABLE_433__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_1__SHIFT 0x10
#define DPM_TABLE_433__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_0_MASK 0xff000000
#define DPM_TABLE_433__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_0__SHIFT 0x18
#define DPM_TABLE_434__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_7_MASK 0xff
#define DPM_TABLE_434__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_7__SHIFT 0x0
#define DPM_TABLE_434__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_6_MASK 0xff00
#define DPM_TABLE_434__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_6__SHIFT 0x8
#define DPM_TABLE_434__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_5_MASK 0xff0000
#define DPM_TABLE_434__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_5__SHIFT 0x10
#define DPM_TABLE_434__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_4_MASK 0xff000000
#define DPM_TABLE_434__ClockStretcherDataTable_ClockStretcherDataTableEntry_1_setting_4__SHIFT 0x18
#define DPM_TABLE_435__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_padding_1_MASK 0xff
#define DPM_TABLE_435__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_padding_1__SHIFT 0x0
#define DPM_TABLE_435__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_padding_0_MASK 0xff00
#define DPM_TABLE_435__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_padding_0__SHIFT 0x8
#define DPM_TABLE_435__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_maxVID_MASK 0xff0000
#define DPM_TABLE_435__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_maxVID__SHIFT 0x10
#define DPM_TABLE_435__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_minVID_MASK 0xff000000
#define DPM_TABLE_435__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_minVID__SHIFT 0x18
#define DPM_TABLE_436__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_3_MASK 0xff
#define DPM_TABLE_436__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_3__SHIFT 0x0
#define DPM_TABLE_436__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_2_MASK 0xff00
#define DPM_TABLE_436__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_2__SHIFT 0x8
#define DPM_TABLE_436__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_1_MASK 0xff0000
#define DPM_TABLE_436__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_1__SHIFT 0x10
#define DPM_TABLE_436__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_0_MASK 0xff000000
#define DPM_TABLE_436__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_0__SHIFT 0x18
#define DPM_TABLE_437__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_7_MASK 0xff
#define DPM_TABLE_437__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_7__SHIFT 0x0
#define DPM_TABLE_437__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_6_MASK 0xff00
#define DPM_TABLE_437__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_6__SHIFT 0x8
#define DPM_TABLE_437__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_5_MASK 0xff0000
#define DPM_TABLE_437__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_5__SHIFT 0x10
#define DPM_TABLE_437__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_4_MASK 0xff000000
#define DPM_TABLE_437__ClockStretcherDataTable_ClockStretcherDataTableEntry_2_setting_4__SHIFT 0x18
#define DPM_TABLE_438__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_padding_1_MASK 0xff
#define DPM_TABLE_438__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_padding_1__SHIFT 0x0
#define DPM_TABLE_438__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_padding_0_MASK 0xff00
#define DPM_TABLE_438__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_padding_0__SHIFT 0x8
#define DPM_TABLE_438__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_maxVID_MASK 0xff0000
#define DPM_TABLE_438__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_maxVID__SHIFT 0x10
#define DPM_TABLE_438__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_minVID_MASK 0xff000000
#define DPM_TABLE_438__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_minVID__SHIFT 0x18
#define DPM_TABLE_439__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_3_MASK 0xff
#define DPM_TABLE_439__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_3__SHIFT 0x0
#define DPM_TABLE_439__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_2_MASK 0xff00
#define DPM_TABLE_439__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_2__SHIFT 0x8
#define DPM_TABLE_439__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_1_MASK 0xff0000
#define DPM_TABLE_439__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_1__SHIFT 0x10
#define DPM_TABLE_439__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_0_MASK 0xff000000
#define DPM_TABLE_439__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_0__SHIFT 0x18
#define DPM_TABLE_440__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_7_MASK 0xff
#define DPM_TABLE_440__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_7__SHIFT 0x0
#define DPM_TABLE_440__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_6_MASK 0xff00
#define DPM_TABLE_440__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_6__SHIFT 0x8
#define DPM_TABLE_440__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_5_MASK 0xff0000
#define DPM_TABLE_440__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_5__SHIFT 0x10
#define DPM_TABLE_440__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_4_MASK 0xff000000
#define DPM_TABLE_440__ClockStretcherDataTable_ClockStretcherDataTableEntry_3_setting_4__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_1__RefClockFrequency_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_1__RefClockFrequency__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_2__PmTimerPeriod_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_2__PmTimerPeriod__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_3__FeatureEnables_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_3__FeatureEnables__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_4__PreVBlankGap_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_4__PreVBlankGap__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_5__VBlankTimeout_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_5__VBlankTimeout__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_6__TrainTimeGap_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_6__TrainTimeGap__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_7__MvddSwitchTime_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_7__MvddSwitchTime__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_8__LongestAcpiTrainTime_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_8__LongestAcpiTrainTime__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_9__AcpiDelay_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_9__AcpiDelay__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_10__G5TrainTime_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_10__G5TrainTime__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_11__DelayMpllPwron_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_11__DelayMpllPwron__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_12__VoltageChangeTimeout_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_12__VoltageChangeTimeout__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_13__HandshakeDisables_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_13__HandshakeDisables__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_14__DisplayPhy4Config_MASK 0xff
#define SOFT_REGISTERS_TABLE_14__DisplayPhy4Config__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_14__DisplayPhy3Config_MASK 0xff00
#define SOFT_REGISTERS_TABLE_14__DisplayPhy3Config__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_14__DisplayPhy2Config_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_14__DisplayPhy2Config__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_14__DisplayPhy1Config_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_14__DisplayPhy1Config__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_15__DisplayPhy8Config_MASK 0xff
#define SOFT_REGISTERS_TABLE_15__DisplayPhy8Config__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_15__DisplayPhy7Config_MASK 0xff00
#define SOFT_REGISTERS_TABLE_15__DisplayPhy7Config__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_15__DisplayPhy6Config_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_15__DisplayPhy6Config__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_15__DisplayPhy5Config_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_15__DisplayPhy5Config__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_16__AverageGraphicsActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_16__AverageGraphicsActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_17__AverageMemoryActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_17__AverageMemoryActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_18__AverageGioActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_18__AverageGioActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_19__PCIeDpmEnabledLevels_MASK 0xff
#define SOFT_REGISTERS_TABLE_19__PCIeDpmEnabledLevels__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_19__LClkDpmEnabledLevels_MASK 0xff00
#define SOFT_REGISTERS_TABLE_19__LClkDpmEnabledLevels__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_19__MClkDpmEnabledLevels_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_19__MClkDpmEnabledLevels__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_19__SClkDpmEnabledLevels_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_19__SClkDpmEnabledLevels__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_20__VCEDpmEnabledLevels_MASK 0xff
#define SOFT_REGISTERS_TABLE_20__VCEDpmEnabledLevels__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_20__ACPDpmEnabledLevels_MASK 0xff00
#define SOFT_REGISTERS_TABLE_20__ACPDpmEnabledLevels__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_20__SAMUDpmEnabledLevels_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_20__SAMUDpmEnabledLevels__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_20__UVDDpmEnabledLevels_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_20__UVDDpmEnabledLevels__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_21__DRAM_LOG_ADDR_H_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_21__DRAM_LOG_ADDR_H__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_22__DRAM_LOG_ADDR_L_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_22__DRAM_LOG_ADDR_L__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_23__DRAM_LOG_PHY_ADDR_H_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_23__DRAM_LOG_PHY_ADDR_H__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_24__DRAM_LOG_PHY_ADDR_L_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_24__DRAM_LOG_PHY_ADDR_L__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_25__DRAM_LOG_BUFF_SIZE_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_25__DRAM_LOG_BUFF_SIZE__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_26__UlvEnterCount_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_26__UlvEnterCount__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_27__UlvTime_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_27__UlvTime__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_28__UcodeLoadStatus_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_28__UcodeLoadStatus__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_29__Reserved_0_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_29__Reserved_0__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_30__Reserved_1_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_30__Reserved_1__SHIFT 0x0
#define PM_FUSES_1__SviLoadLineOffsetVddC_MASK 0xff
#define PM_FUSES_1__SviLoadLineOffsetVddC__SHIFT 0x0
#define PM_FUSES_1__SviLoadLineTrimVddC_MASK 0xff00
#define PM_FUSES_1__SviLoadLineTrimVddC__SHIFT 0x8
#define PM_FUSES_1__SviLoadLineVddC_MASK 0xff0000
#define PM_FUSES_1__SviLoadLineVddC__SHIFT 0x10
#define PM_FUSES_1__SviLoadLineEn_MASK 0xff000000
#define PM_FUSES_1__SviLoadLineEn__SHIFT 0x18
#define PM_FUSES_2__TDC_MAWt_MASK 0xff
#define PM_FUSES_2__TDC_MAWt__SHIFT 0x0
#define PM_FUSES_2__TDC_VDDC_ThrottleReleaseLimitPerc_MASK 0xff00
#define PM_FUSES_2__TDC_VDDC_ThrottleReleaseLimitPerc__SHIFT 0x8
#define PM_FUSES_2__TDC_VDDC_PkgLimit_MASK 0xffff0000
#define PM_FUSES_2__TDC_VDDC_PkgLimit__SHIFT 0x10
#define PM_FUSES_3__Reserved_MASK 0xff
#define PM_FUSES_3__Reserved__SHIFT 0x0
#define PM_FUSES_3__LPMLTemperatureMax_MASK 0xff00
#define PM_FUSES_3__LPMLTemperatureMax__SHIFT 0x8
#define PM_FUSES_3__LPMLTemperatureMin_MASK 0xff0000
#define PM_FUSES_3__LPMLTemperatureMin__SHIFT 0x10
#define PM_FUSES_3__TdcWaterfallCtl_MASK 0xff000000
#define PM_FUSES_3__TdcWaterfallCtl__SHIFT 0x18
#define PM_FUSES_4__LPMLTemperatureScaler_3_MASK 0xff
#define PM_FUSES_4__LPMLTemperatureScaler_3__SHIFT 0x0
#define PM_FUSES_4__LPMLTemperatureScaler_2_MASK 0xff00
#define PM_FUSES_4__LPMLTemperatureScaler_2__SHIFT 0x8
#define PM_FUSES_4__LPMLTemperatureScaler_1_MASK 0xff0000
#define PM_FUSES_4__LPMLTemperatureScaler_1__SHIFT 0x10
#define PM_FUSES_4__LPMLTemperatureScaler_0_MASK 0xff000000
#define PM_FUSES_4__LPMLTemperatureScaler_0__SHIFT 0x18
#define PM_FUSES_5__LPMLTemperatureScaler_7_MASK 0xff
#define PM_FUSES_5__LPMLTemperatureScaler_7__SHIFT 0x0
#define PM_FUSES_5__LPMLTemperatureScaler_6_MASK 0xff00
#define PM_FUSES_5__LPMLTemperatureScaler_6__SHIFT 0x8
#define PM_FUSES_5__LPMLTemperatureScaler_5_MASK 0xff0000
#define PM_FUSES_5__LPMLTemperatureScaler_5__SHIFT 0x10
#define PM_FUSES_5__LPMLTemperatureScaler_4_MASK 0xff000000
#define PM_FUSES_5__LPMLTemperatureScaler_4__SHIFT 0x18
#define PM_FUSES_6__LPMLTemperatureScaler_11_MASK 0xff
#define PM_FUSES_6__LPMLTemperatureScaler_11__SHIFT 0x0
#define PM_FUSES_6__LPMLTemperatureScaler_10_MASK 0xff00
#define PM_FUSES_6__LPMLTemperatureScaler_10__SHIFT 0x8
#define PM_FUSES_6__LPMLTemperatureScaler_9_MASK 0xff0000
#define PM_FUSES_6__LPMLTemperatureScaler_9__SHIFT 0x10
#define PM_FUSES_6__LPMLTemperatureScaler_8_MASK 0xff000000
#define PM_FUSES_6__LPMLTemperatureScaler_8__SHIFT 0x18
#define PM_FUSES_7__LPMLTemperatureScaler_15_MASK 0xff
#define PM_FUSES_7__LPMLTemperatureScaler_15__SHIFT 0x0
#define PM_FUSES_7__LPMLTemperatureScaler_14_MASK 0xff00
#define PM_FUSES_7__LPMLTemperatureScaler_14__SHIFT 0x8
#define PM_FUSES_7__LPMLTemperatureScaler_13_MASK 0xff0000
#define PM_FUSES_7__LPMLTemperatureScaler_13__SHIFT 0x10
#define PM_FUSES_7__LPMLTemperatureScaler_12_MASK 0xff000000
#define PM_FUSES_7__LPMLTemperatureScaler_12__SHIFT 0x18
#define PM_FUSES_8__FuzzyFan_ErrorRateSetDelta_MASK 0xffff
#define PM_FUSES_8__FuzzyFan_ErrorRateSetDelta__SHIFT 0x0
#define PM_FUSES_8__FuzzyFan_ErrorSetDelta_MASK 0xffff0000
#define PM_FUSES_8__FuzzyFan_ErrorSetDelta__SHIFT 0x10
#define PM_FUSES_9__Reserved6_MASK 0xffff
#define PM_FUSES_9__Reserved6__SHIFT 0x0
#define PM_FUSES_9__FuzzyFan_PwmSetDelta_MASK 0xffff0000
#define PM_FUSES_9__FuzzyFan_PwmSetDelta__SHIFT 0x10
#define PM_FUSES_10__GnbLPML_3_MASK 0xff
#define PM_FUSES_10__GnbLPML_3__SHIFT 0x0
#define PM_FUSES_10__GnbLPML_2_MASK 0xff00
#define PM_FUSES_10__GnbLPML_2__SHIFT 0x8
#define PM_FUSES_10__GnbLPML_1_MASK 0xff0000
#define PM_FUSES_10__GnbLPML_1__SHIFT 0x10
#define PM_FUSES_10__GnbLPML_0_MASK 0xff000000
#define PM_FUSES_10__GnbLPML_0__SHIFT 0x18
#define PM_FUSES_11__GnbLPML_7_MASK 0xff
#define PM_FUSES_11__GnbLPML_7__SHIFT 0x0
#define PM_FUSES_11__GnbLPML_6_MASK 0xff00
#define PM_FUSES_11__GnbLPML_6__SHIFT 0x8
#define PM_FUSES_11__GnbLPML_5_MASK 0xff0000
#define PM_FUSES_11__GnbLPML_5__SHIFT 0x10
#define PM_FUSES_11__GnbLPML_4_MASK 0xff000000
#define PM_FUSES_11__GnbLPML_4__SHIFT 0x18
#define PM_FUSES_12__GnbLPML_11_MASK 0xff
#define PM_FUSES_12__GnbLPML_11__SHIFT 0x0
#define PM_FUSES_12__GnbLPML_10_MASK 0xff00
#define PM_FUSES_12__GnbLPML_10__SHIFT 0x8
#define PM_FUSES_12__GnbLPML_9_MASK 0xff0000
#define PM_FUSES_12__GnbLPML_9__SHIFT 0x10
#define PM_FUSES_12__GnbLPML_8_MASK 0xff000000
#define PM_FUSES_12__GnbLPML_8__SHIFT 0x18
#define PM_FUSES_13__GnbLPML_15_MASK 0xff
#define PM_FUSES_13__GnbLPML_15__SHIFT 0x0
#define PM_FUSES_13__GnbLPML_14_MASK 0xff00
#define PM_FUSES_13__GnbLPML_14__SHIFT 0x8
#define PM_FUSES_13__GnbLPML_13_MASK 0xff0000
#define PM_FUSES_13__GnbLPML_13__SHIFT 0x10
#define PM_FUSES_13__GnbLPML_12_MASK 0xff000000
#define PM_FUSES_13__GnbLPML_12__SHIFT 0x18
#define PM_FUSES_14__Reserved1_1_MASK 0xff
#define PM_FUSES_14__Reserved1_1__SHIFT 0x0
#define PM_FUSES_14__Reserved1_0_MASK 0xff00
#define PM_FUSES_14__Reserved1_0__SHIFT 0x8
#define PM_FUSES_14__GnbLPMLMinVid_MASK 0xff0000
#define PM_FUSES_14__GnbLPMLMinVid__SHIFT 0x10
#define PM_FUSES_14__GnbLPMLMaxVid_MASK 0xff000000
#define PM_FUSES_14__GnbLPMLMaxVid__SHIFT 0x18
#define PM_FUSES_15__BapmVddCBaseLeakageLoSidd_MASK 0xffff
#define PM_FUSES_15__BapmVddCBaseLeakageLoSidd__SHIFT 0x0
#define PM_FUSES_15__BapmVddCBaseLeakageHiSidd_MASK 0xffff0000
#define PM_FUSES_15__BapmVddCBaseLeakageHiSidd__SHIFT 0x10
#define SMU_PM_STATUS_0__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_0__DATA__SHIFT 0x0
#define SMU_PM_STATUS_1__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_1__DATA__SHIFT 0x0
#define SMU_PM_STATUS_2__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_2__DATA__SHIFT 0x0
#define SMU_PM_STATUS_3__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_3__DATA__SHIFT 0x0
#define SMU_PM_STATUS_4__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_4__DATA__SHIFT 0x0
#define SMU_PM_STATUS_5__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_5__DATA__SHIFT 0x0
#define SMU_PM_STATUS_6__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_6__DATA__SHIFT 0x0
#define SMU_PM_STATUS_7__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_7__DATA__SHIFT 0x0
#define SMU_PM_STATUS_8__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_8__DATA__SHIFT 0x0
#define SMU_PM_STATUS_9__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_9__DATA__SHIFT 0x0
#define SMU_PM_STATUS_10__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_10__DATA__SHIFT 0x0
#define SMU_PM_STATUS_11__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_11__DATA__SHIFT 0x0
#define SMU_PM_STATUS_12__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_12__DATA__SHIFT 0x0
#define SMU_PM_STATUS_13__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_13__DATA__SHIFT 0x0
#define SMU_PM_STATUS_14__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_14__DATA__SHIFT 0x0
#define SMU_PM_STATUS_15__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_15__DATA__SHIFT 0x0
#define SMU_PM_STATUS_16__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_16__DATA__SHIFT 0x0
#define SMU_PM_STATUS_17__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_17__DATA__SHIFT 0x0
#define SMU_PM_STATUS_18__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_18__DATA__SHIFT 0x0
#define SMU_PM_STATUS_19__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_19__DATA__SHIFT 0x0
#define SMU_PM_STATUS_20__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_20__DATA__SHIFT 0x0
#define SMU_PM_STATUS_21__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_21__DATA__SHIFT 0x0
#define SMU_PM_STATUS_22__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_22__DATA__SHIFT 0x0
#define SMU_PM_STATUS_23__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_23__DATA__SHIFT 0x0
#define SMU_PM_STATUS_24__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_24__DATA__SHIFT 0x0
#define SMU_PM_STATUS_25__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_25__DATA__SHIFT 0x0
#define SMU_PM_STATUS_26__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_26__DATA__SHIFT 0x0
#define SMU_PM_STATUS_27__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_27__DATA__SHIFT 0x0
#define SMU_PM_STATUS_28__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_28__DATA__SHIFT 0x0
#define SMU_PM_STATUS_29__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_29__DATA__SHIFT 0x0
#define SMU_PM_STATUS_30__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_30__DATA__SHIFT 0x0
#define SMU_PM_STATUS_31__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_31__DATA__SHIFT 0x0
#define SMU_PM_STATUS_32__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_32__DATA__SHIFT 0x0
#define SMU_PM_STATUS_33__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_33__DATA__SHIFT 0x0
#define SMU_PM_STATUS_34__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_34__DATA__SHIFT 0x0
#define SMU_PM_STATUS_35__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_35__DATA__SHIFT 0x0
#define SMU_PM_STATUS_36__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_36__DATA__SHIFT 0x0
#define SMU_PM_STATUS_37__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_37__DATA__SHIFT 0x0
#define SMU_PM_STATUS_38__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_38__DATA__SHIFT 0x0
#define SMU_PM_STATUS_39__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_39__DATA__SHIFT 0x0
#define SMU_PM_STATUS_40__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_40__DATA__SHIFT 0x0
#define SMU_PM_STATUS_41__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_41__DATA__SHIFT 0x0
#define SMU_PM_STATUS_42__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_42__DATA__SHIFT 0x0
#define SMU_PM_STATUS_43__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_43__DATA__SHIFT 0x0
#define SMU_PM_STATUS_44__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_44__DATA__SHIFT 0x0
#define SMU_PM_STATUS_45__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_45__DATA__SHIFT 0x0
#define SMU_PM_STATUS_46__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_46__DATA__SHIFT 0x0
#define SMU_PM_STATUS_47__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_47__DATA__SHIFT 0x0
#define SMU_PM_STATUS_48__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_48__DATA__SHIFT 0x0
#define SMU_PM_STATUS_49__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_49__DATA__SHIFT 0x0
#define SMU_PM_STATUS_50__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_50__DATA__SHIFT 0x0
#define SMU_PM_STATUS_51__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_51__DATA__SHIFT 0x0
#define SMU_PM_STATUS_52__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_52__DATA__SHIFT 0x0
#define SMU_PM_STATUS_53__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_53__DATA__SHIFT 0x0
#define SMU_PM_STATUS_54__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_54__DATA__SHIFT 0x0
#define SMU_PM_STATUS_55__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_55__DATA__SHIFT 0x0
#define SMU_PM_STATUS_56__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_56__DATA__SHIFT 0x0
#define SMU_PM_STATUS_57__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_57__DATA__SHIFT 0x0
#define SMU_PM_STATUS_58__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_58__DATA__SHIFT 0x0
#define SMU_PM_STATUS_59__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_59__DATA__SHIFT 0x0
#define SMU_PM_STATUS_60__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_60__DATA__SHIFT 0x0
#define SMU_PM_STATUS_61__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_61__DATA__SHIFT 0x0
#define SMU_PM_STATUS_62__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_62__DATA__SHIFT 0x0
#define SMU_PM_STATUS_63__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_63__DATA__SHIFT 0x0
#define SMU_PM_STATUS_64__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_64__DATA__SHIFT 0x0
#define SMU_PM_STATUS_65__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_65__DATA__SHIFT 0x0
#define SMU_PM_STATUS_66__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_66__DATA__SHIFT 0x0
#define SMU_PM_STATUS_67__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_67__DATA__SHIFT 0x0
#define SMU_PM_STATUS_68__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_68__DATA__SHIFT 0x0
#define SMU_PM_STATUS_69__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_69__DATA__SHIFT 0x0
#define SMU_PM_STATUS_70__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_70__DATA__SHIFT 0x0
#define SMU_PM_STATUS_71__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_71__DATA__SHIFT 0x0
#define SMU_PM_STATUS_72__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_72__DATA__SHIFT 0x0
#define SMU_PM_STATUS_73__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_73__DATA__SHIFT 0x0
#define SMU_PM_STATUS_74__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_74__DATA__SHIFT 0x0
#define SMU_PM_STATUS_75__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_75__DATA__SHIFT 0x0
#define SMU_PM_STATUS_76__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_76__DATA__SHIFT 0x0
#define SMU_PM_STATUS_77__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_77__DATA__SHIFT 0x0
#define SMU_PM_STATUS_78__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_78__DATA__SHIFT 0x0
#define SMU_PM_STATUS_79__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_79__DATA__SHIFT 0x0
#define SMU_PM_STATUS_80__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_80__DATA__SHIFT 0x0
#define SMU_PM_STATUS_81__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_81__DATA__SHIFT 0x0
#define SMU_PM_STATUS_82__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_82__DATA__SHIFT 0x0
#define SMU_PM_STATUS_83__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_83__DATA__SHIFT 0x0
#define SMU_PM_STATUS_84__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_84__DATA__SHIFT 0x0
#define SMU_PM_STATUS_85__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_85__DATA__SHIFT 0x0
#define SMU_PM_STATUS_86__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_86__DATA__SHIFT 0x0
#define SMU_PM_STATUS_87__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_87__DATA__SHIFT 0x0
#define SMU_PM_STATUS_88__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_88__DATA__SHIFT 0x0
#define SMU_PM_STATUS_89__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_89__DATA__SHIFT 0x0
#define SMU_PM_STATUS_90__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_90__DATA__SHIFT 0x0
#define SMU_PM_STATUS_91__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_91__DATA__SHIFT 0x0
#define SMU_PM_STATUS_92__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_92__DATA__SHIFT 0x0
#define SMU_PM_STATUS_93__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_93__DATA__SHIFT 0x0
#define SMU_PM_STATUS_94__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_94__DATA__SHIFT 0x0
#define SMU_PM_STATUS_95__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_95__DATA__SHIFT 0x0
#define SMU_PM_STATUS_96__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_96__DATA__SHIFT 0x0
#define SMU_PM_STATUS_97__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_97__DATA__SHIFT 0x0
#define SMU_PM_STATUS_98__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_98__DATA__SHIFT 0x0
#define SMU_PM_STATUS_99__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_99__DATA__SHIFT 0x0
#define SMU_PM_STATUS_100__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_100__DATA__SHIFT 0x0
#define SMU_PM_STATUS_101__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_101__DATA__SHIFT 0x0
#define SMU_PM_STATUS_102__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_102__DATA__SHIFT 0x0
#define SMU_PM_STATUS_103__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_103__DATA__SHIFT 0x0
#define SMU_PM_STATUS_104__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_104__DATA__SHIFT 0x0
#define SMU_PM_STATUS_105__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_105__DATA__SHIFT 0x0
#define SMU_PM_STATUS_106__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_106__DATA__SHIFT 0x0
#define SMU_PM_STATUS_107__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_107__DATA__SHIFT 0x0
#define SMU_PM_STATUS_108__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_108__DATA__SHIFT 0x0
#define SMU_PM_STATUS_109__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_109__DATA__SHIFT 0x0
#define SMU_PM_STATUS_110__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_110__DATA__SHIFT 0x0
#define SMU_PM_STATUS_111__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_111__DATA__SHIFT 0x0
#define SMU_PM_STATUS_112__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_112__DATA__SHIFT 0x0
#define SMU_PM_STATUS_113__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_113__DATA__SHIFT 0x0
#define SMU_PM_STATUS_114__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_114__DATA__SHIFT 0x0
#define SMU_PM_STATUS_115__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_115__DATA__SHIFT 0x0
#define SMU_PM_STATUS_116__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_116__DATA__SHIFT 0x0
#define SMU_PM_STATUS_117__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_117__DATA__SHIFT 0x0
#define SMU_PM_STATUS_118__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_118__DATA__SHIFT 0x0
#define SMU_PM_STATUS_119__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_119__DATA__SHIFT 0x0
#define SMU_PM_STATUS_120__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_120__DATA__SHIFT 0x0
#define SMU_PM_STATUS_121__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_121__DATA__SHIFT 0x0
#define SMU_PM_STATUS_122__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_122__DATA__SHIFT 0x0
#define SMU_PM_STATUS_123__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_123__DATA__SHIFT 0x0
#define SMU_PM_STATUS_124__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_124__DATA__SHIFT 0x0
#define SMU_PM_STATUS_125__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_125__DATA__SHIFT 0x0
#define SMU_PM_STATUS_126__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_126__DATA__SHIFT 0x0
#define SMU_PM_STATUS_127__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_127__DATA__SHIFT 0x0
#define CG_THERMAL_INT_ENA__THERM_INTH_SET_MASK 0x1
#define CG_THERMAL_INT_ENA__THERM_INTH_SET__SHIFT 0x0
#define CG_THERMAL_INT_ENA__THERM_INTL_SET_MASK 0x2
#define CG_THERMAL_INT_ENA__THERM_INTL_SET__SHIFT 0x1
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_SET_MASK 0x4
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_SET__SHIFT 0x2
#define CG_THERMAL_INT_ENA__THERM_INTH_CLR_MASK 0x8
#define CG_THERMAL_INT_ENA__THERM_INTH_CLR__SHIFT 0x3
#define CG_THERMAL_INT_ENA__THERM_INTL_CLR_MASK 0x10
#define CG_THERMAL_INT_ENA__THERM_INTL_CLR__SHIFT 0x4
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_CLR_MASK 0x20
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_CLR__SHIFT 0x5
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTH_MASK 0xff
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTH__SHIFT 0x0
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTL_MASK 0xff00
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTL__SHIFT 0x8
#define CG_THERMAL_INT_CTRL__GNB_TEMP_THRESHOLD_MASK 0xff0000
#define CG_THERMAL_INT_CTRL__GNB_TEMP_THRESHOLD__SHIFT 0x10
#define CG_THERMAL_INT_CTRL__THERM_INTH_MASK_MASK 0x1000000
#define CG_THERMAL_INT_CTRL__THERM_INTH_MASK__SHIFT 0x18
#define CG_THERMAL_INT_CTRL__THERM_INTL_MASK_MASK 0x2000000
#define CG_THERMAL_INT_CTRL__THERM_INTL_MASK__SHIFT 0x19
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_MASK_MASK 0x4000000
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_MASK__SHIFT 0x1a
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_CNB_MASK_MASK 0x8000000
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_CNB_MASK__SHIFT 0x1b
#define CG_THERMAL_INT_CTRL__THERM_GNB_HW_ENA_MASK 0x10000000
#define CG_THERMAL_INT_CTRL__THERM_GNB_HW_ENA__SHIFT 0x1c
#define CG_THERMAL_INT_STATUS__THERM_INTH_DETECT_MASK 0x1
#define CG_THERMAL_INT_STATUS__THERM_INTH_DETECT__SHIFT 0x0
#define CG_THERMAL_INT_STATUS__THERM_INTL_DETECT_MASK 0x2
#define CG_THERMAL_INT_STATUS__THERM_INTL_DETECT__SHIFT 0x1
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_DETECT_MASK 0x4
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_DETECT__SHIFT 0x2
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_CNB_DETECT_MASK 0x8
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_CNB_DETECT__SHIFT 0x3
#define CG_THERMAL_CTRL__DPM_EVENT_SRC_MASK 0x7
#define CG_THERMAL_CTRL__DPM_EVENT_SRC__SHIFT 0x0
#define CG_THERMAL_CTRL__THERM_INC_CLK_MASK 0x8
#define CG_THERMAL_CTRL__THERM_INC_CLK__SHIFT 0x3
#define CG_THERMAL_CTRL__SPARE_MASK 0x3ff0
#define CG_THERMAL_CTRL__SPARE__SHIFT 0x4
#define CG_THERMAL_CTRL__DIG_THERM_DPM_MASK 0x3fc000
#define CG_THERMAL_CTRL__DIG_THERM_DPM__SHIFT 0xe
#define CG_THERMAL_CTRL__RESERVED_MASK 0x1c00000
#define CG_THERMAL_CTRL__RESERVED__SHIFT 0x16
#define CG_THERMAL_CTRL__CTF_PAD_POLARITY_MASK 0x2000000
#define CG_THERMAL_CTRL__CTF_PAD_POLARITY__SHIFT 0x19
#define CG_THERMAL_CTRL__CTF_PAD_EN_MASK 0x4000000
#define CG_THERMAL_CTRL__CTF_PAD_EN__SHIFT 0x1a
#define CG_THERMAL_STATUS__SPARE_MASK 0x1ff
#define CG_THERMAL_STATUS__SPARE__SHIFT 0x0
#define CG_THERMAL_STATUS__FDO_PWM_DUTY_MASK 0x1fe00
#define CG_THERMAL_STATUS__FDO_PWM_DUTY__SHIFT 0x9
#define CG_THERMAL_STATUS__THERM_ALERT_MASK 0x20000
#define CG_THERMAL_STATUS__THERM_ALERT__SHIFT 0x11
#define CG_THERMAL_STATUS__GEN_STATUS_MASK 0x3c0000
#define CG_THERMAL_STATUS__GEN_STATUS__SHIFT 0x12
#define CG_THERMAL_INT__DIG_THERM_CTF_MASK 0xff
#define CG_THERMAL_INT__DIG_THERM_CTF__SHIFT 0x0
#define CG_THERMAL_INT__DIG_THERM_INTH_MASK 0xff00
#define CG_THERMAL_INT__DIG_THERM_INTH__SHIFT 0x8
#define CG_THERMAL_INT__DIG_THERM_INTL_MASK 0xff0000
#define CG_THERMAL_INT__DIG_THERM_INTL__SHIFT 0x10
#define CG_THERMAL_INT__THERM_INT_MASK_MASK 0xf000000
#define CG_THERMAL_INT__THERM_INT_MASK__SHIFT 0x18
#define CG_MULT_THERMAL_CTRL__TS_FILTER_MASK 0xf
#define CG_MULT_THERMAL_CTRL__TS_FILTER__SHIFT 0x0
#define CG_MULT_THERMAL_CTRL__UNUSED_MASK 0x1f0
#define CG_MULT_THERMAL_CTRL__UNUSED__SHIFT 0x4
#define CG_MULT_THERMAL_CTRL__THERMAL_RANGE_RST_MASK 0x200
#define CG_MULT_THERMAL_CTRL__THERMAL_RANGE_RST__SHIFT 0x9
#define CG_MULT_THERMAL_CTRL__TEMP_SEL_MASK 0xff00000
#define CG_MULT_THERMAL_CTRL__TEMP_SEL__SHIFT 0x14
#define CG_MULT_THERMAL_CTRL__THM_READY_CLEAR_MASK 0x10000000
#define CG_MULT_THERMAL_CTRL__THM_READY_CLEAR__SHIFT 0x1c
#define CG_MULT_THERMAL_STATUS__ASIC_MAX_TEMP_MASK 0x1ff
#define CG_MULT_THERMAL_STATUS__ASIC_MAX_TEMP__SHIFT 0x0
#define CG_MULT_THERMAL_STATUS__CTF_TEMP_MASK 0x3fe00
#define CG_MULT_THERMAL_STATUS__CTF_TEMP__SHIFT 0x9
#define THM_TMON2_CTRL__POWER_DOWN_MASK 0x1
#define THM_TMON2_CTRL__POWER_DOWN__SHIFT 0x0
#define THM_TMON2_CTRL__BGADJ_MASK 0x1fe
#define THM_TMON2_CTRL__BGADJ__SHIFT 0x1
#define THM_TMON2_CTRL__BGADJ_MODE_MASK 0x200
#define THM_TMON2_CTRL__BGADJ_MODE__SHIFT 0x9
#define THM_TMON2_CTRL__TMON_PAUSE_MASK 0x400
#define THM_TMON2_CTRL__TMON_PAUSE__SHIFT 0xa
#define THM_TMON2_CTRL__INT_MEAS_EN_MASK 0x800
#define THM_TMON2_CTRL__INT_MEAS_EN__SHIFT 0xb
#define THM_TMON2_CTRL__DEBUG_MODE_MASK 0x1000
#define THM_TMON2_CTRL__DEBUG_MODE__SHIFT 0xc
#define THM_TMON2_CTRL__EN_CFG_SERDES_MASK 0x2000
#define THM_TMON2_CTRL__EN_CFG_SERDES__SHIFT 0xd
#define THM_TMON2_CTRL2__RDIL_PRESENT_MASK 0xffff
#define THM_TMON2_CTRL2__RDIL_PRESENT__SHIFT 0x0
#define THM_TMON2_CTRL2__RDIR_PRESENT_MASK 0xffff0000
#define THM_TMON2_CTRL2__RDIR_PRESENT__SHIFT 0x10
#define THM_TMON2_CSR_WR__CSR_WRITE_MASK 0x1
#define THM_TMON2_CSR_WR__CSR_WRITE__SHIFT 0x0
#define THM_TMON2_CSR_WR__CSR_READ_MASK 0x2
#define THM_TMON2_CSR_WR__CSR_READ__SHIFT 0x1
#define THM_TMON2_CSR_WR__CSR_ADDR_MASK 0xffc
#define THM_TMON2_CSR_WR__CSR_ADDR__SHIFT 0x2
#define THM_TMON2_CSR_WR__WRITE_DATA_MASK 0xfff000
#define THM_TMON2_CSR_WR__WRITE_DATA__SHIFT 0xc
#define THM_TMON2_CSR_WR__SPARE_MASK 0x1000000
#define THM_TMON2_CSR_WR__SPARE__SHIFT 0x18
#define THM_TMON2_CSR_RD__READ_DATA_MASK 0xfff
#define THM_TMON2_CSR_RD__READ_DATA__SHIFT 0x0
#define CG_FDO_CTRL0__FDO_STATIC_DUTY_MASK 0xff
#define CG_FDO_CTRL0__FDO_STATIC_DUTY__SHIFT 0x0
#define CG_FDO_CTRL0__FAN_SPINUP_DUTY_MASK 0xff00
#define CG_FDO_CTRL0__FAN_SPINUP_DUTY__SHIFT 0x8
#define CG_FDO_CTRL0__FDO_PWM_MANUAL_MASK 0x10000
#define CG_FDO_CTRL0__FDO_PWM_MANUAL__SHIFT 0x10
#define CG_FDO_CTRL0__FDO_PWM_HYSTER_MASK 0x7e0000
#define CG_FDO_CTRL0__FDO_PWM_HYSTER__SHIFT 0x11
#define CG_FDO_CTRL0__FDO_PWM_RAMP_EN_MASK 0x800000
#define CG_FDO_CTRL0__FDO_PWM_RAMP_EN__SHIFT 0x17
#define CG_FDO_CTRL0__FDO_PWM_RAMP_MASK 0xff000000
#define CG_FDO_CTRL0__FDO_PWM_RAMP__SHIFT 0x18
#define CG_FDO_CTRL1__FMAX_DUTY100_MASK 0xff
#define CG_FDO_CTRL1__FMAX_DUTY100__SHIFT 0x0
#define CG_FDO_CTRL1__FMIN_DUTY_MASK 0xff00
#define CG_FDO_CTRL1__FMIN_DUTY__SHIFT 0x8
#define CG_FDO_CTRL1__M_MASK 0xff0000
#define CG_FDO_CTRL1__M__SHIFT 0x10
#define CG_FDO_CTRL1__RESERVED_MASK 0x3f000000
#define CG_FDO_CTRL1__RESERVED__SHIFT 0x18
#define CG_FDO_CTRL1__FDO_PWRDNB_MASK 0x40000000
#define CG_FDO_CTRL1__FDO_PWRDNB__SHIFT 0x1e
#define CG_FDO_CTRL2__TMIN_MASK 0xff
#define CG_FDO_CTRL2__TMIN__SHIFT 0x0
#define CG_FDO_CTRL2__FAN_SPINUP_TIME_MASK 0x700
#define CG_FDO_CTRL2__FAN_SPINUP_TIME__SHIFT 0x8
#define CG_FDO_CTRL2__FDO_PWM_MODE_MASK 0x3800
#define CG_FDO_CTRL2__FDO_PWM_MODE__SHIFT 0xb
#define CG_FDO_CTRL2__TMIN_HYSTER_MASK 0x1c000
#define CG_FDO_CTRL2__TMIN_HYSTER__SHIFT 0xe
#define CG_FDO_CTRL2__TMAX_MASK 0x1fe0000
#define CG_FDO_CTRL2__TMAX__SHIFT 0x11
#define CG_FDO_CTRL2__TACH_PWM_RESP_RATE_MASK 0xfe000000
#define CG_FDO_CTRL2__TACH_PWM_RESP_RATE__SHIFT 0x19
#define CG_TACH_CTRL__EDGE_PER_REV_MASK 0x7
#define CG_TACH_CTRL__EDGE_PER_REV__SHIFT 0x0
#define CG_TACH_CTRL__TARGET_PERIOD_MASK 0xfffffff8
#define CG_TACH_CTRL__TARGET_PERIOD__SHIFT 0x3
#define CG_TACH_STATUS__TACH_PERIOD_MASK 0xffffffff
#define CG_TACH_STATUS__TACH_PERIOD__SHIFT 0x0
#define CC_THM_STRAPS0__TMON0_BGADJ_MASK 0x1fe
#define CC_THM_STRAPS0__TMON0_BGADJ__SHIFT 0x1
#define CC_THM_STRAPS0__TMON1_BGADJ_MASK 0x1fe00
#define CC_THM_STRAPS0__TMON1_BGADJ__SHIFT 0x9
#define CC_THM_STRAPS0__TMON_CMON_FUSE_SEL_MASK 0x20000
#define CC_THM_STRAPS0__TMON_CMON_FUSE_SEL__SHIFT 0x11
#define CC_THM_STRAPS0__NUM_ACQ_MASK 0x1c0000
#define CC_THM_STRAPS0__NUM_ACQ__SHIFT 0x12
#define CC_THM_STRAPS0__TMON_CLK_SEL_MASK 0xe00000
#define CC_THM_STRAPS0__TMON_CLK_SEL__SHIFT 0x15
#define CC_THM_STRAPS0__TMON_CONFIG_SOURCE_MASK 0x1000000
#define CC_THM_STRAPS0__TMON_CONFIG_SOURCE__SHIFT 0x18
#define CC_THM_STRAPS0__CTF_DISABLE_MASK 0x2000000
#define CC_THM_STRAPS0__CTF_DISABLE__SHIFT 0x19
#define CC_THM_STRAPS0__TMON0_DISABLE_MASK 0x4000000
#define CC_THM_STRAPS0__TMON0_DISABLE__SHIFT 0x1a
#define CC_THM_STRAPS0__TMON1_DISABLE_MASK 0x8000000
#define CC_THM_STRAPS0__TMON1_DISABLE__SHIFT 0x1b
#define CC_THM_STRAPS0__TMON2_DISABLE_MASK 0x10000000
#define CC_THM_STRAPS0__TMON2_DISABLE__SHIFT 0x1c
#define CC_THM_STRAPS0__TMON3_DISABLE_MASK 0x20000000
#define CC_THM_STRAPS0__TMON3_DISABLE__SHIFT 0x1d
#define CC_THM_STRAPS0__UNUSED_MASK 0x80000000
#define CC_THM_STRAPS0__UNUSED__SHIFT 0x1f
#define THM_TMON0_RDIL0_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL0_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL0_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL0_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL0_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL0_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL1_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL1_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL1_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL1_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL1_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL1_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL2_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL2_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL2_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL2_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL2_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL2_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL3_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL3_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL3_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL3_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL3_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL3_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL4_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL4_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL4_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL4_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL4_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL4_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL5_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL5_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL5_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL5_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL5_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL5_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL6_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL6_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL6_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL6_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL6_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL6_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL7_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL7_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL7_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL7_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL7_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL7_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL8_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL8_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL8_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL8_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL8_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL8_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL9_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL9_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL9_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL9_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL9_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL9_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL10_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL10_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL10_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL10_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL10_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL10_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL11_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL11_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL11_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL11_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL11_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL11_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL12_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL12_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL12_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL12_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL12_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL12_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL13_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL13_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL13_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL13_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL13_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL13_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL14_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL14_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL14_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL14_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL14_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL14_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL15_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL15_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL15_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL15_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL15_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL15_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR0_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR0_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR0_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR0_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR0_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR0_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR1_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR1_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR1_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR1_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR1_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR1_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR2_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR2_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR2_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR2_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR2_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR2_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR3_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR3_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR3_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR3_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR3_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR3_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR4_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR4_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR4_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR4_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR4_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR4_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR5_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR5_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR5_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR5_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR5_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR5_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR6_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR6_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR6_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR6_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR6_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR6_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR7_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR7_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR7_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR7_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR7_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR7_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR8_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR8_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR8_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR8_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR8_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR8_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR9_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR9_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR9_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR9_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR9_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR9_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR10_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR10_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR10_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR10_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR10_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR10_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR11_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR11_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR11_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR11_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR11_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR11_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR12_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR12_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR12_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR12_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR12_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR12_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR13_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR13_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR13_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR13_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR13_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR13_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR14_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR14_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR14_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR14_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR14_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR14_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR15_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR15_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR15_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR15_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR15_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR15_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL0_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL0_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL0_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL0_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL0_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL0_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL1_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL1_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL1_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL1_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL1_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL1_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL2_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL2_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL2_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL2_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL2_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL2_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL3_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL3_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL3_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL3_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL3_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL3_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL4_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL4_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL4_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL4_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL4_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL4_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL5_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL5_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL5_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL5_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL5_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL5_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL6_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL6_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL6_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL6_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL6_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL6_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL7_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL7_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL7_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL7_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL7_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL7_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL8_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL8_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL8_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL8_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL8_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL8_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL9_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL9_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL9_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL9_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL9_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL9_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL10_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL10_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL10_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL10_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL10_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL10_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL11_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL11_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL11_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL11_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL11_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL11_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL12_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL12_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL12_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL12_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL12_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL12_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL13_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL13_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL13_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL13_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL13_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL13_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL14_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL14_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL14_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL14_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL14_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL14_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIL15_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIL15_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIL15_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIL15_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIL15_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIL15_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR0_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR0_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR0_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR0_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR0_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR0_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR1_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR1_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR1_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR1_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR1_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR1_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR2_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR2_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR2_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR2_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR2_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR2_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR3_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR3_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR3_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR3_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR3_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR3_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR4_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR4_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR4_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR4_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR4_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR4_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR5_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR5_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR5_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR5_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR5_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR5_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR6_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR6_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR6_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR6_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR6_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR6_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR7_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR7_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR7_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR7_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR7_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR7_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR8_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR8_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR8_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR8_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR8_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR8_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR9_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR9_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR9_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR9_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR9_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR9_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR10_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR10_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR10_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR10_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR10_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR10_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR11_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR11_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR11_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR11_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR11_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR11_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR12_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR12_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR12_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR12_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR12_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR12_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR13_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR13_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR13_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR13_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR13_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR13_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR14_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR14_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR14_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR14_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR14_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR14_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_RDIR15_DATA__Z_MASK 0x7ff
#define THM_TMON1_RDIR15_DATA__Z__SHIFT 0x0
#define THM_TMON1_RDIR15_DATA__VALID_MASK 0x800
#define THM_TMON1_RDIR15_DATA__VALID__SHIFT 0xb
#define THM_TMON1_RDIR15_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_RDIR15_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL0_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL0_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL0_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL0_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL0_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL0_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL1_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL1_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL1_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL1_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL1_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL1_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL2_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL2_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL2_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL2_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL2_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL2_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL3_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL3_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL3_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL3_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL3_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL3_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL4_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL4_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL4_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL4_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL4_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL4_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL5_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL5_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL5_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL5_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL5_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL5_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL6_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL6_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL6_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL6_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL6_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL6_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL7_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL7_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL7_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL7_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL7_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL7_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL8_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL8_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL8_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL8_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL8_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL8_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL9_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL9_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL9_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL9_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL9_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL9_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL10_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL10_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL10_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL10_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL10_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL10_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL11_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL11_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL11_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL11_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL11_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL11_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL12_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL12_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL12_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL12_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL12_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL12_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL13_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL13_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL13_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL13_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL13_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL13_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL14_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL14_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL14_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL14_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL14_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL14_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIL15_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIL15_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIL15_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIL15_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIL15_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIL15_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR0_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR0_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR0_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR0_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR0_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR0_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR1_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR1_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR1_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR1_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR1_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR1_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR2_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR2_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR2_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR2_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR2_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR2_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR3_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR3_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR3_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR3_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR3_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR3_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR4_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR4_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR4_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR4_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR4_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR4_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR5_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR5_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR5_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR5_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR5_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR5_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR6_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR6_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR6_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR6_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR6_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR6_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR7_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR7_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR7_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR7_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR7_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR7_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR8_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR8_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR8_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR8_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR8_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR8_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR9_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR9_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR9_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR9_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR9_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR9_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR10_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR10_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR10_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR10_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR10_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR10_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR11_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR11_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR11_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR11_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR11_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR11_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR12_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR12_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR12_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR12_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR12_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR12_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR13_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR13_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR13_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR13_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR13_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR13_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR14_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR14_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR14_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR14_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR14_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR14_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_RDIR15_DATA__Z_MASK 0x7ff
#define THM_TMON2_RDIR15_DATA__Z__SHIFT 0x0
#define THM_TMON2_RDIR15_DATA__VALID_MASK 0x800
#define THM_TMON2_RDIR15_DATA__VALID__SHIFT 0xb
#define THM_TMON2_RDIR15_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_RDIR15_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_INT_DATA__Z_MASK 0x7ff
#define THM_TMON0_INT_DATA__Z__SHIFT 0x0
#define THM_TMON0_INT_DATA__VALID_MASK 0x800
#define THM_TMON0_INT_DATA__VALID__SHIFT 0xb
#define THM_TMON0_INT_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_INT_DATA__TEMP__SHIFT 0xc
#define THM_TMON1_INT_DATA__Z_MASK 0x7ff
#define THM_TMON1_INT_DATA__Z__SHIFT 0x0
#define THM_TMON1_INT_DATA__VALID_MASK 0x800
#define THM_TMON1_INT_DATA__VALID__SHIFT 0xb
#define THM_TMON1_INT_DATA__TEMP_MASK 0xfff000
#define THM_TMON1_INT_DATA__TEMP__SHIFT 0xc
#define THM_TMON2_INT_DATA__Z_MASK 0x7ff
#define THM_TMON2_INT_DATA__Z__SHIFT 0x0
#define THM_TMON2_INT_DATA__VALID_MASK 0x800
#define THM_TMON2_INT_DATA__VALID__SHIFT 0xb
#define THM_TMON2_INT_DATA__TEMP_MASK 0xfff000
#define THM_TMON2_INT_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_DEBUG__DEBUG_RDI_MASK 0x1f
#define THM_TMON0_DEBUG__DEBUG_RDI__SHIFT 0x0
#define THM_TMON0_DEBUG__DEBUG_Z_MASK 0xffe0
#define THM_TMON0_DEBUG__DEBUG_Z__SHIFT 0x5
#define THM_TMON1_DEBUG__DEBUG_RDI_MASK 0x1f
#define THM_TMON1_DEBUG__DEBUG_RDI__SHIFT 0x0
#define THM_TMON1_DEBUG__DEBUG_Z_MASK 0xffe0
#define THM_TMON1_DEBUG__DEBUG_Z__SHIFT 0x5
#define THM_TMON2_DEBUG__DEBUG_RDI_MASK 0x1f
#define THM_TMON2_DEBUG__DEBUG_RDI__SHIFT 0x0
#define THM_TMON2_DEBUG__DEBUG_Z_MASK 0xffe0
#define THM_TMON2_DEBUG__DEBUG_Z__SHIFT 0x5
#define THM_TMON0_STATUS__CURRENT_RDI_MASK 0x1f
#define THM_TMON0_STATUS__CURRENT_RDI__SHIFT 0x0
#define THM_TMON0_STATUS__MEAS_DONE_MASK 0x20
#define THM_TMON0_STATUS__MEAS_DONE__SHIFT 0x5
#define THM_TMON1_STATUS__CURRENT_RDI_MASK 0x1f
#define THM_TMON1_STATUS__CURRENT_RDI__SHIFT 0x0
#define THM_TMON1_STATUS__MEAS_DONE_MASK 0x20
#define THM_TMON1_STATUS__MEAS_DONE__SHIFT 0x5
#define THM_TMON2_STATUS__CURRENT_RDI_MASK 0x1f
#define THM_TMON2_STATUS__CURRENT_RDI__SHIFT 0x0
#define THM_TMON2_STATUS__MEAS_DONE_MASK 0x20
#define THM_TMON2_STATUS__MEAS_DONE__SHIFT 0x5
#define GENERAL_PWRMGT__GLOBAL_PWRMGT_EN_MASK 0x1
#define GENERAL_PWRMGT__GLOBAL_PWRMGT_EN__SHIFT 0x0
#define GENERAL_PWRMGT__STATIC_PM_EN_MASK 0x2
#define GENERAL_PWRMGT__STATIC_PM_EN__SHIFT 0x1
#define GENERAL_PWRMGT__THERMAL_PROTECTION_DIS_MASK 0x4
#define GENERAL_PWRMGT__THERMAL_PROTECTION_DIS__SHIFT 0x2
#define GENERAL_PWRMGT__THERMAL_PROTECTION_TYPE_MASK 0x8
#define GENERAL_PWRMGT__THERMAL_PROTECTION_TYPE__SHIFT 0x3
#define GENERAL_PWRMGT__SW_SMIO_INDEX_MASK 0x40
#define GENERAL_PWRMGT__SW_SMIO_INDEX__SHIFT 0x6
#define GENERAL_PWRMGT__LOW_VOLT_D2_ACPI_MASK 0x100
#define GENERAL_PWRMGT__LOW_VOLT_D2_ACPI__SHIFT 0x8
#define GENERAL_PWRMGT__LOW_VOLT_D3_ACPI_MASK 0x200
#define GENERAL_PWRMGT__LOW_VOLT_D3_ACPI__SHIFT 0x9
#define GENERAL_PWRMGT__VOLT_PWRMGT_EN_MASK 0x400
#define GENERAL_PWRMGT__VOLT_PWRMGT_EN__SHIFT 0xa
#define GENERAL_PWRMGT__SPARE11_MASK 0x800
#define GENERAL_PWRMGT__SPARE11__SHIFT 0xb
#define GENERAL_PWRMGT__GPU_COUNTER_ACPI_MASK 0x4000
#define GENERAL_PWRMGT__GPU_COUNTER_ACPI__SHIFT 0xe
#define GENERAL_PWRMGT__GPU_COUNTER_CLK_MASK 0x8000
#define GENERAL_PWRMGT__GPU_COUNTER_CLK__SHIFT 0xf
#define GENERAL_PWRMGT__GPU_COUNTER_OFF_MASK 0x10000
#define GENERAL_PWRMGT__GPU_COUNTER_OFF__SHIFT 0x10
#define GENERAL_PWRMGT__GPU_COUNTER_INTF_OFF_MASK 0x20000
#define GENERAL_PWRMGT__GPU_COUNTER_INTF_OFF__SHIFT 0x11
#define GENERAL_PWRMGT__SPARE18_MASK 0x40000
#define GENERAL_PWRMGT__SPARE18__SHIFT 0x12
#define GENERAL_PWRMGT__ACPI_D3_VID_MASK 0x180000
#define GENERAL_PWRMGT__ACPI_D3_VID__SHIFT 0x13
#define GENERAL_PWRMGT__DYN_SPREAD_SPECTRUM_EN_MASK 0x800000
#define GENERAL_PWRMGT__DYN_SPREAD_SPECTRUM_EN__SHIFT 0x17
#define GENERAL_PWRMGT__SPARE27_MASK 0x8000000
#define GENERAL_PWRMGT__SPARE27__SHIFT 0x1b
#define GENERAL_PWRMGT__SPARE_MASK 0xf0000000
#define GENERAL_PWRMGT__SPARE__SHIFT 0x1c
#define CNB_PWRMGT_CNTL__GNB_SLOW_MODE_MASK 0x3
#define CNB_PWRMGT_CNTL__GNB_SLOW_MODE__SHIFT 0x0
#define CNB_PWRMGT_CNTL__GNB_SLOW_MASK 0x4
#define CNB_PWRMGT_CNTL__GNB_SLOW__SHIFT 0x2
#define CNB_PWRMGT_CNTL__FORCE_NB_PS1_MASK 0x8
#define CNB_PWRMGT_CNTL__FORCE_NB_PS1__SHIFT 0x3
#define CNB_PWRMGT_CNTL__DPM_ENABLED_MASK 0x10
#define CNB_PWRMGT_CNTL__DPM_ENABLED__SHIFT 0x4
#define CNB_PWRMGT_CNTL__SPARE_MASK 0xffffffe0
#define CNB_PWRMGT_CNTL__SPARE__SHIFT 0x5
#define SCLK_PWRMGT_CNTL__SCLK_PWRMGT_OFF_MASK 0x1
#define SCLK_PWRMGT_CNTL__SCLK_PWRMGT_OFF__SHIFT 0x0
#define SCLK_PWRMGT_CNTL__RESET_BUSY_CNT_MASK 0x10
#define SCLK_PWRMGT_CNTL__RESET_BUSY_CNT__SHIFT 0x4
#define SCLK_PWRMGT_CNTL__RESET_SCLK_CNT_MASK 0x20
#define SCLK_PWRMGT_CNTL__RESET_SCLK_CNT__SHIFT 0x5
#define SCLK_PWRMGT_CNTL__DYN_LIGHT_SLEEP_EN_MASK 0x4000
#define SCLK_PWRMGT_CNTL__DYN_LIGHT_SLEEP_EN__SHIFT 0xe
#define SCLK_PWRMGT_CNTL__AUTO_SCLK_PULSE_SKIP_MASK 0x8000
#define SCLK_PWRMGT_CNTL__AUTO_SCLK_PULSE_SKIP__SHIFT 0xf
#define SCLK_PWRMGT_CNTL__LIGHT_SLEEP_COUNTER_MASK 0x1f0000
#define SCLK_PWRMGT_CNTL__LIGHT_SLEEP_COUNTER__SHIFT 0x10
#define SCLK_PWRMGT_CNTL__DYNAMIC_PM_EN_MASK 0x200000
#define SCLK_PWRMGT_CNTL__DYNAMIC_PM_EN__SHIFT 0x15
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARGET_STATE_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARGET_STATE__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURRENT_STATE_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURRENT_STATE__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_MCLK_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_MCLK_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_MCLK_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_MCLK_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_SCLK_INDEX_MASK 0x1f0000
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_SCLK_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_SCLK_INDEX_MASK 0x3e00000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_SCLK_INDEX__SHIFT 0x15
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_LCLK_INDEX_MASK 0x1c000000
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_LCLK_INDEX__SHIFT 0x1a
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_LCLK_INDEX_MASK 0xe0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_LCLK_INDEX__SHIFT 0x1d
#define PWR_PCC_CONTROL__PCC_POLARITY_MASK 0x1
#define PWR_PCC_CONTROL__PCC_POLARITY__SHIFT 0x0
#define PWR_PCC_GPIO_SELECT__GPIO_MASK 0xffffffff
#define PWR_PCC_GPIO_SELECT__GPIO__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_0__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_0__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_0__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_0__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_0__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_0__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_0__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_0__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_0__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_0__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_0__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_0__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_0__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_0__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_0__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_0__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_0__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_0__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_0__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_0__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_0__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_0__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_0__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_0__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_0__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_0__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_0__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_0__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_0__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_0__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_0__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_0__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_0__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_0__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_0__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_0__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_0__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_0__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_0__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_0__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_0__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_0__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_0__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_0__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_0__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_0__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_0__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_0__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_0__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_0__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_0__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_0__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_0__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_0__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_0__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_0__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_1__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_1__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_1__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_1__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_1__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_1__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_1__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_1__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_1__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_1__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_1__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_1__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_1__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_1__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_1__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_1__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_1__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_1__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_1__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_1__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_1__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_1__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_1__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_1__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_1__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_1__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_1__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_1__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_1__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_1__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_1__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_1__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_1__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_1__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_1__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_1__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_1__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_1__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_1__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_1__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_1__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_1__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_1__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_1__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_1__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_1__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_1__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_1__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_1__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_1__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_1__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_1__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_1__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_1__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_1__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_1__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_2__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_2__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_2__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_2__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_2__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_2__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_2__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_2__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_2__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_2__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_2__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_2__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_2__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_2__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_2__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_2__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_2__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_2__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_2__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_2__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_2__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_2__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_2__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_2__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_2__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_2__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_2__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_2__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_2__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_2__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_2__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_2__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_2__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_2__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_2__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_2__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_2__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_2__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_2__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_2__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_2__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_2__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_2__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_2__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_2__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_2__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_2__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_2__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_2__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_2__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_2__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_2__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_2__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_2__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_2__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_2__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_3__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_3__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_3__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_3__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_3__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_3__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_3__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_3__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_3__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_3__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_3__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_3__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_3__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_3__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_3__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_3__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_3__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_3__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_3__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_3__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_3__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_3__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_3__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_3__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_3__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_3__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_3__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_3__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_3__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_3__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_3__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_3__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_3__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_3__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_3__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_3__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_3__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_3__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_3__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_3__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_3__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_3__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_3__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_3__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_3__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_3__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_3__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_3__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_3__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_3__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_3__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_3__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_3__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_3__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_3__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_3__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_4__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_4__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_4__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_4__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_4__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_4__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_4__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_4__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_4__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_4__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_4__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_4__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_4__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_4__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_4__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_4__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_4__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_4__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_4__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_4__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_4__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_4__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_4__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_4__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_4__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_4__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_4__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_4__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_4__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_4__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_4__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_4__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_4__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_4__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_4__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_4__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_4__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_4__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_4__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_4__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_4__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_4__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_4__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_4__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_4__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_4__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_4__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_4__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_4__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_4__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_4__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_4__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_4__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_4__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_4__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_4__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_5__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_5__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_5__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_5__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_5__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_5__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_5__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_5__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_5__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_5__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_5__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_5__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_5__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_5__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_5__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_5__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_5__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_5__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_5__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_5__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_5__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_5__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_5__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_5__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_5__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_5__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_5__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_5__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_5__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_5__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_5__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_5__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_5__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_5__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_5__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_5__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_5__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_5__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_5__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_5__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_5__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_5__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_5__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_5__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_5__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_5__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_5__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_5__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_5__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_5__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_5__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_5__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_5__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_5__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_5__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_5__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_6__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_6__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_6__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_6__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_6__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_6__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_6__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_6__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_6__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_6__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_6__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_6__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_6__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_6__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_6__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_6__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_6__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_6__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_6__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_6__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_6__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_6__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_6__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_6__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_6__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_6__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_6__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_6__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_6__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_6__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_6__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_6__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_6__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_6__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_6__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_6__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_6__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_6__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_6__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_6__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_6__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_6__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_6__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_6__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_6__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_6__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_6__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_6__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_6__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_6__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_6__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_6__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_6__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_6__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_6__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_6__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_7__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_7__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_7__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_7__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_7__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_7__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_7__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_7__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_7__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_7__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_7__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_7__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_7__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_7__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_7__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_7__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_7__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_7__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_7__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_7__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_7__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_7__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_7__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_7__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_7__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_7__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_7__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_7__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_7__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_7__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_7__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_7__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_7__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_7__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_7__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_7__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_7__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_7__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_7__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_7__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_7__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_7__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_7__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_7__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_7__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_7__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_7__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_7__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_7__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_7__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_7__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_7__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_7__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_7__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_7__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_7__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define PLL_TEST_CNTL__TST_SRC_SEL_MASK 0xf
#define PLL_TEST_CNTL__TST_SRC_SEL__SHIFT 0x0
#define PLL_TEST_CNTL__TST_REF_SEL_MASK 0xf0
#define PLL_TEST_CNTL__TST_REF_SEL__SHIFT 0x4
#define PLL_TEST_CNTL__REF_TEST_COUNT_MASK 0x7f00
#define PLL_TEST_CNTL__REF_TEST_COUNT__SHIFT 0x8
#define PLL_TEST_CNTL__TST_RESET_MASK 0x8000
#define PLL_TEST_CNTL__TST_RESET__SHIFT 0xf
#define PLL_TEST_CNTL__TEST_COUNT_MASK 0xfffe0000
#define PLL_TEST_CNTL__TEST_COUNT__SHIFT 0x11
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_MASK 0xffff
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD__SHIFT 0x0
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_UNIT_MASK 0xf0000
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_UNIT__SHIFT 0x10
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MASK 0x3
#define CG_DISPLAY_GAP_CNTL__DISP_GAP__SHIFT 0x0
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_COUNT_MASK 0x3fff0
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_COUNT__SHIFT 0x4
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_UNIT_MASK 0x700000
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_UNIT__SHIFT 0x14
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MCHG_MASK 0x3000000
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MCHG__SHIFT 0x18
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_DISABLE_MASK 0x10000000
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_DISABLE__SHIFT 0x1c
#define CG_DISPLAY_GAP_CNTL2__VBI_PREDICTION_MASK 0xffffffff
#define CG_DISPLAY_GAP_CNTL2__VBI_PREDICTION__SHIFT 0x0
#define CG_ACPI_CNTL__SCLK_ACPI_DIV_MASK 0x7f
#define CG_ACPI_CNTL__SCLK_ACPI_DIV__SHIFT 0x0
#define CG_ACPI_CNTL__SCLK_CHANGE_SKIP_MASK 0x80
#define CG_ACPI_CNTL__SCLK_CHANGE_SKIP__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL__DIV_ID_MASK 0x7
#define SCLK_DEEP_SLEEP_CNTL__DIV_ID__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL__RAMP_DIS_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL__RAMP_DIS__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL__HYSTERESIS_MASK 0xfff0
#define SCLK_DEEP_SLEEP_CNTL__HYSTERESIS__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL__SCLK_RUNNING_MASK_MASK 0x10000
#define SCLK_DEEP_SLEEP_CNTL__SCLK_RUNNING_MASK__SHIFT 0x10
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_MASK_MASK 0x20000
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_MASK__SHIFT 0x11
#define SCLK_DEEP_SLEEP_CNTL__ALLOW_NBPSTATE_MASK_MASK 0x40000
#define SCLK_DEEP_SLEEP_CNTL__ALLOW_NBPSTATE_MASK__SHIFT 0x12
#define SCLK_DEEP_SLEEP_CNTL__BIF_BUSY_MASK_MASK 0x80000
#define SCLK_DEEP_SLEEP_CNTL__BIF_BUSY_MASK__SHIFT 0x13
#define SCLK_DEEP_SLEEP_CNTL__UVD_BUSY_MASK_MASK 0x100000
#define SCLK_DEEP_SLEEP_CNTL__UVD_BUSY_MASK__SHIFT 0x14
#define SCLK_DEEP_SLEEP_CNTL__MC0SRBM_BUSY_MASK_MASK 0x200000
#define SCLK_DEEP_SLEEP_CNTL__MC0SRBM_BUSY_MASK__SHIFT 0x15
#define SCLK_DEEP_SLEEP_CNTL__MC1SRBM_BUSY_MASK_MASK 0x400000
#define SCLK_DEEP_SLEEP_CNTL__MC1SRBM_BUSY_MASK__SHIFT 0x16
#define SCLK_DEEP_SLEEP_CNTL__MC_ALLOW_MASK_MASK 0x800000
#define SCLK_DEEP_SLEEP_CNTL__MC_ALLOW_MASK__SHIFT 0x17
#define SCLK_DEEP_SLEEP_CNTL__SMU_BUSY_MASK_MASK 0x1000000
#define SCLK_DEEP_SLEEP_CNTL__SMU_BUSY_MASK__SHIFT 0x18
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_NLC_MASK_MASK 0x2000000
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_NLC_MASK__SHIFT 0x19
#define SCLK_DEEP_SLEEP_CNTL__FAST_EXIT_REQ_NBPSTATE_MASK 0x4000000
#define SCLK_DEEP_SLEEP_CNTL__FAST_EXIT_REQ_NBPSTATE__SHIFT 0x1a
#define SCLK_DEEP_SLEEP_CNTL__DEEP_SLEEP_ENTRY_MODE_MASK 0x8000000
#define SCLK_DEEP_SLEEP_CNTL__DEEP_SLEEP_ENTRY_MODE__SHIFT 0x1b
#define SCLK_DEEP_SLEEP_CNTL__MBUS2_ACTIVE_MASK_MASK 0x10000000
#define SCLK_DEEP_SLEEP_CNTL__MBUS2_ACTIVE_MASK__SHIFT 0x1c
#define SCLK_DEEP_SLEEP_CNTL__VCE_BUSY_MASK_MASK 0x20000000
#define SCLK_DEEP_SLEEP_CNTL__VCE_BUSY_MASK__SHIFT 0x1d
#define SCLK_DEEP_SLEEP_CNTL__AZ_BUSY_MASK_MASK 0x40000000
#define SCLK_DEEP_SLEEP_CNTL__AZ_BUSY_MASK__SHIFT 0x1e
#define SCLK_DEEP_SLEEP_CNTL__ENABLE_DS_MASK 0x80000000
#define SCLK_DEEP_SLEEP_CNTL__ENABLE_DS__SHIFT 0x1f
#define SCLK_DEEP_SLEEP_CNTL2__RLC_BUSY_MASK_MASK 0x1
#define SCLK_DEEP_SLEEP_CNTL2__RLC_BUSY_MASK__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL2__HDP_BUSY_MASK_MASK 0x2
#define SCLK_DEEP_SLEEP_CNTL2__HDP_BUSY_MASK__SHIFT 0x1
#define SCLK_DEEP_SLEEP_CNTL2__ROM_BUSY_MASK_MASK 0x4
#define SCLK_DEEP_SLEEP_CNTL2__ROM_BUSY_MASK__SHIFT 0x2
#define SCLK_DEEP_SLEEP_CNTL2__IH_SEM_BUSY_MASK_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL2__IH_SEM_BUSY_MASK__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL2__PDMA_BUSY_MASK_MASK 0x10
#define SCLK_DEEP_SLEEP_CNTL2__PDMA_BUSY_MASK__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL2__IDCT_BUSY_MASK_MASK 0x40
#define SCLK_DEEP_SLEEP_CNTL2__IDCT_BUSY_MASK__SHIFT 0x6
#define SCLK_DEEP_SLEEP_CNTL2__SDMA_BUSY_MASK_MASK 0x80
#define SCLK_DEEP_SLEEP_CNTL2__SDMA_BUSY_MASK__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL2__DC_AZ_BUSY_MASK_MASK 0x100
#define SCLK_DEEP_SLEEP_CNTL2__DC_AZ_BUSY_MASK__SHIFT 0x8
#define SCLK_DEEP_SLEEP_CNTL2__ACP_SMU_ALLOW_DSLEEP_STUTTER_MASK_MASK 0x200
#define SCLK_DEEP_SLEEP_CNTL2__ACP_SMU_ALLOW_DSLEEP_STUTTER_MASK__SHIFT 0x9
#define SCLK_DEEP_SLEEP_CNTL2__UVD_CG_MC_STAT_BUSY_MASK_MASK 0x400
#define SCLK_DEEP_SLEEP_CNTL2__UVD_CG_MC_STAT_BUSY_MASK__SHIFT 0xa
#define SCLK_DEEP_SLEEP_CNTL2__VCE_CG_MC_STAT_BUSY_MASK_MASK 0x800
#define SCLK_DEEP_SLEEP_CNTL2__VCE_CG_MC_STAT_BUSY_MASK__SHIFT 0xb
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_MC_STAT_BUSY_MASK_MASK 0x1000
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_MC_STAT_BUSY_MASK__SHIFT 0xc
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_STATUS_BUSY_MASK_MASK 0x2000
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_STATUS_BUSY_MASK__SHIFT 0xd
#define SCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK_MASK 0x4000
#define SCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK__SHIFT 0xe
#define SCLK_DEEP_SLEEP_CNTL2__SHALLOW_DIV_ID_MASK 0xe00000
#define SCLK_DEEP_SLEEP_CNTL2__SHALLOW_DIV_ID__SHIFT 0x15
#define SCLK_DEEP_SLEEP_CNTL2__INOUT_CUSHION_MASK 0xff000000
#define SCLK_DEEP_SLEEP_CNTL2__INOUT_CUSHION__SHIFT 0x18
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_0_SMU_BUSY_MASK_MASK 0x1
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_0_SMU_BUSY_MASK__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_1_SMU_BUSY_MASK_MASK 0x2
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_1_SMU_BUSY_MASK__SHIFT 0x1
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_2_SMU_BUSY_MASK_MASK 0x4
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_2_SMU_BUSY_MASK__SHIFT 0x2
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_3_SMU_BUSY_MASK_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_3_SMU_BUSY_MASK__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_4_SMU_BUSY_MASK_MASK 0x10
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_4_SMU_BUSY_MASK__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_5_SMU_BUSY_MASK_MASK 0x20
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_5_SMU_BUSY_MASK__SHIFT 0x5
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_6_SMU_BUSY_MASK_MASK 0x40
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_6_SMU_BUSY_MASK__SHIFT 0x6
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_7_SMU_BUSY_MASK_MASK 0x80
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_7_SMU_BUSY_MASK__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_8_SMU_BUSY_MASK_MASK 0x100
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_8_SMU_BUSY_MASK__SHIFT 0x8
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_9_SMU_BUSY_MASK_MASK 0x200
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_9_SMU_BUSY_MASK__SHIFT 0x9
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_10_SMU_BUSY_MASK_MASK 0x400
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_10_SMU_BUSY_MASK__SHIFT 0xa
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_11_SMU_BUSY_MASK_MASK 0x800
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_11_SMU_BUSY_MASK__SHIFT 0xb
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_12_SMU_BUSY_MASK_MASK 0x1000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_12_SMU_BUSY_MASK__SHIFT 0xc
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_13_SMU_BUSY_MASK_MASK 0x2000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_13_SMU_BUSY_MASK__SHIFT 0xd
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_14_SMU_BUSY_MASK_MASK 0x4000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_14_SMU_BUSY_MASK__SHIFT 0xe
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_15_SMU_BUSY_MASK_MASK 0x8000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_15_SMU_BUSY_MASK__SHIFT 0xf
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_DS_DIV_ID_MASK 0x7
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_DS_DIV_ID__SHIFT 0x0
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_SS_DIV_ID_MASK 0x38
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_SS_DIV_ID__SHIFT 0x3
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_ENABLE_MASK 0x10000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_ENABLE__SHIFT 0x10
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_DS_DIV_ID_MASK 0xe0000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_DS_DIV_ID__SHIFT 0x11
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_SS_DIV_ID_MASK 0x700000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_SS_DIV_ID__SHIFT 0x14
#define LCLK_DEEP_SLEEP_CNTL__DIV_ID_MASK 0x7
#define LCLK_DEEP_SLEEP_CNTL__DIV_ID__SHIFT 0x0
#define LCLK_DEEP_SLEEP_CNTL__RAMP_DIS_MASK 0x8
#define LCLK_DEEP_SLEEP_CNTL__RAMP_DIS__SHIFT 0x3
#define LCLK_DEEP_SLEEP_CNTL__HYSTERESIS_MASK 0xfff0
#define LCLK_DEEP_SLEEP_CNTL__HYSTERESIS__SHIFT 0x4
#define LCLK_DEEP_SLEEP_CNTL__RESERVED_MASK 0x7fff0000
#define LCLK_DEEP_SLEEP_CNTL__RESERVED__SHIFT 0x10
#define LCLK_DEEP_SLEEP_CNTL__ENABLE_DS_MASK 0x80000000
#define LCLK_DEEP_SLEEP_CNTL__ENABLE_DS__SHIFT 0x1f
#define LCLK_DEEP_SLEEP_CNTL2__RFE_BUSY_MASK_MASK 0x1
#define LCLK_DEEP_SLEEP_CNTL2__RFE_BUSY_MASK__SHIFT 0x0
#define LCLK_DEEP_SLEEP_CNTL2__BIF_CG_LCLK_BUSY_MASK_MASK 0x2
#define LCLK_DEEP_SLEEP_CNTL2__BIF_CG_LCLK_BUSY_MASK__SHIFT 0x1
#define LCLK_DEEP_SLEEP_CNTL2__L1IMU_SMU_IDLE_MASK_MASK 0x4
#define LCLK_DEEP_SLEEP_CNTL2__L1IMU_SMU_IDLE_MASK__SHIFT 0x2
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_BIT3_MASK 0x8
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_BIT3__SHIFT 0x3
#define LCLK_DEEP_SLEEP_CNTL2__SCLK_RUNNING_MASK_MASK 0x10
#define LCLK_DEEP_SLEEP_CNTL2__SCLK_RUNNING_MASK__SHIFT 0x4
#define LCLK_DEEP_SLEEP_CNTL2__SMU_BUSY_MASK_MASK 0x20
#define LCLK_DEEP_SLEEP_CNTL2__SMU_BUSY_MASK__SHIFT 0x5
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE1_MASK_MASK 0x40
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE1_MASK__SHIFT 0x6
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE2_MASK_MASK 0x80
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE2_MASK__SHIFT 0x7
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE3_MASK_MASK 0x100
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE3_MASK__SHIFT 0x8
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE4_MASK_MASK 0x200
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE4_MASK__SHIFT 0x9
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPP_IDLE_MASK_MASK 0x400
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPP_IDLE_MASK__SHIFT 0xa
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPPSB_IDLE_MASK_MASK 0x800
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPPSB_IDLE_MASK__SHIFT 0xb
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUBIF_IDLE_MASK_MASK 0x1000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUBIF_IDLE_MASK__SHIFT 0xc
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUINTGEN_IDLE_MASK_MASK 0x2000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUINTGEN_IDLE_MASK__SHIFT 0xd
#define LCLK_DEEP_SLEEP_CNTL2__L2IMU_IDLE_MASK_MASK 0x4000
#define LCLK_DEEP_SLEEP_CNTL2__L2IMU_IDLE_MASK__SHIFT 0xe
#define LCLK_DEEP_SLEEP_CNTL2__ORB_IDLE_MASK_MASK 0x8000
#define LCLK_DEEP_SLEEP_CNTL2__ORB_IDLE_MASK__SHIFT 0xf
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_MASK_MASK 0x10000
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_MASK__SHIFT 0x10
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_ACK_MASK_MASK 0x20000
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_ACK_MASK__SHIFT 0x11
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_MASK_MASK 0x40000
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_MASK__SHIFT 0x12
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_ACK_MASK_MASK 0x80000
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_ACK_MASK__SHIFT 0x13
#define LCLK_DEEP_SLEEP_CNTL2__DMAACTIVE_MASK_MASK 0x100000
#define LCLK_DEEP_SLEEP_CNTL2__DMAACTIVE_MASK__SHIFT 0x14
#define LCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK_MASK 0x200000
#define LCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK__SHIFT 0x15
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_MASK 0xffc00000
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED__SHIFT 0x16
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDCI_INDEX_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDCI_INDEX__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDCI_INDEX_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDCI_INDEX__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_MVDD_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_MVDD_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_MVDD_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_MVDD_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDC_INDEX_MASK 0xf0000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDC_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDC_INDEX_MASK 0xf00000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDC_INDEX__SHIFT 0x14
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_PCIE_INDEX_MASK 0xf000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_PCIE_INDEX__SHIFT 0x18
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_PCIE_INDEX_MASK 0xf0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_PCIE_INDEX__SHIFT 0x1c
#define CG_ULV_PARAMETER__ULV_THRESHOLD_MASK 0xffff
#define CG_ULV_PARAMETER__ULV_THRESHOLD__SHIFT 0x0
#define CG_ULV_PARAMETER__ULV_THRESHOLD_UNIT_MASK 0xf0000
#define CG_ULV_PARAMETER__ULV_THRESHOLD_UNIT__SHIFT 0x10
#define SCLK_MIN_DIV__FRACV_MASK 0xfff
#define SCLK_MIN_DIV__FRACV__SHIFT 0x0
#define SCLK_MIN_DIV__INTV_MASK 0x7f000
#define SCLK_MIN_DIV__INTV__SHIFT 0xc
#define PWR_AVFS_SEL__AvfsSel_MASK 0xfffffff
#define PWR_AVFS_SEL__AvfsSel__SHIFT 0x0
#define PWR_AVFS_CNTL__MmBusIn_MASK 0xff
#define PWR_AVFS_CNTL__MmBusIn__SHIFT 0x0
#define PWR_AVFS_CNTL__MmLclRdEn_MASK 0x100
#define PWR_AVFS_CNTL__MmLclRdEn__SHIFT 0x8
#define PWR_AVFS_CNTL__MmLclWrEn_MASK 0x200
#define PWR_AVFS_CNTL__MmLclWrEn__SHIFT 0x9
#define PWR_AVFS_CNTL__MmLclSz_MASK 0xc00
#define PWR_AVFS_CNTL__MmLclSz__SHIFT 0xa
#define PWR_AVFS_CNTL__MmState_MASK 0x3f000
#define PWR_AVFS_CNTL__MmState__SHIFT 0xc
#define PWR_AVFS_CNTL__PsmScanMode_MASK 0x40000
#define PWR_AVFS_CNTL__PsmScanMode__SHIFT 0x12
#define PWR_AVFS_CNTL__PsmGater_MASK 0x80000
#define PWR_AVFS_CNTL__PsmGater__SHIFT 0x13
#define PWR_AVFS_CNTL__PsmTrst_MASK 0x100000
#define PWR_AVFS_CNTL__PsmTrst__SHIFT 0x14
#define PWR_AVFS_CNTL__PsmEn_MASK 0x200000
#define PWR_AVFS_CNTL__PsmEn__SHIFT 0x15
#define PWR_AVFS_CNTL__SkipPhaseEn_MASK 0x400000
#define PWR_AVFS_CNTL__SkipPhaseEn__SHIFT 0x16
#define PWR_AVFS_CNTL__Isolate_MASK 0x800000
#define PWR_AVFS_CNTL__Isolate__SHIFT 0x17
#define PWR_AVFS_CNTL__AvfsRst_MASK 0x1000000
#define PWR_AVFS_CNTL__AvfsRst__SHIFT 0x18
#define PWR_AVFS_CNTL__PccIsolateEn_MASK 0x2000000
#define PWR_AVFS_CNTL__PccIsolateEn__SHIFT 0x19
#define PWR_AVFS_CNTL__DeepSleepIsolateEn_MASK 0x4000000
#define PWR_AVFS_CNTL__DeepSleepIsolateEn__SHIFT 0x1a
#define PWR_AVFS0_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS0_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS0_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS0_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS0_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS0_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS1_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS1_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS1_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS1_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS1_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS1_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS2_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS2_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS2_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS2_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS2_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS2_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS3_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS3_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS3_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS3_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS3_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS3_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS4_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS4_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS4_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS4_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS4_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS4_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS5_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS5_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS5_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS5_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS5_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS5_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS6_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS6_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS6_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS6_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS6_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS6_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS7_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS7_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS7_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS7_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS7_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS7_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS8_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS8_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS8_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS8_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS8_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS8_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS9_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS9_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS9_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS9_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS9_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS9_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS10_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS10_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS10_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS10_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS10_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS10_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS11_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS11_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS11_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS11_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS11_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS11_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS12_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS12_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS12_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS12_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS12_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS12_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS13_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS13_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS13_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS13_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS13_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS13_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS14_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS14_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS14_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS14_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS14_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS14_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS15_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS15_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS15_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS15_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS15_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS15_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS16_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS16_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS16_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS16_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS16_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS16_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS17_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS17_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS17_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS17_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS17_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS17_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS18_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS18_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS18_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS18_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS18_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS18_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS19_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS19_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS19_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS19_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS19_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS19_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS20_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS20_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS20_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS20_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS20_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS20_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS21_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS21_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS21_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS21_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS21_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS21_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS22_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS22_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS22_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS22_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS22_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS22_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS23_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS23_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS23_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS23_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS23_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS23_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS24_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS24_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS24_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS24_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS24_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS24_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS25_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS25_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS25_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS25_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS25_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS25_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS26_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS26_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS26_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS26_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS26_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS26_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_AVFS27_CNTL_STATUS__MmDatOut_MASK 0xff
#define PWR_AVFS27_CNTL_STATUS__MmDatOut__SHIFT 0x0
#define PWR_AVFS27_CNTL_STATUS__PsmTdo_MASK 0x100
#define PWR_AVFS27_CNTL_STATUS__PsmTdo__SHIFT 0x8
#define PWR_AVFS27_CNTL_STATUS__AlarmFlag_MASK 0x200
#define PWR_AVFS27_CNTL_STATUS__AlarmFlag__SHIFT 0x9
#define PWR_CKS_ENABLE__STRETCH_ENABLE_MASK 0x1
#define PWR_CKS_ENABLE__STRETCH_ENABLE__SHIFT 0x0
#define PWR_CKS_ENABLE__masterReset_MASK 0x2
#define PWR_CKS_ENABLE__masterReset__SHIFT 0x1
#define PWR_CKS_ENABLE__staticEnable_MASK 0x4
#define PWR_CKS_ENABLE__staticEnable__SHIFT 0x2
#define PWR_CKS_ENABLE__IGNORE_DROOP_DETECT_MASK 0x8
#define PWR_CKS_ENABLE__IGNORE_DROOP_DETECT__SHIFT 0x3
#define PWR_CKS_ENABLE__PCC_HAND_SHAKE_EN_MASK 0x10
#define PWR_CKS_ENABLE__PCC_HAND_SHAKE_EN__SHIFT 0x4
#define PWR_CKS_ENABLE__MET_CTRL_SEL_MASK 0x60
#define PWR_CKS_ENABLE__MET_CTRL_SEL__SHIFT 0x5
#define PWR_CKS_ENABLE__DS_HAND_SHAKE_EN_MASK 0x80
#define PWR_CKS_ENABLE__DS_HAND_SHAKE_EN__SHIFT 0x7
#define PWR_CKS_CNTL__CKS_BYPASS_MASK 0x1
#define PWR_CKS_CNTL__CKS_BYPASS__SHIFT 0x0
#define PWR_CKS_CNTL__CKS_PCCEnable_MASK 0x2
#define PWR_CKS_CNTL__CKS_PCCEnable__SHIFT 0x1
#define PWR_CKS_CNTL__CKS_TEMP_COMP_MASK 0x4
#define PWR_CKS_CNTL__CKS_TEMP_COMP__SHIFT 0x2
#define PWR_CKS_CNTL__CKS_STRETCH_AMOUNT_MASK 0x78
#define PWR_CKS_CNTL__CKS_STRETCH_AMOUNT__SHIFT 0x3
#define PWR_CKS_CNTL__CKS_SKIP_PHASE_BYPASS_MASK 0x80
#define PWR_CKS_CNTL__CKS_SKIP_PHASE_BYPASS__SHIFT 0x7
#define PWR_CKS_CNTL__CKS_SAMPLE_SIZE_MASK 0xf00
#define PWR_CKS_CNTL__CKS_SAMPLE_SIZE__SHIFT 0x8
#define PWR_CKS_CNTL__CKS_FSM_WAIT_CYCLES_MASK 0xf000
#define PWR_CKS_CNTL__CKS_FSM_WAIT_CYCLES__SHIFT 0xc
#define PWR_CKS_CNTL__CKS_USE_FOR_LOW_FREQ_MASK 0x10000
#define PWR_CKS_CNTL__CKS_USE_FOR_LOW_FREQ__SHIFT 0x10
#define PWR_CKS_CNTL__CKS_NO_EXTRA_COARSE_STEP_MASK 0x20000
#define PWR_CKS_CNTL__CKS_NO_EXTRA_COARSE_STEP__SHIFT 0x11
#define PWR_CKS_CNTL__CKS_LDO_REFSEL_MASK 0x3c0000
#define PWR_CKS_CNTL__CKS_LDO_REFSEL__SHIFT 0x12
#define PWR_CKS_CNTL__DDT_DEBUS_SEL_MASK 0x400000
#define PWR_CKS_CNTL__DDT_DEBUS_SEL__SHIFT 0x16
#define PWR_CKS_CNTL__CKS_LDO_READY_COUNT_VAL_MASK 0x7f800000
#define PWR_CKS_CNTL__CKS_LDO_READY_COUNT_VAL__SHIFT 0x17
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_COUNT_MASK 0x1ffffff
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_COUNT__SHIFT 0x0
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_ENABLE_MASK 0x2000000
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_ENABLE__SHIFT 0x19
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_DISABLE_MASK 0x4000000
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_DISABLE__SHIFT 0x1a
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_MASK_MASK 0x8000000
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_MASK__SHIFT 0x1b
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_STAT_AK_MASK 0x10000000
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_STAT_AK__SHIFT 0x1c
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_TYPE_MASK 0x20000000
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_TYPE__SHIFT 0x1d
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_MODE_MASK 0x40000000
#define PWR_DISP_TIMER_CONTROL__DISP_TIMER_INT_MODE__SHIFT 0x1e
#define PWR_DISP_TIMER_DEBUG__DISP_TIMER_INT_RUNNING_MASK 0x1
#define PWR_DISP_TIMER_DEBUG__DISP_TIMER_INT_RUNNING__SHIFT 0x0
#define PWR_DISP_TIMER_DEBUG__DISP_TIMER_INT_STAT_MASK 0x2
#define PWR_DISP_TIMER_DEBUG__DISP_TIMER_INT_STAT__SHIFT 0x1
#define PWR_DISP_TIMER_DEBUG__DISP_TIMER_INT_MASK 0x4
#define PWR_DISP_TIMER_DEBUG__DISP_TIMER_INT__SHIFT 0x2
#define PWR_DISP_TIMER_DEBUG__DISP_TIMER_RUN_VAL_MASK 0xffffff80
#define PWR_DISP_TIMER_DEBUG__DISP_TIMER_RUN_VAL__SHIFT 0x7
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_COUNT_MASK 0x1ffffff
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_COUNT__SHIFT 0x0
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_ENABLE_MASK 0x2000000
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_ENABLE__SHIFT 0x19
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_DISABLE_MASK 0x4000000
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_DISABLE__SHIFT 0x1a
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_MASK_MASK 0x8000000
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_MASK__SHIFT 0x1b
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_STAT_AK_MASK 0x10000000
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_STAT_AK__SHIFT 0x1c
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_TYPE_MASK 0x20000000
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_TYPE__SHIFT 0x1d
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_MODE_MASK 0x40000000
#define PWR_DISP_TIMER2_CONTROL__DISP_TIMER_INT_MODE__SHIFT 0x1e
#define PWR_DISP_TIMER2_DEBUG__DISP_TIMER_INT_RUNNING_MASK 0x1
#define PWR_DISP_TIMER2_DEBUG__DISP_TIMER_INT_RUNNING__SHIFT 0x0
#define PWR_DISP_TIMER2_DEBUG__DISP_TIMER_INT_STAT_MASK 0x2
#define PWR_DISP_TIMER2_DEBUG__DISP_TIMER_INT_STAT__SHIFT 0x1
#define PWR_DISP_TIMER2_DEBUG__DISP_TIMER_INT_MASK 0x4
#define PWR_DISP_TIMER2_DEBUG__DISP_TIMER_INT__SHIFT 0x2
#define PWR_DISP_TIMER2_DEBUG__DISP_TIMER_RUN_VAL_MASK 0xffffff80
#define PWR_DISP_TIMER2_DEBUG__DISP_TIMER_RUN_VAL__SHIFT 0x7
#define PWR_DISP_TIMER_CONTROL2__DISP_TIMER_PULSE_WIDTH_MASK 0x3ff
#define PWR_DISP_TIMER_CONTROL2__DISP_TIMER_PULSE_WIDTH__SHIFT 0x0
#define VDDGFX_IDLE_PARAMETER__VDDGFX_IDLE_THRESHOLD_MASK 0xffff
#define VDDGFX_IDLE_PARAMETER__VDDGFX_IDLE_THRESHOLD__SHIFT 0x0
#define VDDGFX_IDLE_PARAMETER__VDDGFX_IDLE_THRESHOLD_UNIT_MASK 0xf0000
#define VDDGFX_IDLE_PARAMETER__VDDGFX_IDLE_THRESHOLD_UNIT__SHIFT 0x10
#define VDDGFX_IDLE_CONTROL__VDDGFX_IDLE_EN_MASK 0x1
#define VDDGFX_IDLE_CONTROL__VDDGFX_IDLE_EN__SHIFT 0x0
#define VDDGFX_IDLE_CONTROL__VDDGFX_IDLE_DETECT_MASK 0x2
#define VDDGFX_IDLE_CONTROL__VDDGFX_IDLE_DETECT__SHIFT 0x1
#define VDDGFX_IDLE_CONTROL__FORCE_VDDGFX_IDLE_EXIT_MASK 0x4
#define VDDGFX_IDLE_CONTROL__FORCE_VDDGFX_IDLE_EXIT__SHIFT 0x2
#define VDDGFX_IDLE_CONTROL__SMC_VDDGFX_IDLE_STATE_MASK 0x8
#define VDDGFX_IDLE_CONTROL__SMC_VDDGFX_IDLE_STATE__SHIFT 0x3
#define VDDGFX_IDLE_EXIT__BIF_EXIT_REQ_MASK 0x1
#define VDDGFX_IDLE_EXIT__BIF_EXIT_REQ__SHIFT 0x0
#define LCAC_MC0_CNTL__MC0_ENABLE_MASK 0x1
#define LCAC_MC0_CNTL__MC0_ENABLE__SHIFT 0x0
#define LCAC_MC0_CNTL__MC0_THRESHOLD_MASK 0x1fffe
#define LCAC_MC0_CNTL__MC0_THRESHOLD__SHIFT 0x1
#define LCAC_MC0_CNTL__MC0_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC0_CNTL__MC0_BLOCK_ID__SHIFT 0x11
#define LCAC_MC0_CNTL__MC0_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC0_CNTL__MC0_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC0_OVR_SEL__MC0_OVR_SEL_MASK 0xffffffff
#define LCAC_MC0_OVR_SEL__MC0_OVR_SEL__SHIFT 0x0
#define LCAC_MC0_OVR_VAL__MC0_OVR_VAL_MASK 0xffffffff
#define LCAC_MC0_OVR_VAL__MC0_OVR_VAL__SHIFT 0x0
#define LCAC_MC1_CNTL__MC1_ENABLE_MASK 0x1
#define LCAC_MC1_CNTL__MC1_ENABLE__SHIFT 0x0
#define LCAC_MC1_CNTL__MC1_THRESHOLD_MASK 0x1fffe
#define LCAC_MC1_CNTL__MC1_THRESHOLD__SHIFT 0x1
#define LCAC_MC1_CNTL__MC1_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC1_CNTL__MC1_BLOCK_ID__SHIFT 0x11
#define LCAC_MC1_CNTL__MC1_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC1_CNTL__MC1_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC1_OVR_SEL__MC1_OVR_SEL_MASK 0xffffffff
#define LCAC_MC1_OVR_SEL__MC1_OVR_SEL__SHIFT 0x0
#define LCAC_MC1_OVR_VAL__MC1_OVR_VAL_MASK 0xffffffff
#define LCAC_MC1_OVR_VAL__MC1_OVR_VAL__SHIFT 0x0
#define LCAC_MC2_CNTL__MC2_ENABLE_MASK 0x1
#define LCAC_MC2_CNTL__MC2_ENABLE__SHIFT 0x0
#define LCAC_MC2_CNTL__MC2_THRESHOLD_MASK 0x1fffe
#define LCAC_MC2_CNTL__MC2_THRESHOLD__SHIFT 0x1
#define LCAC_MC2_CNTL__MC2_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC2_CNTL__MC2_BLOCK_ID__SHIFT 0x11
#define LCAC_MC2_CNTL__MC2_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC2_CNTL__MC2_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC2_OVR_SEL__MC2_OVR_SEL_MASK 0xffffffff
#define LCAC_MC2_OVR_SEL__MC2_OVR_SEL__SHIFT 0x0
#define LCAC_MC2_OVR_VAL__MC2_OVR_VAL_MASK 0xffffffff
#define LCAC_MC2_OVR_VAL__MC2_OVR_VAL__SHIFT 0x0
#define LCAC_MC3_CNTL__MC3_ENABLE_MASK 0x1
#define LCAC_MC3_CNTL__MC3_ENABLE__SHIFT 0x0
#define LCAC_MC3_CNTL__MC3_THRESHOLD_MASK 0x1fffe
#define LCAC_MC3_CNTL__MC3_THRESHOLD__SHIFT 0x1
#define LCAC_MC3_CNTL__MC3_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC3_CNTL__MC3_BLOCK_ID__SHIFT 0x11
#define LCAC_MC3_CNTL__MC3_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC3_CNTL__MC3_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC3_OVR_SEL__MC3_OVR_SEL_MASK 0xffffffff
#define LCAC_MC3_OVR_SEL__MC3_OVR_SEL__SHIFT 0x0
#define LCAC_MC3_OVR_VAL__MC3_OVR_VAL_MASK 0xffffffff
#define LCAC_MC3_OVR_VAL__MC3_OVR_VAL__SHIFT 0x0
#define LCAC_MC4_CNTL__MC4_ENABLE_MASK 0x1
#define LCAC_MC4_CNTL__MC4_ENABLE__SHIFT 0x0
#define LCAC_MC4_CNTL__MC4_THRESHOLD_MASK 0x1fffe
#define LCAC_MC4_CNTL__MC4_THRESHOLD__SHIFT 0x1
#define LCAC_MC4_CNTL__MC4_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC4_CNTL__MC4_BLOCK_ID__SHIFT 0x11
#define LCAC_MC4_CNTL__MC4_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC4_CNTL__MC4_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC4_OVR_SEL__MC4_OVR_SEL_MASK 0xffffffff
#define LCAC_MC4_OVR_SEL__MC4_OVR_SEL__SHIFT 0x0
#define LCAC_MC4_OVR_VAL__MC4_OVR_VAL_MASK 0xffffffff
#define LCAC_MC4_OVR_VAL__MC4_OVR_VAL__SHIFT 0x0
#define LCAC_MC5_CNTL__MC5_ENABLE_MASK 0x1
#define LCAC_MC5_CNTL__MC5_ENABLE__SHIFT 0x0
#define LCAC_MC5_CNTL__MC5_THRESHOLD_MASK 0x1fffe
#define LCAC_MC5_CNTL__MC5_THRESHOLD__SHIFT 0x1
#define LCAC_MC5_CNTL__MC5_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC5_CNTL__MC5_BLOCK_ID__SHIFT 0x11
#define LCAC_MC5_CNTL__MC5_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC5_CNTL__MC5_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC5_OVR_SEL__MC5_OVR_SEL_MASK 0xffffffff
#define LCAC_MC5_OVR_SEL__MC5_OVR_SEL__SHIFT 0x0
#define LCAC_MC5_OVR_VAL__MC5_OVR_VAL_MASK 0xffffffff
#define LCAC_MC5_OVR_VAL__MC5_OVR_VAL__SHIFT 0x0
#define LCAC_MC6_CNTL__MC6_ENABLE_MASK 0x1
#define LCAC_MC6_CNTL__MC6_ENABLE__SHIFT 0x0
#define LCAC_MC6_CNTL__MC6_THRESHOLD_MASK 0x1fffe
#define LCAC_MC6_CNTL__MC6_THRESHOLD__SHIFT 0x1
#define LCAC_MC6_CNTL__MC6_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC6_CNTL__MC6_BLOCK_ID__SHIFT 0x11
#define LCAC_MC6_CNTL__MC6_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC6_CNTL__MC6_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC6_OVR_SEL__MC6_OVR_SEL_MASK 0xffffffff
#define LCAC_MC6_OVR_SEL__MC6_OVR_SEL__SHIFT 0x0
#define LCAC_MC6_OVR_VAL__MC6_OVR_VAL_MASK 0xffffffff
#define LCAC_MC6_OVR_VAL__MC6_OVR_VAL__SHIFT 0x0
#define LCAC_MC7_CNTL__MC7_ENABLE_MASK 0x1
#define LCAC_MC7_CNTL__MC7_ENABLE__SHIFT 0x0
#define LCAC_MC7_CNTL__MC7_THRESHOLD_MASK 0x1fffe
#define LCAC_MC7_CNTL__MC7_THRESHOLD__SHIFT 0x1
#define LCAC_MC7_CNTL__MC7_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC7_CNTL__MC7_BLOCK_ID__SHIFT 0x11
#define LCAC_MC7_CNTL__MC7_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC7_CNTL__MC7_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC7_OVR_SEL__MC7_OVR_SEL_MASK 0xffffffff
#define LCAC_MC7_OVR_SEL__MC7_OVR_SEL__SHIFT 0x0
#define LCAC_MC7_OVR_VAL__MC7_OVR_VAL_MASK 0xffffffff
#define LCAC_MC7_OVR_VAL__MC7_OVR_VAL__SHIFT 0x0
#define LCAC_CPL_CNTL__CPL_ENABLE_MASK 0x1
#define LCAC_CPL_CNTL__CPL_ENABLE__SHIFT 0x0
#define LCAC_CPL_CNTL__CPL_THRESHOLD_MASK 0x1fffe
#define LCAC_CPL_CNTL__CPL_THRESHOLD__SHIFT 0x1
#define LCAC_CPL_CNTL__CPL_BLOCK_ID_MASK 0x3e0000
#define LCAC_CPL_CNTL__CPL_BLOCK_ID__SHIFT 0x11
#define LCAC_CPL_CNTL__CPL_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_CPL_CNTL__CPL_SIGNAL_ID__SHIFT 0x16
#define LCAC_CPL_OVR_SEL__CPL_OVR_SEL_MASK 0xffffffff
#define LCAC_CPL_OVR_SEL__CPL_OVR_SEL__SHIFT 0x0
#define LCAC_CPL_OVR_VAL__CPL_OVR_VAL_MASK 0xffffffff
#define LCAC_CPL_OVR_VAL__CPL_OVR_VAL__SHIFT 0x0
#define ROM_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define ROM_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define ROM_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define ROM_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define ROM_CNTL__SCK_OVERWRITE_MASK 0x2
#define ROM_CNTL__SCK_OVERWRITE__SHIFT 0x1
#define ROM_CNTL__CLOCK_GATING_EN_MASK 0x4
#define ROM_CNTL__CLOCK_GATING_EN__SHIFT 0x2
#define ROM_CNTL__CSB_ACTIVE_TO_SCK_SETUP_TIME_MASK 0xff00
#define ROM_CNTL__CSB_ACTIVE_TO_SCK_SETUP_TIME__SHIFT 0x8
#define ROM_CNTL__CSB_ACTIVE_TO_SCK_HOLD_TIME_MASK 0xff0000
#define ROM_CNTL__CSB_ACTIVE_TO_SCK_HOLD_TIME__SHIFT 0x10
#define ROM_CNTL__SCK_PRESCALE_REFCLK_MASK 0xf000000
#define ROM_CNTL__SCK_PRESCALE_REFCLK__SHIFT 0x18
#define ROM_CNTL__SCK_PRESCALE_CRYSTAL_CLK_MASK 0xf0000000
#define ROM_CNTL__SCK_PRESCALE_CRYSTAL_CLK__SHIFT 0x1c
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_BASE_ADDR_MASK 0xffffff
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_BASE_ADDR__SHIFT 0x0
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_INVALIDATE_MASK 0x1000000
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_INVALIDATE__SHIFT 0x18
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_ENABLE_MASK 0x2000000
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_ENABLE__SHIFT 0x19
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_USAGE_MASK 0xc000000
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_USAGE__SHIFT 0x1a
#define ROM_STATUS__ROM_BUSY_MASK 0x1
#define ROM_STATUS__ROM_BUSY__SHIFT 0x0
#define CGTT_ROM_CLK_CTRL0__ON_DELAY_MASK 0xf
#define CGTT_ROM_CLK_CTRL0__ON_DELAY__SHIFT 0x0
#define CGTT_ROM_CLK_CTRL0__OFF_HYSTERESIS_MASK 0xff0
#define CGTT_ROM_CLK_CTRL0__OFF_HYSTERESIS__SHIFT 0x4
#define CGTT_ROM_CLK_CTRL0__SOFT_OVERRIDE1_MASK 0x40000000
#define CGTT_ROM_CLK_CTRL0__SOFT_OVERRIDE1__SHIFT 0x1e
#define CGTT_ROM_CLK_CTRL0__SOFT_OVERRIDE0_MASK 0x80000000
#define CGTT_ROM_CLK_CTRL0__SOFT_OVERRIDE0__SHIFT 0x1f
#define ROM_INDEX__ROM_INDEX_MASK 0xffffff
#define ROM_INDEX__ROM_INDEX__SHIFT 0x0
#define ROM_DATA__ROM_DATA_MASK 0xffffffff
#define ROM_DATA__ROM_DATA__SHIFT 0x0
#define ROM_START__ROM_START_MASK 0xffffff
#define ROM_START__ROM_START__SHIFT 0x0
#define ROM_SW_CNTL__DATA_SIZE_MASK 0xffff
#define ROM_SW_CNTL__DATA_SIZE__SHIFT 0x0
#define ROM_SW_CNTL__COMMAND_SIZE_MASK 0x30000
#define ROM_SW_CNTL__COMMAND_SIZE__SHIFT 0x10
#define ROM_SW_CNTL__ROM_SW_RETURN_DATA_ENABLE_MASK 0x40000
#define ROM_SW_CNTL__ROM_SW_RETURN_DATA_ENABLE__SHIFT 0x12
#define ROM_SW_STATUS__ROM_SW_DONE_MASK 0x1
#define ROM_SW_STATUS__ROM_SW_DONE__SHIFT 0x0
#define ROM_SW_COMMAND__ROM_SW_INSTRUCTION_MASK 0xff
#define ROM_SW_COMMAND__ROM_SW_INSTRUCTION__SHIFT 0x0
#define ROM_SW_COMMAND__ROM_SW_ADDRESS_MASK 0xffffff00
#define ROM_SW_COMMAND__ROM_SW_ADDRESS__SHIFT 0x8
#define ROM_SW_DATA_1__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_1__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_2__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_2__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_3__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_3__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_4__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_4__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_5__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_5__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_6__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_6__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_7__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_7__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_8__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_8__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_9__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_9__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_10__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_10__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_11__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_11__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_12__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_12__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_13__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_13__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_14__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_14__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_15__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_15__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_16__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_16__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_17__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_17__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_18__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_18__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_19__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_19__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_20__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_20__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_21__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_21__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_22__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_22__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_23__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_23__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_24__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_24__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_25__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_25__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_26__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_26__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_27__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_27__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_28__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_28__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_29__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_29__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_30__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_30__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_31__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_31__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_32__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_32__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_33__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_33__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_34__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_34__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_35__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_35__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_36__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_36__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_37__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_37__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_38__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_38__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_39__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_39__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_40__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_40__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_41__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_41__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_42__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_42__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_43__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_43__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_44__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_44__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_45__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_45__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_46__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_46__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_47__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_47__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_48__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_48__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_49__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_49__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_50__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_50__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_51__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_51__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_52__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_52__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_53__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_53__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_54__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_54__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_55__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_55__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_56__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_56__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_57__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_57__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_58__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_58__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_59__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_59__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_60__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_60__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_61__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_61__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_62__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_62__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_63__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_63__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_64__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_64__ROM_SW_DATA__SHIFT 0x0
#define GC_CAC_CGTT_CLK_CTRL__ON_DELAY_MASK 0xf
#define GC_CAC_CGTT_CLK_CTRL__ON_DELAY__SHIFT 0x0
#define GC_CAC_CGTT_CLK_CTRL__OFF_HYSTERESIS_MASK 0xff0
#define GC_CAC_CGTT_CLK_CTRL__OFF_HYSTERESIS__SHIFT 0x4
#define GC_CAC_CGTT_CLK_CTRL__SOFT_OVERRIDE_DYN_MASK 0x40000000
#define GC_CAC_CGTT_CLK_CTRL__SOFT_OVERRIDE_DYN__SHIFT 0x1e
#define GC_CAC_CGTT_CLK_CTRL__SOFT_OVERRIDE_REG_MASK 0x80000000
#define GC_CAC_CGTT_CLK_CTRL__SOFT_OVERRIDE_REG__SHIFT 0x1f
#define SE_CAC_CGTT_CLK_CTRL__ON_DELAY_MASK 0xf
#define SE_CAC_CGTT_CLK_CTRL__ON_DELAY__SHIFT 0x0
#define SE_CAC_CGTT_CLK_CTRL__OFF_HYSTERESIS_MASK 0xff0
#define SE_CAC_CGTT_CLK_CTRL__OFF_HYSTERESIS__SHIFT 0x4
#define SE_CAC_CGTT_CLK_CTRL__SOFT_OVERRIDE_DYN_MASK 0x40000000
#define SE_CAC_CGTT_CLK_CTRL__SOFT_OVERRIDE_DYN__SHIFT 0x1e
#define SE_CAC_CGTT_CLK_CTRL__SOFT_OVERRIDE_REG_MASK 0x80000000
#define SE_CAC_CGTT_CLK_CTRL__SOFT_OVERRIDE_REG__SHIFT 0x1f
#define GC_CAC_LKG_AGGR_LOWER__LKG_AGGR_31_0_MASK 0xffffffff
#define GC_CAC_LKG_AGGR_LOWER__LKG_AGGR_31_0__SHIFT 0x0
#define GC_CAC_LKG_AGGR_UPPER__LKG_AGGR_63_32_MASK 0xffffffff
#define GC_CAC_LKG_AGGR_UPPER__LKG_AGGR_63_32__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_0__WEIGHT_CU_SIG0_MASK 0xffff
#define GC_CAC_WEIGHT_CU_0__WEIGHT_CU_SIG0__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_0__WEIGHT_CU_SIG1_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_0__WEIGHT_CU_SIG1__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_1__WEIGHT_CU_SIG2_MASK 0xffff
#define GC_CAC_WEIGHT_CU_1__WEIGHT_CU_SIG2__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_1__WEIGHT_CU_SIG3_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_1__WEIGHT_CU_SIG3__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_2__WEIGHT_CU_SIG4_MASK 0xffff
#define GC_CAC_WEIGHT_CU_2__WEIGHT_CU_SIG4__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_2__WEIGHT_CU_SIG5_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_2__WEIGHT_CU_SIG5__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_3__WEIGHT_CU_SIG6_MASK 0xffff
#define GC_CAC_WEIGHT_CU_3__WEIGHT_CU_SIG6__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_3__WEIGHT_CU_SIG7_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_3__WEIGHT_CU_SIG7__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_4__WEIGHT_CU_SIG8_MASK 0xffff
#define GC_CAC_WEIGHT_CU_4__WEIGHT_CU_SIG8__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_4__WEIGHT_CU_SIG9_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_4__WEIGHT_CU_SIG9__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_5__WEIGHT_CU_SIG10_MASK 0xffff
#define GC_CAC_WEIGHT_CU_5__WEIGHT_CU_SIG10__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_5__WEIGHT_CU_SIG11_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_5__WEIGHT_CU_SIG11__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_6__WEIGHT_CU_SIG12_MASK 0xffff
#define GC_CAC_WEIGHT_CU_6__WEIGHT_CU_SIG12__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_6__WEIGHT_CU_SIG13_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_6__WEIGHT_CU_SIG13__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_7__WEIGHT_CU_SIG14_MASK 0xffff
#define GC_CAC_WEIGHT_CU_7__WEIGHT_CU_SIG14__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_7__WEIGHT_CU_SIG15_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_7__WEIGHT_CU_SIG15__SHIFT 0x10
#define GC_CAC_ACC_CU0__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU0__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU1__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU1__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU2__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU2__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU3__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU3__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU4__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU4__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU5__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU5__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU6__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU6__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU7__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU7__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU8__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU8__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU9__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU9__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU10__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU10__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU11__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU11__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU12__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU12__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU13__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU13__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU14__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU14__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU15__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU15__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_OVRD_CU__OVRRD_SELECT_MASK 0xffff
#define GC_CAC_OVRD_CU__OVRRD_SELECT__SHIFT 0x0
#define GC_CAC_OVRD_CU__OVRRD_VALUE_MASK 0xffff0000
#define GC_CAC_OVRD_CU__OVRRD_VALUE__SHIFT 0x10

#endif /* SMU_7_1_3_SH_MASK_H */
