.TH XvGetStill __libmansuffix__  __vendorversion__ "libXv Functions"
.SH NAME
XvGetStill \- capture a single frame of video from a drawable
.\"
.SH SYNOPSIS
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "int XvGetStill(Display *" dpy ", XvPortID " port ", Drawable " d ", GC " gc ","
.BI "               int " vx ", int " vy ", unsigned int " vw ", unsigned int " vh ","
.BI "               int " dx ", int " dy ", unsigned int " dw ", unsigned int " dh ");"
.fi
.SH ARGUMENTS
.\"
.IP \fIdpy\fR 15
Specifies the connection to the X server.
.IP \fIport\fR 15
Defines the port to which the still is output.
.IP \fId\fR 15
Defines the drawable from which the still is to be captured.
Pixmaps are currently not supported.
.IP \fIgc\fR 15
Defines the graphical context.  GC components are:
.IR subwindow-mode ,
.IR clip-x-origin ,
.IR clip-y-origin ,
and
.IR clip-mask .
.IP \fIvx,vy,vw,vh\fR 15
Define the location and size of the destination video region
into which the still is to be written.  \fIvx\fP and \fIvy\fP define the
.IR x and
.I y
coordinates of the upper-left corner of the video region;
.IR vw and
.I vh
define the width and height, in pixels, of the video region.
.IP \fIdx,dy,dw,dh\fR 15
Define the location and size of the source drawable from which the
still image is to be captured.
.IR dx and
.I dy
define the
.IR x and
.I y
coordinates of the upper-left corner of the drawable region;
.IR dw and
.I dh
define the width and height, in pixels, of the drawable region.
.\"
.SH DESCRIPTION
.\"
.PN XvGetStill
captures a single frame of video from a drawable.  The
position and size of the destination (video) rectangle is specified by
.IR vx ,
.IR vy ,
.IR vw ,
and
.IR vh .
The position and size of the source (drawable) rectangle is specified by
.IR dx ,
.IR dy ,
.IR dw ,
and
.IR dh .
.PP
Drawable data is clipped to the bounds of the drawable, scaled to the
requested video region size (or the closest size supported) and
clipped to the bounds of the video encoding.  The contents of any region
not updated with drawable data is undefined.
.PP
.\" If the still is successfully captured an XvVideoNotify event with
.\" detail XvStill is generated for the drawable.
.\" [mhs]: Not in this universe
If the port is grabbed
by another client, this request is ignored, and an XvVideoNotify event
with detail XvBusy is generated for the drawable.
.SH RETURN VALUES
.IP [Success] 8
Returned if
.BR XvGetStill (__libmansuffix__)
completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if
.BR XvGetStill (__libmansuffix__)
failed to allocate memory to process the request.
.SH DIAGNOSTICS
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadDrawable] 8
Generated if the requested drawable does not exist.
.IP [BadGC] 8
Generated if the requested graphics context does not exist.
.IP [BadAlloc] 8
Generated if there were insufficient resources to process the request.
.\"
.SH SEE ALSO
.\"
.BR XvPutStill (__libmansuffix__),
.BR XvGetVideo (__libmansuffix__),
.BR XvPutVideo (__libmansuffix__),
.BR XvVideoNotify (__libmansuffix__)

