/* enchant-lsmod.c generated by valac 0.56.18, the Vala compiler
 * generated from enchant-lsmod.vala, do not modify */

/* enchant
 * Copyright (C) 2003 Dom Lachowicz
 * Copyright (C) 2017-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * the non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers. If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <enchant.h>
#include <stdio.h>
#include <util.h>
#include <config.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _enchant_broker_free0(var) ((var == NULL) ? NULL : (var = (enchant_broker_free (var), NULL)))

VALA_EXTERN void describe_dict (const gchar* lang_tag,
                    const gchar* provider_name,
                    const gchar* provider_desc,
                    const gchar* provider_file);
VALA_EXTERN void describe_word_chars (const gchar* lang_tag,
                          const gchar* provider_name,
                          const gchar* provider_desc,
                          const gchar* provider_file,
                          EnchantDict* _self_);
VALA_EXTERN void describe_provider (const gchar* name,
                        const gchar* desc,
                        const gchar* file);
VALA_EXTERN void usage (const gchar* progname);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _describe_dict_enchant_dict_describe_fn (const gchar* lang_tag,
                                              const gchar* provider_name,
                                              const gchar* provider_desc,
                                              const gchar* provider_file,
                                              void* user_data);
static void _describe_word_chars_enchant_dict_describe_fn (const gchar* lang_tag,
                                                    const gchar* provider_name,
                                                    const gchar* provider_desc,
                                                    const gchar* provider_file,
                                                    void* user_data);
static void _describe_provider_enchant_broker_describe_fn (const gchar* provider_name,
                                                    const gchar* provider_desc,
                                                    const gchar* provider_dll_file,
                                                    void* user_data);

void
describe_dict (const gchar* lang_tag,
               const gchar* provider_name,
               const gchar* provider_desc,
               const gchar* provider_file)
{
#line 32 "enchant-lsmod.vala"
	g_return_if_fail (lang_tag != NULL);
#line 32 "enchant-lsmod.vala"
	g_return_if_fail (provider_name != NULL);
#line 32 "enchant-lsmod.vala"
	g_return_if_fail (provider_desc != NULL);
#line 32 "enchant-lsmod.vala"
	g_return_if_fail (provider_file != NULL);
#line 36 "enchant-lsmod.vala"
	g_print ("%s (%s)\n", lang_tag, provider_name);
#line 109 "enchant-lsmod.c"
}

void
describe_word_chars (const gchar* lang_tag,
                     const gchar* provider_name,
                     const gchar* provider_desc,
                     const gchar* provider_file,
                     EnchantDict* _self_)
{
	gchar* word_chars = NULL;
	gchar* _tmp0_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
#line 39 "enchant-lsmod.vala"
	g_return_if_fail (lang_tag != NULL);
#line 39 "enchant-lsmod.vala"
	g_return_if_fail (provider_name != NULL);
#line 39 "enchant-lsmod.vala"
	g_return_if_fail (provider_desc != NULL);
#line 39 "enchant-lsmod.vala"
	g_return_if_fail (provider_file != NULL);
#line 39 "enchant-lsmod.vala"
	g_return_if_fail (_self_ != NULL);
#line 44 "enchant-lsmod.vala"
	_tmp0_ = g_strdup ("");
#line 44 "enchant-lsmod.vala"
	word_chars = _tmp0_;
#line 45 "enchant-lsmod.vala"
	if (_self_ != NULL) {
#line 139 "enchant-lsmod.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 46 "enchant-lsmod.vala"
		_tmp1_ = enchant_dict_get_extra_word_characters (_self_);
#line 46 "enchant-lsmod.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 46 "enchant-lsmod.vala"
		_g_free0 (word_chars);
#line 46 "enchant-lsmod.vala"
		word_chars = _tmp2_;
#line 150 "enchant-lsmod.c"
	}
#line 47 "enchant-lsmod.vala"
	_tmp4_ = word_chars;
#line 47 "enchant-lsmod.vala"
	if (_tmp4_ != NULL) {
#line 156 "enchant-lsmod.c"
		const gchar* _tmp5_;
#line 47 "enchant-lsmod.vala"
		_tmp5_ = word_chars;
#line 47 "enchant-lsmod.vala"
		_tmp3_ = _tmp5_;
#line 162 "enchant-lsmod.c"
	} else {
#line 47 "enchant-lsmod.vala"
		_tmp3_ = "";
#line 166 "enchant-lsmod.c"
	}
#line 47 "enchant-lsmod.vala"
	g_print ("%s\n", _tmp3_);
#line 39 "enchant-lsmod.vala"
	_g_free0 (word_chars);
#line 172 "enchant-lsmod.c"
}

void
describe_provider (const gchar* name,
                   const gchar* desc,
                   const gchar* file)
{
#line 50 "enchant-lsmod.vala"
	g_return_if_fail (name != NULL);
#line 50 "enchant-lsmod.vala"
	g_return_if_fail (desc != NULL);
#line 50 "enchant-lsmod.vala"
	g_return_if_fail (file != NULL);
#line 51 "enchant-lsmod.vala"
	g_print ("%s (%s)\n", name, desc);
#line 188 "enchant-lsmod.c"
}

void
usage (const gchar* progname)
{
	FILE* _tmp0_;
#line 54 "enchant-lsmod.vala"
	g_return_if_fail (progname != NULL);
#line 55 "enchant-lsmod.vala"
	_tmp0_ = stderr;
#line 55 "enchant-lsmod.vala"
	fprintf (_tmp0_, "%s [[-lang|-word-chars] [language_tag]|-list-dicts|-help|-version]\n", progname);
#line 201 "enchant-lsmod.c"
}

static void
_describe_dict_enchant_dict_describe_fn (const gchar* lang_tag,
                                         const gchar* provider_name,
                                         const gchar* provider_desc,
                                         const gchar* provider_file,
                                         void* user_data)
{
#line 87 "enchant-lsmod.vala"
	describe_dict (lang_tag, provider_name, provider_desc, provider_file);
#line 213 "enchant-lsmod.c"
}

static void
_describe_word_chars_enchant_dict_describe_fn (const gchar* lang_tag,
                                               const gchar* provider_name,
                                               const gchar* provider_desc,
                                               const gchar* provider_file,
                                               void* user_data)
{
#line 89 "enchant-lsmod.vala"
	describe_word_chars (lang_tag, provider_name, provider_desc, provider_file, user_data);
#line 225 "enchant-lsmod.c"
}

static void
_describe_provider_enchant_broker_describe_fn (const gchar* provider_name,
                                               const gchar* provider_desc,
                                               const gchar* provider_dll_file,
                                               void* user_data)
{
#line 105 "enchant-lsmod.vala"
	describe_provider (provider_name, provider_desc, provider_dll_file);
#line 236 "enchant-lsmod.c"
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	EnchantBroker* broker = NULL;
	EnchantBroker* _tmp0_;
	gchar* lang_tag = NULL;
	gint retcode = 0;
	gint result;
#line 59 "enchant-lsmod.vala"
	_tmp0_ = enchant_broker_init ();
#line 59 "enchant-lsmod.vala"
	broker = _tmp0_;
#line 60 "enchant-lsmod.vala"
	lang_tag = NULL;
#line 61 "enchant-lsmod.vala"
	retcode = 0;
#line 63 "enchant-lsmod.vala"
	if (args_length1 > 1) {
#line 258 "enchant-lsmod.c"
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
#line 64 "enchant-lsmod.vala"
		_tmp2_ = args[1];
#line 64 "enchant-lsmod.vala"
		if (g_strcmp0 (_tmp2_, "-lang") == 0) {
#line 64 "enchant-lsmod.vala"
			_tmp1_ = TRUE;
#line 267 "enchant-lsmod.c"
		} else {
			const gchar* _tmp3_;
#line 64 "enchant-lsmod.vala"
			_tmp3_ = args[1];
#line 64 "enchant-lsmod.vala"
			_tmp1_ = g_strcmp0 (_tmp3_, "-word-chars") == 0;
#line 274 "enchant-lsmod.c"
		}
#line 64 "enchant-lsmod.vala"
		if (_tmp1_) {
#line 278 "enchant-lsmod.c"
			const gchar* _tmp11_;
#line 65 "enchant-lsmod.vala"
			if (args_length1 > 2) {
#line 282 "enchant-lsmod.c"
				const gchar* _tmp4_;
				gchar* _tmp5_;
#line 66 "enchant-lsmod.vala"
				_tmp4_ = args[2];
#line 66 "enchant-lsmod.vala"
				_tmp5_ = g_strdup (_tmp4_);
#line 66 "enchant-lsmod.vala"
				_g_free0 (lang_tag);
#line 66 "enchant-lsmod.vala"
				lang_tag = _tmp5_;
#line 293 "enchant-lsmod.c"
			} else {
				gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				const gchar* _tmp8_;
#line 68 "enchant-lsmod.vala"
				_tmp6_ = enchant_get_user_language ();
#line 68 "enchant-lsmod.vala"
				_g_free0 (lang_tag);
#line 68 "enchant-lsmod.vala"
				lang_tag = _tmp6_;
#line 69 "enchant-lsmod.vala"
				_tmp8_ = lang_tag;
#line 69 "enchant-lsmod.vala"
				if (_tmp8_ == NULL) {
#line 69 "enchant-lsmod.vala"
					_tmp7_ = TRUE;
#line 310 "enchant-lsmod.c"
				} else {
					const gchar* _tmp9_;
#line 69 "enchant-lsmod.vala"
					_tmp9_ = lang_tag;
#line 69 "enchant-lsmod.vala"
					_tmp7_ = g_strcmp0 (_tmp9_, "C") == 0;
#line 317 "enchant-lsmod.c"
				}
#line 69 "enchant-lsmod.vala"
				if (_tmp7_) {
#line 321 "enchant-lsmod.c"
					gchar* _tmp10_;
#line 70 "enchant-lsmod.vala"
					_tmp10_ = g_strdup ("en");
#line 70 "enchant-lsmod.vala"
					_g_free0 (lang_tag);
#line 70 "enchant-lsmod.vala"
					lang_tag = _tmp10_;
#line 329 "enchant-lsmod.c"
				}
			}
#line 72 "enchant-lsmod.vala"
			_tmp11_ = lang_tag;
#line 72 "enchant-lsmod.vala"
			if (_tmp11_ == NULL) {
#line 336 "enchant-lsmod.c"
				FILE* _tmp12_;
#line 73 "enchant-lsmod.vala"
				_tmp12_ = stderr;
#line 73 "enchant-lsmod.vala"
				fprintf (_tmp12_, "Error: language tag not specified and no default language set\n");
#line 74 "enchant-lsmod.vala"
				retcode = 1;
#line 344 "enchant-lsmod.c"
			} else {
				EnchantDict* dict = NULL;
				EnchantBroker* _tmp13_;
				const gchar* _tmp14_;
				EnchantDict* _tmp15_;
				EnchantDict* _tmp16_;
#line 76 "enchant-lsmod.vala"
				_tmp13_ = broker;
#line 76 "enchant-lsmod.vala"
				_tmp14_ = lang_tag;
#line 76 "enchant-lsmod.vala"
				_tmp15_ = enchant_broker_request_dict (_tmp13_, _tmp14_);
#line 76 "enchant-lsmod.vala"
				dict = _tmp15_;
#line 77 "enchant-lsmod.vala"
				_tmp16_ = dict;
#line 77 "enchant-lsmod.vala"
				if (_tmp16_ == NULL) {
#line 363 "enchant-lsmod.c"
					FILE* _tmp17_;
					const gchar* _tmp18_;
					gchar* errmsg = NULL;
					EnchantBroker* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					const gchar* _tmp22_;
					FILE* _tmp25_;
#line 78 "enchant-lsmod.vala"
					_tmp17_ = stderr;
#line 78 "enchant-lsmod.vala"
					_tmp18_ = lang_tag;
#line 78 "enchant-lsmod.vala"
					fprintf (_tmp17_, "No dictionary available for '%s'", _tmp18_);
#line 79 "enchant-lsmod.vala"
					_tmp19_ = broker;
#line 79 "enchant-lsmod.vala"
					_tmp20_ = enchant_broker_get_error (_tmp19_);
#line 79 "enchant-lsmod.vala"
					_tmp21_ = g_strdup (_tmp20_);
#line 79 "enchant-lsmod.vala"
					errmsg = _tmp21_;
#line 80 "enchant-lsmod.vala"
					_tmp22_ = errmsg;
#line 80 "enchant-lsmod.vala"
					if (_tmp22_ != NULL) {
#line 390 "enchant-lsmod.c"
						FILE* _tmp23_;
						const gchar* _tmp24_;
#line 81 "enchant-lsmod.vala"
						_tmp23_ = stderr;
#line 81 "enchant-lsmod.vala"
						_tmp24_ = errmsg;
#line 81 "enchant-lsmod.vala"
						fprintf (_tmp23_, ": %s", _tmp24_);
#line 399 "enchant-lsmod.c"
					}
#line 82 "enchant-lsmod.vala"
					_tmp25_ = stderr;
#line 82 "enchant-lsmod.vala"
					fputc ('\n', _tmp25_);
#line 83 "enchant-lsmod.vala"
					retcode = 1;
#line 77 "enchant-lsmod.vala"
					_g_free0 (errmsg);
#line 409 "enchant-lsmod.c"
				} else {
					EnchantDictDescribeFn fn = NULL;
					const gchar* _tmp26_;
					EnchantDict* _tmp27_;
					EnchantDictDescribeFn _tmp28_;
					EnchantDict* _tmp29_;
#line 86 "enchant-lsmod.vala"
					_tmp26_ = args[1];
#line 86 "enchant-lsmod.vala"
					if (g_strcmp0 (_tmp26_, "-lang") == 0) {
#line 87 "enchant-lsmod.vala"
						fn = _describe_dict_enchant_dict_describe_fn;
#line 422 "enchant-lsmod.c"
					} else {
#line 89 "enchant-lsmod.vala"
						fn = _describe_word_chars_enchant_dict_describe_fn;
#line 426 "enchant-lsmod.c"
					}
#line 90 "enchant-lsmod.vala"
					_tmp27_ = dict;
#line 90 "enchant-lsmod.vala"
					_tmp28_ = fn;
#line 90 "enchant-lsmod.vala"
					_tmp29_ = dict;
#line 90 "enchant-lsmod.vala"
					enchant_dict_describe (_tmp27_, _tmp28_, _tmp29_);
#line 436 "enchant-lsmod.c"
				}
			}
		} else {
			gboolean _tmp30_ = FALSE;
			const gchar* _tmp31_;
#line 93 "enchant-lsmod.vala"
			_tmp31_ = args[1];
#line 93 "enchant-lsmod.vala"
			if (g_strcmp0 (_tmp31_, "-h") == 0) {
#line 93 "enchant-lsmod.vala"
				_tmp30_ = TRUE;
#line 448 "enchant-lsmod.c"
			} else {
				const gchar* _tmp32_;
#line 93 "enchant-lsmod.vala"
				_tmp32_ = args[1];
#line 93 "enchant-lsmod.vala"
				_tmp30_ = g_strcmp0 (_tmp32_, "-help") == 0;
#line 455 "enchant-lsmod.c"
			}
#line 93 "enchant-lsmod.vala"
			if (_tmp30_) {
#line 459 "enchant-lsmod.c"
				const gchar* _tmp33_;
#line 94 "enchant-lsmod.vala"
				_tmp33_ = args[0];
#line 94 "enchant-lsmod.vala"
				usage (_tmp33_);
#line 465 "enchant-lsmod.c"
			} else {
				gboolean _tmp34_ = FALSE;
				const gchar* _tmp35_;
#line 95 "enchant-lsmod.vala"
				_tmp35_ = args[1];
#line 95 "enchant-lsmod.vala"
				if (g_strcmp0 (_tmp35_, "-v") == 0) {
#line 95 "enchant-lsmod.vala"
					_tmp34_ = TRUE;
#line 475 "enchant-lsmod.c"
				} else {
					const gchar* _tmp36_;
#line 95 "enchant-lsmod.vala"
					_tmp36_ = args[1];
#line 95 "enchant-lsmod.vala"
					_tmp34_ = g_strcmp0 (_tmp36_, "-version") == 0;
#line 482 "enchant-lsmod.c"
				}
#line 95 "enchant-lsmod.vala"
				if (_tmp34_) {
#line 486 "enchant-lsmod.c"
					FILE* _tmp37_;
					const gchar* _tmp38_;
#line 96 "enchant-lsmod.vala"
					_tmp37_ = stderr;
#line 96 "enchant-lsmod.vala"
					_tmp38_ = args[0];
#line 96 "enchant-lsmod.vala"
					fprintf (_tmp37_, "%s %s\n", _tmp38_, PACKAGE_VERSION);
#line 495 "enchant-lsmod.c"
				} else {
					const gchar* _tmp39_;
#line 97 "enchant-lsmod.vala"
					_tmp39_ = args[1];
#line 97 "enchant-lsmod.vala"
					if (g_strcmp0 (_tmp39_, "-list-dicts") == 0) {
#line 502 "enchant-lsmod.c"
						EnchantBroker* _tmp40_;
#line 98 "enchant-lsmod.vala"
						_tmp40_ = broker;
#line 98 "enchant-lsmod.vala"
						enchant_broker_list_dicts (_tmp40_, _describe_dict_enchant_dict_describe_fn, NULL);
#line 508 "enchant-lsmod.c"
					} else {
						FILE* _tmp41_;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
#line 100 "enchant-lsmod.vala"
						_tmp41_ = stderr;
#line 100 "enchant-lsmod.vala"
						_tmp42_ = args[1];
#line 100 "enchant-lsmod.vala"
						fprintf (_tmp41_, "Invalid argument %s\n", _tmp42_);
#line 101 "enchant-lsmod.vala"
						_tmp43_ = args[0];
#line 101 "enchant-lsmod.vala"
						usage (_tmp43_);
#line 102 "enchant-lsmod.vala"
						retcode = 1;
#line 525 "enchant-lsmod.c"
					}
				}
			}
		}
	} else {
		EnchantBroker* _tmp44_;
#line 105 "enchant-lsmod.vala"
		_tmp44_ = broker;
#line 105 "enchant-lsmod.vala"
		enchant_broker_describe (_tmp44_, _describe_provider_enchant_broker_describe_fn, NULL);
#line 536 "enchant-lsmod.c"
	}
#line 107 "enchant-lsmod.vala"
	result = retcode;
#line 107 "enchant-lsmod.vala"
	_g_free0 (lang_tag);
#line 107 "enchant-lsmod.vala"
	_enchant_broker_free0 (broker);
#line 107 "enchant-lsmod.vala"
	return result;
#line 546 "enchant-lsmod.c"
}

int
main (int argc,
      char ** argv)
{
#line 58 "enchant-lsmod.vala"
	return _vala_main (argv, argc);
#line 555 "enchant-lsmod.c"
}

