# CPack uses `rpm --suggests` to check if rpmbuild supports the "Suggests:" tag.
# This test intentionally uses a different method (build a test .spec) so any
# problems will be caught early if functionality should change in the future.
execute_process(
  COMMAND ${RPMBUILD_EXECUTABLE} --nobuild test_suggests.spec
  ERROR_QUIET
  RESULT_VARIABLE RPMBUILD_SUGGESTS_RESULT)

if(RPMBUILD_SUGGESTS_RESULT EQUAL 0)
  set(should_contain_suggests_tag_ true)
endif()

# Only verify that suggests tag is present only if that tag is supported.
# If it is not supported the rpm package was correctly generated by ignoring
# that tag and that was already checked by expected files test.
if(should_contain_suggests_tag_)
  execute_process(COMMAND ${RPM_EXECUTABLE} -q --suggests -p "${FOUND_FILE_1}"
                  WORKING_DIRECTORY "${CPACK_TEMPORARY_DIRECTORY}"
                  RESULT_VARIABLE rpm_result_
                  OUTPUT_VARIABLE rpm_output_
                  ERROR_VARIABLE error_variable_
                  OUTPUT_STRIP_TRAILING_WHITESPACE)

  if(rpm_result_ OR NOT rpm_output_ STREQUAL "libsuggested")
    message(FATAL_ERROR "RPM_SUGGESTED package error: no suggested packages"
        " (result: '${rpm_result_}'; output: '${rpm_output_}';"
        " error: '${error_variable_}')")
  endif()
endif()
