/*************************************************************************
*  Copyright (C) 2008 by Vincent Richefeu                                *
*  vincent.richefeu@hmg.inpg.fr                                          *
*                                                                        *
*  This program is free software; it is licensed under the terms of the  *
*  GNU General Public License v2 or later. See file LICENSE for details. *
*************************************************************************/

#ifndef COULEURS_H
#define COULEURS_H 1

typedef struct
{
  /* r, v and b range from 0 to 1 */
  float r;
  float v;
  float b;
}
couleur;

int nb_val_couleurs = 63;  
couleur gradc[80];
couleur gradrouge[80];
couleur gradbleu[80];

/* this colors come from Maple V */
couleur gradcol[64] = {
  {0.0, 0.0, 0.5625},
  {0.0, 0.0, 0.6250},
  {0.0, 0.0, 0.6875},
  {0.0, 0.0, 0.7500},
  {0.0, 0.0, 0.8125},
  {0.0, 0.0, 0.8750},
  {0.0, 0.0, 0.9375},
  {0.0, 0.0, 1.0000},
  {0.0, 0.0625, 1.0000},
  {0.0, 0.1250, 1.0000},
  {0.0, 0.1875, 1.0000},
  {0.0, 0.2500, 1.0000},
  {0.0, 0.3125, 1.0000},
  {0.0, 0.3750, 1.0000},
  {0.0, 0.4375, 1.0000},
  {0.0, 0.5000, 1.0000},
  {0.0, 0.5625, 1.0000},
  {0.0, 0.6250, 1.0000},
  {0.0, 0.6875, 1.0000},
  {0.0, 0.7500, 1.0000},
  {0.0, 0.8125, 1.0000},
  {0.0, 0.8750, 1.0000},
  {0.0, 0.9375, 1.0000},
  {0.0, 1.0000, 1.0000},
  {0.0625, 1.0000, 1.0000},
  {0.1250, 1.0000, 0.9375},
  {0.1875, 1.0000, 0.8750},
  {0.2500, 1.0000, 0.8125},
  {0.3125, 1.0000, 0.7500},
  {0.3750, 1.0000, 0.6875},
  {0.4375, 1.0000, 0.6250},
  {0.5000, 1.0000, 0.5625},
  {0.5625, 1.0000, 0.5000},
  {0.6250, 1.0000, 0.4375},
  {0.6875, 1.0000, 0.3750},
  {0.7500, 1.0000, 0.3125},
  {0.8125, 1.0000, 0.2500},
  {0.8750, 1.0000, 0.1875},
  {0.9375, 1.0000, 0.1250},
  {1.0000, 1.0000, 0.0625},
  {1.0000, 1.0000, 0.0},
  {1.0000, 0.9375, 0.0},
  {1.0000, 0.8750, 0.0},
  {1.0000, 0.8125, 0.0},
  {1.0000, 0.7500, 0.0},
  {1.0000, 0.6875, 0.0},
  {1.0000, 0.6250, 0.0},
  {1.0000, 0.5625, 0.0},
  {1.0000, 0.5000, 0.0},
  {1.0000, 0.4375, 0.0},
  {1.0000, 0.3750, 0.0},
  {1.0000, 0.3125, 0.0},
  {1.0000, 0.2500, 0.0},
  {1.0000, 0.1875, 0.0},
  {1.0000, 0.1250, 0.0},
  {1.0000, 0.0625, 0.0},
  {1.0000, 0.0, 0.0},
  {0.9375, 0.0, 0.0},
  {0.8750, 0.0, 0.0},
  {0.8125, 0.0, 0.0},
  {0.7500, 0.0, 0.0},
  {0.6875, 0.0, 0.0},
  {0.6250, 0.0, 0.0},
  {0.5625, 0.0, 0.0}
};

couleur gradmono[64] = {
{1.000, 1.000000, 1.000000},
{0.984, 0.984000, 0.984000},
{0.968, 0.968000, 0.968000},
{0.952, 0.952000, 0.952000},
{0.936, 0.936000, 0.936000},
{0.920, 0.920000, 0.920000},
{0.904, 0.904000, 0.904000},
{0.888, 0.888000, 0.888000},
{0.872, 0.872000, 0.872000},
{0.856, 0.856000, 0.856000},
{0.840, 0.840000, 0.840000},
{0.824, 0.824000, 0.824000},
{0.808, 0.808000, 0.808000},
{0.792, 0.792000, 0.792000},
{0.776, 0.776000, 0.776000},
{0.760, 0.760000, 0.760000},
{0.744, 0.744000, 0.744000},
{0.728, 0.728000, 0.728000},
{0.712, 0.712000, 0.712000},
{0.696, 0.696000, 0.696000},
{0.680, 0.680000, 0.680000},
{0.664, 0.664000, 0.664000},
{0.648000, 0.648000, 0.648000},
{0.632000, 0.632000, 0.632000},
{0.616000, 0.616000, 0.616000},
{0.600000, 0.600000, 0.600000},
{0.584000, 0.584000, 0.584000},
{0.568000, 0.568000, 0.568000},
{0.552000, 0.552000, 0.552000},
{0.536000, 0.536000, 0.536000},
{0.520000, 0.520000, 0.520000},
{0.504000, 0.504000, 0.504000},
{0.488000, 0.488000, 0.488000},
{0.472000, 0.472000, 0.472000},
{0.456000, 0.456000, 0.456000},
{0.440000, 0.440000, 0.440000},
{0.424000, 0.424000, 0.424000},
{0.408000, 0.408000, 0.408000},
{0.392000, 0.392000, 0.392000},
{0.376000, 0.376000, 0.376000},
{0.360000, 0.360000, 0.360000},
{0.344000, 0.344000, 0.344000},
{0.328000, 0.328000, 0.328000},
{0.312000, 0.312000, 0.312000},
{0.296000, 0.296000, 0.296000},
{0.280000, 0.280000, 0.280000},
{0.264000, 0.264000, 0.264000},
{0.248000, 0.248000, 0.248000},
{0.232000, 0.232000, 0.232000},
{0.216000, 0.216000, 0.216000},
{0.200000, 0.200000, 0.200000},
{0.184000, 0.184000, 0.184000},
{0.168000, 0.168000, 0.168000},
{0.152000, 0.152000, 0.152000},
{0.136000, 0.136000, 0.136000},
{0.120000, 0.120000, 0.120000},
{0.104000, 0.104000, 0.104000},
{0.088000, 0.088000, 0.088000},
{0.072000, 0.072000, 0.072000},
{0.056000, 0.056000, 0.056000},
{0.040000, 0.040000, 0.040000},
{0.024000, 0.024000, 0.024000},
{0.008000, 0.008000, 0.008000},
{0.0,0.0,0.0}
};

/* Couleurs predefinies */
couleur mgblanc = { 1.0, 1.0, 1.0 };
couleur mgnoir  = { 0.0, 0.0, 0.0 };
couleur mggris  = { 0.4, 0.5, 0.5 };
couleur mgrouge = { 1.0, 0.157, 0.078 };
couleur mgvert  = { 0.251, 1.0, 0.463 };
couleur mgbleu  = { 0.1, 0.1, 0.5 };
couleur mgjaune = { 1.0, 1.0, 0.5 };
couleur mgfun   = { 1.0, 1.0, 1.0 }; /* modifiable par l'utilisateur */ 

/* 1 couleur de fond et 3 couleurs de dessin */
couleur bg_color, fg_color, fg_color1, fg_color2;

/* Couleurs pour les valeurs MAX(rouge) et MIN(bleu) */
float valc_rouge = 1.0, valc_bleu = -1.0;



/* Coloration de groupe de grains */
MGuchar nbcolgrp=0;
MGuchar nbcolgrpMaxi = 10;
MGuchar colIsShown[10] = {0,0,0,0,0,0,0,0,0,0};
char colorName[10][30];

float rcolor[10]={0., 0., 1., 1., 0., 1., 0.67 , 1.,  0.53, 0.8};
float gcolor[10]={0., 1., 0., 1., 1., 0., 0.41 , 0.62, 0.5 , 0.8};
float bcolor[10]={1., 0., 0., 0., 1., 1., 0.95, 0.1,  0.1 , 0.8};


#endif

