;;; xlib-xinerama.el --- Xinerama support.

;; Copyright (C) 2003-2005 by XWEM Org.

;; Author: Zajcev Evgeny <zevlg@yandex.ru>
;; Created: Mon Nov 17 19:23:03 MSK 2003
;; Keywords: xlib, xwem
;; X-CVS: $Id: xlib-xinerama.el,v 1.4 2004/11/29 19:48:19 lg Exp $

;; This file is part of XWEM.

;; XWEM is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XWEM is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;; XInerama support.

;;; Code:

(require 'xlib-xlib)

(defconst X-XInerama-major 1)
(defconst X-XInerama-minor 1)

(defconst X-XInerama-op-QueryVersion	0)
(defconst X-XInerama-op-GetState	1)
(defconst X-XInerama-op-GetScreenCount	2)
(defconst X-XInerama-op-GetScreenSize	3)

(defconst X-XInerama-op-IsActive	4)
(defconst X-XInerama-op-QueryScreens	5)

(defun X-XIneramaQueryVersion (xdpy &optional major minor)
  "On display XDPY query for version of XInerama extension."
  (X-Dpy-p xdpy 'X-XIneramaQueryVersion)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XINERAMA"))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XInerama-op-QueryVersion]
		[2 2]			; length

		[2 (or major X-XInerama-major)]
		[2 (or minor X-XInerama-minor)]))
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]		;success field
		nil
		(list [1 nil]		;not used
		      [2 integerp]	;sequence number
		      [4 nil]		;length
		      [2 integerp]	;major version
		      [2 integerp]	;minor version
		      [20 nil]))))	;pad
    (and (car xin-ext)
         (X-Dpy-send-read xdpy msg ReceiveFields))))

(defun X-XIneramaGetState (xdpy d)
  "Get state of drawable D."
  (X-Dpy-p xdpy 'X-XIneramaGetState)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XINERAMA" 'X-XIneramaGetState))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XInerama-op-GetState]
		[2 2]			; length
		[4 (X-Drawable-id d)]))
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]
		nil
		(list [1 integerp]	; state
		      [2 nil]		; sequence number
		      [4 nil]		; length
		      [4 integerp]
		      [20 nil])))
	 (r (X-Dpy-send-read xdpy msg ReceiveFields)))
    r))

(defun X-XIneramaGetScreenCount (xdpy d)
  "Get screen count."
  (X-Dpy-p xdpy 'X-XIneramaGetScreenCount)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XINERAMA" 'X-XIneramaGetScreenCount))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XInerama-op-GetScreenCount]
		[2 2]			; length
		[4 (X-Drawable-id d)]))
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]
		nil
		(list [1 integerp]	; screen count
		      [2 nil]		; sequence number
		      [4 nil]		; length
		      [4 integerp]
		      [20 nil])))
	 (r (X-Dpy-send-read xdpy msg ReceiveFields)))
    r))

(defun X-XIneramaGetScreenSize (xdpy d scr)
  "Get screens sizes."
  (X-Dpy-p xdpy 'X-XIneramaGetScreenSize)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XINERAMA" 'X-XIneramaGetScreenSize))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XInerama-op-GetScreenSize]
		[2 3]			; length
		[4 (X-Drawable-id d)]
		[4 scr]))
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]
		nil
		(list [1 nil]		; unused
		      [2 nil]		; sequence number
		      [4 nil]		; length
		      [4 integerp]	; width
		      [4 integerp]	; height
		      [4 integerp]	; window
		      [4 integerp]	; screen
		      [8 nil])))
	 (r (X-Dpy-send-read xdpy msg ReceiveFields)))
    r))

;;; Alternative protocol

(defun X-XIneramaIsActive (xdpy)
  "Return non-nil if XINERAMA is active."
  (X-Dpy-p xdpy 'X-XIneramaIsActive)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XINERAMA" 'X-XIneramaIsActive))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XInerama-op-IsActive]
		[2 1]			; length
		))
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]
		nil
		(list [1 nil]		; unused
		      [2 nil]		; sequence
		      [4 nil]		; length
		      [4 integerp]	; state
		      [20 nil])))
	 (r (X-Dpy-send-read xdpy msg ReceiveFields)))
    (and (car r) (nth 1 r))))

(defun X-XIneramaQueryScreens (xdpy)
  "On display XDPY query for XINERAMA screens."
  (X-Dpy-p xdpy 'X-XIneramaIsActive)

  (let* ((xin-ext (X-Dpy-get-extension xdpy "XINERAMA"))
	 (ListOfFields
	  (list (vector 1 (nth 4 xin-ext)) ; opcode
		[1 X-XInerama-op-QueryScreens]
		[2 1]			; length
		))
	 (msg (X-Create-message ListOfFields))
	 (ReceiveFields
	  (list [1 success]
		nil
		(list [1 nil]		; unused
		      [2 nil]		; sequence
		      [4 nil]		; length
		      [4 length-1]	; number
		      [20 nil]
		      [(* 8 length-1) :X-Rect]))))
    (and (car xin-ext)
         (X-Dpy-send-read xdpy msg ReceiveFields))))


(provide 'xlib-xinerama)

;;; xlib-xinerama.el ends here
