/*
 * lexer.l
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

%{
#include <stdlib.h>
#include <string.h>
#include "stdafx.h"

#include "Element.h"
#include "EventIn.h"
#include "EventOut.h"
#include "ExposedField.h"
#include "Field.h"
#include "FieldValue.h"
#include "Node.h"
#include "Scene.h"

#include "SFBool.h"
#include "SFNode.h"
#include "MFNode.h"
#include "SFString.h"

#include "parser.h"
#include "y.tab.h"

#define YY_NEVER_INTERACTIVE 1

#ifdef HAVE_LIBZ
# define YY_INPUT(buf, result, max_size) \
	{ result = gzread( inputFile , buf, max_size ); }
#else
# define YY_INPUT(buf, result, max_size) \
	{ result = fread( buf, 1, max_size, inputFile ); }
#endif

#if defined(__sgi) && !defined(__GNUC__)
#pragma set woff 1110
#endif

long hexint;
int protoFlag=false;
int protoNested=0;
void startProto(void)
   {
   protoFlag=true;
   scene->addProtoDefinition();
   protoNested++;
   }
void toProto(char* string)
   {
   if (protoFlag)
      scene->addToProtoDefinition(string);
   }
void stopProto(void)
   {
   if (protoNested--==1)
      protoFlag=false;
   }
void toComment(char* string)
   {
   if (!protoFlag)
      addToCurrentComment(string);
   }


%}

IDFIRSTCHAR	[^ \r\n\t'\"#,\.\[\]\\\{\}0-9\+\-]
IDRESTCHARS	[^ \r\n\t'\"#,\.\[\]\\\{\}]

EXPONENT	([Ee]("-"|"+")?[0-9]+)

%%

\{                              {
                                toProto(yytext); 
                                nodeComment();
                                return WING_BRACKET_ON;
                                }

\}                              {
                                toProto(yytext); 
                                insideNodeComment();
                                return WING_BRACKET_OFF;
                                }

\[                              {
                                toProto(yytext); 
                                MFComment();
                                return BRACKET_ON;
                                }

\]                              {
                                toProto(yytext); 
                                insideMFComment();
                                return BRACKET_OFF;
                                }

("-"|"+")?([0-9]+"."[0-9]*|[0-9]*"."[0-9]+){EXPONENT}? {
                                                       toProto(yytext); 
                                                       yylval.sffloat = 
                                                          (float) atof(yytext); 
                                                       return FLOAT; 
                                                       }

("-"|"+")?[0-9]+{EXPONENT}	{
                                toProto(yytext); 
                                yylval.sffloat = (float) atof(yytext); 
                                return FLOAT; 
                                }

("-"|"+")?[0-9]+		{
                                toProto(yytext); 
                                yylval.int32 = atoi(yytext); 
                                return INT; 
                                }

("-"|"+")?0x[0-9a-fA-F]+	{ 
                                toProto(yytext); 
                                sscanf(yytext, "%x", &hexint);
                                yylval.int32 = (int) hexint;
                                return INT; 
                                }

Script		{ toProto(yytext); return SCRIPT; }

DEF		{ toProto(yytext); return DEF; }

EXTERNPROTO	{ startProto(); toProto(yytext); return EXTERNPROTO; }

FALSE		{ toProto(yytext); return FALSE_TOK; }

IS		{ toProto(yytext); return IS; }

NULL		{ toProto(yytext); return NULL_TOK; }

PROTO		{ startProto(); toProto(yytext); return PROTO; }

ROUTE		{ toProto(yytext); return ROUTE; }

TO		{ toProto(yytext); return TO; }

TRUE		{ toProto(yytext); return TRUE_TOK; }

USE		{ toProto(yytext); return USE; }

eventIn		{ toProto(yytext); return EVENT_IN; }

eventOut	{ toProto(yytext); return EVENT_OUT; }

exposedField	{ toProto(yytext); return EXPOSED_FIELD; }

field		{ toProto(yytext); return FIELD; }

{IDFIRSTCHAR}{IDRESTCHARS}*	{
                                toProto(yytext); 
		                yylval.id = scene->addSymbol(yytext); 
                                return ID;
		                }

\"([^\"]|\\\"|\\\\)*\"	{
                        toProto(yytext); 
		        for (const char *s = yytext; *s; s++) {
		        if (*s == '\n') lineno++;
		        }
		        yytext[strlen(yytext)-1] = '\0';
		        yylval.id = scene->addSymbol(yytext+1);
		        return STRING;
		        }

\n"#"[^\n]*	        {
                        toProto(yytext); 
                        toComment(yytext);
                        /* eat up comments */
                        }

^"#"VRML" "V1"."0[^\n]*	{
                        return VRML1;
                        }

"#"[^\n]*	        {
                        toProto(yytext); 
                        toComment(yytext);
                        /* eat up comments */
                        }

[ \t\r,]+	        {
                        toProto(yytext); 
                        /* eat up whitespace and commas */
                        }

\n		        { 
                        toProto(yytext); 
                        lineno++; 
                        }

.		        {
                        toProto(yytext);  
                        return yytext[0]; 
                        }

%%
