/*
 * SFNode.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"
#include "DuneApp.h"

#include "SFNode.h"
#include "Node.h"

SFNode::SFNode(Node *value)
{
    _value = value;
    if (_value) _value->ref();
}

SFNode::SFNode(const SFNode &other)
{
    if (other._value) {
	_value = other._value->copy();
	_value->ref();
        _value->reInit();
    } else {
	_value = NULL;
    }
}

SFNode::~SFNode()
{
    if (_value) _value->unref();
}

int SFNode::write(int f, int indent) const
{
    if (_value) {
	return _value->write(f, indent);
    } else {        
	RET_ONERROR( mywritestr(f, "NULL\n") )
        TheApp->incSelectionLinenumber();
    }
    return 0;
}

/* not implemented yet
int
SFNode::writeCC(int f, char* variableName) const
{
    if (_value) {
	return _value->writeCC(f, variableName);
    }
}
*/

bool
SFNode::equals(const FieldValue *value) const
{
    return value->getType() == SFNODE && ((SFNode *) value)->getValue() == _value;
}

FieldValue *
SFNode::addNode(Node *node) const
{
    assert(_value == NULL);
    return new SFNode(node);
}

FieldValue *
SFNode::removeNode(Node *node) const
{
    assert(_value == node);
    return new SFNode(NULL);
}

MyString
SFNode::getEcmaScriptComment(MyString name, int flags) const
{
    const char *indent = ((FieldValue *)this)->getEcmaScriptIndent(flags);
    MyString ret;
    ret = "";
    if (TheApp->GetEcmaScriptAddAllowedValues()) {
        ret += indent;
        ret += "// allowed values:\n";

        ret += indent;
        ret += "   // a VRML node object\n";
    }
    if (TheApp->GetEcmaScriptAddAllowedComponents()) {
        ret += indent;
        ret += "// allowed components:\n";

        ret += indent;
        ret += "   // depends from type of node: ";
        ret += name;
        ret += ".eventin_of_node or ";
        ret += name;
        ret += ".eventout_of_node\n";
    }
    if (TheApp->GetEcmaScriptAddAvailableFunctions()) {
        ret += indent;
        ret += "// available functions:\n";
        if (flags != EL_EVENT_IN) {
            ret += indent;
            ret += "   // ";
            ret += name;
            ret += " = new SFNode(string_vrmlstring);\n";
        }
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "   // string_str = ";
            ret += name;
            ret += ".toString();\n";
        }
    }
    if (TheApp->GetEcmaScriptAddBrowserObject()) {
        if (flags != EL_EVENT_OUT) {
            ret += indent;
            ret += "// related Browser Object functions:\n";

            ret += indent;
            ret += "   // Browser.addRoute(";
            ret += name;
            ret += ", string_fromEventOut, sfnode_toNode, string_toEventIn);\n";

            ret += indent;
            ret += "   // Browser.deleteRoute(";
            ret += name;
            ret += ", string_fromEventOut, sfnode_toNode, string_toEventIn);\n";
        }
    }
    if (TheApp->GetEcmaScriptAddExampleUsage()) {
        ret += indent;
        ret += "// example usage:\n";
        if (flags != EL_EVENT_IN) {
             ret += indent;
             ret += "   // ";
             ret += name;
             ret += "= new SFNode('Shape {geometry Text {string \\\"A\\\"}}');\n";

             ret += indent;
             ret += "   // ";
             ret += name;
             ret += ".geometry.string = 'hello';\n";
        } 
        if (flags != EL_EVENT_OUT) {
             ret += indent;
             ret += "   // string_str =";
             ret += name;
             ret += ".toString();\n";
        }
    }
    return ret;
}
