/*
 * NodeNavigationInfo.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeNavigationInfo.h"
#include "Scene.h"
#include "Proto.h"
#include "FieldValue.h"
#include "MFFloat.h"
#include "SFBool.h"
#include "SFFloat.h"
#include "MFString.h"
#include "SFString.h"
#include "Node.h"


ProtoNavigationInfo::ProtoNavigationInfo(Scene *scene)
  : Proto(scene, "NavigationInfo")
{
    addEventIn(SFBOOL, "set_bind");
    float		values[] = { 0.25f, 1.6f, 0.75f };
    float	       *v = new float[3];  memcpy(v, values, 3 * sizeof(float));
    avatarSize.set(
          addExposedField(MFFLOAT, "avatarSize", new MFFloat(v, 3), 
          new SFFloat(0.0f)));
    headlight.set(
          addExposedField(SFBOOL, "headlight", new SFBool(true)));
    speed.set(
          addExposedField(SFFLOAT, "speed", new SFFloat(1.0f), 
                          new SFFloat(0.0f)));
    static const char *types[] = { "ANY", "WALK", "EXAMINE", "FLY", "NONE", 
                                   NULL};
    StringArray *defaulttypes = new StringArray();
    defaulttypes->append("WALK");
    defaulttypes->append("ANY");
    type.set(
          addExposedField(MFSTRING, "type", new MFString(defaulttypes), 0, 
                          types));
    visibilityLimit.set(
          addExposedField(SFFLOAT, "visibilityLimit", new SFFloat(0.0f), 
                          new SFFloat(0.0f)));
    addEventOut(SFBOOL, "isBound");
}

Node *
ProtoNavigationInfo::create(Scene *scene)
{ 
    return new NodeNavigationInfo(scene, this); 
}

NodeNavigationInfo::NodeNavigationInfo(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

void
NodeNavigationInfo::preDraw()
{
    _scene->setHeadlight(headlight()->getValue());
}
