import pygame
import os

from pygame.locals import *

from locals import *

import data

from util import Util, Score, render_text, bool_to_str
from variables import Variables
from level import Level

from sound import play_sound

class Menu:

  def __init__(self, screen, score = None, world = None, bgscreen = None, time = None, levels = None):
    self.bgscreen = bgscreen
    if self.bgscreen == None:
      self.bgscreen = Util.blackscreen
    self.screen = screen
    self.score = score
    self.time = time
    self.levels = levels
    self.world = world
    return

  def run(self, menu_choice = 0):
    done = False

    clock = pygame.time.Clock()
    
    self.screen.blit(self.bgscreen, (0, 0))      #Renders the menu background, usually the faded out game display
                                                 #Or a black screen

    menu_items = ["Quit", "Sound: " + bool_to_str(Variables.vdict["sound"]), "Dialogue: " + bool_to_str(Variables.vdict["dialogue"]), "Choose world: " + str(self.world.number)]

    count = 0



    while (count <= Variables.vdict["unlocked" + self.world.name] and count < self.world.level_count):
      menu_items.append("Play level " + str(count + 1))
      count += 1

    #Hi score and best time text on the screen
    
    if self.score != None:
      score_text = "Your final score: %s" % str(self.score)
      if self.levels == self.world.level_count:
        time_text = "Your final time: %s frames" % str(self.time)
      else:
        time_text = "Didn't pass all levels"

      if self.score > Variables.vdict["hiscore" + self.world.name]:
        score_text += " - NEW HIGH SCORE!"
        Variables.vdict["hiscore" + self.world.name] = self.score
      else:
        score_text += " - High score: %s" % Variables.vdict["hiscore" + self.world.name]

      if (self.time < Variables.vdict["besttime" + self.world.name] or Variables.vdict["besttime" + self.world.name] == 0) and (self.levels == self.world.level_count):
        time_text += " - NEW BEST TIME!"
        Variables.vdict["besttime" + self.world.name] = self.time
      elif Variables.vdict["besttime" + self.world.name] == 0:
        time_text += " - Best time: no best time"
      else:
        time_text += " - Best time: %s frames" % Variables.vdict["besttime" + self.world.name]
    else:
      score_text = "High score: %s" % Variables.vdict["hiscore" + self.world.name]
      if Variables.vdict["besttime" + self.world.name] == 0:
        time_text = "Best time: no best time"
      else:
        time_text = "Best time: %s frames" % Variables.vdict["besttime" + self.world.name]


    menu_image = render_text("World " + str(self.world.number) + ": " + self.world.name, COLOR_GUI)
    rect = menu_image.get_rect()
    rect.centerx = SCREEN_WIDTH / 2
    rect.top = GUI_MENU_TOP - 75
    self.screen.blit(menu_image, rect)

    menu_image = render_text(score_text, COLOR_GUI)
    rect = menu_image.get_rect()
    rect.centerx = SCREEN_WIDTH / 2
    rect.top = GUI_MENU_TOP - 50
    self.screen.blit(menu_image, rect)

    menu_image = render_text(time_text, COLOR_GUI)
    rect = menu_image.get_rect()
    rect.centerx = SCREEN_WIDTH / 2
    rect.top = GUI_MENU_TOP - 30
    self.screen.blit(menu_image, rect)

    while not done:

      # Pygame event and keyboard input processing
      for event in pygame.event.get():
        if event.type == QUIT or (event.type == KEYDOWN and event.key == K_ESCAPE):
          menu_choice = MENU_QUIT
          done = True
        elif (event.type == KEYDOWN and event.key == K_DOWN) or (event.type == JOYAXISMOTION and event.axis == 1 and event.value > 0.7):
          if menu_choice + MENU_OFFSET + 1 < len(menu_items):
            menu_choice += 1
            play_sound("click")
        elif (event.type == KEYDOWN and event.key == K_UP) or (event.type == JOYAXISMOTION and event.axis == 1 and event.value < -0.7):
          if menu_choice + MENU_OFFSET > 0:
            menu_choice -= 1
            play_sound("click")
        elif (event.type == KEYDOWN and (event.key == K_z or event.key == K_SPACE or event.key == K_RETURN)) or (event.type == JOYBUTTONDOWN and (event.button == 0 or event.button == 1)):
          done = True

      #Menu rendering


      if len(menu_items) < MENU_MAX_VISIBLE:
        menu_offset =  -(len(menu_items) - 5) * 10
      else:
        menu_offset =  -(MENU_MAX_VISIBLE - 5) * 10

      menu_bg = pygame.image.load(data.picpath("menu", "bg")).convert_alpha()
      rect = menu_bg.get_rect()
      rect.centerx = SCREEN_WIDTH / 2
      rect.top = GUI_MENU_TOP
      self.screen.blit(menu_bg, rect)

      menu_head = render_text("Which way is up?")
      rect = menu_head.get_rect()
      rect.centerx = SCREEN_WIDTH / 2
      rect.top = GUI_MENU_TOP + 50 + menu_offset
      self.screen.blit(menu_head, rect)

      #If the menu choice is greater than the second last menu item on screen,
      #the menu must be scrolled (menu_choice indexing starts from -MENU_OFFSET):
      if menu_choice > (MENU_MAX_VISIBLE - MENU_OFFSET - 1):
        current_menu_index = menu_choice - MENU_MAX_VISIBLE
        if (menu_choice + MENU_OFFSET + 1) < len(menu_items):
          current_menu_index += 1
      else:
        current_menu_index = -MENU_OFFSET

      menu_visible = 0

      menu_rendered = False

      while (not menu_rendered):
        m = menu_items[current_menu_index + MENU_OFFSET]
        if (menu_choice == current_menu_index):
          menu_image = render_text(m, COLOR_GUI_HILIGHT, COLOR_GUI_DARK)
        else:
          menu_image = render_text(m, COLOR_GUI)
        rect = menu_image.get_rect()
        rect.centerx = SCREEN_WIDTH / 2
        rect.top = GUI_MENU_TOP + 60 + (menu_visible + 1) * 20 + menu_offset
        self.screen.blit(menu_image, rect)
        current_menu_index += 1
        menu_visible += 1
        if menu_visible > MENU_MAX_VISIBLE or (current_menu_index + MENU_OFFSET) == len(menu_items):
          menu_rendered = True

      #Display, clock

      pygame.display.flip()

      clock.tick(FPS)

    return menu_choice
