/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef SEPARATORCOMBOBOX_H
#define SEPARATORCOMBOBOX_H

#include <QComboBox>

namespace WebIssues
{

/**
* A combo box with separators between items.
*/
class SeparatorComboBox : public QComboBox
{
    Q_OBJECT
public:
    /**
    * Conctructor.
    *
    * @param parent The parent widget.
    */
    SeparatorComboBox( QWidget* parent );

    /**
    * Destructor.
    */
    ~SeparatorComboBox();

public:
    /**
    * Add a separator to the end of the list of existing items.
    */
    void addSeparator();

public: // overrides
    void showPopup();

    bool eventFilter( QObject* watched, QEvent* e );
};

}

#endif
