include( ../config.pri )

TEMPLATE = app
TARGET   = webissues

CONFIG  += qt
QT      += network xml

HEADERS += application.h \
           configdata.h \
           connectionmanager.h \
           dotnetstyle.h \
           iconloader.h \
           mainwindow.h \
           viewerwindow.h \
           viewmanager.h

SOURCES += application.cpp \
           configdata.cpp \
           connectionmanager.cpp \
           iconloader.cpp \
           main.cpp \
           mainwindow.cpp \
           viewerwindow.cpp \
           viewmanager.cpp

win32 {
    SOURCES += dotnetstyle.cpp
}

include( attributes/attributes.pri )
include( commands/commands.pri )
include( data/data.pri )
include( data/rdb/rdb.pri )
include( dialogs/dialogs.pri )
include( icons/icons.pri )
include( models/models.pri )
include( resources/resources.pri )
include( views/views.pri )
include( widgets/widgets.pri )
include( xmlui/xmlui.pri )

INCLUDEPATH += .

PRECOMPILED_HEADER = precompiled.h

TRANSLATIONS += \
           ../translations/webissues_untranslated.ts \
           ../translations/webissues_es.ts \
           ../translations/webissues_pl.ts \
           ../translations/webissues_ru.ts

win32 {
    RC_FILE = webissues.rc
    LIBS += -lshell32
}

win32-msvc*:CONFIG -= flat

CONFIG( debug, debug|release ) {
    DESTDIR = ../debug
    MOC_DIR = debug
    OBJECTS_DIR = debug
    RCC_DIR = debug
} else {
    DESTDIR = ../release
    MOC_DIR = release
    OBJECTS_DIR = release
    RCC_DIR = release
}

target.path = $$PREFIX/bin
INSTALLS += target

unix {
    desktop.files = webissues.desktop
    desktop.path = $$PREFIX/share/applications
    INSTALLS += desktop

    ICON_SIZES = 16 22 32 48
    for( size, ICON_SIZES ) {
        path = $$PREFIX/share/icons/hicolor/$${size}x$${size}/apps
        file = $(INSTALL_ROOT)$$path/webissues.png
        eval( icon-$${size}.path = $$path )
        eval( icon-$${size}.commands = -$(INSTALL_FILE) $$IN_PWD/icons/webissues-$${size}.png $$file )
        eval( icon-$${size}.uninstall = -$(DEL_FILE) $$file )
        INSTALLS += icon-$${size}
    }
}
