/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "htmlwatchwriter.h"

#include <QTextBrowser>
#include <QUrl>

#include "linklocator.h"

using namespace WebIssues;

HTMLWatchWriter::HTMLWatchWriter( QTextBrowser* browser ) :
    m_browser( browser )
{
}

HTMLWatchWriter::~HTMLWatchWriter()
{
}

void HTMLWatchWriter::begin()
{
    m_html += "<html><body><table width=\"100%\" cellpadding=\"3\" cellspacing=\"5\">";
}

void HTMLWatchWriter::end()
{
    m_html += "</table></body></html>";

    m_browser->setHtml( m_html );
}

void HTMLWatchWriter::writeProjectHeader( const QString& name )
{
    m_html += "<tr><th colspan=\"4\" bgcolor=\"#cccccc\">" + name + "</th></tr>";
}

void HTMLWatchWriter::writeFolderHeader( const QString& name )
{
    m_html += "<tr><td colspan=\"4\" bgcolor=\"#dddddd\">" + name + "</td></tr>";
}

void HTMLWatchWriter::writeWatchRow( const QString& linkCell, const QString& totalCell, const QString& newCell, const QString& updatedCell )
{
    m_html += "<tr>" + linkCell + totalCell + newCell + updatedCell + "</tr>";
}

QString HTMLWatchWriter::name( const QString& text )
{
    return "<strong>" + LinkLocator::escape( text ) + "</strong>";
}

QString HTMLWatchWriter::linkCell( int folderId, const QString& watch, const QString& name )
{
    QString encoded = QUrl::toPercentEncoding( watch );
    QString url = QString( "watch://%1/%2" ).arg( folderId ).arg( encoded );

    return QString( "<td width=\"40%\" bgcolor=\"#eeeeee\"><a href=\"%1\">%2</a></td>" ).arg( url, LinkLocator::escape( name ) );
}

QString HTMLWatchWriter::watchCell( const QString& text, WatchState state, int count )
{
    QString color;
    if ( state == WatchUpdated && count > 0 )
        color = "#99ff99";
    else if ( state == WatchNew && count > 0 )
        color = "#ffff88";
    else
        color = "#eeeeee";

    return QString( "<td width=\"20%\" bgcolor=\"%1\">%2: %3</td>" ).arg( color, text ).arg( count );
}
